/* Description and history of csm_stack_p.h at the end of the file.           */
#ifndef CSM_STACK_P_HEADER
#define CSM_STACK_P_HEADER

/*******************************************************************************
 * defines/feature switches and macros (scope: global)
 ******************************************************************************/
#define CSM_C_F_OFF      0x00       /* Feature switched off */
#define CSM_C_F_ON       0x01       /* Feature switched on  */
#define CSM_C_F_VARIABLE 0x02       /* Feature switch is a variable and on/off is read from an ini-file  */

#if (defined TSI)
  #define CSM_M_ROM_TABLE           /* Have to be RAM variables for TSI */
  #define CSM_ROM_VAR               /*   (ditto)                        */
  #define CSM_EXTERN_CONST          /*   (ditto)                        */
#else
  #define CSM_M_ROM_TABLE   const
  #define CSM_ROM_VAR       extern const  /* Constant variables stored in ROM area */
  #define CSM_EXTERN_CONST  extern const  /* All global const vars should be "extern" (-> C++!) */
#endif


/*******************************************************************************
 * Fundamental switches: Operating system and environment
 ******************************************************************************/

/* TSI / WINDOWS environment */
#if (defined TSI)
  #if !defined (_WINDOWS)
    #define _WINDOWS
  #endif
  #define CSM_S_WINDOWS_DLL   CSM_C_F_ON  /**<  \fs  Generation of Windows DLL (TSI only) */
#else
  #define CSM_S_WINDOWS_DLL   CSM_C_F_OFF /**<  \fs  Generation of Windows DLL (TSI only) */
#endif

/*************  General feature switches  *************************************/
/** \fs Debug features on/off. */
#define CSM_S_DEBUG               CSM_C_F_OFF

/** \fs Trace features on/off. */
#define CSM_S_TRACE               CSM_C_F_ON
/** \fs Verbose utility for signal TRACE available/not available. */
#define CSM_S_TRACE_LIMITED_SIGNAL CSM_C_F_OFF
/** \fs ETG Trace features on/off. */
#define CSM_S_TRACE_ETG            CSM_C_F_ON

/** \fs Enable/disable "static" keyword for functions and variables (e.g. for testing). */
#define CSM_S_USE_STATIC          CSM_C_F_ON

/** \fs Usage of ANSI (unsigned int)/ non-ANSI bit fields */
#define CSM_S_ANSI_BITFIELDS      CSM_C_F_OFF

/** \fs Dynamic or fixed (configured) timers */
#define CSM_S_REQUESTABLE_TIMER   CSM_C_F_OFF

/** \fs By application dynamically initialized or fixed (configured in csm_stack_mp.h) callback routines */
#define CSM_S_CALLBACK_INIT_BY_APPLICATION CSM_C_F_ON

/** \fs Add the pvHandle from CSM_lApplCallbackInit() to callback routines.
    This is used to handle the process border jump (e.g. TENGINE subsystem). */
#define CSM_S_USE_CALLBACK_WITH_HANDLE CSM_C_F_ON

/** \fs Using of bus wake temp feature */
#define CSM_S_BUS_WAKE_TEMP   CSM_C_F_OFF

/** \fs Feature switch is used only to control doxygen documentation. \n
   Need to be set to off. Do not change here but in project dependent doxygen
   configuration file. */
#define CSM_S_DOXYGEN_HIDE_NON_API_FCT  CSM_C_F_OFF

/** \fs Function CSM_vRxOverrunOccured() available to indicate an overrun in a
   Rx register or a queue */
#define CSM_S_RX_OVERRUN_INDICATION     CSM_C_F_OFF

/** \fs Reduced error interface/macro which uses only the error grade  */
#define CSM_S_REDUCED_ERROR_INTERFACE CSM_C_F_OFF
/** \fs Error macro calls the function CSM_lExceptionHandler() */
#define CSM_S_EXCEPTION_HANDLER_ACTIVATED CSM_C_F_OFF
#if (CSM_S_REDUCED_ERROR_INTERFACE == CSM_C_F_ON) && (CSM_S_EXCEPTION_HANDLER_ACTIVATED == CSM_C_F_ON)
  #error "Either CSM_S_REDUCED_ERROR_INTERFACE or CSM_S_EXCEPTION_HANDLER_ACTIVATED can be defined."
#endif

/** \fs Cyclic CSM_C_DOWNSTREAM_CYCLETIME ms task is available to call
    CSM_vCyclicTask() on downstream task level. \n
    CSM_vCyclicTask() has to be implemented project specific, the cyclic timer (task)
    in csm_stack_"ENV".c */
#define CSM_S_CYCLIC_TASK   CSM_C_F_OFF

/** \fs Use CSM state maschine */
#define CSM_S_STATE_MASCHINE   CSM_C_F_ON

/** \fs Function calls in nucleus up- and downstream tasks are available to use
    project specific nucleus events */
#define CSM_S_USE_PROJECTSPECIFIC_NU_EVENTS           CSM_C_F_OFF

/** \fs Using of minimum bus wake up feature */
#define CSM_S_BUS_WAKE_MIN                            CSM_C_F_OFF

/** \fs If switch is on, then the Get/Set/ResetTaskContext functions() are
 *  available in csm_stack_tengine.c and the application calback structs contains
 *  a tCSM_TASK_INFO element. This is not necessary if OSAL message buffers are
 *  used for the Access Layer and if callback function calls whithin kernel do
 *  not need a task context switch. If this feature will be used then the
 *  implementation has to be checked. The function bCheckCallBackExecute() in
 *  osaltime.cpp can be used as excample. In addition to the task id it can be
 *  necessary to save the task resource id. */
#define CSM_S_USE_TKSE                                CSM_C_F_OFF

/** \fs Using of Paramount DMB feature */
#define CSM_S_ADDITIONAL_DMB_PRINTFS                  CSM_C_F_OFF

/** \fs Using of critical low voltage handling */
#define CSM_S_CRITICAL_LOW_VOLTAGE                    CSM_C_F_OFF

/** \fs Using of project specific TTFIS commands */
#define CSM_S_PROJ_SPECIFIC_TRACECALLBACK             CSM_C_F_OFF

/** \fs Using of OSAL interface */
#define CSM_S_OSAL_USAGE                              CSM_C_F_OFF

/** \fs Using of tengine OS environment */
#define CSM_S_TENGINE_OS_ENVIRONMENT                  CSM_C_F_OFF

/*************  CAN Stack Manager feature switches  ***************************/

/**
 * \defgroup  CSM        CSM (CAN Stack Manager)
 *            This group contains all files belonging to CAN Stack Manager (CSM)
 *//**
 * \defgroup  CSM_IF     CSM Interfaces
 *            This group contains all files containing external and internal CSM interfaces
 * \ingroup   CSM
 *//**
 * \defgroup  CSM_STACK  CSM Stack
 *            This group contains all CSM files belonging to the stack (csm_stack*.*)
 * \ingroup   CSM
 *//**
 * \defgroup  CSM_APPL   CSM Application adaption
 *            This group contains all CSM files belonging to application specific part
 * \ingroup   CSM
*/

/** \fs Indicates whether the CSM is to be compiled as a proxy or as a manager.*/
#define CSM_S_REMOTE_STACK                     CSM_C_F_ON

/** \fs Route the global wakup reason via CSM and not directy to PWR_viWakeup
 * OFF => CSM_viWakeupCANx are not available */
#define CSM_S_CAN_WAKEUP_FUNCTIONS_VIA_CSM     CSM_C_F_ON

/** \fs Allow PWR to poll CAN wakeup line via CSM */
#define CSM_S_CAN_WAKEUP_POLLING_FCT_AVAILABLE CSM_C_F_ON

/** \fs Allow PWR to block uptream task via CSM_vIndData(CSM_DATA_MAIN_TASK_INACTIVE_IND)*/
#define CSM_S_BLOCKABLE_UPSTREAM_TASK          CSM_C_F_ON

/** \fs Indicate bus error to application from downstream task  */
#define CSM_S_ENABLE_INDICATE_BUSERROR            CSM_C_F_OFF

/** \fs indicate static initialisation error to application */
#define CSM_S_ENABLE_INDICATE_STATIC_ERROR     CSM_C_F_OFF

/** \fs Indicate busoff to application on Busoff entry from downstream task  */
#define CSM_S_INDICATE_BUSOFF_TO_APPLICATION      CSM_C_F_OFF

/** \fs CSM is able to manage variants (e.g. for CBR)  */
#define CSM_S_VARIANTS_MANAGEMENT          CSM_C_F_ON
/** \fs SLOT based configuration on/off. */
// A slot is an entire set of configuration tables belonging together to simply configure different parts of the CSM with one single value.
#define CSM_S_SLOT_BASED_CONFIG                CSM_C_F_ON

/** \fs CSM is controlled by local stack control */
#define CSM_S_CSM_LOCAL_CTRL CSM_C_F_ON
#if (CSM_S_CSM_LOCAL_CTRL == CSM_C_F_ON)
  /**< \fs Local stack control user function enabled */
  #define CSM_S_CSM_LOCAL_CTRL_USER_FUNCTION   CSM_C_F_ON
  /** \fs feature DEACTIVATE_COMMUNICATION_REQUESTS\n
          ON: CommunicationRequest(CSM_C_PTYPE_..._CAN_LOCAL_CTRL,\n
              CSM_C_DEACTIVATE_COMMUNICATION_REQUESTS)\n
              sets all networks asleep, regardless to active CommunicationRequests
          OFF: */
  #define CSM_S_DEACTIVATE_COMMUNICATION_REQUESTS CSM_C_F_ON
#else
  /** \fs feature DEACTIVATE_COMMUNICATION_REQUESTS */
  #define CSM_S_DEACTIVATE_COMMUNICATION_REQUESTS CSM_C_F_OFF
#endif /* CSM_S_CSM_LOCAL_CTRL == CSM_C_F_ON */

/** \fs Virtual network support is enabled (e.g. GMLAN) */
#define CSM_S_VIRTUAL_NETWORK                  CSM_C_F_OFF

/** \fs Service routines to trigger upstream task from interrupt are available.\n
    (Necessary for example for GMLAN ripper) */
#define CSM_S_TRIGGER_UPSTREAM_TASK_FROM_IRQ_AVAILABLE   CSM_C_F_ON

/* !!! Please do not add other project switches !!!!! */
/** \fs Switch ON in VW projects. */
#define CSM_S_CSM_VW                           CSM_C_F_OFF

/***** VW BAP feature switches ****/
/* !!! Please do not move to the CNP section !!! */
#define CSM_S_VW_BAP_TP                         CSM_C_F_OFF   /**< \fs  BAP TP usage */
#define CSM_S_VW_BAP_RAW_TP                     CSM_C_F_OFF
#define CSM_S_VW_BAP_USE_ACKNOWLEDGE            CSM_C_F_OFF   //TODO
#define CSM_S_VW_BAP_DEV_SUPERVISION            CSM_C_F_OFF   //TODO
/** add the complete BAP payload to the data indication */
#define CSM_S_VW_BAP_LONG_DATA_IND              CSM_C_F_OFF
#define CSM_S_VW_BAP_STUPID_PROCESSING_HANDLING CSM_C_F_OFF

/***** FNL feature switches ****/
/** \fs VW "Funktionsnachlauf" */
#define CSM_S_FNL                             CSM_C_F_OFF


/*************  CAN Network Management feature switches  **********************/
/** \fs Any network management is available */
#define CSM_S_CNM_AVAILABLE                   CSM_C_F_ON

#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
  /**
   * \defgroup  CNM     CNM (CAN Network Management)
   *            This group contains all files belonging to CAN Network Management
   *//**
   * \defgroup  CNM_IF  CNM_IF (CNM Interfaces)
   *            This group contains all files belonging to CNM interfaces
   * \ingroup   CNM
   */

  /** \fs Function CSM_vCNM_StateChangeInd is available */
  #define CSM_S_CNM_STATE_CHANGE_IND  CSM_C_F_OFF
  /** \fs Function CSM_vCNMLastNmMsg is available */
  #define CSM_S_LAST_NM_MSG           CSM_C_F_OFF
  /** \fs Opel IVLAN netmanagement (version 3.3) is used. */
  #define CSM_S_IVLAN_NM              CSM_C_F_OFF
  /** \fs Volkswagen netmanagment is used. */
  #define CSM_S_VW_NM                 CSM_C_F_OFF
  /** \fs Volkswagen netmanagment HIGH is used. */
  #define CSM_S_VWHIGH_NM             CSM_C_F_OFF
 /** \fs Fiat Slave netmanagement is used. */
  #define CSM_S_FIATSLAVE_NM          CSM_C_F_OFF
  #define CSM_S_FIAT_NM_SLAVE_1       CSM_C_F_OFF
  #define CSM_S_FIAT_NM_SLAVE_2       CSM_C_F_OFF
  #define CSM_S_FIAT_NM_MASTER_1      CSM_C_F_OFF
  #define CSM_S_FIAT_NM_MASTER_2      CSM_C_F_OFF
  /** \fs Renault netmanagment is used. */
  #define CSM_S_RENAULT_NM            CSM_C_F_OFF
  /** \fs OSEK netmanagment is used. */
  #define CSM_S_OSEK_NM               CSM_C_F_OFF
  /** \fs OSEKI indirect netmanagment is used. */
  #define CSM_S_OSEKI_NM            CSM_C_F_ON
  /** \fs GMLAN netmanagment is used. */
  #define CSM_S_GMLAN_NM               CSM_C_F_OFF
  /** \fs J1939 netmanagement is used */
  #define CSM_S_J1939_NM              CSM_C_F_OFF

  #if (CSM_S_J1939_NM == CSM_C_F_ON)
    /** \fs arbitrary address capable */
    #define CSM_S_J1939_ARBITRARY_ADDRESS     CSM_C_F_OFF
    /** \fs service configurable */
    #define CSM_S_J1939_SERVICE_ADDRESS       CSM_C_F_ON
    /** \fs commanded address available */
    #define CSM_S_J1939_COMMAND_ADDRESS       CSM_C_F_ON
    /** \fs self configurable address */
    #define CSM_S_J1939_SELFCFG_ADDRESS       CSM_C_F_OFF
  #endif

  #if (CSM_S_VW_NM == CSM_C_F_ON)
    /**
     * \defgroup  CNM_VW  CNM_VW (CNM VW Specific Part)
     *            This group contains all files belonging to VW specific network management
     * \ingroup   CNM
     */
  #endif /* CSM_S_VW_NM */

#endif /* CSM_S_CNM_AVAILABLE */


/*************  CAN Network Protocol feature switches  ************************/
/** \fs Any transport protocol is available, CNP Init and Exit functions are used */
#define CSM_S_CNP_AVAILABLE        CSM_C_F_ON

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
  /**
   * \defgroup  CNP     CNP (CAN Higher Layer Protocols)
   *            This group contains all files belonging to CAN Higher Layer Protocols
   *//**
   * \defgroup  CNP_IF  CNP_IF (CNP Interfaces)
   *            This group contains all files belonging to CNP interfaces
   * \ingroup   CNP
   */

  /****** MCNet feature switches ****/
  /** \fs MCNet NM and TP are available  */
  #define CSM_S_MCNET                        CSM_C_F_OFF
  #if (CSM_S_MCNET == CSM_C_F_ON)
    /**
     * \defgroup  CSM_MCNET   CSM_MCNET (MCNet Specific Part of CSM)
     *            This group contains all files belonging to MCNet specific part of CSM
     * \ingroup   CSM
     *//**
     * \defgroup  CNP_MCNET   CNP_MCNET (MCNet Higher Layer Protocols)
     *            This group contains all files belonging to MCNet transport protocols
     * \ingroup   CNP
     *//**
     * \defgroup  CNM_MCNET   CNM_MCNET (MCNet master/slave NM)
     *            This group contains all files belonging to MCNet master or slave network management
     * \ingroup   CNM
     */

    /** \fs MCNet ASDT services available. */
    #define CSM_S_MCNET_ASDT                   CSM_C_F_ON
    /** \fs MCNet USDT TX services available. */
    #define CSM_S_MCNET_USDT_TX                CSM_C_F_OFF
    /** \fs MCNet USDT TX services available. */
    #define CSM_S_MCNET_USDT_RX                CSM_C_F_OFF
    /** \fs MCNet master network management services available. */
    #define CSM_S_MCNET_MASTER_NWM             CSM_C_F_ON
    /** \fs MCNet slave network management services available. */
    #define CSM_S_MCNET_SLAVE_NWM              CSM_C_F_ON
    /** \fs Application TX buffer are used by CAN stack.\n
        It is possible to use the apllication buffers for Tx messages instead of
        additional buffers in the CSM. If this feature is active, it has to be
        configured for each channel in the connection table, if application Tx buffer
        is used or not. */
    #define CSM_S_MCNET_APPL_TX_BUFFER_USED    CSM_C_F_OFF
    /** \fs The application frees the RX buffer.\n
        If this feature is active, the Rx buffer is not automaticly freed after
        data indication by CSM. It has to be configured for each channel.
        If it is positive configured then the  application is responsible to free the
        Rx buffer after YYY_vCSMDataInd(). \n
        See CSM_lDataIndProcessed() */
    #define CSM_S_MCNET_APPL_SETS_RX_BUFFER_FREE CSM_C_F_OFF
    /** \fs MCNet CNP_rMCNetRxBuf available */
    #define CSM_S_MCNET_DOPPELPUFFER           CSM_C_F_OFF
  #endif // CSM_S_MCNET enabled


  /****** ISO-TP feature switches ****/
  /** \fs ISO TP is available  */
  #define CSM_S_ISO_TP                 CSM_C_F_ON
  #if (CSM_S_ISO_TP == CSM_C_F_ON)
    /**
     * \defgroup  CSM_ITP   CSM_ITP (ISO TP Specific Part of CSM)
     *            This group contains all files belonging to ISO TP specific part of CSM
     * \ingroup   CSM
     *//**
     * \defgroup  CNP_ITP   CNP_ITP (ISO Transport Protocols)
     *            This group contains all files belonging to ISO transport protocols
     * \ingroup   CNP
     */

     /** \fs CSM_C_F_ON:      Transmit first Consecutive Frame CF as fast as possible         \n
             CSM_C_F_OFF:     Use STmin also for first CF after FC                            \n */
    #define CSM_S_ITP_TRANSMIT_FIRST_CF_AFAP    CSM_C_F_OFF

     /** \fs CSM_C_F_ON:      Ignore new requests (FF) if Transmission is active (HalfDuplex variant in ISO TP spec) \n
             CSM_C_F_OFF:     Allow new requests (FF) independend on TX state (FullDuplex variant in ISO TP spec)    \n */
    #define CSM_S_ITP_HALF_DUPLEX               CSM_C_F_OFF

    /** \fs CSM_C_F_ON:       All transmitted ISO TP frames have fix length (DLC=8).\n
     *      CSM_C_F_OFF:      Transmitted ISO TP frames have just the necessary length (SF, FC, last CF).\n
     *      CSM_C_F_VARIABLE: Variable CNP_fItpFrameLenFixed will be checked to decide if
     *                        fix or variable frame lenght is used. */
    #define CSM_S_ITP_TX_FIX_FRAME_LENGTH       CSM_C_F_OFF

     /** \fs CSM_C_F_ON:      All received ISO TP frames must have a fix length (DLC=8). \n
             CSM_C_F_OFF:     All received ISO TP frames can have just the necessary length.\n */
    #define CSM_S_ITP_RX_FIX_FRAME_LENGTH       CSM_C_F_OFF

    /** \fs CSM_C_F_ON:       Received ISO TP FlowControl frames must have a fix length (FC DLC=8, VW special).\n
     *      CSM_C_F_OFF:      Received ISO TP FlowControl frames have just the necessary length.\n
     *      CSM_C_F_VARIABLE: Variable CNP_fItpFrameLenFixed will be checked to decide if
     *                        fix or variable frame lenght is used. */
    #define CSM_S_ITP_RX_FC_FIX_FRAME_LENGTH    CSM_C_F_OFF

    /** \fs CSM_C_F_ON:       The StMin value of the flow control will be used for timeout value CS.\n
            CSM_C_F_OFF:      The StMin value of the flow control will be rejected,
                              csm_rIsoTpConnection[bCon].bSTMinRXConfigured will be used for CS.\n
            CSM_C_F_VARIABLE: Variable CNP_fItpUseSTMinOfFC will be checked to decide if StMin will
                              be used or rejected. */
    #define CSM_S_ITP_USE_STMIN_OF_FC           CSM_C_F_ON

    /** \fs Extended STmin range/interpretation according to ISO 15765-2 version 2004 */
    #define CSM_S_ITP_USE_STMIN_OF_FC_2004      CSM_C_F_ON

    /** \fs CSM_C_F_ON:       All flow controls will be used to get the BS and StMin.\n
            CSM_C_F_OFF:      Only the first FC will be used to get the BS and StMin.\n
            CSM_C_F_VARIABLE: Variable CNP_fItpUseSTMinOfFC will be checked to decide if all FCs will
                              be used  to get the BS and StMin. */
    #define CSM_S_ITP_USE_ALL_FC                CSM_C_F_ON
    /** \fs Extend or extended multiplexed addressing are used for ISO-TP */
    #define CSM_S_ITP_EXTENDED_ADDRESSING       CSM_C_F_OFF
    /** \fs CSM_C_F_ON:   Code to indicate the reception of a first frame is available. \n
                          Additional application callback function (yyy_vCSMDataIndFF())
                          is necessary.\n
            CSM_C_F_OFF:  No first frame indication. */
    #define CSM_S_ITP_FF_INDICATION_AVAILABLE   CSM_C_F_OFF
    /** \fs CSM_C_F_ON:   Code to indicate the reception of an error is available. \n
                          Additional application callback function (yyy_vCSMDataIndError())
                          is necessary.\n
            CSM_C_F_OFF:  No first frame indication. */
    #define CSM_S_ITP_ERROR_INDICATION_AVAILABLE   CSM_C_F_OFF
    /** \fs CSM uses the Tx buffer of the application. The application is not allowed to
            write to the buffer until YYY_vCSMDataCon().\n
            Configurable for each channel (fApplTxBufferUsed = TRUE). Value for wMaxTxLen
            must be defined by application. */
    #define CSM_S_ITP_APPL_TX_BUFFER_USED       CSM_C_F_OFF
    /** \fs If fApplSetsRxBufferFree is TRUE (configurable for each channel) then the
            application is responsible to free the Rx buffer after YYY_vCSMDataInd(). \n
            See CSM_lDataIndProcessed() */
    #define CSM_S_ITP_APPL_SETS_RX_BUFFER_FREE  CSM_C_F_OFF

    /** \fs ASDT for ISO-TP available. \n
         Additional define for implementation type (BP, LIGHT, ...) */
    #define CSM_S_ITP_ASDT_EXTENSIONS           CSM_C_F_OFF

    #if (CSM_S_ITP_ASDT_EXTENSIONS == CSM_C_F_ON)
      /** \fs Opel/BP version of ASDT (use new FC Ack for acknowledge) */
      #define CSM_S_ITP_ASDT_EXTENSION_LIGHT      CSM_C_F_OFF
      /** \fs BP version of ASDT (use FC CTS/Wait for acknowledge) */
      #define CSM_S_ITP_ASDT_EXTENSION_BP         CSM_C_F_OFF
      /** \fs Renault version of ASDT (connection-oriented, additional AK,CS and DS PDUs) */
      #define CSM_S_ITP_ASDT_EXTENSION_RENAULT    CSM_C_F_ON
      /** Check configuration of switches */
      #if (   ((CSM_S_ITP_ASDT_EXTENSION_LIGHT == CSM_C_F_ON)   && (CSM_S_ITP_ASDT_EXTENSION_BP == CSM_C_F_ON))      \
           || ((CSM_S_ITP_ASDT_EXTENSION_LIGHT == CSM_C_F_ON)   && (CSM_S_ITP_ASDT_EXTENSION_RENAULT == CSM_C_F_ON)) \
           || ((CSM_S_ITP_ASDT_EXTENSION_RENAULT == CSM_C_F_ON) && (CSM_S_ITP_ASDT_EXTENSION_BP == CSM_C_F_ON))   )
        #error "Only one type of ISO-TP ASDT extension may be used at the same time!"
      #endif
      #if (    (CSM_S_ITP_ASDT_EXTENSION_LIGHT    == CSM_C_F_OFF)   \
            && (CSM_S_ITP_ASDT_EXTENSION_BP       == CSM_C_F_OFF)    \
            && (CSM_S_ITP_ASDT_EXTENSION_RENAULT  == CSM_C_F_OFF)  )
        #error "At least one ISO-TP ASDT extension has to be activated!"
      #endif
    #endif // CSM_S_ITP_ASDT_EXTENSIONS enabled

    /** \fs ICCC (Infotainment Control Channel Concept) for ISO-TP is used. */
    #define CSM_S_ICCC                          CSM_C_F_OFF

    /** \fs CommunicationReq/Ind/Con functions are available for ISO-TP */
    #define CSM_S_ITP_COMMUNICATION_FCT         CSM_C_F_ON

  #endif // CSM_S_ISO_TP enabled

  /****** TP 2.0 feature switches ****/
  /** \fs TP 2.0 is available (MCNet for VW) */
  #define CSM_S_TP20                 CSM_C_F_OFF
  #if ( CSM_S_TP20 == CSM_C_F_ON )
    /**
     * \defgroup  CSM_VW   CSM_VW (VW TP Specific Part of CSM)
     *            This group contains all files belonging to VW TP specific part of CSM
     * \ingroup   CSM
     *//**
     * \defgroup  CNP_VW20  CNP_VW20 (VW TP2.0)
     *            This group contains all files belonging to VW TP2.0
     * \ingroup   CNP
     */

     /* Further things to be addded here...*/

  #endif // CSM_S_TP20 enabled

  /****** VW TP 2.0 feature switches ****/
  /** \fs VW TP 2.0 is available  */
  #define CSM_S_VW_TP_2_0                       CSM_C_F_OFF
  #if ( CSM_S_VW_TP_2_0 == CSM_C_F_ON )
    /**
     * \defgroup  CSM_VW   CSM_VW (VW TP Specific Part of CSM)
     *            This group contains all files belonging to VW TP specific part of CSM
     * \ingroup   CSM
     *//**
     * \defgroup  CNP_VW20  CNP_VW20 (VW TP2.0)
     *            This group contains all files belonging to VW TP2.0
     * \ingroup   CNP
     */

     /* Further things to be addded here...*/

  #endif // CSM_S_VW_TP_2_0 enabled

  #define CSM_S_VWTP20_IND_ON_ML_LEVEL          CSM_C_F_OFF  /**< \fs Send indications via upstream task */

  /****** VW TP 1.6 feature switches ****/
  #define CSM_S_VW_TP_1_6                       CSM_C_F_OFF  /**< \fs VW protocol type 1.6 used */


  /***** UUDT_TX feature switches ****/
  /**  \fs Unacknowledged Unsegmented Data Transfer TX (Single CAN telegram transmission) \n
           e.g. used for confirmed writing (e.g. request bits) */
  #define CSM_S_UUDT_TX                         CSM_C_F_OFF


  /***** UUDT_RX feature switches ****/
  /**  \fs Unacknowledged Unsegmented Data Transfer RX (Single CAN telegram reception) \n
           e.g. used for ensured reception (e.g. update bits) */
  #define CSM_S_UUDT_RX                         CSM_C_F_OFF

  #if (CSM_S_UUDT_RX == CSM_C_F_ON)
    /***** UUDT data error indication ****/
    /** \fs CSM_C_F_ON:       pfvDataErrorInd callback will be used, if defined \n
            CSM_C_F_OFF:      no pfvDataErrorInd support \n
            e.g. to be used for timeout indication on cyclic channels */
    #define CSM_S_UUDT_RX_DATA_ERROR_IND_AVAILABLE   CSM_C_F_OFF

    #if (CSM_S_UUDT_RX_DATA_ERROR_IND_AVAILABLE == CSM_C_F_ON)
      #if (CSM_S_DATA_ERROR_IND_AVAILABLE != CSM_C_F_ON)
        #error CSM_S_DATA_ERROR_IND_AVAILABLE must be ON to enable CSM_S_UUDT_RX_DATA_ERROR_IND_AVAILABLE
      #endif // CSM_S_DATA_ERROR_IND_AVAILABLE != CSM_C_F_ON

      /***** UUDT_RX timeout indication ****/
      #define CSM_S_UUDT_RX_TIMEOUT_INDICATION      CSM_C_F_OFF
      /** \fs CSM_C_F_ON:       enable DataErrorInd(timeout) on timeout of cyclic Rx channels \n
              CSM_C_F_OFF:      disable DataErrorInd(timeout) */
    #endif // CSM_S_UUDT_RX_DATA_ERROR_IND_AVAILABLE == CSM_C_F_ON

    /***** restrict UUDT data indication to changed data ****/
    #define CSM_S_UUDT_RX_INDICATION_ONLY_CHANGED CSM_C_F_OFF
    /** \fs CSM_C_F_ON:       disable DataInd for unchanged data reception on cyclic Rx channels \n
            CSM_C_F_OFF:      DataInd on every reception */
  #endif // CSM_S_UUDT_RX == CSM_C_F_ON


  /****** LIN 2.0 diag feature switches ******/
  #define CSM_S_LIN_DIAG                        CSM_C_F_OFF
  /** \fs CSM_C_F_ON:       LIN diag support (CSM_C_PTYPE_USED_STD_LIN_DIAG) \n
          CSM_C_F_OFF:      no LIN diag support */


  /***** MPDT feature switches ****/
  /**  \fs Multiple Packet Data Transfer (MPDT). Added in 2008 by M.Prhl. First project: Nissan LCN NAR */
  #define CSM_S_MPDT                            CSM_C_F_OFF
  #if ( CSM_S_MPDT == CSM_C_F_ON )
    /** \fs Data indication processed handling can be switched on. Added in 2008 by M.Prhl. First project: Nissan LCN NAR */
    #define CSM_S_MPDT_DATA_IND_PROCESSED       CSM_C_F_OFF

    /** \fs Used bus for MPDT has its own mini NWM for e.g. bus off handling. */
    /* Should be ON for Nissan LCN NAR                                        */
    /* For Nissan LCN2 OSEKI NM does this job, so there it should be OFF      */
    #define CSM_S_MPDT_BUILD_IN_MINI_NWM        CSM_C_F_OFF
  #endif // CSM_S_MPDT enabled

#if (defined VARIANT_S_FTR_ENABLE_INF4CV) || (defined CSM_C_PROJECT_USERSPACE_INF4CV)
  /***** J1939 feature switches ****/
  /** \fs J1939 transport protocol is used */
  #define CSM_S_J1939                           CSM_C_F_ON
  #if ( CSM_S_J1939 == CSM_C_F_ON )
    /** \fs Send CTS-delay frames when channel is busy during data reception */
    #define CSM_S_J1939_RX_DELAY_WHILE_BUSY     CSM_C_F_OFF
    /** \fs Enable Start/Stop broadcast (DM13) message support */
    #define CSM_S_J1939_STARTSTOP_BROADCAST     CSM_C_F_ON
    /** \fs Enable MemoryAccess (DM14, DM15, DM16) message support */
    #define CSM_S_J1939_MEMORYACCESS            CSM_C_F_OFF

  #define CSM_S_DATA_ERROR_IND_AVAILABLE      CSM_C_F_OFF

  #define CSM_S_J1939_ERRORMEMORY             CSM_C_F_OFF
  #endif // CSM_S_J1939 enabled
#else
  #define CSM_S_J1939                           CSM_C_F_OFF
  #if ( CSM_S_J1939 == CSM_C_F_ON )
    /** \fs Send CTS-delay frames when channel is busy during data reception */
    #define CSM_S_J1939_RX_DELAY_WHILE_BUSY     CSM_C_F_OFF
    /** \fs Enable Start/Stop broadcast (DM13) message support */
    #define CSM_S_J1939_STARTSTOP_BROADCAST     CSM_C_F_OFF
    /** \fs Enable MemoryAccess (DM14, DM15, DM16) message support */
    #define CSM_S_J1939_MEMORYACCESS            CSM_C_F_OFF
  #endif // CSM_S_J1939 enabled
#endif

/***** LOCAL_CTRL feature switches ****/
  /** \fs LOCAL_CTRL local control lDataReq() function is used */
  #define CSM_S_CNP_LOCAL_CTRL                  CSM_C_F_ON

#endif // CSM_S_CNP_AVAILABLE == CSM_C_F_ON


/*************  CAN Broadcast Server feature switches  ************************/
#define CSM_S_CBR_AVAILABLE        CSM_C_F_ON   /**< \fs Any broadcast is available,
                                                 * CBR Init and Exit functions are used */
#if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
  #define CSM_S_VECTOR_TXOBJ_USED              CSM_C_F_OFF   /**< \fs Use vector driver tx obj. */
#ifdef VARIANT_S_FTR_ENABLE_SMART_HU
  #define CSM_S_CBR_LITTLE_ENDIAN_SIGNALS      CSM_C_F_OFF   /**< \fs CBR is using little endian words for signals */
  #define CSM_S_CBR_BIG_ENDIAN_SIGNALS         CSM_C_F_ON    /**< \fs CBR is using big endian words for signals */
#else
  #define CSM_S_CBR_LITTLE_ENDIAN_SIGNALS      CSM_C_F_ON   /**< \fs CBR is using little endian words for signals */
  #define CSM_S_CBR_BIG_ENDIAN_SIGNALS         CSM_C_F_OFF    /**< \fs CBR is using big endian words for signals */
#endif
  #define CSM_S_CBR_BOTH_ENDIANS_SIGNALS       CSM_C_F_OFF   /**< \fs CBR can handle both endians for signals */
  #define CSM_S_LITTLE_ENDIAN_CPU              CSM_C_F_ON    /**< \fs CPU is using little endian words */
  #define CSM_S_BIG_ENDIAN_CPU                 CSM_C_F_OFF   /**< \fs CPU is using big endian words */
  #define CSM_S_CBR_TIMEOUT_DEFAULT_LAST_VALUE CSM_C_F_ON    /**< \fs CBR is using last arrived value as timeout default if no timeout default is given */
  #define CSM_S_CBR_RX_TIMEOUT_GROUPS          CSM_C_F_OFF   /**< \fs CBR is able to use groups for timeout supervision  */
  #define CSM_S_DEFAULT_SIGNAL_VALUES          CSM_C_F_ON    /**< \fs set default values */
  #define CSM_S_TIMEOUT_SIGNAL_VALUES          CSM_C_F_ON   /**< \fs set default values in case of RX timeout */
  #define CSM_S_CBR_TX_IF_APPL_ACTIVE          CSM_C_F_ON    /**< \fs if activ feature */
  #define CSM_S_CBR_MIN_DELAY                  CSM_C_F_OFF   /**< \fs CBR supports minimum distance between broadcast messages */
  #define CSM_S_CBR_RESYNCHRONIZED_CYCLE       CSM_C_F_OFF   /**< \fs event transmission does not affect cycle grid of PE message */
  #define CSM_S_CBR_USES_DIRECT_CALLS          CSM_C_F_OFF   /**< \fs CBR supports direct calls in CBR_vCDAReceiveInd */
  #define CSM_S_CBR_USES_COMMUNICATION_REQ     CSM_C_F_ON    /**< \fs CommunicationReq/Ind/Con functions are used */
  #define CSM_S_CCS_USED                       CSM_C_F_OFF   /**< \fs CCS is used in this project */
  #define CSM_S_CBR_QUEUED_SIGNALS_USED        CSM_C_F_OFF   /**< \fs Queued signals for CCS used. */
  #define CSM_S_CBR_DISCARD_MSG_SHORTER_DLC    CSM_C_F_ON    /**< \fs CBR does not update the received message signals */
  #define CSM_S_CBR_TX_MSG_ROLL_COUNTER        CSM_C_F_OFF   /**< \fs CBR does support a rolling signal counter for TX messages upon each Transmission */
  #define CSM_S_CBR_TX_MSG_ROLL_COUNTER_GROUPS CSM_C_F_OFF    /**< \fs CBR does support a rolling signal counter group for TX messages upon each Transmission */
  #define CSM_S_CBR_TX_MSG_CRC                 CSM_C_F_OFF   /**< \fs CBR does support a CRC signal for TX messages upon each Transmission */
  #define CSM_S_CBR_RX_MSG_ROLL_COUNTER        CSM_C_F_OFF   /**< \fs CBR does support a rolling signal counter check for RX messages upon each Reception */
  #define CSM_S_CBR_RX_MSG_CRC                 CSM_C_F_OFF   /**< \fs CBR does support a CRC signal check for RX messages upon each Reception */
  #define CSM_S_iMX_SIGNAL_ABSTRACTION         CSM_C_F_OFF    /**< \fs CBR does support iMX abstract signals */
  #define CSM_S_v850_SIGNAL_ABSTRACTION        CSM_C_F_OFF   /**< \fs CBR does support v850 abstract signals */
  #define CSM_S_CBR_RX_MASK                    CSM_C_F_OFF   /**< \fs CBR does support receive mask to avoid processing of unused data */
  #define CSM_S_CBR_GATEWAY                    CSM_C_F_OFF   /**< \fs CBR does support a signal based gateway */
  #define CSM_S_CBR_PROXY_MASK                 CSM_C_F_OFF   /**< \fs CBR does support a proxy mask */
#endif // CSM_S_CBR_AVAILABLE


/*************  CDA feature switches  *****************************************/
/** \fs Any CDA is available, CDA Init and Exit functions are used */
#define CSM_S_CDA_AVAILABLE                 CSM_C_F_OFF
/** \fs Send predefiend is used for transmit */
#define CSM_S_CDA_PREDEFINED_TX             CSM_C_F_OFF
/** \fs Predefiend is used for receive */
#define CSM_S_CDA_PREDEFINED_RX             CSM_C_F_OFF
/** \fs With send restriction CDA only transmits NWM frames (e.g. after busoff)  */
#define CSM_S_CDA_SENDRESTRICTION           CSM_C_F_OFF
#if (CSM_S_CDA_SENDRESTRICTION == CSM_C_F_ON)
  #define CSM_S_CDA_BUSOFF_SENDRESTRICTION  CSM_C_F_OFF
#endif
/** \fs CDA considers min delays between two transmitted CAN messages */
#define CSM_S_CDA_GLOBAL_MINDELAY           CSM_C_F_OFF
/** \fs CDA VEC adapter must copy data to vector objects for data except CBR. \n
    This is to be switched on if more than only CBR data is routed through
    the cda_vec adapter (e.g. BAP raw data). */
#define CSM_S_CDA_VEC_COPY_DATA             CSM_C_F_OFF
/** \fs For ercosek: CDA IRQ handler is allowed to be interrupted by a higher prio IRQ */
#define CSM_S_CDA_ALLOW_HIGHERPRIOIRQS      CSM_C_F_OFF
/** \fs Via variants management must be checked if a CAN bus is connected to the ECU */
#define CSM_S_CDA_BUS_ABSENCE_POSSIBLE      CSM_C_F_OFF
/** \fs CDA sets a flag for each received CAN frame. \n
     Used for timeout surveillance of CAN traffic. Set in CDA and check and clear e.g. in network
     management.  \n
     Clearing and setting of the flag is not protected with DI/EI. This should not be a problem.
     The Flag is set in the CDA frame indication function on interrupt level and can interrupt a
     clear which is in process so the set will be overwritten. But when there was CAN traffic
     then the flag was already set after timeout (clear) so the timeout is started again. */
#define CSM_S_CDA_FLAG_FOR_RX_FRAMES        CSM_C_F_ON
/** \fs CDA do not deliver messages with a shorter DLC than expected to the CSM modules.
     Exception: data routed via CDA_VEC. This behaviour can be configured within the vector driver */
#define CSM_S_CDA_DISCARD_MSG_SHORTER_DLC   CSM_C_F_ON
/** \fs CDA do not deliver messages with a longer DLC as expected to the CSM modules
     Exception: data routed via CDA_VEC. This behaviour can be configured within the vector driver */
#define CSM_S_CDA_DISCARD_MSG_LONGER_DLC    CSM_C_F_OFF
/** CDA do not compare all bit of a RX-Identifier in an Basic CAN telegram.  \n
    This is used e.g. at a GMLAN CAN */
#define CSM_S_CDA_MASK_CAN_ID    CSM_C_F_OFF
/** \fs CDA gateway function for queued telegrams */
#define CSM_S_CDA_GATEWAY    CSM_C_F_OFF
/** \fs CDA gateway function for predef telegrams */
#define CSM_S_CDA_GATEWAY_PREDEF    CSM_C_F_OFF
/** \fs CDA indicates one CAN telegrams to many parts. e.g. CBR and CDA_GATEWAY */
#define CSM_S_CDA_MULTI_DATA_IND    CSM_C_F_OFF
/** \fs Enables CDA statistics */
#define CSM_S_CDA_STATISTICS                      CSM_C_F_ON
/** bitte wenn die Frage geklrt ist lschen */
#define CSM_S_CDA_WARUM_WIRD_DAS_HIER_GEBRAUCHT   CSM_C_F_OFF
/** \fs Enables delay busoff end. Busoff ends not after CDA_lBusoffRecovery. Busoff ends with the
     first DataInd from CDA. This feature is used e.g. in VW projects */
#define CSM_S_CDA_END_BUS_OFF_WITH_DATA_IND       CSM_C_F_OFF
/** \fs Enables CDA Error Pin checking. This is used e.g. for VW OSEK payload */
#define CSM_S_CDA_CHECK_ERROR_PIN                 CSM_C_F_OFF
/** \fs Enables CDA data confirmation. Added in 2008 by M.Prhl. First project: Nissan LCN NAR. */
#define CSM_S_CDA_DATA_CON                        CSM_C_F_OFF
/** \fs Enables CDA TX timeout. Added in 2011 by A.Borck. First project: Nissan LCN2 */
#define CSM_S_CDA_TRANSMIT_TIMEOUT                CSM_C_F_OFF
/** \fs Enables CDA support of a telegram sub-type. Added in 2011 by A.Borck. First project: Nissan LCN2 */
#define CSM_S_CDA_TEL_SUB_TYPE_SUPPORT            CSM_C_F_OFF
/** \fs Enables CDA support of several message-box configurations. Added in 2011 by A.Borck. First project: Nissan LCN2 */
#define CSM_S_CDA_MULTI_HW_CONFIGURATIONS         CSM_C_F_OFF
/** \fs For an old VW V850 project this was enabled - do not use this in actual projects !!!! */
#define CSM_S_CDA_OLD_CAN_CONTROLLER              CSM_C_F_OFF

#if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)
  #define CSM_S_VECTOR_TXOBJ_USED              CSM_C_F_OFF   /**< \fs Use vector driver tx obj. */
#endif /* CSM_S_CDA_AVAILABLE */

/*************  ??? feature switches  *****************************************/
/**
 *            This group contains all old, unused or not commented feature switches
 */
/** \fs High speed transceiver hardware test started by maus command.
 *      Used during CM production tests for V850 projects.\n
 *      CSM_C_F_ON:  test available\n
 *      CSM_C_F_OFF: test not available */
#define CSM_S_CAN_HIGHSPEED_TRANSCEIVER_HW_TEST     CSM_C_F_OFF //(cda_m.h, cda_trx..., csm_stack_esd.c)
/** \fs Fault tolerant transceiver hardware test started by maus command.
 *      Used during CM production tests for V850 projects.\n
 *      CSM_C_F_ON:  test available\n
 *      CSM_C_F_OFF: test not available */
#define CSM_S_CAN_LOWSPEED_TRANSCEIVER_HW_TEST      CSM_C_F_OFF //(cda_m.h, cda_trx..., csm_stack_esd.c)

#define CSM_S_ITP_ASDT_LOW_LEVEL_TIMEOUTS_RENAULT   CSM_C_F_OFF //(cda_afcan.c)
#define CSM_S_CDA_TRX_1_NSTB_EN_SEPARATE_PINS       CSM_C_F_OFF //(cda_trx_1.c)
#define CSM_S_V850                                  CSM_C_F_OFF //(cnp.c)
#define CSM_S_VW_TP20_BROADCAST_SERVICE             CSM_C_F_OFF //(cnp_vw20.c)
#define CSM_S_VW_TP20_PARA_EXCHG                    CSM_C_F_OFF //(cnp_vw20.c)
#define CSM_S_VW_TP20_PARA_FUNC                     CSM_C_F_OFF //(cnp_vw20.c)
#define CSM_S_VW_TP20_MULTI_ECU                     CSM_C_F_OFF //(cnp_vw20.c)
#define CSM_S_FORD_TP_EX                            CSM_C_F_OFF //(csm_test.c)
#define CSM_S_FORD_TP_EX_TEST                       CSM_C_F_OFF //(csm_test.c)
#define CSM_S_ENABLE_ALWAYS_INDICATE_STATE_CHANGE   CSM_C_F_OFF //(csm.c)
#define CSM_S_TEST                                  CSM_C_F_OFF //(csm.c)
#define CSM_S_VW_MUTE_MODE                          CSM_C_F_OFF //(csm_vw.c)
#define CSM_S_NORMAL_REQ_BY_DIFFERENT_CLIENTS       CSM_C_F_OFF //(csm_stack_esd.c)
/** \fs Feature used for Opel MY 4.5 project. BR_TEL (UUDT) rx telegrams are indicated
 *      for diagnosis on downstream task level and all others on upstream task level. */
#define CSM_S_DIFFERENT_OPEL_BR_TEL_TX_ACCESS_LEVELS  CSM_C_F_OFF //(csm_stack_esd.c)
#define CSM_S_USE_CLEAR_IND_REASON_FUNCTION         CSM_C_F_OFF //(csm_stack_m.h)
#define CSM_S_FFD_WORKAROUND                        CSM_C_F_OFF //(csm_stack_nucleus.c)
#define CSM_S_FD_CSM_TEST                           CSM_C_F_OFF //(csm_stack_nucleus.c)
#define CSM_S_POWER_STATE_CONTROL                   CSM_C_F_OFF //(csm_stack_posix.c)
#define CSM_S_FUJITSUOSEK_ALARM_TIMER               CSM_C_F_OFF //(csm_stack_fujitsuosek.c)

/* only for CAN stack modules */
#if (defined CSM_STACK_SELF) || (defined CSM_STACK_ENV_SELF) || (defined CSM_APL_SELF)
/* To do.... */
#endif

#else
# error CSM_STACK_P.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          csm_stack_p.h
 * \brief         Feature switches and basic defines for the CSM stack.
 *
 *                Feature switches and basic defines for the CSM stack.
 *
 * \sw_component  CAN stack
 * \project       RN AIVI
 * \path          /di_can/modules_swa/csm_stack/src/
 * \ingroup       CSM
 * \ingroup       CSM_STACK
 *
 * \authors       V-Team
 *
 * COPYRIGHT:      (c) 2015 Bosch Car Multimedia GmbH
 *
 * \history_begin
 *
 *****************  V-Team PVCS
 *
 *  06.03.14  \main\vw_mib2_mqb_proxy\16 Prhl
 * - CSM_S_CBR_TX_IF_APPL_ACTIVE and set to CSM_C_F_ON
 *
 *  07.04.15  \main\rn_aivi_proxy\1  Prhl
 * - merge from \main\vw_mib2_mqb_proxy\16
 *
 *  07.04.15  \main\rn_aivi_proxy\2  Prhl
 * - CSM_S_VW_BAP_TP and set to CSM_C_F_OFF
 * - CSM_S_VW_BAP_DEV_SUPERVISION and set to CSM_C_F_OFF
 * - CSM_S_VW_BAP_LONG_DATA_IND and set to CSM_C_F_OFF
 *
 *  10.04.15  \main\rn_aivi_proxy\3  Prhl
 * - CSM_S_CBR_LITTLE_ENDIAN_SIGNALS set to CSM_C_F_OFF
 * - CSM_S_CBR_BIG_ENDIAN_SIGNALS set to CSM_C_F_ON
 *
 *  21.04.15  \main\rn_aivi_proxy\4  Borck
 * - ISO TP disabled
 * - additional CBR switches added and set to OFF (required to use latest cbr)
 *
 *  30.04.15  \main\rn_aivi_proxy\5  Prhl
 * - CSM_S_MPDT set to CSM_C_F_ON
 *
 *  19.05.15  \main\rn_aivi_proxy\6  Prhl
 * - CSM_S_VARIANTS_MANAGEMENT set to CSM_C_F_ON
 * - CSM_S_SLOT_BASED_CONFIG added and set to CSM_C_F_ON
 *
 *  20.05.15  \main\rn_aivi_proxy\7  Prhl
 * - CSM_S_CNM_AVAILABLE set to CSM_C_F_ON
 * - CSM_S_OSEKI_NM  added and set to CSM_C_F_ON
 *
 *  23.07.15  \main\rn_aivi_proxy\8  Borck
 * - LINT issue fixed
 *
 *  24.09.15  \main\rn_aivi_proxy\9  A.Borck
 * - feature switches for cbr_al (SLOT based Signal Abstraction Layer) introduced
 *   -- CSM_S_iMX_SIGNAL_ABSTRACTION is CSM_C_F_ON, CSM_S_v850_SIGNAL_ABSTRACTION is CSM_C_F_OFF here
 *
 *  08.10.15  \main\rn_aivi_proxy\10  A.Borck
 * - Feature Mini Abstraction (CSM_S_CBR_ABSTRACT_SIGNALS) removed completely
 *
 *  07.01.16  \main\rn_aivi_proxy\11  A.Borck
 * - section with CSM_S_CNP_AVAILABLE modified:
 *   in fact -> CSM_S_CNP_LOCAL_CTRL set to CSM_C_F_ON (what requires the cnp_lctr.c module then)
 *
 *  03.03.16  \main\rn_aivi_proxy\12  A.Borck
 * - defines added and set to OFF (CSM_S_CBR_RX_MASK, CSM_S_CBR_GATEWAY)
 *
 *  20.06.16  \main\rn_aivi_proxy\13  A.Borck
 * - new feature switches introduced to compile with latest cbr.c (rolling counters for RX and TX)
 *
 *  23.06.16  \main\rn_aivi_proxy\14  A.Borck
 * - #define CSM_S_CBR_PROXY_MASK introduced and set to CSM_C_F_OFF
 *
 *  15.05.17  \main\rn_aivi_proxy\15  A.Borck
 * - ISO-TP feature set to ON
 *
 *  17.08.17  \main\rn_aivi_proxy\16  A.Borck
 * - new feature switch for Rolling Counter Groups introduced and set to OFF
 *
 * 24.11.17  main\g3inf4cv_csm_proxy_in\1  Jayashree
 * - Initial version for INF4CV
 *
 * \history_end
 *//****** END OF FILE ********************************************************/
