//**************************************************************************************************
//* defines CSM wide (Generated code - do NOT change manually !!!)
//**************************************************************************************************
// Temporary Wakeup used in CSM_lSignalWrite() for all NON-VW projects
#if (CSM_S_BUS_WAKE_TEMP == CSM_C_F_ON)
#define CSM_C_WAKE_TEMP_TIME    11000              // keep awake time = 11s
#endif

#define CSM_LCTR_C_MAX_USER           5              // Number of local control users (LCM,SPM for VCAN and MCAN, IGN for VCAN, on iMX for symmetry only)
#define CSM_CBR_MAX_USER              2             // Number of cbr users (only VCAN is for CBR)
#define CSM_C_MAX_ERROR_IND_USER     10              // Number of error indication user
#define CSM_APL_MAX_CONFIG_SLOTS     1              // Max. Number of configuration slots
#define CSM_APL_INVALID_CONFIG_SLOT  0xFF            // in case of error (reading from NVM)

#define CSM_C_CAN_CONFIG_SLOT_0      0x00            // slot 0


#define CSM_APL_C_READ_SLOT          0x00            // trace subcmd to trigger a slot read
#define CSM_APL_C_READ_EARLYNOR_SLOT 0x00            // subcmd to Read Slot from Early Nor
#define CSM_APL_C_INIT_DATAPOOL      0x01            // trace subcmd to trigger a re-init of the datapool after KDS writing
#define CSM_APL_C_CHECK_INC_COM      0x02            // trace subcmd to check if INC connection to CCS is active
#define CSM_APL_C_SET_DP_ITEM        0x03            // trace subcmd to set a certain datapool item
#define CSM_APL_C_SET_DLT_LOGLEVEL   0x04            // trace subcmd to set a certain loglevel for a certain module on v850
#define CSM_APL_C_SET_ISOTP_BS       0x05            // trace subcmd to set the blocksize for ISO-TP on v850



// ##################################################
// _CSM_SECTION_HISTORY: user specific code start
// ##################################################

/*****************************************************************************/
/* CSM_STACK (down/up strem task) */
/*****************************************************************************/
#define CSM_M_UPSTREAM_TASK_LOCK()                CSM_iInterruptsDisable()
#define CSM_M_UPSTREAM_TASK_UNLOCK(iIsrStat)      CSM_vInterruptsRestore(iIsrStat)
#define CSM_M_DOWNSTREAM_TASK_LOCK()              CSM_iInterruptsDisable()
#define CSM_M_DOWNSTREAM_TASK_UNLOCK(iIsrStat)    CSM_vInterruptsRestore(iIsrStat)
// CSM_C_DOWN_REASON_...    List of all used triggers for the Downstream Task

#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_OSEK_NM == CSM_C_F_ON)
#define CSM_C_DOWN_REASON_OSEK_TIMEOUT              0x00000400ul
#endif /* CSM_S_OSEK_NM */
#endif /* CSM_S_CNM_AVAILABLE */

// CSM_C_DOWN_REASON_...    List of all used triggers for the Downstream Task
#define CSM_C_DOWN_REASON_CSM_BUS_STATE_CHANGED         0x00000000ul
#define CSM_C_DOWN_REASON_CSM_COMMUNICATION_REQ         0x00000040ul
#define CSM_C_DOWN_REASON_CBR_SEND                      0x00000080ul
#define CSM_C_DOWN_REASON_CBR_TIMEOUT                   0x00000100ul
#define CSM_C_DOWN_REASON_CBR_COMMUNICATION_REQ         0x00000200ul
#define CSM_C_DOWN_REASON_CNM_OSEKI_COMMUNICATION_REQ   0x00000400ul
//#define CSM_C_DOWN_REASON_ITP_DATA_REQ                  0x00000800ul
#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_OSEK_NM == CSM_C_F_ON)
#define CSM_C_DOWN_REASON_OSEK_TIMEOUT              0x00000800ul
#endif /* CSM_S_OSEK_NM */
#endif /* CSM_S_CNM_AVAILABLE */
#define CSM_C_DOWN_REASON_CNP_ITP_COMMUNICATION_REQ     0x00001000ul
#define CSM_C_DOWN_REASON_IPC_LOCAL_BR_REQ_TX           0x00002000ul
#define CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX         0x01000000uL       // NP (TP) data from INC available
#define CSM_C_DOWN_REASON_IPC_REMOTE_NET_DATA_RX        0x02000000uL       // NET data from INC available
#define CSM_C_DOWN_REASON_IPC_REMOTE_BR_DATA_RX         0x04000000uL       // BR data from INC available
#define CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ         0x08000000uL
#define CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ         0x10000000uL
#define CSM_C_DOWN_REASON_CSM_IND_RADIOSTATUSCHANGED    0x20000000uL
#define CSM_C_DOWN_REASON_IPC_PROXY_TX_TIMEOUT          0x40000000uL       // OSAL timeout LINUX, TX to INC for BR, NET, NP
#define CSM_C_DOWN_REASON_IPC_LOCAL_NET_REQ_TX          0x80000000uL

// CSM_C_IND_REASON_...   List of all used triggers for the Upstream Task
// CSM_C_IND_REASON_...   List of all used triggers for the Upstream Task
#if (CSM_S_CSM_LOCAL_CTRL == CSM_C_F_ON)
#define CSM_C_IND_REASON_CSM_COMMUNICATION_CON          0x00000001ul
#define CSM_C_IND_REASON_CSM_COMMUNICATION_IND          0x00000002ul
#endif /* CSM_S_CSM_LOCAL_CTRL */
#define CSM_C_IND_REASON_CBR_SIGNAL_IND                 0x00000004ul
#define CSM_C_IND_REASON_CBR_COMMUNICATION_IND          0x00000008ul
#define CSM_C_IND_REASON_CBR_COMMUNICATION_CON          0x00000010ul
//#define CSM_C_IND_REASON_CSM_MPDT_DATA_IND              0x00000020ul
//#define CSM_C_IND_REASON_CSM_MPDT_DATA_CON              0x00000040ul
//#define CSM_C_IND_REASON_CSM_MPDT_COMMUNICATION_IND     0x00000080ul
//#define CSM_C_IND_REASON_CSM_MPDT_COMMUNICATION_CON     0x00000100ul
#define CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_IND      0x00000200ul
#define CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_CON      0x00000400ul
//#define CSM_C_IND_REASON_ITP_DATA_CON                   0x00000800ul       // give an ISO-TP data confirmation (TX done or Timeout)
//#define CSM_C_IND_REASON_ITP_DATA_IND                   0x00001000ul       // give an ISO-TP data indication (upstream)
#define CSM_C_IND_REASON_BUS_ERROR                      0x00080000ul
#define CSM_C_IND_REASON_CSM_OSEKI_NM_STATE_CHANGED     0x00100000ul

#if (CSM_S_J1939 == CSM_C_F_ON)
  #define CSM_C_DOWN_REASON_J1939_DATA_REQ              0x00200000ul
  #define CSM_C_DOWN_REASON_J1939_COMMUNICATION_REQ     0x0040000ul
  #define CSM_C_DOWN_REASON_J1939_CON_TIMEOUT           0x00800000ul
  #define CSM_C_IND_REASON_J1939_COMMUNICATION_CON      0x00020000ul
  #define CSM_C_IND_REASON_J1939_COMMUNICATION_IND      0x00040000ul
#endif /* CSM_S_J1939 */

//**************************************************************************************************
//* defines for CBR (Generated code - do NOT change manually !!!)
//**************************************************************************************************
// define the amount of CBR broadcast messages (TX and RX) here

#define CBR_RX_MAX_NUMBER_SLOT0       (17)   // #ToDo: This was automatically corrected from 0 to 1
#define CBR_TX_MAX_NUMBER_SLOT0       (14)
#define CBR_RX_ABSOLUT_MAX_NUMBER     (17)
#define CBR_TX_ABSOLUT_MAX_NUMBER     (14)
#define CBR_RX_MAX_NUMBER             bCbrRxMaxNumber            // replace define by var in code
#define CBR_TX_MAX_NUMBER             bCbrTxMaxNumber            // replace define by var in code

/*****************************************************************************/
/* CSM CAN identifyer */
/*****************************************************************************/
/* CAN1/VCAN*/
/*TX*/

#define CSM_C_TX_ID_PhoneStatus                      0x98ff1496L /* 0xc7f8L */
#define CSM_C_TX_ID_MediaStatus2                     0x98ff134cL /* 0xc7f8L */
#define CSM_C_TX_ID_MediaStatus1                     0x98ff124cL /* 0xc7f8L */
#define CSM_C_TX_ID_DeviceStatus                     0x98ff114cL /* 0xc7f8L */
#define CSM_C_TX_ID_Camera_Status                    0x98ff174cL /* 0xc7f8L */
#define CSM_C_TX_ID_Display_Mainline                 0x98ff164cL /* 0xc7f8L */
#define CSM_C_TX_ID_CabinMedia_Status                0x98ff154cL /* 0xc7f8L */
#define CSM_C_TX_ID_CabinB_Media_Status              0x98ff184cL /* 0xc7f8L */
#define CSM_C_TX_ID_VehiclePositionNav               0x98fef31cL /* 0xc7f7L */

/*RX*/
#define CSM_C_RX_ID_MediaCommand                     0x98ff0217L /* 0xc7f8L */
#define CSM_C_RX_ID_SystemEnvironment                0x98ff0117L /* 0xc7f8L */
#define CSM_C_RX_ID_CruiseControl                    0x98fef100L /* 0xc7f7L */
#define CSM_C_RX_ID_AmbientConditions                0x98fef517L /* 0xc7f7L */
#define CSM_C_RX_ID_VehicleWeight                    0x98feea17L /* 0xc7f7L */
#define CSM_C_RX_ID_VehiclePosition                  0x98fef34aL /* 0xc7f7L */
#define CSM_C_RX_ID_ETC5                             0x98fec300L /* 0xc7f6L */
#define CSM_C_RX_ID_TCO1                             0x98fe6ceeL /* 0xc7f3L */
#define CSM_C_RX_ID_TimeDate                         0x98fee6eeL /* 0xc7f7L */
#define CSM_C_RX_ID_RemoteControl                    0x98ff0317L /* 0xc7f8L */
#define CSM_C_RX_ID_Illumination                     0x98d0ff17L /* 0xc687L */
#define CSM_C_RX_ID_SystemEnvironmentExtended        0x98ff0517L /* 0xc7f8L */
#define CSM_C_RX_ID_Camera_Request                   0x98ff0617L /* 0xc7f8L */
#define CSM_C_RX_ID_CabinMediaCommand                0x98ff0417L /* 0xc7f8L */

/* CAN2/MCAN */
/*TX*/
#define CSM_C_TX_ID_KeyIllumination1                 0x98ff0b4cL /* 0xc7f8L */
#define CSM_C_TX_ID_KeyIllumination0                 0x98ff0a4cL /* 0xc7f8L */
#define CSM_C_TX_ID_KeyColour1                       0x98ff0d4cL /* 0xc7f8L */
#define CSM_C_TX_ID_KeyColour0                       0x98ff0c4cL /* 0xc7f8L */
#define CSM_C_TX_ID_Req_DeviceInformation            0x98ff0e4cL /* 0xc7f8L */

/*RX*/
#define CSM_C_RX_ID_Remotecontrol                    0x94ff032cL /* 0xa7f8L */
#define CSM_C_RX_ID_Resp_DeviceInformation2          0x98ff0f2cL /* 0xc7f8L */
#define CSM_C_RX_ID_Resp_DeviceInformation1          0x98ff0e2cL /* 0xc7f8L */

#define CSM_C_J1939_MAX_PGN_CALLBACKS 1

#if (CSM_S_J1939 == CSM_C_F_ON)

#define CSM_C_J1939_MAX_USER                3
#define CSM_C_J1939_NODE_OWN                CSM_C_J1939_NODE_RAD
#define CSM_C_J1939_LOCAL_NODES             3 /**< Number of J1939 nodes on this ECU */

tCSM_J1939_APPL_CALLBACK csm_j1939_arApplCallbackFkt[CSM_C_J1939_MAX_USER];

tCSM_J1939_PGN_CALLBACK csm_j1939_arPGNCallbackFkt[CSM_C_J1939_CFG_MAXPGN][CSM_C_J1939_MAX_PGN_CALLBACKS];

tCSM_J1939_PGN_IND_FLAGS csm_j1939_abPGNIndFlags[CSM_C_J1939_CFG_MAXPGN];

static const tCSM_J1939_APPL_CFG csm_j1939_arApplCfg[CSM_C_J1939_MAX_USER] =
{
  {
  CSM_C_CAN_BUS_VCAN,
  CSM_C_J1939_NODE_RAD,
  CSM_C_PTYPE_J1939,
  CSM_C_APPL_ID_VCAN_LOCAL_CTRL_SPM
  },
  {
  CSM_C_CAN_BUS_VCAN,
  CSM_C_J1939_NODE_RAD,
  CSM_C_PTYPE_J1939,
  CSM_C_APPL_ID_VCAN_LOCAL_CTRL_DIA
  },
  {
  CSM_C_CAN_BUS_VCAN,
  CSM_C_J1939_NODE_RAD,
  CSM_C_PTYPE_J1939,
  CSM_C_APPL_ID_VCAN_LOCAL_CTRL_IGNITION
  }
};

#endif
//**************************************************************************************************
//* CSM Timer configuration (Generated code - do NOT change manually !!!)
//**************************************************************************************************
// The timer configuration of the Proxy is totally different from the real CSM !!!
enum
{
  // ATTENTION: adapting the amount of timers here requires further adaptions at other places
  CSM_TIMER_DUMMY = 0,                            // is always needed to have at least 1 entry
  CSM_TIMER_NET_LCTRL,                            // net ctrl
  CSM_TIMER_NET_LCTRL_USER_0,                     // net ctrl user 0 from LCTRL config
  CSM_TIMER_NET_LCTRL_USER_1,                     // net ctrl user 1 from LCTRL config
  CSM_TIMER_NET_OSEKI,                            // net OSEKI
  CSM_TIMER_BRSIGNAL,                             // broadcast
  CSM_TIMER_NP1_COM,                              // np1  -> chn. index 0
  CSM_TIMER_NP1_TX,                            // np1  -> chn. index 0
  CSM_TIMER_NP1_RX,                            // np1  -> chn. index 0
  CSM_TIMER_NP2_COM,                              // np2  -> chn. index 1
  CSM_TIMER_NP2_TX,                            // np2  -> chn. index 1
  CSM_TIMER_NP2_RX,                            // np2  -> chn. index 1
  CSM_TIMER_NP3_COM,                              // np3  -> chn. index 2
  CSM_TIMER_NP3_TX,                            // np3  -> chn. index 2
  CSM_TIMER_NP3_RX,                            // np3  -> chn. index 2
  CSM_TIMER_NP4_COM,                              // np4  -> chn. index 3
  CSM_TIMER_NP4_TX,                            // np4  -> chn. index 3
  CSM_TIMER_NP4_RX,                            // np4  -> chn. index 3
  CSM_TIMER_NP5_COM,                              // np5  -> chn. index 4
  CSM_TIMER_NP5_TX,                            // np5  -> chn. index 4
  CSM_TIMER_NP5_RX,                            // np5  -> chn. index 4
  CSM_TIMER_NP6_COM,                              // np6  -> chn. index 5
  CSM_TIMER_NP6_TX,                            // np6  -> chn. index 5
  CSM_TIMER_NP6_RX,                            // np6  -> chn. index 5
  CSM_TIMER_NP7_COM,                              // np7  -> chn. index 6
  CSM_TIMER_NP7_TX,                            // np7  -> chn. index 6
  CSM_TIMER_NP7_RX,                            // np7  -> chn. index 6
  CSM_TIMER_NP8_COM,                              // np8  -> chn. index 7
  CSM_TIMER_NP8_TX,                            // np8  -> chn. index 7
  CSM_TIMER_NP8_RX,                            // np8  -> chn. index 7
  CSM_TIMER_NP9_COM,                              // np9  -> chn. index 8
  CSM_TIMER_NP9_TX,                            // np9  -> chn. index 8
  CSM_TIMER_NP9_RX,                            // np9  -> chn. index 8
  CSM_TIMER_NP10_COM,                             // np10 -> chn. index 9
  CSM_TIMER_NP10_TX,                           // np10 -> chn. index 9
  CSM_TIMER_NP10_RX,                           // np10 -> chn. index 9
  CSM_TIMER_NP11_COM,                             // np11 -> chn. index 10
  CSM_TIMER_NP11_TX,                           // np11 -> chn. index 10
  CSM_TIMER_NP11_RX,                           // np11 -> chn. index 10
  CSM_MAX_TIMER
};
#define CSM_C_MAX_TIMER    CSM_MAX_TIMER          // make define from enum


/*****************************************************************************/
/* CBR */
/*****************************************************************************/
#if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
#define CBR_M_INIT_VARS()  /**< empty */

#define CBR_MAX_APPL_ID  3

/* DLC for CAN1/VCAN Messages*/
#define CSM_C_DLC_PhoneStatus                   8  /**< data length*/
#define CSM_C_DLC_MediaStatus2                  8  /**< data length*/
#define CSM_C_DLC_MediaStatus1                  8  /**< data length*/
#define CSM_C_DLC_DeviceStatus                  8  /**< data length*/
#define CSM_C_DLC_Camera_Status                 8  /**< data length*/
#define CSM_C_DLC_Display_Mainline              8  /**< data length*/
#define CSM_C_DLC_CabinMedia_Status             8  /**< data length*/
#define CSM_C_DLC_CabinB_Media_Status           8  /**< data length*/
#define CSM_C_DLC_VehiclePositionNav            8  /**< data length*/

#define CSM_C_DLC_MediaCommand                  8  /**< data length*/
#define CSM_C_DLC_SystemEnvironment             8  /**< data length*/
#define CSM_C_DLC_CruiseControl                 8  /**< data length*/
#define CSM_C_DLC_AmbientConditions             8  /**< data length*/
#define CSM_C_DLC_VehicleWeight                 8  /**< data length*/
#define CSM_C_DLC_VehiclePosition               8  /**< data length*/
#define CSM_C_DLC_ETC5                          8  /**< data length*/
#define CSM_C_DLC_TCO1                          8  /**< data length*/
#define CSM_C_DLC_TimeDate                      8  /**< data length*/
#define CSM_C_DLC_RemoteControl                 8  /**< data length*/
#define CSM_C_DLC_Illumination                  8  /**< data length*/
#define CSM_C_DLC_SystemEnvironmentExtended     8  /**< data length*/
#define CSM_C_DLC_Camera_Request                8  /**< data length*/
#define CSM_C_DLC_CabinMediaCommand             8  /**< data length*/

/* DLC for CAN2/MCAN Messages*/
/*TX*/
#define CSM_C_DLC_KeyIllumination1              8  /**< data length*/
#define CSM_C_DLC_KeyIllumination0              8  /**< data length*/
#define CSM_C_DLC_KeyColour1                    8  /**< data length*/
#define CSM_C_DLC_KeyColour0                    8  /**< data length*/
#define CSM_C_DLC_Req_DeviceInformation         1  /**< data length*/

/*RX*/
#define CSM_C_DLC_Remotecontrol                 8  /**< data length*/
#define CSM_C_DLC_Resp_DeviceInformation2       8  /**< data length*/
#define CSM_C_DLC_Resp_DeviceInformation1       8  /**< data length*/

#define CSM_M_GET_SIGNAL_ID_FROM_VIRTUAL_SIGNAL_ID(a) a   /* in case no virtual signals are used.. */
#define CSM_M_CHECK_FOR_VALID_SIGNAL_ID(a)            1   /* in case no virtual signals are used.. */

#endif /* CSM_S_CBR_AVAILABLE */


/*****************************************************************************/
/* CNM_OSEK */
/*****************************************************************************/
#define CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN      2  // max. value of RX monitors
#define NO_OF_ACTIVE_RX_MONITORS_VCAN              2  // configured nr. of RX monitors (refer to cnm_oseki_mp.h)
#define CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN      2

#define CNM_OSEKI_NR_OF_RX_NODE_MONITORS_MCAN      2  // max. value of RX monitors MCAN
#define NO_OF_ACTIVE_RX_MONITORS_MCAN              2  // configured nr. of RX monitors (refer to cnm_oseki_mp.h)
#define CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN      2

#define NO_OF_ACTIVE_BUSOFF_MONITORS               2
#define CSM_NWM_C_MAX_COMMAND_USER                 2   // amount of users using CommunicationReq on OSEKI NM

/* this define is important for the configuration table csm_arNWMCfg[]       */
/* DO NOT change this group -> only change single defines above              */
#define CSM_NWM_C_MAX_USER     ( NO_OF_ACTIVE_RX_MONITORS_VCAN +  \
                                 CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN +  \
                 NO_OF_ACTIVE_RX_MONITORS_MCAN +\
                 CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN +\
                                 NO_OF_ACTIVE_BUSOFF_MONITORS          +  \
                                 CSM_NWM_C_MAX_COMMAND_USER )

//**************************************************************************************************
//* for CSM_STACK_[OS]  (Generated code - do NOT change manually !!!)
//**************************************************************************************************
// CSM Timer OS dependent configuration
#ifdef CSM_STACK_ENV_SELF   // map the following definitions in csm_stack_[OS].c

// Timer Timeout-Callback prototypes
#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_OSEKI_NM == CSM_C_F_ON)
// empty
#endif
#endif

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_MPDT == CSM_C_F_ON)
// empty
#endif

#if (CSM_S_J1939 == CSM_C_F_ON)

/** configuration of own node IDs for Rx/Tx, defines first own node ID and number of following ones */
/** table to link the NodeID to current Node's address */
tCSM_J1939_ADDR cnp_j1939_arActAddrTable[CSM_C_MAX_CAN_BUS][CSM_C_J1939_CFG_MAXNODES] =
{
  {
    {0x00}, /*CSM_C_J1939_NODE_ECU*/
    {0xFB}, /*CSM_C_J1939_NODE_FLM*/
    {0x4A}, /*CSM_C_J1939_NODE_GNSS*/
    {0xEE}, /*CSM_C_J1939_NODE_TCO*/
    {0x17}, /*CSM_C_J1939_NODE_ICL*/
    {0x4C}, /*CSM_C_J1939_NODE_RAD*/
    {0x1C}, /*CSM_C_J1939_NODE_NAV*/
    {0x96}, /*CSM_C_J1939_NODE_PHN*/

    {CSM_J1939_ADDR_NULL},      /*CSM_C_J1939_NODE_NULL*/
    {CSM_J1939_ADDR_BROADCAST}, /*CSM_C_J1939_NODE_BROADCAST*/
  },
};

#define CSM_NP_CCS_CHANNEL_RAD           0x03 // ccs channel number for RAD
#define CSM_NP_CCS_CHANNEL_PHN          0x05 // ccs channel number for PHN
#define CSM_NP_CCS_CHANNEL_NAV           0x04 // ccs channel number for NAV

extern tCSM_J1939_PGN_DATA cnp_j1939_arActPGNTable[CSM_C_J1939_CFG_MAXPGN];

const tCSM_J1939_PGN_CFG cnp_j1939_arCfgPGNTable[CSM_C_J1939_CFG_MAXPGN] =
        {
          /* project specific PGNs */
          /* BUS              PRIO MUTE  PGN     TIME   TXLEN      TXTIMER-ID               RXLEN       RXTIMER-ID            CCS-CHN     */
        /* RAD */
        { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FEF5,  0,     0,   CSM_TIMER_DUMMY,               8,   CSM_TIMER_DUMMY,     CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_AMBIENTCOND_ICAN*/
      { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FEF1,  0,     0,   CSM_TIMER_DUMMY,             8,   CSM_TIMER_DUMMY,      CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_CRUISECONTROL_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FF11,  0,     8,   CSM_TIMER_DUMMY,                0,   CSM_TIMER_DUMMY,      CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_DEVSTATUS_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FE6B,  50,    0,   CSM_TIMER_DUMMY,               10,   CSM_TIMER_DUMMY, CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_DRIVINDI_ICAN*/
        { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FEC3,  0,     0,   CSM_TIMER_DUMMY,               8,   CSM_TIMER_DUMMY,     CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_ETC5_ICAN*/
        { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FF25,  50,    8,   CSM_TIMER_DUMMY,               20,   CSM_TIMER_DUMMY, CSM_NP_CCS_CHANNEL_NAV }, /*CSM_C_J1939_PGN_FltData_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00D0FF,  0,     0,   CSM_TIMER_DUMMY,               8,   CSM_TIMER_DUMMY,     CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_ILLUMINATION_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FF26,  10,    260, CSM_TIMER_DUMMY,       0,   CSM_TIMER_DUMMY,     CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_CABINAMEDIADATA_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FF02,  0,     0,   CSM_TIMER_DUMMY,               8,   CSM_TIMER_DUMMY,      CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_MEDCMD_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FF21,  10,    260, CSM_TIMER_DUMMY,       0,   CSM_TIMER_DUMMY,     CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_MEDDATA_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FF12,  0,     8,   CSM_TIMER_DUMMY,               0,   CSM_TIMER_DUMMY,      CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_MEDSTATE1_ICAN*/
        { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FF13,  0,     8,   CSM_TIMER_DUMMY,               0,   CSM_TIMER_DUMMY,     CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_MEDSTATE2_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FF24,  10,    260, CSM_TIMER_DUMMY,       0,   CSM_TIMER_DUMMY,      CSM_NP_CCS_CHANNEL_NAV }, /*CSM_C_J1939_PGN_NAVDATA_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FF27,  10,    260, CSM_TIMER_DUMMY,      0,   CSM_TIMER_DUMMY,      CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_CABINBMEDIADATA_ICAN*/
        { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FF14,  0,     8,   CSM_TIMER_DUMMY,               0,   CSM_TIMER_DUMMY,      CSM_NP_CCS_CHANNEL_PHN }, /*CSM_C_J1939_PGN_PHNSTATUS_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FF03,  0,     0,   CSM_TIMER_DUMMY,               8,   CSM_TIMER_DUMMY,     CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_REMOTECNTRL_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FF01,  0,     0,   CSM_TIMER_DUMMY,               8,   CSM_TIMER_DUMMY,     CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_SYSENV_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FE6C,  0,     0,   CSM_TIMER_DUMMY,               8,   CSM_TIMER_DUMMY,     CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_TCO1_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FEE6,  0,     0,   CSM_TIMER_DUMMY,               8,   CSM_TIMER_DUMMY,      CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_TIMEDATE_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FEF3,  0,     8,   CSM_TIMER_DUMMY,               8,   CSM_TIMER_DUMMY,      CSM_NP_CCS_CHANNEL_NAV }, /*CSM_C_J1939_PGN_VEHPOS_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FEEA,  0,     0,   CSM_TIMER_DUMMY,               8,   CSM_TIMER_DUMMY,      CSM_NP_CCS_CHANNEL_NAV }, /*CSM_C_J1939_PGN_VEHWt_ICAN*/
    { CSM_C_CAN_BUS_VCAN, 0x6,  1, 0x00FEEC,  0,     50,   CSM_TIMER_DUMMY,               17,   CSM_TIMER_DUMMY,CSM_NP_CCS_CHANNEL_RAD }, /*CSM_C_J1939_PGN_VIN_ICAN*/

          #if (CSM_S_J1939_ERRORMEMORY == CSM_C_F_ON)
        { CSM_C_CAN_BUS_VCAN, 0x6,  0, 0x00FECA,   50,    42, CSM_TIMER_DUMMY,     0, CSM_TIMER_DUMMY,          0xFF}, /*CSM_C_J1939_PGN_DM1*/
        { CSM_C_CAN_BUS_VCAN, 0x6,  0, 0x00FECB,   50,    42, CSM_TIMER_DUMMY,     0, CSM_TIMER_DUMMY,          0xFF}, /*CSM_C_J1939_PGN_DM2*/
        { CSM_C_CAN_BUS_VCAN, 0x6,  0, 0x00FECC,    0,     0, CSM_TIMER_DUMMY,             0, CSM_TIMER_DUMMY,          0xFF}, /*CSM_C_J1939_PGN_DM3*/
        { CSM_C_CAN_BUS_VCAN, 0x6,  0, 0x00FECE,   50,     8, CSM_TIMER_DUMMY,             0, CSM_TIMER_DUMMY,          0xFF}, /*CSM_C_J1939_PGN_DM5*/
        { CSM_C_CAN_BUS_VCAN, 0x6,  0, 0x00FED3,    0,     0, CSM_TIMER_DUMMY,             0, CSM_TIMER_DUMMY,          0xFF}, /*CSM_C_J1939_PGN_DM11*/
        { CSM_C_CAN_BUS_VCAN, 0x6,  0, 0x00C300,    0,     0, CSM_TIMER_DUMMY,             8, CSM_TIMER_DUMMY,          0xFF}, /*CSM_C_J1939_PGN_DM22*/
          #endif
          #if (CSM_S_J1939_STARTSTOP_BROADCAST == CSM_C_F_ON)
        { CSM_C_CAN_BUS_VCAN, 0x6,  0, 0x00DF00,    0,     8, CSM_TIMER_DUMMY,             8, CSM_TIMER_DUMMY          }, /*CSM_C_J1939_PGN_DM13_ICAN*/
          #endif
          #if (CSM_S_J1939_MEMORYACCESS == CSM_C_F_ON)
        { CSM_C_CAN_BUS_VCAN, 0x6,  0, 0x00D900,    0,     0, CSM_TIMER_DUMMY,             8, CSM_TIMER_DUMMY,         0xFF}, /*CSM_C_J1939_PGN_DM14*/
        { CSM_C_CAN_BUS_VCAN, 0x6,  0, 0x00D800,    0,     8, CSM_TIMER_DUMMY,             0, CSM_TIMER_DUMMY,         0xFF}, /*CSM_C_J1939_PGN_DM15*/
        { CSM_C_CAN_BUS_VCAN, 0x6,  0, 0x00D700,    5,   256, CSM_TIMER_DUMMY,   256, CSM_TIMER_DUMMY, 0xFF}, /*CSM_C_J1939_PGN_DM16*/
          #endif
          #if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON )
          #if (CSM_S_J1939_COMMAND_ADDRESS == CSM_C_F_ON)
        { CSM_C_CAN_BUS_VCAN, 0x6,  0, 0x00FED8,   50,     0, CSM_TIMER_DUMMY,             9, CSM_TIMER_DUMMY, 0xFF}, /*CSM_C_J1939_PGN_COMMANDADDRESS_ICAN*/
          #endif
          #endif
        };

#endif
#endif

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_ISO_TP == CSM_C_F_ON)
void CNP_ITP_vTxTimerExpired(DWORD dwValue);
void CNP_ITP_vRxTimerExpired(DWORD dwValue);
#endif
#endif

#if (CSM_S_REMOTE_STACK == CSM_C_F_ON)
  extern void  CSM_PROXY_vTimeout( DWORD wTimerId);
#endif
// ########################################
// _CSM_SECTION2: user specific code start
// ########################################

// #######################################
// _CSM_SECTION2: user specific code end
// #######################################
//**************************************************************************************************
//* CSM Timer instances (Generated code - do NOT change manually !!!)
//**************************************************************************************************
// array with callbacks for timer system
const tCSM_TIMER csm_arTimer[ CSM_MAX_TIMER] =
{
  {NULL, 0}, /* CSM_TIMER_DUMMY */
  {CSM_PROXY_vTimeout,  1},                         // CSM_TIMER_NET_LCTRL
  {CSM_PROXY_vTimeout,  2},                         // CSM_TIMER_NET_LCTRL USER 0 from LCTRL config
  {CSM_PROXY_vTimeout,  3},                         // CSM_TIMER_NET_LCTRL USER 1 from LCTRL config
  {CSM_PROXY_vTimeout,  4},                         // CSM_TIMER_NET_OSEKI
  {CSM_PROXY_vTimeout,  5},                         // CSM_TIMER_BRSIGNAL
  {CSM_PROXY_vTimeout,  6},                         // np1  -> chn. index 0
  {CSM_PROXY_vTimeout,  7},                         // np1  -> chn. index 0
  {CSM_PROXY_vTimeout,  8},                         // np1  -> chn. index 0
  {CSM_PROXY_vTimeout,  9},                         // np2  -> chn. index 1
  {CSM_PROXY_vTimeout, 10},                         // np2  -> chn. index 1
  {CSM_PROXY_vTimeout, 11},                         // np2  -> chn. index 1
  {CSM_PROXY_vTimeout, 12},                         // np3  -> chn. index 2
  {CSM_PROXY_vTimeout, 13},                         // np3  -> chn. index 2
  {CSM_PROXY_vTimeout, 14},                         // np3  -> chn. index 2
  {CSM_PROXY_vTimeout, 15},                         // np4  -> chn. index 3
  {CSM_PROXY_vTimeout, 16},                         // np4  -> chn. index 3
  {CSM_PROXY_vTimeout, 17},                         // np4  -> chn. index 3
  {CSM_PROXY_vTimeout, 18},                         // np5  -> chn. index 4
  {CSM_PROXY_vTimeout, 19},                         // np5  -> chn. index 4
  {CSM_PROXY_vTimeout, 20},                         // np5  -> chn. index 4
  {CSM_PROXY_vTimeout, 21},                         // np6  -> chn. index 5
  {CSM_PROXY_vTimeout, 22},                         // np6  -> chn. index 5
  {CSM_PROXY_vTimeout, 23},                         // np6  -> chn. index 5
  {CSM_PROXY_vTimeout, 24},                         // np7  -> chn. index 6
  {CSM_PROXY_vTimeout, 25},                         // np7  -> chn. index 6
  {CSM_PROXY_vTimeout, 26},                         // np7  -> chn. index 6
  {CSM_PROXY_vTimeout, 27},                         // np8  -> chn. index 7
  {CSM_PROXY_vTimeout, 28},                         // np8  -> chn. index 7
  {CSM_PROXY_vTimeout, 29},                         // np8  -> chn. index 7
  {CSM_PROXY_vTimeout, 30},                         // np9  -> chn. index 8
  {CSM_PROXY_vTimeout, 31},                         // np9  -> chn. index 8
  {CSM_PROXY_vTimeout, 32},                         // np9  -> chn. index 8
  {CSM_PROXY_vTimeout, 33},                         // np10 -> chn. index 9
  {CSM_PROXY_vTimeout, 34},                         // np10 -> chn. index 9
  {CSM_PROXY_vTimeout, 35},                         // np10 -> chn. index 9
  {CSM_PROXY_vTimeout, 36},                         // np11 -> chn. index 10
  {CSM_PROXY_vTimeout, 37},                         // np11 -> chn. index 10
  {CSM_PROXY_vTimeout, 38},                         // np11 -> chn. index 10
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
#if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
  {CBR_vTransmitTimeout, 0},
  {CBR_vTransmitTimeout, 1},
  {CBR_vTransmitTimeout, 2},
  {CBR_vTransmitTimeout, 3},
  {CBR_vTransmitTimeout, 4},
  {CBR_vTransmitTimeout, 5},
  {CBR_vTransmitTimeout, 6},
  {CBR_vTransmitTimeout, 7},
  {CBR_vTransmitTimeout, 8},
  {CBR_vTransmitTimeout, 9},
  {CBR_vTransmitTimeout, 10},
  {CBR_vTransmitTimeout, 11},
  {CBR_vTransmitTimeout, 12},
  {CBR_vTransmitTimeout, 13},
#if (CSM_S_CBR_MIN_DELAY == CSM_C_F_ON)
  {CBR_vTransmitMinDelayTimeout, 0},
  {CBR_vTransmitMinDelayTimeout, 1},
  {CBR_vTransmitMinDelayTimeout, 2},
  {CBR_vTransmitMinDelayTimeout, 3},
  {CBR_vTransmitMinDelayTimeout, 4},
  {CBR_vTransmitMinDelayTimeout, 5},
  {CBR_vTransmitMinDelayTimeout, 6},
  {CBR_vTransmitMinDelayTimeout, 7},
  {CBR_vTransmitMinDelayTimeout, 8},
  {CBR_vTransmitMinDelayTimeout, 9},
  {CBR_vTransmitMinDelayTimeout, 10},
  {CBR_vTransmitMinDelayTimeout, 11},
  {CBR_vTransmitMinDelayTimeout, 12},
  {CBR_vTransmitMinDelayTimeout, 13},
#endif /* CSM_S_CBR_MIN_DELAY */
  {CBR_vReceiveTimeout, 0},
  {CBR_vReceiveTimeout, 1},
  {CBR_vReceiveTimeout, 2},
  {CBR_vReceiveTimeout, 3},
  {CBR_vReceiveTimeout, 4},
  {CBR_vReceiveTimeout, 5},
  {CBR_vReceiveTimeout, 6},
  {CBR_vReceiveTimeout, 7},
  {CBR_vReceiveTimeout, 8},
  {CBR_vReceiveTimeout, 9},
  {CBR_vReceiveTimeout, 10},
  {CBR_vReceiveTimeout, 11},
  {CBR_vReceiveTimeout, 12},
  {CBR_vReceiveTimeout, 13},
  {CBR_vReceiveTimeout, 14},
  {CBR_vReceiveTimeout, 15},
  {CBR_vReceiveTimeout, 16},
#endif /* CSM_S_CBR_AVAILABLE */
#endif /* CSM_S_REMOTE_STACK */
#if (CSM_S_BUS_WAKE_TEMP == CSM_C_F_ON)
  {csm_vWakeTempTimeout, 0},
#endif /* CSM_S_BUS_WAKE_TEMP */

#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_OSEK_NM == CSM_C_F_ON)
  {CSM_vCNMBusoffReinitTimerExpired, 0},
  {CNM_OSEK_vTimer, 0},
#endif /* CSM_S_OSEK_NM */
#endif /* CSM_S_CNM_AVAILABLE */

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_ISO_TP == CSM_C_F_ON)
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CNP_ITP_vTxTimerExpired, 0}, /*CSM_TIMER_ITP_TX_CH0X*/
  {CNP_ITP_vTxTimerExpired, 1}, /*CSM_TIMER_ITP_TX_CH1X*/
  {CNP_ITP_vTxTimerExpired, 2}, /*CSM_TIMER_ITP_TX_CH2X*/

  {CNP_ITP_vRxTimerExpired, 0}, /*CSM_TIMER_ITP_RX_CH0X*/
  {CNP_ITP_vRxTimerExpired, 1}, /*CSM_TIMER_ITP_RX_CH1X*/
  {CNP_ITP_vRxTimerExpired, 2}, /*CSM_TIMER_ITP_RX_CH2X*/
  #endif
#endif /* CSM_S_ISO_TP */
#endif /* CSM_S_CNP_AVAILABLE */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CSM_APL_vUpdateUserData, 0},
#endif /* CSM_S_CNP_AVAILABLE */
};
#endif // CSM_STACK_ENV_SELF



#ifdef CBR_SELF
/*
    SS    SSSSS   S    S    SSSS
   S  S   S       S    S    S   S
   S      S       SS   S    S    S
    S     SSS     SSS  S    S    S
     S    S       S  SSS    S    S
      S   S       S   SS    S    S
   S  S   S       S    S    S   S
    SS    SSSSS   S    S    SSSS
*/
/********************************************/
/* TX Data */
/********************************************/
/*CAN1/VCAN*/
BYTE cbr_aubTX_PhoneStatus_TelData[ CSM_C_DLC_PhoneStatus];
BYTE cbr_aubTX_MediaStatus2_TelData[ CSM_C_DLC_MediaStatus2];
BYTE cbr_aubTX_MediaStatus1_TelData[ CSM_C_DLC_MediaStatus1];
BYTE cbr_aubTX_DeviceStatus_TelData[ CSM_C_DLC_DeviceStatus];
BYTE cbr_aubTX_Camera_Status_TelData[ CSM_C_DLC_Camera_Status];
BYTE cbr_aubTX_Display_Mainline_TelData[ CSM_C_DLC_Display_Mainline];
BYTE cbr_aubTX_CabinMedia_Status_TelData[ CSM_C_DLC_CabinMedia_Status];
BYTE cbr_aubTX_CabinB_Media_Status_TelData[ CSM_C_DLC_CabinB_Media_Status];
BYTE cbr_aubTX_VehiclePositionNav_TelData[ CSM_C_DLC_VehiclePositionNav];

/*CAN2/MCAN*/
BYTE cbr_aubTX_KeyIllumination1_TelData[ CSM_C_DLC_KeyIllumination1];
BYTE cbr_aubTX_KeyIllumination0_TelData[ CSM_C_DLC_KeyIllumination0];
BYTE cbr_aubTX_KeyColour1_TelData[ CSM_C_DLC_KeyColour1];
BYTE cbr_aubTX_KeyColour0_TelData[ CSM_C_DLC_KeyColour0];
BYTE cbr_aubTX_Req_DeviceInformation_TelData[ CSM_C_DLC_Req_DeviceInformation];

//*****************************************************************************/
/* TX_PhoneStatus */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_PhoneStatusSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 0,  64),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* PhoneStatus */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Roaming */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24, 16),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CallDuration */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* PhoneBatteryLevel */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* GSMFieldstrength */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CallHistorySyncStatus */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* PhonebookSyncStatus */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  4,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CallStatus */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL }   /* BTlinkStatus */
};

const BYTE cbr_aubTX_PhoneStatus_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0x03,0,0};

/***********************/
const CSM_TELEGRAM cbr_aubTX_PhoneStatus =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_PhoneStatusSignals),
/* prSignals */                 cbr_aubTX_PhoneStatusSignals,
/* pvTeleGramDefaultData */     cbr_aubTX_PhoneStatus_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_MediaStatus2 */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_MediaStatus2Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 64),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* MediaStatus2 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40, 16),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CurrTrackNum */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* PlaylistMode */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 28,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* RepeatState */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* MixState */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* SeekState */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* PlayState */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 16),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* TrackTime */
};

const BYTE cbr_aubTX_MediaStatus2_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0x03,0xFF,0xFF,0};

/***********************/
const CSM_TELEGRAM cbr_aubTX_MediaStatus2 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_MediaStatus2Signals),
/* prSignals */                 cbr_aubTX_MediaStatus2Signals,
/* pvTeleGramDefaultData */     cbr_aubTX_MediaStatus2_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_MediaStatus1 */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_MediaStatus1Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 0,  64),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* MediaStatus1 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  5),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* TunerPreset */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  6),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* TunerBand */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 26,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* DABFMstatus */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* TPEGRTMstatus */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 22,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* TPEGstatus */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* TAstatus */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 18,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* TPstatus */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* RDSstatus */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 10,  6),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Volume */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* MuteStatus */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  6),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* AudioSource */
};

const BYTE cbr_aubTX_MediaStatus1_DefaultData[] = {0x3F,0xFF,0xFF,0x0F,0x3F,0x0F,0,0};

/***********************/
const CSM_TELEGRAM cbr_aubTX_MediaStatus1 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_MediaStatus1Signals),
/* prSignals */                 cbr_aubTX_MediaStatus1Signals,
/* pvTeleGramDefaultData */     cbr_aubTX_MediaStatus1_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_DeviceStatus */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_DeviceStatusSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 64),  CBR_TMSG_CYCLIC, 0, NULL },  /* DeviceStatus */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 60,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* Radio_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 58,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* Wifi_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* BluetoothStatus */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 50,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* NavData_Present */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* Camera2_Present */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 46,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* Camera1_Present */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 44,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* SDcard2_Present */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 42,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* SDcard1_Present */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* USB2_Present */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 38,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* USB1_Present */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 36,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* AUX2_PlugPresent */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 34,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* AUX1_PlugPresent */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* CD_Present */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 28,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* Wifi_Avail */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 26,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* Navigation_Avail */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* Phone_Avail */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 22,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* SourceCamera2_Avail */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* SourceCamera1_Avail */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 18,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* SourceBluetooth_Avail */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* SourceSDcard2_Avail */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 14,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* SourceSDcard1_Avail */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* SourceUSB2_Avail */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 10,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* SourceUSB1_Avail */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* SourceAUX2_Avail */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  6,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* SourceAUX1_Avail */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  4,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* SourceCD_Avail */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* SourceDAB_Avail */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* SourceAMFM_Avail */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 30,  2),  CBR_TMSG_CYCLIC, 0, NULL },  /* Phone_VR_Avail */
};

const BYTE cbr_aubTX_DeviceStatus_DefaultData[] = {0xFF,0xFF,0xFF,0x3F,0xFF,0xFF,0x0F,0x3F};

/***********************/
const CSM_TELEGRAM cbr_aubTX_DeviceStatus =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_DeviceStatusSignals),
/* prSignals */                 cbr_aubTX_DeviceStatusSignals,
/* pvTeleGramDefaultData */     cbr_aubTX_DeviceStatus_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_Camera_Status */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_Camera_StatusSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 64),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera17_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 38,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera16_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 36,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera15_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 34,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera14_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera13_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 30,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera12_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 28,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera11_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 26,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera10_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera9_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 22,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera8_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera7_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 18,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera6_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera5_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 14,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera4_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera3_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 10,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera2_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Camera1_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* DisplayCameraCIs_Rq */
};

const BYTE cbr_aubTX_Camera_Status_DefaultData[] = {0x03,0xFF,0xFF,0xFF,0xFF,0x03,0,0};

/***********************/
const CSM_TELEGRAM cbr_aubTX_Camera_Status =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_Camera_StatusSignals),
/* prSignals */                 cbr_aubTX_Camera_StatusSignals,
/* pvTeleGramDefaultData */     cbr_aubTX_Camera_Status_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_Display_Mainline */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_Display_MainlineSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 64),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Display_Mainline */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Mainline_Char8 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Mainline_Char7 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Mainline_Char6 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Mainline_Char5 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Mainline_Char4 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Mainline_Char3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Mainline_Char2 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Mainline_Char1 */
};

const BYTE cbr_aubTX_Display_Mainline_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};

/***********************/
const CSM_TELEGRAM cbr_aubTX_Display_Mainline =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_Display_MainlineSignals),
/* prSignals */                 cbr_aubTX_Display_MainlineSignals,
/* pvTeleGramDefaultData */     cbr_aubTX_Display_Mainline_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_CabinMedia_Status */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_CabinMedia_StatusSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 64),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinMedia_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 60,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* RepeatState */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* MixState */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 52,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* SeekState */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* PlayState */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32, 16),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* TrackTime */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 22,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* PlaylistMode */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  5),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* TunerPreset */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  6),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* TunerBand */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 10,  6),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Cabin_vol */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinMute_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  6),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinAudioSource */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  6,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* Drv_Announcement */
};

const BYTE cbr_aubTX_CabinMedia_Status_DefaultData[] = {0xFF,0xFF,0xFF,0x1F,0xFF,0xFF,0xFF,0xFF};

/***********************/
const CSM_TELEGRAM cbr_aubTX_CabinMedia_Status =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_CabinMedia_StatusSignals),
/* prSignals */                 cbr_aubTX_CabinMedia_StatusSignals,
/* pvTeleGramDefaultData */     cbr_aubTX_CabinMedia_Status_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_CabinB_Media_Status */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_CabinB_Media_StatusSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 64),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinB_Media_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  6),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinB_AudioSource */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 60,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinB_Repeat_State */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinB_Mix_State */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 52,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinB_Seek_State */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  4),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinB_Play_State */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32, 16),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinB_Track_Time */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 22,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinB_PlaylistMode */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  5),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinB_Tuner_PresetStation */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  6),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinB_Tuner_Band */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 10,  6),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinB_Vol */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinB_Mute_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  6,  2),  CBR_TMSG_CYCLIC_AND_SPONTAN, 0, NULL },  /* CabinB_DrvAnnouncement */
};

const BYTE cbr_aubTX_CabinB_Media_Status_DefaultData[] = {0xFF,0xFF,0xFF,0x1F,0xFF,0xFF,0xFF,0xFF};

/***********************/
const CSM_TELEGRAM cbr_aubTX_CabinB_Media_Status =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_CabinB_Media_StatusSignals),
/* prSignals */                 cbr_aubTX_CabinB_Media_StatusSignals,
/* pvTeleGramDefaultData */     cbr_aubTX_CabinB_Media_Status_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_VehiclePositionNav */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_VehiclePositionNavSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 64),  CBR_TMSG_NO_TRANSMISSION, 0, NULL },  /* VehiclePositionNav */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32, 32),  CBR_TMSG_NO_TRANSMISSION, 0, NULL },  /* Longitude */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 32),  CBR_TMSG_NO_TRANSMISSION, 0, NULL },  /* Latitude */
};

const BYTE cbr_aubTX_VehiclePositionNav_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};

/***********************/
const CSM_TELEGRAM cbr_aubTX_VehiclePositionNav =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_VehiclePositionNavSignals),
/* prSignals */                 cbr_aubTX_VehiclePositionNavSignals,
/* pvTeleGramDefaultData */     cbr_aubTX_VehiclePositionNav_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};


/*****************************************************************************/
/* TX_KeyIllumination1 */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_KeyIllumination1Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 0,  64),  CBR_TMSG_CYCLIC, 0, NULL },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Reserved */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Reserved */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Encoder2_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Encoder1_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key12_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key11_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key10_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key9_Illumination */
};

const BYTE cbr_aubTX_KeyIllumination1_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};

/***********************/
const CSM_TELEGRAM cbr_aubTX_KeyIllumination1 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_KeyIllumination1Signals),
/* prSignals */                 cbr_aubTX_KeyIllumination1Signals,
/* pvTeleGramDefaultData */     cbr_aubTX_KeyIllumination1_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_KeyIllumination0 */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_KeyIllumination0Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 0,  64),  CBR_TMSG_CYCLIC, 0, NULL },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key8_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key7_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key6_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key5_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key4_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key3_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key2_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key1_Illumination */
};

const BYTE cbr_aubTX_KeyIllumination0_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};

/***********************/
const CSM_TELEGRAM cbr_aubTX_KeyIllumination0 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_KeyIllumination0Signals),
/* prSignals */                 cbr_aubTX_KeyIllumination0Signals,
/* pvTeleGramDefaultData */     cbr_aubTX_KeyIllumination0_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_KeyColour1 */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_KeyColour1Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 0,   64),  CBR_TMSG_CYCLIC, 0, NULL },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Reserved */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Reserved */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Enconder2_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Enconder1_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key12_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key11_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key9_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key10_Colour */
};

const BYTE cbr_aubTX_KeyColour1_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};

/***********************/
const CSM_TELEGRAM cbr_aubTX_KeyColour1 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_KeyColour1Signals),
/* prSignals */                 cbr_aubTX_KeyColour1Signals,
/* pvTeleGramDefaultData */     cbr_aubTX_KeyColour1_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_KeyColour0 */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_KeyColour0Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 0,  64),  CBR_TMSG_CYCLIC, 0, NULL },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key8_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key7_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key6_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key5_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key4_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key3_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key2_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key1_Colour */
};

const BYTE cbr_aubTX_KeyColour0_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};

/***********************/
const CSM_TELEGRAM cbr_aubTX_KeyColour0 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_KeyColour0Signals),
/* prSignals */                 cbr_aubTX_KeyColour0Signals,
/* pvTeleGramDefaultData */     cbr_aubTX_KeyColour0_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_Req_DeviceInformation */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_Req_DeviceInformationSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CBR_TMSG_SPONTAN, 0, NULL },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CBR_TMSG_SPONTAN, 0, NULL },  /* Req_DeviceInformation */
};

const BYTE cbr_aubTX_Req_DeviceInformation_DefaultData[] = {0};

/***********************/
const CSM_TELEGRAM cbr_aubTX_Req_DeviceInformation =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_Req_DeviceInformationSignals),
/* prSignals */                 cbr_aubTX_Req_DeviceInformationSignals,
/* pvTeleGramDefaultData */     cbr_aubTX_Req_DeviceInformation_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};


/*
    RRR    RRRRR    RRRR   RRRRR    R    R     R   RRRRR
    R  R   R       R       R             R     R   R
    R   R  R       R       R        R     R   R    R
    R   R  RRR     R       RRR      R     R   R    RR
    RRRR   R       R       R        R      R R     R
    R  R   R       R       R        R      R R     R
    R   R  R       R       R        R       R      R
    R   R  RRRRR    RRRR   RRRRR   RRR      R      RRRRR
*/

/********************************************/
/* RX Data */
/********************************************/
/*CAN1/VCAN*/
BYTE cbr_aubRX_MediaCommand_TelData[ CSM_C_DLC_MediaCommand];
BYTE cbr_aubRX_SystemEnvironment_TelData[ CSM_C_DLC_SystemEnvironment];
BYTE cbr_aubRX_CruiseControl_TelData[ CSM_C_DLC_CruiseControl];
BYTE cbr_aubRX_AmbientConditions_TelData[ CSM_C_DLC_AmbientConditions];
BYTE cbr_aubRX_VehicleWeight_TelData[ CSM_C_DLC_VehicleWeight];
BYTE cbr_aubRX_VehiclePosition_TelData[ CSM_C_DLC_VehiclePosition];
BYTE cbr_aubRX_ETC5_TelData[ CSM_C_DLC_ETC5];
BYTE cbr_aubRX_TCO1_TelData[ CSM_C_DLC_TCO1];
BYTE cbr_aubRX_TimeDate_TelData[ CSM_C_DLC_TimeDate];
BYTE cbr_aubRX_RemoteControl_TelData[ CSM_C_DLC_RemoteControl];
BYTE cbr_aubRX_Illumination_TelData[ CSM_C_DLC_Illumination];
BYTE cbr_aubRX_SystemEnvironmentExtended_TelData[ CSM_C_DLC_SystemEnvironmentExtended];
BYTE cbr_aubRX_Camera_Request_TelData[ CSM_C_DLC_Camera_Request];
BYTE cbr_aubRX_CabinMediaCommand_TelData[ CSM_C_DLC_CabinMediaCommand];

/*CAN2/MCAN*/
BYTE cbr_aubRX_Remotecontrol_TelData[ CSM_C_DLC_Remotecontrol];
BYTE cbr_aubRX_Resp_DeviceInformation2_TelData[ CSM_C_DLC_Resp_DeviceInformation2];
BYTE cbr_aubRX_Resp_DeviceInformation1_TelData[ CSM_C_DLC_Resp_DeviceInformation1];

/*****************************************************************************/
/* RX_MediaCommand */
/*****************************************************************************/
#define CBR_C_SIG_RX_MediaCommand_NUM_CALLBACK                              3
#define CBR_C_SIG_RX_MediaCommand_Smartphone_Voice_Recognition_NUM_CALLBACK    3
#define CBR_C_SIG_RX_MediaCommand_Voice_recognition_command_NUM_CALLBACK    3
#define CBR_C_SIG_RX_MediaCommand_TrackCmd_NUM_CALLBACK                     3
#define CBR_C_SIG_RX_MediaCommand_PhoneCallCmd_NUM_CALLBACK                 3
#define CBR_C_SIG_RX_MediaCommand_PhonePwrCmd_NUM_CALLBACK                  3
#define CBR_C_SIG_RX_MediaCommand_PlaylistCmd_NUM_CALLBACK                  3
#define CBR_C_SIG_RX_MediaCommand_RDScmd_NUM_CALLBACK                       3
#define CBR_C_SIG_RX_MediaCommand_TAcmd_NUM_CALLBACK                        3
#define CBR_C_SIG_RX_MediaCommand_TunerCmd_NUM_CALLBACK                     3
#define CBR_C_SIG_RX_MediaCommand_VolumeCmd_NUM_CALLBACK                    3
#define CBR_C_SIG_RX_MediaCommand_SourceCmd_NUM_CALLBACK                    3
#define CBR_C_SIG_RX_MediaCommand_RadioPwrCmd_NUM_CALLBACK                  3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_MediaCommand[ CBR_C_SIG_RX_MediaCommand_NUM_CALLBACK] = { CCS_BR_vCSMSigInd };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_MediaCommand_Smartphone_Voice_Recognition[ CBR_C_SIG_RX_MediaCommand_Smartphone_Voice_Recognition_NUM_CALLBACK] = { NULL};
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_MediaCommand_Voice_recognition_command[ CBR_C_SIG_RX_MediaCommand_Voice_recognition_command_NUM_CALLBACK] = {NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_MediaCommand_TrackCmd[ CBR_C_SIG_RX_MediaCommand_TrackCmd_NUM_CALLBACK] = {NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_MediaCommand_PhoneCallCmd[ CBR_C_SIG_RX_MediaCommand_PhoneCallCmd_NUM_CALLBACK] = {NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_MediaCommand_PhonePwrCmd[ CBR_C_SIG_RX_MediaCommand_PhonePwrCmd_NUM_CALLBACK] = {NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_MediaCommand_PlaylistCmd[ CBR_C_SIG_RX_MediaCommand_PlaylistCmd_NUM_CALLBACK] = {NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_MediaCommand_RDScmd[ CBR_C_SIG_RX_MediaCommand_RDScmd_NUM_CALLBACK] = {NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_MediaCommand_TAcmd[ CBR_C_SIG_RX_MediaCommand_TAcmd_NUM_CALLBACK] = {NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_MediaCommand_TunerCmd[ CBR_C_SIG_RX_MediaCommand_TunerCmd_NUM_CALLBACK] = {NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_MediaCommand_VolumeCmd[ CBR_C_SIG_RX_MediaCommand_VolumeCmd_NUM_CALLBACK] = {NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_MediaCommand_SourceCmd[ CBR_C_SIG_RX_MediaCommand_SourceCmd_NUM_CALLBACK] = {NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_MediaCommand_RadioPwrCmd[ CBR_C_SIG_RX_MediaCommand_RadioPwrCmd_NUM_CALLBACK] = {NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_MediaCommand[ CBR_C_SIG_RX_MediaCommand_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_MediaCommand_Smartphone_Voice_Recognition[ CBR_C_SIG_RX_MediaCommand_Smartphone_Voice_Recognition_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_MediaCommand_Voice_recognition_command[ CBR_C_SIG_RX_MediaCommand_Voice_recognition_command_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_MediaCommand_TrackCmd[ CBR_C_SIG_RX_MediaCommand_TrackCmd_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_MediaCommand_PhoneCallCmd[ CBR_C_SIG_RX_MediaCommand_PhoneCallCmd_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_MediaCommand_PhonePwrCmd[ CBR_C_SIG_RX_MediaCommand_PhonePwrCmd_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_MediaCommand_PlaylistCmd[ CBR_C_SIG_RX_MediaCommand_PlaylistCmd_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_MediaCommand_RDScmd[ CBR_C_SIG_RX_MediaCommand_RDScmd_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_MediaCommand_TAcmd[ CBR_C_SIG_RX_MediaCommand_TAcmd_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_MediaCommand_TunerCmd[ CBR_C_SIG_RX_MediaCommand_TunerCmd_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_MediaCommand_VolumeCmd[ CBR_C_SIG_RX_MediaCommand_VolumeCmd_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_MediaCommand_SourceCmd[ CBR_C_SIG_RX_MediaCommand_SourceCmd_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_MediaCommand_RadioPwrCmd[ CBR_C_SIG_RX_MediaCommand_RadioPwrCmd_NUM_CALLBACK] = {{ NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_MediaCommandSignals[] =
{
   /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_MediaCommand*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_NUM_CALLBACK, cbr_apfnSIG_RX_MediaCommand }, /* MediaCommand*/
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_Voice_recognition_command_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_Voice_recognition_command }, /* Voice_recognition_command */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_TrackCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_TrackCmd }, /* TrackCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 42,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_PhoneCallCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_PhoneCallCmd }, /* PhoneCallCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_PhonePwrCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_PhonePwrCmd }, /* PhonePwrCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_PlaylistCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_PlaylistCmd }, /* PlaylistCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 18,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_RDScmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_RDScmd }, /* RDScmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_TAcmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_TAcmd }, /* TAcmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_TunerCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_TunerCmd }, /* TunerCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_VolumeCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_VolumeCmd }, /* VolumeCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  6),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_SourceCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_SourceCmd }, /* SourceCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_RadioPwrCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_RadioPwrCmd }, /* RadioPwrCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 50,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_Smartphone_Voice_Recognition_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_Smartphone_Voice_Recognition }, /* Smartphone_Voice_Recognition */
#else
  {0, CSM_C_DLC_MediaCommand*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_NUM_CALLBACK, cbr_apfnSIG_RX_MediaCommand }, /* MediaCommand */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_Voice_recognition_command_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_Voice_recognition_command }, /* Voice_recognition_command */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_TrackCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_TrackCmd }, /* TrackCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 42,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_PhoneCallCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_PhoneCallCmd }, /* PhoneCallCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_PhonePwrCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_PhonePwrCmd }, /* PhonePwrCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_PlaylistCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_PlaylistCmd }, /* PlaylistCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 18,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_RDScmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_RDScmd }, /* RDScmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_TAcmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_TAcmd }, /* TAcmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_TunerCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_TunerCmd }, /* TunerCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_VolumeCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_VolumeCmd }, /* VolumeCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  6),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_SourceCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_SourceCmd }, /* SourceCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_RadioPwrCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_RadioPwrCmd }, /* RadioPwrCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 50,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_MediaCommand_Smartphone_Voice_Recognition_NUM_CALLBACK ,cbr_apfnSIG_RX_MediaCommand_Smartphone_Voice_Recognition }, /* Smartphone_Voice_Recognition */
#endif
};
const BYTE cbr_aubRX_MediaCommand_DefaultData[] = {0xFF,0xFF,0xFF,0x03,0,0x3F,0x03,0};
const BYTE cbr_aubRX_MediaCommand_TimeoutData[] = {0,0,0,0,0,0,0,0};


/***********************/
const CSM_TELEGRAM cbr_aubRX_MediaCommand =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_MediaCommandSignals),
/* prSignals */                 cbr_aubRX_MediaCommandSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_MediaCommand_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_MediaCommand_TimeoutData,
/* pvTelegramTimeOutMask */     NULL

};

/*****************************************************************************/
/* RX_SystemEnvironment */
/*****************************************************************************/
#define CBR_C_SIG_RX_SystemEnvironment_NUM_CALLBACK                     3
#define CBR_C_SIG_RX_SystemEnvironment_Time_Mode_NUM_CALLBACK           3
#define CBR_C_SIG_RX_SystemEnvironment_Dimming_Mode_NUM_CALLBACK        3
#define CBR_C_SIG_RX_SystemEnvironment_FrontCamReq_NUM_CALLBACK         3
#define CBR_C_SIG_RX_SystemEnvironment_RearCamReq_NUM_CALLBACK          3
#define CBR_C_SIG_RX_SystemEnvironment_CamouflageMode_NUM_CALLBACK      3
#define CBR_C_SIG_RX_SystemEnvironment_SystemMute_NUM_CALLBACK          3
#define CBR_C_SIG_RX_SystemEnvironment_DistanceScale_NUM_CALLBACK       3
#define CBR_C_SIG_RX_SystemEnvironment_TemperatureScale_NUM_CALLBACK    3
#define CBR_C_SIG_RX_SystemEnvironment_SystemLanguage_NUM_CALLBACK      3
#define CBR_C_SIG_RX_SystemEnvironment_VehicleMileage_NUM_CALLBACK      3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironment[CBR_C_SIG_RX_SystemEnvironment_NUM_CALLBACK]= { CCS_BR_vCSMSigInd };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironment_Time_Mode[ CBR_C_SIG_RX_SystemEnvironment_Time_Mode_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironment_Dimming_Mode[ CBR_C_SIG_RX_SystemEnvironment_Dimming_Mode_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironment_FrontCamReq[ CBR_C_SIG_RX_SystemEnvironment_FrontCamReq_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironment_RearCamReq[ CBR_C_SIG_RX_SystemEnvironment_RearCamReq_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironment_CamouflageMode[ CBR_C_SIG_RX_SystemEnvironment_CamouflageMode_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironment_SystemMute[ CBR_C_SIG_RX_SystemEnvironment_SystemMute_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironment_DistanceScale[ CBR_C_SIG_RX_SystemEnvironment_DistanceScale_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironment_TemperatureScale[ CBR_C_SIG_RX_SystemEnvironment_TemperatureScale_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironment_SystemLanguage[ CBR_C_SIG_RX_SystemEnvironment_SystemLanguage_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironment_VehicleMileage[ CBR_C_SIG_RX_SystemEnvironment_VehicleMileage_NUM_CALLBACK] = { NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironment[CBR_C_SIG_RX_SystemEnvironment_NUM_CALLBACK]= {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironment_Time_Mode[ CBR_C_SIG_RX_SystemEnvironment_Time_Mode_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironment_Dimming_Mode[ CBR_C_SIG_RX_SystemEnvironment_Dimming_Mode_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironment_FrontCamReq[ CBR_C_SIG_RX_SystemEnvironment_FrontCamReq_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironment_RearCamReq[ CBR_C_SIG_RX_SystemEnvironment_RearCamReq_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironment_CamouflageMode[ CBR_C_SIG_RX_SystemEnvironment_CamouflageMode_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironment_SystemMute[ CBR_C_SIG_RX_SystemEnvironment_SystemMute_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironment_DistanceScale[ CBR_C_SIG_RX_SystemEnvironment_DistanceScale_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironment_TemperatureScale[ CBR_C_SIG_RX_SystemEnvironment_TemperatureScale_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironment_SystemLanguage[ CBR_C_SIG_RX_SystemEnvironment_SystemLanguage_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironment_VehicleMileage[ CBR_C_SIG_RX_SystemEnvironment_VehicleMileage_NUM_CALLBACK] = {{ NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_SystemEnvironmentSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_SystemEnvironment*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_NUM_CALLBACK, cbr_apfnSIG_RX_SystemEnvironment },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 54,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_Time_Mode_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_Time_Mode }, /* Time_Mode */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 52,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_Dimming_Mode_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_Dimming_Mode }, /* Dimming_Mode */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 62,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_FrontCamReq_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_FrontCamReq }, /* FrontCamReq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 60,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_RearCamReq_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_RearCamReq }, /* RearCamReq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 58,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_CamouflageMode_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_CamouflageMode }, /* CamouflageMode */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_SystemMute_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_SystemMute }, /* SystemMute */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 50,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_DistanceScale_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_DistanceScale }, /* DistanceScale */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_TemperatureScale_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_TemperatureScale }, /* TemperatureScale */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_SystemLanguage_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_SystemLanguage }, /* SystemLanguage */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 32),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_VehicleMileage_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_VehicleMileage }, /* VehicleMileage */
#else
  {0, CSM_C_DLC_SystemEnvironment*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_NUM_CALLBACK, cbr_apfnSIG_RX_SystemEnvironment },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 54,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_Time_Mode_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_Time_Mode }, /* Time_Mode */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 52,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_Dimming_Mode_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_Dimming_Mode }, /* Dimming_Mode */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 62,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_FrontCamReq_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_FrontCamReq }, /* FrontCamReq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 60,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_RearCamReq_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_RearCamReq }, /* RearCamReq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 58,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_CamouflageMode_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_CamouflageMode }, /* CamouflageMode */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_SystemMute_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_SystemMute }, /* SystemMute */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 50,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_DistanceScale_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_DistanceScale }, /* DistanceScale */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_TemperatureScale_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_TemperatureScale }, /* TemperatureScale */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_SystemLanguage_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_SystemLanguage }, /* SystemLanguage */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 32),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironment_VehicleMileage_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironment_VehicleMileage }, /* VehicleMileage */
#endif
};

const BYTE cbr_aubRX_SystemEnvironment_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
const BYTE cbr_aubRX_SystemEnvironment_TimeoutData[] = {0,0,0,0,0,0,0,0};

/***********************/
const CSM_TELEGRAM cbr_aubRX_SystemEnvironment =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_SystemEnvironmentSignals),
/* prSignals */                 cbr_aubRX_SystemEnvironmentSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_SystemEnvironment_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_SystemEnvironment_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};


/*****************************************************************************/
/* RX_CruiseControl */
/*****************************************************************************/
#define CBR_C_SIG_RX_CruiseControl_NUM_CALLBACK                         3
#define CBR_C_SIG_RX_CruiseControl_VehicleSpeed_NUM_CALLBACK            3
#define CBR_C_SIG_RX_CruiseControl_ParkingBreakSwitch_NUM_CALLBACK      3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CruiseControl[ CBR_C_SIG_RX_CruiseControl_NUM_CALLBACK] = { CCS_BR_vCSMSigInd };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CruiseControl_VehicleSpeed[ CBR_C_SIG_RX_CruiseControl_VehicleSpeed_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CruiseControl_ParkingBreakSwitch[ CBR_C_SIG_RX_CruiseControl_ParkingBreakSwitch_NUM_CALLBACK] = { NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CruiseControl[ CBR_C_SIG_RX_CruiseControl_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CruiseControl_VehicleSpeed[ CBR_C_SIG_RX_CruiseControl_VehicleSpeed_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CruiseControl_ParkingBreakSwitch[ CBR_C_SIG_RX_CruiseControl_ParkingBreakSwitch_NUM_CALLBACK] = {{ NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_CruiseControlSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_CruiseControl*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CruiseControl_NUM_CALLBACK, cbr_apfnSIG_RX_CruiseControl },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8, 16),  CSM_C_ALWAYS_IND, CBR_C_SIG_RX_CruiseControl_VehicleSpeed_NUM_CALLBACK ,cbr_apfnSIG_RX_CruiseControl_VehicleSpeed }, /* VehicleSpeed */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CruiseControl_ParkingBreakSwitch_NUM_CALLBACK ,cbr_apfnSIG_RX_CruiseControl_ParkingBreakSwitch }, /* ParkingBreakSwitch */
#else
  {0, CSM_C_DLC_CruiseControl*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CruiseControl_NUM_CALLBACK, cbr_apfnSIG_RX_CruiseControl },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CruiseControl_VehicleSpeed_NUM_CALLBACK ,cbr_apfnSIG_RX_CruiseControl_VehicleSpeed }, /* VehicleSpeed */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CruiseControl_ParkingBreakSwitch_NUM_CALLBACK ,cbr_apfnSIG_RX_CruiseControl_ParkingBreakSwitch }, /* ParkingBreakSwitch */
#endif
};
const BYTE cbr_aubRX_CruiseControl_DefaultData[] = {0x0C,0xFF,0xFF,0,0,0,0,0};
const BYTE cbr_aubRX_CruiseControl_TimeoutData[] = {0,0,0,0,0,0,0,0};

/***********************/
const CSM_TELEGRAM cbr_aubRX_CruiseControl =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_CruiseControlSignals),
/* prSignals */                 cbr_aubRX_CruiseControlSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_CruiseControl_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_CruiseControl_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_AmbientConditions */
/*****************************************************************************/
#define CBR_C_SIG_RX_AmbientConditions_NUM_CALLBACK                        3
#define CBR_C_SIG_RX_AmbientConditions_AmbientAirTemp_NUM_CALLBACK         3
#define CBR_C_SIG_RX_AmbientConditions_CabInteriorTemp_NUM_CALLBACK        3


#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_AmbientConditions[CBR_C_SIG_RX_AmbientConditions_NUM_CALLBACK] = { CCS_BR_vCSMSigInd };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_AmbientConditions_AmbientAirTemp[ CBR_C_SIG_RX_AmbientConditions_AmbientAirTemp_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_AmbientConditions_CabInteriorTemp[ CBR_C_SIG_RX_AmbientConditions_CabInteriorTemp_NUM_CALLBACK] = { NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_AmbientConditions[CBR_C_SIG_RX_AmbientConditions_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_AmbientConditions_AmbientAirTemp[ CBR_C_SIG_RX_AmbientConditions_AmbientAirTemp_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_AmbientConditions_CabInteriorTemp[ CBR_C_SIG_RX_AmbientConditions_CabInteriorTemp_NUM_CALLBACK] = {{ NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_AmbientConditionsSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_AmbientConditions*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_AmbientConditions_NUM_CALLBACK, cbr_apfnSIG_RX_AmbientConditions },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_AmbientConditions_AmbientAirTemp_NUM_CALLBACK ,cbr_apfnSIG_RX_AmbientConditions_AmbientAirTemp }, /* AmbientAirTemp */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_AmbientConditions_CabInteriorTemp_NUM_CALLBACK ,cbr_apfnSIG_RX_AmbientConditions_CabInteriorTemp }, /* CabInteriorTemp */
#else
  {0, CSM_C_DLC_AmbientConditions*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_AmbientConditions_NUM_CALLBACK, cbr_apfnSIG_RX_AmbientConditions },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_AmbientConditions_AmbientAirTemp_NUM_CALLBACK ,cbr_apfnSIG_RX_AmbientConditions_AmbientAirTemp }, /* AmbientAirTemp */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_AmbientConditions_CabInteriorTemp_NUM_CALLBACK ,cbr_apfnSIG_RX_AmbientConditions_CabInteriorTemp }, /* CabInteriorTemp */
#endif
};

const BYTE cbr_aubRX_AmbientConditions_DefaultData[] = {0,0xFF,0xFF,0xFF,0xFF,0,0,0};
const BYTE cbr_aubRX_AmbientConditions_TimeoutData[] = {0,0,0,0,0,0,0,0};

/***********************/
const CSM_TELEGRAM cbr_aubRX_AmbientConditions =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_AmbientConditionsSignals),
/* prSignals */                 cbr_aubRX_AmbientConditionsSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_AmbientConditions_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_AmbientConditions_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_VehicleWeight */
/*****************************************************************************/

#define CBR_C_SIG_RX_VehicleWeight_NUM_CALLBACK                         3
#define CBR_C_SIG_RX_VehicleWeight_CargoWeight_NUM_CALLBACK             3
#define CBR_C_SIG_RX_VehicleWeight_TrailerWeight_NUM_CALLBACK           3
#define CBR_C_SIG_RX_VehicleWeight_AxleWeight_NUM_CALLBACK              3
#define CBR_C_SIG_RX_VehicleWeight_AxleLocation_NUM_CALLBACK            3


#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_VehicleWeight[ CBR_C_SIG_RX_VehicleWeight_NUM_CALLBACK] = { CCS_BR_vCSMSigInd };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_VehicleWeight_CargoWeight[ CBR_C_SIG_RX_VehicleWeight_CargoWeight_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_VehicleWeight_TrailerWeight[ CBR_C_SIG_RX_VehicleWeight_TrailerWeight_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_VehicleWeight_AxleWeight[ CBR_C_SIG_RX_VehicleWeight_AxleWeight_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_VehicleWeight_AxleLocation[ CBR_C_SIG_RX_VehicleWeight_AxleLocation_NUM_CALLBACK] = { NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_VehicleWeight[ CBR_C_SIG_RX_VehicleWeight_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_VehicleWeight_CargoWeight[ CBR_C_SIG_RX_VehicleWeight_CargoWeight_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_VehicleWeight_TrailerWeight[ CBR_C_SIG_RX_VehicleWeight_TrailerWeight_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_VehicleWeight_AxleWeight[ CBR_C_SIG_RX_VehicleWeight_AxleWeight_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_VehicleWeight_AxleLocation[ CBR_C_SIG_RX_VehicleWeight_AxleLocation_NUM_CALLBACK] = {{ NULL }};
#endif


const CSM_SIGNAL cbr_aubRX_VehicleWeightSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
   {0, CSM_C_DLC_VehicleWeight*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehicleWeight_NUM_CALLBACK, cbr_apfnSIG_RX_VehicleWeight },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehicleWeight_CargoWeight_NUM_CALLBACK ,cbr_apfnSIG_RX_VehicleWeight_CargoWeight }, /* CargoWeight */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehicleWeight_TrailerWeight_NUM_CALLBACK ,cbr_apfnSIG_RX_VehicleWeight_TrailerWeight }, /* TrailerWeight */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehicleWeight_AxleWeight_NUM_CALLBACK ,cbr_apfnSIG_RX_VehicleWeight_AxleWeight }, /* AxleWeight */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehicleWeight_AxleLocation_NUM_CALLBACK ,cbr_apfnSIG_RX_VehicleWeight_AxleLocation }, /* AxleLocation */
#else
  {0, CSM_C_DLC_VehicleWeight*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehicleWeight_NUM_CALLBACK, cbr_apfnSIG_RX_VehicleWeight },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehicleWeight_CargoWeight_NUM_CALLBACK ,cbr_apfnSIG_RX_VehicleWeight_CargoWeight }, /* CargoWeight */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehicleWeight_TrailerWeight_NUM_CALLBACK ,cbr_apfnSIG_RX_VehicleWeight_TrailerWeight }, /* TrailerWeight */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehicleWeight_AxleWeight_NUM_CALLBACK ,cbr_apfnSIG_RX_VehicleWeight_AxleWeight }, /* AxleWeight */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehicleWeight_AxleLocation_NUM_CALLBACK ,cbr_apfnSIG_RX_VehicleWeight_AxleLocation }, /* AxleLocation */
#endif
};
const BYTE cbr_aubRX_VehicleWeight_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0};
const BYTE cbr_aubRX_VehicleWeight_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_VehicleWeight =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_VehicleWeightSignals),
/* prSignals */                 cbr_aubRX_VehicleWeightSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_VehicleWeight_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_VehicleWeight_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};



/*****************************************************************************/
/* RX_VehiclePosition */
/*****************************************************************************/
#define CBR_C_SIG_RX_VehiclePosition_NUM_CALLBACK                    3
#define CBR_C_SIG_RX_VehiclePosition_Longitude_NUM_CALLBACK          3
#define CBR_C_SIG_RX_VehiclePosition_Latitude_NUM_CALLBACK           3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_VehiclePosition[ CBR_C_SIG_RX_VehiclePosition_NUM_CALLBACK] = { CCS_BR_vCSMSigInd };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_VehiclePosition_Longitude[ CBR_C_SIG_RX_VehiclePosition_Longitude_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_VehiclePosition_Latitude[ CBR_C_SIG_RX_VehiclePosition_Latitude_NUM_CALLBACK] = { NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_VehiclePosition[ CBR_C_SIG_RX_VehiclePosition_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_VehiclePosition_Longitude[ CBR_C_SIG_RX_VehiclePosition_Longitude_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_VehiclePosition_Latitude[ CBR_C_SIG_RX_VehiclePosition_Latitude_NUM_CALLBACK] = {{ NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_VehiclePositionSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_VehiclePosition*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehiclePosition_NUM_CALLBACK, cbr_apfnSIG_RX_VehiclePosition },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32, 32),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehiclePosition_Longitude_NUM_CALLBACK ,cbr_apfnSIG_RX_VehiclePosition_Longitude }, /* Longitude */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 32),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehiclePosition_Latitude_NUM_CALLBACK ,cbr_apfnSIG_RX_VehiclePosition_Latitude }, /* Latitude */
#else
  {0, CSM_C_DLC_VehiclePosition*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehiclePosition_NUM_CALLBACK, cbr_apfnSIG_RX_VehiclePosition },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32, 32),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehiclePosition_Longitude_NUM_CALLBACK ,cbr_apfnSIG_RX_VehiclePosition_Longitude }, /* Longitude */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 32),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_VehiclePosition_Latitude_NUM_CALLBACK ,cbr_apfnSIG_RX_VehiclePosition_Latitude }, /* Latitude */
#endif
};
const BYTE cbr_aubRX_VehiclePosition_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
const BYTE cbr_aubRX_VehiclePosition_TimeoutData[] = {0,0,0,0,0,0,0,0};

/***********************/
const CSM_TELEGRAM cbr_aubRX_VehiclePosition =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_VehiclePositionSignals),
/* prSignals */                 cbr_aubRX_VehiclePositionSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_VehiclePosition_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_VehiclePosition_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_ETC5 */
/*****************************************************************************/
#define CBR_C_SIG_RX_ETC5_NUM_CALLBACK                  3
#define CBR_C_SIG_RX_ETC5_ReverseSwitch_NUM_CALLBACK    3


#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ETC5 [CBR_C_SIG_RX_ETC5_NUM_CALLBACK] = { CCS_BR_vCSMSigInd };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ETC5_ReverseSwitch[ CBR_C_SIG_RX_ETC5_ReverseSwitch_NUM_CALLBACK] = { NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ETC5 [CBR_C_SIG_RX_ETC5_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ETC5_ReverseSwitch[ CBR_C_SIG_RX_ETC5_ReverseSwitch_NUM_CALLBACK] = {{ NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_ETC5Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_ETC5*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ETC5_NUM_CALLBACK, cbr_apfnSIG_RX_ETC5 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ETC5_ReverseSwitch_NUM_CALLBACK ,cbr_apfnSIG_RX_ETC5_ReverseSwitch }, /* ReverseSwitch */
#else
  {0, CSM_C_DLC_ETC5*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ETC5_NUM_CALLBACK, cbr_apfnSIG_RX_ETC5 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ETC5_ReverseSwitch_NUM_CALLBACK ,cbr_apfnSIG_RX_ETC5_ReverseSwitch }, /* ReverseSwitch */
#endif
};

const BYTE cbr_aubRX_ETC5_DefaultData[] = {0,0x03,0,0,0,0,0,0};
const BYTE cbr_aubRX_ETC5_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_ETC5 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_ETC5Signals),
/* prSignals */                 cbr_aubRX_ETC5Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_ETC5_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_ETC5_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_TCO1 */
/*****************************************************************************/
#define CBR_C_SIG_RX_TCO1_NUM_CALLBACK                             3
#define CBR_C_SIG_RX_TCO1_TCOVehSpeed_NUM_CALLBACK                 3
#define CBR_C_SIG_RX_TCO1_DirectionIndicator_NUM_CALLBACK          3
#define CBR_C_SIG_RX_TCO1_DriverCard1_NUM_CALLBACK                 3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TCO1[ CBR_C_SIG_RX_TCO1_NUM_CALLBACK] = { CCS_BR_vCSMSigInd };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TCO1_TCOVehSpeed[ CBR_C_SIG_RX_TCO1_TCOVehSpeed_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TCO1_DirectionIndicator[ CBR_C_SIG_RX_TCO1_DirectionIndicator_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TCO1_DriverCard1[ CBR_C_SIG_RX_TCO1_DriverCard1_NUM_CALLBACK] = { NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TCO1[ CBR_C_SIG_RX_TCO1_NUM_CALLBACK] ={{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TCO1_TCOVehSpeed[ CBR_C_SIG_RX_TCO1_TCOVehSpeed_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TCO1_DirectionIndicator[ CBR_C_SIG_RX_TCO1_DirectionIndicator_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TCO1_DriverCard1[ CBR_C_SIG_RX_TCO1_DriverCard1_NUM_CALLBACK] = {{ NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_TCO1Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_TCO1*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TCO1_NUM_CALLBACK, cbr_apfnSIG_RX_TCO1 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48, 16),  CSM_C_ALWAYS_IND, CBR_C_SIG_RX_TCO1_TCOVehSpeed_NUM_CALLBACK ,cbr_apfnSIG_RX_TCO1_TCOVehSpeed }, /* TCOVehSpeed */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 30,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TCO1_DirectionIndicator_NUM_CALLBACK ,cbr_apfnSIG_RX_TCO1_DirectionIndicator }, /* DirectionIndicator */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TCO1_DriverCard1_NUM_CALLBACK ,cbr_apfnSIG_RX_TCO1_DriverCard1 }, /* DriverCard1 */
#else
  {0, CSM_C_DLC_TCO1*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TCO1_NUM_CALLBACK, cbr_apfnSIG_RX_TCO1 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TCO1_TCOVehSpeed_NUM_CALLBACK ,cbr_apfnSIG_RX_TCO1_TCOVehSpeed }, /* TCOVehSpeed */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 30,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TCO1_DirectionIndicator_NUM_CALLBACK ,cbr_apfnSIG_RX_TCO1_DirectionIndicator }, /* DirectionIndicator */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TCO1_DriverCard1_NUM_CALLBACK ,cbr_apfnSIG_RX_TCO1_DriverCard1 }, /* DriverCard1 */
#endif
};
const BYTE cbr_aubRX_TCO1_DefaultData[] = {0,0x3,0,0xC,0,0,0xFF,0xFF};
const BYTE cbr_aubRX_TCO1_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_TCO1 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_TCO1Signals),
/* prSignals */                 cbr_aubRX_TCO1Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_TCO1_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_TCO1_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};


/*****************************************************************************/
/* RX_TimeDate */
/*****************************************************************************/

#define CBR_C_SIG_RX_TimeDate_NUM_CALLBACK                          3
#define CBR_C_SIG_RX_TimeDate_LocalOffsetHour_NUM_CALLBACK          3
#define CBR_C_SIG_RX_TimeDate_LocalOffsetMinute_NUM_CALLBACK        3
#define CBR_C_SIG_RX_TimeDate_Year_NUM_CALLBACK                     3
#define CBR_C_SIG_RX_TimeDate_Day_NUM_CALLBACK                      3
#define CBR_C_SIG_RX_TimeDate_Month_NUM_CALLBACK                    3
#define CBR_C_SIG_RX_TimeDate_Hours_NUM_CALLBACK                    3
#define CBR_C_SIG_RX_TimeDate_Minutes_NUM_CALLBACK                  3
#define CBR_C_SIG_RX_TimeDate_Seconds_NUM_CALLBACK                  3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TimeDate[ CBR_C_SIG_RX_TimeDate_NUM_CALLBACK] = { CCS_BR_vCSMSigInd };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TimeDate_LocalOffsetHour[ CBR_C_SIG_RX_TimeDate_LocalOffsetHour_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TimeDate_LocalOffsetMinute[ CBR_C_SIG_RX_TimeDate_LocalOffsetMinute_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TimeDate_Year[ CBR_C_SIG_RX_TimeDate_Year_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TimeDate_Day[ CBR_C_SIG_RX_TimeDate_Day_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TimeDate_Month[ CBR_C_SIG_RX_TimeDate_Month_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TimeDate_Hours[ CBR_C_SIG_RX_TimeDate_Hours_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TimeDate_Minutes[ CBR_C_SIG_RX_TimeDate_Minutes_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TimeDate_Seconds[ CBR_C_SIG_RX_TimeDate_Seconds_NUM_CALLBACK] = { NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TimeDate[ CBR_C_SIG_RX_TimeDate_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TimeDate_LocalOffsetHour[ CBR_C_SIG_RX_TimeDate_LocalOffsetHour_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TimeDate_LocalOffsetMinute[ CBR_C_SIG_RX_TimeDate_LocalOffsetMinute_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TimeDate_Year[ CBR_C_SIG_RX_TimeDate_Year_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TimeDate_Day[ CBR_C_SIG_RX_TimeDate_Day_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TimeDate_Month[ CBR_C_SIG_RX_TimeDate_Month_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TimeDate_Hours[ CBR_C_SIG_RX_TimeDate_Hours_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TimeDate_Minutes[ CBR_C_SIG_RX_TimeDate_Minutes_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TimeDate_Seconds[ CBR_C_SIG_RX_TimeDate_Seconds_NUM_CALLBACK] = {{ NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_TimeDateSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_TimeDate*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_NUM_CALLBACK, cbr_apfnSIG_RX_TimeDate },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_LocalOffsetHour_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_LocalOffsetHour }, /* LocalOffsetHour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_LocalOffsetMinute_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_LocalOffsetMinute }, /* LocalOffsetMinute */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_Year_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_Year }, /* Year */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_Day_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_Day }, /* Day */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_Month_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_Month }, /* Month */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_Hours_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_Hours }, /* Hours */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_Minutes_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_Minutes }, /* Minutes */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_Seconds_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_Seconds }, /* Seconds */
#else
  {0, CSM_C_DLC_TimeDate*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_NUM_CALLBACK, cbr_apfnSIG_RX_TimeDate },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_LocalOffsetHour_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_LocalOffsetHour }, /* LocalOffsetHour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_LocalOffsetMinute_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_LocalOffsetMinute }, /* LocalOffsetMinute */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_Year_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_Year }, /* Year */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_Day_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_Day }, /* Day */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_Month_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_Month }, /* Month */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_Hours_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_Hours }, /* Hours */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_Minutes_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_Minutes }, /* Minutes */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TimeDate_Seconds_NUM_CALLBACK ,cbr_apfnSIG_RX_TimeDate_Seconds }, /* Seconds */
#endif
};
const BYTE cbr_aubRX_TimeDate_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
const BYTE cbr_aubRX_TimeDate_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_TimeDate =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_TimeDateSignals),
/* prSignals */                 cbr_aubRX_TimeDateSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_TimeDate_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_TimeDate_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_RemoteControl */
/*****************************************************************************/
#define CBR_C_SIG_RX_RemoteControl_NUM_CALLBACK                         3
#define CBR_C_SIG_RX_RemoteControl_Button_Hash_NUM_CALLBACK             3
#define CBR_C_SIG_RX_RemoteControl_Button_Star_NUM_CALLBACK             3
#define CBR_C_SIG_RX_RemoteControl_Button_Voice_NUM_CALLBACK            3
#define CBR_C_SIG_RX_RemoteControl_Button_9_NUM_CALLBACK                3
#define CBR_C_SIG_RX_RemoteControl_Button_8_NUM_CALLBACK                3
#define CBR_C_SIG_RX_RemoteControl_Button_7_NUM_CALLBACK                3
#define CBR_C_SIG_RX_RemoteControl_Button_6_NUM_CALLBACK                3
#define CBR_C_SIG_RX_RemoteControl_Button_5_NUM_CALLBACK                3
#define CBR_C_SIG_RX_RemoteControl_Button_4_NUM_CALLBACK                3
#define CBR_C_SIG_RX_RemoteControl_Button_3_NUM_CALLBACK                3
#define CBR_C_SIG_RX_RemoteControl_Button_2_NUM_CALLBACK                3
#define CBR_C_SIG_RX_RemoteControl_Button_0_NUM_CALLBACK                3
#define CBR_C_SIG_RX_RemoteControl_Button_1_NUM_CALLBACK                3
#define CBR_C_SIG_RX_RemoteControl_Button_Traffic_NUM_CALLBACK          3
#define CBR_C_SIG_RX_RemoteControl_Button_Map_NUM_CALLBACK              3
#define CBR_C_SIG_RX_RemoteControl_Button_Navi_NUM_CALLBACK             3
#define CBR_C_SIG_RX_RemoteControl_Button_Phone_NUM_CALLBACK            3
#define CBR_C_SIG_RX_RemoteControl_Button_Media_NUM_CALLBACK            3
#define CBR_C_SIG_RX_RemoteControl_Button_Tuner_NUM_CALLBACK            3
#define CBR_C_SIG_RX_RemoteControl_Button_Previous_NUM_CALLBACK         3
#define CBR_C_SIG_RX_RemoteControl_Button_Next_NUM_CALLBACK             3
#define CBR_C_SIG_RX_RemoteControl_Button_Back_NUM_CALLBACK             3
#define CBR_C_SIG_RX_RemoteControl_Button_Setup_NUM_CALLBACK            3
#define CBR_C_SIG_RX_RemoteControl_Button_Home_NUM_CALLBACK             3
#define CBR_C_SIG_RX_RemoteControl_Encoder_Volume_NUM_CALLBACK          3
#define CBR_C_SIG_RX_RemoteControl_Button_Mute_NUM_CALLBACK             3
#define CBR_C_SIG_RX_RemoteControl_Button_VolumeDown_NUM_CALLBACK       3
#define CBR_C_SIG_RX_RemoteControl_Button_VolumeUp_NUM_CALLBACK         3
#define CBR_C_SIG_RX_RemoteControl_Button_OnOff_NUM_CALLBACK            3

#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl[ CBR_C_SIG_RX_RemoteControl_NUM_CALLBACK] = { CCS_BR_vCSMSigInd };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_Hash[ CBR_C_SIG_RX_RemoteControl_Button_Hash_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_Star[ CBR_C_SIG_RX_RemoteControl_Button_Star_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_Voice[ CBR_C_SIG_RX_RemoteControl_Button_Voice_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_9[ CBR_C_SIG_RX_RemoteControl_Button_9_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_8[ CBR_C_SIG_RX_RemoteControl_Button_8_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_7[ CBR_C_SIG_RX_RemoteControl_Button_7_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_6[ CBR_C_SIG_RX_RemoteControl_Button_6_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_5[ CBR_C_SIG_RX_RemoteControl_Button_5_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_4[ CBR_C_SIG_RX_RemoteControl_Button_4_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_3[ CBR_C_SIG_RX_RemoteControl_Button_3_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_2[ CBR_C_SIG_RX_RemoteControl_Button_2_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_0[ CBR_C_SIG_RX_RemoteControl_Button_0_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_1[ CBR_C_SIG_RX_RemoteControl_Button_1_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_Traffic[ CBR_C_SIG_RX_RemoteControl_Button_Traffic_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_Map[ CBR_C_SIG_RX_RemoteControl_Button_Map_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_Navi[ CBR_C_SIG_RX_RemoteControl_Button_Navi_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_Phone[ CBR_C_SIG_RX_RemoteControl_Button_Phone_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_Media[ CBR_C_SIG_RX_RemoteControl_Button_Media_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_Tuner[ CBR_C_SIG_RX_RemoteControl_Button_Tuner_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_Previous[ CBR_C_SIG_RX_RemoteControl_Button_Previous_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_Next[ CBR_C_SIG_RX_RemoteControl_Button_Next_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_Back[ CBR_C_SIG_RX_RemoteControl_Button_Back_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_Setup[ CBR_C_SIG_RX_RemoteControl_Button_Setup_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_Home[ CBR_C_SIG_RX_RemoteControl_Button_Home_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Encoder_Volume[ CBR_C_SIG_RX_RemoteControl_Encoder_Volume_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_Mute[ CBR_C_SIG_RX_RemoteControl_Button_Mute_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_VolumeDown[ CBR_C_SIG_RX_RemoteControl_Button_VolumeDown_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_VolumeUp[ CBR_C_SIG_RX_RemoteControl_Button_VolumeUp_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_RemoteControl_Button_OnOff[ CBR_C_SIG_RX_RemoteControl_Button_OnOff_NUM_CALLBACK] = { NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl[ CBR_C_SIG_RX_RemoteControl_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_Hash[ CBR_C_SIG_RX_RemoteControl_Button_Hash_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_Star[ CBR_C_SIG_RX_RemoteControl_Button_Star_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_Voice[ CBR_C_SIG_RX_RemoteControl_Button_Voice_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_9[ CBR_C_SIG_RX_RemoteControl_Button_9_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_8[ CBR_C_SIG_RX_RemoteControl_Button_8_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_7[ CBR_C_SIG_RX_RemoteControl_Button_7_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_6[ CBR_C_SIG_RX_RemoteControl_Button_6_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_5[ CBR_C_SIG_RX_RemoteControl_Button_5_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_4[ CBR_C_SIG_RX_RemoteControl_Button_4_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_3[ CBR_C_SIG_RX_RemoteControl_Button_3_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_2[ CBR_C_SIG_RX_RemoteControl_Button_2_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_0[ CBR_C_SIG_RX_RemoteControl_Button_0_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_1[ CBR_C_SIG_RX_RemoteControl_Button_1_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_Traffic[ CBR_C_SIG_RX_RemoteControl_Button_Traffic_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_Map[ CBR_C_SIG_RX_RemoteControl_Button_Map_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_Navi[ CBR_C_SIG_RX_RemoteControl_Button_Navi_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_Phone[ CBR_C_SIG_RX_RemoteControl_Button_Phone_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_Media[ CBR_C_SIG_RX_RemoteControl_Button_Media_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_Tuner[ CBR_C_SIG_RX_RemoteControl_Button_Tuner_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_Previous[ CBR_C_SIG_RX_RemoteControl_Button_Previous_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_Next[ CBR_C_SIG_RX_RemoteControl_Button_Next_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_Back[ CBR_C_SIG_RX_RemoteControl_Button_Back_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_Setup[ CBR_C_SIG_RX_RemoteControl_Button_Setup_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_Home[ CBR_C_SIG_RX_RemoteControl_Button_Home_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Encoder_Volume[ CBR_C_SIG_RX_RemoteControl_Encoder_Volume_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_Mute[ CBR_C_SIG_RX_RemoteControl_Button_Mute_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_VolumeDown[ CBR_C_SIG_RX_RemoteControl_Button_VolumeDown_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_VolumeUp[ CBR_C_SIG_RX_RemoteControl_Button_VolumeUp_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_RemoteControl_Button_OnOff[ CBR_C_SIG_RX_RemoteControl_Button_OnOff_NUM_CALLBACK] = {{ NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_RemoteControlSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_RemoteControl*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_NUM_CALLBACK, cbr_apfnSIG_RX_RemoteControl },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 62,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Hash_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Hash }, /* Button_Hash */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 60,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Star_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Star }, /* Button_Star */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 38,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Voice_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Voice }, /* Button_Voice */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_9_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_9 }, /* Button_9 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 54,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_8_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_8 }, /* Button_8 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 52,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_7_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_7 }, /* Button_7 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 50,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_6_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_6 }, /* Button_6 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_5_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_5 }, /* Button_5 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 46,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_4_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_4 }, /* Button_4 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 44,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_3_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_3 }, /* Button_3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 42,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_2_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_2 }, /* Button_2 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 58,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_0_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_0 }, /* Button_0 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_1_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_1 }, /* Button_1 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 36,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Traffic_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Traffic }, /* Button_Traffic */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 34,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Map_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Map }, /* Button_Map */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Navi_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Navi }, /* Button_Navi */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 30,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Phone_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Phone }, /* Button_Phone */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 28,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Media_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Media }, /* Button_Media */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 26,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Tuner_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Tuner }, /* Button_Tuner */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Previous_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Previous }, /* Button_Previous */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 22,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Next_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Next }, /* Button_Next */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Back_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Back }, /* Button_Back */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 18,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Setup_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Setup }, /* Button_Setup */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Home_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Home }, /* Button_Home */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Encoder_Volume_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Encoder_Volume }, /* Encoder_Volume */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  6,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Mute_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Mute }, /* Button_Mute */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  4,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_VolumeDown_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_VolumeDown }, /* Button_VolumeDown */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_VolumeUp_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_VolumeUp }, /* Button_VolumeUp */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_OnOff_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_OnOff }, /* Button_OnOff */
#else
  {0, CSM_C_DLC_RemoteControl*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_NUM_CALLBACK, cbr_apfnSIG_RX_RemoteControl },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 62,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Hash_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Hash }, /* Button_Hash */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 60,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Star_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Star }, /* Button_Star */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 38,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Voice_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Voice }, /* Button_Voice */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_9_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_9 }, /* Button_9 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 54,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_8_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_8 }, /* Button_8 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 52,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_7_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_7 }, /* Button_7 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 50,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_6_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_6 }, /* Button_6 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_5_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_5 }, /* Button_5 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 46,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_4_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_4 }, /* Button_4 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 44,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_3_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_3 }, /* Button_3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 42,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_2_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_2 }, /* Button_2 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 58,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_0_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_0 }, /* Button_0 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_1_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_1 }, /* Button_1 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 36,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Traffic_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Traffic }, /* Button_Traffic */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 34,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Map_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Map }, /* Button_Map */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Navi_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Navi }, /* Button_Navi */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 30,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Phone_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Phone }, /* Button_Phone */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 28,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Media_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Media }, /* Button_Media */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 26,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Tuner_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Tuner }, /* Button_Tuner */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Previous_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Previous }, /* Button_Previous */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 22,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Next_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Next }, /* Button_Next */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Back_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Back }, /* Button_Back */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 18,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Setup_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Setup }, /* Button_Setup */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Home_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Home }, /* Button_Home */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Encoder_Volume_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Encoder_Volume }, /* Encoder_Volume */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  6,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_Mute_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_Mute }, /* Button_Mute */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  4,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_VolumeDown_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_VolumeDown }, /* Button_VolumeDown */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_VolumeUp_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_VolumeUp }, /* Button_VolumeUp */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_RemoteControl_Button_OnOff_NUM_CALLBACK ,cbr_apfnSIG_RX_RemoteControl_Button_OnOff }, /* Button_OnOff */
#endif
};
const BYTE cbr_aubRX_RemoteControl_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
const BYTE cbr_aubRX_RemoteControl_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_RemoteControl =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_RemoteControlSignals),
/* prSignals */                 cbr_aubRX_RemoteControlSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_RemoteControl_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_RemoteControl_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_Illumination */
/*****************************************************************************/
#define CBR_C_SIG_RX_Illumination_NUM_CALLBACK                          3
#define CBR_C_SIG_RX_Illumination_Key_Illumination_NUM_CALLBACK         3
#define CBR_C_SIG_RX_Illumination_Illumination_NUM_CALLBACK             3

#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Illumination[ CBR_C_SIG_RX_Illumination_NUM_CALLBACK] = { CCS_BR_vCSMSigInd };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Illumination_Key_Illumination[ CBR_C_SIG_RX_Illumination_Key_Illumination_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Illumination_Illumination[ CBR_C_SIG_RX_Illumination_Illumination_NUM_CALLBACK] = { NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Illumination[ CBR_C_SIG_RX_Illumination_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Illumination_Key_Illumination[ CBR_C_SIG_RX_Illumination_Key_Illumination_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Illumination_Illumination[ CBR_C_SIG_RX_Illumination_Illumination_NUM_CALLBACK] = {{ NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_IlluminationSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_Illumination*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Illumination_NUM_CALLBACK, cbr_apfnSIG_RX_Illumination },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Illumination_Key_Illumination_NUM_CALLBACK ,cbr_apfnSIG_RX_Illumination_Key_Illumination }, /* Key_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Illumination_Illumination_NUM_CALLBACK ,cbr_apfnSIG_RX_Illumination_Illumination }, /* Illumination */
#else
  {0, CSM_C_DLC_Illumination*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Illumination_NUM_CALLBACK, cbr_apfnSIG_RX_Illumination },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Illumination_Key_Illumination_NUM_CALLBACK ,cbr_apfnSIG_RX_Illumination_Key_Illumination }, /* Key_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Illumination_Illumination_NUM_CALLBACK ,cbr_apfnSIG_RX_Illumination_Illumination }, /* Illumination */
#endif
};
const BYTE cbr_aubRX_Illumination_DefaultData[] = {0xFF,0xFF,0,0,0,0,0,0};
const BYTE cbr_aubRX_Illumination_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_Illumination =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_IlluminationSignals),
/* prSignals */                 cbr_aubRX_IlluminationSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_Illumination_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_Illumination_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_SystemEnvironmentExtended */
/*****************************************************************************/
#define CBR_C_SIG_RX_SystemEnvironmentExtended_NUM_CALLBACK                            3
#define CBR_C_SIG_RX_SystemEnvironmentExtended_Locking_Status_NUM_CALLBACK             3
#define CBR_C_SIG_RX_SystemEnvironmentExtended_Passenger_DOOR_Status_NUM_CALLBACK      3
#define CBR_C_SIG_RX_SystemEnvironmentExtended_Driver_DOORStatus_NUM_CALLBACK          3
#define CBR_C_SIG_RX_SystemEnvironmentExtended_Date_Mode_NUM_CALLBACK                  3
#define CBR_C_SIG_RX_SystemEnvironmentExtended_Camera_Split_Quad_Stat_NUM_CALLBACK     3

#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironmentExtended[ CBR_C_SIG_RX_SystemEnvironmentExtended_NUM_CALLBACK] = { CCS_BR_vCSMSigInd };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironmentExtended_Locking_Status[ CBR_C_SIG_RX_SystemEnvironmentExtended_Locking_Status_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironmentExtended_Passenger_DOOR_Status[ CBR_C_SIG_RX_SystemEnvironmentExtended_Passenger_DOOR_Status_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironmentExtended_Driver_DOORStatus[ CBR_C_SIG_RX_SystemEnvironmentExtended_Driver_DOORStatus_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironmentExtended_Date_Mode[ CBR_C_SIG_RX_SystemEnvironmentExtended_Date_Mode_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SystemEnvironmentExtended_Camera_Split_Quad_Stat[ CBR_C_SIG_RX_SystemEnvironmentExtended_Camera_Split_Quad_Stat_NUM_CALLBACK] = { NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironmentExtended[ CBR_C_SIG_RX_SystemEnvironmentExtended_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironmentExtended_Locking_Status[ CBR_C_SIG_RX_SystemEnvironmentExtended_Locking_Status_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironmentExtended_Passenger_DOOR_Status[ CBR_C_SIG_RX_SystemEnvironmentExtended_Passenger_DOOR_Status_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironmentExtended_Driver_DOORStatus[ CBR_C_SIG_RX_SystemEnvironmentExtended_Driver_DOORStatus_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironmentExtended_Date_Mode[ CBR_C_SIG_RX_SystemEnvironmentExtended_Date_Mode_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SystemEnvironmentExtended_Camera_Split_Quad_Stat[ CBR_C_SIG_RX_SystemEnvironmentExtended_Camera_Split_Quad_Stat_NUM_CALLBACK] = {{ NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_SystemEnvironmentExtendedSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_SystemEnvironmentExtended*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironmentExtended_NUM_CALLBACK, cbr_apfnSIG_RX_SystemEnvironmentExtended },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 28,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironmentExtended_Locking_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironmentExtended_Locking_Status }, /* Locking_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 26,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironmentExtended_Passenger_DOOR_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironmentExtended_Passenger_DOOR_Status }, /* Passenger_DOOR_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironmentExtended_Driver_DOORStatus_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironmentExtended_Driver_DOORStatus }, /* Driver_DOORStatus */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironmentExtended_Date_Mode_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironmentExtended_Date_Mode }, /* Date_Mode */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironmentExtended_Camera_Split_Quad_Stat_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironmentExtended_Camera_Split_Quad_Stat }, /* Camera_Split_Quad_Stat */
#else
  {0, CSM_C_DLC_SystemEnvironmentExtended*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironmentExtended_NUM_CALLBACK, cbr_apfnSIG_RX_SystemEnvironmentExtended },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 28,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironmentExtended_Locking_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironmentExtended_Locking_Status }, /* Locking_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 26,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironmentExtended_Passenger_DOOR_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironmentExtended_Passenger_DOOR_Status }, /* Passenger_DOOR_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironmentExtended_Driver_DOORStatus_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironmentExtended_Driver_DOORStatus }, /* Driver_DOORStatus */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironmentExtended_Date_Mode_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironmentExtended_Date_Mode }, /* Date_Mode */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SystemEnvironmentExtended_Camera_Split_Quad_Stat_NUM_CALLBACK ,cbr_apfnSIG_RX_SystemEnvironmentExtended_Camera_Split_Quad_Stat }, /* Camera_Split_Quad_Stat */
#endif
};
const BYTE cbr_aubRX_SystemEnvironmentExtended_DefaultData[] = {0xFF,0xFF,0x03,0x3F,0,0,0,0};
const BYTE cbr_aubRX_SystemEnvironmentExtended_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_SystemEnvironmentExtended =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_SystemEnvironmentExtendedSignals),
/* prSignals */                 cbr_aubRX_SystemEnvironmentExtendedSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_SystemEnvironmentExtended_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_SystemEnvironmentExtended_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_Camera_Request */
/*****************************************************************************/
#define CBR_C_SIG_RX_Camera_Request_NUM_CALLBACK                 3
#define CBR_C_SIG_RX_Camera_Request_Camera17_Req_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Camera_Request_Camera16_Req_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Camera_Request_Camera15_Req_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Camera_Request_Camera14_Req_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Camera_Request_Camera13_Req_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Camera_Request_Camera12_Req_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Camera_Request_Camera11_Req_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Camera_Request_Camera10_Req_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Camera_Request_Camera9_Req_NUM_CALLBACK     3
#define CBR_C_SIG_RX_Camera_Request_Camera8_Req_NUM_CALLBACK     3
#define CBR_C_SIG_RX_Camera_Request_Camera7_Req_NUM_CALLBACK     3
#define CBR_C_SIG_RX_Camera_Request_Camera6_Req_NUM_CALLBACK     3
#define CBR_C_SIG_RX_Camera_Request_Camera5_Req_NUM_CALLBACK     3
#define CBR_C_SIG_RX_Camera_Request_Camera4_Req_NUM_CALLBACK     3
#define CBR_C_SIG_RX_Camera_Request_Camera3_Req_NUM_CALLBACK     3
#define CBR_C_SIG_RX_Camera_Request_Camera2_Req_NUM_CALLBACK     3
#define CBR_C_SIG_RX_Camera_Request_Camera1_Req_NUM_CALLBACK     3

#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request[ CBR_C_SIG_RX_Camera_Request_NUM_CALLBACK] = { CCS_BR_vCSMSigInd};
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera17_Req[ CBR_C_SIG_RX_Camera_Request_Camera17_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera16_Req[ CBR_C_SIG_RX_Camera_Request_Camera16_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera15_Req[ CBR_C_SIG_RX_Camera_Request_Camera15_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera14_Req[ CBR_C_SIG_RX_Camera_Request_Camera14_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera13_Req[ CBR_C_SIG_RX_Camera_Request_Camera13_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera12_Req[ CBR_C_SIG_RX_Camera_Request_Camera12_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera11_Req[ CBR_C_SIG_RX_Camera_Request_Camera11_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera10_Req[ CBR_C_SIG_RX_Camera_Request_Camera10_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera9_Req[ CBR_C_SIG_RX_Camera_Request_Camera9_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera8_Req[ CBR_C_SIG_RX_Camera_Request_Camera8_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera7_Req[ CBR_C_SIG_RX_Camera_Request_Camera7_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera6_Req[ CBR_C_SIG_RX_Camera_Request_Camera6_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera5_Req[ CBR_C_SIG_RX_Camera_Request_Camera5_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera4_Req[ CBR_C_SIG_RX_Camera_Request_Camera4_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera3_Req[ CBR_C_SIG_RX_Camera_Request_Camera3_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera2_Req[ CBR_C_SIG_RX_Camera_Request_Camera2_Req_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Camera_Request_Camera1_Req[ CBR_C_SIG_RX_Camera_Request_Camera1_Req_NUM_CALLBACK] = { NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request[ CBR_C_SIG_RX_Camera_Request_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera17_Req[ CBR_C_SIG_RX_Camera_Request_Camera17_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera16_Req[ CBR_C_SIG_RX_Camera_Request_Camera16_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera15_Req[ CBR_C_SIG_RX_Camera_Request_Camera15_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera14_Req[ CBR_C_SIG_RX_Camera_Request_Camera14_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera13_Req[ CBR_C_SIG_RX_Camera_Request_Camera13_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera12_Req[ CBR_C_SIG_RX_Camera_Request_Camera12_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera11_Req[ CBR_C_SIG_RX_Camera_Request_Camera11_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera10_Req[ CBR_C_SIG_RX_Camera_Request_Camera10_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera9_Req[ CBR_C_SIG_RX_Camera_Request_Camera9_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera8_Req[ CBR_C_SIG_RX_Camera_Request_Camera8_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera7_Req[ CBR_C_SIG_RX_Camera_Request_Camera7_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera6_Req[ CBR_C_SIG_RX_Camera_Request_Camera6_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera5_Req[ CBR_C_SIG_RX_Camera_Request_Camera5_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera4_Req[ CBR_C_SIG_RX_Camera_Request_Camera4_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera3_Req[ CBR_C_SIG_RX_Camera_Request_Camera3_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera2_Req[ CBR_C_SIG_RX_Camera_Request_Camera2_Req_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Camera_Request_Camera1_Req[ CBR_C_SIG_RX_Camera_Request_Camera1_Req_NUM_CALLBACK] = {{ NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_Camera_RequestSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_Camera_Request*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_NUM_CALLBACK, cbr_apfnSIG_RX_Camera_Request },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera17_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera17_Req }, /* Camera17_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 30,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera16_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera16_Req }, /* Camera16_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 28,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera15_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera15_Req }, /* Camera15_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 26,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera14_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera14_Req }, /* Camera14_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera13_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera13_Req }, /* Camera13_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 22,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera12_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera12_Req }, /* Camera12_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera11_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera11_Req }, /* Camera11_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 18,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera10_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera10_Req }, /* Camera10_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera9_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera9_Req }, /* Camera9_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 14,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera8_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera8_Req }, /* Camera8_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera7_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera7_Req }, /* Camera7_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 10,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera6_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera6_Req }, /* Camera6_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera5_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera5_Req }, /* Camera5_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  6,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera4_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera4_Req }, /* Camera4_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  4,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera3_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera3_Req }, /* Camera3_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera2_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera2_Req }, /* Camera2_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera1_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera1_Req }, /* Camera1_Req */
#else
  {0, CSM_C_DLC_Camera_Request*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_NUM_CALLBACK, cbr_apfnSIG_RX_Camera_Request },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera17_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera17_Req }, /* Camera17_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 30,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera16_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera16_Req }, /* Camera16_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 28,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera15_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera15_Req }, /* Camera15_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 26,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera14_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera14_Req }, /* Camera14_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera13_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera13_Req }, /* Camera13_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 22,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera12_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera12_Req }, /* Camera12_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera11_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera11_Req }, /* Camera11_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 18,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera10_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera10_Req }, /* Camera10_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera9_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera9_Req }, /* Camera9_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 14,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera8_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera8_Req }, /* Camera8_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera7_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera7_Req }, /* Camera7_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 10,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera6_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera6_Req }, /* Camera6_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera5_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera5_Req }, /* Camera5_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  6,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera4_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera4_Req }, /* Camera4_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  4,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera3_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera3_Req }, /* Camera3_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera2_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera2_Req }, /* Camera2_Req */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Camera_Request_Camera1_Req_NUM_CALLBACK ,cbr_apfnSIG_RX_Camera_Request_Camera1_Req }, /* Camera1_Req */
#endif
};
const BYTE cbr_aubRX_Camera_Request_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0x03,0,0,0};
const BYTE cbr_aubRX_Camera_Request_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_Camera_Request =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_Camera_RequestSignals),
/* prSignals */                 cbr_aubRX_Camera_RequestSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_Camera_Request_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_Camera_Request_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_CabinMediaCommand */
/*****************************************************************************/
#define CBR_C_SIG_RX_CabinMediaCommand_NUM_CALLBACK                         3
#define CBR_C_SIG_RX_CabinMediaCommand_CabinPlaylistCmd_NUM_CALLBACK        3
#define CBR_C_SIG_RX_CabinMediaCommand_Cabin_TrackCommand_NUM_CALLBACK      3
#define CBR_C_SIG_RX_CabinMediaCommand_Cabin_Tuner_Command_NUM_CALLBACK     3
#define CBR_C_SIG_RX_CabinMediaCommand_Cabin_Volume_Command_NUM_CALLBACK    3
#define CBR_C_SIG_RX_CabinMediaCommand_Cabin_Source_Command_NUM_CALLBACK    3

#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CabinMediaCommand[ CBR_C_SIG_RX_CabinMediaCommand_NUM_CALLBACK] = { CCS_BR_vCSMSigInd };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CabinMediaCommand_CabinPlaylistCmd[ CBR_C_SIG_RX_CabinMediaCommand_CabinPlaylistCmd_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CabinMediaCommand_Cabin_TrackCommand[ CBR_C_SIG_RX_CabinMediaCommand_Cabin_TrackCommand_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CabinMediaCommand_Cabin_Tuner_Command[ CBR_C_SIG_RX_CabinMediaCommand_Cabin_Tuner_Command_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CabinMediaCommand_Cabin_Volume_Command[ CBR_C_SIG_RX_CabinMediaCommand_Cabin_Volume_Command_NUM_CALLBACK] = { NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CabinMediaCommand_Cabin_Source_Command[ CBR_C_SIG_RX_CabinMediaCommand_Cabin_Source_Command_NUM_CALLBACK] = { NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CabinMediaCommand[ CBR_C_SIG_RX_CabinMediaCommand_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CabinMediaCommand_CabinPlaylistCmd[ CBR_C_SIG_RX_CabinMediaCommand_CabinPlaylistCmd_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CabinMediaCommand_Cabin_TrackCommand[ CBR_C_SIG_RX_CabinMediaCommand_Cabin_TrackCommand_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CabinMediaCommand_Cabin_Tuner_Command[ CBR_C_SIG_RX_CabinMediaCommand_Cabin_Tuner_Command_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CabinMediaCommand_Cabin_Volume_Command[ CBR_C_SIG_RX_CabinMediaCommand_Cabin_Volume_Command_NUM_CALLBACK] = {{ NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CabinMediaCommand_Cabin_Source_Command[ CBR_C_SIG_RX_CabinMediaCommand_Cabin_Source_Command_NUM_CALLBACK] = {{ NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_CabinMediaCommandSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_CabinMediaCommand*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CabinMediaCommand_NUM_CALLBACK, cbr_apfnSIG_RX_CabinMediaCommand },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CabinMediaCommand_CabinPlaylistCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_CabinMediaCommand_CabinPlaylistCmd }, /* CabinPlaylistCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CabinMediaCommand_Cabin_TrackCommand_NUM_CALLBACK ,cbr_apfnSIG_RX_CabinMediaCommand_Cabin_TrackCommand }, /* Cabin_TrackCommand */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CabinMediaCommand_Cabin_Tuner_Command_NUM_CALLBACK ,cbr_apfnSIG_RX_CabinMediaCommand_Cabin_Tuner_Command }, /* Cabin_Tuner_Command */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CabinMediaCommand_Cabin_Volume_Command_NUM_CALLBACK ,cbr_apfnSIG_RX_CabinMediaCommand_Cabin_Volume_Command }, /* Cabin_Volume_Command */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  6),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CabinMediaCommand_Cabin_Source_Command_NUM_CALLBACK ,cbr_apfnSIG_RX_CabinMediaCommand_Cabin_Source_Command }, /* Cabin_Source_Command */
#else
  {0, CSM_C_DLC_CabinMediaCommand*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CabinMediaCommand_NUM_CALLBACK, cbr_apfnSIG_RX_CabinMediaCommand },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CabinMediaCommand_CabinPlaylistCmd_NUM_CALLBACK ,cbr_apfnSIG_RX_CabinMediaCommand_CabinPlaylistCmd }, /* CabinPlaylistCmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CabinMediaCommand_Cabin_TrackCommand_NUM_CALLBACK ,cbr_apfnSIG_RX_CabinMediaCommand_Cabin_TrackCommand }, /* Cabin_TrackCommand */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CabinMediaCommand_Cabin_Tuner_Command_NUM_CALLBACK ,cbr_apfnSIG_RX_CabinMediaCommand_Cabin_Tuner_Command }, /* Cabin_Tuner_Command */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CabinMediaCommand_Cabin_Volume_Command_NUM_CALLBACK ,cbr_apfnSIG_RX_CabinMediaCommand_Cabin_Volume_Command }, /* Cabin_Volume_Command */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  6),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CabinMediaCommand_Cabin_Source_Command_NUM_CALLBACK ,cbr_apfnSIG_RX_CabinMediaCommand_Cabin_Source_Command }, /* Cabin_Source_Command */
#endif
};

const BYTE cbr_aubRX_CabinMediaCommand_DefaultData[] = {0xFC,0xFF,0xF,0x03,0,0,0,0};
const BYTE cbr_aubRX_CabinMediaCommand_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_CabinMediaCommand =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_CabinMediaCommandSignals),
/* prSignals */                 cbr_aubRX_CabinMediaCommandSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_CabinMediaCommand_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_CabinMediaCommand_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};


/*****************************************************************************/
/* RX_Remotecontrol */
/*****************************************************************************/
#define CBR_C_SIG_RX_Remotecontrol_NUM_CALLBACK                   3
#define CBR_C_SIG_RX_Remotecontrol_Encoder2_Steps_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Encoder1_Steps_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Encoder2_Button_NUM_CALLBACK   3
#define CBR_C_SIG_RX_Remotecontrol_Encoder1_Button_NUM_CALLBACK   3
#define CBR_C_SIG_RX_Remotecontrol_Key21_Status_NUM_CALLBACK      3
#define CBR_C_SIG_RX_Remotecontrol_Key20_Status_NUM_CALLBACK      3
#define CBR_C_SIG_RX_Remotecontrol_Key19_Status_NUM_CALLBACK      3
#define CBR_C_SIG_RX_Remotecontrol_Key18_Status_NUM_CALLBACK      3
#define CBR_C_SIG_RX_Remotecontrol_Key17_Status_NUM_CALLBACK      3
#define CBR_C_SIG_RX_Remotecontrol_Key16_Status_NUM_CALLBACK      3
#define CBR_C_SIG_RX_Remotecontrol_Key15_Status_NUM_CALLBACK      3
#define CBR_C_SIG_RX_Remotecontrol_Key14_Status_NUM_CALLBACK      3
#define CBR_C_SIG_RX_Remotecontrol_Key13_Status_NUM_CALLBACK      3
#define CBR_C_SIG_RX_Remotecontrol_Key12_Status_NUM_CALLBACK      3
#define CBR_C_SIG_RX_Remotecontrol_Key11_Status_NUM_CALLBACK      3
#define CBR_C_SIG_RX_Remotecontrol_Key10_Status_NUM_CALLBACK      3
#define CBR_C_SIG_RX_Remotecontrol_Key9_Status_NUM_CALLBACK       3
#define CBR_C_SIG_RX_Remotecontrol_Key8_Status_NUM_CALLBACK       3
#define CBR_C_SIG_RX_Remotecontrol_Key7_Status_NUM_CALLBACK       3
#define CBR_C_SIG_RX_Remotecontrol_Key6_Status_NUM_CALLBACK       3
#define CBR_C_SIG_RX_Remotecontrol_Key5_Status_NUM_CALLBACK       3
#define CBR_C_SIG_RX_Remotecontrol_Key4_Status_NUM_CALLBACK       3
#define CBR_C_SIG_RX_Remotecontrol_Key3_Status_NUM_CALLBACK       3
#define CBR_C_SIG_RX_Remotecontrol_Key2_Status_NUM_CALLBACK       3
#define CBR_C_SIG_RX_Remotecontrol_Key1_Status_NUM_CALLBACK       3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol[ CBR_C_SIG_RX_Remotecontrol_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Encoder2_Steps[ CBR_C_SIG_RX_Remotecontrol_Encoder2_Steps_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Encoder1_Steps[ CBR_C_SIG_RX_Remotecontrol_Encoder1_Steps_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Encoder2_Button[ CBR_C_SIG_RX_Remotecontrol_Encoder2_Button_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Encoder1_Button[ CBR_C_SIG_RX_Remotecontrol_Encoder1_Button_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key21_Status[ CBR_C_SIG_RX_Remotecontrol_Key21_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key20_Status[ CBR_C_SIG_RX_Remotecontrol_Key20_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key19_Status[ CBR_C_SIG_RX_Remotecontrol_Key19_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key18_Status[ CBR_C_SIG_RX_Remotecontrol_Key18_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key17_Status[ CBR_C_SIG_RX_Remotecontrol_Key17_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key16_Status[ CBR_C_SIG_RX_Remotecontrol_Key16_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key15_Status[ CBR_C_SIG_RX_Remotecontrol_Key15_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key14_Status[ CBR_C_SIG_RX_Remotecontrol_Key14_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key13_Status[ CBR_C_SIG_RX_Remotecontrol_Key13_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key12_Status[ CBR_C_SIG_RX_Remotecontrol_Key12_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key11_Status[ CBR_C_SIG_RX_Remotecontrol_Key11_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key10_Status[ CBR_C_SIG_RX_Remotecontrol_Key10_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key9_Status[ CBR_C_SIG_RX_Remotecontrol_Key9_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key8_Status[ CBR_C_SIG_RX_Remotecontrol_Key8_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key7_Status[ CBR_C_SIG_RX_Remotecontrol_Key7_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key6_Status[ CBR_C_SIG_RX_Remotecontrol_Key6_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key5_Status[ CBR_C_SIG_RX_Remotecontrol_Key5_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key4_Status[ CBR_C_SIG_RX_Remotecontrol_Key4_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key3_Status[ CBR_C_SIG_RX_Remotecontrol_Key3_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key2_Status[ CBR_C_SIG_RX_Remotecontrol_Key2_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key1_Status[ CBR_C_SIG_RX_Remotecontrol_Key1_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol[ CBR_C_SIG_RX_Remotecontrol_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Encoder2_Steps[ CBR_C_SIG_RX_Remotecontrol_Encoder2_Steps_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Encoder1_Steps[ CBR_C_SIG_RX_Remotecontrol_Encoder1_Steps_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Encoder2_Button[ CBR_C_SIG_RX_Remotecontrol_Encoder2_Button_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Encoder1_Button[ CBR_C_SIG_RX_Remotecontrol_Encoder1_Button_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key21_Status[ CBR_C_SIG_RX_Remotecontrol_Key21_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key20_Status[ CBR_C_SIG_RX_Remotecontrol_Key20_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key19_Status[ CBR_C_SIG_RX_Remotecontrol_Key19_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key18_Status[ CBR_C_SIG_RX_Remotecontrol_Key18_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key17_Status[ CBR_C_SIG_RX_Remotecontrol_Key17_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key16_Status[ CBR_C_SIG_RX_Remotecontrol_Key16_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key15_Status[ CBR_C_SIG_RX_Remotecontrol_Key15_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key14_Status[ CBR_C_SIG_RX_Remotecontrol_Key14_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key13_Status[ CBR_C_SIG_RX_Remotecontrol_Key13_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key12_Status[ CBR_C_SIG_RX_Remotecontrol_Key12_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key11_Status[ CBR_C_SIG_RX_Remotecontrol_Key11_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key10_Status[ CBR_C_SIG_RX_Remotecontrol_Key10_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key9_Status[ CBR_C_SIG_RX_Remotecontrol_Key9_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key8_Status[ CBR_C_SIG_RX_Remotecontrol_Key8_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key7_Status[ CBR_C_SIG_RX_Remotecontrol_Key7_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key6_Status[ CBR_C_SIG_RX_Remotecontrol_Key6_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key5_Status[ CBR_C_SIG_RX_Remotecontrol_Key5_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key4_Status[ CBR_C_SIG_RX_Remotecontrol_Key4_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key3_Status[ CBR_C_SIG_RX_Remotecontrol_Key3_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key2_Status[ CBR_C_SIG_RX_Remotecontrol_Key2_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key1_Status[ CBR_C_SIG_RX_Remotecontrol_Key1_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_RemotecontrolSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_Remotecontrol*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_NUM_CALLBACK, cbr_apfnSIG_RX_Remotecontrol },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 54,  8),  CSM_C_ALWAYS_IND, CBR_C_SIG_RX_Remotecontrol_Encoder2_Steps_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Encoder2_Steps }, /* Encoder2_Steps */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 46,  8),  CSM_C_ALWAYS_IND, CBR_C_SIG_RX_Remotecontrol_Encoder1_Steps_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Encoder1_Steps }, /* Encoder1_Steps */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 44,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Encoder2_Button_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Encoder2_Button }, /* Encoder2_Button */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 42,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Encoder1_Button_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Encoder1_Button }, /* Encoder1_Button */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key21_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key21_Status }, /* Key21_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 38,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key20_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key20_Status }, /* Key20_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 36,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key19_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key19_Status }, /* Key19_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 34,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key18_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key18_Status }, /* Key18_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key17_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key17_Status }, /* Key17_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 30,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key16_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key16_Status }, /* Key16_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 28,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key15_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key15_Status }, /* Key15_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 26,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key14_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key14_Status }, /* Key14_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key13_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key13_Status }, /* Key13_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 22,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key12_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key12_Status }, /* Key12_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key11_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key11_Status }, /* Key11_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 18,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key10_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key10_Status }, /* Key10_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key9_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key9_Status }, /* Key9_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 14,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key8_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key8_Status }, /* Key8_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key7_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key7_Status }, /* Key7_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 10,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key6_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key6_Status }, /* Key6_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key5_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key5_Status }, /* Key5_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  6,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key4_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key4_Status }, /* Key4_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  4,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key3_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key3_Status }, /* Key3_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key2_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key2_Status }, /* Key2_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key1_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key1_Status }, /* Key1_Status */
#else
  {0, CSM_C_DLC_Remotecontrol*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_NUM_CALLBACK, cbr_apfnSIG_RX_Remotecontrol },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 54,  8),  CSM_C_ALWAYS_IND, CBR_C_SIG_RX_Remotecontrol_Encoder2_Steps_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Encoder2_Steps }, /* Encoder2_Steps */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 46,  8),  CSM_C_ALWAYS_IND, CBR_C_SIG_RX_Remotecontrol_Encoder1_Steps_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Encoder1_Steps }, /* Encoder1_Steps */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 44,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Encoder2_Button_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Encoder2_Button }, /* Encoder2_Button */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 42,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Encoder1_Button_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Encoder1_Button }, /* Encoder1_Button */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key21_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key21_Status }, /* Key21_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 38,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key20_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key20_Status }, /* Key20_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 36,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key19_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key19_Status }, /* Key19_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 34,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key18_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key18_Status }, /* Key18_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key17_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key17_Status }, /* Key17_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 30,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key16_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key16_Status }, /* Key16_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 28,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key15_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key15_Status }, /* Key15_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 26,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key14_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key14_Status }, /* Key14_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key13_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key13_Status }, /* Key13_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 22,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key12_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key12_Status }, /* Key12_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key11_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key11_Status }, /* Key11_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 18,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key10_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key10_Status }, /* Key10_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key9_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key9_Status }, /* Key9_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 14,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key8_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key8_Status }, /* Key8_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key7_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key7_Status }, /* Key7_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 10,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key6_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key6_Status }, /* Key6_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key5_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key5_Status }, /* Key5_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  6,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key4_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key4_Status }, /* Key4_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  4,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key3_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key3_Status }, /* Key3_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key2_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key2_Status }, /* Key2_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key1_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key1_Status }, /* Key1_Status */
#endif
};
const BYTE cbr_aubRX_Remotecontrol_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
const BYTE cbr_aubRX_Remotecontrol_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_Remotecontrol =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_RemotecontrolSignals),
/* prSignals */                 cbr_aubRX_RemotecontrolSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_Remotecontrol_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_Remotecontrol_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_Resp_DeviceInformation2 */
/*****************************************************************************/
#define CBR_C_SIG_RX_Resp_DeviceInformation2_NUM_CALLBACK                 3
#define CBR_C_SIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP_NUM_CALLBACK    3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation2[ CBR_C_SIG_RX_Resp_DeviceInformation2_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP[ CBR_C_SIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP[ CBR_C_SIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation2[ CBR_C_SIG_RX_Resp_DeviceInformation2_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP[ CBR_C_SIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP[ CBR_C_SIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_Resp_DeviceInformation2Signals[] =
{

  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_Resp_DeviceInformation2*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation2_NUM_CALLBACK, cbr_apfnSIG_RX_Resp_DeviceInformation2 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 32),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP }, /* B_SW_Ver_MCP */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32, 32),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP }, /* B_HW_Ver_MCP */
#else
  {0, CSM_C_DLC_Resp_DeviceInformation2*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation2_NUM_CALLBACK, cbr_apfnSIG_RX_Resp_DeviceInformation2 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 32),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP }, /* B_SW_Ver_MCP */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32, 32),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP }, /* B_HW_Ver_MCP */
#endif
};
const BYTE cbr_aubRX_Resp_DeviceInformation2_DefaultData[] = {0,0,0,0,0,0,0,0};
const BYTE cbr_aubRX_Resp_DeviceInformation2_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_Resp_DeviceInformation2 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_Resp_DeviceInformation2Signals),
/* prSignals */                 cbr_aubRX_Resp_DeviceInformation2Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_Resp_DeviceInformation2_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_Resp_DeviceInformation1 */
/*****************************************************************************/
#define CBR_C_SIG_RX_Resp_DeviceInformation1_NUM_CALLBACK            3
#define CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_YY_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_MM_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_DD_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_YY_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_MM_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_DD_NUM_CALLBACK    3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation1[ CBR_C_SIG_RX_Resp_DeviceInformation1_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_YY[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_YY_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_MM[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_DD[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_DD_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_YY[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_YY_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_MM[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_DD[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_DD_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation1[ CBR_C_SIG_RX_Resp_DeviceInformation1_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_YY[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_YY_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_MM[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_DD[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_DD_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_YY[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_YY_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_MM[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_DD[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_DD_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_Resp_DeviceInformation1Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {0, CSM_C_DLC_Resp_DeviceInformation1*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_NUM_CALLBACK, cbr_apfnSIG_RX_Resp_DeviceInformation1 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_YY_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_YY }, /* B_SW_YY */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_MM }, /* B_SW_MM */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_DD_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_DD }, /* B_SW_DD */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_YY_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_YY }, /* B_HW_YY */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_MM }, /* B_HW_MM */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_DD_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_DD }, /* B_HW_DD */
#else
  {0, CSM_C_DLC_Resp_DeviceInformation1*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_NUM_CALLBACK, cbr_apfnSIG_RX_Resp_DeviceInformation1 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_YY_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_YY }, /* B_SW_YY */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_MM }, /* B_SW_MM */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_DD_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_DD }, /* B_SW_DD */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_YY_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_YY }, /* B_HW_YY */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_MM }, /* B_HW_MM */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_DD_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_DD }, /* B_HW_DD */
#endif
};
const BYTE cbr_aubRX_Resp_DeviceInformation1_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0,0};
const BYTE cbr_aubRX_Resp_DeviceInformation1_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_Resp_DeviceInformation1 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_Resp_DeviceInformation1Signals),
/* prSignals */                 cbr_aubRX_Resp_DeviceInformation1Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_Resp_DeviceInformation1_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};



const CSM_CBR_TX csm_arCbrTxTelegram_Slot0 [CBR_TX_MAX_NUMBER_SLOT0]=
{
/*
bus, id ,                                                                       pointer to data buffer,                                                          cycle time
                                        dlc,                                                                                 message type,                             number of repetitions
                                                                                                                                                                            minimum distance
                                                                                                                                                                               delay */
CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff1496L),  CSM_C_DLC_PhoneStatus,                 cbr_aubTX_PhoneStatus_TelData,                CBR_TMSG_CYCLIC_AND_SPONTAN,                 1000,  0, 100,   0,
CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff134cL),  CSM_C_DLC_MediaStatus2,                cbr_aubTX_MediaStatus2_TelData,               CBR_TMSG_CYCLIC_AND_SPONTAN,                    1000,  0, 100,   0,
CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff124cL),  CSM_C_DLC_MediaStatus1,                cbr_aubTX_MediaStatus1_TelData,               CBR_TMSG_CYCLIC_AND_SPONTAN,                 1000,  0, 100,   0,
CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff114cL),  CSM_C_DLC_DeviceStatus,                cbr_aubTX_DeviceStatus_TelData,               CBR_TMSG_CYCLIC,                             1000,  0, 100,   0,
CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff174cL),  CSM_C_DLC_Camera_Status,               cbr_aubTX_Camera_Status_TelData,              CBR_TMSG_CYCLIC_AND_SPONTAN,                 1000,  0, 100,   0,
CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff164cL),  CSM_C_DLC_Display_Mainline,            cbr_aubTX_Display_Mainline_TelData,           CBR_TMSG_NO_TRANSMISSION,                    1000,  0, 100,   0,
CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff154cL),  CSM_C_DLC_CabinMedia_Status,           cbr_aubTX_CabinMedia_Status_TelData,          CBR_TMSG_CYCLIC_AND_SPONTAN,                    1000,  0, 100,   0,
CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff184cL),  CSM_C_DLC_CabinB_Media_Status,         cbr_aubTX_CabinB_Media_Status_TelData,        CBR_TMSG_NO_TRANSMISSION,                    1000,  0, 100,   0,
CSM_C_CAN_BUS_VCAN, MK_ID(0x98fef31cL),  CSM_C_DLC_VehiclePositionNav,          cbr_aubTX_VehiclePositionNav_TelData,         CBR_TMSG_CYCLIC,                    	   1000,  0, 100,   0,
CSM_C_CAN_BUS_MCAN, MK_ID(0x98ff0b4cL),  CSM_C_DLC_KeyIllumination1,            cbr_aubTX_KeyIllumination1_TelData,           CBR_TMSG_CYCLIC,                             1000,  0, 100,   0,
CSM_C_CAN_BUS_MCAN, MK_ID(0x98ff0a4cL),  CSM_C_DLC_KeyIllumination0,            cbr_aubTX_KeyIllumination0_TelData,           CBR_TMSG_CYCLIC,                             1000,  0, 100,   0,
CSM_C_CAN_BUS_MCAN, MK_ID(0x98ff0d4cL),  CSM_C_DLC_KeyColour1,                  cbr_aubTX_KeyColour1_TelData,                 CBR_TMSG_CYCLIC,                             1000,  0, 100,   0,
CSM_C_CAN_BUS_MCAN, MK_ID(0x98ff0c4cL),  CSM_C_DLC_KeyColour0,                  cbr_aubTX_KeyColour0_TelData,                 CBR_TMSG_CYCLIC,                             1000,  0, 100,   0,
CSM_C_CAN_BUS_MCAN, MK_ID(0x98ff0e4cL),  CSM_C_DLC_Req_DeviceInformation,       cbr_aubTX_Req_DeviceInformation_TelData,      CBR_TMSG_SPONTAN,                               0,  0,   0,   0,
} ;

/* ------------------------------------------------------------------------- */
const CSM_TELEGRAM* const cbr_arTxTelegramIndex_Slot0[CBR_TX_MAX_NUMBER_SLOT0] =
{
  &cbr_aubTX_PhoneStatus,
  &cbr_aubTX_MediaStatus2,
  &cbr_aubTX_MediaStatus1,
  &cbr_aubTX_DeviceStatus,
  &cbr_aubTX_Camera_Status,
  &cbr_aubTX_Display_Mainline,
  &cbr_aubTX_CabinMedia_Status,
  &cbr_aubTX_CabinB_Media_Status,
  &cbr_aubTX_VehiclePositionNav,
  &cbr_aubTX_KeyIllumination1,
  &cbr_aubTX_KeyIllumination0,
  &cbr_aubTX_KeyColour1,
  &cbr_aubTX_KeyColour0,
  &cbr_aubTX_Req_DeviceInformation,
 };





const CSM_CBR_RX csm_arCbrRxTelegram_Slot0[CBR_RX_MAX_NUMBER_SLOT0] = {
/* The remote approach uses dlc and message type from this array, */
/* therefore correct IDs, message types and timeouts not necessary */

/*                                            dlc,                                                                                          message type,
    ID                                                                                 address of data buffer,                                                                 timeout time */
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff0217L), CSM_C_DLC_MediaCommand,                    &cbr_aubRX_MediaCommand_TelData,                       CBR_TMSG_CYCLIC,                   1000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff0117L), CSM_C_DLC_SystemEnvironment,               &cbr_aubRX_SystemEnvironment_TelData,                  CBR_TMSG_CYCLIC,                   1000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98fef100L), CSM_C_DLC_CruiseControl,                   &cbr_aubRX_CruiseControl_TelData,                      CBR_TMSG_CYCLIC,                   1000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98fef517L), CSM_C_DLC_AmbientConditions,               &cbr_aubRX_AmbientConditions_TelData,                  CBR_TMSG_CYCLIC,                   10000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98feea17L), CSM_C_DLC_VehicleWeight,                   &cbr_aubRX_VehicleWeight_TelData,                      CBR_TMSG_CYCLIC,                   1000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98fef34aL), CSM_C_DLC_VehiclePosition,                 &cbr_aubRX_VehiclePosition_TelData,                    CBR_TMSG_CYCLIC,                   10000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98fec300L), CSM_C_DLC_ETC5,                            &cbr_aubRX_ETC5_TelData,                               CBR_TMSG_CYCLIC,                   1000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98fe6ceeL), CSM_C_DLC_TCO1,                            &cbr_aubRX_TCO1_TelData,                               CBR_TMSG_CYCLIC,                   200 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98fee6eeL), CSM_C_DLC_TimeDate,                        &cbr_aubRX_TimeDate_TelData,                           CBR_TMSG_CYCLIC,                   10000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff0317L), CSM_C_DLC_RemoteControl,                   &cbr_aubRX_RemoteControl_TelData,                      CBR_TMSG_CYCLIC,                   1000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98d0ff17L), CSM_C_DLC_Illumination,                    &cbr_aubRX_Illumination_TelData,                       CBR_TMSG_CYCLIC,                   10000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff0517L), CSM_C_DLC_SystemEnvironmentExtended,       &cbr_aubRX_SystemEnvironmentExtended_TelData,          CBR_TMSG_CYCLIC,                   1000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff0617L), CSM_C_DLC_Camera_Request,                  &cbr_aubRX_Camera_Request_TelData,                     CBR_TMSG_CYCLIC_AND_SPONTAN,       10000 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff0417L), CSM_C_DLC_CabinMediaCommand,               &cbr_aubRX_CabinMediaCommand_TelData,                  CBR_TMSG_CYCLIC,                   1000 },
{ CSM_C_CAN_BUS_MCAN, MK_ID(0x94ff032cL), CSM_C_DLC_Remotecontrol,                   &cbr_aubRX_Remotecontrol_TelData,                      CBR_TMSG_CYCLIC,                   500 },
{ CSM_C_CAN_BUS_MCAN, MK_ID(0x98ff0f2cL), CSM_C_DLC_Resp_DeviceInformation2,         &cbr_aubRX_Resp_DeviceInformation2_TelData,            CBR_TMSG_SPONTAN,                  0 },
{ CSM_C_CAN_BUS_MCAN, MK_ID(0x98ff0e2cL), CSM_C_DLC_Resp_DeviceInformation1,         &cbr_aubRX_Resp_DeviceInformation1_TelData,            CBR_TMSG_SPONTAN,                  0 },
};


/* ------------------------------------------------------------------------- */
const CSM_TELEGRAM* const cbr_arRxTelegramIndex_Slot0[CBR_RX_MAX_NUMBER_SLOT0] =
{
  &cbr_aubRX_MediaCommand,
  &cbr_aubRX_SystemEnvironment,
  &cbr_aubRX_CruiseControl,
  &cbr_aubRX_AmbientConditions,
  &cbr_aubRX_VehicleWeight,
  &cbr_aubRX_VehiclePosition,
  &cbr_aubRX_ETC5,
  &cbr_aubRX_TCO1,
  &cbr_aubRX_TimeDate,
  &cbr_aubRX_RemoteControl,
  &cbr_aubRX_Illumination,
  &cbr_aubRX_SystemEnvironmentExtended,
  &cbr_aubRX_Camera_Request,
  &cbr_aubRX_CabinMediaCommand,
  &cbr_aubRX_Remotecontrol,
  &cbr_aubRX_Resp_DeviceInformation2,
  &cbr_aubRX_Resp_DeviceInformation1,
};




#endif /* CBR_SELF */

/*****************************************************************************/
/* CNP_ITP */
/*****************************************************************************/
#if (CSM_S_ISO_TP == CSM_C_F_ON)

/*#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
extern const tCSM_ISO_TP_USDT_APPL_CALLBACK_ADMIN csm_itp_arCallbackFkt[ CSM_C_ISO_TP_MAX_CONNECTIONS];
#else
extern tCSM_ISO_TP_USDT_APPL_CALLBACK_ADMIN csm_itp_arCallbackFkt[ CSM_C_ISO_TP_MAX_CONNECTIONS];
#endif

#ifdef CSM_ITP_SELF

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)

const tCSM_ISO_TP_USDT_APPL_CALLBACK_ADMIN csm_itp_arCallbackFkt[ CSM_C_ISO_TP_MAX_CONNECTIONS] =
{
   {
      NULL, NULL, CCS_NP_vCSMMsgCon, CCS_NP_vCSMMsgReceived, CCS_NP_vCSMDataErrorInd
   },
   {
      NULL, NULL, NULL, NULL
   },
   {
      NULL, NULL, NULL, NULL
   }
};
#else
tCSM_ISO_TP_USDT_APPL_CALLBACK_ADMIN csm_itp_arCallbackFkt[ CSM_C_ISO_TP_MAX_CONNECTIONS];
#endif

#endif *//* CSM_ITP_SELF */


#endif /* CSM_S_ISO_TP */

#if (CSM_S_ISO_TP == CSM_C_F_ON)
#ifdef CNP_ITP_SELF
/* "malloc" RxAssembly and Tx buffer
 * Take care of channel number and length defined above */

BYTE cnp_abAssBufCh0[ CSM_C_USDT_ISO_INF4CV_USDT_ISO_EXTKI_MAX_RX_LENGTH];
BYTE cnp_abTxBufCh0[ CSM_C_USDT_ISO_INF4CV_USDT_ISO_EXTKI_MAX_TX_LENGTH];

BYTE cnp_abAssBufCh1[ CSM_C_USDT_ISO_DTCCT_USDT_ISO_DIAG_MAX_RX_LENGTH];
BYTE cnp_abTxBufCh1[ CSM_C_USDT_ISO_DTCCT_USDT_ISO_DIAG_MAX_TX_LENGTH];

BYTE cnp_abAssBufCh2[ CSM_C_USDT_ISO_INF4CV_USDT_ISO_EXTKI_MAX_RX_LENGTH];
BYTE cnp_abTxBufCh2[ CSM_C_USDT_ISO_INF4CV_USDT_ISO_EXTKI_MAX_TX_LENGTH];


    /* Macros to initialize the buffers (no way found to place CNP_rItpAssRxBuf[0] in ROM) */
#define CNP_M_INIT_ASS_BUF_ARRAY \
                 CNP_rItpAssRxBuf[0].rMsg.pbData=cnp_abAssBufCh0;\
                 CNP_rItpAssRxBuf[1].rMsg.pbData=cnp_abAssBufCh1;\
         CNP_rItpAssRxBuf[2].rMsg.pbData=cnp_abAssBufCh2;\


#define CNP_M_INIT_TX_BUF_ARRAY \
                 CNP_rItpTxBuf[0].rMsg.pbData=cnp_abTxBufCh0;\
                 CNP_rItpTxBuf[1].rMsg.pbData=cnp_abTxBufCh1;\
         CNP_rItpTxBuf[2].rMsg.pbData=cnp_abTxBufCh2;\


#endif /* CNP_ITP_SELF */
#endif /* CSM_S_ISO_TP */


//**************************************************************************************************
//* CBR configuration, variables (Generated code - do NOT change manually !!!)
//**************************************************************************************************


