//**************************************************************************************************
//* defines CSM wide (Generated code - do NOT change manually !!!)
//**************************************************************************************************
// Temporary Wakeup used in CSM_lSignalWrite() for all NON-VW projects
#if (CSM_S_BUS_WAKE_TEMP == CSM_C_F_ON)
#define CSM_C_WAKE_TEMP_TIME    11000              // keep awake time = 11s
#endif

#define CSM_LCTR_C_MAX_USER           5              // Number of local control users (LCM,SPM for VCAN and MCAN, IGN for VCAN, on iMX for symmetry only)
#define CSM_CBR_MAX_USER              2             // Number of cbr users (only VCAN is for CBR)
#define CSM_C_MAX_ERROR_IND_USER     10              // Number of error indication user
#define CSM_APL_MAX_CONFIG_SLOTS     1              // Max. Number of configuration slots
#define CSM_APL_INVALID_CONFIG_SLOT  0xFF            // in case of error (reading from NVM)

#define CSM_C_CAN_CONFIG_SLOT_0      0x00            // slot 0


#define CSM_APL_C_READ_SLOT          0x00            // trace subcmd to trigger a slot read
#define CSM_APL_C_READ_EARLYNOR_SLOT 0x00            // subcmd to Read Slot from Early Nor
#define CSM_APL_C_INIT_DATAPOOL      0x01            // trace subcmd to trigger a re-init of the datapool after KDS writing
#define CSM_APL_C_CHECK_INC_COM      0x02            // trace subcmd to check if INC connection to CCS is active
#define CSM_APL_C_SET_DP_ITEM        0x03            // trace subcmd to set a certain datapool item
#define CSM_APL_C_SET_DLT_LOGLEVEL   0x04            // trace subcmd to set a certain loglevel for a certain module on v850
#define CSM_APL_C_SET_ISOTP_BS       0x05            // trace subcmd to set the blocksize for ISO-TP on v850



// ##################################################
// _CSM_SECTION_HISTORY: user specific code start
// ##################################################

/*****************************************************************************/
/* CSM_STACK (down/up strem task) */
/*****************************************************************************/
#define CSM_M_UPSTREAM_TASK_LOCK()                CSM_iInterruptsDisable()
#define CSM_M_UPSTREAM_TASK_UNLOCK(iIsrStat)      CSM_vInterruptsRestore(iIsrStat)
#define CSM_M_DOWNSTREAM_TASK_LOCK()              CSM_iInterruptsDisable()
#define CSM_M_DOWNSTREAM_TASK_UNLOCK(iIsrStat)    CSM_vInterruptsRestore(iIsrStat)
// CSM_C_DOWN_REASON_...    List of all used triggers for the Downstream Task

#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_OSEK_NM == CSM_C_F_ON)
#define CSM_C_DOWN_REASON_OSEK_TIMEOUT              0x00000400ul
#endif /* CSM_S_OSEK_NM */
#endif /* CSM_S_CNM_AVAILABLE */

// CSM_C_DOWN_REASON_...    List of all used triggers for the Downstream Task
#define CSM_C_DOWN_REASON_CSM_BUS_STATE_CHANGED         0x00000000ul
#define CSM_C_DOWN_REASON_CSM_COMMUNICATION_REQ         0x00000040ul
#define CSM_C_DOWN_REASON_CBR_SEND                      0x00000080ul
#define CSM_C_DOWN_REASON_CBR_TIMEOUT                   0x00000100ul
#define CSM_C_DOWN_REASON_CBR_COMMUNICATION_REQ         0x00000200ul
#define CSM_C_DOWN_REASON_CNM_OSEKI_COMMUNICATION_REQ   0x00000400ul
//#define CSM_C_DOWN_REASON_ITP_DATA_REQ                  0x00000800ul
#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_OSEK_NM == CSM_C_F_ON)
#define CSM_C_DOWN_REASON_OSEK_TIMEOUT              0x00000800ul
#endif /* CSM_S_OSEK_NM */
#endif /* CSM_S_CNM_AVAILABLE */
#define CSM_C_DOWN_REASON_CNP_ITP_COMMUNICATION_REQ     0x00001000ul
#define CSM_C_DOWN_REASON_IPC_LOCAL_BR_REQ_TX           0x00002000ul
#define CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX         0x01000000uL       // NP (TP) data from INC available
#define CSM_C_DOWN_REASON_IPC_REMOTE_NET_DATA_RX        0x02000000uL       // NET data from INC available
#define CSM_C_DOWN_REASON_IPC_REMOTE_BR_DATA_RX         0x04000000uL       // BR data from INC available
#define CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ         0x08000000uL
#define CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ         0x10000000uL
#define CSM_C_DOWN_REASON_CSM_IND_RADIOSTATUSCHANGED    0x20000000uL
#define CSM_C_DOWN_REASON_IPC_PROXY_TX_TIMEOUT          0x40000000uL       // OSAL timeout LINUX, TX to INC for BR, NET, NP
#define CSM_C_DOWN_REASON_IPC_LOCAL_NET_REQ_TX          0x80000000uL

// CSM_C_IND_REASON_...   List of all used triggers for the Upstream Task
// CSM_C_IND_REASON_...   List of all used triggers for the Upstream Task
#if (CSM_S_CSM_LOCAL_CTRL == CSM_C_F_ON)
#define CSM_C_IND_REASON_CSM_COMMUNICATION_CON          0x00000001ul
#define CSM_C_IND_REASON_CSM_COMMUNICATION_IND          0x00000002ul
#endif /* CSM_S_CSM_LOCAL_CTRL */
#define CSM_C_IND_REASON_CBR_SIGNAL_IND                 0x00000004ul
#define CSM_C_IND_REASON_CBR_COMMUNICATION_IND          0x00000008ul
#define CSM_C_IND_REASON_CBR_COMMUNICATION_CON          0x00000010ul
//#define CSM_C_IND_REASON_CSM_MPDT_DATA_IND              0x00000020ul
//#define CSM_C_IND_REASON_CSM_MPDT_DATA_CON              0x00000040ul
//#define CSM_C_IND_REASON_CSM_MPDT_COMMUNICATION_IND     0x00000080ul
//#define CSM_C_IND_REASON_CSM_MPDT_COMMUNICATION_CON     0x00000100ul
#define CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_IND      0x00000200ul
#define CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_CON      0x00000400ul
//#define CSM_C_IND_REASON_ITP_DATA_CON                   0x00000800ul       // give an ISO-TP data confirmation (TX done or Timeout)
//#define CSM_C_IND_REASON_ITP_DATA_IND                   0x00001000ul       // give an ISO-TP data indication (upstream)
#define CSM_C_IND_REASON_BUS_ERROR                      0x00080000ul
#define CSM_C_IND_REASON_CSM_OSEKI_NM_STATE_CHANGED     0x00100000ul


//**************************************************************************************************
//* defines for CBR (Generated code - do NOT change manually !!!)
//**************************************************************************************************
// define the amount of CBR broadcast messages (TX and RX) here
#define CBR_RX_MAX_NUMBER_SLOT0       (24)   // #ToDo: This was automatically corrected from 0 to 1
#define CBR_TX_MAX_NUMBER_SLOT0       (9)
#define CBR_RX_ABSOLUT_MAX_NUMBER     (24)
#define CBR_TX_ABSOLUT_MAX_NUMBER     (9)
#define CBR_RX_MAX_NUMBER             bCbrRxMaxNumber            // replace define by var in code
#define CBR_TX_MAX_NUMBER             bCbrTxMaxNumber            // replace define by var in code

/*****************************************************************************/
/* CSM CAN identifyer */
/*****************************************************************************/

/* CAN1/VCAN */
#define CSM_C_TX_ID_RQST2TCO         0x98eaeeffL /* 0xc757L */
#define CSM_C_TX_ID_CMC_C01_AR       0x98ff0154L /* 0xc7f8L */
#define CSM_C_TX_ID_NM_HUS_AR        0x98ff8054L /* 0xc7fcL */
#define CSM_C_TX_ID_HUS_DM1          0x10feca54L /* 0x87f6L */ 

#define CSM_C_RX_ID_EAM3_B34         0x98ff288cL /* 0xc7f9L */
#define CSM_C_RX_ID_EAM3_B33         0x98ff3f8cL /* 0xc7f9L */
#define CSM_C_RX_ID_ICUC_C10         0x98ff0817L /* 0xc7f8L */
#define CSM_C_RX_ID_SCA_E1           0x98ff0721L /* 0xc7f8L */
#define CSM_C_RX_ID_SCH_E1           0x98ff0447L /* 0xc7f8L */
#define CSM_C_RX_ID_WMI_C02          0x98ff024cL /* 0xc7f8L */
#define CSM_C_RX_ID_TPCM_TCO         0x98ecffeeL /* 0xc767L */
#define CSM_C_RX_ID_TPDT_TCO         0x98ebffeeL /* 0xc75fL */
#define CSM_C_RX_ID_TCO1_ICUC        0x8cfe6c17L /* 0x67f3L */
#define CSM_C_RX_ID_DI_Shrt_TCO      0x98fe6beeL /* 0xc7f3L */
#define CSM_C_RX_ID_NM_APPL_NWT_AR   0x98ff8026L /* 0xc7fcL */
#define CSM_C_RX_ID_SCA_C2           0x90ff0021L /* 0x87f8L */
#define CSM_C_RX_ID_ETC2_CPC         0x94f00500L /* 0xa780L */
#define CSM_C_RX_ID_EBC2_BS          0x94febf0bL /* 0xa7f5L */
#define CSM_C_RX_ID_ICUC_C2          0x94ff0017L /* 0xa7f8L */
#define CSM_C_RX_ID_TD_ICUC          0x98fee617L /* 0xc7f7L */
#define CSM_C_RX_ID_ICUC_C1          0x98ff0017L /* 0xc7f8L */
#define CSM_C_RX_ID_CGW_C1           0x98ff0025L /* 0xc7f8L */
#define CSM_C_RX_ID_CGW_GVC1         0x98ffc025L /* 0xc7feL */
#define CSM_C_RX_ID_CGW_VIN          0x98ffc825L /* 0xc7feL */
#define CSM_C_RX_ID_EAM3_B30         0x98ff3b8cL /* 0xc7f9L */

/* CAN2/MCAN */
/*TX*/
#define CSM_C_TX_ID_KeyIllumination1              0x98ff0b4cL /* 0xc7f8L */
#define CSM_C_TX_ID_KeyIllumination0              0x98ff0a4cL /* 0xc7f8L */
#define CSM_C_TX_ID_KeyColour1                    0x98ff0d4cL /* 0xc7f8L */
#define CSM_C_TX_ID_KeyColour0                    0x98ff0c4cL /* 0xc7f8L */
#define CSM_C_TX_ID_Req_DeviceInformation         0x98ff0e4cL /* 0xc7f8L */

/*RX*/
#define CSM_C_RX_ID_Remotecontrol                 0x94ff032cL /* 0xa7f8L */
#define CSM_C_RX_ID_Resp_DeviceInformation2       0x98ff0f2cL /* 0xc7f8L */
#define CSM_C_RX_ID_Resp_DeviceInformation1       0x98ff0e2cL /* 0xc7f8L */


//**************************************************************************************************
//* CSM Timer configuration (Generated code - do NOT change manually !!!)
//**************************************************************************************************
// The timer configuration of the Proxy is totally different from the real CSM !!!
enum
{
  // ATTENTION: adapting the amount of timers here requires further adaptions at other places
  CSM_TIMER_DUMMY = 0,                            // is always needed to have at least 1 entry
  CSM_TIMER_NET_LCTRL,                            // net ctrl
  CSM_TIMER_NET_LCTRL_USER_0,                     // net ctrl user 0 from LCTRL config
  CSM_TIMER_NET_LCTRL_USER_1,                     // net ctrl user 1 from LCTRL config
  CSM_TIMER_NET_OSEKI,                            // net OSEKI
  CSM_TIMER_BRSIGNAL,                             // broadcast
  CSM_TIMER_NP1_COM,                              // np1  -> chn. index 0
  CSM_TIMER_NP1_TX,                            // np1  -> chn. index 0
  CSM_TIMER_NP1_RX,                            // np1  -> chn. index 0
  CSM_TIMER_NP2_COM,                              // np2  -> chn. index 1
  CSM_TIMER_NP2_TX,                            // np2  -> chn. index 1
  CSM_TIMER_NP2_RX,                            // np2  -> chn. index 1
  CSM_TIMER_NP3_COM,                              // np3  -> chn. index 2
  CSM_TIMER_NP3_TX,                            // np3  -> chn. index 2
  CSM_TIMER_NP3_RX,                            // np3  -> chn. index 2
  CSM_TIMER_NP4_COM,                              // np4  -> chn. index 3
  CSM_TIMER_NP4_TX,                            // np4  -> chn. index 3
  CSM_TIMER_NP4_RX,                            // np4  -> chn. index 3
  CSM_TIMER_NP5_COM,                              // np5  -> chn. index 4
  CSM_TIMER_NP5_TX,                            // np5  -> chn. index 4
  CSM_TIMER_NP5_RX,                            // np5  -> chn. index 4
  CSM_TIMER_NP6_COM,                              // np6  -> chn. index 5
  CSM_TIMER_NP6_TX,                            // np6  -> chn. index 5
  CSM_TIMER_NP6_RX,                            // np6  -> chn. index 5
  CSM_TIMER_NP7_COM,                              // np7  -> chn. index 6
  CSM_TIMER_NP7_TX,                            // np7  -> chn. index 6
  CSM_TIMER_NP7_RX,                            // np7  -> chn. index 6
  CSM_TIMER_NP8_COM,                              // np8  -> chn. index 7
  CSM_TIMER_NP8_TX,                            // np8  -> chn. index 7
  CSM_TIMER_NP8_RX,                            // np8  -> chn. index 7
  CSM_TIMER_NP9_COM,                              // np9  -> chn. index 8
  CSM_TIMER_NP9_TX,                            // np9  -> chn. index 8
  CSM_TIMER_NP9_RX,                            // np9  -> chn. index 8
  CSM_TIMER_NP10_COM,                             // np10 -> chn. index 9
  CSM_TIMER_NP10_TX,                           // np10 -> chn. index 9
  CSM_TIMER_NP10_RX,                           // np10 -> chn. index 9
  CSM_TIMER_NP11_COM,                             // np11 -> chn. index 10
  CSM_TIMER_NP11_TX,                           // np11 -> chn. index 10
  CSM_TIMER_NP11_RX,                           // np11 -> chn. index 10
  CSM_MAX_TIMER
};
#define CSM_C_MAX_TIMER    CSM_MAX_TIMER          // make define from enum


/*****************************************************************************/
/* CBR */
/*****************************************************************************/
#if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
#define CBR_M_INIT_VARS()  /**< empty */

#define CBR_MAX_APPL_ID  3

/* DLC for CAN1/VCAN Messages*/
#define CSM_C_DLC_RQST2TCO            3  /**< data length*/
#define CSM_C_DLC_CMC_C01_AR          8  /**< data length*/
#define CSM_C_DLC_NM_HUS_AR           8  /**< data length*/
#define CSM_C_DLC_HUS_DM1             8  /**< data length*/

#define CSM_C_DLC_EAM3_B34            8  /**< data length*/
#define CSM_C_DLC_EAM3_B33            8  /**< data length*/
#define CSM_C_DLC_ICUC_C10            8  /**< data length*/
#define CSM_C_DLC_SCA_E1              8  /**< data length*/
#define CSM_C_DLC_SCH_E1              8  /**< data length*/
#define CSM_C_DLC_WMI_C02             8  /**< data length*/
#define CSM_C_DLC_TPCM_TCO            8  /**< data length*/
#define CSM_C_DLC_TPDT_TCO            8  /**< data length*/
#define CSM_C_DLC_TCO1_ICUC           8  /**< data length*/
#define CSM_C_DLC_DI_Shrt_TCO         8  /**< data length*/
#define CSM_C_DLC_NM_APPL_NWT_AR      8  /**< data length*/
#define CSM_C_DLC_SCA_C2              8  /**< data length*/
#define CSM_C_DLC_ETC2_CPC            8  /**< data length*/
#define CSM_C_DLC_EBC2_BS             8  /**< data length*/
#define CSM_C_DLC_ICUC_C2             8  /**< data length*/
#define CSM_C_DLC_TD_ICUC             8  /**< data length*/
#define CSM_C_DLC_ICUC_C1             8  /**< data length*/
#define CSM_C_DLC_CGW_C1              8  /**< data length*/
#define CSM_C_DLC_CGW_GVC1            8  /**< data length*/
#define CSM_C_DLC_CGW_VIN             8  /**< data length*/
#define CSM_C_DLC_EAM3_B30            8  /**< data length*/

/* DLC for CAN2/MCAN Messages*/
/*TX*/
#define CSM_C_DLC_KeyIllumination1          8  /**< data length*/
#define CSM_C_DLC_KeyIllumination0          8  /**< data length*/
#define CSM_C_DLC_KeyColour1                8  /**< data length*/
#define CSM_C_DLC_KeyColour0                8  /**< data length*/
#define CSM_C_DLC_Req_DeviceInformation     1  /**< data length*/

/*RX*/
#define CSM_C_DLC_Remotecontrol             8  /**< data length*/
#define CSM_C_DLC_Resp_DeviceInformation2   8  /**< data length*/
#define CSM_C_DLC_Resp_DeviceInformation1   8  /**< data length*/

#define CSM_M_GET_SIGNAL_ID_FROM_VIRTUAL_SIGNAL_ID(a) a   /* in case no virtual signals are used.. */
#define CSM_M_CHECK_FOR_VALID_SIGNAL_ID(a)            1   /* in case no virtual signals are used.. */

#endif /* CSM_S_CBR_AVAILABLE */


/*****************************************************************************/
/* CNM_OSEK */
/*****************************************************************************/
#define CNM_OSEKI_NR_OF_RX_NODE_MONITORS_VCAN      2  // max. value of RX monitors
#define NO_OF_ACTIVE_RX_MONITORS_VCAN              2  // configured nr. of RX monitors (refer to cnm_oseki_mp.h)
#define CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN      2

#define CNM_OSEKI_NR_OF_RX_NODE_MONITORS_MCAN      2  // max. value of RX monitors MCAN
#define NO_OF_ACTIVE_RX_MONITORS_MCAN              2  // configured nr. of RX monitors (refer to cnm_oseki_mp.h)
#define CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN      2

#define NO_OF_ACTIVE_BUSOFF_MONITORS               2
#define CSM_NWM_C_MAX_COMMAND_USER                 2   // amount of users using CommunicationReq on OSEKI NM

/* this define is important for the configuration table csm_arNWMCfg[]       */
/* DO NOT change this group -> only change single defines above              */
#define CSM_NWM_C_MAX_USER     ( NO_OF_ACTIVE_RX_MONITORS_VCAN +  \
                                 CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_VCAN +  \
                 NO_OF_ACTIVE_RX_MONITORS_MCAN +\
                 CNM_OSEKI_NR_OF_TX_MUTE_MONITORS_MCAN +\
                                 NO_OF_ACTIVE_BUSOFF_MONITORS          +  \
                                 CSM_NWM_C_MAX_COMMAND_USER )

//**************************************************************************************************
//* for CSM_STACK_[OS]  (Generated code - do NOT change manually !!!)
//**************************************************************************************************
// CSM Timer OS dependent configuration
#ifdef CSM_STACK_ENV_SELF   // map the following definitions in csm_stack_[OS].c

// Timer Timeout-Callback prototypes
#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_OSEKI_NM == CSM_C_F_ON)
// empty
#endif
#endif

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_MPDT == CSM_C_F_ON)
// empty
#endif
#endif

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_ISO_TP == CSM_C_F_ON)
void CNP_ITP_vTxTimerExpired(DWORD dwValue);
void CNP_ITP_vRxTimerExpired(DWORD dwValue);
#endif
#endif

#if (CSM_S_REMOTE_STACK == CSM_C_F_ON)
  extern void  CSM_PROXY_vTimeout( DWORD wTimerId);
#endif
// ########################################
// _CSM_SECTION2: user specific code start
// ########################################

// #######################################
// _CSM_SECTION2: user specific code end
// #######################################
//**************************************************************************************************
//* CSM Timer instances (Generated code - do NOT change manually !!!)
//**************************************************************************************************
// array with callbacks for timer system
const tCSM_TIMER csm_arTimer[ CSM_MAX_TIMER] =
{
  {NULL, 0}, /* CSM_TIMER_DUMMY */
  {CSM_PROXY_vTimeout,  1},                         // CSM_TIMER_NET_LCTRL
  {CSM_PROXY_vTimeout,  2},                         // CSM_TIMER_NET_LCTRL USER 0 from LCTRL config
  {CSM_PROXY_vTimeout,  3},                         // CSM_TIMER_NET_LCTRL USER 1 from LCTRL config
  {CSM_PROXY_vTimeout,  4},                         // CSM_TIMER_NET_OSEKI
  {CSM_PROXY_vTimeout,  5},                         // CSM_TIMER_BRSIGNAL
  {CSM_PROXY_vTimeout,  6},                         // np1  -> chn. index 0
  {CSM_PROXY_vTimeout,  7},                         // np1  -> chn. index 0
  {CSM_PROXY_vTimeout,  8},                         // np1  -> chn. index 0
  {CSM_PROXY_vTimeout,  9},                         // np2  -> chn. index 1
  {CSM_PROXY_vTimeout, 10},                         // np2  -> chn. index 1
  {CSM_PROXY_vTimeout, 11},                         // np2  -> chn. index 1
  {CSM_PROXY_vTimeout, 12},                         // np3  -> chn. index 2
  {CSM_PROXY_vTimeout, 13},                         // np3  -> chn. index 2
  {CSM_PROXY_vTimeout, 14},                         // np3  -> chn. index 2
  {CSM_PROXY_vTimeout, 15},                         // np4  -> chn. index 3
  {CSM_PROXY_vTimeout, 16},                         // np4  -> chn. index 3
  {CSM_PROXY_vTimeout, 17},                         // np4  -> chn. index 3
  {CSM_PROXY_vTimeout, 18},                         // np5  -> chn. index 4
  {CSM_PROXY_vTimeout, 19},                         // np5  -> chn. index 4
  {CSM_PROXY_vTimeout, 20},                         // np5  -> chn. index 4
  {CSM_PROXY_vTimeout, 21},                         // np6  -> chn. index 5
  {CSM_PROXY_vTimeout, 22},                         // np6  -> chn. index 5
  {CSM_PROXY_vTimeout, 23},                         // np6  -> chn. index 5
  {CSM_PROXY_vTimeout, 24},                         // np7  -> chn. index 6
  {CSM_PROXY_vTimeout, 25},                         // np7  -> chn. index 6
  {CSM_PROXY_vTimeout, 26},                         // np7  -> chn. index 6
  {CSM_PROXY_vTimeout, 27},                         // np8  -> chn. index 7
  {CSM_PROXY_vTimeout, 28},                         // np8  -> chn. index 7
  {CSM_PROXY_vTimeout, 29},                         // np8  -> chn. index 7
  {CSM_PROXY_vTimeout, 30},                         // np9  -> chn. index 8
  {CSM_PROXY_vTimeout, 31},                         // np9  -> chn. index 8
  {CSM_PROXY_vTimeout, 32},                         // np9  -> chn. index 8
  {CSM_PROXY_vTimeout, 33},                         // np10 -> chn. index 9
  {CSM_PROXY_vTimeout, 34},                         // np10 -> chn. index 9
  {CSM_PROXY_vTimeout, 35},                         // np10 -> chn. index 9
  {CSM_PROXY_vTimeout, 36},                         // np11 -> chn. index 10
  {CSM_PROXY_vTimeout, 37},                         // np11 -> chn. index 10
  {CSM_PROXY_vTimeout, 38},                         // np11 -> chn. index 10
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
#if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
  {CBR_vTransmitTimeout, 0},
  {CBR_vTransmitTimeout, 1},
  {CBR_vTransmitTimeout, 2},
  {CBR_vTransmitTimeout, 3},
  {CBR_vTransmitTimeout, 4},
#if (CSM_S_CBR_MIN_DELAY == CSM_C_F_ON)
  {CBR_vTransmitMinDelayTimeout, 0},
  {CBR_vTransmitMinDelayTimeout, 1},
  {CBR_vTransmitMinDelayTimeout, 2},
  {CBR_vTransmitMinDelayTimeout, 3},
  {CBR_vTransmitMinDelayTimeout, 4},
#endif /* CSM_S_CBR_MIN_DELAY */
  {CBR_vReceiveTimeout, 0},
  {CBR_vReceiveTimeout, 1},
  {CBR_vReceiveTimeout, 2},
  {CBR_vReceiveTimeout, 3},
  {CBR_vReceiveTimeout, 4},
  {CBR_vReceiveTimeout, 5},
  {CBR_vReceiveTimeout, 6},
  {CBR_vReceiveTimeout, 7},
  {CBR_vReceiveTimeout, 8},
  {CBR_vReceiveTimeout, 9},
  {CBR_vReceiveTimeout, 10},
  {CBR_vReceiveTimeout, 11},
  {CBR_vReceiveTimeout, 12},
#endif /* CSM_S_CBR_AVAILABLE */
#endif /* CSM_S_REMOTE_STACK */
#if (CSM_S_BUS_WAKE_TEMP == CSM_C_F_ON)
  {csm_vWakeTempTimeout, 0},
#endif /* CSM_S_BUS_WAKE_TEMP */

#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_OSEK_NM == CSM_C_F_ON)
  {CSM_vCNMBusoffReinitTimerExpired, 0},
  {CNM_OSEK_vTimer, 0},
#endif /* CSM_S_OSEK_NM */
#endif /* CSM_S_CNM_AVAILABLE */

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_ISO_TP == CSM_C_F_ON)
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CNP_ITP_vTxTimerExpired, 0}, /*CSM_TIMER_ITP_TX_CH0X*/
  {CNP_ITP_vTxTimerExpired, 1}, /*CSM_TIMER_ITP_TX_CH1X*/
  {CNP_ITP_vTxTimerExpired, 2}, /*CSM_TIMER_ITP_TX_CH2X*/

  {CNP_ITP_vRxTimerExpired, 0}, /*CSM_TIMER_ITP_RX_CH0X*/
  {CNP_ITP_vRxTimerExpired, 1}, /*CSM_TIMER_ITP_RX_CH1X*/
  {CNP_ITP_vRxTimerExpired, 2}, /*CSM_TIMER_ITP_RX_CH2X*/
  #endif
#endif /* CSM_S_ISO_TP */
#endif /* CSM_S_CNP_AVAILABLE */
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
  {CSM_APL_vUpdateUserData, 0},
#endif /* CSM_S_CNP_AVAILABLE */
};
#endif // CSM_STACK_ENV_SELF



#ifdef CBR_SELF
/*
    SS    SSSSS   S    S    SSSS
   S  S   S       S    S    S   S
   S      S       SS   S    S    S
    S     SSS     SSS  S    S    S
     S    S       S  SSS    S    S
      S   S       S   SS    S    S
   S  S   S       S    S    S   S
    SS    SSSSS   S    S    SSSS
*/
/********************************************/
/* TX Data */
/********************************************/
/*CAN1/VCAN*/
BYTE cbr_aubTX_RQST2TCO_TelData[ CSM_C_DLC_RQST2TCO];
BYTE cbr_aubTX_CMC_C01_AR_TelData[ CSM_C_DLC_CMC_C01_AR];
BYTE cbr_aubTX_NM_HUS_AR_TelData[ CSM_C_DLC_NM_HUS_AR];
BYTE cbr_aubTX_HUS_DM1_TelData[ CSM_C_DLC_HUS_DM1];

/*CAN2/MCAN*/
BYTE cbr_aubTX_KeyIllumination1_TelData[ CSM_C_DLC_KeyIllumination1];
BYTE cbr_aubTX_KeyIllumination0_TelData[ CSM_C_DLC_KeyIllumination0];
BYTE cbr_aubTX_KeyColour1_TelData[ CSM_C_DLC_KeyColour1];
BYTE cbr_aubTX_KeyColour0_TelData[ CSM_C_DLC_KeyColour0];
BYTE cbr_aubTX_Req_DeviceInformation_TelData[ CSM_C_DLC_Req_DeviceInformation];

/*****************************************************************************/
/* TX_RQST2TCO */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_RQST2TCOSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 24),  CBR_TMSG_SPONTAN, 0, NULL },  /* PGN_Rqst2TCO */
};
const BYTE cbr_aubTX_RQST2TCO_DefaultData[] = {0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubTX_RQST2TCO =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_RQST2TCOSignals),
/* prSignals */                 cbr_aubTX_RQST2TCOSignals,
/* pvTeleGramDefaultData */     cbr_aubTX_RQST2TCO_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_CMC_C01_AR */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_CMC_C01_ARSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 0,  64),  CBR_TMSG_SPONTAN, 0, NULL },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* Cam1_ManAct_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* Cam2_ManAct_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  4,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* Cam3_ManAct_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  6,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* Cam4_ManAct_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* Cam5_ManAct_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 10,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* Cam6_ManAct_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* Cam7_ManAct_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* DispCamCls_Rq */
};
const BYTE cbr_aubTX_CMC_C01_AR_DefaultData[] = {0xFF,0x3F,0x03,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubTX_CMC_C01_AR =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_CMC_C01_ARSignals),
/* prSignals */                 cbr_aubTX_CMC_C01_ARSignals,
/* pvTeleGramDefaultData */     cbr_aubTX_CMC_C01_AR_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_NM_HUS_AR */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_NM_HUS_ARSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 0,  64),  CBR_TMSG_SPONTAN, 0, NULL },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CBR_TMSG_SPONTAN, 0, NULL },  /* WakeupRsn_HUS */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  1),  CBR_TMSG_SPONTAN, 0, NULL },  /* Awake_NwSt */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 25,  1),  CBR_TMSG_SPONTAN, 0, NULL },  /* Awake_Diag_Actv */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 26,  1),  CBR_TMSG_SPONTAN, 0, NULL },  /* Awake_IgnOn */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 28,  1),  CBR_TMSG_SPONTAN, 0, NULL },  /* Awake_DispOn_Rq */
};
const BYTE cbr_aubTX_NM_HUS_AR_DefaultData[] = {0,0,0xFF,0x17,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubTX_NM_HUS_AR =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_NM_HUS_ARSignals),
/* prSignals */                 cbr_aubTX_NM_HUS_ARSignals,
/* pvTeleGramDefaultData */     cbr_aubTX_NM_HUS_AR_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_HUS_DM1 */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_HUS_DM1Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 64),  CBR_TMSG_SPONTAN, 0, NULL },  /* HUS_DM1 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 47,  1),  CBR_TMSG_SPONTAN, 0, NULL },  /* DTC_SPN_ConvMd_HUS */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  7),  CBR_TMSG_SPONTAN, 0, NULL },  /* DTC_OccCnt_HUS */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16, 24),  CBR_TMSG_SPONTAN, 0, NULL },  /* DTC_Stat_HUS */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 14,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* DTC_MIL_Flash_Stat_HUS */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* DTC_RSL_Flash_Stat_HUS */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 10,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* DTC_AWL_Flash_Stat_HUS */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* DTC_PL_Flash_Stat_HUS */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  6,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* DTC_MIL_Stat_HUS */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  4,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* DTC_RSL_Stat_HUS */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* DTC_AWL_Stat_HUS */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  2),  CBR_TMSG_SPONTAN, 0, NULL },  /* DTC_PL_Stat_HUS */
};
const BYTE cbr_aubTX_HUS_DM1_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0x7F,0xFF,0xFF};
/***********************/
const CSM_TELEGRAM cbr_aubTX_HUS_DM1 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_HUS_DM1Signals),
/* prSignals */                 cbr_aubTX_HUS_DM1Signals,
/* pvTeleGramDefaultData */     cbr_aubTX_HUS_DM1_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_KeyIllumination1 */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_KeyIllumination1Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 0,  64),  CBR_TMSG_CYCLIC, 0, NULL },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Reserved */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Reserved */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Encoder2_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Encoder1_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key12_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key11_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key10_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key9_Illumination */
};
const BYTE cbr_aubTX_KeyIllumination1_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
/***********************/
const CSM_TELEGRAM cbr_aubTX_KeyIllumination1 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_KeyIllumination1Signals),
/* prSignals */                 cbr_aubTX_KeyIllumination1Signals,
/* pvTeleGramDefaultData */     cbr_aubTX_KeyIllumination1_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_KeyIllumination0 */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_KeyIllumination0Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 0,  64),  CBR_TMSG_CYCLIC, 0, NULL },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key8_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key7_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key6_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key5_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key4_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key3_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key2_Illumination */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key1_Illumination */
};
const BYTE cbr_aubTX_KeyIllumination0_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
/***********************/
const CSM_TELEGRAM cbr_aubTX_KeyIllumination0 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_KeyIllumination0Signals),
/* prSignals */                 cbr_aubTX_KeyIllumination0Signals,
/* pvTeleGramDefaultData */     cbr_aubTX_KeyIllumination0_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_KeyColour1 */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_KeyColour1Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 0,   64),  CBR_TMSG_CYCLIC, 0, NULL },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Reserved */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Reserved */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Encoder2_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Encoder1_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key12_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key11_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key9_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key10_Colour */
};
const BYTE cbr_aubTX_KeyColour1_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
/***********************/
const CSM_TELEGRAM cbr_aubTX_KeyColour1 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_KeyColour1Signals),
/* prSignals */                 cbr_aubTX_KeyColour1Signals,
/* pvTeleGramDefaultData */     cbr_aubTX_KeyColour1_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_KeyColour0 */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_KeyColour0Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 0,  64),  CBR_TMSG_CYCLIC, 0, NULL },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key8_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key7_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key6_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key5_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key4_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key3_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key2_Colour */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CBR_TMSG_CYCLIC, 0, NULL },  /* Key1_Colour */
};
const BYTE cbr_aubTX_KeyColour0_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
/***********************/
const CSM_TELEGRAM cbr_aubTX_KeyColour0 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_KeyColour0Signals),
/* prSignals */                 cbr_aubTX_KeyColour0Signals,
/* pvTeleGramDefaultData */     cbr_aubTX_KeyColour0_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* TX_Req_DeviceInformation */
/*****************************************************************************/
const CSM_SIGNAL cbr_aubTX_Req_DeviceInformationSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CBR_TMSG_SPONTAN, 0, NULL },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CBR_TMSG_SPONTAN, 0, NULL },  /* Req_DeviceInformation */
};
const BYTE cbr_aubTX_Req_DeviceInformation_DefaultData[] = {0};
/***********************/
const CSM_TELEGRAM cbr_aubTX_Req_DeviceInformation =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubTX_Req_DeviceInformationSignals),
/* prSignals */                 cbr_aubTX_Req_DeviceInformationSignals,
/* pvTeleGramDefaultData */     cbr_aubTX_Req_DeviceInformation_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*
    RRR    RRRRR    RRRR   RRRRR    R    R     R   RRRRR
    R  R   R       R       R             R     R   R
    R   R  R       R       R        R     R   R    R
    R   R  RRR     R       RRR      R     R   R    RR
    RRRR   R       R       R        R      R R     R
    R  R   R       R       R        R      R R     R
    R   R  R       R       R        R       R      R
    R   R  RRRRR    RRRR   RRRRR   RRR      R      RRRRR
*/

/********************************************/
/* RX Data */
/********************************************/
BYTE cbr_aubRX_EAM3_B34_TelData[ CSM_C_DLC_EAM3_B34];
BYTE cbr_aubRX_EAM3_B33_TelData[ CSM_C_DLC_EAM3_B33];
BYTE cbr_aubRX_ICUC_C10_TelData[ CSM_C_DLC_ICUC_C10];
BYTE cbr_aubRX_SCA_E1_TelData[ CSM_C_DLC_SCA_E1];
BYTE cbr_aubRX_SCH_E1_TelData[ CSM_C_DLC_SCH_E1];
BYTE cbr_aubRX_WMI_C02_TelData[ CSM_C_DLC_WMI_C02];
BYTE cbr_aubRX_TPCM_TCO_TelData[ CSM_C_DLC_TPCM_TCO];
BYTE cbr_aubRX_TPDT_TCO_TelData[ CSM_C_DLC_TPDT_TCO];
BYTE cbr_aubRX_TCO1_ICUC_TelData[ CSM_C_DLC_TCO1_ICUC];
BYTE cbr_aubRX_DI_Shrt_TCO_TelData[ CSM_C_DLC_DI_Shrt_TCO];
BYTE cbr_aubRX_NM_APPL_NWT_AR_TelData[ CSM_C_DLC_NM_APPL_NWT_AR];
BYTE cbr_aubRX_SCA_C2_TelData[ CSM_C_DLC_SCA_C2];
BYTE cbr_aubRX_ETC2_CPC_TelData[ CSM_C_DLC_ETC2_CPC];
BYTE cbr_aubRX_EBC2_BS_TelData[ CSM_C_DLC_EBC2_BS];
BYTE cbr_aubRX_ICUC_C2_TelData[ CSM_C_DLC_ICUC_C2];
BYTE cbr_aubRX_TD_ICUC_TelData[ CSM_C_DLC_TD_ICUC];
BYTE cbr_aubRX_ICUC_C1_TelData[ CSM_C_DLC_ICUC_C1];
BYTE cbr_aubRX_CGW_C1_TelData[ CSM_C_DLC_CGW_C1];
BYTE cbr_aubRX_CGW_GVC1_TelData[ CSM_C_DLC_CGW_GVC1];
BYTE cbr_aubRX_CGW_VIN_TelData[ CSM_C_DLC_CGW_VIN];
BYTE cbr_aubRX_EAM3_B30_TelData[ CSM_C_DLC_EAM3_B30];



/*****************************************************************************/
/* RX_EAM3_B34 */
/*****************************************************************************/
#define CBR_C_SIG_RX_EAM3_B34_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B34_CAM_SplitQuad_Stat_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B34[ CBR_C_SIG_RX_EAM3_B34_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL  };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B34_CAM_SplitQuad_Stat[ CBR_C_SIG_RX_EAM3_B34_CAM_SplitQuad_Stat_NUM_CALLBACK] = { NULL, NULL, NULL  };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B34[ CBR_C_SIG_RX_EAM3_B34_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B34_CAM_SplitQuad_Stat[ CBR_C_SIG_RX_EAM3_B34_CAM_SplitQuad_Stat_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_EAM3_B34Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_EAM3_B34*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B34_NUM_CALLBACK, cbr_apfnSIG_RX_EAM3_B34 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B34_CAM_SplitQuad_Stat_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B34_CAM_SplitQuad_Stat }, /* CAM_SplitQuad_Stat */
};
const BYTE cbr_aubRX_EAM3_B34_DefaultData[] = {0xFF,0xFF,0,0,0,0,0,0};
const BYTE cbr_aubRX_EAM3_B34_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_EAM3_B34 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_EAM3_B34Signals),
/* prSignals */                 cbr_aubRX_EAM3_B34Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_EAM3_B34_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_EAM3_B34_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_EAM3_B33 */
/*****************************************************************************/
#define CBR_C_SIG_RX_EAM3_B33_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B33_Cam1Txt_Rq_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B33_Cam2Txt_Rq_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B33_Cam3Txt_Rq_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B33_Cam4Txt_Rq_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B33_Cam5Txt_Rq_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B33_Cam6Txt_Rq_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B33_Cam7Txt_Rq_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B33[ CBR_C_SIG_RX_EAM3_B33_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B33_Cam1Txt_Rq[ CBR_C_SIG_RX_EAM3_B33_Cam1Txt_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B33_Cam2Txt_Rq[ CBR_C_SIG_RX_EAM3_B33_Cam2Txt_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B33_Cam3Txt_Rq[ CBR_C_SIG_RX_EAM3_B33_Cam3Txt_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B33_Cam4Txt_Rq[ CBR_C_SIG_RX_EAM3_B33_Cam4Txt_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B33_Cam5Txt_Rq[ CBR_C_SIG_RX_EAM3_B33_Cam5Txt_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B33_Cam6Txt_Rq[ CBR_C_SIG_RX_EAM3_B33_Cam6Txt_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B33_Cam7Txt_Rq[ CBR_C_SIG_RX_EAM3_B33_Cam7Txt_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B33[ CBR_C_SIG_RX_EAM3_B33_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B33_Cam1Txt_Rq[ CBR_C_SIG_RX_EAM3_B33_Cam1Txt_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B33_Cam2Txt_Rq[ CBR_C_SIG_RX_EAM3_B33_Cam2Txt_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B33_Cam3Txt_Rq[ CBR_C_SIG_RX_EAM3_B33_Cam3Txt_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B33_Cam4Txt_Rq[ CBR_C_SIG_RX_EAM3_B33_Cam4Txt_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B33_Cam5Txt_Rq[ CBR_C_SIG_RX_EAM3_B33_Cam5Txt_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B33_Cam6Txt_Rq[ CBR_C_SIG_RX_EAM3_B33_Cam6Txt_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B33_Cam7Txt_Rq[ CBR_C_SIG_RX_EAM3_B33_Cam7Txt_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_EAM3_B33Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_EAM3_B33*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B33_NUM_CALLBACK, cbr_apfnSIG_RX_EAM3_B33 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B33_Cam1Txt_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B33_Cam1Txt_Rq }, /* Cam1Txt_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B33_Cam2Txt_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B33_Cam2Txt_Rq }, /* Cam2Txt_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B33_Cam3Txt_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B33_Cam3Txt_Rq }, /* Cam3Txt_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B33_Cam4Txt_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B33_Cam4Txt_Rq }, /* Cam4Txt_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B33_Cam5Txt_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B33_Cam5Txt_Rq }, /* Cam5Txt_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B33_Cam6Txt_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B33_Cam6Txt_Rq }, /* Cam6Txt_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B33_Cam7Txt_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B33_Cam7Txt_Rq }, /* Cam7Txt_Rq */
};
const BYTE cbr_aubRX_EAM3_B33_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0};
const BYTE cbr_aubRX_EAM3_B33_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_EAM3_B33 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_EAM3_B33Signals),
/* prSignals */                 cbr_aubRX_EAM3_B33Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_EAM3_B33_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_EAM3_B33_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_ICUC_C10 */
/*****************************************************************************/
#define CBR_C_SIG_RX_ICUC_C10_NUM_CALLBACK    3
#define CBR_C_SIG_RX_ICUC_C10_StW_Sw07_Rq_ICUC_NUM_CALLBACK    3
#define CBR_C_SIG_RX_ICUC_C10_StW_Sw08_Rq_ICUC_NUM_CALLBACK    3
#define CBR_C_SIG_RX_ICUC_C10_StW_Sw15_Rq_ICUC_NUM_CALLBACK    3
#define CBR_C_SIG_RX_ICUC_C10_StW_Sw16_Rq_ICUC_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C10[ CBR_C_SIG_RX_ICUC_C10_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C10_StW_Sw07_Rq_ICUC[ CBR_C_SIG_RX_ICUC_C10_StW_Sw07_Rq_ICUC_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C10_StW_Sw08_Rq_ICUC[ CBR_C_SIG_RX_ICUC_C10_StW_Sw08_Rq_ICUC_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C10_StW_Sw15_Rq_ICUC[ CBR_C_SIG_RX_ICUC_C10_StW_Sw15_Rq_ICUC_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C10_StW_Sw16_Rq_ICUC[ CBR_C_SIG_RX_ICUC_C10_StW_Sw16_Rq_ICUC_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C10[ CBR_C_SIG_RX_ICUC_C10_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C10_StW_Sw07_Rq_ICUC[ CBR_C_SIG_RX_ICUC_C10_StW_Sw07_Rq_ICUC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C10_StW_Sw08_Rq_ICUC[ CBR_C_SIG_RX_ICUC_C10_StW_Sw08_Rq_ICUC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C10_StW_Sw15_Rq_ICUC[ CBR_C_SIG_RX_ICUC_C10_StW_Sw15_Rq_ICUC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C10_StW_Sw16_Rq_ICUC[ CBR_C_SIG_RX_ICUC_C10_StW_Sw16_Rq_ICUC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_ICUC_C10Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_ICUC_C10*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C10_NUM_CALLBACK, cbr_apfnSIG_RX_ICUC_C10 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 44,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C10_StW_Sw07_Rq_ICUC_NUM_CALLBACK ,cbr_apfnSIG_RX_ICUC_C10_StW_Sw07_Rq_ICUC }, /* StW_Sw07_Rq_ICUC */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 46,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C10_StW_Sw08_Rq_ICUC_NUM_CALLBACK ,cbr_apfnSIG_RX_ICUC_C10_StW_Sw08_Rq_ICUC }, /* StW_Sw08_Rq_ICUC */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 60,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C10_StW_Sw15_Rq_ICUC_NUM_CALLBACK ,cbr_apfnSIG_RX_ICUC_C10_StW_Sw15_Rq_ICUC }, /* StW_Sw15_Rq_ICUC */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 62,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C10_StW_Sw16_Rq_ICUC_NUM_CALLBACK ,cbr_apfnSIG_RX_ICUC_C10_StW_Sw16_Rq_ICUC }, /* StW_Sw16_Rq_ICUC */
};
const BYTE cbr_aubRX_ICUC_C10_DefaultData[] = {0,0,0,0,0,0xF,0,0xF};
const BYTE cbr_aubRX_ICUC_C10_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_ICUC_C10 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_ICUC_C10Signals),
/* prSignals */                 cbr_aubRX_ICUC_C10Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_ICUC_C10_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_ICUC_C10_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_SCA_E1 */
/*****************************************************************************/
#define CBR_C_SIG_RX_SCA_E1_NUM_CALLBACK    3
#define CBR_C_SIG_RX_SCA_E1_PanelLmpDimChgTm_Cval_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SCA_E1[ CBR_C_SIG_RX_SCA_E1_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SCA_E1_PanelLmpDimChgTm_Cval[ CBR_C_SIG_RX_SCA_E1_PanelLmpDimChgTm_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SCA_E1[ CBR_C_SIG_RX_SCA_E1_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SCA_E1_PanelLmpDimChgTm_Cval[ CBR_C_SIG_RX_SCA_E1_PanelLmpDimChgTm_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_SCA_E1Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_SCA_E1*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SCA_E1_NUM_CALLBACK, cbr_apfnSIG_RX_SCA_E1 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SCA_E1_PanelLmpDimChgTm_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_SCA_E1_PanelLmpDimChgTm_Cval }, /* PanelLmpDimChgTm_Cval */
};
const BYTE cbr_aubRX_SCA_E1_DefaultData[] = {0,0,0,0,0,0,0xFF,0};
const BYTE cbr_aubRX_SCA_E1_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_SCA_E1 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_SCA_E1Signals),
/* prSignals */                 cbr_aubRX_SCA_E1Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_SCA_E1_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_SCA_E1_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_WMI_C02 */
/*****************************************************************************/
#define CBR_C_SIG_RX_WMI_C02_NUM_CALLBACK    3
#define CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_1_WMI_NUM_CALLBACK    3
#define CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_2_WMI_NUM_CALLBACK    3
#define CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_3_WMI_NUM_CALLBACK    3
#define CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_4_WMI_NUM_CALLBACK    3
#define CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_5_WMI_NUM_CALLBACK    3
#define CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_6_WMI_NUM_CALLBACK    3
#define CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_7_WMI_NUM_CALLBACK    3
#define CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_8_WMI_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_WMI_C02[ CBR_C_SIG_RX_WMI_C02_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_1_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_1_WMI_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_2_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_2_WMI_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_3_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_3_WMI_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_4_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_4_WMI_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_5_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_5_WMI_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_6_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_6_WMI_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_7_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_7_WMI_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_8_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_8_WMI_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_WMI_C02[ CBR_C_SIG_RX_WMI_C02_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_1_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_1_WMI_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_2_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_2_WMI_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_3_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_3_WMI_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_4_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_4_WMI_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_5_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_5_WMI_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_6_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_6_WMI_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_7_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_7_WMI_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_8_WMI[ CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_8_WMI_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_WMI_C02Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_WMI_C02*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_WMI_C02_NUM_CALLBACK, cbr_apfnSIG_RX_WMI_C02 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_1_WMI_NUM_CALLBACK ,cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_1_WMI }, /* FltbrdDrv_ID_1_WMI */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_2_WMI_NUM_CALLBACK ,cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_2_WMI }, /* FltbrdDrv_ID_2_WMI */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_3_WMI_NUM_CALLBACK ,cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_3_WMI }, /* FltbrdDrv_ID_3_WMI */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_4_WMI_NUM_CALLBACK ,cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_4_WMI }, /* FltbrdDrv_ID_4_WMI */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_5_WMI_NUM_CALLBACK ,cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_5_WMI }, /* FltbrdDrv_ID_5_WMI */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_6_WMI_NUM_CALLBACK ,cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_6_WMI }, /* FltbrdDrv_ID_6_WMI */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_7_WMI_NUM_CALLBACK ,cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_7_WMI }, /* FltbrdDrv_ID_7_WMI */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_WMI_C02_FltbrdDrv_ID_8_WMI_NUM_CALLBACK ,cbr_apfnSIG_RX_WMI_C02_FltbrdDrv_ID_8_WMI }, /* FltbrdDrv_ID_8_WMI */
};
const BYTE cbr_aubRX_WMI_C02_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
const BYTE cbr_aubRX_WMI_C02_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_WMI_C02 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_WMI_C02Signals),
/* prSignals */                 cbr_aubRX_WMI_C02Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_WMI_C02_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_WMI_C02_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_TPCM_TCO */
/*****************************************************************************/
#define CBR_C_SIG_RX_TPCM_TCO_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TPCM_TCO_CtrlByte_Stat_TCO_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TPCM_TCO_TotalMsgSizeBAM_Cval_TCO_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TPCM_TCO_TotalNumOfPktBAM_Cval_TCO_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TPCM_TCO_PGN_Cval_TCO_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TPCM_TCO[ CBR_C_SIG_RX_TPCM_TCO_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TPCM_TCO_CtrlByte_Stat_TCO[ CBR_C_SIG_RX_TPCM_TCO_CtrlByte_Stat_TCO_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TPCM_TCO_TotalMsgSizeBAM_Cval_TCO[ CBR_C_SIG_RX_TPCM_TCO_TotalMsgSizeBAM_Cval_TCO_NUM_CALLBACK] = { NULL, NULL, NULL};
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TPCM_TCO_TotalNumOfPktBAM_Cval_TCO[ CBR_C_SIG_RX_TPCM_TCO_TotalNumOfPktBAM_Cval_TCO_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TPCM_TCO_PGN_Cval_TCO[ CBR_C_SIG_RX_TPCM_TCO_PGN_Cval_TCO_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TPCM_TCO[ CBR_C_SIG_RX_TPCM_TCO_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TPCM_TCO_CtrlByte_Stat_TCO[ CBR_C_SIG_RX_TPCM_TCO_CtrlByte_Stat_TCO_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TPCM_TCO_TotalMsgSizeBAM_Cval_TCO[ CBR_C_SIG_RX_TPCM_TCO_TotalMsgSizeBAM_Cval_TCO_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TPCM_TCO_TotalNumOfPktBAM_Cval_TCO[ CBR_C_SIG_RX_TPCM_TCO_TotalNumOfPktBAM_Cval_TCO_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TPCM_TCO_PGN_Cval_TCO[ CBR_C_SIG_RX_TPCM_TCO_PGN_Cval_TCO_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_TPCM_TCOSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_TPCM_TCO*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TPCM_TCO_NUM_CALLBACK, cbr_apfnSIG_RX_TPCM_TCO },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TPCM_TCO_CtrlByte_Stat_TCO_NUM_CALLBACK ,cbr_apfnSIG_RX_TPCM_TCO_CtrlByte_Stat_TCO }, /* CtrlByte_Stat_TCO */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8, 16),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TPCM_TCO_TotalMsgSizeBAM_Cval_TCO_NUM_CALLBACK ,cbr_apfnSIG_RX_TPCM_TCO_TotalMsgSizeBAM_Cval_TCO }, /* TotalMsgSizeBAM_Cval_TCO */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TPCM_TCO_TotalNumOfPktBAM_Cval_TCO_NUM_CALLBACK ,cbr_apfnSIG_RX_TPCM_TCO_TotalNumOfPktBAM_Cval_TCO }, /* TotalNumOfPktBAM_Cval_TCO */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40, 24),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TPCM_TCO_PGN_Cval_TCO_NUM_CALLBACK ,cbr_apfnSIG_RX_TPCM_TCO_PGN_Cval_TCO }, /* PGN_Cval_TCO */
};
const BYTE cbr_aubRX_TPCM_TCO_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0,0xFF,0xFF,0xFF};
const BYTE cbr_aubRX_TPCM_TCO_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_TPCM_TCO =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_TPCM_TCOSignals),
/* prSignals */                 cbr_aubRX_TPCM_TCOSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_TPCM_TCO_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_TPCM_TCO_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_TPDT_TCO */
/*****************************************************************************/
#define CBR_C_SIG_RX_TPDT_TCO_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TPDT_TCO_SequenceNum_Cval_TCO_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TPDT_TCO_Data_Cval_TCO_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TPDT_TCO_Data2_Cval_TCO_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TPDT_TCO_Data3_Cval_TCO_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TPDT_TCO_Data4_Cval_TCO_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TPDT_TCO_Data5_Cval_TCO_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TPDT_TCO_Data6_Cval_TCO_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TPDT_TCO_Data7_Cval_TCO_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TPDT_TCO[ CBR_C_SIG_RX_TPDT_TCO_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TPDT_TCO_SequenceNum_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_SequenceNum_Cval_TCO_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TPDT_TCO_Data_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_Data_Cval_TCO_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TPDT_TCO_Data2_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_Data2_Cval_TCO_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TPDT_TCO_Data3_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_Data3_Cval_TCO_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TPDT_TCO_Data4_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_Data4_Cval_TCO_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TPDT_TCO_Data5_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_Data5_Cval_TCO_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TPDT_TCO_Data6_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_Data6_Cval_TCO_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TPDT_TCO_Data7_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_Data7_Cval_TCO_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TPDT_TCO[ CBR_C_SIG_RX_TPDT_TCO_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TPDT_TCO_SequenceNum_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_SequenceNum_Cval_TCO_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TPDT_TCO_Data_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_Data_Cval_TCO_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TPDT_TCO_Data2_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_Data2_Cval_TCO_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TPDT_TCO_Data3_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_Data3_Cval_TCO_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TPDT_TCO_Data4_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_Data4_Cval_TCO_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TPDT_TCO_Data5_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_Data5_Cval_TCO_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TPDT_TCO_Data6_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_Data6_Cval_TCO_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TPDT_TCO_Data7_Cval_TCO[ CBR_C_SIG_RX_TPDT_TCO_Data7_Cval_TCO_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_TPDT_TCOSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_TPDT_TCO*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TPDT_TCO_NUM_CALLBACK, cbr_apfnSIG_RX_TPDT_TCO },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TPDT_TCO_SequenceNum_Cval_TCO_NUM_CALLBACK ,cbr_apfnSIG_RX_TPDT_TCO_SequenceNum_Cval_TCO }, /* SequenceNum_Cval_TCO */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TPDT_TCO_Data_Cval_TCO_NUM_CALLBACK ,cbr_apfnSIG_RX_TPDT_TCO_Data_Cval_TCO }, /* Data_Cval_TCO */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TPDT_TCO_Data2_Cval_TCO_NUM_CALLBACK ,cbr_apfnSIG_RX_TPDT_TCO_Data2_Cval_TCO }, /* Data2_Cval_TCO */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TPDT_TCO_Data3_Cval_TCO_NUM_CALLBACK ,cbr_apfnSIG_RX_TPDT_TCO_Data3_Cval_TCO }, /* Data3_Cval_TCO */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TPDT_TCO_Data4_Cval_TCO_NUM_CALLBACK ,cbr_apfnSIG_RX_TPDT_TCO_Data4_Cval_TCO }, /* Data4_Cval_TCO */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TPDT_TCO_Data5_Cval_TCO_NUM_CALLBACK ,cbr_apfnSIG_RX_TPDT_TCO_Data5_Cval_TCO }, /* Data5_Cval_TCO */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TPDT_TCO_Data6_Cval_TCO_NUM_CALLBACK ,cbr_apfnSIG_RX_TPDT_TCO_Data6_Cval_TCO }, /* Data6_Cval_TCO */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TPDT_TCO_Data7_Cval_TCO_NUM_CALLBACK ,cbr_apfnSIG_RX_TPDT_TCO_Data7_Cval_TCO }, /* Data7_Cval_TCO */
};
const BYTE cbr_aubRX_TPDT_TCO_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
const BYTE cbr_aubRX_TPDT_TCO_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_TPDT_TCO =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_TPDT_TCOSignals),
/* prSignals */                 cbr_aubRX_TPDT_TCOSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_TPDT_TCO_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_TPDT_TCO_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_TCO1_ICUC */
/*****************************************************************************/
#define CBR_C_SIG_RX_TCO1_ICUC_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TCO1_ICUC_D_Card_Stat_ICUC_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TCO1_ICUC[ CBR_C_SIG_RX_TCO1_ICUC_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TCO1_ICUC_D_Card_Stat_ICUC[ CBR_C_SIG_RX_TCO1_ICUC_D_Card_Stat_ICUC_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TCO1_ICUC[ CBR_C_SIG_RX_TCO1_ICUC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TCO1_ICUC_D_Card_Stat_ICUC[ CBR_C_SIG_RX_TCO1_ICUC_D_Card_Stat_ICUC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_TCO1_ICUCSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
{0, CSM_C_DLC_TCO1_ICUC*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TCO1_ICUC_NUM_CALLBACK, cbr_apfnSIG_RX_TCO1_ICUC },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TCO1_ICUC_D_Card_Stat_ICUC_NUM_CALLBACK ,cbr_apfnSIG_RX_TCO1_ICUC_D_Card_Stat_ICUC }, /* D_Card_Stat_ICUC */
};
const BYTE cbr_aubRX_TCO1_ICUC_DefaultData[] = {0,0x3,0,0,0,0,0,0};
const BYTE cbr_aubRX_TCO1_ICUC_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_TCO1_ICUC =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_TCO1_ICUCSignals),
/* prSignals */                 cbr_aubRX_TCO1_ICUCSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_TCO1_ICUC_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_TCO1_ICUC_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_DI_Shrt_TCO */
/*****************************************************************************/
#define CBR_C_SIG_RX_DI_Shrt_TCO_NUM_CALLBACK    3
#define CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char001_Cval_NUM_CALLBACK    3
#define CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char002_Cval_NUM_CALLBACK    3
#define CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char003_Cval_NUM_CALLBACK    3
#define CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char004_Cval_NUM_CALLBACK    3
#define CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char005_Cval_NUM_CALLBACK    3
#define CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char006_Cval_NUM_CALLBACK    3
#define CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char007_Cval_NUM_CALLBACK    3
#define CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char008_Cval_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_DI_Shrt_TCO[ CBR_C_SIG_RX_DI_Shrt_TCO_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char001_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char001_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char002_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char002_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char003_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char003_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char004_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char004_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char005_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char005_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char006_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char006_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char007_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char007_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char008_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char008_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_DI_Shrt_TCO[ CBR_C_SIG_RX_DI_Shrt_TCO_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char001_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char001_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char002_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char002_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char003_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char003_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char004_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char004_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char005_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char005_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char006_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char006_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char007_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char007_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char008_Cval[ CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char008_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_DI_Shrt_TCOSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_DI_Shrt_TCO*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_DI_Shrt_TCO_NUM_CALLBACK, cbr_apfnSIG_RX_DI_Shrt_TCO },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char001_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char001_Cval }, /* DI_Char001_Cval */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char002_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char002_Cval }, /* DI_Char002_Cval */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char003_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char003_Cval }, /* DI_Char003_Cval */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char004_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char004_Cval }, /* DI_Char004_Cval */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char005_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char005_Cval }, /* DI_Char005_Cval */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char006_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char006_Cval }, /* DI_Char006_Cval */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char007_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char007_Cval }, /* DI_Char007_Cval */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_DI_Shrt_TCO_DI_Char008_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_DI_Shrt_TCO_DI_Char008_Cval }, /* DI_Char008_Cval */
};
const BYTE cbr_aubRX_DI_Shrt_TCO_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
const BYTE cbr_aubRX_DI_Shrt_TCO_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_DI_Shrt_TCO =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_DI_Shrt_TCOSignals),
/* prSignals */                 cbr_aubRX_DI_Shrt_TCOSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_DI_Shrt_TCO_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_DI_Shrt_TCO_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_NM_APPL_NWT_AR */
/*****************************************************************************/
#define CBR_C_SIG_RX_NM_APPL_NWT_AR_NUM_CALLBACK    3
#define CBR_C_SIG_RX_NM_APPL_NWT_AR_Awake_Diag_Actv_NUM_CALLBACK    3
#define CBR_C_SIG_RX_NM_APPL_NWT_AR_Awake_IgnOn_NUM_CALLBACK    3
#define CBR_C_SIG_RX_NM_APPL_NWT_AR_Awake_NwSt_NUM_CALLBACK    3
#define CBR_C_SIG_RX_NM_APPL_NWT_AR_WakeupRsn_APPL_NWT_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_NM_APPL_NWT_AR[ CBR_C_SIG_RX_NM_APPL_NWT_AR_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_NM_APPL_NWT_AR_Awake_Diag_Actv[ CBR_C_SIG_RX_NM_APPL_NWT_AR_Awake_Diag_Actv_NUM_CALLBACK] = {NULL, NULL, NULL};
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_NM_APPL_NWT_AR_Awake_IgnOn[ CBR_C_SIG_RX_NM_APPL_NWT_AR_Awake_IgnOn_NUM_CALLBACK] = { NULL, NULL, NULL};
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_NM_APPL_NWT_AR_Awake_NwSt[ CBR_C_SIG_RX_NM_APPL_NWT_AR_Awake_NwSt_NUM_CALLBACK] = {NULL, NULL, NULL};
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_NM_APPL_NWT_AR_WakeupRsn_APPL_NWT[ CBR_C_SIG_RX_NM_APPL_NWT_AR_WakeupRsn_APPL_NWT_NUM_CALLBACK] = {NULL, NULL, NULL};
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_NM_APPL_NWT_AR[ CBR_C_SIG_RX_NM_APPL_NWT_AR_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_NM_APPL_NWT_AR_Awake_Diag_Actv[ CBR_C_SIG_RX_NM_APPL_NWT_AR_Awake_Diag_Actv_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_NM_APPL_NWT_AR_Awake_IgnOn[ CBR_C_SIG_RX_NM_APPL_NWT_AR_Awake_IgnOn_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_NM_APPL_NWT_AR_Awake_NwSt[ CBR_C_SIG_RX_NM_APPL_NWT_AR_Awake_NwSt_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_NM_APPL_NWT_AR_WakeupRsn_APPL_NWT[ CBR_C_SIG_RX_NM_APPL_NWT_AR_WakeupRsn_APPL_NWT_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_NM_APPL_NWT_ARSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_NM_APPL_NWT_AR*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_NM_APPL_NWT_AR_NUM_CALLBACK, cbr_apfnSIG_RX_NM_APPL_NWT_AR },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 25,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_NM_APPL_NWT_AR_Awake_Diag_Actv_NUM_CALLBACK ,cbr_apfnSIG_RX_NM_APPL_NWT_AR_Awake_Diag_Actv }, /* Awake_Diag_Actv */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 26,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_NM_APPL_NWT_AR_Awake_IgnOn_NUM_CALLBACK ,cbr_apfnSIG_RX_NM_APPL_NWT_AR_Awake_IgnOn }, /* Awake_IgnOn */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_NM_APPL_NWT_AR_Awake_NwSt_NUM_CALLBACK ,cbr_apfnSIG_RX_NM_APPL_NWT_AR_Awake_NwSt }, /* Awake_NwSt */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_NM_APPL_NWT_AR_WakeupRsn_APPL_NWT_NUM_CALLBACK ,cbr_apfnSIG_RX_NM_APPL_NWT_AR_WakeupRsn_APPL_NWT }, /* WakeupRsn_APPL_NWT */
};
const BYTE cbr_aubRX_NM_APPL_NWT_AR_DefaultData[] = {0,0,0xFF,0x07,0,0,0,0};
const BYTE cbr_aubRX_NM_APPL_NWT_AR_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_NM_APPL_NWT_AR =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_NM_APPL_NWT_ARSignals),
/* prSignals */                 cbr_aubRX_NM_APPL_NWT_ARSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_NM_APPL_NWT_AR_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_NM_APPL_NWT_AR_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};


/*****************************************************************************/
/* RX_SCH_E1 */
/*****************************************************************************/
#define CBR_C_SIG_RX_SCH_E1_NUM_CALLBACK                   3
#define CBR_C_SIG_RX_SCH_E1_PkBrk_Stat_SCH_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SCH_E1[ CBR_C_SIG_RX_SCH_E1_PkBrk_Stat_SCH_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SCH_E1_PkBrk_Stat_SCH[ CBR_C_SIG_RX_SCH_E1_PkBrk_Stat_SCH_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SCH_E1[ CBR_C_SIG_RX_SCH_E1_PkBrk_Stat_SCH_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SCH_E1_PkBrk_Stat_SCH[ CBR_C_SIG_RX_SCH_E1_PkBrk_Stat_SCH_NUM_CALLBACK] = { NULL, NULL, NULL };
#endif
const CSM_SIGNAL cbr_aubRX_SCH_E1Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_SCH_E1*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SCH_E1_NUM_CALLBACK, cbr_apfnSIG_RX_SCH_E1 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SCH_E1_PkBrk_Stat_SCH_NUM_CALLBACK ,cbr_apfnSIG_RX_SCH_E1_PkBrk_Stat_SCH }, /* PkBrk_Stat_SCH */
};
const BYTE cbr_aubRX_SCH_E1_DefaultData[] = {0x03,0,0,0,0,0,0,0};
const BYTE cbr_aubRX_SCH_E1_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_SCH_E1 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_SCH_E1Signals),
/* prSignals */                 cbr_aubRX_SCH_E1Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_SCH_E1_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_SCH_E1_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_SCA_C2 */
/*****************************************************************************/
#define CBR_C_SIG_RX_SCA_C2_NUM_CALLBACK    3
#define CBR_C_SIG_RX_SCA_C2_IgnSw_Stat_SCA_NUM_CALLBACK    3
#define CBR_C_SIG_RX_SCA_C2_SysVolt_Stat_NUM_CALLBACK    3
#define CBR_C_SIG_RX_SCA_C2_EngCrk_Stat_NUM_CALLBACK    3
#define CBR_C_SIG_RX_SCA_C2_PNM_Grp10_Stat_NUM_CALLBACK    3
#define CBR_C_SIG_RX_SCA_C2_PanelLmp_Cmd_NUM_CALLBACK    3
#define CBR_C_SIG_RX_SCA_C2_PanelLmpDim_Cval_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SCA_C2[ CBR_C_SIG_RX_SCA_C2_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SCA_C2_IgnSw_Stat_SCA[ CBR_C_SIG_RX_SCA_C2_IgnSw_Stat_SCA_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SCA_C2_SysVolt_Stat[ CBR_C_SIG_RX_SCA_C2_SysVolt_Stat_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SCA_C2_EngCrk_Stat[ CBR_C_SIG_RX_SCA_C2_EngCrk_Stat_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SCA_C2_PNM_Grp10_Stat[ CBR_C_SIG_RX_SCA_C2_PNM_Grp10_Stat_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SCA_C2_PanelLmp_Cmd[ CBR_C_SIG_RX_SCA_C2_PanelLmp_Cmd_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_SCA_C2_PanelLmpDim_Cval[ CBR_C_SIG_RX_SCA_C2_PanelLmpDim_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SCA_C2[ CBR_C_SIG_RX_SCA_C2_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SCA_C2_IgnSw_Stat_SCA[ CBR_C_SIG_RX_SCA_C2_IgnSw_Stat_SCA_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SCA_C2_SysVolt_Stat[ CBR_C_SIG_RX_SCA_C2_SysVolt_Stat_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SCA_C2_EngCrk_Stat[ CBR_C_SIG_RX_SCA_C2_EngCrk_Stat_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SCA_C2_PNM_Grp10_Stat[ CBR_C_SIG_RX_SCA_C2_PNM_Grp10_Stat_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SCA_C2_PanelLmp_Cmd[ CBR_C_SIG_RX_SCA_C2_PanelLmp_Cmd_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_SCA_C2_PanelLmpDim_Cval[ CBR_C_SIG_RX_SCA_C2_PanelLmpDim_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_SCA_C2Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_SCA_C2*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SCA_C2_NUM_CALLBACK, cbr_apfnSIG_RX_SCA_C2 },

  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SCA_C2_IgnSw_Stat_SCA_NUM_CALLBACK ,cbr_apfnSIG_RX_SCA_C2_IgnSw_Stat_SCA }, /* IgnSw_Stat_SCA */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  4,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SCA_C2_SysVolt_Stat_NUM_CALLBACK ,cbr_apfnSIG_RX_SCA_C2_SysVolt_Stat }, /* SysVolt_Stat */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  6,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SCA_C2_EngCrk_Stat_NUM_CALLBACK ,cbr_apfnSIG_RX_SCA_C2_EngCrk_Stat }, /* EngCrk_Stat */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 41,  1),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SCA_C2_PNM_Grp10_Stat_NUM_CALLBACK ,cbr_apfnSIG_RX_SCA_C2_PNM_Grp10_Stat }, /* PNM_Grp10_Stat */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 54,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SCA_C2_PanelLmp_Cmd_NUM_CALLBACK ,cbr_apfnSIG_RX_SCA_C2_PanelLmp_Cmd }, /* PanelLmp_Cmd */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_SCA_C2_PanelLmpDim_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_SCA_C2_PanelLmpDim_Cval }, /* PanelLmpDim_Cval */
};
const BYTE cbr_aubRX_SCA_C2_DefaultData[] = {0xFF,0,0,0,0,0x02,0xC,0xFF};
const BYTE cbr_aubRX_SCA_C2_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_SCA_C2 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_SCA_C2Signals),
/* prSignals */                 cbr_aubRX_SCA_C2Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_SCA_C2_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_SCA_C2_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_ETC2_CPC */
/*****************************************************************************/
#define CBR_C_SIG_RX_ETC2_CPC_NUM_CALLBACK    3
#define CBR_C_SIG_RX_ETC2_CPC_TxCurrGr_Stat_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ETC2_CPC[ CBR_C_SIG_RX_ETC2_CPC_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ETC2_CPC_TxCurrGr_Stat[ CBR_C_SIG_RX_ETC2_CPC_TxCurrGr_Stat_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ETC2_CPC[ CBR_C_SIG_RX_ETC2_CPC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ETC2_CPC_TxCurrGr_Stat[ CBR_C_SIG_RX_ETC2_CPC_TxCurrGr_Stat_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_ETC2_CPCSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_ETC2_CPC*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ETC2_CPC_NUM_CALLBACK, cbr_apfnSIG_RX_ETC2_CPC },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ETC2_CPC_TxCurrGr_Stat_NUM_CALLBACK ,cbr_apfnSIG_RX_ETC2_CPC_TxCurrGr_Stat }, /* TxCurrGr_Stat */
};
const BYTE cbr_aubRX_ETC2_CPC_DefaultData[] = {0,0,0,0xFF,0,0,0,0};
const BYTE cbr_aubRX_ETC2_CPC_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_ETC2_CPC =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_ETC2_CPCSignals),
/* prSignals */                 cbr_aubRX_ETC2_CPCSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_ETC2_CPC_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_ETC2_CPC_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_EBC2_BS */
/*****************************************************************************/
#define CBR_C_SIG_RX_EBC2_BS_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EBC2_BS_FA_Spd_Cval_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EBC2_BS[ CBR_C_SIG_RX_EBC2_BS_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EBC2_BS_FA_Spd_Cval[ CBR_C_SIG_RX_EBC2_BS_FA_Spd_Cval_NUM_CALLBACK] = { NULL, NULL, NULL};
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EBC2_BS[ CBR_C_SIG_RX_EBC2_BS_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EBC2_BS_FA_Spd_Cval[ CBR_C_SIG_RX_EBC2_BS_FA_Spd_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_EBC2_BSSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_EBC2_BS*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EBC2_BS_NUM_CALLBACK, cbr_apfnSIG_RX_EBC2_BS },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 16),  CSM_C_ALWAYS_IND, CBR_C_SIG_RX_EBC2_BS_FA_Spd_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_EBC2_BS_FA_Spd_Cval }, /* FA_Spd_Cval */
};
const BYTE cbr_aubRX_EBC2_BS_DefaultData[] = {0xFF,0xFF,0,0,0,0,0,0};
const BYTE cbr_aubRX_EBC2_BS_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_EBC2_BS =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_EBC2_BSSignals),
/* prSignals */                 cbr_aubRX_EBC2_BSSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_EBC2_BS_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_EBC2_BS_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_ICUC_C2 */
/*****************************************************************************/
#define CBR_C_SIG_RX_ICUC_C2_NUM_CALLBACK    3
#define CBR_C_SIG_RX_ICUC_C2_MuteDev_Stat_NUM_CALLBACK    3
#define CBR_C_SIG_RX_ICUC_C2_Mute_Rq_NUM_CALLBACK    3
#define CBR_C_SIG_RX_ICUC_C2_DayNightMd_Stat_NUM_CALLBACK    3
#define CBR_C_SIG_RX_ICUC_C2_DispDateMd_Cval_NUM_CALLBACK    3
#define CBR_C_SIG_RX_ICUC_C2_DispTmMd_Cval_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C2[ CBR_C_SIG_RX_ICUC_C2_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C2_MuteDev_Stat[ CBR_C_SIG_RX_ICUC_C2_MuteDev_Stat_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C2_Mute_Rq[ CBR_C_SIG_RX_ICUC_C2_Mute_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C2_DayNightMd_Stat[ CBR_C_SIG_RX_ICUC_C2_DayNightMd_Stat_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C2_DispDateMd_Cval[ CBR_C_SIG_RX_ICUC_C2_DispDateMd_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C2_DispTmMd_Cval[ CBR_C_SIG_RX_ICUC_C2_DispTmMd_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C2[ CBR_C_SIG_RX_ICUC_C2_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C2_MuteDev_Stat[ CBR_C_SIG_RX_ICUC_C2_MuteDev_Stat_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C2_Mute_Rq[ CBR_C_SIG_RX_ICUC_C2_Mute_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C2_DayNightMd_Stat[ CBR_C_SIG_RX_ICUC_C2_DayNightMd_Stat_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C2_DispDateMd_Cval[ CBR_C_SIG_RX_ICUC_C2_DispDateMd_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C2_DispTmMd_Cval[ CBR_C_SIG_RX_ICUC_C2_DispTmMd_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_ICUC_C2Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_ICUC_C2*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C2_NUM_CALLBACK, cbr_apfnSIG_RX_ICUC_C2 },

  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 18,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C2_MuteDev_Stat_NUM_CALLBACK ,cbr_apfnSIG_RX_ICUC_C2_MuteDev_Stat }, /* MuteDev_Stat */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C2_Mute_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_ICUC_C2_Mute_Rq }, /* Mute_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C2_DayNightMd_Stat_NUM_CALLBACK ,cbr_apfnSIG_RX_ICUC_C2_DayNightMd_Stat }, /* DayNightMd_Stat */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 44,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C2_DispDateMd_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_ICUC_C2_DispDateMd_Cval }, /* DispDateMd_Cval */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 46,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C2_DispTmMd_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_ICUC_C2_DispTmMd_Cval }, /* DispTmMd_Cval */
};
const BYTE cbr_aubRX_ICUC_C2_DefaultData[] = {0,0,0xFC,0x03,0,0xF,0,0};
const BYTE cbr_aubRX_ICUC_C2_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_ICUC_C2 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_ICUC_C2Signals),
/* prSignals */                 cbr_aubRX_ICUC_C2Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_ICUC_C2_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_ICUC_C2_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_TD_ICUC */
/*****************************************************************************/
#define CBR_C_SIG_RX_TD_ICUC_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TD_ICUC_DateTmSecond_Cval_ICUC_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TD_ICUC_DateTmMinute_Cval_ICUC_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TD_ICUC_DateTmHour_Cval_ICUC_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TD_ICUC_DateTmMonth_Cval_ICUC_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TD_ICUC_DateTmDay_Cval_ICUC_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TD_ICUC_DateTmYear_Cval_ICUC_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TD_ICUC_LocalMinuteOffset_Cval_ICUC_NUM_CALLBACK    3
#define CBR_C_SIG_RX_TD_ICUC_LocalHourOffset_Cval_ICUC_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TD_ICUC[ CBR_C_SIG_RX_TD_ICUC_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TD_ICUC_DateTmSecond_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_DateTmSecond_Cval_ICUC_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TD_ICUC_DateTmMinute_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_DateTmMinute_Cval_ICUC_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TD_ICUC_DateTmHour_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_DateTmHour_Cval_ICUC_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TD_ICUC_DateTmMonth_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_DateTmMonth_Cval_ICUC_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TD_ICUC_DateTmDay_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_DateTmDay_Cval_ICUC_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TD_ICUC_DateTmYear_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_DateTmYear_Cval_ICUC_NUM_CALLBACK] = { NULL, NULL, NULL};
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TD_ICUC_LocalMinuteOffset_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_LocalMinuteOffset_Cval_ICUC_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_TD_ICUC_LocalHourOffset_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_LocalHourOffset_Cval_ICUC_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TD_ICUC[ CBR_C_SIG_RX_TD_ICUC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TD_ICUC_DateTmSecond_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_DateTmSecond_Cval_ICUC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TD_ICUC_DateTmMinute_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_DateTmMinute_Cval_ICUC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TD_ICUC_DateTmHour_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_DateTmHour_Cval_ICUC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TD_ICUC_DateTmMonth_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_DateTmMonth_Cval_ICUC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TD_ICUC_DateTmDay_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_DateTmDay_Cval_ICUC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TD_ICUC_DateTmYear_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_DateTmYear_Cval_ICUC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TD_ICUC_LocalMinuteOffset_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_LocalMinuteOffset_Cval_ICUC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_TD_ICUC_LocalHourOffset_Cval_ICUC[ CBR_C_SIG_RX_TD_ICUC_LocalHourOffset_Cval_ICUC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_TD_ICUCSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_TD_ICUC*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TD_ICUC_NUM_CALLBACK, cbr_apfnSIG_RX_TD_ICUC },

  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TD_ICUC_DateTmSecond_Cval_ICUC_NUM_CALLBACK ,cbr_apfnSIG_RX_TD_ICUC_DateTmSecond_Cval_ICUC }, /* DateTmSecond_Cval_ICUC */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TD_ICUC_DateTmMinute_Cval_ICUC_NUM_CALLBACK ,cbr_apfnSIG_RX_TD_ICUC_DateTmMinute_Cval_ICUC }, /* DateTmMinute_Cval_ICUC */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TD_ICUC_DateTmHour_Cval_ICUC_NUM_CALLBACK ,cbr_apfnSIG_RX_TD_ICUC_DateTmHour_Cval_ICUC }, /* DateTmHour_Cval_ICUC */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TD_ICUC_DateTmMonth_Cval_ICUC_NUM_CALLBACK ,cbr_apfnSIG_RX_TD_ICUC_DateTmMonth_Cval_ICUC }, /* DateTmMonth_Cval_ICUC */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TD_ICUC_DateTmDay_Cval_ICUC_NUM_CALLBACK ,cbr_apfnSIG_RX_TD_ICUC_DateTmDay_Cval_ICUC }, /* DateTmDay_Cval_ICUC */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TD_ICUC_DateTmYear_Cval_ICUC_NUM_CALLBACK ,cbr_apfnSIG_RX_TD_ICUC_DateTmYear_Cval_ICUC }, /* DateTmYear_Cval_ICUC */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TD_ICUC_LocalMinuteOffset_Cval_ICUC_NUM_CALLBACK ,cbr_apfnSIG_RX_TD_ICUC_LocalMinuteOffset_Cval_ICUC }, /* LocalMinuteOffset_Cval_ICUC */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_TD_ICUC_LocalHourOffset_Cval_ICUC_NUM_CALLBACK ,cbr_apfnSIG_RX_TD_ICUC_LocalHourOffset_Cval_ICUC }, /* LocalHourOffset_Cval_ICUC */
};
const BYTE cbr_aubRX_TD_ICUC_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
const BYTE cbr_aubRX_TD_ICUC_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_TD_ICUC =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_TD_ICUCSignals),
/* prSignals */                 cbr_aubRX_TD_ICUCSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_TD_ICUC_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_TD_ICUC_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_ICUC_C1 */
/*****************************************************************************/
#define CBR_C_SIG_RX_ICUC_C1_NUM_CALLBACK    3
#define CBR_C_SIG_RX_ICUC_C1_CurrLangChar_Cval_NUM_CALLBACK    3
#define CBR_C_SIG_RX_ICUC_C1_CurrLangChar2_Cval_NUM_CALLBACK    3
#define CBR_C_SIG_RX_ICUC_C1_DistUnit_Cval_NUM_CALLBACK    3
#define CBR_C_SIG_RX_ICUC_C1_TempUnit_Cval_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C1[ CBR_C_SIG_RX_ICUC_C1_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C1_CurrLangChar_Cval[ CBR_C_SIG_RX_ICUC_C1_CurrLangChar_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C1_CurrLangChar2_Cval[ CBR_C_SIG_RX_ICUC_C1_CurrLangChar2_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C1_DistUnit_Cval[ CBR_C_SIG_RX_ICUC_C1_DistUnit_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_ICUC_C1_TempUnit_Cval[ CBR_C_SIG_RX_ICUC_C1_TempUnit_Cval_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C1[ CBR_C_SIG_RX_ICUC_C1_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C1_CurrLangChar_Cval[ CBR_C_SIG_RX_ICUC_C1_CurrLangChar_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C1_CurrLangChar2_Cval[ CBR_C_SIG_RX_ICUC_C1_CurrLangChar2_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C1_DistUnit_Cval[ CBR_C_SIG_RX_ICUC_C1_DistUnit_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_ICUC_C1_TempUnit_Cval[ CBR_C_SIG_RX_ICUC_C1_TempUnit_Cval_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_ICUC_C1Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_ICUC_C1*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C1_NUM_CALLBACK, cbr_apfnSIG_RX_ICUC_C1 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C1_CurrLangChar_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_ICUC_C1_CurrLangChar_Cval }, /* CurrLangChar_Cval */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C1_CurrLangChar2_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_ICUC_C1_CurrLangChar2_Cval }, /* CurrLangChar2_Cval */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C1_DistUnit_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_ICUC_C1_DistUnit_Cval }, /* DistUnit_Cval */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 60,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_ICUC_C1_TempUnit_Cval_NUM_CALLBACK ,cbr_apfnSIG_RX_ICUC_C1_TempUnit_Cval }, /* TempUnit_Cval */
};
const BYTE cbr_aubRX_ICUC_C1_DefaultData[] = {0,0,0xFF,0xFF,0,0,0,0x33};
const BYTE cbr_aubRX_ICUC_C1_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_ICUC_C1 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_ICUC_C1Signals),
/* prSignals */                 cbr_aubRX_ICUC_C1Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_ICUC_C1_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_ICUC_C1_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_CGW_C1 */
/*****************************************************************************/
#define CBR_C_SIG_RX_CGW_C1_NUM_CALLBACK    3
#define CBR_C_SIG_RX_CGW_C1_Offboard_Tester_Stat_NUM_CALLBACK    3
#define CBR_C_SIG_RX_CGW_C1_SelfHealing2_Stat_NUM_CALLBACK    3
#define CBR_C_SIG_RX_CGW_C1_SelfHealing3_Stat_NUM_CALLBACK    3
#define CBR_C_SIG_RX_CGW_C1_TotalVehDist_Cval_DIAG_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_C1[ CBR_C_SIG_RX_CGW_C1_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_C1_Offboard_Tester_Stat[ CBR_C_SIG_RX_CGW_C1_Offboard_Tester_Stat_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_C1_SelfHealing2_Stat[ CBR_C_SIG_RX_CGW_C1_SelfHealing2_Stat_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_C1_SelfHealing3_Stat[ CBR_C_SIG_RX_CGW_C1_SelfHealing3_Stat_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_C1_TotalVehDist_Cval_DIAG[ CBR_C_SIG_RX_CGW_C1_TotalVehDist_Cval_DIAG_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_C1[ CBR_C_SIG_RX_CGW_C1_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_C1_Offboard_Tester_Stat[ CBR_C_SIG_RX_CGW_C1_Offboard_Tester_Stat_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_C1_SelfHealing2_Stat[ CBR_C_SIG_RX_CGW_C1_SelfHealing2_Stat_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_C1_SelfHealing3_Stat[ CBR_C_SIG_RX_CGW_C1_SelfHealing3_Stat_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_C1_TotalVehDist_Cval_DIAG[ CBR_C_SIG_RX_CGW_C1_TotalVehDist_Cval_DIAG_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_CGW_C1Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_CGW_C1*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_C1_NUM_CALLBACK, cbr_apfnSIG_RX_CGW_C1 },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_C1_Offboard_Tester_Stat_NUM_CALLBACK ,cbr_apfnSIG_RX_CGW_C1_Offboard_Tester_Stat }, /* Offboard_Tester_Stat */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_C1_SelfHealing2_Stat_NUM_CALLBACK ,cbr_apfnSIG_RX_CGW_C1_SelfHealing2_Stat }, /* SelfHealing2_Stat */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_C1_SelfHealing3_Stat_NUM_CALLBACK ,cbr_apfnSIG_RX_CGW_C1_SelfHealing3_Stat }, /* SelfHealing3_Stat */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32, 32),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_C1_TotalVehDist_Cval_DIAG_NUM_CALLBACK ,cbr_apfnSIG_RX_CGW_C1_TotalVehDist_Cval_DIAG }, /* TotalVehDist_Cval_DIAG */
};
const BYTE cbr_aubRX_CGW_C1_DefaultData[] = {0x03,0,0xFF,0xFF,0x80,0,0,0};
const BYTE cbr_aubRX_CGW_C1_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_CGW_C1 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_CGW_C1Signals),
/* prSignals */                 cbr_aubRX_CGW_C1Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_CGW_C1_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_CGW_C1_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_CGW_GVC1 */
/*****************************************************************************/
#define CBR_C_SIG_RX_CGW_GVC1_GVC_NUM_CALLBACK    3
#define CBR_C_SIG_RX_CGW_GVC1_GVC_VehModel_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_GVC1_GVC[ CBR_C_SIG_RX_CGW_GVC1_GVC_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_GVC1_GVC_VehModel[ CBR_C_SIG_RX_CGW_GVC1_GVC_VehModel_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_GVC1_GVC[ CBR_C_SIG_RX_CGW_GVC1_GVC_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_GVC1_GVC_VehModel[ CBR_C_SIG_RX_CGW_GVC1_GVC_VehModel_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_CGW_GVC1Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_CGW_GVC1*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_GVC1_GVC_NUM_CALLBACK, cbr_apfnSIG_RX_CGW_GVC1_GVC },
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  4,  4),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_GVC1_GVC_VehModel_NUM_CALLBACK ,cbr_apfnSIG_RX_CGW_GVC1_GVC_VehModel }, /* GVC_VehModel */
};
const BYTE cbr_aubRX_CGW_GVC1_DefaultData[] = {0xFF,0,0,0,0,0,0,0};
const BYTE cbr_aubRX_CGW_GVC1_TimeoutData[] = {0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_CGW_GVC1 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_CGW_GVC1Signals),
/* prSignals */                 cbr_aubRX_CGW_GVC1Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_CGW_GVC1_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_CGW_GVC1_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};



/*****************************************************************************/
/* RX_CGW_VIN */
/*****************************************************************************/
#define CBR_C_SIG_RX_CGW_VIN_VIN_NUM_CALLBACK    3
#define CBR_C_SIG_RX_CGW_VIN_VIN_Cntr_Stat_NUM_CALLBACK    3
#define CBR_C_SIG_RX_CGW_VIN_VIN_Seg_NUM_CALLBACK    3
#define CBR_C_SIG_RX_CGW_VIN_VIN_Seg2_NUM_CALLBACK    3
#define CBR_C_SIG_RX_CGW_VIN_VIN_Seg3_NUM_CALLBACK    3
#define CBR_C_SIG_RX_CGW_VIN_VIN_Seg4_NUM_CALLBACK    3
#define CBR_C_SIG_RX_CGW_VIN_VIN_Seg5_NUM_CALLBACK    3
#define CBR_C_SIG_RX_CGW_VIN_VIN_Seg6_NUM_CALLBACK    3
#define CBR_C_SIG_RX_CGW_VIN_VIN_Seg7_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK ==  CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_VIN_VIN[ CBR_C_SIG_RX_CGW_VIN_VIN_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_VIN_VIN_Cntr_Stat[ CBR_C_SIG_RX_CGW_VIN_VIN_Cntr_Stat_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_VIN_VIN_Seg[ CBR_C_SIG_RX_CGW_VIN_VIN_Seg_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_VIN_VIN_Seg2[ CBR_C_SIG_RX_CGW_VIN_VIN_Seg2_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_VIN_VIN_Seg3[ CBR_C_SIG_RX_CGW_VIN_VIN_Seg3_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_VIN_VIN_Seg4[ CBR_C_SIG_RX_CGW_VIN_VIN_Seg4_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_VIN_VIN_Seg5[ CBR_C_SIG_RX_CGW_VIN_VIN_Seg5_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_VIN_VIN_Seg6[ CBR_C_SIG_RX_CGW_VIN_VIN_Seg6_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_CGW_VIN_VIN_Seg7[ CBR_C_SIG_RX_CGW_VIN_VIN_Seg7_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_VIN_VIN[ CBR_C_SIG_RX_CGW_VIN_VIN_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_VIN_VIN_Cntr_Stat[ CBR_C_SIG_RX_CGW_VIN_VIN_Cntr_Stat_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_VIN_VIN_Seg[ CBR_C_SIG_RX_CGW_VIN_VIN_Seg_NUM_CALLBACK] =  {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_VIN_VIN_Seg2[ CBR_C_SIG_RX_CGW_VIN_VIN_Seg2_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_VIN_VIN_Seg3[ CBR_C_SIG_RX_CGW_VIN_VIN_Seg3_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_VIN_VIN_Seg4[ CBR_C_SIG_RX_CGW_VIN_VIN_Seg4_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_VIN_VIN_Seg5[ CBR_C_SIG_RX_CGW_VIN_VIN_Seg5_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_VIN_VIN_Seg6[ CBR_C_SIG_RX_CGW_VIN_VIN_Seg6_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_CGW_VIN_VIN_Seg7[ CBR_C_SIG_RX_CGW_VIN_VIN_Seg7_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_CGW_VINSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_CGW_VIN*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_VIN_VIN_NUM_CALLBACK, cbr_apfnSIG_RX_CGW_VIN_VIN }, /* CGW_VIN */

  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_VIN_VIN_Cntr_Stat_NUM_CALLBACK ,cbr_apfnSIG_RX_CGW_VIN_VIN_Cntr_Stat }, /* VIN_Cntr_Stat */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_VIN_VIN_Seg_NUM_CALLBACK ,cbr_apfnSIG_RX_CGW_VIN_VIN_Seg }, /* VIN_Seg */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_VIN_VIN_Seg2_NUM_CALLBACK ,cbr_apfnSIG_RX_CGW_VIN_VIN_Seg2 }, /* VIN_Seg2 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_VIN_VIN_Seg3_NUM_CALLBACK ,cbr_apfnSIG_RX_CGW_VIN_VIN_Seg3 }, /* VIN_Seg3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_VIN_VIN_Seg4_NUM_CALLBACK ,cbr_apfnSIG_RX_CGW_VIN_VIN_Seg4 }, /* VIN_Seg4 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_VIN_VIN_Seg5_NUM_CALLBACK ,cbr_apfnSIG_RX_CGW_VIN_VIN_Seg5 }, /* VIN_Seg5 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_VIN_VIN_Seg6_NUM_CALLBACK ,cbr_apfnSIG_RX_CGW_VIN_VIN_Seg6 }, /* VIN_Seg6 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 56,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_CGW_VIN_VIN_Seg7_NUM_CALLBACK ,cbr_apfnSIG_RX_CGW_VIN_VIN_Seg7 }, /* VIN_Seg7 */
};
const BYTE cbr_aubRX_CGW_VIN_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
const BYTE cbr_aubRX_CGW_VIN_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_CGW_VIN =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_CGW_VINSignals),
/* prSignals */                 cbr_aubRX_CGW_VINSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_CGW_VIN_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_CGW_VIN_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_EAM3_B30 */
/*****************************************************************************/
#define CBR_C_SIG_RX_EAM3_B30_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B30_SwivMonAutoOpen_Rq_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B30_ActCam1_Rq_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B30_ActCam2_Rq_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B30_ActCam3_Rq_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B30_ActCam4_Rq_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B30_ActCam5_Rq_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B30_ActCam6_Rq_NUM_CALLBACK    3
#define CBR_C_SIG_RX_EAM3_B30_ActCam7_Rq_NUM_CALLBACK    3
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B30[ CBR_C_SIG_RX_EAM3_B30_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B30_SwivMonAutoOpen_Rq[ CBR_C_SIG_RX_EAM3_B30_SwivMonAutoOpen_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B30_ActCam1_Rq[ CBR_C_SIG_RX_EAM3_B30_ActCam1_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B30_ActCam2_Rq[ CBR_C_SIG_RX_EAM3_B30_ActCam2_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B30_ActCam3_Rq[ CBR_C_SIG_RX_EAM3_B30_ActCam3_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B30_ActCam4_Rq[ CBR_C_SIG_RX_EAM3_B30_ActCam4_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B30_ActCam5_Rq[ CBR_C_SIG_RX_EAM3_B30_ActCam5_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B30_ActCam6_Rq[ CBR_C_SIG_RX_EAM3_B30_ActCam6_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_EAM3_B30_ActCam7_Rq[ CBR_C_SIG_RX_EAM3_B30_ActCam7_Rq_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B30[ CBR_C_SIG_RX_EAM3_B30_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B30_SwivMonAutoOpen_Rq[ CBR_C_SIG_RX_EAM3_B30_SwivMonAutoOpen_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B30_ActCam1_Rq[ CBR_C_SIG_RX_EAM3_B30_ActCam1_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B30_ActCam2_Rq[ CBR_C_SIG_RX_EAM3_B30_ActCam2_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B30_ActCam3_Rq[ CBR_C_SIG_RX_EAM3_B30_ActCam3_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B30_ActCam4_Rq[ CBR_C_SIG_RX_EAM3_B30_ActCam4_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B30_ActCam5_Rq[ CBR_C_SIG_RX_EAM3_B30_ActCam5_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B30_ActCam6_Rq[ CBR_C_SIG_RX_EAM3_B30_ActCam6_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_EAM3_B30_ActCam7_Rq[ CBR_C_SIG_RX_EAM3_B30_ActCam7_Rq_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif
const CSM_SIGNAL cbr_aubRX_EAM3_B30Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {0, CSM_C_DLC_EAM3_B30*8, CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B30_NUM_CALLBACK, cbr_apfnSIG_RX_EAM3_B30 }, /* EAM3_B30 */

  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B30_SwivMonAutoOpen_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B30_SwivMonAutoOpen_Rq }, /* SwivMonAutoOpen_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B30_ActCam1_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B30_ActCam1_Rq }, /* ActCam1_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 42,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B30_ActCam2_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B30_ActCam2_Rq }, /* ActCam2_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 44,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B30_ActCam3_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B30_ActCam3_Rq }, /* ActCam3_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 46,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B30_ActCam4_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B30_ActCam4_Rq }, /* ActCam4_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 48,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B30_ActCam5_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B30_ActCam5_Rq }, /* ActCam5_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 50,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B30_ActCam6_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B30_ActCam6_Rq }, /* ActCam6_Rq */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 52,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_EAM3_B30_ActCam7_Rq_NUM_CALLBACK ,cbr_apfnSIG_RX_EAM3_B30_ActCam7_Rq }, /* ActCam7_Rq */
};
const BYTE cbr_aubRX_EAM3_B30_DefaultData[] = {0,0,0,0,0x03,0xFF,0x3F,0};
const BYTE cbr_aubRX_EAM3_B30_TimeoutData[] = {0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_EAM3_B30 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_EAM3_B30Signals),
/* prSignals */                 cbr_aubRX_EAM3_B30Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_EAM3_B30_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_EAM3_B30_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

BYTE cbr_aubRX_Remotecontrol_TelData[ CSM_C_DLC_Remotecontrol];
BYTE cbr_aubRX_Resp_DeviceInformation2_TelData[ CSM_C_DLC_Resp_DeviceInformation2];
BYTE cbr_aubRX_Resp_DeviceInformation1_TelData[ CSM_C_DLC_Resp_DeviceInformation1];


/*****************************************************************************/
/* RX_Remotecontrol */
/*****************************************************************************/
#define CBR_C_SIG_RX_Remotecontrol_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Encoder2_Steps_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Encoder1_Steps_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Encoder2_Button_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Encoder1_Button_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key21_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key20_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key19_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key18_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key17_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key16_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key15_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key14_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key13_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key12_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key11_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key10_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key9_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key8_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key7_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key6_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key5_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key4_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key3_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key2_Status_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Remotecontrol_Key1_Status_NUM_CALLBACK    3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol[ CBR_C_SIG_RX_Remotecontrol_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Encoder2_Steps[ CBR_C_SIG_RX_Remotecontrol_Encoder2_Steps_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Encoder1_Steps[ CBR_C_SIG_RX_Remotecontrol_Encoder1_Steps_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Encoder2_Button[ CBR_C_SIG_RX_Remotecontrol_Encoder2_Button_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Encoder1_Button[ CBR_C_SIG_RX_Remotecontrol_Encoder1_Button_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key21_Status[ CBR_C_SIG_RX_Remotecontrol_Key21_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key20_Status[ CBR_C_SIG_RX_Remotecontrol_Key20_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key19_Status[ CBR_C_SIG_RX_Remotecontrol_Key19_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key18_Status[ CBR_C_SIG_RX_Remotecontrol_Key18_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key17_Status[ CBR_C_SIG_RX_Remotecontrol_Key17_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key16_Status[ CBR_C_SIG_RX_Remotecontrol_Key16_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key15_Status[ CBR_C_SIG_RX_Remotecontrol_Key15_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key14_Status[ CBR_C_SIG_RX_Remotecontrol_Key14_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key13_Status[ CBR_C_SIG_RX_Remotecontrol_Key13_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key12_Status[ CBR_C_SIG_RX_Remotecontrol_Key12_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key11_Status[ CBR_C_SIG_RX_Remotecontrol_Key11_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key10_Status[ CBR_C_SIG_RX_Remotecontrol_Key10_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key9_Status[ CBR_C_SIG_RX_Remotecontrol_Key9_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key8_Status[ CBR_C_SIG_RX_Remotecontrol_Key8_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key7_Status[ CBR_C_SIG_RX_Remotecontrol_Key7_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key6_Status[ CBR_C_SIG_RX_Remotecontrol_Key6_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key5_Status[ CBR_C_SIG_RX_Remotecontrol_Key5_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key4_Status[ CBR_C_SIG_RX_Remotecontrol_Key4_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key3_Status[ CBR_C_SIG_RX_Remotecontrol_Key3_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key2_Status[ CBR_C_SIG_RX_Remotecontrol_Key2_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Remotecontrol_Key1_Status[ CBR_C_SIG_RX_Remotecontrol_Key1_Status_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol[ CBR_C_SIG_RX_Remotecontrol_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Encoder2_Steps[ CBR_C_SIG_RX_Remotecontrol_Encoder2_Steps_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Encoder1_Steps[ CBR_C_SIG_RX_Remotecontrol_Encoder1_Steps_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Encoder2_Button[ CBR_C_SIG_RX_Remotecontrol_Encoder2_Button_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Encoder1_Button[ CBR_C_SIG_RX_Remotecontrol_Encoder1_Button_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key21_Status[ CBR_C_SIG_RX_Remotecontrol_Key21_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key20_Status[ CBR_C_SIG_RX_Remotecontrol_Key20_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key19_Status[ CBR_C_SIG_RX_Remotecontrol_Key19_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key18_Status[ CBR_C_SIG_RX_Remotecontrol_Key18_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key17_Status[ CBR_C_SIG_RX_Remotecontrol_Key17_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key16_Status[ CBR_C_SIG_RX_Remotecontrol_Key16_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key15_Status[ CBR_C_SIG_RX_Remotecontrol_Key15_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key14_Status[ CBR_C_SIG_RX_Remotecontrol_Key14_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key13_Status[ CBR_C_SIG_RX_Remotecontrol_Key13_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key12_Status[ CBR_C_SIG_RX_Remotecontrol_Key12_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key11_Status[ CBR_C_SIG_RX_Remotecontrol_Key11_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key10_Status[ CBR_C_SIG_RX_Remotecontrol_Key10_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key9_Status[ CBR_C_SIG_RX_Remotecontrol_Key9_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key8_Status[ CBR_C_SIG_RX_Remotecontrol_Key8_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key7_Status[ CBR_C_SIG_RX_Remotecontrol_Key7_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key6_Status[ CBR_C_SIG_RX_Remotecontrol_Key6_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key5_Status[ CBR_C_SIG_RX_Remotecontrol_Key5_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key4_Status[ CBR_C_SIG_RX_Remotecontrol_Key4_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key3_Status[ CBR_C_SIG_RX_Remotecontrol_Key3_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key2_Status[ CBR_C_SIG_RX_Remotecontrol_Key2_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Remotecontrol_Key1_Status[ CBR_C_SIG_RX_Remotecontrol_Key1_Status_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_RemotecontrolSignals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 0,  64),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol }, /* Remote Control */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 54,  8),  CSM_C_ALWAYS_IND, CBR_C_SIG_RX_Remotecontrol_Encoder2_Steps_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Encoder2_Steps }, /* Encoder2_Steps */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 46,  8),  CSM_C_ALWAYS_IND, CBR_C_SIG_RX_Remotecontrol_Encoder1_Steps_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Encoder1_Steps }, /* Encoder1_Steps */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 44,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Encoder2_Button_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Encoder2_Button }, /* Encoder2_Button */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 42,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Encoder1_Button_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Encoder1_Button }, /* Encoder1_Button */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key21_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key21_Status }, /* Key21_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 38,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key20_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key20_Status }, /* Key20_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 36,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key19_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key19_Status }, /* Key19_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 34,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key18_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key18_Status }, /* Key18_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key17_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key17_Status }, /* Key17_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 30,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key16_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key16_Status }, /* Key16_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 28,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key15_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key15_Status }, /* Key15_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 26,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key14_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key14_Status }, /* Key14_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key13_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key13_Status }, /* Key13_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 22,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key12_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key12_Status }, /* Key12_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 20,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key11_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key11_Status }, /* Key11_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 18,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key10_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key10_Status }, /* Key10_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key9_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key9_Status }, /* Key9_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 14,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key8_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key8_Status }, /* Key8_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 12,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key7_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key7_Status }, /* Key7_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 10,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key6_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key6_Status }, /* Key6_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key5_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key5_Status }, /* Key5_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  6,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key4_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key4_Status }, /* Key4_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  4,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key3_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key3_Status }, /* Key3_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  2,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key2_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key2_Status }, /* Key2_Status */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  2),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Remotecontrol_Key1_Status_NUM_CALLBACK ,cbr_apfnSIG_RX_Remotecontrol_Key1_Status }, /* Key1_Status */
};
const BYTE cbr_aubRX_Remotecontrol_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
const BYTE cbr_aubRX_Remotecontrol_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_Remotecontrol =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_RemotecontrolSignals),
/* prSignals */                 cbr_aubRX_RemotecontrolSignals,
/* pvTeleGramDefaultData */     cbr_aubRX_Remotecontrol_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     cbr_aubRX_Remotecontrol_TimeoutData,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_Resp_DeviceInformation2 */
/*****************************************************************************/
#define CBR_C_SIG_RX_Resp_DeviceInformation2_NUM_CALLBACK                 3
#define CBR_C_SIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP_NUM_CALLBACK    3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation2[ CBR_C_SIG_RX_Resp_DeviceInformation2_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP[ CBR_C_SIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP[ CBR_C_SIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation2[ CBR_C_SIG_RX_Resp_DeviceInformation2_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP[ CBR_C_SIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP[ CBR_C_SIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_Resp_DeviceInformation2Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 64),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation2_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation2 }, /* Device Information 2 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 32),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation2_B_SW_Ver_MCP }, /* B_SW_Ver_MCP */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32, 32),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation2_B_HW_Ver_MCP }, /* B_HW_Ver_MCP */
};
const BYTE cbr_aubRX_Resp_DeviceInformation2_DefaultData[] = {0,0,0,0,0,0,0,0};
const BYTE cbr_aubRX_Resp_DeviceInformation2_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_Resp_DeviceInformation2 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_Resp_DeviceInformation2Signals),
/* prSignals */                 cbr_aubRX_Resp_DeviceInformation2Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_Resp_DeviceInformation2_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};

/*****************************************************************************/
/* RX_Resp_DeviceInformation1 */
/*****************************************************************************/
#define CBR_C_SIG_RX_Resp_DeviceInformation1_NUM_CALLBACK            3
#define CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_YY_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_MM_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_DD_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_YY_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_MM_NUM_CALLBACK    3
#define CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_DD_NUM_CALLBACK    3

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation1[ CBR_C_SIG_RX_Resp_DeviceInformation1_NUM_CALLBACK] = { CCS_BR_vCSMSigInd, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_YY[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_YY_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_MM[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_DD[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_DD_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_YY[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_YY_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_MM[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_MM_NUM_CALLBACK] = { NULL, NULL, NULL };
/*const*/ tCSM_PFN_CBR_SIGNAL_IND cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_DD[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_DD_NUM_CALLBACK] = { NULL, NULL, NULL };
#else
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation1[ CBR_C_SIG_RX_Resp_DeviceInformation1_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_YY[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_YY_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_MM[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_DD[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_DD_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_YY[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_YY_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_MM[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_MM_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
/*const*/ tCSM_BR_SIGNAL_CALLBACK cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_DD[ CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_DD_NUM_CALLBACK] = {{ NULL }, { NULL }, { NULL }};
#endif

const CSM_SIGNAL cbr_aubRX_Resp_DeviceInformation1Signals[] =
{
  /*  bStartBit,  bLength,  bIndicationMode,  pfvSignalInd1, ..2, ..3 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0, 64),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1 }, /* Device Information 1 */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  0,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_YY_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_YY }, /* B_SW_YY */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL(  8,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_MM }, /* B_SW_MM */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 16,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_SW_DD_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_SW_DD }, /* B_SW_DD */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 24,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_YY_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_YY }, /* B_HW_YY */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 32,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_MM_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_MM }, /* B_HW_MM */
  {CBR_CONVERT_VECTOR_DBC_LITTLE_SIGNAL( 40,  8),  CSM_C_IND_AFTER_CHANGE, CBR_C_SIG_RX_Resp_DeviceInformation1_B_HW_DD_NUM_CALLBACK ,cbr_apfnSIG_RX_Resp_DeviceInformation1_B_HW_DD }, /* B_HW_DD */
};
const BYTE cbr_aubRX_Resp_DeviceInformation1_DefaultData[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0,0};
const BYTE cbr_aubRX_Resp_DeviceInformation1_TimeoutData[] = {0,0,0,0,0,0,0,0};
/***********************/
const CSM_TELEGRAM cbr_aubRX_Resp_DeviceInformation1 =
{
/* bNumberOfSignals */          CSM_M_NUMBER_OF_CBR_SIGNALS(cbr_aubRX_Resp_DeviceInformation1Signals),
/* prSignals */                 cbr_aubRX_Resp_DeviceInformation1Signals,
/* pvTeleGramDefaultData */     cbr_aubRX_Resp_DeviceInformation1_DefaultData,
/* pvTelegramDefaultMask */     NULL,
/* pvTelegramTimeOutData */     NULL,
/* pvTelegramTimeOutMask */     NULL
};


const CSM_CBR_TX csm_arCbrTxTelegram_Slot0 [CBR_TX_MAX_NUMBER_SLOT0]=
{
/*
bus,                       id ,                dlc,                         pointer to data buffer,                    message type,        cycle time  number of repetitions minimum distance    delay */



CSM_C_CAN_BUS_VCAN, MK_ID(0x98eaeeffL),  CSM_C_DLC_RQST2TCO,                cbr_aubTX_RQST2TCO_TelData,                CBR_TMSG_SPONTAN,           0,          0,            0,          0,
CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff0154L),  CSM_C_DLC_CMC_C01_AR,              cbr_aubTX_CMC_C01_AR_TelData,              CBR_TMSG_SPONTAN,           0,          0,            0,          0,
CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff8054L),  CSM_C_DLC_NM_HUS_AR,               cbr_aubTX_NM_HUS_AR_TelData,               CBR_TMSG_SPONTAN,           0,          0,            0,          0,
CSM_C_CAN_BUS_VCAN, MK_ID(0x10feca54L),  CSM_C_DLC_HUS_DM1,                 cbr_aubTX_HUS_DM1_TelData,                 CBR_TMSG_SPONTAN,           0,          0,           20,          0,

CSM_C_CAN_BUS_MCAN, MK_ID(0x98ff0b4cL),  CSM_C_DLC_KeyIllumination1,        cbr_aubTX_KeyIllumination1_TelData,        CBR_TMSG_CYCLIC,         1000,          0,          100,          0,
CSM_C_CAN_BUS_MCAN, MK_ID(0x98ff0a4cL),  CSM_C_DLC_KeyIllumination0,        cbr_aubTX_KeyIllumination0_TelData,        CBR_TMSG_CYCLIC,         1000,          0,          100,          0,
CSM_C_CAN_BUS_MCAN, MK_ID(0x98ff0d4cL),  CSM_C_DLC_KeyColour1,              cbr_aubTX_KeyColour1_TelData,              CBR_TMSG_CYCLIC,         1000,          0,          100,          0,
CSM_C_CAN_BUS_MCAN, MK_ID(0x98ff0c4cL),  CSM_C_DLC_KeyColour0,              cbr_aubTX_KeyColour0_TelData,              CBR_TMSG_CYCLIC,         1000,          0,          100,          0,
CSM_C_CAN_BUS_MCAN, MK_ID(0x98ff0e4cL),  CSM_C_DLC_Req_DeviceInformation,   cbr_aubTX_Req_DeviceInformation_TelData,   CBR_TMSG_SPONTAN,           0,          0,            0,          0,
} ;


/* ------------------------------------------------------------------------- */
const CSM_TELEGRAM* const cbr_arTxTelegramIndex_Slot0[CBR_TX_MAX_NUMBER_SLOT0] =
{
  &cbr_aubTX_RQST2TCO,
  &cbr_aubTX_CMC_C01_AR,
  &cbr_aubTX_NM_HUS_AR,
  &cbr_aubTX_HUS_DM1,
  &cbr_aubTX_KeyIllumination1,
  &cbr_aubTX_KeyIllumination0,
  &cbr_aubTX_KeyColour1,
  &cbr_aubTX_KeyColour0,
  &cbr_aubTX_Req_DeviceInformation,
 };


const CSM_CBR_RX csm_arCbrRxTelegram_Slot0[CBR_RX_MAX_NUMBER_SLOT0] = {
/* The remote approach uses dlc and message type from this array, */
/* therefore correct IDs, message types and timeouts not necessary */

/*                     ID                  dlc,                      address of data buffer,                     message type,      timeout time */

{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff288cL), CSM_C_DLC_EAM3_B34,                  &cbr_aubRX_EAM3_B34_TelData,                        CBR_TMSG_CYCLIC_AND_SPONTAN,             100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff3f8cL), CSM_C_DLC_EAM3_B33,                  &cbr_aubRX_EAM3_B33_TelData,                        CBR_TMSG_CYCLIC_AND_SPONTAN,             100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff0817L), CSM_C_DLC_ICUC_C10,                  &cbr_aubRX_ICUC_C10_TelData,                        CBR_TMSG_CYCLIC_AND_SPONTAN,             100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff0721L), CSM_C_DLC_SCA_E1,                    &cbr_aubRX_SCA_E1_TelData,                          CBR_TMSG_CYCLIC_AND_SPONTAN,             100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff024cL), CSM_C_DLC_WMI_C02,                   &cbr_aubRX_WMI_C02_TelData,                         CBR_TMSG_CYCLIC,                         100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ecffeeL), CSM_C_DLC_TPCM_TCO,                  &cbr_aubRX_TPCM_TCO_TelData,                        CBR_TMSG_SPONTAN,                        100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ebffeeL), CSM_C_DLC_TPDT_TCO,                  &cbr_aubRX_TPDT_TCO_TelData,                        CBR_TMSG_SPONTAN,                        100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x8cfe6c17L), CSM_C_DLC_TCO1_ICUC,                 &cbr_aubRX_TCO1_ICUC_TelData,                       CBR_TMSG_CYCLIC,                         100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98fe6beeL), CSM_C_DLC_DI_Shrt_TCO,               &cbr_aubRX_DI_Shrt_TCO_TelData,                     CBR_TMSG_SPONTAN,                        100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff8026L), CSM_C_DLC_NM_APPL_NWT_AR,            &cbr_aubRX_NM_APPL_NWT_AR_TelData,                  CBR_TMSG_CYCLIC,                         100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff0447L), CSM_C_DLC_SCH_E1,                    &cbr_aubRX_SCH_E1_TelData,                          CBR_TMSG_CYCLIC_AND_SPONTAN,             100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x90ff0021L), CSM_C_DLC_SCA_C2,                    &cbr_aubRX_SCA_C2_TelData,                          CBR_TMSG_CYCLIC,                         100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x94f00500L), CSM_C_DLC_ETC2_CPC,                  &cbr_aubRX_ETC2_CPC_TelData,                        CBR_TMSG_CYCLIC,                         100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x94febf0bL), CSM_C_DLC_EBC2_BS,                   &cbr_aubRX_EBC2_BS_TelData,                         CBR_TMSG_CYCLIC,                         100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x94ff0017L), CSM_C_DLC_ICUC_C2,                   &cbr_aubRX_ICUC_C2_TelData,                         CBR_TMSG_CYCLIC_AND_SPONTAN,             100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98fee617L), CSM_C_DLC_TD_ICUC,                   &cbr_aubRX_TD_ICUC_TelData,                         CBR_TMSG_CYCLIC,                         100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff0017L), CSM_C_DLC_ICUC_C1,                   &cbr_aubRX_ICUC_C1_TelData,                         CBR_TMSG_CYCLIC_AND_SPONTAN,             100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff0025L), CSM_C_DLC_CGW_C1,                    &cbr_aubRX_CGW_C1_TelData,                          CBR_TMSG_CYCLIC_AND_SPONTAN,             100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ffc025L), CSM_C_DLC_CGW_GVC1,                  &cbr_aubRX_CGW_GVC1_TelData,                        CBR_TMSG_SPONTAN,                        100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ffc825L), CSM_C_DLC_CGW_VIN,                   &cbr_aubRX_CGW_VIN_TelData,                         CBR_TMSG_SPONTAN,                        100 },
{ CSM_C_CAN_BUS_VCAN, MK_ID(0x98ff3b8cL), CSM_C_DLC_EAM3_B30,                  &cbr_aubRX_EAM3_B30_TelData,                        CBR_TMSG_SPONTAN,                        100 },
{ CSM_C_CAN_BUS_MCAN, MK_ID(0x94ff032cL), CSM_C_DLC_Remotecontrol,             &cbr_aubRX_Remotecontrol_TelData,                   CBR_TMSG_CYCLIC,                         500 },
{ CSM_C_CAN_BUS_MCAN, MK_ID(0x98ff0f2cL), CSM_C_DLC_Resp_DeviceInformation2,   &cbr_aubRX_Resp_DeviceInformation2_TelData,         CBR_TMSG_SPONTAN,                          0 },
{ CSM_C_CAN_BUS_MCAN, MK_ID(0x98ff0e2cL), CSM_C_DLC_Resp_DeviceInformation1,   &cbr_aubRX_Resp_DeviceInformation1_TelData,         CBR_TMSG_SPONTAN,                          0 },
};


/* ------------------------------------------------------------------------- */
const CSM_TELEGRAM* const cbr_arRxTelegramIndex_Slot0[CBR_RX_MAX_NUMBER_SLOT0] =
{
  &cbr_aubRX_SCH_E1,
  &cbr_aubRX_EAM3_B34,
  &cbr_aubRX_EAM3_B33,
  &cbr_aubRX_ICUC_C10,
  &cbr_aubRX_SCA_E1,
  &cbr_aubRX_WMI_C02,
  &cbr_aubRX_TPCM_TCO,
  &cbr_aubRX_TPDT_TCO,
  &cbr_aubRX_TCO1_ICUC,
  &cbr_aubRX_DI_Shrt_TCO,
  &cbr_aubRX_NM_APPL_NWT_AR,
  &cbr_aubRX_SCA_C2,
  &cbr_aubRX_ETC2_CPC,
  &cbr_aubRX_EBC2_BS,
  &cbr_aubRX_ICUC_C2,
  &cbr_aubRX_TD_ICUC,
  &cbr_aubRX_ICUC_C1,
  &cbr_aubRX_CGW_C1,
  &cbr_aubRX_CGW_GVC1,
  &cbr_aubRX_CGW_VIN,
  &cbr_aubRX_EAM3_B30,
  &cbr_aubRX_Remotecontrol,
  &cbr_aubRX_Resp_DeviceInformation2,
  &cbr_aubRX_Resp_DeviceInformation1,
};




#endif /* CBR_SELF */

/*****************************************************************************/
/* CNP_ITP */
/*****************************************************************************/
#if (CSM_S_ISO_TP == CSM_C_F_ON)

/*#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
extern const tCSM_ISO_TP_USDT_APPL_CALLBACK_ADMIN csm_itp_arCallbackFkt[ CSM_C_ISO_TP_MAX_CONNECTIONS];
#else
extern tCSM_ISO_TP_USDT_APPL_CALLBACK_ADMIN csm_itp_arCallbackFkt[ CSM_C_ISO_TP_MAX_CONNECTIONS];
#endif

#ifdef CSM_ITP_SELF

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)

const tCSM_ISO_TP_USDT_APPL_CALLBACK_ADMIN csm_itp_arCallbackFkt[ CSM_C_ISO_TP_MAX_CONNECTIONS] =
{
   {
      NULL, NULL, CCS_NP_vCSMMsgCon, CCS_NP_vCSMMsgReceived, CCS_NP_vCSMDataErrorInd
   },
   {
      NULL, NULL, NULL, NULL
   },
   {
      NULL, NULL, NULL, NULL
   }
};
#else
tCSM_ISO_TP_USDT_APPL_CALLBACK_ADMIN csm_itp_arCallbackFkt[ CSM_C_ISO_TP_MAX_CONNECTIONS];
#endif

#endif *//* CSM_ITP_SELF */


#endif /* CSM_S_ISO_TP */

#if (CSM_S_ISO_TP == CSM_C_F_ON)
#ifdef CNP_ITP_SELF
/* "malloc" RxAssembly and Tx buffer
 * Take care of channel number and length defined above */

BYTE cnp_abAssBufCh0[ CSM_C_USDT_ISO_INF4CV_USDT_ISO_EXTKI_MAX_RX_LENGTH];
BYTE cnp_abTxBufCh0[ CSM_C_USDT_ISO_INF4CV_USDT_ISO_EXTKI_MAX_TX_LENGTH];

BYTE cnp_abAssBufCh1[ CSM_C_USDT_ISO_DTCCT_USDT_ISO_DIAG_MAX_RX_LENGTH];
BYTE cnp_abTxBufCh1[ CSM_C_USDT_ISO_DTCCT_USDT_ISO_DIAG_MAX_TX_LENGTH];

BYTE cnp_abAssBufCh2[ CSM_C_USDT_ISO_INF4CV_USDT_ISO_EXTKI_MAX_RX_LENGTH];
BYTE cnp_abTxBufCh2[ CSM_C_USDT_ISO_INF4CV_USDT_ISO_EXTKI_MAX_TX_LENGTH];


    /* Macros to initialize the buffers (no way found to place CNP_rItpAssRxBuf[0] in ROM) */
#define CNP_M_INIT_ASS_BUF_ARRAY \
                 CNP_rItpAssRxBuf[0].rMsg.pbData=cnp_abAssBufCh0;\
                 CNP_rItpAssRxBuf[1].rMsg.pbData=cnp_abAssBufCh1;\
         CNP_rItpAssRxBuf[2].rMsg.pbData=cnp_abAssBufCh2;\


#define CNP_M_INIT_TX_BUF_ARRAY \
                 CNP_rItpTxBuf[0].rMsg.pbData=cnp_abTxBufCh0;\
                 CNP_rItpTxBuf[1].rMsg.pbData=cnp_abTxBufCh1;\
         CNP_rItpTxBuf[2].rMsg.pbData=cnp_abTxBufCh2;\


#endif /* CNP_ITP_SELF */
#endif /* CSM_S_ISO_TP */


//**************************************************************************************************
//* CBR configuration, variables (Generated code - do NOT change manually !!!)
//**************************************************************************************************
