#ifndef CSM_STACK_MP_HEADER
// File name for preprozessor commands
#define CSM_STACK_MP_HEADER
// This include is required to keep the native signals away from users of csm_stack_ip.h (indirectly csm_if.h)
#include "csm_stack_cbr_ip.h"

#define MK_ID(a) a
#define MK_EXT_ID(a) (0x80000000 | (a))

//**************************************************************************************************
//* CSM global and project independent !!!
//**************************************************************************************************
// assert macro
#define CSM_vAssert(_INT_)  NORMAL_M_ASSERT(_INT_)

// TTFis trace class based on component definition from elsewhere
#define TR_CLASS_FD_CSM      (TR_COMP_CSM + 0)  // 0x1C00
#define TR_CLASS_FD_CSMTST   (TR_COMP_CSM + 1)  // 0x1C01

/*****************************************************************************/
 /* CNP_ITP */
/*****************************************************************************/
#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_ISO_TP == CSM_C_F_ON)

#define CSM_C_ISO_TP_MAX_CONNECTIONS 3

#endif /* CSM_S_ISO_TP */
#endif /* CSM_S_CNP_AVAILABLE */

// Number of used CAN busses
#define CSM_C_MAX_CAN_BUS                          2

#if (defined VARIANT_S_FTR_ENABLE_INF4CV) || (defined VARIANT_S_FTR_ENABLE_EVOBUS) || (defined VARIANT_S_FTR_ENABLE_SMART_HU)|| (defined VARIANT_S_FTR_ENABLE_EVOBUSB2E) || (defined CSM_C_PROJECT_USERSPACE_EVOBUS) || (defined CSM_C_PROJECT_USERSPACE_EVOBUSB2E) || (defined CSM_C_PROJECT_USERSPACE_INF4CV) || (defined CSM_C_PROJECT_USERSPACE_SMART_HU)
  // fine: at least we are building one project
  #if (defined VARIANT_S_FTR_ENABLE_INF4CV) || (defined CSM_C_PROJECT_USERSPACE_INF4CV)
    #include "csm_stack_mp_inf4cv.h"
  #elif (defined VARIANT_S_FTR_ENABLE_EVOBUS) || (defined CSM_C_PROJECT_USERSPACE_EVOBUS)
  #include "csm_stack_mp_evobus.h"
  #elif (defined VARIANT_S_FTR_ENABLE_SMART_HU) || (defined CSM_C_PROJECT_USERSPACE_SMART_HU)
  #include "csm_stack_mp_smart_hu.h"
  #elif (defined VARIANT_S_FTR_ENABLE_EVOBUSB2E) || (defined CSM_C_PROJECT_USERSPACE_EVOBUSB2E)
	#include "csm_stack_mp_evobusb2e.h"
  #else
    #error "No valid project variant detectable: g3inf4cv expected here"
  #endif
#else
  // if no variant feature switch is defined, we do not need the content of csm_stack_mp.h for the product being build
#endif

#else  // CSM_STACK_MP_HEADER
  #error CSM_STACK_MP.H included several times
#endif // CSM_STACK_MP_HEADER

/***************************************************************************************************
 * \doxydocu
 * \file          csm_stack_mp.h
 * \brief         Project specific part of the module internal header(s) of the
 *                whole CAN stack.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESU3
 *
 * \sw_component  CAN stack
 * \project       Renault Nissan IVI
 * \path          /di_can/modules_swa/csm_stack/src/
 *
 * \ingroup       CSM
 * \ingroup       CSM_STACK
 *
 * \authors       Borck
 *
 * COPYRIGHT      (c) 2015 Bosch Car Multimedia GmbH
 *
 * \history_begin
 *
 * 21.09.15  main\rn_aivi_proxy\rn_aivi_generated\1   A.Borck
 * - initial, generated
 *
 * 22.09.15  main\rn_aivi_proxy\rn_aivi_generated\2   A.Borck
 * - default data of 0x5FE changed manually !!
 *
 * 21.10.15  main\rn_aivi_proxy\rn_aivi_generated\3   A.Borck
 * - some signals removed (for 0x71E, 0x72E)
 *
 * 26.10.15  main\rn_aivi_proxy\rn_aivi_generated\4   A.Borck
 * - few ADASIS messages made temporarily, manually for event based TX only (0x4D0, 0x5F6)
 *
 * 04.11.15  main\rn_aivi_proxy\rn_aivi_generated\5   A.Borck
 * - new timer IDs added
 * - amount of MPDT connections increased from 3 to 8 (RSE is configured but not initialized)
 * - timer array extended
 *
 * 11.11.15  main\rn_aivi_proxy\rn_aivi_generated\6   A.Borck
 * - number of RX monitors synced with v850 (from 6 to 15)
 * - number of TX monitors increased to 9
 *
 * 02.12.15  main\rn_aivi_proxy\rn_aivi_generated\7   A.Borck
 * - Sync with modified Generator Template and Input Table
 * - amount of RX monitors changed from 15 -> 13
 * - message lengths of 5F7, 355 and 1F9 changed
 * - some few changes of the generated code have to be done manually !!!
 *
 * 08.01.16  main\rn_aivi_proxy\rn_aivi_generated\8   A.Borck
 * - number of TX monitors increased to 11
 *
 * 02.03.16  main\rn_aivi_proxy\rn_aivi_generated\9   A.Borck
 * - new Sync with code generation tool chain
 * - SLOTs 0,1 introduced
 * - RX/TX telegram buffers: principle of sharing 1 single buffer for all SLOTs introduced
 * - Note: mind the manual changes !!
 *
 * 14.03.16  main\rn_aivi_proxy\rn_aivi_generated\10   A.Borck
 * - Sync with new code generation tool chain
 * - SLOT 1 has 61 RX messages now (+ ISO, + XCP, 1 TX -> limit of 64 message boxes reached
 *
 * 17.03.16  main\rn_aivi_proxy\rn_aivi_generated\11   M.Proehl
 * - Slot 3 is now generated.
 *
 * 22.03.16  main\rn_aivi_proxy\rn_aivi_generated\12   M.Proehl
 * - Slot 3 is now generated. update
 *
 * 06.04.16  main\rn_aivi_proxy\rn_aivi_generated\13   A.Borck
 * - Sync with new template for this file (to get away from manually required adaptions):
 *   - nr. of basic objects is 16 now again (Sammler is currently obsolete)
 *   - SIGMA and XCP TX/RX identifiers are now generated also
 *   - TX Default data for 0x402 also set for SLOT3 (same as SLOT1)
 *   - TX Type for 0x4D0 set to spontan for SLOT1 (same as SLOT5/6)
 *   - TX default data for 0x558 fixed
 *   - TX Type for 0x5F6 set to spontan for SLOT1 (same as SLOT5/6)
 *   - Bus IDs for MCAN set correctly in Descriptor tables for the IDs 0x320, 0x321, 0x402,0x558 and 0x58F
 *
 * 19.04.16  main\rn_aivi_proxy\rn_aivi_generated\14   A.Borck
 * - new sync with updated generator files
 *
 * 18.05.16  main\rn_aivi_proxy\rn_aivi_generated\15   A.Borck
 * - new sync with updated template
 *   - memory saving optimisation for v850 must NOT be applied for iMX site !! (template fixed, not visible here)
 *   - SIGMA frames set to indication type ALWAYS_INDICATE
 *
 * 26.05.16  main\rn_aivi_proxy\rn_aivi_generated\16   A.Borck
 * - new code generation due to new database
 *
 * 14.06.16  main\rn_aivi_proxy\rn_aivi_generated\17   A.Borck
 * - new code generation due to new database
 *
 * 20.06.16  main\rn_aivi_proxy\rn_aivi_generated\18   A.Borck
 * - new code generation due to new database and new features
 *
 * 23.06.16  main\rn_aivi_proxy\rn_aivi_generated\19   A.Borck
 * - new code generation due to changed template (introduction of proxy mask)
 *
 * 28.07.16  main\rn_aivi_proxy\rn_aivi_generated\20   M.Proehl
 * - new code generation from  https://hi-dms.de.bosch.com/docushare/dsweb/Get/Version-1266420/AbstractionMaster_Scope21.xlsx
 *   and https://hi-dms.de.bosch.com/docushare/dsweb/Get/Version-1265727/Translationtable_based_on_N-V01-01_A-IVI_V-CAN_Spec_v3.3.0.xlsx
 *
 * 08.08.16  main\rn_aivi_proxy\rn_aivi_generated\21   A.Borck
 * - new code generation due to latest delivery from Stephan and corrections from Tobias
 *
 * 10.08.16  main\rn_aivi_proxy\rn_aivi_generated\22   A.Borck
 * - new code generated: timeout for 0x63D set to 200 ms
 *
 * 16.08.16  main\rn_aivi_proxy\rn_aivi_generated\23   A.Borck
 * - Check auf ueberlappende Signale innerhalb eines Frames (bzw. einer Multiplex-Gruppe) implementiert
 * - Generierung einer Textdatei mit Warnungen bei verdaechtigen Coding-Meaning-Tabelleneintraegen, deren Format die Erzeugung einer
 *   Signal-Wertetabelle verhindern (relevant eigentlich nur fuer CANoe)
 * - enthaelt die neueste AbstractionMaster-Tabelle (DocuShare V23) und TranslationTable_v3.3.0 (DocuShare V26) (beide im ZIP enthalten)
 *   mit signal-overlap-Korrekturen fuer drei Signale
 *
 * 23.08.16  main\rn_aivi_proxy\rn_aivi_generated\24   A.Borck
 * - new code generation: RX timeout and TX MinDelay are handled in Stephan's Tooling already
 *
 * 25.08.16  main\rn_aivi_proxy\rn_aivi_generated\25   A.Borck
 * - new code generation due to new database with Slot 71E
 *
 * 26.08.16  main\rn_aivi_proxy\rn_aivi_generated\26   A.Borck
 * - templated changed, so that in unused SLOTs the dummy TX message cannot be sent
 *
 * 31.08.16  main\rn_aivi_proxy\rn_aivi_generated\27   A.Borck
 * - bug fix due to missing signal in 0x350
 *
 * 06.09.16  main\rn_aivi_proxy\rn_aivi_generated\28   A.Borck
 * - added to TTFis commands to check INC comm state and to ReInit datapool
 *
 * 19.09.16  main\rn_aivi_proxy\rn_aivi_generated\29   A.Borck
 * - MPDT channel now supporting C-Type and D-Type data (here new required timers added)
 *
 * 26.09.16  main\rn_aivi_proxy\rn_aivi_generated\30   A.Borck
 * - added a #define for TTFis command (set datapool item)
 *
 * 21.10.16  main\rn_aivi_proxy\rn_aivi_generated\31   A.Borck
 * - code generation now based on database 3.4.0
 *
 * 07.11.16  main\rn_aivi_proxy\rn_aivi_generated\32   A.Borck
 * - one define added for LOgLevel setting on v850 via LCTRL DataReq
 *
 * 08.11.16  main\rn_aivi_proxy\rn_aivi_generated\33   A.Borck
 * - new code generation due to new database
 *
 * 22.11.16  main\rn_aivi_proxy\rn_aivi_generated\34   A.Borck
 * - new code generation due to new master abstraction table
 *
 * 09.12.16  main\rn_aivi_proxy\rn_aivi_generated\35   A.Borck
 * - new include file added (csm_stack_cbr_ip.h)
 *
 * 12.12.16  main\rn_aivi_proxy\rn_aivi_generated\36   A.Borck
 * - new code generation due to new database
 *
 * 16.01.17  main\rn_aivi_proxy\rn_aivi_generated\37   A.Borck
 * - CSM internal, real RIVIE/NPIVI support enabled now vie different include files at compilation time
 *
 * 23.01.17  main\rn_aivi_proxy\rn_aivi_generated\38   A.Borck
 * - trace class definition for csm test process moved here.
 *
 * 24.11.17  main\g3inf4cv_csm_proxy_in\1  Jayashree
 * - Initial version for INF4CV
 *
 **************************************************************************************************/
// ##################################################
// _CSM_SECTION_HISTORY: user specific code end
// ##################################################
