//lint -wlib(1)               suppress lint messages for <...> libraries

// Description and history of csm_stack_linux_p.c at the end of the file.
// File name for preprocessor commands
#define CSM_STACK_LINUX_P_SELF

#ifdef CSM_STACK_LINUX_P_SELF
// LINT happy
#endif

/*******************************************************************************
| includes:
|   1)system- and project- includes
|   2)needed interfaces from external components
|...3)internal and external interfaces from this component
|-----------------------------------------------------------------------------*/

//#define CSM_S_IMPORT_INTERFACE_GENERIC_USER               // ???
//#define CSM_S_IMPORT_INTERFACE_GENERIC_KERNEL             // ???

// DataGram socket service
#define USE_DGRAM_SERVICE
// DGRAM include
#ifdef USE_DGRAM_SERVICE
#include "dgram_service.h"
#endif

// CSM includes
#include "csm_stack_i.h"
#include "csm_i.h"
#include "csm_stack_m.h"
#include "csm_m.h"
#include "csm_apl.h"

#if (CSM_S_REMOTE_STACK == CSM_C_F_ON)
 // if running as PROXY we need apropriate inlcudes
 #include "csm_proxy_i.h"
 #include "csm_proxy_m.h"
#endif

// system includes
//#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>               // prototypes for IP conversion
#include <pthread.h>
#include <errno.h>
#include <netdb.h>

// INC includes
#include "inc.h"
#include "inc_ports.h"
#include "inc_scc_port_extender_gpio.h"

// BKA2HI workaround, since platform refuses to define sensible, generic names
#ifndef NET_TP10_PORT
//#define NET_TP10_PORT (0xC700 | 0x0020)
#define NET_TP10_PORT  BAP_00_PORT
#endif

#ifndef NET_TP11_PORT
//#define NET_TP11_PORT (0xC700 | 0x0021)
#define NET_TP11_PORT  BAP_01_PORT
#endif

/*************** ETG Tracing ******/
#define TR_CLASS_CSMLINUX (TR_COMP_CSM + 0x15)

#if (CSM_S_TRACE == CSM_C_F_ON)
  #define ETRACE_S_IMPORT_INTERFACE_GENERIC
  //#define ETRACE_S_IMPORT_INTERFACE_ERRMEM                 // was nicht gebraucht wird, darf auskommentiert werden
  #include "etrace_if.h"

  #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
  #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
    #include "csm_etg_trace.h"
    #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CSMLINUX
    //#define ETG_INLINE
    #include "trcGenProj/Header/csm_stack_linux_p.c.trc.h"
  #endif
  #endif
#endif // CSM_S_TRACE

/*******************************************************************************
 * defines and macros (scope: file local)
 ******************************************************************************/
// parameters for callbacks
#define INC_COM_INDICATION                    0    // indicates RX data
#define INC_COM_CONFIRMATION                  1    // indicates TX confirmation

/*******************************************************************************
 * typedefs (scope: file local)
 ******************************************************************************/
// none

/*******************************************************************************
 * variable definition (scope: file local)
 ******************************************************************************/
static BYTE abTimeoutFlags[CSM_MAX_TIMER];         // timeout flags

/*******************************************************************************
 * variable definition (scope: CAN stack)
 ******************************************************************************/
extern BYTE bCbrTxMaxNumber;

// some pointers to DGRAM data
sk_dgram * csm_stack_pdgram_net;                   // NET ctrl
sk_dgram * csm_stack_pdgram_br;                    // broadcasts
//sk_dgram * csm_stack_pdgram_can_raw;             // NET TP 0 = RAW currently not used
sk_dgram * csm_stack_pdgram_can_np1;               // NET TP 1
sk_dgram * csm_stack_pdgram_can_np2;               // NET TP 2
sk_dgram * csm_stack_pdgram_can_np3;               // NET TP 3
sk_dgram * csm_stack_pdgram_can_np4;               // NET TP 4
sk_dgram * csm_stack_pdgram_can_np5;               // NET TP 5
sk_dgram * csm_stack_pdgram_can_np6;               // NET TP 6
sk_dgram * csm_stack_pdgram_can_np7;               // NET TP 7
sk_dgram * csm_stack_pdgram_can_np8;               // NET TP 8
sk_dgram * csm_stack_pdgram_can_np9;               // NET TP 9
sk_dgram * csm_stack_pdgram_can_np10;              // NET TP 10
sk_dgram * csm_stack_pdgram_can_np11;              // NET TP 11

/*******************************************************************************
 * function prototypes (scope: file local)
 ******************************************************************************/
void csm_vRemoteNetComCallback(INT s32Arg);        // NET ctrl
void csm_vBrSignalComCallback(INT s32Arg);         // broadcasts
//void csm_vRawComCallback(INT s32Arg);            // NET TP 0 = RAW currently not used
void csm_vTp1ComCallback(INT s32Arg);              // NET TP 1
void csm_vTp2ComCallback(INT s32Arg);              // NET TP 2
void csm_vTp3ComCallback(INT s32Arg);              // NET TP 3
void csm_vTp4ComCallback(INT s32Arg);              // NET TP 4
void csm_vTp5ComCallback(INT s32Arg);              // NET TP 5
void csm_vTp6ComCallback(INT s32Arg);              // NET TP 6
void csm_vTp7ComCallback(INT s32Arg);              // NET TP 7
void csm_vTp8ComCallback(INT s32Arg);              // NET TP 8
void csm_vTp9ComCallback(INT s32Arg);              // NET TP 9
void csm_vTp10ComCallback(INT s32Arg);             // NET TP 10
void csm_vTp11ComCallback(INT s32Arg);             // NET TP 11

/*******************************************************************************
 * function implementation (scope: file local = static)
 ******************************************************************************/
/*******************************************************************************
 * function    csm_vRxBrThread
 * \doxydocu
 * \brief      worker thread for Broadcast reception
 *
 * \param[in]  void* arg
 *             dgram pointer
 *
 * \return     void
 *
 * \access     CAN task level
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 15.04.13 CM-AI/PJ-CD43-Pistoor
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
void* csm_vRxBrThread(void* arg)
{
  char buffer[CSM_C_BUFFER_SIZE_BR_RX];
  memset(buffer, 0, CSM_C_BUFFER_SIZE_BR_RX);

  if(arg == NULL)
  {
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("csm_vRxBrThread: Couldn't start thread, argument is NULL"));
        #endif
      #endif
    #endif
    return NULL;
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("csm_vRxBrThread: Thread started"));
      #endif
    #endif
  #endif

  sk_dgram* pdgram = (sk_dgram*) arg;
  int rc = -1;

  while(1) /*lint !e716 yes intentionally */
  {
    if(rIpcDataBrSignalCom.fRxBufferUsed == FALSE)
    {
      rc = dgram_recv(pdgram, buffer, sizeof(buffer));
      if(rc > 0)
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_USR4(("IPC RX Event - csm_vRxBrThread: RX on CBR - DGRAM:%08X  Len:%04X  Data:%02x", pdgram, rc, ETG_LIST_LEN(rc), ETG_LIST_PTR_T8(buffer) ));
            #endif
          #endif
        #endif

        rIpcDataBrSignalCom.fRxBufferUsed = TRUE;
        CSM_vMemCopy(rIpcDataBrSignalCom.au8BufferRx, (void *) &buffer[0], (WORD)rc);
        rIpcDataBrSignalCom.wDataLength = (WORD)rc;
        CSM_vMemSet(buffer, 0, CSM_C_BUFFER_SIZE_BR_RX);
        // now use callback to pass data to upstream/downstream task
        csm_vBrSignalComCallback(INC_COM_INDICATION);
      }
      else
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("csm_vRxBrThread: Reception error"));
            #endif
          #endif
        #endif
      }
    }
    else
    {
      usleep(1000);
    }
  }
}

/*******************************************************************************
 * function    csm_vRxNetThread
 * \doxydocu
 * \brief      worker thread for NET control reception
 *
 * \param[in]  void* arg
 *             dgram pointer
 *
 * \return     void
 *
 * \access     CAN task level
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 15.04.13 CM-AI/PJ-CD43-Pistoor
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
void* csm_vRxNetThread(void* arg)
{
  char buffer[CSM_C_BUFFER_SIZE_BR_RX];
  memset(buffer, 0, CSM_C_BUFFER_SIZE_BR_RX);



  if(arg == NULL)
  {
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("csm_vRxNetThread: Couldn't start Thread, argument is NULL"));
        #endif
      #endif
    #endif
    return NULL;
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("csm_vRxNetThread: Thread started"));
      #endif
    #endif
  #endif
  sk_dgram* pdgram = (sk_dgram*) arg;
  int rc = -1;

  while(1) /*lint !e716 yes intentionally */
  {
    if(rIpcDataRemoteNet.fRxBufferUsed == FALSE)
    {
      rc = dgram_recv(pdgram, buffer, sizeof(buffer));
      if(rc > 0)
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_USR3(("IPC RX Event - csm_vRxNetThread: RX on NET - DGRAM:%08X  Len:%04X  Data:%02x", pdgram, rc, ETG_LIST_LEN(rc), ETG_LIST_PTR_T8(buffer) ));
            #endif
          #endif
        #endif

        rIpcDataRemoteNet.fRxBufferUsed = TRUE;
        CSM_vMemCopy(rIpcDataRemoteNet.au8BufferRx, (void *) &buffer[0], (WORD)rc);
        rIpcDataRemoteNet.wDataLength = (WORD)rc;
        CSM_vMemSet(buffer, 0, CSM_C_BUFFER_SIZE_REMOTE_RX);
        // now use callback to pass data to upstream/downstream task
        csm_vRemoteNetComCallback(INC_COM_INDICATION);
      }
      else
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("csm_vRxNetThread: Reception error"));
            #endif
          #endif
        #endif
      }
    }
    else
    {
      usleep( 1000);
    }
  }
}

/*******************************************************************************
 * function    csm_vRxNpThreadCanNp1
 * \doxydocu
 * \brief      worker thread for CAN NP1 reception
 *
 * \param[in]  void* arg
 *             dgram pointer
 *
 * \return     void
 *
 * \access     CAN task level
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 15.04.13 CM-AI/PJ-CD43-Pistoor
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
void* csm_vRxNpThreadCanNp1(void* arg)
{
  char buffer[CSM_C_BUFFER_SIZE_TP_RX];
  memset(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);

  if(arg == NULL)
  {
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("csm_vRxNpThreadCanNp1: Couldn't start Thread, argument is NULL"));
        #endif
      #endif
    #endif
    return NULL;
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("csm_vRxNpThreadCanNp1: Thread started"));
      #endif
    #endif
  #endif

  sk_dgram* pdgram = (sk_dgram*) arg;
  int rc = -1;

  while(1) /*lint !e716 yes intentionally */
  {
    if(arIpcDataTp[NET_NP_1_INDEX].fRxBufferUsed == FALSE)
    {
      rc = dgram_recv(pdgram, buffer, sizeof(buffer));
      if(rc > 0)
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_USR3(("IPC RX Event - csm_vRxNpThreadCanNp1: RX on NP1 - DGRAM:%08X  Len:%04X  Data:%02x", pdgram, rc, ETG_LIST_LEN(rc), ETG_LIST_PTR_T8(buffer) ));
            #endif
          #endif
        #endif

        arIpcDataTp[NET_NP_1_INDEX].fRxBufferUsed = TRUE;
        CSM_vMemCopy(arIpcDataTp[NET_NP_1_INDEX].au8BufferRx, (void *) &buffer[0], (WORD)rc);
        arIpcDataTp[NET_NP_1_INDEX].wDataLength = (WORD)rc;
        CSM_vMemSet(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);
        // now use callback to pass data to upstream/downstream task
        csm_vTp1ComCallback(INC_COM_INDICATION);
      }
      else
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("csm_vRxNpThreadCanNp1: Reception error"));
            #endif
          #endif
        #endif
      }
    }
    else
    {
      usleep(1000);
    }
  }
}

/*******************************************************************************
 * function    csm_vRxNpThreadCanNp2
 * \doxydocu
 * \brief      worker thread for CAN NP2 reception
 *
 * \param[in]  void* arg
 *             dgram pointer
 *
 * \return     void
 *
 * \access     CAN task level
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 15.04.13 CM-AI/PJ-CD43-Pistoor
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
void* csm_vRxNpThreadCanNp2(void* arg)
{
  char buffer[CSM_C_BUFFER_SIZE_TP_RX];
  memset(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);

  if(arg == NULL)
  {
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("csm_vRxNpThreadCanNp2: Couldn't start Thread, argument is NULL"));
        #endif
      #endif
    #endif
    return NULL;
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("csm_vRxNpThreadCanNp2: Thread started"));
      #endif
    #endif
  #endif

  sk_dgram* pdgram = (sk_dgram*) arg;
  int rc = -1;

  while(1) /*lint !e716 yes intentionally */
  {
    if(arIpcDataTp[NET_NP_2_INDEX].fRxBufferUsed == FALSE)
    {
      rc = dgram_recv(pdgram, buffer, sizeof(buffer));
      if(rc > 0)
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_USR3(("IPC RX Event - csm_vRxNpThreadCanNp2: RX on NP2 - DGRAM:%08X  Len:%04X  Data:%02x", pdgram, rc, ETG_LIST_LEN(rc), ETG_LIST_PTR_T8(buffer) ));
            #endif
          #endif
        #endif

        arIpcDataTp[NET_NP_2_INDEX].fRxBufferUsed = TRUE;
        CSM_vMemCopy(arIpcDataTp[NET_NP_2_INDEX].au8BufferRx, (void *) &buffer[0], (WORD)rc);
        arIpcDataTp[NET_NP_2_INDEX].wDataLength = (WORD)rc;
        CSM_vMemSet(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);
        // now use callback to pass data to upstream/downstream task
        csm_vTp2ComCallback(INC_COM_INDICATION);
      }
      else
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("csm_vRxNpThreadCanNp2: Reception error"));
            #endif
          #endif
        #endif
      }
    }
    else
    {
      usleep(1000);
    }
  }
}

/*******************************************************************************
 * function    csm_vRxNpThreadCanNp3
 * \doxydocu
 * \brief      worker thread for CAN NP 3 reception
 *
 * \param[in]  void* arg
 *             dgram pointer
 *
 * \return     void
 *
 * \access     CAN task level
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 15.04.13 CM-AI/PJ-CD43-Pistoor
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
void* csm_vRxNpThreadCanNp3(void* arg)
{
  char buffer[CSM_C_BUFFER_SIZE_TP_RX];
  memset(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);

  if(arg == NULL)
  {
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("csm_vRxNpThreadCanNp3: Couldn't start Thread, argument is NULL"));
        #endif
      #endif
    #endif
    return NULL;
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("csm_vRxNpThreadCanNp3: Thread started"));
      #endif
    #endif
  #endif

  sk_dgram* pdgram = (sk_dgram*) arg;
  int rc = -1;

  while(1) /*lint !e716 yes intentionally */
  {
    if(arIpcDataTp[NET_NP_3_INDEX].fRxBufferUsed == FALSE)
    {
      rc = dgram_recv(pdgram, buffer, sizeof(buffer));
      if(rc > 0)
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_USR3(("IPC RX Event - csm_vRxNpThreadCanNp3: RX on NP3 - DGRAM:%08X  Len:%04X  Data:%02x", pdgram, rc, ETG_LIST_LEN(rc), ETG_LIST_PTR_T8(buffer) ));
            #endif
          #endif
        #endif

        arIpcDataTp[NET_NP_3_INDEX].fRxBufferUsed = TRUE;
        CSM_vMemCopy(arIpcDataTp[NET_NP_3_INDEX].au8BufferRx, (void *) &buffer[0], (WORD)rc);
        arIpcDataTp[NET_NP_3_INDEX].wDataLength = (WORD)rc;
        CSM_vMemSet(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);
        csm_vTp3ComCallback(INC_COM_INDICATION);
      }
      else
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("csm_vRxNpThreadCanNp3: Reception error"));
            #endif
          #endif
        #endif
      }
    }
    else
    {
      usleep(1000);
    }
  }
}

/*******************************************************************************
 * function    csm_vRxNpThreadCanNp4
 * \doxydocu
 * \brief      worker thread for CAN NP 4 reception
 *
 * \param[in]  void* arg
 *             dgram pointer
 *
 * \return     void
 *
 * \access     CAN task level
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 15.04.13 CM-AI/PJ-CD43-Pistoor
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
void* csm_vRxNpThreadCanNp4(void* arg)
{
  char buffer[CSM_C_BUFFER_SIZE_TP_RX];
  memset(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);

  if(arg == NULL)
  {
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("csm_vRxNpThreadCanNp4: Couldn't start Thread, argument is NULL"));
        #endif
      #endif
    #endif
    return NULL;
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("csm_vRxNpThreadCanNp4: Thread started"));
      #endif
    #endif
  #endif

  sk_dgram* pdgram = (sk_dgram*) arg;
  int rc = -1;

  while(1) /*lint !e716 yes intentionally */
  {
    if(arIpcDataTp[NET_NP_4_INDEX].fRxBufferUsed == FALSE)
    {
      rc = dgram_recv(pdgram, buffer, sizeof(buffer));
      if(rc > 0)
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_USR3(("IPC RX Event - csm_vRxNpThreadCanNp4: RX on NP4 - DGRAM:%08X  Len:%04X  Data:%02x", pdgram, rc, ETG_LIST_LEN(rc), ETG_LIST_PTR_T8(buffer) ));
            #endif
          #endif
        #endif

        arIpcDataTp[NET_NP_4_INDEX].fRxBufferUsed = TRUE;
        CSM_vMemCopy(arIpcDataTp[NET_NP_4_INDEX].au8BufferRx, (void *) &buffer[0], (WORD)rc);
        arIpcDataTp[NET_NP_4_INDEX].wDataLength = (WORD)rc;
        CSM_vMemSet(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);
        csm_vTp4ComCallback(INC_COM_INDICATION);
      }
      else
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("csm_vRxNpThreadCanNp4: Reception error"));
            #endif
          #endif
        #endif
      }
    }
    else
    {
      usleep(1000);
    }
  }
}

/*******************************************************************************
 * function    csm_vRxNpThreadCanNp5
 * \doxydocu
 * \brief      worker thread for CAN NP 5 reception
 *
 * \param[in]  void* arg
 *             dgram pointer
 *
 * \return     void
 *
 * \access     CAN task level
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 15.04.13 CM-AI/PJ-CD43-Pistoor
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
void* csm_vRxNpThreadCanNp5(void* arg)
{
  char buffer[CSM_C_BUFFER_SIZE_TP_RX];
  memset(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);

  if(arg == NULL)
  {
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("csm_vRxNpThreadCanNp5: Couldn't start Thread, argument is NULL"));
        #endif
      #endif
    #endif
    return NULL;
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("csm_vRxNpThreadCanNp5: Thread started"));
      #endif
    #endif
  #endif

  sk_dgram* pdgram = (sk_dgram*) arg;
  int rc = -1;

  while(1) /*lint !e716 yes intentionally */
  {
    if(arIpcDataTp[NET_NP_5_INDEX].fRxBufferUsed == FALSE)
    {
      rc = dgram_recv(pdgram, buffer, sizeof(buffer));
      if(rc > 0)
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_USR3(("IPC RX Event - csm_vRxNpThreadCanNp5: RX on NP5 - DGRAM:%08X  Len:%04X  Data:%02x", pdgram, rc, ETG_LIST_LEN(rc), ETG_LIST_PTR_T8(buffer) ));
            #endif
          #endif
        #endif

        arIpcDataTp[NET_NP_5_INDEX].fRxBufferUsed = TRUE;
        CSM_vMemCopy(arIpcDataTp[NET_NP_5_INDEX].au8BufferRx, (void *) &buffer[0], (WORD)rc);
        arIpcDataTp[NET_NP_5_INDEX].wDataLength = (WORD)rc;
        CSM_vMemSet(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);
        csm_vTp5ComCallback(INC_COM_INDICATION);
      }
      else
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("csm_vRxNpThreadCanNp5: Reception error"));
            #endif
          #endif
        #endif
      }
    }
    else
    {
      usleep(1000);
    }
  }
}

/*******************************************************************************
 * function    csm_vRxNpThreadCanNp6
 * \doxydocu
 * \brief      worker thread for CAN NP 6 reception
 *
 * \param[in]  void* arg
 *             dgram pointer
 *
 * \return     void
 *
 * \access     CAN task level
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 15.04.13 CM-AI/PJ-CD43-Pistoor
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
void* csm_vRxNpThreadCanNp6(void* arg)
{
  char buffer[CSM_C_BUFFER_SIZE_TP_RX];
  memset(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);

  if(arg == NULL)
  {
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("csm_vRxNpThreadCanNp6: Couldn't start Thread, argument is NULL"));
        #endif
      #endif
    #endif
    return NULL;
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("csm_vRxNpThreadCanNp6: Thread started"));
      #endif
    #endif
  #endif

  sk_dgram* pdgram = (sk_dgram*) arg;
  int rc = -1;

  while(1) /*lint !e716 yes intentionally */
  {
    if(arIpcDataTp[NET_NP_6_INDEX].fRxBufferUsed == FALSE)
    {
      rc = dgram_recv(pdgram, buffer, sizeof(buffer));
      if(rc > 0)
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_USR3(("IPC RX Event - csm_vRxNpThreadCanNp6: RX on NP6 - DGRAM:%08X  Len:%04X  Data:%02x", pdgram, rc, ETG_LIST_LEN(rc), ETG_LIST_PTR_T8(buffer) ));
            #endif
          #endif
        #endif

        arIpcDataTp[NET_NP_6_INDEX].fRxBufferUsed = TRUE;
        CSM_vMemCopy(arIpcDataTp[NET_NP_6_INDEX].au8BufferRx, (void *) &buffer[0], (WORD)rc);
        arIpcDataTp[NET_NP_6_INDEX].wDataLength = (WORD)rc;
        CSM_vMemSet(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);
        csm_vTp6ComCallback(INC_COM_INDICATION);
      }
      else
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("csm_vRxNpThreadCanNp6: Reception error"));
            #endif
          #endif
        #endif
      }
    }
    else
    {
      usleep(1000);
    }
  }
}

/*******************************************************************************
 * function    csm_vRxNpThreadCanNp7
 * \doxydocu
 * \brief      worker thread for CAN NP 7 reception
 *
 * \param[in]  void* arg
 *             dgram pointer
 *
 * \return     void
 *
 * \access     CAN task level
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 15.04.13 CM-AI/PJ-CD43-Pistoor
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
void* csm_vRxNpThreadCanNp7(void* arg)
{
  char buffer[CSM_C_BUFFER_SIZE_TP_RX];
  memset(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);

  if(arg == NULL)
  {
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("csm_vRxNpThreadCanNp7: Couldn't start Thread, argument is NULL"));
        #endif
      #endif
    #endif
    return NULL;
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("csm_vRxNpThreadCanNp7: Thread started"));
      #endif
    #endif
  #endif

  sk_dgram* pdgram = (sk_dgram*) arg;
  int rc = -1;

  while(1) /*lint !e716 yes intentionally */
  {
    if(arIpcDataTp[NET_NP_7_INDEX].fRxBufferUsed == FALSE)
    {
      rc = dgram_recv(pdgram, buffer, sizeof(buffer));
      if(rc > 0)
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_USR3(("IPC RX Event - csm_vRxNpThreadCanNp7: RX on NP7 - DGRAM:%08X  Len:%04X  Data:%02x", pdgram, rc, ETG_LIST_LEN(rc), ETG_LIST_PTR_T8(buffer) ));
            #endif
          #endif
        #endif

        arIpcDataTp[NET_NP_7_INDEX].fRxBufferUsed = TRUE;
        CSM_vMemCopy(arIpcDataTp[NET_NP_7_INDEX].au8BufferRx, (void *) &buffer[0], (WORD)rc);
        arIpcDataTp[NET_NP_7_INDEX].wDataLength = (WORD)rc;
        CSM_vMemSet(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);
        csm_vTp7ComCallback(INC_COM_INDICATION);
      }
      else
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("csm_vRxNpThreadCanNp7: Reception error"));
            #endif
          #endif
        #endif
      }
    }
    else
    {
      usleep(1000);
    }
  }
}

/*******************************************************************************
 * function    csm_vRxNpThreadCanNp8
 * \doxydocu
 * \brief      worker thread for CAN NP 8 reception
 *
 * \param[in]  void* arg
 *             dgram pointer
 *
 * \return     void
 *
 * \access     CAN task level
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 15.04.13 CM-AI/PJ-CD43-Pistoor
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
void * csm_vRxNpThreadCanNp8(void * arg)
{
  char buffer[CSM_C_BUFFER_SIZE_TP_RX];
  memset(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);

  if(arg == NULL)
  {
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("csm_vRxNpThreadCanNp8: Couldn't start Thread, argument is NULL"));
        #endif
      #endif
    #endif
    return NULL;
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("csm_vRxNpThreadCanNp8: Thread started"));
      #endif
    #endif
  #endif

  sk_dgram* pdgram = (sk_dgram*) arg;
  int rc = -1;

  while(1) /*lint !e716 yes intentionally */
  {
    if(arIpcDataTp[NET_NP_8_INDEX].fRxBufferUsed == FALSE)
    {
      rc = dgram_recv(pdgram, buffer, sizeof(buffer));
      if(rc > 0)
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_USR3(("IPC RX Event - csm_vRxNpThreadCanNp8: RX on NP8 - DGRAM:%08X  Len:%04X  Data:%02x", pdgram, rc, ETG_LIST_LEN(rc), ETG_LIST_PTR_T8(buffer) ));
            #endif
          #endif
        #endif

        arIpcDataTp[NET_NP_8_INDEX].fRxBufferUsed = TRUE;
        CSM_vMemCopy(arIpcDataTp[NET_NP_8_INDEX].au8BufferRx, (void *) &buffer[0], (WORD)rc);
        arIpcDataTp[NET_NP_8_INDEX].wDataLength = (WORD)rc;
        CSM_vMemSet(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);
        csm_vTp8ComCallback(INC_COM_INDICATION);
      }
      else
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("csm_vRxNpThreadCanNp8: Reception error"));
            #endif
          #endif
        #endif
      }
    }
    else
    {
      usleep(1000);
    }
  }
}

/*******************************************************************************
 * function    csm_vRxNpThreadCanNp9
 * \doxydocu
 * \brief      worker thread for CAN NP 9 reception
 *
 * \param[in]  void* arg
 *             dgram pointer
 *
 * \return     void
 *
 * \access     CAN task level
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 03.05.2017  Borck
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
void * csm_vRxNpThreadCanNp9(void * arg)
{
  char buffer[CSM_C_BUFFER_SIZE_TP_RX];
  memset(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);

  if(arg == NULL)
  {
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("csm_vRxNpThreadCanNp9: Couldn't start Thread, argument is NULL"));
        #endif
      #endif
    #endif
    return NULL;
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("csm_vRxNpThreadCanNp9: Thread started"));
      #endif
    #endif
  #endif

  sk_dgram* pdgram = (sk_dgram*) arg;
  int rc = -1;

  while(1) /*lint !e716 yes intentionally */
  {
    if(arIpcDataTp[NET_NP_9_INDEX].fRxBufferUsed == FALSE)
    {
      rc = dgram_recv(pdgram, buffer, sizeof(buffer));
      if(rc > 0)
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_USR3(("IPC RX Event - csm_vRxNpThreadCanNp9: RX on NP9 - DGRAM:%08X  Len:%04X  Data:%02x", pdgram, rc, ETG_LIST_LEN(rc), ETG_LIST_PTR_T8(buffer) ));
            #endif
          #endif
        #endif

        arIpcDataTp[NET_NP_9_INDEX].fRxBufferUsed = TRUE;
        CSM_vMemCopy(arIpcDataTp[NET_NP_9_INDEX].au8BufferRx, (void *) &buffer[0], (WORD)rc);
        arIpcDataTp[NET_NP_9_INDEX].wDataLength = (WORD)rc;
        CSM_vMemSet(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);
        csm_vTp9ComCallback(INC_COM_INDICATION);
      }
      else
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("csm_vRxNpThreadCanNp9: Reception error"));
            #endif
          #endif
        #endif
      }
    }
    else
    {
      usleep(1000);
    }
  }
}

/*******************************************************************************
 * function    csm_vRxNpThreadCanNp10
 * \doxydocu
 * \brief      worker thread for CAN NP 10 reception
 *
 * \param[in]  void* arg
 *             dgram pointer
 *
 * \return     void
 *
 * \access     CAN task level
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 03.05.2017  Borck
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
void * csm_vRxNpThreadCanNp10(void * arg)
{
  char buffer[CSM_C_BUFFER_SIZE_TP_RX];
  memset(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);

  if(arg == NULL)
  {
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("csm_vRxNpThreadCanNp10: Couldn't start Thread, argument is NULL"));
        #endif
      #endif
    #endif
    return NULL;
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("csm_vRxNpThreadCanNp10: Thread started"));
      #endif
    #endif
  #endif

  sk_dgram* pdgram = (sk_dgram*) arg;
  int rc = -1;

  while(1) /*lint !e716 yes intentionally */
  {
    if(arIpcDataTp[NET_NP_10_INDEX].fRxBufferUsed == FALSE)
    {
      rc = dgram_recv(pdgram, buffer, sizeof(buffer));
      if(rc > 0)
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_USR3(("IPC RX Event - csm_vRxNpThreadCanNp10: RX on NP10 - DGRAM:%08X  Len:%04X  Data:%02x", pdgram, rc, ETG_LIST_LEN(rc), ETG_LIST_PTR_T8(buffer) ));
            #endif
          #endif
        #endif

        arIpcDataTp[NET_NP_10_INDEX].fRxBufferUsed = TRUE;
        CSM_vMemCopy(arIpcDataTp[NET_NP_10_INDEX].au8BufferRx, (void *) &buffer[0], (WORD)rc);
        arIpcDataTp[NET_NP_10_INDEX].wDataLength = (WORD)rc;
        CSM_vMemSet(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);
        csm_vTp10ComCallback(INC_COM_INDICATION);
      }
      else
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("csm_vRxNpThreadCanNp10: Reception error"));
            #endif
          #endif
        #endif
      }
    }
    else
    {
      usleep(1000);
    }
  }
}

/*******************************************************************************
 * function    csm_vRxNpThreadCanNp11
 * \doxydocu
 * \brief      worker thread for CAN NP 11 reception
 *
 * \param[in]  void* arg
 *             dgram pointer
 *
 * \return     void
 *
 * \access     CAN task level
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 03.05.2017  Borck
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
#if (CSM_C_PROXY_TP_CHANNELS > 10)
void * csm_vRxNpThreadCanNp11(void * arg)
{
  char buffer[CSM_C_BUFFER_SIZE_TP_RX];
  memset(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);

  if(arg == NULL)
  {
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("csm_vRxNpThreadCanNp11: Couldn't start Thread, argument is NULL"));
        #endif
      #endif
    #endif
    return NULL;
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("csm_vRxNpThreadCanNp11: Thread started"));
      #endif
    #endif
  #endif

  sk_dgram* pdgram = (sk_dgram*) arg;
  int rc = -1;

  while(1) /*lint !e716 yes intentionally */
  {
    if(arIpcDataTp[NET_NP_11_INDEX].fRxBufferUsed == FALSE)
    {
      rc = dgram_recv(pdgram, buffer, sizeof(buffer));
      if(rc > 0)
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_USR3(("IPC RX Event - csm_vRxNpThreadCanNp11: RX on NP11 - DGRAM:%08X  Len:%04X  Data:%02x", pdgram, rc, ETG_LIST_LEN(rc), ETG_LIST_PTR_T8(buffer) ));
            #endif
          #endif
        #endif

        arIpcDataTp[NET_NP_11_INDEX].fRxBufferUsed = TRUE;
        CSM_vMemCopy(arIpcDataTp[NET_NP_11_INDEX].au8BufferRx, (void *) &buffer[0], (WORD)rc);
        arIpcDataTp[NET_NP_11_INDEX].wDataLength = (WORD)rc;
        CSM_vMemSet(buffer, 0, CSM_C_BUFFER_SIZE_TP_RX);
        csm_vTp11ComCallback(INC_COM_INDICATION);
      }
      else
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("csm_vRxNpThreadCanNp11: Reception error"));
            #endif
          #endif
        #endif
      }
    }
    else
    {
      usleep(1000);
    }
  }
}
#endif

/*******************************************************************************
 * function    csm_vOpenIncSocket
 * \doxydocu
 * \brief      Open INC socket
 *
 * \param[in]  u16RemotePortNo
 *              remote port number
 *
 * \return     sk_dgram*
 *
 * \access     CAN task level
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 22.03.13 CM-AI/PJ-CD43-Pistoor
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
sk_dgram* csm_vOpenIncSocket(WORD u16RemotePortNo)
{
  int fd, ret;
  sk_dgram* dgram = NULL;

  struct hostent *local, *remote;
  struct sockaddr_in local_addr, remote_addr;

  local = gethostbyname("scc-local");
  local_addr.sin_family = AF_INET;
  memcpy((char *) &local_addr.sin_addr.s_addr, (char *) local->h_addr, (size_t)local->h_length);
  local_addr.sin_port = htons(u16RemotePortNo); /* from inc_ports.h */

  remote = gethostbyname("scc");
  remote_addr.sin_family = AF_INET;
  memcpy((char *) &remote_addr.sin_addr.s_addr, (char *) remote->h_addr, (size_t)remote->h_length);
  remote_addr.sin_port = htons(u16RemotePortNo); /* from inc_ports.h */

  {
    char sLocal[10];
    char sRemote[10];
    strncpy(sLocal,  (char*)inet_ntoa(local_addr.sin_addr),sizeof(sLocal));
    strncpy(sRemote, (char*)inet_ntoa(remote_addr.sin_addr),sizeof(sRemote));

    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR2(("csm_vOpenIncSocket: local  %d:%s ", ntohs(local_addr.sin_port), sLocal ));
        ETG_TRACE_USR2(("csm_vOpenIncSocket: remote %d:%s ", ntohs(remote_addr.sin_port), sRemote ));
        #endif
      #endif
    #endif
  }

  fd = socket(AF_BOSCH_INC_AUTOSAR, (int)SOCK_STREAM, 0);
  if (fd == -1)
  {
    int errsv = errno;
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("csm_vOpenIncSocket: INC socket creation failed: %d\n", errsv));
        #endif
      #endif
    #endif
  }
  else
  {
    dgram = dgram_init(fd, DGRAM_MAX, NULL);
    if (dgram == NULL)
    {
      #if (CSM_S_TRACE == CSM_C_F_ON)
        #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
          #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
          ETG_TRACE_ERR(("csm_vOpenIncSocket: INC socket dgram_init failed"));
          #endif
        #endif
      #endif
    }
    else
    {
	  ret = bind(fd, (const struct sockaddr *) &local_addr, (socklen_t)sizeof(local_addr));  //to fix compiler warnings 
      if (ret < 0)
      {
        int errsv = errno;
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("csm_vOpenIncSocket: INC socket bind failed: %d", errsv));
            #endif
          #endif
        #endif
      }
      else
      {
        ret = connect(fd,(const struct sockaddr *) &remote_addr, (socklen_t)sizeof(remote_addr)); //to fix compiler warnings
        if (ret < 0)
        {
          int errsv = errno;
          #if (CSM_S_TRACE == CSM_C_F_ON)
            #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
              #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
              ETG_TRACE_ERR(("csm_vOpenIncSocket: INC socket connect failed: %d", errsv));
              #endif
            #endif
          #endif
        }
      }
    }
  }
  return dgram;
}

/*******************************************************************************
 * function    csm_vRemoteNetComCallback
 * \doxydocu
 * \brief      Informs about communication status
 *
 * \param[in]  s32Arg
 *              callback type (confirmation or indication)
 *
 * \return     VOID
 *
 * \access     IPCA task (FgsVdCom)
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 02.08.06 CM-DI/ESA3-Haffner
 * Initial Revision.
 * \history_end
 ******************************************************************************/
void csm_vRemoteNetComCallback(INT s32Arg)
{
  BYTE bValidArg = FALSE;

  if (s32Arg == INC_COM_INDICATION)
  {
    /* Data is available in Receive Buffer */
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vRemoteNetComCallback: COM_IND - RX data from INC available"));
        #endif
      #endif
    #endif
    csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_REMOTE_NET_DATA_RX);
  }
  else if (s32Arg == INC_COM_CONFIRMATION)
  {
    /* Data transferred successfully (or not) */
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vRemoteNetComCallback: COM_CONF - TX data to INC completed"));
        #endif
      #endif
    #endif
  }
  else
  {
    CSM_vAssert(bValidArg == TRUE);
  }
}

/*******************************************************************************
 * function    csm_vBrSignalComCallback
 * \doxydocu
 * \brief      Informs about communication status
 *
 * \param[in]  s32Arg
 *              callback type (confirmation or indication)
 *
 * \return     VOID
 *
 * \access     IPCA task (FgsVdCom)
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 02.08.06 CM-DI/ESA3-Haffner
 * Initial Revision.
 * \history_end
 ******************************************************************************/
void csm_vBrSignalComCallback(INT s32Arg)
{
  BYTE bValidArg = FALSE;

  if (s32Arg == INC_COM_INDICATION )
  {
    /* Data is available in Receive Buffer */
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR4(("csm_vBrSignalComCallback: COM_IND - RX data from INC available - downstream trigger RX data handling now"));
        #endif
      #endif
    #endif
    csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_REMOTE_BR_DATA_RX);
  }
  else if (s32Arg == INC_COM_CONFIRMATION)
  {
    /* Data transferred successfully */
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR4(("csm_vBrSignalComCallback: COM_CONF - TX data to INC completed - downstream trigger more TX requests now"));
        #endif
      #endif
    #endif
    csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_BR_REQ_TX);
  }
  else
  {
    CSM_vAssert(bValidArg == TRUE);
  }
}

/*******************************************************************************
 * function    csm_vTpXxComCallback
 * \doxydocu
 * \brief      Informs about communication status
 *
 * \param[in]  s32Arg
 *              callback type (confirmation or indication)
 *
 * \return     VOID
 *
 * \access     IPCA task (FgsVdCom)
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 13.10.06 CM-DI/ESA3-Haffner
 * Initial Revision.
 * \history_end
 ******************************************************************************/
void csm_vTp1ComCallback(INT s32Arg)
{
  BYTE bValidArg = FALSE;

  if (s32Arg == INC_COM_INDICATION)
  {
    // Data is available in Receive Buffer
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp1ComCallback: COM_IND - RX data from INC available"));
        #endif
      #endif
    #endif
    arIpcDataTp[NET_NP_1_INDEX].fDataAvailable = TRUE;
    csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX);
  }
  else if (s32Arg == INC_COM_CONFIRMATION)
  {
    // Data transferred successfully by INC (at least INC is pretending so)
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp1ComCallback: COM_CONF - TX data to INC completed"));
        #endif
      #endif
    #endif

    // clear the INC related confirmation flag
    arIpcDataTp[NET_NP_1_INDEX].fWaitForIncConf = FALSE;

    // retrigger downstream task, if tx data is pending
    if (arIpcDataTp[NET_NP_1_INDEX].fCommTxReq)
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ);
    }

    if ((arIpcDataTp[NET_NP_1_INDEX].fDataTxReq_C) || (arIpcDataTp[NET_NP_1_INDEX].fDataTxReq_D))
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ);
    }
  }
  else
  {
    CSM_vAssert(bValidArg == TRUE);
  }
}
//**************************************************************************************************
void csm_vTp2ComCallback(INT s32Arg)
{
  BYTE bValidArg = FALSE;

  if (s32Arg == INC_COM_INDICATION)
  {
    // Data is available in Receive Buffer
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp2ComCallback: COM_IND - RX data from INC available"));
        #endif
      #endif
    #endif
    arIpcDataTp[NET_NP_2_INDEX].fDataAvailable = TRUE;
    csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX);
  }
  else if (s32Arg == INC_COM_CONFIRMATION)
  {
    // Data transferred successfully by INC (at least INC is pretending so)
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp2ComCallback: COM_CONF - TX data to INC completed"));
        #endif
      #endif
    #endif

    // clear the INC related confirmation flag
    arIpcDataTp[NET_NP_2_INDEX].fWaitForIncConf = FALSE;

    // retrigger downstream task, if tx data is pending
    if (arIpcDataTp[NET_NP_2_INDEX].fCommTxReq)
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ);
    }

    if ((arIpcDataTp[NET_NP_2_INDEX].fDataTxReq_C) || (arIpcDataTp[NET_NP_2_INDEX].fDataTxReq_D))
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ);
    }
  }
  else
  {
    CSM_vAssert(bValidArg == TRUE);
  }
}
//**************************************************************************************************
void csm_vTp3ComCallback(INT s32Arg)
{
  BYTE bValidArg = FALSE;

  if (s32Arg == INC_COM_INDICATION)
  {
    // Data is available in Receive Buffer
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp3ComCallback: COM_IND - RX data from INC available"));
        #endif
      #endif
    #endif
    arIpcDataTp[NET_NP_3_INDEX].fDataAvailable = TRUE;
    csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX);
  }
  else if (s32Arg == INC_COM_CONFIRMATION)
  {
    // Data transferred successfully by INC (at least INC is pretending so)
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp3ComCallback: COM_CONF - TX data to INC completed"));
        #endif
      #endif
    #endif

    // retrigger downstream task, if tx data is pending
    arIpcDataTp[NET_NP_3_INDEX].fWaitForIncConf = FALSE;

    // retrigger downstream task, if tx data is pending
    if (arIpcDataTp[NET_NP_3_INDEX].fCommTxReq)
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ);
    }

    if ((arIpcDataTp[NET_NP_3_INDEX].fDataTxReq_C) || (arIpcDataTp[NET_NP_3_INDEX].fDataTxReq_D))
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ);
    }
  }
  else
  {
    CSM_vAssert(bValidArg == TRUE);
  }
}
//**************************************************************************************************
void csm_vTp4ComCallback(INT s32Arg)
{
  BYTE bValidArg = FALSE;

  if (s32Arg == INC_COM_INDICATION)
  {
    // Data is available in Receive Buffer
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp4ComCallback: COM_IND - RX data from INC available"));
        #endif
      #endif
    #endif
    arIpcDataTp[NET_NP_4_INDEX].fDataAvailable = TRUE;
    csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX);
  }
  else if (s32Arg == INC_COM_CONFIRMATION)
  {
    // Data transferred successfully by INC (at least INC is pretending so)
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp4ComCallback: COM_CONF - TX data to INC completed"));
        #endif
      #endif
    #endif

    // retrigger downstream task, if tx data is pending
    arIpcDataTp[NET_NP_4_INDEX].fWaitForIncConf = FALSE;

    // retrigger downstream task, if tx data is pending
    if (arIpcDataTp[NET_NP_4_INDEX].fCommTxReq)
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ);
    }

    if ((arIpcDataTp[NET_NP_4_INDEX].fDataTxReq_C) || (arIpcDataTp[NET_NP_4_INDEX].fDataTxReq_D))
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ);
    }
  }
  else
  {
    CSM_vAssert(bValidArg == TRUE);
  }
}
//**************************************************************************************************
void csm_vTp5ComCallback(INT s32Arg)
{
  BYTE bValidArg = FALSE;

  if (s32Arg == INC_COM_INDICATION)
  {
    // Data is available in Receive Buffer
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp5ComCallback: COM_IND - RX data from INC available"));
        #endif
      #endif
    #endif
    arIpcDataTp[NET_NP_5_INDEX].fDataAvailable = TRUE;
    csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX);
  }
  else if (s32Arg == INC_COM_CONFIRMATION)
  {
    // Data transferred successfully by INC (at least INC is pretending so)
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp5ComCallback: COM_CONF - TX data to INC completed"));
        #endif
      #endif
    #endif

    // retrigger downstream task, if tx data is pending
    arIpcDataTp[NET_NP_5_INDEX].fWaitForIncConf = FALSE;

    // retrigger downstream task, if tx data is pending
    if (arIpcDataTp[NET_NP_5_INDEX].fCommTxReq)
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ);
    }

    if ((arIpcDataTp[NET_NP_5_INDEX].fDataTxReq_C) || (arIpcDataTp[NET_NP_5_INDEX].fDataTxReq_D))
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ);
    }
  }
  else
  {
    CSM_vAssert(bValidArg == TRUE);
  }
}
//**************************************************************************************************
void csm_vTp6ComCallback(INT s32Arg)
{
  BYTE bValidArg = FALSE;

  if (s32Arg == INC_COM_INDICATION)
  {
    // Data is available in Receive Buffer
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp6ComCallback: COM_IND - RX data from INC available"));
        #endif
      #endif
    #endif
    arIpcDataTp[NET_NP_6_INDEX].fDataAvailable = TRUE;
    csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX);
  }
  else if (s32Arg == INC_COM_CONFIRMATION)
  {
    // Data transferred successfully by INC (at least INC is pretending so)
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp6ComCallback: COM_CONF - TX data to INC completed"));
        #endif
      #endif
    #endif

    // retrigger downstream task, if tx data is pending
    arIpcDataTp[NET_NP_6_INDEX].fWaitForIncConf = FALSE;

    // retrigger downstream task, if tx data is pending
    if (arIpcDataTp[NET_NP_6_INDEX].fCommTxReq)
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ);
    }

    if ((arIpcDataTp[NET_NP_6_INDEX].fDataTxReq_C) || (arIpcDataTp[NET_NP_6_INDEX].fDataTxReq_D))
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ);
    }
  }
  else
  {
    CSM_vAssert(bValidArg == TRUE);
  }
}
//**************************************************************************************************
void csm_vTp7ComCallback(INT s32Arg)
{
  BYTE bValidArg = FALSE;

  if (s32Arg == INC_COM_INDICATION)
  {
    // Data is available in Receive Buffer
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp7ComCallback: COM_IND - RX data from INC available"));
        #endif
      #endif
    #endif
    arIpcDataTp[NET_NP_7_INDEX].fDataAvailable = TRUE;
    csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX);
  }
  else if (s32Arg == INC_COM_CONFIRMATION)
  {
    // Data transferred successfully by INC (at least INC is pretending so)
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp7ComCallback: COM_CONF - TX data to INC completed"));
        #endif
      #endif
    #endif

    // retrigger downstream task, if tx data is pending
    arIpcDataTp[NET_NP_7_INDEX].fWaitForIncConf = FALSE;

    // retrigger downstream task, if tx data is pending
    if (arIpcDataTp[NET_NP_7_INDEX].fCommTxReq)
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ);
    }

    if ((arIpcDataTp[NET_NP_7_INDEX].fDataTxReq_C) || (arIpcDataTp[NET_NP_7_INDEX].fDataTxReq_D))
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ);
    }
  }
  else
  {
    CSM_vAssert(bValidArg == TRUE);
  }
}
//**************************************************************************************************
void csm_vTp8ComCallback(INT s32Arg)
{
  BYTE bValidArg = FALSE;

  if (s32Arg == INC_COM_INDICATION)
  {
    // Data is available in Receive Buffer
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp8ComCallback: COM_IND - RX data from INC available"));
        #endif
      #endif
    #endif
    arIpcDataTp[NET_NP_8_INDEX].fDataAvailable = TRUE;
    csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX);
  }
  else if (s32Arg == INC_COM_CONFIRMATION)
  {
    // Data transferred successfully by INC (at least INC is pretending so)
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp8ComCallback: COM_CONF - TX data to INC completed"));
        #endif
      #endif
    #endif

    // retrigger downstream task, if tx data is pending
    arIpcDataTp[NET_NP_8_INDEX].fWaitForIncConf = FALSE;

    // retrigger downstream task, if tx data is pending
    if (arIpcDataTp[NET_NP_8_INDEX].fCommTxReq)
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ);
    }

    if ((arIpcDataTp[NET_NP_8_INDEX].fDataTxReq_C) || (arIpcDataTp[NET_NP_8_INDEX].fDataTxReq_D))
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ);
    }
  }
  else
  {
    CSM_vAssert(bValidArg == TRUE);
  }
}
// ***********************************************************************************************
void csm_vTp9ComCallback(INT s32Arg)
{
  BYTE bValidArg = FALSE;

  if (s32Arg == INC_COM_INDICATION)
  {
    // Data is available in Receive Buffer
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp9ComCallback: COM_IND - RX data from INC available"));
        #endif
      #endif
    #endif
    arIpcDataTp[NET_NP_9_INDEX].fDataAvailable = TRUE;
    csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX);
  }
  else if (s32Arg == INC_COM_CONFIRMATION)
  {
    // Data transferred successfully by INC (at least INC is pretending so)
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp9ComCallback: COM_CONF - TX data to INC completed"));
        #endif
      #endif
    #endif

    // retrigger downstream task, if tx data is pending
    arIpcDataTp[NET_NP_9_INDEX].fWaitForIncConf = FALSE;

    // retrigger downstream task, if tx data is pending
    if (arIpcDataTp[NET_NP_9_INDEX].fCommTxReq)
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ);
    }

    if ((arIpcDataTp[NET_NP_9_INDEX].fDataTxReq_C) || (arIpcDataTp[NET_NP_9_INDEX].fDataTxReq_D))
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ);
    }
  }
  else
  {
    CSM_vAssert(bValidArg == TRUE);
  }
}
// ***********************************************************************************************
void csm_vTp10ComCallback(INT s32Arg)
{
  BYTE bValidArg = FALSE;

  if (s32Arg == INC_COM_INDICATION)
  {
    // Data is available in Receive Buffer
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp10ComCallback: COM_IND - RX data from INC available"));
        #endif
      #endif
    #endif
    arIpcDataTp[NET_NP_10_INDEX].fDataAvailable = TRUE;
    csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX);
  }
  else if (s32Arg == INC_COM_CONFIRMATION)
  {
    // Data transferred successfully by INC (at least INC is pretending so)
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp10ComCallback: COM_CONF - TX data to INC completed"));
        #endif
      #endif
    #endif

    // retrigger downstream task, if tx data is pending
    arIpcDataTp[NET_NP_10_INDEX].fWaitForIncConf = FALSE;

    // retrigger downstream task, if tx data is pending
    if (arIpcDataTp[NET_NP_10_INDEX].fCommTxReq)
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ);
    }

    if ((arIpcDataTp[NET_NP_10_INDEX].fDataTxReq_C) || (arIpcDataTp[NET_NP_10_INDEX].fDataTxReq_D))
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ);
    }
  }
  else
  {
    CSM_vAssert(bValidArg == TRUE);
  }
}
// ***********************************************************************************************
#if (CSM_C_PROXY_TP_CHANNELS > 10)
void csm_vTp11ComCallback(INT s32Arg)
{
  BYTE bValidArg = FALSE;

  if (s32Arg == INC_COM_INDICATION)
  {
    // Data is available in Receive Buffer
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp11ComCallback: COM_IND - RX data from INC available"));
        #endif
      #endif
    #endif
    arIpcDataTp[NET_NP_11_INDEX].fDataAvailable = TRUE;
    csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX);
  }
  else if (s32Arg == INC_COM_CONFIRMATION)
  {
    // Data transferred successfully by INC (at least INC is pretending so)
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR3(("csm_vTp11ComCallback: COM_CONF - TX data to INC completed"));
        #endif
      #endif
    #endif

    // retrigger downstream task, if tx data is pending
    arIpcDataTp[NET_NP_11_INDEX].fWaitForIncConf = FALSE;

    // retrigger downstream task, if tx data is pending
    if (arIpcDataTp[NET_NP_11_INDEX].fCommTxReq)
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ);
    }

    if ((arIpcDataTp[NET_NP_11_INDEX].fDataTxReq_C) || (arIpcDataTp[NET_NP_11_INDEX].fDataTxReq_D))
    {
      csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ);
    }
  }
  else
  {
    CSM_vAssert(bValidArg == TRUE);
  }
}
#endif

/*******************************************************************************
 * function implementation (scope: CAN stack and operating system)
 *******************************************************************************/

/*******************************************************************************
 * function    CSM_lIpcInitAll
 * \doxydocu
 * \brief      Opens and initializes all IPC channels for this project
 *
 * \param      VOID
 *
 * \return     LONG
 *
 * \access     CAN task
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 02.08.06 CM-DI/ESA3-Haffner
 * Initial Revision.
 * \history_end
 ******************************************************************************/
LONG CSM_lIpcInitAll(void)
{
  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR1(("CSM_lIpcInitAll: called"));
      #endif
    #endif
  #endif

  WORD wCount;
  BYTE bLoop;

  /* init all data before opening the IPC channels */
  /* init remote net stuff */
  rIpcDataRemoteNet.tyIpcHandle = NET_CTRL_PORT;
  rIpcDataRemoteNet.fRxBufferUsed = FALSE;
  rIpcDataRemoteNet.u8CompStatusReq = CSM_C_REMOTE_NET_CTRL_COMP_STATUS_INACTIVE;
  rIpcDataRemoteNet.u8CompStatusAct = CSM_C_REMOTE_NET_CTRL_COMP_STATUS_INACTIVE;

  for(bLoop=0; bLoop<CSM_C_MAX_CAN_BUS ; bLoop++)
  {
    rIpcDataRemoteNet.au16BusError[ bLoop] = 0;
  }

  for(bLoop=0; bLoop<CSM_LCTR_C_MAX_USER ; bLoop++)
  {
    rIpcDataRemoteNet.afCommTxReq[bLoop] = FALSE;
    rIpcDataRemoteNet.afWaitForCommConf[bLoop] = FALSE;
    rIpcDataRemoteNet.au8CommStatusReq[ bLoop] = CSM_C_DISCONNECT;
  }

  /* init broadcast stuff */
  rIpcDataBrSignalCom.tyIpcHandle = NET_BROADCAST_PORT;
  rIpcDataBrSignalCom.fRxBufferUsed = FALSE;

  for(bLoop=0; bLoop<CSM_CBR_MAX_USER ; bLoop++)
  {
    rIpcDataBrSignalCom.afWaitForCommConf[ bLoop] = FALSE;
    rIpcDataBrSignalCom.afCommTxReq[ bLoop] = FALSE;
    rIpcDataBrSignalCom.au8CommStatusReq[ bLoop] = CSM_C_DISCONNECT;
    rIpcDataBrSignalCom.au8CommStatusAct[ bLoop] = CSM_C_DISCONNECT;
  }

  for (wCount = 0; wCount < CBR_TX_MAX_NUMBER; wCount++)
  {
    rIpcDataBrSignalCom.afTelTxReq[ wCount] = FALSE;
  }

  /* init TP stuff */
  for (wCount = 0; wCount < CSM_C_PROXY_TP_CHANNELS; wCount++)
  {
    arIpcDataTp[wCount].tyIpcHandle       = coarIpcCfgTpIncHandle[wCount];
    arIpcDataTp[wCount].fRxBufferUsed     = FALSE;
    arIpcDataTp[wCount].fWaitForIncConf   = FALSE;                               // init value is 0
    arIpcDataTp[wCount].fWaitForCommConf  = FALSE;                               // init value is 0
    arIpcDataTp[wCount].fWaitForDataConf_C  = FALSE;                             // init value is 0
    arIpcDataTp[wCount].fWaitForDataConf_D  = FALSE;                             // init value is 0
    arIpcDataTp[wCount].fDataAvailable    = FALSE;
    arIpcDataTp[wCount].fCommTxReq        = FALSE;
    arIpcDataTp[wCount].fDataTxReq_C      = FALSE;
    arIpcDataTp[wCount].fDataTxReq_D      = FALSE;
    arIpcDataTp[wCount].u8CommStatusReq   = CSM_C_DISCONNECT;
    arIpcDataTp[wCount].u8CommStatusAct   = CSM_C_DISCONNECT;
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR1(("CSM_lIpcInitAll: now openening Inc Sockets"));
      #endif
    #endif
  #endif

  pthread_t tidBr;
  pthread_t tidNet;
  pthread_t tidNp1;
  pthread_t tidNp2;
  pthread_t tidNp3;
  pthread_t tidNp4;
  pthread_t tidNp5;
  pthread_t tidNp6;
  pthread_t tidNp7;
  pthread_t tidNp8;
  pthread_t tidNp9;
  pthread_t tidNp10;
  pthread_t tidNp11;

  csm_stack_pdgram_can_np1 = NULL;
  csm_stack_pdgram_can_np2 = NULL;
  csm_stack_pdgram_can_np3 = NULL;
  csm_stack_pdgram_can_np4 = NULL;
  csm_stack_pdgram_can_np5 = NULL;
  csm_stack_pdgram_can_np6 = NULL;
  csm_stack_pdgram_can_np7 = NULL;
  csm_stack_pdgram_can_np8 = NULL;
  csm_stack_pdgram_can_np9 = NULL;
  csm_stack_pdgram_can_np10 = NULL;
  csm_stack_pdgram_can_np11 = NULL;


  // open sockets for NET, BR and create RX threads
  csm_stack_pdgram_net = csm_vOpenIncSocket(NET_CTRL_PORT);           //0xc70e, NET Control
  if ( -1 == pthread_create(&tidNet, NULL, csm_vRxNetThread, (void*)csm_stack_pdgram_net ))
  {
    int errsv = errno;
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("CSM_lIpcInitAll: Failed to create the Rx NET thread: %d", errsv));
        #endif
      #endif
    #endif
  }
  csm_stack_pdgram_br = csm_vOpenIncSocket(NET_BROADCAST_PORT);       //0xc70f, Broadcast
  if ( -1 == pthread_create(&tidBr, NULL, csm_vRxBrThread, (void*)csm_stack_pdgram_br ))
  {
    int errsv = errno;
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("CSM_lIpcInitAll: Failed to create the Rx Broadcast thread: %d", errsv));
        #endif
      #endif
    #endif
  }

  // open sockets for NPs (TPs) and create threads
  csm_stack_pdgram_can_np1 = csm_vOpenIncSocket(NET_TP1_PORT);       //0xc711, CAN NP 1 = MPDT TCU
  if ( -1 == pthread_create(&tidNp1, NULL, csm_vRxNpThreadCanNp1, (void*)csm_stack_pdgram_can_np1 ))
  {
    int errsv = errno;
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("CSM_lIpcInitAll: Failed to create the Rx Np1 Transport protocol thread: %d", errsv));
        #endif
      #endif
    #endif
  }
  csm_stack_pdgram_can_np2 = csm_vOpenIncSocket(NET_TP2_PORT);       //0xc712, CAN NP2 = MPDT BOSEA
  if ( -1 == pthread_create(&tidNp2, NULL, csm_vRxNpThreadCanNp2, (void*)csm_stack_pdgram_can_np2 ))
  {
    int errsv = errno;
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("CSM_lIpcInitAll: Failed to create the Rx Np2 Transport protocol thread: %d", errsv));
        #endif
      #endif
    #endif
  }
  csm_stack_pdgram_can_np3 = csm_vOpenIncSocket(NET_TP3_PORT);       //0xc713, CAN NP3 = MPDT BOSE
  if ( -1 == pthread_create(&tidNp3, NULL, csm_vRxNpThreadCanNp3, (void*)csm_stack_pdgram_can_np3 ))
  {
    int errsv = errno;
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("CSM_lIpcInitAll: Failed to create the Rx Np3 Transport protocol thread: %d", errsv));
        #endif
      #endif
    #endif
  }
  csm_stack_pdgram_can_np4 = csm_vOpenIncSocket(NET_TP4_PORT);  //0xc71C, CAN NP4 = MPDT NAV
  if ( -1 == pthread_create(&tidNp4, NULL, csm_vRxNpThreadCanNp4, (void*)csm_stack_pdgram_can_np4 ))
  {
    int errsv = errno;
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("CSM_lIpcInitAll: Failed to create the Rx Np4 Transport protocol thread: %d", errsv));
        #endif
      #endif
    #endif
  }
  csm_stack_pdgram_can_np5 = csm_vOpenIncSocket(NET_TP5_PORT);       //0xc71D, CAN NP5 = MPDT AUD
  if ( -1 == pthread_create(&tidNp5, NULL, csm_vRxNpThreadCanNp5, (void*)csm_stack_pdgram_can_np5 ))
  {
    int errsv = errno;
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("CSM_lIpcInitAll: Failed to create the Rx Np5 Transport protocol thread: %d", errsv));
        #endif
      #endif
    #endif
  }
  csm_stack_pdgram_can_np6 = csm_vOpenIncSocket(NET_TP6_PORT);       //0xc71E, CAN NP6 = MPDT NAV2/D2SU
  if ( -1 == pthread_create(&tidNp6, NULL, csm_vRxNpThreadCanNp6, (void*)csm_stack_pdgram_can_np6 ))
  {
    int errsv = errno;
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("CSM_lIpcInitAll: Failed to create the Rx Np6 Transport protocol thread: %d", errsv));
        #endif
      #endif
    #endif
  }
  csm_stack_pdgram_can_np7 = csm_vOpenIncSocket(NET_TP7_PORT);       //0xc71F, CAN NP7 = MPDT CD/AVM3
  if ( -1 == pthread_create(&tidNp7, NULL, csm_vRxNpThreadCanNp7, (void*)csm_stack_pdgram_can_np7 ))
  {
    int errsv = errno;
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("CSM_lIpcInitAll: Failed to create the Rx Np7 Transport protocol thread: %d", errsv));
        #endif
      #endif
    #endif
  }

  // assign handle for np channel 8 which has access index 7
  // should be 0xc720, CAN NP8 -> NET_TP10
  csm_stack_pdgram_can_np8 = csm_vOpenIncSocket((WORD)arIpcDataTp[NET_NP_8_INDEX].tyIpcHandle);
  arIpcCfgTpSocketHandles[NET_NP_8_INDEX] = csm_stack_pdgram_can_np8;
  if ( -1 == pthread_create(&tidNp8, NULL, csm_vRxNpThreadCanNp8, (void*)csm_stack_pdgram_can_np8 ))
  {
    int errsv = errno;
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("CSM_lIpcInitAll: Failed to create the Rx Np8 Transport protocol thread: %d", errsv));
        #endif
      #endif
    #endif
  }
  // assign handle for np channel 9 which has access index 8
  // should be 0xc718, CAN NP9 -> NET_TP8
  #if (CSM_C_PROXY_TP_CHANNELS > 8)
  csm_stack_pdgram_can_np9 = csm_vOpenIncSocket((WORD)arIpcDataTp[NET_NP_9_INDEX].tyIpcHandle);
  arIpcCfgTpSocketHandles[NET_NP_9_INDEX] = csm_stack_pdgram_can_np9;
  if ( -1 == pthread_create(&tidNp9, NULL, csm_vRxNpThreadCanNp9, (void*)csm_stack_pdgram_can_np9 ))
  {
    int errsv = errno;
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("CSM_lIpcInitAll: Failed to create the Rx Np9 Transport protocol thread: %d", errsv));
        #endif
      #endif
    #endif
  }
  #endif
  // assign handle for np channel 10 which has access index 9
  // should be 0xc719, CAN NP9 -> NET_TP9
  #if (CSM_C_PROXY_TP_CHANNELS > 9)
  csm_stack_pdgram_can_np10 = csm_vOpenIncSocket((WORD)arIpcDataTp[NET_NP_10_INDEX].tyIpcHandle);
  arIpcCfgTpSocketHandles[NET_NP_10_INDEX] = csm_stack_pdgram_can_np10;
  if ( -1 == pthread_create(&tidNp10, NULL, csm_vRxNpThreadCanNp10, (void*)csm_stack_pdgram_can_np10 ))
  {
    int errsv = errno;
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("CSM_lIpcInitAll: Failed to create the Rx Np10 Transport protocol thread: %d", errsv));
        #endif
      #endif
    #endif
  }
  #endif
  // assign handle for np channel 11 which has access index 10
  // should be 0xc721, CAN NP10 -> NET_TP11
  #if (CSM_C_PROXY_TP_CHANNELS > 10)
  csm_stack_pdgram_can_np11 = csm_vOpenIncSocket((WORD)arIpcDataTp[NET_NP_11_INDEX].tyIpcHandle);
  arIpcCfgTpSocketHandles[NET_NP_11_INDEX] = csm_stack_pdgram_can_np11;
  if ( -1 == pthread_create(&tidNp11, NULL, csm_vRxNpThreadCanNp11, (void*)csm_stack_pdgram_can_np11 ))
  {
    int errsv = errno;
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("CSM_lIpcInitAll: Failed to create the Rx Np11 Transport protocol thread: %d", errsv));
        #endif
      #endif
    #endif
  }
  #endif

  return CSM_C_NO_ERROR;
}

/*******************************************************************************
 * function    CSM_lIpcExitAll
 * \doxydocu
 * \brief      Could Close all IPC channels for this project
 *
 * \param      VOID
 *
 * \return     LONG
 *
 * \access     CAN task
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 30.04.13 CM-AI/PJ-CD-43-Pistoor
 * Initial Revision.
 * \history_end
 ******************************************************************************/
LONG CSM_lIpcExitAll(void)
{
  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR1(("CSM_lIpcExitAll: called"));
      #endif
    #endif
  #endif
  return CSM_C_NO_ERROR;
}

/*******************************************************************************
 * function    CSM_lIpcDataGet
 * \doxydocu
 * \brief      Gets data received by INC
 *
 * \param      VtIpcHdl tyIpcHandle     Handle
 *             BYTE* pu8DataRx          pointer to data
 *             DWORD u32MaxBufLengthRx  buffer length
 *             DWORD* pu32LengthRx      actual data length
 *
 * \return     LONG
 *
 * \access     CAN task
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 30.04.13 CM-AI/PJ-CD-43-Pistoor
 * Initial Revision.
 * \history_end
 ******************************************************************************/
LONG CSM_lIpcDataGet(tIpcHdl tyIpcHandle, BYTE* pu8DataRx, DWORD u32MaxBufLengthRx, DWORD* pu32LengthRx)
{
  LONG s32Ret = CSM_C_NO_ERROR;
  BYTE bAccessIndex = 0xFF;         // preset as INVALID

  switch(tyIpcHandle)
  {
    case NET_BROADCAST_PORT:
      if(u32MaxBufLengthRx >= CSM_C_BUFFER_SIZE_BR_RX )
      {
        CSM_vMemCopy( (void *) pu8DataRx, rIpcDataBrSignalCom.au8BufferRx,  CSM_C_BUFFER_SIZE_BR_RX);
        *pu32LengthRx = rIpcDataBrSignalCom.wDataLength;
      }
      else
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("CSM_lIpcDataGet: RX buffer for NET_BROADCAST_PORT is to small"));
            #endif
          #endif
        #endif
        s32Ret = CSM_STACK_M_MAKE_ERROR( CSM_C_ERR_WARNING, CSM_E_DATA_LENGTH_EXCEEDED);
      }
      break;

    case NET_CTRL_PORT:
      if(u32MaxBufLengthRx >= CSM_C_BUFFER_SIZE_REMOTE_RX )
      {
        CSM_vMemCopy( (void *) pu8DataRx, rIpcDataRemoteNet.au8BufferRx,  CSM_C_BUFFER_SIZE_REMOTE_RX);
        *pu32LengthRx = rIpcDataRemoteNet.wDataLength;
      }
      else
      {
        #if (CSM_S_TRACE == CSM_C_F_ON)
          #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
            #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
            ETG_TRACE_ERR(("CSM_lIpcDataGet: RX buffer for NET_CTRL_PORT is to small"));
            #endif
          #endif
        #endif
        s32Ret = CSM_STACK_M_MAKE_ERROR( CSM_C_ERR_WARNING, CSM_E_DATA_LENGTH_EXCEEDED);
      }
      break;

    case NET_TP0_PORT:  // CAN RAW
      break;

    case NET_TP1_PORT:  // CAN MPDT
      bAccessIndex = NET_NP_1_INDEX;
      break;

    case NET_TP2_PORT:  // CAN MPDT
      bAccessIndex = NET_NP_2_INDEX;
      break;

    case NET_TP3_PORT:  // CAN MPDT
      bAccessIndex = NET_NP_3_INDEX;
      break;

    case NET_TP4_PORT:  // CAN MPDT
      bAccessIndex = NET_NP_4_INDEX;
      break;

    case NET_TP5_PORT:  // CAN MPDT
      bAccessIndex = NET_NP_5_INDEX;
      break;

    case NET_TP6_PORT:  // CAN MPDT
      bAccessIndex = NET_NP_6_INDEX;
      break;

    case NET_TP7_PORT:  // CAN MPDT
      bAccessIndex = NET_NP_7_INDEX;
      break;

    case NET_TP8_PORT:
    case NET_TP9_PORT:
    case NET_TP10_PORT:
    case NET_TP11_PORT:
      for (BYTE i = 0; i < CSM_C_PROXY_TP_CHANNELS; i++)
      {
        if (coarIpcCfgTpIncHandle[i] == tyIpcHandle)
        {
          bAccessIndex = i;
          break;
        }
      }
      break;

    default:
      #if (CSM_S_TRACE == CSM_C_F_ON)
        #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
          #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
          ETG_TRACE_ERR(("CSM_lIpcDataGet: ERROR reading from invalid INC socket, tyIpcHandle: 0x%x", tyIpcHandle));
          #endif
        #endif
      #endif
      break;
  }

  if (bAccessIndex != 0xFF)
  {
    // common handling for TP channels
    if(u32MaxBufLengthRx >= CSM_C_BUFFER_SIZE_TP_RX )
    {
      // ETG_TRACE_USR3(("CSM_lIpcDataGet: Copy Data from %X to %X", arIpcDataTp[bAccessIndex].au8BufferRx, pu8DataRx));
      // BKA2HI: die folgende CopyZeile ist komplett berflssig, weil die Daten schon lngst in der Ziel-Struktur stehen (wurde schon in der Thread RX gemacht)
      CSM_vMemCopy( (void *) pu8DataRx, arIpcDataTp[bAccessIndex].au8BufferRx, CSM_C_BUFFER_SIZE_TP_RX);
      *pu32LengthRx = arIpcDataTp[bAccessIndex].wDataLength;
      arIpcDataTp[bAccessIndex].fDataAvailable = FALSE;
    }
    else
    {
      #if (CSM_S_TRACE == CSM_C_F_ON)
        #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
          #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
          ETG_TRACE_ERR(("CSM_lIpcDataGet: RX buffer for NET_PORT: 0x%x is to small", bAccessIndex ));
          #endif
        #endif
      #endif
      s32Ret = CSM_STACK_M_MAKE_ERROR( CSM_C_ERR_WARNING, CSM_E_DATA_LENGTH_EXCEEDED);
    }
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("CSM_lIpcDataGet: Handle:%08X  MaxLen:%04X  Len:%04X  Data:%02X)", tyIpcHandle, u32MaxBufLengthRx, *pu32LengthRx,  ETG_LIST_LEN(*pu32LengthRx), ETG_LIST_PTR_T8(pu8DataRx)  ));
      #endif
    #endif
  #endif

  return s32Ret;
}

/*******************************************************************************
 * function    CSM_lIpcDataSend
 * \doxydocu
 * \brief      sets data received to INC
 *
 * \param      VtIpcHdl tyIpcHandle     Handle
 *             BYTE* pu8DataTx          pointer to data
 *             DWORD* pu32LengthTx      actual data length
 *
 * \return     LONG
 *
 * \access     CAN task
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 30.04.13 CM-AI/PJ-CD-43-Pistoor
 * Initial Revision.
 * \history_end
 ******************************************************************************/
LONG CSM_lIpcDataSend(tIpcHdl tyIpcHandle, BYTE* pu8DataTx, DWORD u32LengthTx)
{
  LONG s32Ret = CSM_C_NO_ERROR;
  sk_dgram* dgram = NULL;
  int wr;
  tyIpcCfgTpComCallback pComCallback = NULL;

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR4(("CSM_lIpcDataSend: Handle:%08X  Len:%04X  Data:%02X", tyIpcHandle, u32LengthTx,  ETG_LIST_LEN(u32LengthTx), ETG_LIST_PTR_T8(pu8DataTx) ));
      #endif
    #endif
  #endif

  switch(tyIpcHandle)
  {
    case NET_CTRL_PORT:
      dgram = csm_stack_pdgram_net;
      break;

    case NET_BROADCAST_PORT:
      dgram = csm_stack_pdgram_br;
      break;

    case NET_TP0_PORT:  // CAN RAW
      break;

    case NET_TP1_PORT:
      dgram = csm_stack_pdgram_can_np1;
      break;

    case NET_TP2_PORT:
      dgram = csm_stack_pdgram_can_np2;
      break;

    case NET_TP3_PORT:
      dgram = csm_stack_pdgram_can_np3;
      break;

    case NET_TP4_PORT:
      dgram = csm_stack_pdgram_can_np4;
      break;

    case NET_TP5_PORT:
      dgram = csm_stack_pdgram_can_np5;
      break;

    case NET_TP6_PORT:
      dgram = csm_stack_pdgram_can_np6;
      break;

    case NET_TP7_PORT:
      dgram = csm_stack_pdgram_can_np7;
      break;

    case NET_TP8_PORT:
    case NET_TP9_PORT:
    case NET_TP10_PORT:
    case NET_TP11_PORT:
      for (BYTE i = 0; i < CSM_C_PROXY_TP_CHANNELS; i++)
      {
        if (coarIpcCfgTpIncHandle[i] == tyIpcHandle)
        {
          dgram = arIpcCfgTpSocketHandles[i];
          break;
        }
      }
      break;

    default: // keep pointer NULL
      break;
  }

  // check if pointer is really assigned
  if(dgram != NULL)
  {
    wr = dgram_send(dgram, pu8DataTx, u32LengthTx);

    if (wr < 0)
    {
      #if (CSM_S_TRACE == CSM_C_F_ON)
        #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
          #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
          ETG_TRACE_ERR(("CSM_lIpcDataSend: ERROR writing to INC socket"));
          #endif
        #endif
      #endif
    }
    else
    {
      switch(tyIpcHandle)
      {
        case NET_BROADCAST_PORT:
          #if (CSM_S_TRACE == CSM_C_F_ON)
            #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
              #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
                ETG_TRACE_USR4(("CSM_lIpcDataSend: NET_BR_PORT - TX done"));
              #endif
            #endif
          #endif
          // this is to trigger pending BR requests
          csm_vBrSignalComCallback(INC_COM_CONFIRMATION);
          break;

        case NET_CTRL_PORT:
          if(*(pu8DataTx + 2) == IPC_SRVC_CODE_COMMUNICATION_REQ)    // Communication Request senden
          {
            #if (CSM_S_TRACE == CSM_C_F_ON)
              #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
                #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
                ETG_TRACE_USR3(("CSM_lIpcDataSend: NET_CTRL_PORT - COM_REQ - TX done"));
                #endif
              #endif
            #endif
            // this is to trigger pending BR requests
            csm_vBrSignalComCallback(INC_COM_CONFIRMATION);
          }
          else if(*(pu8DataTx + 2) == IPC_SRVC_CODE_COMP_STATUS_REQ) // Component Status Request senden
          {
            #if (CSM_S_TRACE == CSM_C_F_ON)
              #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
                #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
                ETG_TRACE_USR3(("CSM_lIpcDataSend: NET_CTRL_PORT - Component status request - TX done"));
                #endif
              #endif
            #endif
            csm_vRemoteNetComCallback(INC_COM_CONFIRMATION);
          }
          else
          {
            #if (CSM_S_TRACE == CSM_C_F_ON)
              #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
                #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
                ETG_TRACE_USR3(("CSM_lIpcDataSend: NET_CTRL_PORT - TX done"));
                #endif
              #endif
            #endif
            csm_vRemoteNetComCallback(INC_COM_CONFIRMATION);
          }
          break;

        case NET_TP0_PORT:  // CAN RAW
          break;

        case NET_TP1_PORT:
          // give a synchrounous confirmation directly
          csm_vTp1ComCallback(INC_COM_CONFIRMATION);
          break;

        case NET_TP2_PORT:
          // give a synchronous confirmation directly
          csm_vTp2ComCallback(INC_COM_CONFIRMATION);
          break;

        case NET_TP3_PORT:
          // give a synchronous confirmation directly
          csm_vTp3ComCallback(INC_COM_CONFIRMATION);
          break;

        case NET_TP4_PORT:
          // give a synchronous confirmation directly
          csm_vTp4ComCallback(INC_COM_CONFIRMATION);
          break;

        case NET_TP5_PORT:
          // give a synchronous confirmation directly
          csm_vTp5ComCallback(INC_COM_CONFIRMATION);
          break;

        case NET_TP6_PORT:
          // give a synchronous confirmation directly
          csm_vTp6ComCallback(INC_COM_CONFIRMATION);
          break;

        case NET_TP7_PORT:
          // give a synchronous confirmation directly
          csm_vTp7ComCallback(INC_COM_CONFIRMATION);
          break;

        // here we also need the re-mapping from NET_TP_PORT to the internal NP channel
        // the former fixed calls of callbacks must be changed to remapped calls
        case NET_TP8_PORT:
        case NET_TP9_PORT:
        case NET_TP10_PORT:
        case NET_TP11_PORT:
          for (BYTE i = 0; i < CSM_C_PROXY_TP_CHANNELS; i++)
          {
            if (coarIpcCfgTpIncHandle[i] == tyIpcHandle)
            {
              pComCallback = arpIpcCfgTpComCallbacks[i];
              break;
            }
          }

          if (pComCallback != NULL)
          {
            (*pComCallback)(INC_COM_CONFIRMATION);
          }
          break;

        default:
          s32Ret = CSM_M_MAKE_ERROR(CSM_C_ERR_ERROR, CSM_C_ERR_LOC_CSM, CSM_E_GENERAL_ERROR);
          #if (CSM_S_TRACE == CSM_C_F_ON)
            #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
              #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
              ETG_TRACE_ERR(("CSM_lIpcDataSend: ERROR writing to invalid INC socket, tyIpcHandle: 0x%x", tyIpcHandle));
              #endif
            #endif
          #endif
          break;
      }
    }
  }
  else
  {
    s32Ret = CSM_M_MAKE_ERROR(CSM_C_ERR_ERROR, CSM_C_ERR_LOC_CSM, CSM_E_GENERAL_ERROR);
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_ERR(("CSM_lIpcDataSend: ERROR writing to INC socket, dgram for INC port 0x%x is NULL", tyIpcHandle));
        #endif
      #endif
    #endif
  }

  return s32Ret;
}

// General Timeout function for the Proxy (callback for Linux Timer System)
void CSM_PROXY_vTimeout(const DWORD wTimerId)
{
  BYTE bValidTimer = FALSE;

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("IPC TIMER Event - CSM_PROXY_vTimeout: Id:%x",
                      ETG_CENUM(tCSM_TIMER_ID, (tU8)wTimerId)
                    ));
      #endif
    #endif
  #endif

  if (wTimerId < CSM_MAX_TIMER)
  {
    // set the flag corresponding to timer nr. (this is an atomic access as discussed with M.Prhl)
    abTimeoutFlags[wTimerId] = 0x01;
    // process the timeout in downstream task
    csm_vTriggerCsmDownstreamTask(CSM_C_DOWN_REASON_IPC_PROXY_TX_TIMEOUT);
  }
  else
  {
    CSM_vAssert(bValidTimer == TRUE);
  }
}

// Get function for timeout flags, so that timeouts can be processed asynchronously in proxy module
BYTE* CSM_PROXY_pbGetTimeoutFlags(void)
{
  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_USR3(("CSM_PROXY_dwGetTimeoutFlags: Pending Timeouts: %X",
                       ETG_LIST_LEN(CSM_MAX_TIMER),
                       ETG_LIST_PTR_T8(abTimeoutFlags)
                    ));
      #endif
    #endif
  #endif
  return &(abTimeoutFlags[0]);
}

#undef CSM_STACK_LINUX_P_SELF

/*******************************************************************************
 * \doxydocu
 * \file          csm_stack_linux_p.c
 * \brief         Project specific part of the linux environment specific
 *                adaptions for the CAN stack (timer, debug, task activation ...)
 *
 * \sw_component  CAN stack
 * \project       RN AIVI
 * \path          /di_can/modules_swa/csm_stack/src/
 *
 * \ingroup       CSM
 * \ingroup       CSM_STACK
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * \history_begin
 *
 * 01.06.15  main/rn_aivi_proxy/1  Borck
 * - adaptions for RN AIVI:
 *   -- BAP related stuff removed
 *   -- indizees for NET_NP data array access introduced
 *   -- local callbacks renamed for the NP TP channels
 *   -- ETG trace strings adapted
 *   -- Thread functions renamed
 *   -- number of NP TP channels increased from 2 to 3 (in header file)
 *
 * 04.06.15  main/rn_aivi_proxy/2  Borck
 * - some ETG trace adaptions
 *
 * 10.06.15  main/rn_aivi_proxy/3  Borck
 * - some ETG trace adaptions
 * - Proxy timeout callback adapted to signature change
 *
 * 19.06.15  main/rn_aivi_proxy/4  Borck
 * - array with timeout flags introduced
 * - new names for "down reason" indications used
 * - timeout handling for IPC transmissions added
 *
 * 09.07.15  main/rn_aivi_proxy/5  Borck
 * - used downstream reasons have been renamed
 * - some modification due to extension in IPC data struct
 * - some comments added
 *
 * 23.07.15  main/rn_aivi_proxy/6  Borck
 * - generic kernel defined disabled
 * - additional include added
 * - some LINT issues fixed
 * - some trace output modified
 *
 * 21.09.15  main/rn_aivi_proxy/rn_aivi_proxy_generated/1  Borck
 * - external variable declared, which is now required due to a mapped #define
 *
 * 04.11.15  main/rn_aivi_proxy/rn_aivi_proxy_generated/2  Borck
 * - changes for new introduced TP channels (NET):
 * -- new dgrams, new access IDs, new threads, new thread callbacks
 * -- RX and TX functions extended for new NET channels
 *
 * 03.03.16  main/rn_aivi_proxy/rn_aivi_proxy_generated/3  M. Prhl
 * - adapt code to old, new and upcoming inc_port.h
 *
 * 06.09.16  main/rn_aivi_proxy/rn_aivi_proxy_generated/4  A.Borck
 * - dedicated trace class for this module introduced:
 *
 * 19.09.16  main/rn_aivi_proxy/rn_aivi_proxy_generated/5  A.Borck
 * - MPDT channels now supporting C-Type and D-Type data
 *
 * 05.05.17  main/rn_aivi_proxy/rn_aivi_proxy_generated/6  A.Borck
 * - prepared for usage with 11 INC LUNs for AIVI and PIVI
 * - NET_TP_PORTS are not mapped to CSM internal NP channels directly (1:1) -> runtime information dependend on config is required.
 *
 * 30.05.17  main/rn_aivi_proxy/rn_aivi_proxy_generated/7  A.Borck
 * - trace output modified
 * - discovered and commented a useless copy action
 *
 * 31.05.17  main/rn_aivi_proxy/rn_aivi_proxy_generated/8  A.Borck
 * - LINT issues fixed
 * - INC port name workaround adapted
 *
 * 01.06.17  main/rn_aivi_proxy/rn_aivi_proxy_generated/9  A.Borck
 * - ETG trace output changed
 * - some comments changed
 * - more LINT issues fixed
 *
 * 14.06.17  main/rn_aivi_proxy/rn_aivi_proxy_generated/10  A.Borck
 * - some direct variant dependencies replaced by dependencies on amount of NetTp channels
 *   - this makes FOTA ISO-TP channels possible for RIVIE
 *
 * 10.08.17  main/rn_aivi_proxy/rn_aivi_proxy_generated/11  A.Borck
 * - final optimisations regarding TRACE output -> USER3 should be used as standard, USER4 is with CBR output
 *
 * 24.11.17  main\g3inf4cv_csm_proxy_in\1  Jayashree
 * - Initial version for INF4CV
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
