//**************************************************************************************************
//* defines and macros (scope: CAN stack and application)
//**************************************************************************************************

#define CSM_C_PROJECT_INF4CV /**< This is the define to identify the project TCC-TOUCH */
#define CSM_C_VERSION                                     0x88010001        /**< Verision number Diamler Projects->0x88 Variant->0x01 Version Number->0x0001*/


//**************************************************************************************************
//* PROC CSM Datapool
//**************************************************************************************************
#define CSM_C_ADDRESS_FIELD_DP_SLOT                   0x00
#define CSM_C_ADDRESS_FIELD_DP_STEERING_WHEEL_TYPE    0x01
#define CSM_C_ADDRESS_FIELD_DP_VOICE_REC              0x02
#define CSM_C_ADDRESS_FIELD_DP_FUEL_TYPE              0x03
#define CSM_C_ADDRESS_FIELD_DP_CAMERA_SYSTEM          0x04
#define CSM_C_ADDRESS_FIELD_DP_IPA_HFP                0x05
#define CSM_C_ADDRESS_FIELD_DP_SONAR                  0x06
#define CSM_C_ADDRESS_FIELD_DP_ANTI_THEFT             0x07
#define CSM_C_ADDRESS_FIELD_DP_ANTICIPATORY_LINE      0x08
#define CSM_C_ADDRESS_FIELD_DP_STEERING_MSG           0x09
#define CSM_C_ADDRESS_FIELD_DP_TRAFFIC_SIGN_REC       0x0A
#define CSM_C_ADDRESS_FIELD_DP_NAVI_FUNCTION          0x0B
#define CSM_C_ADDRESS_FIELD_DP_RCSTYPE                0x0C
#define CSM_C_ADDRESS_FIELD_DP_ITCOMMANDERTYPE        0x0D
#define CSM_C_ADDRESS_FIELD_DP_VCANMCAN_GATEWAY       0x0E
#define CSM_C_ADDRESS_FIELD_DP_FUEL_CONSUMPTION_INFO  0x0F
#define CSM_C_ADDRESS_FIELD_DP_TPMS                   0x10
#define CSM_C_ADDRESS_FIELD_DP_VDC                    0x11
#define CSM_C_ADDRESS_FIELD_DP_AD_FUNCTION            0x12
#define CSM_C_ADDRESS_FIELD_DP_VEHICLE_SETTING        0x13
#define CSM_C_ADDRESS_FIELD_DP_HUD_SETTING            0x14
#define CSM_C_ADDRESS_FIELD_DP_HVAC_TYPE              0x15
#define CSM_C_ADDRESS_FIELD_DP_DIGITAL_ASSI           0x16
#define CSM_C_ADDRESS_FIELD_DP_SEND_COUNTRY_INFO      0x17

#define CSM_C_ADDRESS_FIELD_DP_MAX_ITEMS              0x18                // max value used for indexed access in arrays
/* Id's for the individual J1939 PGN's  handled within CNP_J1939*/
enum
{
     /* project specific PGNs                    *
      * (this order is used as index in arrays!) */
   CSM_C_J1939_PGN_AMBIENTCOND_ICAN,
   CSM_C_J1939_PGN_CRUISECONTROL_ICAN,
   CSM_C_J1939_PGN_DEVSTATUS_ICAN,
   CSM_C_J1939_PGN_DRIVINDI_ICAN,
   CSM_C_J1939_PGN_ETC5_ICAN,
   CSM_C_J1939_PGN_FltData_ICAN,
     CSM_C_J1939_PGN_ILLUMINATION_ICAN,
   CSM_C_J1939_PGN_CABINAMEDIADATA_ICAN,
   CSM_C_J1939_PGN_MEDCMD_ICAN,
   CSM_C_J1939_PGN_MEDDATA_ICAN,
   CSM_C_J1939_PGN_MEDSTATE1_ICAN,
   CSM_C_J1939_PGN_MEDSTATE2_ICAN,
   CSM_C_J1939_PGN_NAVDATA_ICAN,
   CSM_C_J1939_PGN_CABINBMEDIADATA_ICAN,
   CSM_C_J1939_PGN_PHNSTATUS_ICAN,
    CSM_C_J1939_PGN_REMOTECNTRL_ICAN,
  CSM_C_J1939_PGN_SYSENV_ICAN,
  CSM_C_J1939_PGN_TCO1_ICAN,
  CSM_C_J1939_PGN_TIMEDATE_ICAN,
  CSM_C_J1939_PGN_VEHPOS_ICAN,
  CSM_C_J1939_PGN_VEHWt_ICAN,
    CSM_C_J1939_PGN_VIN_ICAN,
  CSM_C_MAX_CCS_NP_CHANNELS,
    /* do not change any PGN after this, they are common */
    #if (CSM_S_J1939_ERRORMEMORY == CSM_C_F_ON)
    CSM_C_J1939_PGN_DM1 = CSM_C_MAX_CCS_NP_CHANNELS,  /*Read Active DTCs*/
    CSM_C_J1939_PGN_DM2,  /*Read Previously Active DTCs*/
    CSM_C_J1939_PGN_DM3,  /*Clear Previously Active DTCs*/
    CSM_C_J1939_PGN_DM5,  /*Diagnostic Readiness*/
    CSM_C_J1939_PGN_DM11, /*Clear Active DTCs*/
    CSM_C_J1939_PGN_DM22, /*Clear Individual DTC*/
    #endif
    #if (CSM_S_J1939_STARTSTOP_BROADCAST == CSM_C_F_ON)
    CSM_C_J1939_PGN_DM13_ICAN, /*Start/Stop Broadcast*/
    #endif
    #if (CSM_S_J1939_MEMORYACCESS == CSM_C_F_ON)
    CSM_C_J1939_PGN_DM14, /*MemoryAccessRequest*/
    CSM_C_J1939_PGN_DM15, /*MemoryAccessResponse*/
    CSM_C_J1939_PGN_DM16, /*BinaryDataTransfer*/
    #endif
    CSM_C_J1939_CFG_MAXPGN,
    CSM_C_J1939_PGN_UNKNOWN
};

/* Node Id's for the individual nodes handled within CNM_J1939*/
enum
{
    /* project specific nodes                             *
     * attention (this order is used as index in arrays!) */

    /*remote nodes*/
  CSM_C_J1939_NODE_ECU=0,  /* ECU */
  CSM_C_J1939_NODE_FLM,    /* FLM */
  CSM_C_J1939_NODE_GNSS,   /* GNSS */
  CSM_C_J1939_NODE_TCO,    /* TCO */
  CSM_C_J1939_NODE_ICL,    /* ICL */

  /*own nodes of this ECU*/
  CSM_C_J1939_NODE_RAD,   /* MMT3 (self!) */
  CSM_C_J1939_NODE_NAV,   /* MMT3 (self!) */
  CSM_C_J1939_NODE_PHN,   /* MMT3 (self!) */

    /* common definitions, must remain here! */
    CSM_C_J1939_NODE_NULL,
    CSM_C_J1939_NODE_BROADCAST,
    CSM_C_J1939_CFG_MAXNODES, /** number of supported remote nodes */
    CSM_C_J1939_NODE_UNKNOWN
};

// ##################################################
// _CSM_SECTION_HISTORY: user specific code start
// ##################################################

/***************************************************************************************************
 * \doxydocu
 * \file          csm_stack_ip_g3inf4cv.h
 * \brief         Project specific part of the interface header(s) of the
 *                CAN stack.
 *
 * \see           CAN-SW Architektur, written by CM-DI
 *
 * \sw_component  CAN stack
 * \project       g3inf4cv
 * \path          /di_can/modules_swa/csm_stack/src/
 *
 * \ingroup       CSM_STACK
 *
 * \authors       Jayashree
 *
 * COPYRIGHT      (c) 2017 Bosch Car Multimedia RBEI
 *
 * \history_begin
 *
 * 05.10.17  \main\rn_aivi_proxy\2  A.Borck
 * - manually changed:
 *   -- Initial Version by porting tcc touch code
 *
 * 24.11.17  main\g3inf4cv_csm_proxy_in\1  Jayashree
 * - Initial version for INF4CV
 *
 **************************************************************************************************/
// ##################################################
// _CSM_SECTION_HISTORY: user specific code end
// ##################################################

