// Description and history of csm_stack_ip.h at the end of the file.
#ifndef CSM_STACK_IP_HEADER
// File name for preprozessor commands
#define CSM_STACK_IP_HEADER

//**************************************************************************************************
//* CSM global and project/variant independent !!!
//**************************************************************************************************
// Bus numbers
typedef enum
{
  _VCAN  = 0x0000,
  _MCAN  = 0x0001
} tCSM_BUS_NUMBER;       // for ETG trace

#define CSM_C_CAN_BUS_VCAN      CSM_M_GET_LOBYTE(_VCAN) // 0
#define CSM_C_CAN_BUS_MCAN      CSM_M_GET_LOBYTE(_MCAN) // 1

// Protocol types
typedef enum
{
  _LOCAL_CTRL     = 0x8801UL,
  _OSEKI_NWM_     = 0x8804UL,
  _BR_SIGNAL_     = 0x8840UL,
  _USDT_ISO__     = 0x8850UL
} tCSM_PROTOCOL_TYPE;   // for ETG trace

#if (CSM_S_CSM_LOCAL_CTRL == CSM_C_F_ON)
#define CSM_C_PTYPE_PSGEN_CAN_LOCAL_CTRL            ((DWORD) _LOCAL_CTRL)
#define CSM_C_ADDRESS_FIELD_DC_LOCAL_CTRL              0x01
#define CSM_C_ADDRESS_FIELD_DC_LOCAL_CTRL_UNDEF        0xff
#endif
/*****************************************************************************/
/* CBR */
/*****************************************************************************/
#define CSM_C_PTYPE_DC_BR_SIGNAL                   ((DWORD) _BR_SIGNAL_)
/* ------------------------------------------------------------------------- */
/* CSM  BR ADDRESS FIELD */
#define CSM_C_ADDRESS_FIELD_INF4CV_BR_VCAN                  0x01
#define CSM_C_ADDRESS_FIELD_INF4CV_BR_MCAN                  0x02
#define CSM_C_ADDRESS_FIELD_INF4CV_BR_UNDEF                 0xff

/* ------------------------------------------------------------------------- */
/*****************************************************************************/
/* CNM */
/*****************************************************************************/
#define CSM_C_PTYPE_DC_OSEKI_NWM                 ((DWORD) _OSEKI_NWM_)

/*****************************************************************************/
/* cnp ISO-TP */
/*****************************************************************************/
/* Protokolltype */
#define CSM_C_PTYPE_DC_USDT_ISO                       ((DWORD) _USDT_ISO__)
#define CSM_C_PTYPE_J1939                                 0xC070UL
#if (CSM_S_J1939 == CSM_C_F_ON)
/*****************************************************************************/
/* CNP J1939 */
/*****************************************************************************/

/* Protokolltype changed from 0xC001 to 0xC070*/
#define CSM_C_PTYPE_J1939                                 0xC070UL

/* J1939 address field */
#define CSM_C_ADR_FLD_J1939                               0x00

#define CSM_C_ADR_FLD_J1939_0                             0x01
#define CSM_C_ADR_FLD_J1939_1                             0x02
#define CSM_C_ADR_FLD_J1939_2                             0x03
#endif

/* ------------------------------------------------------------------------- */
/*CNP ADDRESS FIELD */
typedef enum
{
  _LOCAL_CMP__    = 0x0000,
  _APPL_______    = 0x0001,
  _VCAN_CDIAG_    = 0x0002,
  _VCAN_PDIAG_    = 0x0003,
  _MCAN_CDIAG_    = 0x0004

} tCSM_ADDRESS_FIELD_USDT_ISO;
#define CSM_C_ADDRESS_FIELD_INF4CV_USDT_ISO               ((DWORD) _LOCAL_CMP__) /*bLocalComp*/

#define CSM_C_ADDRESS_FIELD_INF4CV_USDT_ISO_0            ((DWORD) _APPL_______) /* Extki Appl*/
#define CSM_C_ADDRESS_FIELD_INF4CV_USDT_ISO_1            ((DWORD) _VCAN_CDIAG_) /* Customer Diag Appl*/
#define CSM_C_ADDRESS_FIELD_INF4CV_USDT_ISO_2            ((DWORD) _VCAN_PDIAG_) /* Production Diag Appl*/
#define CSM_C_ADDRESS_FIELD_INF4CV_USDT_ISO_3            ((DWORD) _MCAN_CDIAG_) /* Customer Diag MCAN Appl*/


#define CSM_C_ADDRESS_FIELD_INF4CV_USDT_ISO_EXTKI          CSM_C_ADDRESS_FIELD_INF4CV_USDT_ISO_0 /**< bRemoteComp  for BOSCH diagnosis channel */

/*CSM ADDRESS FIELD FOR CUSTOMER DIAG*/
#define CSM_C_ADDRESS_FIELD_INF4CV_USDT_ISO_CDIAG          CSM_C_ADDRESS_FIELD_INF4CV_USDT_ISO_1 /**< bRemoteComp  for BOSCH diagnosis channel */

/*CSM ADDRESS FIELD FOR PRODUCTION DIAG*/
#define CSM_C_ADDRESS_FIELD_INF4CV_USDT_ISO_PDIAG          CSM_C_ADDRESS_FIELD_INF4CV_USDT_ISO_2 /**< bRemoteComp  for BOSCH diagnosis channel */

/*CSM ADDRESS FIELD FOR CUSTOMER DIAG MCAN*/
#define CSM_C_ADDRESS_FIELD_INF4CV_USDT_ISO_MCAN_CDIAG     CSM_C_ADDRESS_FIELD_INF4CV_USDT_ISO_3 /**< bRemoteComp  for BOSCH diagnosis channel */
#define CSM_C_ADDRESS_FIELD_INF4CV_USDT_NODE_UNUSED        0xFF /**< bRemoteComp for EXtki channel */

/* ------------------------------------------------------------------------- */
/*Message length*/
#define CSM_C_USDT_ISO_INF4CV_USDT_ISO_DIAG_MAX_RX_LENGTH   4096 /**< Max Rx message length for BOSCH diagnosis channel */
#define CSM_C_USDT_ISO_INF4CV_USDT_ISO_DIAG_MAX_TX_LENGTH   4096 /**< Max Tx message length for BOSCH diagnosis channel */


#define CSM_C_USDT_ISO_INF4CV_USDT_ISO_EXTKI_MAX_RX_LENGTH  255 /**< Max Rx message length for BOSCH diagnosis channel */
#define CSM_C_USDT_ISO_INF4CV_USDT_ISO_EXTKI_MAX_TX_LENGTH  255 /**< Max Tx message length for BOSCH diagnosis channel */

/* ------------------------------------------------------------------------- */

// APPL IDs
typedef enum
{
  _BR_MCAN_____    = 0x0000,
  _BR_VCAN_____    = 0x0001,
  _LCTRL_MCAN__    = 0x0002,
  _LCTRL_VCAN__    = 0x0003,
  _LCM_MCAN____    = 0x0004,
  _LCM_VCAN____    = 0x0005,
  _IGNITION_MCAN_   = 0x0006,
  _IGNITION_VCAN_   = 0x0007,
  _DIAG_MCAN___    = 0x0008,
  _DIAG_VCAN___    = 0x0009,
  _VEHICLE_DATA_   = 0x000A
} tCSM_APPL_ID;                      // for ETG trace

#define CSM_C_APPL_ID_RN_BR_VCAN                   ((WORD) _BR_VCAN_____)
#define CSM_C_APPL_ID_RN_BR_MCAN                ((WORD) _BR_MCAN_____)

#define CSM_C_APPL_ID_MCAN_LOCAL_CTRL_SPM       ((WORD) _LCTRL_MCAN__)
#define CSM_C_APPL_ID_VCAN_LOCAL_CTRL_SPM       ((WORD) _LCTRL_VCAN__)
#define CSM_C_APPL_ID_MCAN_LOCAL_CTRL_LCM       ((WORD) _LCM_MCAN____)
#define CSM_C_APPL_ID_VCAN_LOCAL_CTRL_LCM       ((WORD) _LCM_VCAN____)
//the following define is provided for SPM compatibility
#define CSM_C_APPL_ID_VCAN_LOCAL_CTRL_IGNITION   ((WORD) _IGNITION_VCAN_)
#define CSM_C_APPL_ID_MCAN_LOCAL_CTRL_IGNITION   ((WORD) _IGNITION_MCAN_)

#define CSM_C_APPL_ID_VCAN_LOCAL_CTRL_DIA        ((WORD) _LCM_VCAN____)
#define CSM_C_APPL_ID_MCAN_LOCAL_CTRL_DIA        ((WORD) _LCM_MCAN____)
#define CSM_C_APPL_ID_DC_CAN_NM_VEHICLE_DATA     ((WORD) _VEHICLE_DATA_)

/*****************************************************************************/

// IPC service codes
typedef enum
{
  _COMP_STATUS_REQ        =  0x08,
  _COMP_STATUS_CON        =  0x09,
  _COMP_STATUS_IND        =  0x0B,
  _BUS_STATE_IND          =  0x15,
  _BUS_ERROR_IND          =  0x17,
  _SERVICE_REJECT         =  0x1B,
  _COMMUNICATION_REQ      =  0x24,
  _COMMUNICATION_CON      =  0x25,
  _COMMUNICATION_IND      =  0x27,
  _DATA_REQ               =  0x40,
  _DATA_CON               =  0x41,
  _DATA_IND               =  0x45,
  _SIGNAL_WRITE_REQ       =  0x50,
  _SIGNAL_IND             =  0x55
} tCSM_IPC_SERVICE_CODE;            // for ETG trace

// REJECT codes
typedef enum
{
  _NO_REASON              =  0x00,
  _UNKNOWN_SRVC           =  0x01,
  _COMP_INACTIVE          =  0x02,
  _INVALID_PARA           =  0x03,
  _SRVC_UNAVAILABLE       =  0x0b,
  _STACK_INACTIVE         =  0x80,
  _STACK_BUSY             =  0x81,
  _NO_CONNECTION          =  0x82,
  _WRONG_CSM_VERSION      =  0x83,
  _DATA_LEN_EXCEEDED      =  0x84,
  _BUFFER_FULL            =  0x85
} tCSM_IPC_REJECT_REASON;          // for ETG trace

// TX result
typedef enum
{
  _OK____  = 0x00,
  _NOT_OK  = 0x01
} tCSM_INC_TX_RESULT;              // for ETG trace

// Action Request
typedef enum
{
  _CONNECT____  = 0x01,
  _DISCONNECT_  = 0x02
} tCSM_ACTION_REQ;                 // for ETG trace

// Timer ID to be synced with the enum in ..._mp.h
typedef enum
{
  _NET_CTRL_______ = 0x01,                             // net ctrl
  _NET_CTRL_USER_0 = 0x02,                             // net ctrl
  _NET_CTRL_USER_1 = 0x03,                             // net ctrl
  _NET_OSEKI______ = 0x04,                             // net oseki
  _BRSIGNAL_______ = 0x05,                             // broadcast
  _NP1_COMREQ_____ = 0x06,                             // np1 mpdt TCU
  _NP1_CType______ = 0x07,                             // np1 mpdt TCU
  _NP1_DType______ = 0x08,                             // np1 mpdt TCU
} tCSM_TIMER_ID;                                       // for ETG trace

//**************************************************************************************************
//* CNM
//**************************************************************************************************
// CSM ADDRESS FIELD
// lower byte of the address field
// these values NOT anymore indicees to the NM monitors directly !!!
// we would rather call it a sort of client (component) ID
// a component may use several RX/TX IDs, but only 1 of them can be monitored
typedef enum
{
  _NAVI___   = 0x0000,     // MPDT 29
  _AUDIO__   = 0x0001,     // MPDT 28
  _SWC____   = 0x0002,     // MPDT 03
  _TCU____   = 0x0003,     // MPDT 2C
  _BOSE___   = 0x0004,     // MPDT 06
  _RSE____   = 0x0005,     // MPDT 2D
  _NAVI2__   = 0x0006,     // MPDT 51
  _CD_____   = 0x0007,     // MPDT 05
  _BOSEA__   = 0x0008,     // MPDT 30
  _AVM____   = 0x0009,     // VCAN Node
  _ECM____   = 0x000A,     // VCAN Node
  _BCM____   = 0x000B,     // VCAN Node
  _USM____   = 0x000C,     // VCAN Node
  _METER__   = 0x000D,     // VCAN Node
  _5EA____   = 0x000E,     // VCAN Node
  _HCM____   = 0x000F,     // VCAN Node
  _SBW____   = 0x0010,     // VCAN Node
  _STRG___   = 0x0011,     // VCAN Node
  _SONAR__   = 0x0012,     // VCAN Node
  _HVAC___   = 0x0013,     // VCAN Node
  _VCM____   = 0x0014,     // VCAN Node
  _IDM____   = 0x0015,     // VCAN Node
  _LBC____   = 0x0016,     // VCAN Node
  _RCU____   = 0x0017,     // VCAN Node
  _ITC____   = 0x0018,     // MPDT 2E
  _RSC____   = 0x0019,     // MPDT 32
  _HUD____   = 0x001A,     // VCAN Node
  _ADAS___   = 0x001B,     // VCAN Node
  _FCAM___   = 0x001C,     // VCAN Node
  _CVT____   = 0x001D,     // VCAN Node
  _VDC____   = 0x001E,     // VCAN Node
  _ECM2___   = 0x001F,     // VCAN Node
  _D2SU___   = 0x0020,     // MPDT 60
  _D2DC___   = 0x0021,     // MPDT 2A
  _D2IS___   = 0x0022,     // MPDT 01
  _AVM3___   = 0x0023,     // MPDT 13
  _INVALID   = 0x00FF
} tCSM_ADDRESS_FIELD_1_OSEKI;       // for ETG trace

#define CSM_C_ADR_FLD_RN_NM_NAV       CSM_M_GET_LOBYTE(_NAVI___)
#define CSM_C_ADR_FLD_RN_NM_AUD       CSM_M_GET_LOBYTE(_AUDIO__)
#define CSM_C_ADR_FLD_RN_NM_SWC       CSM_M_GET_LOBYTE(_SWC____)
#define CSM_C_ADR_FLD_RN_NM_TCU       CSM_M_GET_LOBYTE(_TCU____)
#define CSM_C_ADR_FLD_RN_NM_BOSE      CSM_M_GET_LOBYTE(_BOSE___)
#define CSM_C_ADR_FLD_RN_NM_RSE       CSM_M_GET_LOBYTE(_RSE____)
#define CSM_C_ADR_FLD_RN_NM_NAV2      CSM_M_GET_LOBYTE(_NAVI2__)
#define CSM_C_ADR_FLD_RN_NM_CD        CSM_M_GET_LOBYTE(_CD_____)
#define CSM_C_ADR_FLD_RN_NM_BOSEA     CSM_M_GET_LOBYTE(_BOSEA__)
#define CSM_C_ADR_FLD_RN_NM_AVM       CSM_M_GET_LOBYTE(_AVM____)
#define CSM_C_ADR_FLD_RN_NM_ECM       CSM_M_GET_LOBYTE(_ECM____)
#define CSM_C_ADR_FLD_RN_NM_BCM       CSM_M_GET_LOBYTE(_BCM____)
#define CSM_C_ADR_FLD_RN_NM_USM       CSM_M_GET_LOBYTE(_USM____)
#define CSM_C_ADR_FLD_RN_NM_METER     CSM_M_GET_LOBYTE(_METER__)
#define CSM_C_ADR_FLD_RN_NM_5EA       CSM_M_GET_LOBYTE(_5EA____)
#define CSM_C_ADR_FLD_RN_NM_HCM       CSM_M_GET_LOBYTE(_HCM____)
#define CSM_C_ADR_FLD_RN_NM_SBW       CSM_M_GET_LOBYTE(_SBW____)
#define CSM_C_ADR_FLD_RN_NM_STRG      CSM_M_GET_LOBYTE(_STRG___)
#define CSM_C_ADR_FLD_RN_NM_SONAR     CSM_M_GET_LOBYTE(_SONAR__)
#define CSM_C_ADR_FLD_RN_NM_HVAC      CSM_M_GET_LOBYTE(_HVAC___)
#define CSM_C_ADR_FLD_RN_NM_VCM       CSM_M_GET_LOBYTE(_VCM____)
#define CSM_C_ADR_FLD_RN_NM_IDM       CSM_M_GET_LOBYTE(_IDM____)
#define CSM_C_ADR_FLD_RN_NM_LBC       CSM_M_GET_LOBYTE(_LBC____)
#define CSM_C_ADR_FLD_RN_NM_RCU       CSM_M_GET_LOBYTE(_RCU____)
#define CSM_C_ADR_FLD_RN_NM_ITC       CSM_M_GET_LOBYTE(_ITC____)
#define CSM_C_ADR_FLD_RN_NM_RSC       CSM_M_GET_LOBYTE(_RSC____)
#define CSM_C_ADR_FLD_RN_NM_HUD       CSM_M_GET_LOBYTE(_HUD____)
#define CSM_C_ADR_FLD_RN_NM_ADAS      CSM_M_GET_LOBYTE(_ADAS___)
#define CSM_C_ADR_FLD_RN_NM_FCAM      CSM_M_GET_LOBYTE(_FCAM___)
#define CSM_C_ADR_FLD_RN_NM_CVT       CSM_M_GET_LOBYTE(_CVT____)
#define CSM_C_ADR_FLD_RN_NM_VDC       CSM_M_GET_LOBYTE(_VDC____)
#define CSM_C_ADR_FLD_RN_NM_ECM2      CSM_M_GET_LOBYTE(_ECM2___)
#define CSM_C_ADR_FLD_RN_NM_D2SU      CSM_M_GET_LOBYTE(_D2SU___)
#define CSM_C_ADR_FLD_RN_NM_D2DC      CSM_M_GET_LOBYTE(_D2DC___)
#define CSM_C_ADR_FLD_RN_NM_D2IS      CSM_M_GET_LOBYTE(_D2IS___)
#define CSM_C_ADR_FLD_RN_NM_AVM3      CSM_M_GET_LOBYTE(_AVM3___)

// special purpose defines
#define CSM_C_ADR_FLD_RN_NM_OURSELF   CSM_C_ADR_FLD_RN_NM_AVM      // TX Mute for our device node
                                                                   // since vehicle data uses AVM to convert the node into the ITC
                                                                   // we currently cannot change it


// unified error state for ETG tracing
typedef enum
{
  STATE_OK_______     = 0x0000,
  STATE_PRESENT__     = 0x0001,
  STATE_CONFIRMED     = 0x0002
} tCSM_OSEKI_ERROR_STATE;

// higher byte of the address field
// these values references RX, TX or BusOFF arrays of the OSEKI monitor
typedef enum
{
  _RX_INDICATOR____     = 0x0080,
  _TX_INDICATOR____     = 0x0040,
  _BUSOFF_INDICATOR     = 0x0020,
  _CMD_INDICATOR___     = 0x0010
} tCSM_ADDRESS_FIELD_0_OSEKI;       // for ETG trace

#define CSM_C_ADR_FLD_DC_NM_RX_INDICATOR      CSM_M_GET_LOBYTE(_RX_INDICATOR____)
#define CSM_C_ADR_FLD_DC_NM_TX_INDICATOR      CSM_M_GET_LOBYTE(_TX_INDICATOR____)
#define CSM_C_ADR_FLD_DC_NM_BUSOFF_INDICATOR  CSM_M_GET_LOBYTE(_BUSOFF_INDICATOR)
#define CSM_C_ADR_FLD_DC_NM_CMD_INDICATOR     CSM_M_GET_LOBYTE(_CMD_INDICATOR___)

// commands that can be passed to the CNM OSEKI via CommunicationReq
#define CNM_OSEKI_CMD_NO_CMD                  0x00
#define CNM_OSEKI_CMD_REINIT_MONITOR          0x01

// aditional value for action. But this value is only supported with ApplId CSM_C_APPL_ID_VW_CAN_LOCAL_CTRL_DIAG_SEND_RESTRICTION
#define CSM_C_NORMAL_COMMUNICATION_LIMITED         0x0a  /**< Only specific diagnostic communication allowed */

// other Exports
// some state defines for node and mute monitoring
// ensure that these states do NOT have the value 0xFF -> that is reserved for error
#define CNM_OSEKI_C_STATE_NODE_PRESENT            0x00
#define CNM_OSEKI_C_STATE_NODE_ABSENT             0x01
#define CNM_OSEKI_C_STATE_NODE_CONFIRMED_ABSENT   0x02

#define CNM_OSEKI_C_STATE_NODE_NOT_MUTED          0x00
#define CNM_OSEKI_C_STATE_NODE_MUTED              0x01
#define CNM_OSEKI_C_STATE_NODE_CONFIRMED_MUTED    0x02

#define CNM_OSEKI_C_STATE_BUS_ON                  0x00
#define CNM_OSEKI_C_STATE_BUS_OFF                 0x01
#define CNM_OSEKI_C_STATE_CONFIRMED_BUS_OFF       0x02

#define CNM_OSEKI_C_STATE_ERROR                   0xFF


//**************************************************************************************************
//* CBR
//**************************************************************************************************
/*************************************************************/
/* signal packet defines broadcast send telegrams            */
/*************************************************************/
#define CBR_C_TCC_DM1_TX_MAX_SIGNALS       11
#define CBR_C_TCC_C1_TX_MAX_SIGNALS        8
#define CBR_C_VDS_TCC_TX_MAX_SIGNALS       4
#define CBR_C_VP_TCC_TX_MAX_SIGNALS        2
#define CBR_C_TCC_C2_TX_MAX_SIGNALS        8
#define CBR_C_NM_TCC_TX_MAX_SIGNALS        11

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)

#if (CSM_S_ISO_TP == CSM_C_F_ON)
#ifdef CSM_C_PROJECT_TCC_TOUCH

/*****************************************************************************/
/* CONSTANTS                                                                 */
/*****************************************************************************/
#define CSM_EXTKI_RXTX_MAX_BUFFER_SIZE      255

#define kExtKiTCCNumber                     0x9B
#define kExtKiICUCNumber                    0x9A
#define kExtKiFBNumber                      0x9C
#define kCustomerDiagTCCNumber              0x97
#define kDiagBroadcast                      0xFF
#define kProdDiagSZKNumber                  0x98

/*****************************************************************************/
/* error numbers for ErrorCallback functions                                 */
/*****************************************************************************/
/* More error codes related to TP are available in tpmc.h*/
#define kTpTxErrExtKiDataLengthExceeded     0x36
#define kTpRxErrExtKiDataLengthExceeded     0x10

/* Node Id's for the individual nodes handled within ISO-TP */
enum
{
    /* project specific nodes                             *
     * attention (this order is used as index in arrays!) */
    /*remote nodes*/
  CSM_C_ISO_TP_TESTER =0,  /* ECU */
  CSM_C_ISO_TP_ICUC,    /* Cluster */
  /*own nodes of this ECU*/
  CSM_C_ISO_TP_DTCCT,   /* TCC-Touch (self!) */

    /* common definitions, must remain here! */
  CSM_C_ISO_TP_NODE_NULL,
  CSM_C_ISO_TP_NODE_BROADCAST,
  CSM_C_ISO_TP_CFG_MAXNODES, /** number of supported remote nodes */
  CSM_C_ISO_TP_NODE_UNKNOWN
};
#endif /*CSM_C_PROJECT_TCC_TOUCH*/
#endif
#endif /* CSM_S_CNP_AVAILABLE */
/* ------------------------------------------------------------------------- */
#if (defined VARIANT_S_FTR_ENABLE_INF4CV) || (defined VARIANT_S_FTR_ENABLE_EVOBUS) || (defined VARIANT_S_FTR_ENABLE_SMART_HU) || (defined VARIANT_S_FTR_ENABLE_EVOBUSB2E)
  // fine: at least we are building 1 project
  #if (defined VARIANT_S_FTR_ENABLE_INF4CV)
    #include "csm_stack_ip_inf4cv.h"
  #elif (defined VARIANT_S_FTR_ENABLE_EVOBUS)
    #include "csm_stack_ip_evobus.h"
  #elif (defined VARIANT_S_FTR_ENABLE_SMART_HU)
    #include "csm_stack_ip_smart_hu.h"
  #elif (defined VARIANT_S_FTR_ENABLE_EVOBUSB2E)
    #include "csm_stack_ip_evobusb2e.h"
  #else
  #error "No valid project variant detectable: INF4CV required here"
  #endif

#else
#endif
#if (defined CSM_C_PROJECT_USERSPACE_EVOBUS) || (defined CSM_C_PROJECT_USERSPACE_EVOBUSB2E) || (defined CSM_C_PROJECT_USERSPACE_INF4CV) || (defined CSM_C_PROJECT_USERSPACE_SMART_HU)
   #if (defined CSM_C_PROJECT_USERSPACE_INF4CV)
    #include "csm_stack_ip_inf4cv.h"
    #include "csm_stack_cbr_ip_inf4cv.h"
   #elif (defined CSM_C_PROJECT_USERSPACE_EVOBUS)
    #include "csm_stack_ip_evobus.h"
    #include "csm_stack_cbr_ip_evobus.h"
  #elif (defined CSM_C_PROJECT_USERSPACE_SMART_HU)
    #include "csm_stack_ip_smart_hu.h"
    #include "csm_stack_cbr_ip_smart_hu.h"
   #elif (defined CSM_C_PROJECT_USERSPACE_EVOBUSB2E)
    #include "csm_stack_ip_evobusb2e.h"
    #include "csm_stack_cbr_ip_evobusb2e.h"
   #else
    #error "No valid project variant detectable: INF4CV/EvoBus required here"
   #endif
#else
  // if no variant feature switch is defined, we do not need the content of csm_stack_ip.h for the product being build
#endif


#else  // CSM_STACK_IP_HEADER
  #error CSM_STACK_IP.H included several times
#endif // CSM_STACK_IP_HEADER

// ##################################################
// _CSM_SECTION_HISTORY: user specific code start
// ##################################################
/***************************************************************************************************
 * \doxydocu
 * \file          csm_stack_ip.h
 * \brief         Project specific part of the interface header(s) of the
 *                CAN stack.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESU3
 *
 * \sw_component  CAN stack
 * \project       nissan_lcn
 * \path          /di_can/modules_swa/csm_stack/src/
 *
 * \ingroup       CSM_STACK
 *
 * \authors       Borck, Proehl
 *
 * COPYRIGHT      (c) 2009 Bosch Car Multimedia GmbH
 *
 * \history_begin
 *
 * 21.09.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\1   A.Borck
 * - initial, generated version
 *
 * 22.09.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\2   A.Borck
 * - generated v850 comment added
 *
 * 24.09.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\3   A.Borck
 * - include file for cbr_al added (SLOT based CBR Signal Abstraction)
 * - most of the compatibility defines for iMX replaced by abstract signal defines from cbr_al
 *
 * 30.09.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\4   A.Borck
 * - some more compatibility defines added
 *
 * 01.10.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\5   A.Borck
 * - some adaptions in compatibility defines to identify invalid mappings
 *
 * 05.10.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\6   A.Borck
 * - version number set to 5 !!!
 *
 * 06.10.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\7   A.Borck
 * - signal to SLOT mismatch (invalid marker) for 2 signals fixed
 *
 * 08.10.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\8   A.Borck
 * - Mini Abstraction (CSM_S_CBR_ABSTRACT_SIGNALS) removed completely
 *
 * 13.10.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\9   A.Borck
 * - update due to changed generator template
 *
 * 14.10.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\10  A.Borck
 * - duplicated define in compatibility section fixed (will be removed anyway asap.)
 *
 * 21.10.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\11  A.Borck
 * - some signals removed (0x71E, 0x72E)
 * - v850 compatibility defines removed
 *
 * 26.10.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\12  A.Borck
 * - takeover and adaption of some Addressfields (from LCTRL NVM) for PDD datapool access
 *
 * 04.11.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\13  A.Borck
 * - version number set to 0x06 !!!
 * - new Timer IDs in ETG enum
 * - new MPDT Address Fields
 *
 * 11.11.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\14  A.Borck
 * - version number set to 7 since today is day 11 (taetae taetae taetae)
 * - addressfields for OSEKI synced and extended with v850
 *
 * 12.11.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\15  A.Borck
 * - small fix for oseki addressfields (sequence)
 *
 * 27.11.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\16  M.Proehl
 * - define CSM_C_DLC_RX_SLOT6_1F9_ECM_SystemControl changed to 6.
 *   Data base was changed by Nissan.
 *
 * 02.12.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\17  A.Borck
 * - New Sync with modified Generator Template and Input Tables
 *   -> DLC 5F7 from 8 to 5
 *   -> DLC 355 from 8 to 7
 *
 * 08.01.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\18  A.Borck
 * - OSEKI config extended by 2 MPDT channels for ITC and RSC
 * - new address fields for LCTR (KDS changed interface)
 *
 * 20.01.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\19  A.Borck
 * - Generator template adapted, some addr. fields adapted for common node abbrev. for automatic code generation
 *
 * 29.01.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\20  M.Proehl
 * - defines CSM_C_ADDRESS_FIELD_DP_RCSTYPE and CSM_C_ADDRESS_FIELD_DP_ITCOMMANDERTYPE added.
 *
 * 03.03.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\21  A.Borck
 * - new Sync with code generation tool chain
 * - SLOTs 0,1
 *
 * 03.03.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\22  A.Borck
 * - version number increased to 8
 *
 * 11.03.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\23  A.Borck
 * - Sync with new code generation tool chain
 * - SLOT 1 has 61 RX messages now (+ ISO, + XCP, 1 TX -> limit of 64 message boxes reached
 *
 * 15.03.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\24  M.Proehl
 * - CSM_C_VERSION set to 0x9C010009
 *
 * 17.03.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\25  M.Proehl
 * - CSM_C_VERSION set to 0x9C01000A
 * - Slot 3 is now generated.
 *
 * 22.03.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\26  M.Proehl
 * - CSM_C_VERSION set to 0x9C01000B
 * - Slot 3 is now generated. update
 *
 * 07.04.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\27  A.Borck
 * - Sync with updated template:
 *   - previous, manually added stuff is generated now
 *
 * 18.04.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\28  A.Borck
 * - Sync with updated template:
 *   - some compatibility defines removed
 *
 * 19.04.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\29  A.Borck
 * - new sync with updated generator files
 *
 * 26.05.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\30  A.Borck
 * - new code generation due to new database
 *
 * 14.06.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\31  A.Borck
 * - new code generation due to new database
 *
 * 20.06.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\32  A.Borck
 * - new code generation due to new database and features
 *
 * 28.07.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\33  M.Proehl
 * - new code generation from  https://hi-dms.de.bosch.com/docushare/dsweb/Get/Version-1266420/AbstractionMaster_Scope21.xlsx
 *   and https://hi-dms.de.bosch.com/docushare/dsweb/Get/Version-1265727/Translationtable_based_on_N-V01-01_A-IVI_V-CAN_Spec_v3.3.0.xlsx
 *
 * 08.08.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\34  M.Proehl
 * - new code generation due to latest delivery from Stephan and corrections from Tobias
 *
 * 16.08.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\35  A.Borck
 * - Check auf ueberlappende Signale innerhalb eines Frames (bzw. einer Multiplex-Gruppe) implementiert
 * - Generierung einer Textdatei mit Warnungen bei Coding-Meaning-Tabelleneintraegen, deren Format die Erzeugung einer
 *   Signal-Wertetabelle verhindern (relevant eigentlich nur fue CANoe)
 * - enthaelt die neueste AbstractionMaster-Tabelle (DocuShare V23) und TranslationTable_v3.3.0 (DocuShare V26) (beide im ZIP enthalten)
 *   mit signal-overlap-Korrekturen fuer Signale
 *
 * 25.08.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\36  A.Borck
 * - new code generation due to new database with SLOT 7
 *
 * 31.08.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\37  A.Borck
 * - bug fix due to missing signal in 0x350
 *
 * 19.09.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\38  A.Borck
 * - MPDT channel now supporting C-Type and D-Type data (here required timer enums added)
 *
 * 20.09.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\39  A.Borck
 * - some compatibility defines removed
 *
 * 21.09.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\40  A.Borck
 * - address fields for datapool access extended for CDA gateway enabler
 *
 * 21.10.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\41  A.Borck
 * - generated code is now based on database 3.4.0
 * - some signal compatibility defines added to be able to build (intermediate solution, to be reverted)
 * - version number set to 0x9C01000D
 *
 * 07.11.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\42  A.Borck
 * - manually fixed 2 LINT issues
 * - added 2 address fields for LCTRL
 *
 * 08.11.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\43  A.Borck
 * - new code generation due to new database
 *
 * 09.12.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\44  A.Borck
 * - native signal interface removed (moved to csm_stack_cbr_ip.h)
 *
 * 13.12.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\45  A.Borck
 * - some manually added, but marked as invalid, compatibility defines
 *
 * 16.01.17  \main\rn_aivi_proxy\rn_aivi_proxy_generated\46  A.Borck
 * - manually changed:
 *   -- some content moved to project specific, (internally used) variant file
 *   -- only interface stuff that is really used by other components is still located here
 *   -- some address fields extended due to new components (generic for all variants)
 *
 * 24.01.17  \main\rn_aivi_proxy\rn_aivi_proxy_generated\47  A.Borck
 * - manually changed:
 *   -- some content moved here from variant files, since identical and needed for proper ETG
 *
 * 27.01.17  \main\rn_aivi_proxy\rn_aivi_proxy_generated\49  A.Borck
 * - forgotten comment added:
 *   version 48 added interface for BS setting (ISO TP)
 *
 * 02.02.17  \main\rn_aivi_proxy\rn_aivi_proxy_generated\50  A.Borck
 * - MPDT component address field defines updated due to new MCAN components
 * - OSEKI monitor address field defines updated due to new MCAN components (MPDT TX)
 *
 * 15.05.17  \main\rn_aivi_proxy\rn_aivi_proxy_generated\51  A.Borck
 * - protocol type for ISO-TP added again, since now required for both variants !!
 * - enum for timer IDs extended to support the maximum of 11 INC NP channels
 * - new ISO-TP address fields added, (used for RIVIE and NPIVI)
 *
 * 31.05.17  \main\rn_aivi_proxy\rn_aivi_proxy_generated\52  A.Borck
 * - LINT issues fixed
 *
 * 22.06.17  \main\rn_aivi_proxy\rn_aivi_proxy_generated\53  A.Borck
 * - some ISO-TP address fields moved here
 *
 * 11.07.17  \main\rn_aivi_proxy\rn_aivi_proxy_generated\54  A.Borck
 * - added an abstrakt signal (compatibility define) with invalid marker to fix a compilation problem
 * - removed most of the compatibility defines
 *
 * 24.11.17  main\g3inf4cv_csm_proxy_in\1  Jayashree
 * - Initial version for INF4CV
 *
 **************************************************************************************************/
// ##################################################
// _CSM_SECTION_HISTORY: user specific code end
// ##################################################
