/*****************************************************************************/
/* CBR */
/*****************************************************************************/
/* ------------------------------------------------------------------------- */
/* copy generated CBR defines here */

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
#ifdef CSM_PROXY_SELF
const BYTE csm_arCbrNumberOfRxTelegrams[ CSM_C_MAX_CAN_BUS] =
{
    CBR_RX_MAX_NUMBER  /* Rx telegrams for bus 0 (CAN), value coming from Vector generated il_cfg.h */
};

const BYTE csm_arCbrNumberOfTxTelegrams[ CSM_C_MAX_CAN_BUS] =
{
    CBR_TX_MAX_NUMBER  /* Tx telegrams for bus 0 (CAN) */
};
#else
extern const BYTE csm_arCbrNumberOfRxTelegrams[ CSM_C_MAX_CAN_BUS];
extern const BYTE csm_arCbrNumberOfTxTelegrams[ CSM_C_MAX_CAN_BUS];
#endif /* CSM_PROXY_SELF */
#endif /* CSM_S_REMOTE_STACK == CSM_C_F_ON */

/* ------------------------------------------------------------------------- */

/*
    SS    SSSSS   S    S   SSSSS
   S  S   S       S    S    S   S
   S      S       SS   S    S    S
    S     SSS     S S  S    S    S
     S    S       S  SSS    S    S
      S   S       S   SS    S    S
   S  S   S       S    S    S   S
    SS    SSSSS   S    S   SSSSS


*/
/*************************************************************/
/* Handles of send objects                                   */
/*************************************************************/
#define CBR_C_ITM_State_TX_TEL_INDEX   0


/*************************************************************/
/* signal definitions in broadcast send telegrams            */
/*************************************************************/
/*****************************************************************************/
/*****************************************************************************/
/* CBR_C_ITM_State_TX_TEL_INDEX */
#define CSM_C_DLC_ITM_State                                            8
#define CSM_C_SIG_TX_ITM_State                                         CSM_M_MAKE_SIGNAL_ID(CBR_C_ITM_State_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_PrivacyResetAck_ITM_State                         CSM_M_MAKE_SIGNAL_ID(CBR_C_ITM_State_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_AccurateVehicleAutonomy_MM_ITM_State              CSM_M_MAKE_SIGNAL_ID(CBR_C_ITM_State_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_ActivityEvent_ITM_State                           CSM_M_MAKE_SIGNAL_ID(CBR_C_ITM_State_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_ONOFF_Request_ITM_State                           CSM_M_MAKE_SIGNAL_ID(CBR_C_ITM_State_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_TimeFormat_MM_ITM_State                           CSM_M_MAKE_SIGNAL_ID(CBR_C_ITM_State_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_LocalTime_MM_ITM_State                            CSM_M_MAKE_SIGNAL_ID(CBR_C_ITM_State_TX_TEL_INDEX, 6)




/*
   RRRR    RRRRR    RRRR   RRRRR    R    R     R   RRRRR
    R  R   R       R       R             R     R   R
    R   R  R       R       R        E     R   R    R
    R   R  RRR     R       RRR      R     R   R    RR
    RRRR   R       R       R        R      R R     R
    R  R   R       R       R        R      R R     R
    R   R  R       R       R        R       R      R
    R   R  RRRRR    RRRR   RRRRR   RRR      R      RRRRR


*/

/*************************************************************/
/* Handles of receive objects                               */
/*************************************************************/
#define CBR_C_MFD_PrivacyReset_RX_TEL_INDEX          0
#define CBR_C_GW_SpeedData_RX_TEL_INDEX              1
#define CBR_C_GW_Chassis_Data2_RX_TEL_INDEX          2
#define CBR_C_GW_RearCamInfo_RX_TEL_INDEX            3
#define CBR_C_GW_PositionInfo_RX_TEL_INDEX           4
#define CBR_C_RADIO_State_RX_TEL_INDEX               5
#define CBR_C_GW_DiagInfo_RX_TEL_INDEX               6
#define CBR_C_GW_RadioInfo_RX_TEL_INDEX              7
#define CBR_C_GW_MMI_Info1_RX_TEL_INDEX              8
#define CBR_C_GW_SEND_RX_TEL_INDEX                   9
#define CBR_C_GW_Chassis_Data3_RX_TEL_INDEX         10
#define CBR_C_GW_MMI_Info3_RX_TEL_INDEX             11

/*************************************************************/
/* signal definitions in broadcast receive telegrams         */
/*************************************************************/
/*****************************************************************************/
/*****************************************************************************/
/* CBR_C_MFD_PrivacyReset_RX_TEL_INDEX */
#define CSM_C_DLC_MFD_PrivacyReset                                     1
#define CSM_C_SIG_RX_MFD_PrivacyReset                                  CSM_M_MAKE_SIGNAL_ID(CBR_C_MFD_PrivacyReset_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_PrivacyResetReq_MFD_PrivacyReset                  CSM_M_MAKE_SIGNAL_ID(CBR_C_MFD_PrivacyReset_RX_TEL_INDEX, 1)

/*****************************************************************************/
/* CBR_C_GW_SpeedData_RX_TEL_INDEX */
#define CSM_C_DLC_GW_SpeedData                                         8
#define CSM_C_SIG_RX_GW_SpeedData                                      CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SpeedData_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_Rst_WheelSpeed_R_R_MM_GW_SpeedData                CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SpeedData_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_Rst_WheelSpeed_R_L_MM_GW_SpeedData                CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SpeedData_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_Rst_WheelSpeed_F_R_MM_GW_SpeedData                CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SpeedData_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_Rst_WheelSpeed_F_L_MM_GW_SpeedData                CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SpeedData_RX_TEL_INDEX, 4)

/*****************************************************************************/
/* CBR_C_GW_Chassis_Data2_RX_TEL_INDEX */
#define CSM_C_DLC_GW_Chassis_Data2                                     7
#define CSM_C_SIG_RX_GW_Chassis_Data2                                  CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_Chassis_Data2_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_Rst_Yawrate_MM_GW_Chassis_Data2                   CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_Chassis_Data2_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_Rst_TransversalAcceleration_MM_GW_Chassis_Data2   CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_Chassis_Data2_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_Rst_SteeringWheelSpeed_MM_GW_Chassis_Data2        CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_Chassis_Data2_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_Rst_LongitudinalAcceleration_MM_GW_Chassis_Data2  CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_Chassis_Data2_RX_TEL_INDEX, 4)

/*****************************************************************************/
/* CBR_C_GW_RearCamInfo_RX_TEL_INDEX */
#define CSM_C_DLC_GW_RearCamInfo                                       7
#define CSM_C_SIG_RX_GW_RearCamInfo                                    CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_RearCamInfo_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_SteeringWheelAngle_Offset_MM_GW_RearCamInfo       CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_RearCamInfo_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_SteeringWheelAngle_MM_GW_RearCamInfo              CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_RearCamInfo_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_SwaSensorInternalStatus_MM_GW_RearCamInfo         CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_RearCamInfo_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_RearGearEngaged_MM_GW_RearCamInfo                 CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_RearCamInfo_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_BootOpenWarning_MM_GW_RearCamInfo                 CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_RearCamInfo_RX_TEL_INDEX, 5)

/*****************************************************************************/
/* CBR_C_GW_PositionInfo_RX_TEL_INDEX */
#define CSM_C_DLC_GW_PositionInfo                                      5
#define CSM_C_SIG_RX_GW_PositionInfo                                   CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_PositionInfo_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_RearGearEngaged_MM_GW_PositionInfo                CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_PositionInfo_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_VehicleSpeed_MM_GW_PositionInfo                   CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_PositionInfo_RX_TEL_INDEX, 2)

/*****************************************************************************/
/* CBR_C_RADIO_State_RX_TEL_INDEX */
#define CSM_C_DLC_RADIO_State                                          4
#define CSM_C_SIG_RX_RADIO_State                                       CSM_M_MAKE_SIGNAL_ID(CBR_C_RADIO_State_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_RadioState_RADIO_State                            CSM_M_MAKE_SIGNAL_ID(CBR_C_RADIO_State_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_ActivityEvent_RADIO_State                         CSM_M_MAKE_SIGNAL_ID(CBR_C_RADIO_State_RX_TEL_INDEX, 2)

/*****************************************************************************/
/* CBR_C_GW_DiagInfo_RX_TEL_INDEX */
#define CSM_C_DLC_GW_DiagInfo                                          5
#define CSM_C_SIG_RX_GW_DiagInfo                                       CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_DiagInfo_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_DistanceTotalizer_MM_GW_DiagInfo                  CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_DiagInfo_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_NetworkDiag_MM_GW_DiagInfo                        CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_DiagInfo_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_ApplicationDiag_MM_GW_DiagInfo                    CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_DiagInfo_RX_TEL_INDEX, 3)

/*****************************************************************************/
/* CBR_C_GW_RadioInfo_RX_TEL_INDEX */
#define CSM_C_DLC_GW_RadioInfo                                         6
#define CSM_C_SIG_RX_GW_RadioInfo                                      CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_RadioInfo_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_VehicleID_MM_GW_RadioInfo                         CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_RadioInfo_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_VehicleSpeed_MM_GW_RadioInfo                      CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_RadioInfo_RX_TEL_INDEX, 2)

/*****************************************************************************/
/* CBR_C_GW_MMI_Info1_RX_TEL_INDEX */
#define CSM_C_DLC_GW_MMI_Info1                                         8
#define CSM_C_SIG_RX_GW_MMI_Info1                                      CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_RoofOpenningState_MM_GW_MMI_Info1                 CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_HVBatteryLow_MM_GW_MMI_Info1                      CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_SoundCommand_GW_MMI_Info1                         CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_TemperatureUnit_GW_MMI_Info1                      CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_SingleDoorOpeningActivationState_GW_MMI_Info1     CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_RearLeftDoorOpenWarning_MM_GW_MMI_Info1           CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_RearRightDoorOpenWarning_MM_GW_MMI_Info1          CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_AutomaticLockUpActivationState_GW_MMI_Info1       CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 8)
#define CSM_C_SIG_RX_RearWiperStatus_MM_GW_MMI_Info1                   CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 9)
#define CSM_C_SIG_RX_FrontRightDoorOpenWarning_MM_GW_MMI_Info1         CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 10)
#define CSM_C_SIG_RX_FrontLeftDoorOpenWarning_MM_GW_MMI_Info1          CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 11)
#define CSM_C_SIG_RX_LowBatteryWarning_MM_GW_MMI_Info1                 CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 12)
#define CSM_C_SIG_RX_LightSensorStatus_MM_GW_MMI_Info1                 CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 13)
#define CSM_C_SIG_RX_DayNightStatus_MM_GW_MMI_Info1                    CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 14)
#define CSM_C_SIG_RX_DisplayActivation_GW_MMI_Info1                    CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 15)
#define CSM_C_SIG_RX_TemperatureValue_GW_MMI_Info1                     CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 16)
#define CSM_C_SIG_RX_DimmingValue_GW_MMI_Info1                         CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info1_RX_TEL_INDEX, 17)

/*****************************************************************************/
/* CBR_C_GW_SEND_RX_TEL_INDEX */
#define CSM_C_DLC_GW_SEND                                              5
#define CSM_C_SIG_RX_GW_SEND                                           CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_VehicleOutsideLockedState_MM_GW_SEND              CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_UnballastRequest_MM_GW_SEND                       CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_SelectiveWakeUpType_MM_GW_SEND                    CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_MM_WakeUpSleepCommand_GW_SEND                     CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_IgnitionSupplyConfirmation_GW_SEND                CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_StopAutoState_MM_GW_SEND                          CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_WakeUpType_MM_GW_SEND                             CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_TechnicalWakeUpType_MM_GW_SEND                    CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 8)
#define CSM_C_SIG_RX_WelcomePhaseState_MM_GW_SEND                      CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 9)
#define CSM_C_SIG_RX_VehicleState_MM_GW_SEND                           CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 10)
#define CSM_C_SIG_RX_Offset_GW_SEND                                    CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 11)
#define CSM_C_SIG_RX_CustomerDeparture_GW_SEND                         CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 12)
#define CSM_C_SIG_RX_Opcode2_GW_SEND_GW_SEND                           CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 13)
#define CSM_C_SIG_RX_Dir_GW_SEND                                       CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 14)
#define CSM_C_SIG_RX_SatKey_GW_SEND                                    CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 15)
#define CSM_C_SIG_RX_SatCont_GW_SEND                                   CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 16)
#define CSM_C_SIG_RX_SatLong_GW_SEND                                   CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 17)
#define CSM_C_SIG_RX_WakeUpContext_GW_SEND                             CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 18)
#define CSM_C_SIG_RX_OnOffAction_GW_SEND                               CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 19)
#define CSM_C_SIG_RX_Opcode_GW_SEND_GW_SEND                            CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_SEND_RX_TEL_INDEX, 20)

/*****************************************************************************/
/* CBR_C_GW_Chassis_Data3_RX_TEL_INDEX */
#define CSM_C_DLC_GW_Chassis_Data3                                     8
#define CSM_C_SIG_RX_GW_Chassis_Data3                                  CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_Chassis_Data3_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_AccurateOdometer_MM_GW_Chassis_Data3              CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_Chassis_Data3_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_ClimateCoolingRequest_MM_GW_Chassis_Data3         CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_Chassis_Data3_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_GearLeverPosition_MM_GW_Chassis_Data3             CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_Chassis_Data3_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_EngineStatus_R_MM_GW_Chassis_Data3                CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_Chassis_Data3_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_ABSinRegulation_MM_GW_Chassis_Data3               CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_Chassis_Data3_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_EngineAirTemp_MM_GW_Chassis_Data3                 CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_Chassis_Data3_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_EngineCoolantTemp_MM_GW_Chassis_Data3             CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_Chassis_Data3_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_BrakingPressure_MM_GW_Chassis_Data3               CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_Chassis_Data3_RX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_GW_MMI_Info3_RX_TEL_INDEX */
#define CSM_C_DLC_GW_MMI_Info3                                         2
#define CSM_C_SIG_RX__GW_MMI_Info3                                     CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info3_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_SteeringPushToTalkCommand_MM_GW_MMI_Info3         CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info3_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_ExternalTempRaw_MM_GW_MMI_Info3                   CSM_M_MAKE_SIGNAL_ID(CBR_C_GW_MMI_Info3_RX_TEL_INDEX, 2)

/*****************************************************************************/
/* ------------------------------------------------------------------------- */
/* end of copy generated CBR defines here */
/* ------------------------------------------------------------------------- */
