/*****************************************************************************/
/* CBR */
/*****************************************************************************/
/* ------------------------------------------------------------------------- */
/* copy generated CBR defines here */

#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
#ifdef CSM_PROXY_SELF
const BYTE csm_arCbrNumberOfRxTelegrams[ CSM_C_MAX_CAN_BUS] =
{
    CBR_RX_MAX_NUMBER  /* Rx telegrams for bus 0 (CAN), value coming from Vector generated il_cfg.h */
};

const BYTE csm_arCbrNumberOfTxTelegrams[ CSM_C_MAX_CAN_BUS] =
{
    CBR_TX_MAX_NUMBER  /* Tx telegrams for bus 0 (CAN) */
};
#else
extern const BYTE csm_arCbrNumberOfRxTelegrams[ CSM_C_MAX_CAN_BUS];
extern const BYTE csm_arCbrNumberOfTxTelegrams[ CSM_C_MAX_CAN_BUS];
#endif /* CSM_PROXY_SELF */
#endif /* CSM_S_REMOTE_STACK == CSM_C_F_ON */

/* ------------------------------------------------------------------------- */

/*
    SS    SSSSS   S    S   SSSSS
   S  S   S       S    S    S   S
   S      S       SS   S    S    S
    S     SSS     S S  S    S    S
     S    S       S  SSS    S    S
      S   S       S   SS    S    S
   S  S   S       S    S    S   S
    SS    SSSSS   S    S   SSSSS


*/
/*************************************************************/
/* Handles of send objects                                   */
/*************************************************************/
/* VCAN */
#define CBR_C_PhoneStatus_TX_TEL_INDEX              0
#define CBR_C_MediaStatus2_TX_TEL_INDEX             1
#define CBR_C_MediaStatus1_TX_TEL_INDEX             2
#define CBR_C_DeviceStatus_TX_TEL_INDEX             3
#define CBR_C_Camera_Status_TX_TEL_INDEX            4
#define CBR_C_Display_Mainline_TX_TEL_INDEX         5
#define CBR_C_CabinMedia_Status_TX_TEL_INDEX        6
#define CBR_C_CabinB_Media_Status_TX_TEL_INDEX      7
#define CBR_C_VehiclePositionNav_TX_TEL_INDEX       8

/* MCAN */
#define CBR_C_KeyIllumination1_TX_TEL_INDEX         9
#define CBR_C_KeyIllumination0_TX_TEL_INDEX        10
#define CBR_C_KeyColour1_TX_TEL_INDEX              11
#define CBR_C_KeyColour0_TX_TEL_INDEX              12
#define CBR_C_Req_DeviceInformation_TX_TEL_INDEX   13

//**************************************************************************************************
// Signal Definitions Handled in broadcast TX telegrams
//**************************************************************************************************

/* CBR_C_PhoneStatus_TX_TEL_INDEX */
#define CSM_C_DLC_PhoneStatus                                        8
#define CSM_C_SIG_TX_PhoneStatus                                     CSM_M_MAKE_SIGNAL_ID(CBR_C_PhoneStatus_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Roaming_PhoneStatus                             CSM_M_MAKE_SIGNAL_ID(CBR_C_PhoneStatus_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_CallDuration_PhoneStatus                        CSM_M_MAKE_SIGNAL_ID(CBR_C_PhoneStatus_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_PhoneBatteryLevel_PhoneStatus                   CSM_M_MAKE_SIGNAL_ID(CBR_C_PhoneStatus_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_GSMFieldstrength_PhoneStatus                    CSM_M_MAKE_SIGNAL_ID(CBR_C_PhoneStatus_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_CallHistorySyncStatus_PhoneStatus               CSM_M_MAKE_SIGNAL_ID(CBR_C_PhoneStatus_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_PhonebookSyncStatus_PhoneStatus                 CSM_M_MAKE_SIGNAL_ID(CBR_C_PhoneStatus_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_CallStatus_PhoneStatus                          CSM_M_MAKE_SIGNAL_ID(CBR_C_PhoneStatus_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_BTlinkStatus_PhoneStatus                        CSM_M_MAKE_SIGNAL_ID(CBR_C_PhoneStatus_TX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_MediaStatus2_TX_TEL_INDEX */
#define CSM_C_DLC_MediaStatus2                                       8
#define CSM_C_SIG_TX_MediaStatus2                                    CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus2_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_CurrTrackNum_MediaStatus2                       CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus2_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_PlaylistMode_MediaStatus2                       CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus2_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_RepeatState_MediaStatus2                        CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus2_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_MixState_MediaStatus2                           CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus2_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_SeekState_MediaStatus2                          CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus2_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_PlayState_MediaStatus2                          CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus2_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_TrackTime_MediaStatus2                          CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus2_TX_TEL_INDEX, 7)

/*****************************************************************************/
/* CBR_C_MediaStatus1_TX_TEL_INDEX */
#define CSM_C_DLC_MediaStatus1                                       8
#define CSM_C_SIG_TX_MediaStatus1                                    CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus1_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_TunerPreset_MediaStatus1                        CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus1_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_TunerBand_MediaStatus1                          CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus1_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_DABFMstatus_MediaStatus1                        CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus1_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_TPEGRTMstatus_MediaStatus1                      CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus1_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_TPEGstatus_MediaStatus1                         CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus1_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_TAstatus_MediaStatus1                           CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus1_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_TPstatus_MediaStatus1                           CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus1_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_RDSstatus_MediaStatus1                          CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus1_TX_TEL_INDEX, 8)
#define CSM_C_SIG_TX_Volume_MediaStatus1                             CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus1_TX_TEL_INDEX, 9)
#define CSM_C_SIG_TX_MuteStatus_MediaStatus1                         CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus1_TX_TEL_INDEX, 10)
#define CSM_C_SIG_TX_AudioSource_MediaStatus1                        CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaStatus1_TX_TEL_INDEX, 11)

/*****************************************************************************/
/* CBR_C_DeviceStatus_TX_TEL_INDEX */
#define CSM_C_DLC_DeviceStatus                                       8
#define CSM_C_SIG_TX_DeviceStatus                                    CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Radio_Status_DeviceStatus                       CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_Wifi_Status_DeviceStatus                        CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_BluetoothStatus_DeviceStatus                    CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_NavData_Present_DeviceStatus                    CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_Camera2_Present_DeviceStatus                    CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_Camera1_Present_DeviceStatus                    CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_SDcard2_Present_DeviceStatus                    CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_SDcard1_Present_DeviceStatus                    CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 8)
#define CSM_C_SIG_TX_USB2_Present_DeviceStatus                       CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 9)
#define CSM_C_SIG_TX_USB1_Present_DeviceStatus                       CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 10)
#define CSM_C_SIG_TX_AUX2_PlugPresent_DeviceStatus                   CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 11)
#define CSM_C_SIG_TX_AUX1_PlugPresent_DeviceStatus                   CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 12)
#define CSM_C_SIG_TX_CD_Present_DeviceStatus                         CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 13)
#define CSM_C_SIG_TX_Wifi_Avail_DeviceStatus                         CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 14)
#define CSM_C_SIG_TX_Navigation_Avail_DeviceStatus                   CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 15)
#define CSM_C_SIG_TX_Phone_Avail_DeviceStatus                        CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 16)
#define CSM_C_SIG_TX_SourceCamera2_Avail_DeviceStatus                CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 17)
#define CSM_C_SIG_TX_SourceCamera1_Avail_DeviceStatus                CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 18)
#define CSM_C_SIG_TX_SourceBluetooth_Avail_DeviceStatus              CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 19)
#define CSM_C_SIG_TX_SourceSDcard2_Avail_DeviceStatus                CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 20)
#define CSM_C_SIG_TX_SourceSDcard1_Avail_DeviceStatus                CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 21)
#define CSM_C_SIG_TX_SourceUSB2_Avail_DeviceStatus                   CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 22)
#define CSM_C_SIG_TX_SourceUSB1_Avail_DeviceStatus                   CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 23)
#define CSM_C_SIG_TX_SourceAUX2_Avail_DeviceStatus                   CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 24)
#define CSM_C_SIG_TX_SourceAUX1_Avail_DeviceStatus                   CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 25)
#define CSM_C_SIG_TX_SourceCD_Avail_DeviceStatus                     CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 26)
#define CSM_C_SIG_TX_SourceDAB_Avail_DeviceStatus                    CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 27)
#define CSM_C_SIG_TX_SourceAMFM_Avail_DeviceStatus                   CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 28)
#define CSM_C_SIG_TX_Phone_VR_Avail_DeviceStatus                     CSM_M_MAKE_SIGNAL_ID(CBR_C_DeviceStatus_TX_TEL_INDEX, 29)

/*****************************************************************************/
/* CBR_C_Camera_Status_TX_TEL_INDEX */
#define CSM_C_DLC_Camera_Status                                      8
#define CSM_C_SIG_TX_Camera_Status                                   CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Camera17_Status_Camera_Status                   CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_Camera16_Status_Camera_Status                   CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_Camera15_Status_Camera_Status                   CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_Camera14_Status_Camera_Status                   CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_Camera13_Status_Camera_Status                   CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_Camera12_Status_Camera_Status                   CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_Camera11_Status_Camera_Status                   CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_Camera10_Status_Camera_Status                   CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 8)
#define CSM_C_SIG_TX_Camera9_Status_Camera_Status                    CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 9)
#define CSM_C_SIG_TX_Camera8_Status_Camera_Status                    CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 10)
#define CSM_C_SIG_TX_Camera7_Status_Camera_Status                    CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 11)
#define CSM_C_SIG_TX_Camera6_Status_Camera_Status                    CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 12)
#define CSM_C_SIG_TX_Camera5_Status_Camera_Status                    CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 13)
#define CSM_C_SIG_TX_Camera4_Status_Camera_Status                    CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 14)
#define CSM_C_SIG_TX_Camera3_Status_Camera_Status                    CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 15)
#define CSM_C_SIG_TX_Camera2_Status_Camera_Status                    CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 16)
#define CSM_C_SIG_TX_Camera1_Status_Camera_Status                    CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 17)
#define CSM_C_SIG_TX_DisplayCameraCIs_Rq_Camera_Status               CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Status_TX_TEL_INDEX, 18)

/*****************************************************************************/
/* CBR_C_Display_Mainline_TX_TEL_INDEX */
#define CSM_C_DLC_Display_Mainline                                   8
#define CSM_C_SIG_TX_Display_Mainline                                CSM_M_MAKE_SIGNAL_ID(CBR_C_Display_Mainline_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Mainline_Char8_Display_Mainline                 CSM_M_MAKE_SIGNAL_ID(CBR_C_Display_Mainline_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_Mainline_Char7_Display_Mainline                 CSM_M_MAKE_SIGNAL_ID(CBR_C_Display_Mainline_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_Mainline_Char6_Display_Mainline                 CSM_M_MAKE_SIGNAL_ID(CBR_C_Display_Mainline_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_Mainline_Char5_Display_Mainline                 CSM_M_MAKE_SIGNAL_ID(CBR_C_Display_Mainline_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_Mainline_Char4_Display_Mainline                 CSM_M_MAKE_SIGNAL_ID(CBR_C_Display_Mainline_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_Mainline_Char3_Display_Mainline                 CSM_M_MAKE_SIGNAL_ID(CBR_C_Display_Mainline_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_Mainline_Char2_Display_Mainline                 CSM_M_MAKE_SIGNAL_ID(CBR_C_Display_Mainline_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_Mainline_Char1_Display_Mainline                 CSM_M_MAKE_SIGNAL_ID(CBR_C_Display_Mainline_TX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_CabinMedia_Status_TX_TEL_INDEX */
#define CSM_C_DLC_CabinMedia_Status                                  8
#define CSM_C_SIG_TX_CabinMedia_Status                               CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMedia_Status_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_RepeatState_CabinMedia_Status                   CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMedia_Status_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_MixState_CabinMedia_Status                      CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMedia_Status_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_SeekState_CabinMedia_Status                     CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMedia_Status_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_PlayState_CabinMedia_Status                     CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMedia_Status_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_TrackTime_CabinMedia_Status                     CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMedia_Status_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_PlaylistMode_CabinMedia_Status                  CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMedia_Status_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_TunerPreset_CabinMedia_Status                   CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMedia_Status_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_TunerBand_CabinMedia_Status                     CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMedia_Status_TX_TEL_INDEX, 8)
#define CSM_C_SIG_TX_Cabin_vol_CabinMedia_Status                     CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMedia_Status_TX_TEL_INDEX, 9)
#define CSM_C_SIG_TX_CabinMute_Status_CabinMedia_Status              CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMedia_Status_TX_TEL_INDEX, 10)
#define CSM_C_SIG_TX_CabinAudioSource_CabinMedia_Status              CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMedia_Status_TX_TEL_INDEX, 11)
#define CSM_C_SIG_TX_Drv_Announcement_CabinMedia_Status              CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMedia_Status_TX_TEL_INDEX, 12)

/*****************************************************************************/
/* CBR_C_CabinB_Media_Status_TX_TEL_INDEX */
#define CSM_C_DLC_CabinB_Media_Status                                8
#define CSM_C_SIG_TX_CabinB_Media_Status                             CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinB_Media_Status_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_CabinB_AudioSource_CabinB_Media_Status          CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinB_Media_Status_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_CabinB_Repeat_State_CabinB_Media_Status         CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinB_Media_Status_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_CabinB_Mix_State_CabinB_Media_Status            CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinB_Media_Status_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_CabinB_Seek_State_CabinB_Media_Status           CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinB_Media_Status_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_CabinB_Play_State_CabinB_Media_Status           CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinB_Media_Status_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_CabinB_Track_Time_CabinB_Media_Status           CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinB_Media_Status_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_CabinB_PlaylistMode_CabinB_Media_Status         CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinB_Media_Status_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_CabinB_Tuner_PresetStation_CabinB_Media_Status  CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinB_Media_Status_TX_TEL_INDEX, 8)
#define CSM_C_SIG_TX_CabinB_Tuner_Band_CabinB_Media_Status           CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinB_Media_Status_TX_TEL_INDEX, 9)
#define CSM_C_SIG_TX_CabinB_Vol_CabinB_Media_Status                  CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinB_Media_Status_TX_TEL_INDEX, 10)
#define CSM_C_SIG_TX_CabinB_Mute_Status_CabinB_Media_Status          CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinB_Media_Status_TX_TEL_INDEX, 11)
#define CSM_C_SIG_TX_CabinB_DrvAnnouncement_CabinB_Media_Status      CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinB_Media_Status_TX_TEL_INDEX, 12)

/*****************************************************************************/
/* CBR_C_VehiclePositionNav_TX_TEL_INDEX */
#define CSM_C_DLC_VehiclePositionNav                                 8
#define CSM_C_SIG_TX_VehiclePositionNav                              CSM_M_MAKE_SIGNAL_ID(CBR_C_VehiclePositionNav_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Longitude_VehiclePositionNav                    CSM_M_MAKE_SIGNAL_ID(CBR_C_VehiclePositionNav_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_Latitude_VehiclePositionNav                     CSM_M_MAKE_SIGNAL_ID(CBR_C_VehiclePositionNav_TX_TEL_INDEX, 2)

/*****************************************************************************/
/*CAN2*/
/* CBR_C_KeyIllumination1_TX_TEL_INDEX */
#define CSM_C_DLC_KeyIllumination1                                    8
#define CSM_C_SIG_TX_KeyIllumination1                                 CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Reserved0_KeyIllumination1                       CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_Reserved1_KeyIllumination1                       CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_Encoder2_Illumination_KeyIllumination1           CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_Encoder1_Illumination_KeyIllumination1           CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_Key12_Illumination_KeyIllumination1              CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_Key11_Illumination_KeyIllumination1              CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_Key10_Illumination_KeyIllumination1              CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_Key9_Illumination_KeyIllumination1               CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination1_TX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_KeyIllumination0_TX_TEL_INDEX */
#define CSM_C_DLC_KeyIllumination0                                    8
#define CSM_C_SIG_TX_KeyIllumination0                                 CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Key8_Illumination_KeyIllumination0               CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_Key7_Illumination_KeyIllumination0               CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_Key6_Illumination_KeyIllumination0               CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_Key5_Illumination_KeyIllumination0               CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_Key4_Illumination_KeyIllumination0               CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_Key3_Illumination_KeyIllumination0               CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_Key2_Illumination_KeyIllumination0               CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_Key1_Illumination_KeyIllumination0               CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyIllumination0_TX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_KeyColour1_TX_TEL_INDEX */
#define CSM_C_DLC_KeyColour1                                          8
#define CSM_C_SIG_TX_KeyColour1                                       CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Reserved0_KeyColour1                             CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_Reserved1_KeyColour1                             CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_Enconder2_Colour_KeyColour1                      CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_Enconder1_Colour_KeyColour1                      CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_Key12_Colour_KeyColour1                          CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_Key11_Colour_KeyColour1                          CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_Key9_Colour_KeyColour1                           CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_Key10_Colour_KeyColour1                          CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour1_TX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_KeyColour0_TX_TEL_INDEX */
#define CSM_C_DLC_KeyColour0                                          8
#define CSM_C_SIG_TX_KeyColour0                                       CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Key8_Colour_KeyColour0                           CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 1)
#define CSM_C_SIG_TX_Key7_Colour_KeyColour0                           CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 2)
#define CSM_C_SIG_TX_Key6_Colour_KeyColour0                           CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 3)
#define CSM_C_SIG_TX_Key5_Colour_KeyColour0                           CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 4)
#define CSM_C_SIG_TX_Key4_Colour_KeyColour0                           CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 5)
#define CSM_C_SIG_TX_Key3_Colour_KeyColour0                           CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 6)
#define CSM_C_SIG_TX_Key2_Colour_KeyColour0                           CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 7)
#define CSM_C_SIG_TX_Key1_Colour_KeyColour0                           CSM_M_MAKE_SIGNAL_ID(CBR_C_KeyColour0_TX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_Req_DeviceInformation_TX_TEL_INDEX */
#define CSM_C_DLC_Req_DeviceInformation                               1
#define CSM_C_SIG_TX_Req_DeviceInformation                            CSM_M_MAKE_SIGNAL_ID(CBR_C_Req_DeviceInformation_TX_TEL_INDEX, 0)
#define CSM_C_SIG_TX_Req_DeviceInformation_Req_DeviceInformation      CSM_M_MAKE_SIGNAL_ID(CBR_C_Req_DeviceInformation_TX_TEL_INDEX, 1)



/*
   RRRR    RRRRR    RRRR   RRRRR    R    R     R   RRRRR
    R  R   R       R       R             R     R   R
    R   R  R       R       R        E     R   R    R
    R   R  RRR     R       RRR      R     R   R    RR
    RRRR   R       R       R        R      R R     R
    R  R   R       R       R        R      R R     R
    R   R  R       R       R        R       R      R
    R   R  RRRRR    RRRR   RRRRR   RRR      R      RRRRR
*/

/*************************************************************/
/* Handles of receive objects                               */
/*************************************************************/
#define CBR_C_MediaCommand_RX_TEL_INDEX                     0
#define CBR_C_SystemEnvironment_RX_TEL_INDEX                1
#define CBR_C_CruiseControl_RX_TEL_INDEX                    2
#define CBR_C_AmbientConditions_RX_TEL_INDEX                3
#define CBR_C_VehicleWeight_RX_TEL_INDEX                    4
#define CBR_C_VehiclePosition_RX_TEL_INDEX                  5
#define CBR_C_ETC5_RX_TEL_INDEX                             6
#define CBR_C_TCO1_RX_TEL_INDEX                             7
#define CBR_C_TimeDate_RX_TEL_INDEX                         8
#define CBR_C_RemoteControl_RX_TEL_INDEX                    9
#define CBR_C_Illumination_RX_TEL_INDEX                    10
#define CBR_C_SystemEnvironmentExtended_RX_TEL_INDEX       11
#define CBR_C_Camera_Request_RX_TEL_INDEX                  12
#define CBR_C_CabinMediaCommand_RX_TEL_INDEX               13

/*CAN2*/
#define CBR_C_Remotecontrol_RX_TEL_INDEX                   14
#define CBR_C_Resp_DeviceInformation2_RX_TEL_INDEX         15
#define CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX         16


/*************************************************************/
/* signal definitions in broadcast receive telegrams         */
/*************************************************************/

/* CBR_C_MediaCommand_RX_TEL_INDEX */
#define CSM_C_DLC_MediaCommand                                           8
#define CSM_C_SIG_RX_MediaCommand                                        CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaCommand_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_Voice_recognition_command_MediaCommand              CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaCommand_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_TrackCmd_MediaCommand                               CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaCommand_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_PhoneCallCmd_MediaCommand                           CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaCommand_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_PhonePwrCmd_MediaCommand                            CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaCommand_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_PlaylistCmd_MediaCommand                            CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaCommand_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_RDScmd_MediaCommand                                 CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaCommand_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_TAcmd_MediaCommand                                  CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaCommand_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_TunerCmd_MediaCommand                               CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaCommand_RX_TEL_INDEX, 8)
#define CSM_C_SIG_RX_VolumeCmd_MediaCommand                              CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaCommand_RX_TEL_INDEX, 9)
#define CSM_C_SIG_RX_SourceCmd_MediaCommand                              CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaCommand_RX_TEL_INDEX, 10)
#define CSM_C_SIG_RX_RadioPwrCmd_MediaCommand                            CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaCommand_RX_TEL_INDEX, 11)
#define CSM_C_SIG_RX_Smartphone_Voice_Recognition_MediaCommand           CSM_M_MAKE_SIGNAL_ID(CBR_C_MediaCommand_RX_TEL_INDEX, 12)

/*****************************************************************************/
/* CBR_C_SystemEnvironment_RX_TEL_INDEX */
#define CSM_C_DLC_SystemEnvironment                                      8
#define CSM_C_SIG_RX_SystemEnvironment                                   CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironment_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_Time_Mode_SystemEnvironment                         CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironment_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_Dimming_Mode_SystemEnvironment                      CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironment_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_FrontCamReq_SystemEnvironment                       CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironment_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_RearCamReq_SystemEnvironment                        CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironment_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_CamouflageMode_SystemEnvironment                    CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironment_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_SystemMute_SystemEnvironment                        CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironment_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_DistanceScale_SystemEnvironment                     CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironment_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_TemperatureScale_SystemEnvironment                  CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironment_RX_TEL_INDEX, 8)
#define CSM_C_SIG_RX_SystemLanguage_SystemEnvironment                    CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironment_RX_TEL_INDEX, 9)
#define CSM_C_SIG_RX_VehicleMileage_SystemEnvironment                    CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironment_RX_TEL_INDEX, 10)


/*****************************************************************************/
/* CBR_C_CruiseControl_RX_TEL_INDEX */
#define CSM_C_DLC_CruiseControl                                          8
#define CSM_C_SIG_RX_CruiseControl                                       CSM_M_MAKE_SIGNAL_ID(CBR_C_CruiseControl_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_VehicleSpeed_CruiseControl                          CSM_M_MAKE_SIGNAL_ID(CBR_C_CruiseControl_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_ParkingBreakSwitch_CruiseControl                    CSM_M_MAKE_SIGNAL_ID(CBR_C_CruiseControl_RX_TEL_INDEX, 2)

/*****************************************************************************/
/* CBR_C_AmbientConditions_RX_TEL_INDEX */
#define CSM_C_DLC_AmbientConditions                                      8
#define CSM_C_SIG_RX_AmbientConditions                                   CSM_M_MAKE_SIGNAL_ID(CBR_C_AmbientConditions_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_AmbientAirTemp_AmbientConditions                    CSM_M_MAKE_SIGNAL_ID(CBR_C_AmbientConditions_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_CabInteriorTemp_AmbientConditions                   CSM_M_MAKE_SIGNAL_ID(CBR_C_AmbientConditions_RX_TEL_INDEX, 2)

/*****************************************************************************/
/* CBR_C_VehicleWeight_RX_TEL_INDEX */
#define CSM_C_DLC_VehicleWeight                                          8
#define CSM_C_SIG_RX_VehicleWeight                                       CSM_M_MAKE_SIGNAL_ID(CBR_C_VehicleWeight_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_CargoWeight_VehicleWeight                           CSM_M_MAKE_SIGNAL_ID(CBR_C_VehicleWeight_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_TrailerWeight_VehicleWeight                         CSM_M_MAKE_SIGNAL_ID(CBR_C_VehicleWeight_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_AxleWeight_VehicleWeight                            CSM_M_MAKE_SIGNAL_ID(CBR_C_VehicleWeight_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_AxleLocation_VehicleWeight                          CSM_M_MAKE_SIGNAL_ID(CBR_C_VehicleWeight_RX_TEL_INDEX, 4)

/*****************************************************************************/
/* CBR_C_VehiclePosition_RX_TEL_INDEX */
#define CSM_C_DLC_VehiclePosition                                        8
#define CSM_C_SIG_RX_VehiclePosition                                     CSM_M_MAKE_SIGNAL_ID(CBR_C_VehiclePosition_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_Longitude_VehiclePosition                           CSM_M_MAKE_SIGNAL_ID(CBR_C_VehiclePosition_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_Latitude_VehiclePosition                            CSM_M_MAKE_SIGNAL_ID(CBR_C_VehiclePosition_RX_TEL_INDEX, 2)

/*****************************************************************************/
/* CBR_C_ETC5_RX_TEL_INDEX */
#define CSM_C_DLC_ETC5                                                   8
#define CSM_C_SIG_RX_ETC5                                                CSM_M_MAKE_SIGNAL_ID(CBR_C_ETC5_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_ReverseSwitch_ETC5                                  CSM_M_MAKE_SIGNAL_ID(CBR_C_ETC5_RX_TEL_INDEX, 1)

/*****************************************************************************/
/* CBR_C_TCO1_RX_TEL_INDEX */
#define CSM_C_DLC_TCO1                                                   8
#define CSM_C_SIG_RX_TCO1                                                CSM_M_MAKE_SIGNAL_ID(CBR_C_TCO1_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_TCOVehSpeed_TCO1                                    CSM_M_MAKE_SIGNAL_ID(CBR_C_TCO1_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_DirectionIndicator_TCO1                             CSM_M_MAKE_SIGNAL_ID(CBR_C_TCO1_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_DriverCard1_TCO1                                    CSM_M_MAKE_SIGNAL_ID(CBR_C_TCO1_RX_TEL_INDEX, 3)

/*****************************************************************************/
/* CBR_C_TimeDate_RX_TEL_INDEX */
#define CSM_C_DLC_TimeDate                                               8
#define CSM_C_SIG_RX_TimeDate                                            CSM_M_MAKE_SIGNAL_ID(CBR_C_TimeDate_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_LocalOffsetHour_TimeDate                            CSM_M_MAKE_SIGNAL_ID(CBR_C_TimeDate_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_LocalOffsetMinute_TimeDate                          CSM_M_MAKE_SIGNAL_ID(CBR_C_TimeDate_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_Year_TimeDate                                       CSM_M_MAKE_SIGNAL_ID(CBR_C_TimeDate_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_Day_TimeDate                                        CSM_M_MAKE_SIGNAL_ID(CBR_C_TimeDate_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_Month_TimeDate                                      CSM_M_MAKE_SIGNAL_ID(CBR_C_TimeDate_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_Hours_TimeDate                                      CSM_M_MAKE_SIGNAL_ID(CBR_C_TimeDate_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_Minutes_TimeDate                                    CSM_M_MAKE_SIGNAL_ID(CBR_C_TimeDate_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_Seconds_TimeDate                                    CSM_M_MAKE_SIGNAL_ID(CBR_C_TimeDate_RX_TEL_INDEX, 8)

/*****************************************************************************/
/* CBR_C_RemoteControl_RX_TEL_INDEX */
#define CSM_C_DLC_RemoteControl                                          8
#define CSM_C_SIG_RX_RemoteControl                                       CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_Button_Hash_RemoteControl                           CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_Button_Star_RemoteControl                           CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_Button_Voice_RemoteControl                          CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_Button_9_RemoteControl                              CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_Button_8_RemoteControl                              CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_Button_7_RemoteControl                              CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_Button_6_RemoteControl                              CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_Button_5_RemoteControl                              CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 8)
#define CSM_C_SIG_RX_Button_4_RemoteControl                              CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 9)
#define CSM_C_SIG_RX_Button_3_RemoteControl                              CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 10)
#define CSM_C_SIG_RX_Button_2_RemoteControl                              CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 11)
#define CSM_C_SIG_RX_Button_0_RemoteControl                              CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 12)
#define CSM_C_SIG_RX_Button_1_RemoteControl                              CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 13)
#define CSM_C_SIG_RX_Button_Traffic_RemoteControl                        CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 14)
#define CSM_C_SIG_RX_Button_Map_RemoteControl                            CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 15)
#define CSM_C_SIG_RX_Button_Navi_RemoteControl                           CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 16)
#define CSM_C_SIG_RX_Button_Phone_RemoteControl                          CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 17)
#define CSM_C_SIG_RX_Button_Media_RemoteControl                          CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 18)
#define CSM_C_SIG_RX_Button_Tuner_RemoteControl                          CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 19)
#define CSM_C_SIG_RX_Button_Previous_RemoteControl                       CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 20)
#define CSM_C_SIG_RX_Button_Next_RemoteControl                           CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 21)
#define CSM_C_SIG_RX_Button_Back_RemoteControl                           CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 22)
#define CSM_C_SIG_RX_Button_Setup_RemoteControl                          CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 23)
#define CSM_C_SIG_RX_Button_Home_RemoteControl                           CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 24)
#define CSM_C_SIG_RX_Encoder_Volume_RemoteControl                        CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 25)
#define CSM_C_SIG_RX_Button_Mute_RemoteControl                           CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 26)
#define CSM_C_SIG_RX_Button_VolumeDown_RemoteControl                     CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 27)
#define CSM_C_SIG_RX_Button_VolumeUp_RemoteControl                       CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 28)
#define CSM_C_SIG_RX_Button_OnOff_RemoteControl                          CSM_M_MAKE_SIGNAL_ID(CBR_C_RemoteControl_RX_TEL_INDEX, 29)

/*****************************************************************************/
/* CBR_C_Illumination_RX_TEL_INDEX */
#define CSM_C_DLC_Illumination                                           8
#define CSM_C_SIG_RX_Illumination                                        CSM_M_MAKE_SIGNAL_ID(CBR_C_Illumination_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_Key_Illumination_Illumination                       CSM_M_MAKE_SIGNAL_ID(CBR_C_Illumination_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_Illumination_Illumination                           CSM_M_MAKE_SIGNAL_ID(CBR_C_Illumination_RX_TEL_INDEX, 2)

/*****************************************************************************/
/* CBR_C_SystemEnvironmentExtended_RX_TEL_INDEX */
#define CSM_C_DLC_SystemEnvironmentExtended                              8
#define CSM_C_SIG_RX_SystemEnvironmentExtended                           CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironmentExtended_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_Locking_Status_SystemEnvironmentExtended            CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironmentExtended_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_Passenger_DOOR_Status_SystemEnvironmentExtended     CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironmentExtended_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_Driver_DOORStatus_SystemEnvironmentExtended         CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironmentExtended_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_Date_Mode_SystemEnvironmentExtended                 CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironmentExtended_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_Camera_Split_Quad_Stat_SystemEnvironmentExtended    CSM_M_MAKE_SIGNAL_ID(CBR_C_SystemEnvironmentExtended_RX_TEL_INDEX, 5)

/*****************************************************************************/
/* CBR_C_Camera_Request_RX_TEL_INDEX */
#define CSM_C_DLC_Camera_Request                                         8
#define CSM_C_SIG_RX_Camera_Request                                      CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_Camera17_Req_Camera_Request                         CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_Camera16_Req_Camera_Request                         CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_Camera15_Req_Camera_Request                         CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_Camera14_Req_Camera_Request                         CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_Camera13_Req_Camera_Request                         CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_Camera12_Req_Camera_Request                         CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_Camera11_Req_Camera_Request                         CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_Camera10_Req_Camera_Request                         CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 8)
#define CSM_C_SIG_RX_Camera9_Req_Camera_Request                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 9)
#define CSM_C_SIG_RX_Camera8_Req_Camera_Request                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 10)
#define CSM_C_SIG_RX_Camera7_Req_Camera_Request                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 11)
#define CSM_C_SIG_RX_Camera6_Req_Camera_Request                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 12)
#define CSM_C_SIG_RX_Camera5_Req_Camera_Request                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 13)
#define CSM_C_SIG_RX_Camera4_Req_Camera_Request                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 14)
#define CSM_C_SIG_RX_Camera3_Req_Camera_Request                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 15)
#define CSM_C_SIG_RX_Camera2_Req_Camera_Request                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 16)
#define CSM_C_SIG_RX_Camera1_Req_Camera_Request                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Camera_Request_RX_TEL_INDEX, 17)

/*****************************************************************************/
/* CBR_C_CabinMediaCommand_RX_TEL_INDEX */
#define CSM_C_DLC_CabinMediaCommand                                      8
#define CSM_C_SIG_RX_CabinMediaCommand                                   CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMediaCommand_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_CabinPlaylistCmd_CabinMediaCommand                  CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMediaCommand_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_Cabin_TrackCommand_CabinMediaCommand                CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMediaCommand_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_Cabin_Tuner_Command_CabinMediaCommand               CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMediaCommand_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_Cabin_Volume_Command_CabinMediaCommand              CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMediaCommand_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_Cabin_Source_Command_CabinMediaCommand              CSM_M_MAKE_SIGNAL_ID(CBR_C_CabinMediaCommand_RX_TEL_INDEX, 5)

/*****************************************************************************/
/* CBR_C_Remotecontrol_RX_TEL_INDEX */
#define CSM_C_DLC_Remotecontrol                                          8
#define CSM_C_SIG_RX_Remotecontrol                                       CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_Encoder2_Steps_Remotecontrol                        CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_Encoder1_Steps_Remotecontrol                        CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_Encoder2_Button_Remotecontrol                       CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_Encoder1_Button_Remotecontrol                       CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_Key21_Status_Remotecontrol                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_Key20_Status_Remotecontrol                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 6)
#define CSM_C_SIG_RX_Key19_Status_Remotecontrol                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 7)
#define CSM_C_SIG_RX_Key18_Status_Remotecontrol                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 8)
#define CSM_C_SIG_RX_Key17_Status_Remotecontrol                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 9)
#define CSM_C_SIG_RX_Key16_Status_Remotecontrol                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 10)
#define CSM_C_SIG_RX_Key15_Status_Remotecontrol                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 11)
#define CSM_C_SIG_RX_Key14_Status_Remotecontrol                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 12)
#define CSM_C_SIG_RX_Key13_Status_Remotecontrol                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 13)
#define CSM_C_SIG_RX_Key12_Status_Remotecontrol                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 14)
#define CSM_C_SIG_RX_Key11_Status_Remotecontrol                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 15)
#define CSM_C_SIG_RX_Key10_Status_Remotecontrol                          CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 16)
#define CSM_C_SIG_RX_Key9_Status_Remotecontrol                           CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 17)
#define CSM_C_SIG_RX_Key8_Status_Remotecontrol                           CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 18)
#define CSM_C_SIG_RX_Key7_Status_Remotecontrol                           CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 19)
#define CSM_C_SIG_RX_Key6_Status_Remotecontrol                           CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 20)
#define CSM_C_SIG_RX_Key5_Status_Remotecontrol                           CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 21)
#define CSM_C_SIG_RX_Key4_Status_Remotecontrol                           CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 22)
#define CSM_C_SIG_RX_Key3_Status_Remotecontrol                           CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 23)
#define CSM_C_SIG_RX_Key2_Status_Remotecontrol                           CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 24)
#define CSM_C_SIG_RX_Key1_Status_Remotecontrol                           CSM_M_MAKE_SIGNAL_ID(CBR_C_Remotecontrol_RX_TEL_INDEX, 25)

/*****************************************************************************/
/* CBR_C_Resp_DeviceInformation2_RX_TEL_INDEX */
#define CSM_C_DLC_Resp_DeviceInformation2                                8
#define CSM_C_SIG_RX_Resp_DeviceInformation2                             CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation2_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_B_SW_Ver_MCP_Resp_DeviceInformation2                CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation2_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_B_HW_Ver_MCP_Resp_DeviceInformation2                CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation2_RX_TEL_INDEX, 2)

/*****************************************************************************/
/* CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX */
#define CSM_C_DLC_Resp_DeviceInformation1                                8
#define CSM_C_SIG_RX_Resp_DeviceInformation1                             CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX, 0)
#define CSM_C_SIG_RX_B_SW_YY_Resp_DeviceInformation1                     CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX, 1)
#define CSM_C_SIG_RX_B_SW_MM_Resp_DeviceInformation1                     CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX, 2)
#define CSM_C_SIG_RX_B_SW_DD_Resp_DeviceInformation1                     CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX, 3)
#define CSM_C_SIG_RX_B_HW_YY_Resp_DeviceInformation1                     CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX, 4)
#define CSM_C_SIG_RX_B_HW_MM_Resp_DeviceInformation1                     CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX, 5)
#define CSM_C_SIG_RX_B_HW_DD_Resp_DeviceInformation1                     CSM_M_MAKE_SIGNAL_ID(CBR_C_Resp_DeviceInformation1_RX_TEL_INDEX, 6)

/* ------------------------------------------------------------------------- */
/* end of copy generated CBR defines here */
/* ------------------------------------------------------------------------- */

/* ------------------------------------------------------------------------- */
/* end of copy generated CBR defines here */
/* ------------------------------------------------------------------------- */

