//lint -wlib(1)               suppress lint messages for <...> libraries

/* Description and history of csm_stack.c at the end of the file.             */
/** File name for preprocessor commands */
#define CSM_STACK_SELF
/** csm_stack.c is a file according V-Team CAN-SW architecture implementation rules */
#define CSM_CAN_STACK

/*******************************************************************************
 * includes:
 ******************************************************************************/
/*************** CSM and stack **************/
#include "csm_stack_i.h"
#include "csm_i.h"         /* can stack includes */
#include "csm_stack_m.h"
#include "csm_m.h"
#include "csm_apl.h" /* for CSM_vDTCEventCallback() */

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
  #if (CSM_S_MCNET == CSM_C_F_ON) || (defined CSM_C_DOWN_REASON_ITP_DATA_REQ)
    #include "csm_c.h"
  #endif
#endif

/*****************************************************************
| check of all feature switches which affects this file :
| The following #defines should be declared in csm_stack_p.h:
|----------------------------------------------------------------*/
#ifndef CSM_S_TRACE
  #error "CSM_S_TRACE must be set to CSM_C_F_ON or -OFF !"
#else
  #if (CSM_S_TRACE == CSM_C_F_ON)
    #ifndef CSM_S_TRACE_ETG
      #error "CSM_S_TRACE_ETG must be set to CSM_C_F_ON or -OFF !"
    #endif
  #endif
#endif

/********** local control *********/
#if  (CSM_S_CSM_LOCAL_CTRL == CSM_C_F_ON)
#include "csm_lctr_i.h"
#endif /*  (CSM_S_CSM_LOCAL_CTRL == CSM_C_F_ON)  */

/************** Proxy *************/
#if (CSM_S_REMOTE_STACK == CSM_C_F_ON)
 #include "csm_proxy_i.h"
#endif

/*************** CBR **************/
#if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
  #include "cbr_i.h"
  #include "csm_cbr_c.h"
#endif

/*************** BAP **************/
#if ( CSM_S_VW_BAP_TP == CSM_C_F_ON )
 #include "csm_bap_m.h"
#endif

/*************** CNP **************/
#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
#include "cnp_i.h"
  #if (CSM_S_MCNET == CSM_C_F_ON)
    #include "csm_mcnet_i.h"
    #include "cnp_mcnet_i.h"
  #endif
  #if (CSM_S_ISO_TP == CSM_C_F_ON) /* (defined CSM_C_IND_REASON_ITP_DATA_IND) || (defined CSM_C_IND_REASON_ITP_DATA_CON) || (defined CSM_C_IND_REASON_ITP_COMM_IND) */
    #include "csm_itp_m.h"
    #include "cnp_itp_i.h"
  #endif
  #if (CSM_S_VW_TP_2_0 == CSM_C_F_ON)
    #if (CSM_S_VWTP20_IND_ON_ML_LEVEL == CSM_C_F_ON )
      #include "csm_vw_i.h"
    #endif
  #endif
  #if (CSM_S_MPDT == CSM_C_F_ON)
    #include "csm_mpdt_m.h"
    #include "cnp_mpdt_i.h"
  #endif
  #if ((CSM_S_UUDT_RX == CSM_C_F_ON) || (CSM_S_UUDT_TX == CSM_C_F_ON))
    #include "cnp_uudt_i.h"
  #endif
  #ifdef CSM_C_IND_REASON_LIN_DIAG_DATA_IND
    #include"cnp_lin_diag.h"
  #endif /* CSM_C_IND_REASON_LIN_DIAG_DATA_IND */
  #ifdef CSM_C_IND_REASON_LIN_USDT_DATA_IND
    #include"cnp_lin_usdt.h"
  #endif /* CSM_C_IND_REASON_LIN_USDT_DATA_IND */
  #if  (CSM_S_CSM_LOCAL_CTRL == CSM_C_F_ON)
  #if (CSM_S_CNP_LOCAL_CTRL == CSM_C_F_ON)
    #include "cnp_lctr_i.h"
  #endif /* CSM_S_CNP_LOCAL_CTRL */
  #endif /*  (CSM_S_CSM_LOCAL_CTRL == CSM_C_F_ON)  */
  #if (CSM_S_J1939 == CSM_C_F_ON)
    #include "csm_j1939_m.h"
    #if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
    #include "cnp_j1939_i.h"
    #endif
    #if (CSM_S_J1939_NM == CSM_C_F_ON)
      #include "cnm_J1939_i.h"
    #endif
  #endif /* (CSM_S_J1939 == CSM_C_F_ON) */
#endif /* CSM_S_CNP_AVAILABLE */

/*************** CNM **************/
#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
#include "cnm_i.h"
  #if (CSM_S_FIATSLAVE_NM == CSM_C_F_ON)
  #include "cnm_fiatslave_i.h"
  #endif
  #if (CSM_S_OSEK_NM == CSM_C_F_ON)
  #include "cnm_osek_i.h"
  #endif
  #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
  #include "cnm_oseki_i.h"
  #endif
  #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
  #include "cnm_vwhigh_i.h"
  #endif
  #if (CSM_S_GMLAN_NM == CSM_C_F_ON)
  #include "cnm_gmlan_i.h"
  #endif
  #if (CSM_S_IVLAN_NM == CSM_C_F_ON)
  #include "cnm_ivlan_i.h"
  #endif
#endif

/*************** CDA **************/
#if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)
  #include "cda_i.h"
#endif

#ifdef CSM_C_DOWN_REASON_CDA_LLD_LIN_TX_CON
  #include "cda_lld_lin_i.h"
#endif

//*************** ETG Tracing ******
#if (CSM_S_TRACE == CSM_C_F_ON)
  #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
  #define ETRACE_S_IMPORT_INTERFACE_GENERIC
  #include <etrace_if.h>

  #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
    #include "csm_etg_trace.h"
    #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FD_CSM
    // #define ETG_INLINE
    #include "trcGenProj/Header/csm_stack.c.trc.h"
  #endif
  #endif
#endif // CSM_S_TRACE == CSM_C_F_ON

#ifdef CSM_C_DOWN_REASON_CSM_IND_EEMS_CHK_ON
  extern VOID CSM_vCSM_EEMSInd(DWORD dwSignalID, DWORD dwSignalIndStatus);
#endif

/*****************************************************************
| check of all feature switches which affects this file :
| The following #defines should be declared in csm_stack_p.h:
|----------------------------------------------------------------*/
/* main switches */
#ifndef CSM_S_REMOTE_STACK
  #error "CSM_S_REMOTE_STACK must be set to CSM_C_F_ON or -OFF !"
#endif
#ifndef CSM_S_CBR_AVAILABLE
  #error "CSM_S_CBR_AVAILABLE must be set to CSM_C_F_ON or -OFF !"
#endif
#ifndef CSM_S_DOXYGEN_HIDE_NON_API_FCT
  #error "CSM_S_DOXYGEN_HIDE_NON_API_FCT must be set to CSM_C_F_ON or -OFF !"
#endif
#ifndef CSM_S_TRACE
  #error "CSM_S_TRACE must be set to CSM_C_F_ON or -OFF !"
#endif

#if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)
  #ifndef CSM_S_CDA_SENDRESTRICTION
    #error "CSM_S_CDA_SENDRESTRICTION must be set to CSM_C_F_ON or -OFF !"
    #if (CSM_S_CDA_SENDRESTRICTION == CSM_C_F_ON)
      #ifndef CSM_S_CDA_BUSOFF_SENDRESTRICTION
        #error "CSM_S_CDA_BUSOFF_SENDRESTRICTION must be set to CSM_C_F_ON or -OFF !"
      #endif
    #endif
  #endif
#endif
#ifndef CSM_S_BLOCKABLE_UPSTREAM_TASK
  #error "CSM_S_BLOCKABLE_UPSTREAM_TASK must be set to CSM_C_F_ON or -OFF !"
#endif
#ifndef CSM_S_EXCEPTION_HANDLER_ACTIVATED
  #error "CSM_S_EXCEPTION_HANDLER_ACTIVATED must be set to CSM_C_F_ON or -OFF !"
#endif

/* switches with dependencies */
#ifndef CSM_S_CNP_AVAILABLE
  #error "CSM_S_CNP_AVAILABLE must be set to CSM_C_F_ON or -OFF !"
#else
  #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
    #ifndef CSM_S_MCNET
      #error "CSM_S_MCNET must be set to CSM_C_F_ON or -OFF !"
    #else
      #if (CSM_S_MCNET == CSM_C_F_ON)
        #ifndef CSM_S_MCNET_DOPPELPUFFER
          #error "CSM_S_MCNET_DOPPELPUFFER must be set to CSM_C_F_ON or -OFF !"
        #endif
      #endif
    #endif
    #ifndef CSM_S_VW_TP_2_0
      #error " CSM_S_VW_TP_2_0 must be set to CSM_C_F_ON or -OFF !"
    #elif (CSM_S_VW_TP_2_0 == CSM_C_F_ON)
      #ifndef CSM_S_VWTP20_IND_ON_ML_LEVEL
        #error "CSM_S_VWTP20_IND_ON_ML_LEVEL must be set to CSM_C_F_ON or -OFF !"
      #endif
    #endif
    #ifndef CSM_S_VW_BAP_TP
      #error "CSM_S_VW_BAP_TP must be set to CSM_C_F_ON or -OFF !"
    #endif
    #if (CSM_S_ISO_TP == CSM_C_F_ON)
      #ifndef CSM_S_ITP_APPL_SETS_RX_BUFFER_FREE
        #error "CSM_S_ITP_APPL_SETS_RX_BUFFER_FREE must be set to CSM_C_F_ON or -OFF !"
      #endif
      #if (((defined CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_REQ) || \
            (defined CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_CON) || \
            (defined CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_IND)) && \
           ((!defined CSM_S_ITP_COMMUNICATION_FCT) || \
            (CSM_S_ITP_COMMUNICATION_FCT != CSM_C_F_ON)))
        #error "CSM_S_ITP_COMMUNICATION_FCT must be set to CSM_C_F_ON if protocol type CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_REQ -CON or -IND is defined!"
      #endif
    #endif
  #endif
#endif

#ifndef CSM_S_CNM_AVAILABLE
  #error "CSM_S_CNM_AVAILABLE must be set to CSM_C_F_ON or -OFF !"
#else
  #if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
    #ifndef CSM_S_FIATSLAVE_NM
      #error "CSM_S_FIATSLAVE_NM must be set to CSM_C_F_ON or -OFF !"
    #endif
    #ifndef CSM_S_OSEK_NM
      #error "CSM_S_OSEK_NM must be set to CSM_C_F_ON or -OFF !"
    #endif
    #ifndef CSM_S_GMLAN_NM
      #error "CSM_S_GMLAN_NM must be set to CSM_C_F_ON or -OFF !"
    #endif
    #ifndef CSM_S_IVLAN_NM
      #error "CSM_S_IVLAN_NM must be set to CSM_C_F_ON or -OFF !"
    #endif
  #endif
#endif

#ifndef CSM_S_ENABLE_INDICATE_BUSERROR
  #error "CSM_S_ENABLE_INDICATE_BUSERROR must be set to CSM_C_F_ON or -OFF !"
#else
  #if (CSM_S_ENABLE_INDICATE_BUSERROR == CSM_C_F_ON)
    #ifndef CSM_S_INDICATE_BUSOFF_TO_APPLICATION
      #error "CSM_S_INDICATE_BUSOFF_TO_APPLICATION must be set to CSM_C_F_ON or -OFF !"
    #endif
  #endif
#endif

#ifndef CSM_S_CDA_AVAILABLE
  #error "CSM_S_CDA_AVAILABLE must be set to CSM_C_F_ON or -OFF !"
#else
  #if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)
    #ifndef CSM_S_CDA_END_BUS_OFF_WITH_DATA_IND
      #error "CSM_S_CDA_END_BUS_OFF_WITH_DATA_IND must be set to CSM_C_F_ON or -OFF !"
    #endif
  #endif
#endif

/*******************************************************************************
 * defines and macros (scope: file local)
 ******************************************************************************/
/*-- none --*/

/*******************************************************************************
 * typedefs (scope: file local)
 ******************************************************************************/
/*-- none --*/

/*******************************************************************************
 * variable definition (scope: file local)
 ******************************************************************************/

DWORD u32ErrorCounter;
//extern DWORD csm_dwCommunicationRequests1[];

#if (defined CSM_C_DOWN_REASON_CDA_BUSOFF_ENTRY) || (defined CSM_C_DOWN_REASON_CDA_BUSOFF_RECOVERY)
  extern tBusOffState csm_bBusOffState[CSM_C_MAX_CAN_BUS];
#endif

// BKA2HI: the follwoing feature switch is currently (11/2016) not used in RN-AIVI
// It has to be checked, whether and where it is still required
#ifdef CSM_C_DOWN_REASON_TRACE
  WORD csm_wDownstreamTraceOutLevel;
  WORD csm_wDownstreamTraceOutInterface;
  WORD csm_wDownstreamTraceOutFunktion;
  WORD csm_wDownstreamTraceOutDataLength;
  BYTE csm_abDownstreamTraceOutData[CSM_MAX_TRACE_LENGTH];
  BOOL csm_fDownstreamTraceOutOverrun = FALSE;
#endif // CSM_C_DOWN_REASON_TRACE

/*******************************************************************************
 * variable definition (scope: CAN stack)
 ******************************************************************************/
#if (CSM_S_BLOCKABLE_UPSTREAM_TASK == CSM_C_F_ON)
/* variable: csm_fBlockUpstreamTask
 * comment:  flag, if true tratment of flags in upstream task is not
 *           allowed.
 */
BOOLEAN csm_fBlockUpstreamTask;
#endif /* CSM_S_BLOCKABLE_UPSTREAM_TASK */

/*******************************************************************************
 * function prototypes (scope: file local)
 ******************************************************************************/
/*-- none --*/

/*******************************************************************************
 * constants (scope: file local)
 ******************************************************************************/
/*-- none --*/

// Feature switch is used only to control doxygen documentation
#if (CSM_S_DOXYGEN_HIDE_NON_API_FCT == CSM_C_F_OFF)

/*******************************************************************************
 * function implementation (scope: file local = static)
 ******************************************************************************/

/*******************************************************************************
 * function implementation (scope: module local)
 ******************************************************************************/

/*******************************************************************************
 * function    csm_vTriggerCsmUpstreamTask
 * \doxydocu
 * \brief      Activates the CSM indication task and stores the activation reason.
 *
 *
 * \param[in]  dwIndicationReason
 *             reason to trigger the indication task
 *             Allowed values (see csm_stack_mp.h): CSM_C_IND_REASON_...\n
 *
 * \return     void
 *
 * \access     all task (no isr)
 * \reentrant  yes
 *
 * \lastreview 29.05.06 CM-DI/ESA3-Prhl
 *
 * \history_begin
 *11.02.03 CM-DI/ESU3-K"ohler
 *Makro CSM_M_SET_DOWN_REASON includes now DI/EI and so function is reentrant.
 *
 *04.11.02 CM-DI/EHS3-Pistoor
 *Added access level
 *
 *17.06.02 CM-DI/EHS3-K"ohler
 *Initial Revision.
 * \history_end
 ******************************************************************************/
VOID csm_vTriggerCsmUpstreamTask(DWORD dwIndicationReason)
{
  CSM_M_SET_IND_REASON(dwIndicationReason);
  csm_vActivateUpstreamTask();
}

#if (CSM_S_TRIGGER_UPSTREAM_TASK_FROM_IRQ_AVAILABLE == CSM_C_F_ON)
/*******************************************************************************
 * function    csm_vTriggerCsmUpstreamTaskFromIrq
 * \doxydocu
 * \brief      Activates the CSM upstraem task from interrupt level and stores
 *             the activation reason.
 *
 * \param[in]  dwIndicationReason
 *             reason to trigger the upstream task
 *             Allowed values (see csm_stack_mp.h): CSM_C_IND_REASON_...\n
 *
 * \return     void
 *
 * \access     all
 * \reentrant  yes
 *
 * \lastreview 26.10.06 CM-DI/ESA3-Prhl
 *
 * \history_begin
 * 06.10.06 CM-DI/ESA3-Khler
 * Initial Revision.
 * \history_end
 ******************************************************************************/
VOID csm_vTriggerCsmUpstreamTaskFromIrq(DWORD dwIndicationReason)
{
  CSM_M_SET_IND_REASON(dwIndicationReason);
  csm_vActivateUpstreamTaskFromIrq();
}
#endif  /* CSM_S_TRIGGER_UPSTREAM_TASK_FROM_IRQ_AVAILABLE */


/*******************************************************************************
 * function    csm_vTriggerCsmDownstreamTask
 * \doxydocu
 * \brief      Activates the CSM downstraem task and stores the activation reason.
 *
 *
 * \param[in]  dwRequestReason
 *             Allowed values (see csm_stack_mp.h): CSM_C_DOWN_REASON_...\n
 *
 * \return     void
 *
 * \access     all task (no isr)
 * \reentrant  yes
 *
 * \lastreview 29.05.06 CM-DI/ESA3-Prhl
 *
 * \history_begin
 *11.02.03 CM-DI/ESU3-K"ohler
 *Makro CSM_M_SET_DOWN_REASON includes now DI/EI and so function is reentrant.
 *
 *04.11.02 CM-DI/EHS3-Pistoor
 *Initial Revision.
 * \history_end
 ******************************************************************************/
VOID csm_vTriggerCsmDownstreamTask(DWORD dwRequestReason)
{
  CSM_M_SET_DOWN_REASON(dwRequestReason);
  csm_vActivateDownstreamTask();
}


/*******************************************************************************
 * function    csm_vTriggerCsmDownstreamTaskFromIrq
 * \doxydocu
 * \brief      Activates the CSM downstraem task and stores the activation reason.
 *
 * \param[in]  dwRequestReason
 *             reason to trigger the downstream task
 *             Allowed values (see csm_stack_mp.h): CSM_C_DOWN_REASON_...\n
 *
 * \return     void
 *
 * \access     all
 * \reentrant  yes
 *
 * \lastreview 29.05.06 CM-DI/ESA3-Prhl
 *
 * \history_begin
 *11.02.03 CM-DI/ESU3-K"ohler
 *Makro CSM_M_SET_DOWN_REASON includes now DI/EI and so function is reentrant.
 *
 *04.11.02 CM-DI/EHS3-Pistoor
 *Initial Revision.
 * \history_end
 ******************************************************************************/
VOID csm_vTriggerCsmDownstreamTaskFromIrq(DWORD dwRequestReason)
{
  CSM_M_SET_DOWN_REASON(dwRequestReason);
  csm_vActivateDownstreamTaskFromIrq();
}


/*******************************************************************************
 * function implementation (scope: CAN stack and operating system)
 *******************************************************************************/


/*******************************************************************************
 * function    CSM_vMemCopyDWordInMotorolaOrder
 * \doxydocu
 * \brief      Copies the bytes of a DWORD to a byte array in Motorola format
 *             e.g. for trace output
 *
 * \param[out] pbDestination
 *              Pointer to destination area where 4 bytes will be copied
 *              (need to be large enough).
 *
 * \param[in]  dwInput
 *              Input variable where 4 bytes will be copied from.
 *
 * \return     no
 *
 * \access     all
 * \reentrant  yes if destination is different
 *
 * \lastreview 16.11.09 VTeam-Khler
 *
 * \history_begin
 * 16.11.09  VTeam-Khler
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
void CSM_vMemCopyDWordInMotorolaOrder (BYTE* pbDestination, DWORD dwInput)
{
  *pbDestination++ = CSM_M_GET_HIBYTE(CSM_M_GET_HIWORD( dwInput ));
  *pbDestination++ = CSM_M_GET_LOBYTE(CSM_M_GET_HIWORD( dwInput ));
  *pbDestination++ = CSM_M_GET_HIBYTE(CSM_M_GET_LOWORD( dwInput ));
  *pbDestination   = CSM_M_GET_LOBYTE(CSM_M_GET_LOWORD( dwInput ));

}  /* end of CSM_vMemCopyDWordInMotorolaOrder() */

/*******************************************************************************
 * function    CSM_vDownstreamTraceOut
 * \doxydocu
 * \brief      triggers a CSM_M_TRACEOUT via Downstream task
 *
 * \param[in ] wTraceOutLevel
 *              Trace Level.
 *
 * \param[in ] wTraceOutInterface
 *              Interface number.
 *
 * \param[in]  wTraceOutFunktion
 *              Funktion number
 *
 * \param[in]  *pbTraceOutData
 *              Pointer to trace data buffer.
 *
 * \param[in]  wTraceOutDataLength
 *              Number of bytes in trace data buffer.
 *
 * \return     no
 *
 * \access     all
 * \reentrant  yes
 *
 * \lastreview  11.12.09  Prhl
 *
 * \history_begin
 * 09.12.09  VTeam-Franke
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
#ifdef CSM_C_DOWN_REASON_TRACE
void CSM_vDownstreamTraceOut(const WORD wTraceOutLevel, const WORD wTraceOutInterface, const WORD wTraceOutFunktion,
                             const BYTE *pbTraceOutData, const WORD wTraceOutDataLength)
{
  // INFO: This function is called from within CSM_lExceptionHandler.
  // This can happen only, if the feature CSM_S_REMOTE_STACK is OFF and
  // the features CSM_S_EXCEPTION_HANDLER_ACTIVATE and CSM_S_TRACE are ON.

  // parameter check
  if (pbTraceOutData != NULL)
  {
    // copy data to global variables
    csm_wDownstreamTraceOutLevel = wTraceOutLevel;
    csm_wDownstreamTraceOutInterface = wTraceOutInterface;
    csm_wDownstreamTraceOutFunktion = wTraceOutFunktion;

    // check len of trace data against max. possible
    if (wTraceOutDataLength < CSM_MAX_TRACE_LENGTH)
    {
      csm_wDownstreamTraceOutDataLength = wTraceOutDataLength;
    }
    else
    {
      // limitate if too much
      csm_wDownstreamTraceOutDataLength = CSM_MAX_TRACE_LENGTH;
    }

    // now copy trace data to global buffer
    CSM_vMemCopy(csm_abDownstreamTraceOutData, pbTraceOutData, wTraceOutDataLength);

    // set overrun bit, if task already triggered
    if (CSM_M_IS_IND_REASON_SET(CSM_C_DOWN_REASON_TRACE))
    {
      csm_fDownstreamTraceOutOverrun = TRUE;
    }
    else
    {
      csm_fDownstreamTraceOutOverrun = FALSE;
      csm_vTriggerCsmDownstreamTaskFromIrq(CSM_C_DOWN_REASON_TRACE);
    }
  } // pbTraceOutData != NULL
}
#endif // CSM_C_DOWN_REASON_TRACE

/*******************************************************************************
 * function    CSM_lExceptionHandler
 * \doxydocu
 * \brief      This function will be called by the macro CSM_M_MAKE_ERROR
 *             in cases of warnings, errors and severe errors.
 *
 *
 * \param[in]  u8ErrorGrade
 *             error grade
 *             Allowed values:
 *                CSM_C_ERR_INFO
 *                CSM_C_ERR_WARNING
 *                CSM_C_ERR_ERROR
 *                CSM_C_ERR_SEVERE_ERROR
 *
 * \param[in]  u8ErrorLocation
 *             error location
 *             Allowed values:
 *                CSM_C_ERR_LOC_GLB
 *                CSM_C_ERR_LOC_CSM
 *                CSM_C_ERR_LOC_CNM
 *                CSM_C_ERR_LOC_CNP
 *                CSM_C_ERR_LOC_CNP_MCNET
 *                CSM_C_ERR_LOC_CNP_ISO_TP
 *                CSM_C_ERR_LOC_CNP_VAG_TP
 *                CSM_C_ERR_LOC_CBR
 *                CSM_C_ERR_LOC_CDA
 *                CSM_C_ERR_LOC_CSM_STACK
 *                CSM_C_ERR_LOC_CSM_APL
 *
 * \param[in]  u8ErrorGrade
 *             error, code, see modules
 *
 * \return     True/False
 *
 * \access     XXXXXXXXXXXXXXXXXXXXXXXX
 * \reentrant  no
 *
 * \lastreview 29.05.06 CM-DI/ESA3-Prhl
 *
 * \history_begin
 *21.02.03 CM-DI/ESU3-Pistoor
 *Initial Revision.
 * \history_end
 ******************************************************************************/
#if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
#if (CSM_S_EXCEPTION_HANDLER_ACTIVATED == CSM_C_F_ON)
LONG CSM_lExceptionHandler(BYTE u8ErrorGrade, BYTE u8ErrorLocation, WORD u16ErrorCode)
{
  LONG u32ErrorValue = (-(u8ErrorGrade << 24) - (u8ErrorLocation << 16) - u16ErrorCode);

  if (u16ErrorCode != CSM_E_INIT_WARNING)
  {
    u32ErrorCounter++;

    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_USR1(("CSM_lExceptionHandler - CSM exception: %x %x %x",
                        ETG_CENUM(CSM_TRC_ERROR_GRADE,u8ErrorGrade),
                        ETG_CENUM(CSM_TRC_ERROR_LOCATION,u8ErrorLocation),
                        ETG_CENUM(CSM_TRC_ERROR_CODE,u16ErrorCode)
                       )
                      );
        #endif
      #else
      {
        #ifdef CSM_C_DOWN_REASON_TRACE
        BYTE abData[4];
        abData[0] = CSM_M_GET_HIBYTE(CSM_M_GET_HIWORD(u32ErrorValue));
        abData[1] = CSM_M_GET_LOBYTE(CSM_M_GET_HIWORD(u32ErrorValue));
        abData[2] = CSM_M_GET_HIBYTE(CSM_M_GET_LOWORD(u32ErrorValue));
        abData[3] = CSM_M_GET_LOBYTE(CSM_M_GET_LOWORD(u32ErrorValue));

        CSM_vDownstreamTraceOut(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_DOWNSTREAM_TRACE, abData, sizeof(abData));
        #endif
      }
      #endif // CSM_S_TRACE_ETG
    #endif // CSM_S_TRACE
  }
  return u32ErrorValue;
}
#endif
#endif // CSM_S_REMOTE_STACK

/*******************************************************************************
 * function    CSM_vUpstreamTask
 * \doxydocu
 * \brief      call callback functions on up-stream task level.
 *
 *
 * \return     void
 *
 * \access     up-stream task level
 * \reentrant  no
 *
 * \lastreview 21.11.08 VTeam-Zurmhl
 *             29.06.06 CM-DI/ESA3-Battis
 *
 * \history_begin
 *
 * 21.11.08 CM-DI/PJ-FO45-Pistoor
 * Added CSM_C_IND_REASON_ITP_DATA_IND_FF and CSM_C_IND_REASON_ITP_ERROR_IND
 *
 * 08.12.06 CM-DI/ESA3-Battis
 * call of OsSpecific Upstrea task moveed to the top of upstream task.
 *
 * 28.06.06 CM-DI/ESA3-Haffner
 * ProcessTimeout reason handling for new proxy added
 *
 *27.02.04 CM-DI/ESU3-K"ohler
 *Indication reason (= call on upstream task level) bus state change added.
 *
 *12.01.04 CM-DI/ESU3-Zurmuehl
 *Bugfix: Buffer assigment for CSM_C_IND_REASON_MCNET_ASDT_DATA_IND
 *
 *15.12.03 CM-DI/ESU3-K"ohler
 *CSM_C_MCNET_CONNS replaced by CSM_C_MCNET_MAX_CONNECTIONS.
 *
 *19.11.03 CM-DI/ESU3-Zurmuehl
 *MCNet services added ("draft version")
 *
 *24.07.03 CM-DI/ESU3-K"ohler
 *Disable and restore interrupts with new functions or (ITP) moved to the makros
 *in csm_stack_m.h.
 *
 *18.06.03  CM-DI/ESU3-Pistoor
 *Call of CNP_lIsoTp_DataIndProcessed() instead of CNP_vItpFreeAssBuffer()
 *
 *19.03.03  CM-DI/ESU3-K"ohler
 *IVLAN Error linker call saved with DI/EI.
 *
 *18.03.03  CM-DI/ESU3-Franke
 *project specific extensions for FORD_TP_EX, comment lines added
 *
 *17.02.03  CM-DI/ESU3-K"ohler
 *Order of ISO-TP indication and confirmation changed: confirmation first.
 *
 *12.02.03  CM-DI/ESU3-K"ohler
 *Addressfield- and data-pointer for message interface changed to pointer to
 *const values.
 *
 *18.12.02  CM-DI/EHS3-Pistoor
 *Added CSM_C_IND_REASON_NM_CAN1_UP and CSM_C_IND_REASON_NM_CAN1_DOWN
 *
 *26.11.02  CM-DI/EHS3-K"ohler
 *CSM_C_IND_REASON_NETWORK_CAN1_DOWN added as feature switch.
 *
 *25.11.02 CM-DI/EHS3-Pistoor
 *Added indication reason CSM_C_IND_REASON_NETWORK_CAN1_DOWN
 *
 *07.11.02 CM-DI/EHS3-K"ohler
 *Negative return value in ISO-TP DataCon changed to !CSM_C_NO_ERROR because
 *it has to be a byte not dword.
 *
 *16.09.02 CM-DI/EHS3-K"ohler
 *ISO-TP communication indication added
 *
 *20.04.02 CM-DI/EHS3-K"ohler
 *CSM_vIndicationTask renamed CSM_vUpstreamTask
 *
 *15.04.02 CM-DI/EHS3-K"ohler
 *CSM_vESD_IndicationTask renamed CSM_vIndicationTask.
 *
 *25.02.02 CM-DI/EHS3-Pistoor
 *Initial version
 *
 * \history_end
 ******************************************************************************/
VOID CSM_vUpstreamTask(VOID)
{
  #if (CSM_S_BLOCKABLE_UPSTREAM_TASK == CSM_C_F_ON)
  if (csm_fBlockUpstreamTask)
  {
    return;
  }
  #endif // CSM_S_BLOCKABLE_UPSTREAM_TASK

  csm_vOSspecificUpstream();

  //**************************************************************************
  // CSM_vProcessErrorInd()
  //**************************************************************************
  #if (CSM_S_ENABLE_INDICATE_BUSERROR == CSM_C_F_ON)
  #ifdef CSM_C_IND_REASON_BUS_ERROR
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_BUS_ERROR) )
  {
    CSM_M_CLEAR_IND_REASON (CSM_C_IND_REASON_BUS_ERROR);
    CSM_vProcessErrorInd();
  }
  #endif // CSM_C_IND_REASON_BUS_ERROR
  #endif // CSM_S_ENABLE_INDICATE_BUSERROR

  //**************************************************************************
  // CSM-Proxy upstream handling
  //**************************************************************************
  #if (CSM_S_REMOTE_STACK == CSM_C_F_ON)
  #ifdef CSM_C_IND_REASON_PROXY_TIMEOUT
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_PROXY_TIMEOUT) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_PROXY_TIMEOUT);
    CSM_PROXY_vProcessTimeoutUpstream();
  }
  #endif // CSM_C_IND_REASON_PROXY_TIMEOUT
  #endif // CSM_S_REMOTE_STACK

  //**************************************************************************
  // CSM upstream handling
  //**************************************************************************
  #ifdef CSM_C_IND_REASON_CSM_COMMUNICATION_CON
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_CSM_COMMUNICATION_CON) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_CSM_COMMUNICATION_CON);
    CSM_LCTR_vProcessCommunicationCon();
  }
  #endif // CSM_C_IND_REASON_CSM_COMMUNICATION_CON

  #ifdef CSM_C_IND_REASON_CSM_COMMUNICATION_IND
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_CSM_COMMUNICATION_IND) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_CSM_COMMUNICATION_IND);
    CSM_LCTR_vProcessCommunicationInd();
  }
  #endif // CSM_C_IND_REASON_CSM_COMMUNICATION_IND

  #ifdef CSM_C_IND_REASON_EEMS_IND
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_EEMS_IND) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_EEMS_IND);
    CSM_vCSM_EEMSInd(SIG_RX_EEMS_B_CAN_all, CSM_C_SIGNAL_ARRIVED);
  }
  #endif // CSM_C_IND_REASON_CSM_COMMUNICATION_IND

  //**************************************************************************
  // CNM upstream handling
  //**************************************************************************
  #ifdef CSM_C_IND_REASON_GMLAN_COMMUNICATION_IND
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_GMLAN_COMMUNICATION_IND) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_GMLAN_COMMUNICATION_IND);
    CSM_GMLAN_vProcessCommunicationInd();
  }
  #endif // CSM_C_IND_REASON_GMLAN_COMMUNICATION_IND

  #ifdef CSM_C_UP_REASON_CSM_OSEK_NM_STATE_CHANGED
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_UP_REASON_CSM_OSEK_NM_STATE_CHANGED) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_UP_REASON_CSM_OSEK_NM_STATE_CHANGED);
    CSM_NM_vProcessCommunicationInd();
  }
  #endif // CSM_C_UP_REASON_CSM_OSEK_NM_STATE_CHANGED

  #ifdef CSM_C_IND_REASON_CSM_OSEKI_NM_STATE_CHANGED
  if (CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_CSM_OSEKI_NM_STATE_CHANGED) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_CSM_OSEKI_NM_STATE_CHANGED);
    CSM_OSEKI_vProcessCommunicationInd();
  }
  #endif // CSM_C_IND_REASON_CSM_OSEKI_NM_STATE_CHANGED

  //**************************************************************************
  // CBR upstream handling
  //**************************************************************************
  #if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
  #ifdef CSM_C_IND_REASON_CBR_SIGNAL_IND
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_CBR_SIGNAL_IND) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_CBR_SIGNAL_IND);
    CBR_vProcessSignalInd();
  }
  #endif // CSM_C_IND_REASON_CBR_SIGNAL_IND

  #ifdef CSM_C_IND_REASON_CBR_COMMUNICATION_CON
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_CBR_COMMUNICATION_CON) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_CBR_COMMUNICATION_CON);
    CSM_CBR_vProcessCommunicationCon();
  }
  #endif // CSM_C_IND_REASON_CBR_COMMUNICATION_CON

  #ifdef CSM_C_IND_REASON_CBR_COMMUNICATION_IND
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_CBR_COMMUNICATION_IND) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_CBR_COMMUNICATION_IND);
    CSM_CBR_vProcessCommunicationInd();
  }
  #endif // CSM_C_IND_REASON_CBR_COMMUNICATION_IND

  #ifdef CSM_C_IND_REASON_CBR_NACHLAUF_CON
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_CBR_NACHLAUF_CON) )
  {
    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_CBR_NACHLAUF_CON);
    CSM_CBR_vProcessNachlaufCon();
  }
  #endif // CSM_C_IND_REASON_CBR_NACHLAUF_CON
  #endif // CSM_S_CBR_AVAILABLE

  /****************************************************************************
   * Rx interrupt has put received application telegrams (messages) into a
   * special queue and now they will be passed to the applications.
   ************************************************************************* */
  //**************************************************************************
  // CNP upstream handling
  //**************************************************************************
  #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
  #ifdef CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_CON
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_CON) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_CON);
    CSM_ITP_vProcessCommunicationCon();
  }
  #endif // CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_CON

  #ifdef CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_IND
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_IND) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_IND);
    CSM_ITP_vProcessCommunicationInd();
  }
  #endif // CSM_C_IND_REASON_CNP_ITP_COMMUNICATION_IND

  /********************************************************************************************
   * An ISO-TP message was sent and now the transfer result will be passed to the application.
   *******************************************************************************************/
  #ifdef CSM_C_IND_REASON_ITP_DATA_CON
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_ITP_DATA_CON) )
  {
    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_ITP_DATA_CON);
    CNP_ITP_vProcessDataCon();
  }
  #endif // CSM_C_IND_REASON_ITP_DATA_CON

  /*********************************************************************************
   * An ISO-TP message was received and now it will be passed to the application.
   ********************************************************************************/
  #ifdef CSM_C_IND_REASON_ITP_DATA_IND
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_ITP_DATA_IND) )
  {
    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_ITP_DATA_IND);
    CNP_ITP_vProcessDataInd();
  }
  #endif // CSM_C_IND_REASON_ITP_DATA_IND

  /**************************************************************************************************
   * An ISO-TP First Frame message was received and now the info will be passed to the application.
   *************************************************************************************************/
  #if (CSM_S_ISO_TP == CSM_C_F_ON)
  #if (CSM_S_ITP_FF_INDICATION_AVAILABLE == CSM_C_F_ON)
    #ifdef CSM_C_IND_REASON_ITP_DATA_IND_FF
    if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_ITP_DATA_IND_FF) )
    {
      CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_ITP_DATA_IND_FF);
      CNP_ITP_vProcessDataIndFF();
    }
    #endif // CSM_C_IND_REASON_ITP_DATA_IND_FF
  #endif // CSM_S_ITP_FF_INDICATION_AVAILABLE
  #endif // CSM_S_ISO_TP == CSM_C_F_ON

  /**********************************************************************************
   * An ISO-TP error happened and now the info will be passed to the application.
   *********************************************************************************/
  #if (CSM_S_ISO_TP == CSM_C_F_ON)
  #if (CSM_S_ITP_ERROR_INDICATION_AVAILABLE == CSM_C_F_ON)
    #ifdef CSM_C_IND_REASON_ITP_ERROR_IND
    if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_ITP_ERROR_IND) )
    {
      CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_ITP_ERROR_IND);
      CNP_ITP_vProcessErrorInd();
    }
    #endif // CSM_C_IND_REASON_ITP_ERROR_IND
  #endif // CSM_S_ITP_ERROR_INDICATION_AVAILABLE
  #endif // CSM_S_ISO_TP == CSM_C_F_ON

  /******************************************************************************************
   * An UUDT message was send and now the transfer result will be passed to the application.
   *****************************************************************************************/
  #ifdef CSM_C_IND_REASON_UUDT_DATA_CON
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_UUDT_DATA_CON) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_UUDT_DATA_CON);
    CSM_UUDT_vProcessDataCon();
  }
  #endif // CSM_C_IND_REASON_UUDT_DATA_CON

  /*****************************************************************************
   * An UUDT message was received and now it will be passed to the application.
   ****************************************************************************/
  #ifdef CSM_C_IND_REASON_UUDT_DATA_IND
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_UUDT_DATA_IND) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_UUDT_DATA_IND);
    CSM_UUDT_vProcessDataInd();
  }
  #endif // CSM_C_IND_REASON_UUDT_DATA_IND

  /*****************************************************************************
   * An UUDT error happened and now the info will be passed to the application.
   ****************************************************************************/
  #ifdef CSM_C_IND_REASON_UUDT_ERROR_IND
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_UUDT_ERROR_IND) )
  {
    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_UUDT_ERROR_IND);
    CNP_UUDT_vProcessErrorInd();
  }
  #endif // CSM_C_IND_REASON_UUDT_ERROR_IND

  /*******************************************************************************
   * A LIN diag message was received and now it will be passed to the application.
   ******************************************************************************/
  #ifdef CSM_C_IND_REASON_LIN_DIAG_DATA_IND
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_LIN_DIAG_DATA_IND) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_LIN_DIAG_DATA_IND);
    CNP_LIN_DIAG_vProcessDataInd();
  }
  #endif // CSM_C_IND_REASON_LIN_DIAG_DATA_IND

  /*********************************************************************************
   * A LIN usdt message was received and now it will be passed to the application.
   ********************************************************************************/
  #ifdef CSM_C_IND_REASON_LIN_USDT_DATA_IND
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_LIN_USDT_DATA_IND) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_LIN_USDT_DATA_IND);
    CNP_LIN_USDT_vProcessDataInd();
  }
  #endif // CSM_C_IND_REASON_LIN_USDT_DATA_IND

  /*****************************************************************************
   * MPDT ProcessCommunicationCon
   ****************************************************************************/
  #ifdef CSM_C_IND_REASON_CSM_MPDT_COMMUNICATION_CON
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_CSM_MPDT_COMMUNICATION_CON) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_CSM_MPDT_COMMUNICATION_CON);
    CSM_MPDT_vProcessCommunicationCon();
  }
  #endif // CSM_C_IND_REASON_CSM_MPDT_COMMUNICATION_CON

  /*****************************************************************************
   * MPDT ProcessCommunicationInd
   ****************************************************************************/
  #ifdef CSM_C_IND_REASON_CSM_MPDT_COMMUNICATION_IND
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_CSM_MPDT_COMMUNICATION_IND) )
  {
    CSM_M_CLEAR_IND_REASON( CSM_C_IND_REASON_CSM_MPDT_COMMUNICATION_IND);
    CSM_MPDT_vProcessCommunicationInd();
  }
  #endif // CSM_C_IND_REASON_CSM_MPDT_COMMUNICATION_IND

  /**********************************************************************************************
   * An MPDT-TP message was sent and now the transfer result will be passed to the application.
   *********************************************************************************************/
  #ifdef CSM_C_IND_REASON_CSM_MPDT_DATA_CON
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_CSM_MPDT_DATA_CON) )
  {
    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_CSM_MPDT_DATA_CON);
    CSM_MPDT_vProcessDataCon();
  }
  #endif // CSM_C_IND_REASON_CSM_MPDT_DATA_CON

  /*********************************************************************************
   * An MPDT-TP message was received and now it will be passed to the application.
   ********************************************************************************/
  #ifdef CSM_C_IND_REASON_CSM_MPDT_DATA_IND
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_CSM_MPDT_DATA_IND) )
  {
    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_CSM_MPDT_DATA_IND);
    CSM_MPDT_vProcessDataInd();
  }
  #endif // CSM_C_IND_REASON_CSM_MPDT_DATA_IND

  /*********************************************************************************
   * J1939 issues
   ********************************************************************************/
  #ifdef CSM_C_IND_REASON_J1939_DATA_IND
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_J1939_DATA_IND) )
  {
    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_J1939_DATA_IND);
    CSM_J1939_vProcessDataInd();
  }
  #endif // CSM_C_IND_REASON_J1939_DATA_IND

  #ifdef CSM_C_IND_REASON_J1939_DATA_CON
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_J1939_DATA_CON) )
  {
    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_J1939_DATA_CON);
    CSM_J1939_vProcessDataCon();
  }
  #endif

  #ifdef CSM_C_IND_REASON_J1939_ERROR_IND
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_J1939_ERROR_IND) )
  {
    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_J1939_ERROR_IND);
    CSM_J1939_vProcessErrorInd();
  }
  #endif

  #ifdef CSM_C_IND_REASON_J1939_DATA_IND_FF
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_J1939_DATA_IND_FF) )
  {
    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_J1939_DATA_IND_FF);
    CSM_J1939_vProcessDataIndFF();
  }
  #endif

  #ifdef CSM_C_IND_REASON_J1939_COMMUNICATION_CON
  if( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_J1939_COMMUNICATION_CON) )
  {
    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_J1939_COMMUNICATION_CON);
    CSM_J1939_vProcessCommunicationCon();
  }
  #endif

  #ifdef CSM_C_IND_REASON_J1939_COMMUNICATION_IND
  if( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_J1939_COMMUNICATION_IND) )
  {
    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_J1939_COMMUNICATION_IND);
    CSM_J1939_vProcessCommunicationInd();
  }
  #endif

  /*****************************************************************************
   * The "connection state" of a MCNet channel has changed after demand and now
   *  the current state will be passed to the application. */
  #ifdef CSM_C_IND_REASON_MCNET_COMM_CON
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_MCNET_COMM_CON) )
  {
    BYTE bChannel;  /* Loop index */
    BYTE bConnectState = 0;   /* MCNet connection state *//*set to 0 to avoid Lint warning*/
    CSM_ADDR_MCNET_ASDT rAddrField;

    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_MCNET_COMM_CON);
    for (bChannel = 0;                                /* check all channels */
         bChannel < CSM_C_MCNET_MAX_CONNECTIONS;
         bChannel++)
    {
      if (CSM_M_IS_MCNET_CONNECT_CON_FLAG_SET(bChannel) ) /* if connection confirmation is necessary */
      {
        CSM_M_CLEAR_MCNET_CONNECT_CON_FLAG(bChannel);     /* set on CAN task level, cleared on mainloop level */

        CSM_MCNET_vGetAsdtAddress (bChannel, &rAddrField);

        /* U.Z.(6): Verbindungszustand umkodieren, demnchst besser als Bitfeld in csm_rMCNetConnectionAct zu lsen! */
        if (CNP_MCNET_C_CONNECTED == CNP_MCNET_abState[CNP_MCNET_C_MAIN_STATE][bChannel])
        {
          if (CSM_MCNET_C_SM_ENHANCED == CNP_MCNET_abServiceMode[bChannel])
          {
            bConnectState = CSM_C_CONNECTED_MCNET_ENH;
          }
          else if (CSM_MCNET_C_SM_STANDARD == CNP_MCNET_abServiceMode[bChannel] )
          {
            bConnectState = CSM_C_CONNECTED_MCNET_STD;
          }
          else
          {
            CSM_vAssert( FALSE);
          }
        }
        else
        {
          bConnectState = CSM_C_DISCONNECTED_MCNET;
        }


        if ( CSM_M_IS_MCNET_CON_REQ_TRIGGERED_BY_APPL_FLAG_SET(bChannel) ) /* ConnectReq by application: */
        {
          CSM_M_CLEAR_MCNET_CON_REQ_TRIGGERED_BY_APPL_FLAG(bChannel);      /* Clear Flag */

          #if (CSM_S_TRACE == CSM_C_F_ON)
          {
            // checked buffer size against CSM_MAX_TRACE_LENGTH !! BKA2HI: 11/2016
            BYTE abData[10];
            abData[ 0] = csm_rMCNetConnection[ bChannel].bBus;
            abData[ 1] = CSM_M_GET_HIBYTE(CSM_M_GET_HIWORD(CSM_C_PTYPE_MCNET_ASDT_STD));/*lint !e572 !e778 PQM_authorized_multi_127*/
            abData[ 2] = CSM_M_GET_LOBYTE(CSM_M_GET_HIWORD(CSM_C_PTYPE_MCNET_ASDT_STD));/*lint !e572 !e778 PQM_authorized_multi_127*/
            abData[ 3] = CSM_M_GET_HIBYTE(CSM_M_GET_LOWORD(CSM_C_PTYPE_MCNET_ASDT_STD));
            abData[ 4] = CSM_M_GET_LOBYTE(CSM_M_GET_LOWORD(CSM_C_PTYPE_MCNET_ASDT_STD));
            abData[ 5] = *((((BYTE *)&rAddrField)+0));
            abData[ 6] = *((((BYTE *)&rAddrField)+1));
            abData[ 7] = bConnectState;
            abData[ 8] = CSM_M_GET_HIBYTE( CSM_C_APPL_ID_DEFAULT);
            abData[ 9] = CSM_M_GET_LOBYTE( CSM_C_APPL_ID_DEFAULT);
            CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_CSM_COMMUNICATION_CON, abData, 10);
          }
          #endif // CSM_S_TRACE
          #if (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
          if (CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvCommunicationCon != NULL)
          {
            #if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
            CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvCommunicationCon( CSM_MCNET_arASDTCallbackFkt[ bChannel].pvHandle,
                                                                        csm_rMCNetConnection[ bChannel].bBus,
                                                                        CSM_C_PTYPE_MCNET_ASDT_STD,
                                                                        (VOID*) &rAddrField,
                                                                        bConnectState,
                                                                        CSM_C_APPL_ID_DEFAULT);

            #else // CSM_S_USE_CALLBACK_WITH_HANDLE
            CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvCommunicationCon( csm_rMCNetConnection[ bChannel].bBus,
                                                                        CSM_C_PTYPE_MCNET_ASDT_STD,
                                                                        (VOID*) &rAddrField,
                                                                        bConnectState,
                                                                        CSM_C_APPL_ID_DEFAULT);

            #endif // CSM_S_USE_CALLBACK_WITH_HANDLE
          }
          #else // (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
          if (csm_rMCNetConnection[bChannel].pfvASDTCommCon != NULL)
          {
            csm_rMCNetConnection[bChannel].pfvASDTCommCon(csm_rMCNetConnection[ bChannel].bBus, CSM_C_PTYPE_MCNET_ASDT_STD/*dwProtocollType*/,
                                                          (VOID*) &rAddrField,
                                                          bConnectState, CSM_C_APPL_ID_DEFAULT);

          }
          #endif // (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
        }
        else   /* ConnectReq by MCNet NM: Send indication to application */
        {
          #if (CSM_S_TRACE == CSM_C_F_ON)
          {
            // checked buffer size against CSM_MAX_TRACE_LENGTH !! BKA2HI: 11/2016
            BYTE abData[10];
            abData[ 0] = csm_rMCNetConnection[ bChannel].bBus;
            abData[ 1] = CSM_M_GET_HIBYTE(CSM_M_GET_HIWORD(CSM_C_PTYPE_MCNET_ASDT_STD));/*lint !e572 !e778 PQM_authorized_multi_127*/
            abData[ 2] = CSM_M_GET_LOBYTE(CSM_M_GET_HIWORD(CSM_C_PTYPE_MCNET_ASDT_STD));/*lint !e572 !e778 PQM_authorized_multi_127*/
            abData[ 3] = CSM_M_GET_HIBYTE(CSM_M_GET_LOWORD(CSM_C_PTYPE_MCNET_ASDT_STD));
            abData[ 4] = CSM_M_GET_LOBYTE(CSM_M_GET_LOWORD(CSM_C_PTYPE_MCNET_ASDT_STD));
            abData[ 5] = *((((BYTE *)&rAddrField)+0));
            abData[ 6] = *((((BYTE *)&rAddrField)+1));
            abData[ 7] = bConnectState;
            abData[ 8] = CSM_M_GET_HIBYTE( CSM_C_APPL_ID_DEFAULT);
            abData[ 9] = CSM_M_GET_LOBYTE( CSM_C_APPL_ID_DEFAULT);
            CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_CSM_COMMUNICATION_IND, abData, 10);
          }
          #endif // CSM_S_TRACE
          #if (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
          if (CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvCommunicationInd != NULL)
          {
            #if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
            CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvCommunicationInd( CSM_MCNET_arASDTCallbackFkt[ bChannel].pvHandle,
                                                                        csm_rMCNetConnection[ bChannel].bBus,
                                                                        CSM_C_PTYPE_MCNET_ASDT_STD/*dwProtocollType*/,
                                                                        (VOID*) &rAddrField,
                                                                        bConnectState,
                                                                        CSM_C_APPL_ID_DEFAULT);

            #else // CSM_S_USE_CALLBACK_WITH_HANDLE
            CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvCommunicationInd( csm_rMCNetConnection[ bChannel].bBus,
                                                                        CSM_C_PTYPE_MCNET_ASDT_STD/*dwProtocollType*/,
                                                                        (VOID*) &rAddrField,
                                                                        bConnectState,
                                                                        CSM_C_APPL_ID_DEFAULT);
            #endif // CSM_S_USE_CALLBACK_WITH_HANDLE
          }
          #else // (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
          if (csm_rMCNetConnection[bChannel].pfvASDTCommInd != NULL)
          {
            csm_rMCNetConnection[bChannel].pfvASDTCommInd(csm_rMCNetConnection[ bChannel].bBus, CSM_C_PTYPE_MCNET_ASDT_STD/*dwProtocollType*/,
                                                          (VOID*) &rAddrField,
                                                          bConnectState, CSM_C_APPL_ID_DEFAULT);
          }
          #endif // (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
        }
      } // end if connection confirmation
    } // end for all MCNet-TP channels
  }
  #endif // CSM_C_IND_REASON_MCNET_COMM_CON

  /*****************************************************************************
   * The "connection state" of a MCNet channel has changed spontaneously and now
   *  the current state will be passed to the application. */
  #ifdef CSM_C_IND_REASON_MCNET_COMM_IND
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_MCNET_COMM_IND) )
  {
    BYTE bChannel;        /* Loop index */
    BYTE bConnectState = 0;   /* MCNet connection state *//*set to 0 to avoid Lint warning*/
    CSM_ADDR_MCNET_ASDT rAddrField;

    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_MCNET_COMM_IND);

    for (bChannel = 0;                                /* check all channels */
         bChannel < CSM_C_MCNET_MAX_CONNECTIONS;
         bChannel++)
    {
      if ((CSM_M_IS_MCNET_CONNECT_IND_FLAG_SET(bChannel))   /* if connection confirmation is necessary */
           )
      {
        CSM_M_CLEAR_MCNET_CONNECT_IND_FLAG(bChannel);     /* set on CAN task level, cleared on mainloop level */

        CSM_MCNET_vGetAsdtAddress (bChannel, &rAddrField);

        /* U.Z.(6): Verbindungszustand umkodieren, demnchst besser als Bitfeld in csm_rMCNetConnectionAct zu lsen! */
        if (CNP_MCNET_C_CONNECTED == CNP_MCNET_abState[CNP_MCNET_C_MAIN_STATE][bChannel])
        {
          if (CSM_MCNET_C_SM_ENHANCED == CNP_MCNET_abServiceMode[bChannel])
          {
            bConnectState = CSM_C_CONNECTED_MCNET_ENH;
          }
          else if (CSM_MCNET_C_SM_STANDARD == CNP_MCNET_abServiceMode[bChannel] )
          {
            bConnectState = CSM_C_CONNECTED_MCNET_STD;
          }
          else
          {
            CSM_vAssert( FALSE);
          }
        }
        else
        {
          bConnectState = CSM_C_DISCONNECTED_MCNET;
        }
        #if (CSM_S_TRACE == CSM_C_F_ON)
        {
          // checked buffer size against CSM_MAX_TRACE_LENGTH !! BKA2HI: 11/2016
          BYTE abData[10];
          abData[ 0] = csm_rMCNetConnection[ bChannel].bBus;
          abData[ 1] = CSM_M_GET_HIBYTE(CSM_M_GET_HIWORD(CSM_C_PTYPE_MCNET_ASDT_STD));/*lint !e572 !e778 PQM_authorized_multi_127*/
          abData[ 2] = CSM_M_GET_LOBYTE(CSM_M_GET_HIWORD(CSM_C_PTYPE_MCNET_ASDT_STD));/*lint !e572 !e778 PQM_authorized_multi_127*/
          abData[ 3] = CSM_M_GET_HIBYTE(CSM_M_GET_LOWORD(CSM_C_PTYPE_MCNET_ASDT_STD));
          abData[ 4] = CSM_M_GET_LOBYTE(CSM_M_GET_LOWORD(CSM_C_PTYPE_MCNET_ASDT_STD));
          abData[ 5] = *((((BYTE *)&rAddrField)+0));
          abData[ 6] = *((((BYTE *)&rAddrField)+1));
          abData[ 7] = bConnectState;
          abData[ 8] = CSM_M_GET_HIBYTE( CSM_C_APPL_ID_DEFAULT);
          abData[ 9] = CSM_M_GET_LOBYTE( CSM_C_APPL_ID_DEFAULT);
          CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_CSM_COMMUNICATION_IND, abData, 10);
        }
        #endif // CSM_S_TRACE
        #if (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
        if( (CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvCommunicationInd != NULL))
        {
          #if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
          CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvCommunicationInd( CSM_MCNET_arASDTCallbackFkt[ bChannel].pvHandle,
                                                                      csm_rMCNetConnection[ bChannel].bBus,
                                                                      CSM_C_PTYPE_MCNET_ASDT_STD,
                                                                      (VOID*) &rAddrField,
                                                                      bConnectState,
                                                                      CSM_C_APPL_ID_DEFAULT);
          #else // CSM_S_USE_CALLBACK_WITH_HANDLE
          CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvCommunicationInd( csm_rMCNetConnection[ bChannel].bBus,
                                                                      CSM_C_PTYPE_MCNET_ASDT_STD,
                                                                      (VOID*) &rAddrField,
                                                                      bConnectState,
                                                                      CSM_C_APPL_ID_DEFAULT);
          #endif // CSM_S_USE_CALLBACK_WITH_HANDLE
        }
        #else // (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
        if( (csm_rMCNetConnection[bChannel].pfvASDTCommInd != NULL)) {
        csm_rMCNetConnection[bChannel].pfvASDTCommInd(csm_rMCNetConnection[ bChannel].bBus,
                                                      CSM_C_PTYPE_MCNET_ASDT_STD,
                                                      (VOID*) &rAddrField,
                                                      bConnectState,
                                                      CSM_C_APPL_ID_DEFAULT); }
        #endif // (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
      } // end if connection indication
    } // end for all MCNet-TP channels
  }
  #endif // CSM_C_IND_REASON_MCNET_COMM_IND

  /*****************************************************************************
   * An MCNet message was transmitted and the transfer result will be passed to
   * the application */
  #ifdef CSM_C_IND_REASON_MCNET_ASDT_DATA_CON
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_MCNET_ASDT_DATA_CON) )
  {
    BYTE bChannel;  /* Loop index */
    CSM_ADDR_MCNET_ASDT rAddrField;

    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_MCNET_ASDT_DATA_CON);
    for (bChannel = 0;                                /* check all channels */
         bChannel < CSM_C_MCNET_MAX_CONNECTIONS;
         bChannel++)
    {

      /* Check for "expedited data service" confirmation: */
      if ((CSM_M_IS_MCNET_ASDT_ED_DATA_CON_FLAG_SET(bChannel))   /* if data indication is necessary */
           )
      {
        CSM_M_CLEAR_MCNET_ASDT_ED_DATA_CON_FLAG(bChannel);   /* set on CAN task level, cleared on mainloop level */

        CSM_MCNET_vGetAsdtAddress (bChannel, &rAddrField);

        #if (CSM_S_TRACE == CSM_C_F_ON)
        {
          // checked buffer size against CSM_MAX_TRACE_LENGTH !! BKA2HI: 11/2016
          BYTE abData[11];
          #if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
          abData[ 0] = CSM_M_GET_HIBYTE(CSM_M_GET_HIWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
          abData[ 1] = CSM_M_GET_LOBYTE(CSM_M_GET_HIWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
          abData[ 2] = CSM_M_GET_HIBYTE(CSM_M_GET_LOWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
          abData[ 3] = CSM_M_GET_LOBYTE(CSM_M_GET_LOWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
          #endif // CSM_S_USE_CALLBACK_WITH_HANDLE

          abData[ 4] = CSM_M_GET_HIBYTE(CSM_M_GET_HIWORD( CSM_C_PTYPE_MCNET_ASDT_EXP));/*lint !e572 !e778 PQM_authorized_multi_127*/
          abData[ 5] = CSM_M_GET_LOBYTE(CSM_M_GET_HIWORD( CSM_C_PTYPE_MCNET_ASDT_EXP));/*lint !e572 !e778 PQM_authorized_multi_127*/
          abData[ 6] = CSM_M_GET_HIBYTE(CSM_M_GET_LOWORD( CSM_C_PTYPE_MCNET_ASDT_EXP));
          abData[ 7] = CSM_M_GET_LOBYTE(CSM_M_GET_LOWORD( CSM_C_PTYPE_MCNET_ASDT_EXP));
          abData[ 8] = rAddrField.bLocalComp;
          abData[ 9] = rAddrField.bRemoteComp;
          abData[10] = CSM_abMCNetAsdtEdDataConResults[bChannel];
          CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_CSM_DATA_CON, abData, 11);
        }
        #endif // CSM_S_TRACE

        #if (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
        if( CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataCon != NULL)
        {
          #if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
          CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataCon( CSM_MCNET_arASDTCallbackFkt[ bChannel].pvHandle,
                                                             CSM_C_PTYPE_MCNET_ASDT_EXP,
                                                             (VOID*) &rAddrField,
                                                             CSM_abMCNetAsdtEdDataConResults[bChannel]);
          #else // CSM_S_USE_CALLBACK_WITH_HANDLE
          CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataCon( CSM_C_PTYPE_MCNET_ASDT_EXP,
                                                             (VOID*) &rAddrField,
                                                             CSM_abMCNetAsdtEdDataConResults[bChannel]);
          #endif // CSM_S_USE_CALLBACK_WITH_HANDLE
        }
        #else // (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
        if( csm_rMCNetConnection[bChannel].pfvASDTDataCon != NULL) {
        csm_rMCNetConnection[bChannel].pfvASDTDataCon( CSM_C_PTYPE_MCNET_ASDT_EXP,
                                                      (VOID*) &rAddrField,
                                                      CSM_abMCNetAsdtEdDataConResults[bChannel]); }
        #endif // (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
      } // end if expedited data confirmation

      /* Check for "long data service" confirmation: */
      if ((CSM_M_IS_MCNET_ASDT_LD_DATA_CON_FLAG_SET(bChannel))   /* if data indication is necessary */
           )
      {
        CSM_M_CLEAR_MCNET_ASDT_LD_DATA_CON_FLAG(bChannel);   /* set on CAN task level, cleared on mainloop level */

        CSM_MCNET_vGetAsdtAddress (bChannel, &rAddrField);

        #if (CSM_S_TRACE == CSM_C_F_ON)
        {
          // checked buffer size against CSM_MAX_TRACE_LENGTH !! BKA2HI: 11/2016
          BYTE abData[11];
          #if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
          abData[ 0] = CSM_M_GET_HIBYTE(CSM_M_GET_HIWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
          abData[ 1] = CSM_M_GET_LOBYTE(CSM_M_GET_HIWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
          abData[ 2] = CSM_M_GET_HIBYTE(CSM_M_GET_LOWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
          abData[ 3] = CSM_M_GET_LOBYTE(CSM_M_GET_LOWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
          #endif // CSM_S_USE_CALLBACK_WITH_HANDLE

          abData[ 4] = CSM_M_GET_HIBYTE(CSM_M_GET_HIWORD( CSM_C_PTYPE_MCNET_ASDT_STD));/*lint !e572 !e778 PQM_authorized_multi_127*/
          abData[ 5] = CSM_M_GET_LOBYTE(CSM_M_GET_HIWORD( CSM_C_PTYPE_MCNET_ASDT_STD));/*lint !e572 !e778 PQM_authorized_multi_127*/
          abData[ 6] = CSM_M_GET_HIBYTE(CSM_M_GET_LOWORD( CSM_C_PTYPE_MCNET_ASDT_STD));
          abData[ 7] = CSM_M_GET_LOBYTE(CSM_M_GET_LOWORD( CSM_C_PTYPE_MCNET_ASDT_STD));
          abData[ 8] = rAddrField.bLocalComp;
          abData[ 9] = rAddrField.bRemoteComp;
          abData[10] = CSM_abMCNetAsdtLdDataConResults[bChannel];
          CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_CSM_DATA_CON, abData, 11);
        }
        #endif // CSM_S_TRACE
        #if (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
        if( CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataCon != NULL)
        {
          #if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
          CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataCon( CSM_MCNET_arASDTCallbackFkt[ bChannel].pvHandle,
                                                             CSM_C_PTYPE_MCNET_ASDT_STD,
                                                             (VOID*) &rAddrField,
                                                             CSM_abMCNetAsdtLdDataConResults[bChannel]);
          #else // CSM_S_USE_CALLBACK_WITH_HANDLE
          CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataCon( CSM_C_PTYPE_MCNET_ASDT_STD,
                                                             (VOID*) &rAddrField,
                                                             CSM_abMCNetAsdtLdDataConResults[bChannel]);
          #endif // CSM_S_USE_CALLBACK_WITH_HANDLE
        }
        #else /* (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON) */
        if( csm_rMCNetConnection[bChannel].pfvASDTDataCon != NULL) {
        csm_rMCNetConnection[bChannel].pfvASDTDataCon( CSM_C_PTYPE_MCNET_ASDT_STD,
                                                      (VOID*) &rAddrField,
                                                      CSM_abMCNetAsdtLdDataConResults[bChannel]); }
        #endif // (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
      } // end if long data confirmation
    } // end for all MCNet-TP channels
  }
  #endif // CSM_C_IND_REASON_MCNET_ASDT_DATA_CON

  /**********************************************************************************
   * An MCNet ASDT message was received and data will be passed to the application  */
  /**********************************************************************************/

  /**********************************************************************************/
  /* Bem.: Achtung: Derzeit wird nur der Assemblierungspuffer verwendet!            */
  /*       Fr einen Einsatz mit den "richtigen" Aplikationspuffern                 */
  /*      (CNP_rMCNetLdRxBuf etc.) muss das Ganze noch berarbeitet werden          */
  /*       Siehe auch CNP_MCNET_lBufferCheck() mit den dortigen Bemerkungen.        */
  /**********************************************************************************/

  #ifdef CSM_C_IND_REASON_MCNET_ASDT_DATA_IND
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_MCNET_ASDT_DATA_IND) )
  {
    BYTE bChannel;  /* Loop index */
    CSM_ADDR_MCNET_ASDT rAddrField;

    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_MCNET_ASDT_DATA_IND);
    for (bChannel = 0;                                /* check all channels */
         bChannel < CSM_C_MCNET_MAX_CONNECTIONS;
         bChannel++)
    {
      if ((CSM_M_IS_MCNET_ASDT_DATA_IND_FLAG_SET(bChannel))   /* if data indication is necessary */
           )
      {
        CSM_M_CLEAR_MCNET_ASDT_DATA_IND_FLAG(bChannel);     /* set on CAN task level, cleared on mainloop level */

        CSM_MCNET_vGetAsdtAddress (bChannel, &rAddrField);

        #if (CSM_S_MCNET_DOPPELPUFFER == CSM_C_F_ON)
        /* Check, if Long Data  buffer contains a message */
        if (0 == CNP_rMCNetRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].nFree)
        #else // CSM_S_MCNET_DOPPELPUFFER
        /* Check, if Long Data assembly buffer contains a message */
        if (0 == CNP_rMCNetAssRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].nFree)/*lint !e778*/
        #endif // CSM_S_MCNET_DOPPELPUFFER
        {
          #if (CSM_S_TRACE == CSM_C_F_ON)
          {
            // checked buffer size against - trace buffer sizes have been checked against CSM_MAX_TRACE_LENGTH due to reduction of the same in csm_stack_m.h !! BKA2HI: 11/2016
            BYTE abData[256];
            #if (256 > CSM_MAX_TRACE_LENGTH)
            #error "Buffer size does not match CSM_MAX_TRACE_LENGTH"
            #endif

            #if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
            abData[ 0] = CSM_M_GET_HIBYTE(CSM_M_GET_HIWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
            abData[ 1] = CSM_M_GET_LOBYTE(CSM_M_GET_HIWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
            abData[ 2] = CSM_M_GET_HIBYTE(CSM_M_GET_LOWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
            abData[ 3] = CSM_M_GET_LOBYTE(CSM_M_GET_LOWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
            #endif // CSM_S_USE_CALLBACK_WITH_HANDLE

            abData[ 4] = CSM_M_GET_HIBYTE(CSM_M_GET_HIWORD(CSM_C_PTYPE_MCNET_ASDT_STD));/*lint !e572 !e778 PQM_authorized_multi_127*/
            abData[ 5] = CSM_M_GET_LOBYTE(CSM_M_GET_HIWORD(CSM_C_PTYPE_MCNET_ASDT_STD));/*lint !e572 !e778 PQM_authorized_multi_127*/
            abData[ 6] = CSM_M_GET_HIBYTE(CSM_M_GET_LOWORD(CSM_C_PTYPE_MCNET_ASDT_STD));
            abData[ 7] = CSM_M_GET_LOBYTE(CSM_M_GET_LOWORD(CSM_C_PTYPE_MCNET_ASDT_STD));
            abData[ 8] = *((((BYTE *)&rAddrField)+0));
            abData[ 9] = *((((BYTE *)&rAddrField)+1));

            abData[10] = CSM_M_GET_HIBYTE( CNP_rMCNetAssRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.wDataLength);/*lint !e778*/
            abData[11] = CSM_M_GET_LOBYTE( CNP_rMCNetAssRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.wDataLength);/*lint !e778*/

            CSM_vMemCopy( &(abData[ 12]), CNP_rMCNetAssRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.pbData, (256-12));/*lint !e778*/
            CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_CSM_DATA_IND,
                           abData, (BYTE)(CNP_rMCNetAssRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.wDataLength+12));/*lint !e778*/
          }
          #endif // CSM_S_TRACE
          #if (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
          #if (CSM_S_MCNET_DOPPELPUFFER == CSM_C_F_ON)
          if( CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataInd != NULL)
          {
            #if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
            CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataInd( CSM_MCNET_arASDTCallbackFkt[ bChannel].pvHandle,
                                                               CSM_C_PTYPE_MCNET_ASDT_STD,
                                                               (VOID*) &rAddrField,
                                                               CNP_rMCNetRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.pbData,
                                                               CNP_rMCNetRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.wDataLength);
            #else // CSM_S_USE_CALLBACK_WITH_HANDLE
              #error
            #endif // CSM_S_USE_CALLBACK_WITH_HANDLE
          }
          #else // CSM_S_MCNET_DOPPELPUFFER
          if( CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataInd != NULL)
          {
            #if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
            CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataInd( CSM_MCNET_arASDTCallbackFkt[ bChannel].pvHandle,
                                                               CSM_C_PTYPE_MCNET_ASDT_STD,
                                                               (VOID*) &rAddrField,
                                                               CNP_rMCNetAssRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.pbData,/*lint !e778*/
                                                               CNP_rMCNetAssRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.wDataLength);/*lint !e778*/
            #else // CSM_S_USE_CALLBACK_WITH_HANDLE
            CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataInd( CSM_C_PTYPE_MCNET_ASDT_STD,
                                                               (VOID*) &rAddrField,
                                                               CNP_rMCNetAssRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.pbData,/*lint !e778*/
                                                               CNP_rMCNetAssRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.wDataLength);/*lint !e778*/
            #endif // CSM_S_USE_CALLBACK_WITH_HANDLE
          }
          #endif // CSM_S_MCNET_DOPPELPUFFER
          #else // (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
          #if (CSM_S_MCNET_DOPPELPUFFER == CSM_C_F_ON)
          if(csm_rMCNetConnection[bChannel].pfvASDTDataInd != NULL) {
          csm_rMCNetConnection[bChannel].pfvASDTDataInd( CSM_C_PTYPE_MCNET_ASDT_STD,
                                                         (VOID*) &rAddrField,
                                                         CNP_rMCNetRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.pbData,
                                                         CNP_rMCNetRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.wDataLength); }
          #else // CSM_S_MCNET_DOPPELPUFFER
          if(csm_rMCNetConnection[bChannel].pfvASDTDataInd != NULL) {
          csm_rMCNetConnection[bChannel].pfvASDTDataInd( CSM_C_PTYPE_MCNET_ASDT_STD,
                                                         (VOID*) &rAddrField,
                                                         CNP_rMCNetAssRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.pbData,
                                                         CNP_rMCNetAssRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.wDataLength); }
          #endif // CSM_S_MCNET_DOPPELPUFFER
          #endif // (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
          #if (CSM_S_MCNET_APPL_SETS_RX_BUFFER_FREE == CSM_C_F_ON)
          if(!csm_rMCNetConnection[ bChannel].fApplSetsRxBufferFree) /* application do not set the buffer free */
          #endif
          {
            /*CNP_MCNET_lAsdtDataIndProcessed( CNP_MCNET_C_LDATA_SERV-1, bChannel);*/          /* => CSM sets it free */
          }
        }

        #if (CSM_S_MCNET_DOPPELPUFFER == CSM_C_F_ON)
        /* Check, if Expedited Data buffer contains a message */
        if (0 == CNP_rMCNetRxBuf[CNP_MCNET_C_EDATA_SERV-1][bChannel].nFree)
        #else // CSM_S_MCNET_DOPPELPUFFER
        /* Check, if Expedited Data assembly buffer contains a message */
        if (0 == CNP_rMCNetAssRxBuf[CNP_MCNET_C_EDATA_SERV-1][bChannel].nFree)
        #endif // CSM_S_MCNET_DOPPELPUFFER
        {
          #if (CSM_S_TRACE == CSM_C_F_ON)
          {
            // checked buffer size against CSM_MAX_TRACE_LENGTH !! BKA2HI: 11/2016
            BYTE abData[256];
            #if (256 > CSM_MAX_TRACE_LENGTH)
            #error "Buffer size does not match CSM_MAX_TRACE_LENGTH"
            #endif

            #if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
            abData[ 0] = CSM_M_GET_HIBYTE(CSM_M_GET_HIWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
            abData[ 1] = CSM_M_GET_LOBYTE(CSM_M_GET_HIWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
            abData[ 2] = CSM_M_GET_HIBYTE(CSM_M_GET_LOWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
            abData[ 3] = CSM_M_GET_LOBYTE(CSM_M_GET_LOWORD( CSM_MCNET_arASDTCallbackFkt[bChannel].pvHandle));
            #endif // CSM_S_USE_CALLBACK_WITH_HANDLE

            abData[ 4] = CSM_M_GET_HIBYTE(CSM_M_GET_HIWORD(CSM_C_PTYPE_MCNET_ASDT_EXP));/*lint !e572 !e778 PQM_authorized_multi_127*/
            abData[ 5] = CSM_M_GET_LOBYTE(CSM_M_GET_HIWORD(CSM_C_PTYPE_MCNET_ASDT_EXP));/*lint !e572 !e778 PQM_authorized_multi_127*/
            abData[ 6] = CSM_M_GET_HIBYTE(CSM_M_GET_LOWORD(CSM_C_PTYPE_MCNET_ASDT_EXP));
            abData[ 7] = CSM_M_GET_LOBYTE(CSM_M_GET_LOWORD(CSM_C_PTYPE_MCNET_ASDT_EXP));
            abData[ 8] = *((((BYTE *)&rAddrField)+0));
            abData[ 9] = *((((BYTE *)&rAddrField)+1));

            abData[10] = CSM_M_GET_HIBYTE( CNP_rMCNetAssRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.wDataLength);/*lint !e778*/
            abData[11] = CSM_M_GET_LOBYTE( CNP_rMCNetAssRxBuf[CNP_MCNET_C_LDATA_SERV-1][bChannel].rMsg.wDataLength);/*lint !e778*/

            CSM_vMemCopy(&(abData[10]), CNP_rMCNetAssRxBuf[CNP_MCNET_C_EDATA_SERV-1][bChannel].rMsg.pbData, (256-10));
            CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_CSM_DATA_IND,
                           abData, (BYTE)(CNP_rMCNetAssRxBuf[CNP_MCNET_C_EDATA_SERV-1][bChannel].rMsg.wDataLength+10));
          }
          #endif // CSM_S_TRACE

          #if (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
          #if (CSM_S_MCNET_DOPPELPUFFER == CSM_C_F_ON)
          if( CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataInd != NULL)
          {
            #if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
            CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataInd( CSM_MCNET_arASDTCallbackFkt[ bChannel].pvHandle,
                                                               CSM_C_PTYPE_MCNET_ASDT_EXP,
                                                               (VOID*) &rAddrField,
                                                               CNP_rMCNetRxBuf[CNP_MCNET_C_EDATA_SERV-1][bChannel].rMsg.pbData,
                                                               CNP_rMCNetRxBuf[CNP_MCNET_C_EDATA_SERV-1][bChannel].rMsg.wDataLength);
            #else // CSM_S_USE_CALLBACK_WITH_HANDLE
              #error
            #endif // CSM_S_USE_CALLBACK_WITH_HANDLE
          }
          #else // CSM_S_MCNET_DOPPELPUFFER
          if( CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataInd != NULL)
          {
            #if (CSM_S_USE_CALLBACK_WITH_HANDLE == CSM_C_F_ON)
            CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataInd( CSM_MCNET_arASDTCallbackFkt[ bChannel].pvHandle,
                                                               CSM_C_PTYPE_MCNET_ASDT_EXP,
                                                               (VOID*) &rAddrField,
                                                               CNP_rMCNetAssRxBuf[CNP_MCNET_C_EDATA_SERV-1][bChannel].rMsg.pbData,
                                                               CNP_rMCNetAssRxBuf[CNP_MCNET_C_EDATA_SERV-1][bChannel].rMsg.wDataLength);
            #else // CSM_S_USE_CALLBACK_WITH_HANDLE
            CSM_MCNET_arASDTCallbackFkt[ bChannel].pfvDataInd( CSM_C_PTYPE_MCNET_ASDT_EXP,
                                                               (VOID*) &rAddrField,
                                                               CNP_rMCNetAssRxBuf[CNP_MCNET_C_EDATA_SERV-1][bChannel].rMsg.pbData,
                                                               CNP_rMCNetAssRxBuf[CNP_MCNET_C_EDATA_SERV-1][bChannel].rMsg.wDataLength);
            #endif // CSM_S_USE_CALLBACK_WITH_HANDLE
          }
          #endif // CSM_S_MCNET_DOPPELPUFFER
          #else // (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
          #if (CSM_S_MCNET_DOPPELPUFFER == CSM_C_F_ON)
          if(csm_rMCNetConnection[bChannel].pfvASDTDataInd != NULL) {
          csm_rMCNetConnection[bChannel].pfvASDTDataInd( CSM_C_PTYPE_MCNET_ASDT_EXP,
                                                         (VOID*) &rAddrField,
                                                         CNP_rMCNetRxBuf[CNP_MCNET_C_EDATA_SERV-1][bChannel].rMsg.pbData,
                                                         CNP_rMCNetRxBuf[CNP_MCNET_C_EDATA_SERV-1][bChannel].rMsg.wDataLength);}
          #else // CSM_S_MCNET_DOPPELPUFFER
          if(csm_rMCNetConnection[bChannel].pfvASDTDataInd != NULL) {
          csm_rMCNetConnection[bChannel].pfvASDTDataInd( CSM_C_PTYPE_MCNET_ASDT_EXP,
                                                         (VOID*) &rAddrField,
                                                         CNP_rMCNetAssRxBuf[CNP_MCNET_C_EDATA_SERV-1][bChannel].rMsg.pbData,
                                                         CNP_rMCNetAssRxBuf[CNP_MCNET_C_EDATA_SERV-1][bChannel].rMsg.wDataLength);}
          #endif // CSM_S_MCNET_DOPPELPUFFER
          #endif // (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
          #if (CSM_S_MCNET_APPL_SETS_RX_BUFFER_FREE == CSM_C_F_ON)
          if(!csm_rMCNetConnection[ bChannel].fApplSetsRxBufferFree) /* application do not set the buffer free */
          #endif
          {
            /*CNP_MCNET_lAsdtDataIndProcessed( CNP_MCNET_C_EDATA_SERV-1,bChannel);*/          /* => CSM sets it free */
          }
        }
      } // end if communication indication
    } // end for all MCNet-TP channels
  } // end if CSM_C_IND_REASON_MCNET_ASDT_DATA_IND
  #endif // CSM_C_IND_REASON_MCNET_ASDT_DATA_IND

  /**********************************************************************************
   * An MCNet USDT message was sent and the result will be passed to the application  */
  #ifdef CSM_C_IND_REASON_MCNET_USDT_DATA_CON
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_MCNET_USDT_DATA_CON) )
  {
    BYTE bChannel;  /* Loop index */
    CSM_ADDR_MCNET_USDT rAddrField;

    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_MCNET_USDT_DATA_CON);
    for (bChannel = 0;                                /* check all channels */
         bChannel < CSM_C_MCNET_MAX_USDT_TX_CHANNELS;  /* U.Z.(6): besser evtl. Variable ?!*/
         bChannel++)
    {
      if ((CSM_M_IS_MCNET_USDT_DATA_CON_FLAG_SET(bChannel)) &&  /* if data indication is necessary */
          (csm_rMCNetUsdtTxChannel[bChannel].pfvUSDTDataCon != NULL) )
      {
        CSM_M_CLEAR_MCNET_USDT_DATA_CON_FLAG(bChannel);     /* set on CAN task level, cleared on mainloop level */

        CSM_MCNET_vGetUsdtTxAddress (bChannel, &rAddrField);

        /* Result always positive! */
        csm_rMCNetUsdtTxChannel[bChannel].pfvUSDTDataCon( CSM_C_PTYPE_MCNET_USDT,
                                                          (VOID*) &rAddrField,
                                                          CSM_C_CONF_OK );

        CNP_rMCNetBdTxBuf[bChannel].nFree = TRUE;  /* TX channel free for new data request */
        CNP_rMCNetBdTxBuf[bChannel].nRd   = 0;     /* Reset read pointer for TX message    */

      } // end if communication indication
    } // end for all MCNet USDT RX channels
  }
  #endif // CSM_C_IND_REASON_MCNET_USDT_DATA_CON


  /**********************************************************************************
   * An MCNet USDT message was received and data will be passed to the application  */
  /**********************************************************************************/

  /**********************************************************************************/
  /* Bem.: Achtung: Derzeit wird nur der Assemblierungspuffer verwendet!            */
  /*       Fr einen Einsatz mit den "richtigen" Aplikationspuffern                 */
  /*      (CNP_rMCNetBdRxBuf etc.) muss das Ganze noch berarbeitet werden          */
  /*       Siehe auch CNP_MCNET_lBufferCheck() mit den dortigen Bemerkungen.        */
  /**********************************************************************************/

  #ifdef CSM_C_IND_REASON_MCNET_USDT_DATA_IND
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_MCNET_USDT_DATA_IND) )
  {
    BYTE bChannel;  /* Loop index */
    CSM_ADDR_MCNET_USDT rAddrField;

    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_MCNET_USDT_DATA_IND);
    for (bChannel = 0;                                /* check all channels */
         bChannel < CSM_C_MCNET_MAX_USDT_RX_CHANNELS;  /* U.Z.(6): besser evtl. Variable ?!*/
         bChannel++)
    {
      if ((CSM_M_IS_MCNET_USDT_DATA_IND_FLAG_SET(bChannel)) &&  /* if data indication is necessary */
          (csm_rMCNetUsdtRxChannel[bChannel].pfvUSDTDataInd != NULL) )
      {
        CSM_M_CLEAR_MCNET_USDT_DATA_IND_FLAG(bChannel);     /* set on CAN task level, cleared on mainloop level */

        CSM_MCNET_vGetUsdtRxAddress (bChannel, &rAddrField);

        if (0 == CNP_rMCNetAssUsdtRxBuf[bChannel].nFree) /* Standard/Long */
        {

          csm_rMCNetUsdtRxChannel[bChannel].pfvUSDTDataInd( CSM_C_PTYPE_MCNET_USDT  /*dwProtocollType*/,
                                                            (VOID*) &rAddrField,
                                                            CNP_rMCNetAssUsdtRxBuf[bChannel].rMsg.pbData/*pbData*/,
                                                            CNP_rMCNetAssUsdtRxBuf[bChannel].rMsg.wDataLength/*wDataLength*/);

          CNP_rMCNetAssUsdtRxBuf[bChannel].nFree = 1;
        }

      } /* end if communication indication */
    } /* end for all MCNet USDT RX channels */
  }
  #endif // CSM_C_IND_REASON_MCNET_USDT_DATA_IND

  #if (CSM_S_VW_TP_2_0 == CSM_C_F_ON)
  #if (CSM_S_VWTP20_IND_ON_ML_LEVEL == CSM_C_F_ON)
  /*****************************************************************************
  * Indication and confirmation on mainloop level for VW-TP20, if configured
  *
   *****************************************************************************
   * The "connection state" of a VW-TP channel has changed and now the current
   * state will be passed to the application.
   * (communication indication or communication confirmation)
  */
  #ifdef CSM_C_IND_REASON_VWTP20_COMM_IND
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_VWTP20_COMM_IND) )
  {
    BYTE bChan;   /* Loop index */

    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_VWTP20_COMM_IND);
    for (bChan = 0; bChan < CSM_C_VW_TP20_CONNECTIONS; bChan++)
    {
      if (CSM_M_IS_VWTP20_CONNECT_IND_FLAG(bChan) ) /* if connection confirmation is necessary */
      {
        BYTE bConnectState = CSM_M_IS_VWTP20_CONNECT_STATE_FLAG_SET(bChan) ? CSM_C_CONNECTED : CSM_C_DISCONNECTED;

        CSM_M_CLR_VWTP20_CONNECT_IND_FLAG(bChan);     /* set on CAN task level, cleared on mainloop level */

        CSM_VW_vSendCommInd(bChan, bConnectState);
      } /* end if connection indication */
    } /* end for all VW-TP channels */
  } /* end if Connection Reason set */
  #endif // CSM_C_IND_REASON_VWTP_COMM_IND

  #ifdef CSM_C_IND_REASON_VWTP20_COMM_CON
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_VWTP20_COMM_CON) )
  {
    BYTE bChan;        /* Loop index */


    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_VWTP20_COMM_CON);
    for (bChan = 0; bChan < CSM_C_VW_TP20_CONNECTIONS; bChan++)
    {
      if (CSM_M_IS_VWTP20_CONNECT_CON_FLAG_SET(bChan) ) /* if connection confirmation is necessary */
      {
        BYTE bConnectState = CSM_M_IS_VWTP20_CONNECT_STATE_FLAG_SET(bChan) ? CSM_C_CONNECTED : CSM_C_DISCONNECTED;

        CSM_M_CLR_VWTP20_CONNECT_CON_FLAG(bChan);     /* set on CAN task level, cleared on mainloop level */

        CSM_VW_vSendComConf(bChan, bConnectState);
      } /* end if connection confirmation */
    } /* end for all VW-TP channels */
  } /* end if Connection Reason set */
  #endif // CSM_C_IND_REASON_VWTP_COMM_CON

  /*************************************************************************
  * The data transmit was finished by a VW-TP channel and now the transfer
  * result will be passed to the application.
  */
  #ifdef CSM_C_IND_REASON_VWTP20_DATA_CON
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_VWTP20_DATA_CON) )
  {
    BYTE bChan;        /* Loop index */


    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_VWTP20_DATA_CON);
    for (bChan = 0; bChan < CSM_C_VW_TP20_CONNECTIONS; bChan++)
    {
      if (CSM_M_IS_VWTP20_DATA_CON_FLAG_SET(bChan) ) /* if Data confirmation is necessary */
      {                                          /* get transfer result */
        BYTE bTransferResult = CSM_M_IS_VWTP20_DATA_RESULT_FLAG_SET(bChan) ? CSM_C_CONF_OK : CSM_C_CONF_FAULT;

        CSM_M_CLR_VWTP20_DATA_CON_FLAG(bChan);     /* set on CAN task level, cleared on mainloop level */

        CSM_VW_vSendDataConf(bChan,bTransferResult);
      } /* end if Data Indication */
    } /* end for all VW-TP channels */
  } /* end if Data indication Reason set */
  #endif // CSM_C_IND_REASON_VWTP_DATA_CON

  /*************************************************************************
  * Data was received by a VW-TP channel and now the data
  * will be passed to the application.
  */
  #ifdef CSM_C_IND_REASON_VWTP20_DATA_IND
  if ( CSM_M_IS_IND_REASON_SET(CSM_C_IND_REASON_VWTP20_DATA_IND) )
  {
    BYTE bChan;        /* Loop index */


    CSM_M_CLEAR_IND_REASON(CSM_C_IND_REASON_VWTP20_DATA_IND);
    for (bChan = 0; bChan < CSM_C_VW_TP20_CONNECTIONS; bChan++)
    {
      if (CSM_M_IS_VWTP20_DATA_IND_FLAG_SET(bChan) ) /* if connection confirmation is necessary */
      {
        CSM_M_CLR_VWTP20_DATA_IND_FLAG(bChan);     /* set on CAN task level, cleared on mainloop level */

        CSM_VW_vSendDataInd(bChan);
      } /* end if Data Indication */
    } /* end for all VW-TP channels */
  } /* end if Data indication Reason set */
  #endif // CSM_C_IND_REASON_VWTP_DATA_IND
  #endif // if (CSM_S_VWTP20_IND_ON_ML_LEVEL == CSM_C_F_ON )
  #endif // CSM_S_VW_TP_2_0

  #endif // CSM_S_CNP_AVAILABLE

  /*****************************************************************************/
  /********************************** B A P ************************************/

  /*************************************************************************
  * A BAP communication request is to be confirmed to the application
  */
  #ifdef CSM_C_IND_REASON_BAP_COMM_CON
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_BAP_COMM_CON) )
  {
    CSM_BAP_vProcessCommCon();
  }
  #endif // CSM_C_IND_REASON_BAP_COMM_CON

  /*************************************************************************
  * A BAP data request is to be confirmed to the application now.
  */
  #ifdef CSM_C_IND_REASON_BAP_DATA_CON
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_BAP_DATA_CON) )
  {
    CSM_BAP_vProcessDataCon();
  }
  #endif // CSM_C_IND_REASON_BAP_DATA_CON

  /*************************************************************************
  * BAP data has been received and must be delivered to the application
  * now.
  */
  #ifdef CSM_C_IND_REASON_BAP_DATA_IND
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_BAP_DATA_IND) )
  {
    CSM_BAP_vProcessDataInd();
  }
  #endif // CSM_C_IND_REASON_BAP_DATA_IND

  #ifdef CSM_C_IND_REASON_DTC_ERROR_IND
  if ( CSM_M_IS_IND_REASON_SET( CSM_C_IND_REASON_DTC_ERROR_IND) )
  {
    CSM_vDTCEventCallback();
  }
  #endif /* CSM_C_IND_REASON_BAP_DATA_IND */

} // end CSM_vUpstreamTask()

/*******************************************************************************
 * function    CSM_vDownstreamTask
 * \doxydocu
 * \brief      Calls the CSM module functions on CAN task level because many
 *             functions are not reentrant and have to be called on same level.
 *
 *
 * \return     void
 *
 * \access     CAN task
 * \reentrant  no
 *
 * \lastreview 21.11.08 VTeam-Zurmhl
 *             18.04.08 VTeam-Prhl
 *
 * \history_begin
 * 18.11.08 Prhl
 * Function call CNP_MPDT_vProcessSendTelegram() added for down reason CSM_C_DOWN_REASON_CNP_MPDT_SEND_TELEGRAM. This is for MPDT TTmin support.
 *
 * 17.11.08 Prhl
 * Function call CDA_vProcessDataCon() added for down reason CSM_C_DOWN_REASON_CDA_CON. This is for CDA data confimation support.
 *
 * 29.09.08 Prhl
 * Function CNP_MPDT_lBusoffEntry() added down reason CSM_C_DOWN_REASON_CDA_BUSOFF_ENTRY. Nissan has now network management to handle bus off.
 *
 * 24.09.08 Prhl
 * CSM_C_DOWN_REASON_CNP_MPDT_PACKET_DATA_REQ added to call CNP_MPDT_vProcessPacketDataReq().
 *
 * 18.04.08 VTeam-Prhl
 * down reason CSM_C_DOWN_REASON_BAP_OWN_PROCESSING added.
 *
 * 16.08.07 RBIN/EDI2-Basavaraj
 * - Adaptation of the Volcano driver
 *
 * 28.06.06 CM-DI/ESA3-Haffner
 * proxy handling added
 *
 *18.01.05 CM-DI/ESA3-K"ohler
 * CDA_lSend() with Tx-struct used instead of CDA_lSendRaw to transmit Opel
 * broadcast telegrams.
 *
 *27.02.04 CM-DI/ESU3-K"ohler
 *Downstream reason (= call on downstream task level) bus state change added.
 *
 *13.01.04 CM-DI/EHS3-Zurmuehl
 *bBus deleted in CSM_MCNET_vCNP_ConnectCon, CNP_MCNET_lASDT_DataReq,
 *CNP_MCNET_lUSDTDataReq, CSM_MCNET_vCNP_USDTDataCon and CSM_MCNET_vCNP_ASDTDataCon
 *
 *04.11.02 CM-DI/EHS3-Pistoor
 *Initial version
 *
 * \history_end
 ******************************************************************************/
VOID CSM_vDownstreamTask(VOID)
{
  //*************************************************************************
  // Proxy downstream handling
  //*************************************************************************
  #if (CSM_S_REMOTE_STACK == CSM_C_F_ON)

  // Handling of local IPC TX requests (on Proxy Site) for BR, NET and TP channels.
  // Names of handler functions and down reasons have been changed !!!

  // BR (CommReq and SignalWrite)
  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_IPC_LOCAL_BR_REQ_TX) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_IPC_LOCAL_BR_REQ_TX);
    CSM_PROXY_vProcess_IPC_LOCAL_BrRequests();
  }

  // NET (CommReq)
  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_IPC_LOCAL_NET_REQ_TX) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_IPC_LOCAL_NET_REQ_TX);
    CSM_PROXY_vProcess_IPC_LOCAL_NetRequests();
  }

  // TP (CommReq, DataReq)
  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_IPC_LOCAL_TP_DATA_REQ);
    CSM_PROXY_vProcess_IPC_LOCAL_TpDataReq();
  }

  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_IPC_LOCAL_TP_COMM_REQ);
    CSM_PROXY_vProcess_IPC_LOCAL_TpCommReq();
  }

  // In the following section we process IPC RX data (on Proxy site) for BR, NET and NP channels
  // BKA2HI: To have a common mechanism for ALL these IPC RX data, TP handling has been moved here
  // from UPSTREAM task. The names of the handler functions have been changed as well.
  // If this mechanism is handled by DOWN or UP stream task, is absolutely free of choice.
  // It is only important to have a common path for ALL 3 data types.

  // NET
  #ifdef CSM_C_DOWN_REASON_IPC_REMOTE_NET_DATA_RX
  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_IPC_REMOTE_NET_DATA_RX) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_IPC_REMOTE_NET_DATA_RX);
    CSM_PROXY_vProcess_IPC_REMOTE_NetData();
  }
  #endif

  // BR
  #ifdef CSM_C_DOWN_REASON_IPC_REMOTE_BR_DATA_RX
  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_IPC_REMOTE_BR_DATA_RX) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_IPC_REMOTE_BR_DATA_RX);
    CSM_PROXY_vProcess_IPC_REMOTE_BrData();
  }
  #endif

  // NP (TP)
  #ifdef CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX
  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_IPC_REMOTE_TP_DATA_RX);
    CSM_PROXY_vProcess_IPC_REMOTE_TpData();
  }
  #endif

  // Timeout indication for IPC Proxy BR, NET and NP channels (TX direction to v850 via IPC)
  #ifdef CSM_C_DOWN_REASON_IPC_PROXY_TX_TIMEOUT
  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_IPC_PROXY_TX_TIMEOUT) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_IPC_PROXY_TX_TIMEOUT);
    CSM_PROXY_vProcess_IPC_TX_ResponseTimeout();
  }
  #endif
  #endif // CSM_S_REMOTE_STACK == CSM_C_F_ON

  //*************************************************************************
  // CDA downstream handling
  //*************************************************************************
  #ifdef CSM_C_DOWN_REASON_CDA_BUSOFF_ENTRY_CAN0
    #error "CSM_C_DOWN_REASON_CDA_BUSOFF_ENTRY_CAN0 not supported any more ! Use CSM_C_DOWN_REASON_CDA_BUSOFF_ENTRY instead !!"
  #endif

  #ifdef CSM_C_DOWN_REASON_CDA_BUSOFF_ENTRY
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CDA_BUSOFF_ENTRY) )
  {
    BYTE bBus;
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CDA_BUSOFF_ENTRY);

    for (bBus=0; bBus < CSM_C_MAX_CAN_BUS; bBus++)
    {
      if (csm_bBusOffState[ bBus].fEntryIndication == TRUE)
      {
        csm_bBusOffState[ bBus].fEntryIndication = FALSE;
        CDA_lBusoffEntry( bBus);
        #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
        #if (CSM_S_MPDT == CSM_C_F_ON)
          CNP_MPDT_lBusoffEntry( bBus); // Nissan has no network management
        #endif
        #if (CSM_S_J1939 == CSM_C_F_ON)
          CNP_J1939_lBusoffEntry( bBus); /* J1939 may have no NM */
        #endif
        #endif
        #if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
          CNM_lBusoffEntry( bBus);
        #endif
        #if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)
        #if (CSM_S_CDA_SENDRESTRICTION == CSM_C_F_ON)
          #if (CSM_S_CDA_BUSOFF_SENDRESTRICTION == CSM_C_F_ON)
          /* This is a FIAT only feature up to now. Please check if there is a better way to do this in
          CDA_lBusoffEntry(), because only CDA is affected by the send restriction affected */
          CSM_vEnableBusoffSendRestriction( bBus);
          #endif
        #endif
        #endif

        #if (CSM_S_ENABLE_INDICATE_BUSERROR == CSM_C_F_ON)
          #if (CSM_S_INDICATE_BUSOFF_TO_APPLICATION == CSM_C_F_ON)
           CSM_vIndicateBusError(bBus, CSM_C_BUS_OFF, TRUE);
          #endif
        #endif
      }
    }
  }
  #endif // CSM_C_DOWN_REASON_CDA_BUSOFF_ENTRY

  #ifdef CSM_C_DOWN_REASON_CDA_BUSOFF_RECOVERY_CAN0
    #error "CSM_C_DOWN_REASON_CDA_BUSOFF_RECOVERY_CAN0 not supported any more ! Use CSM_C_DOWN_REASON_CDA_BUSOFF_RECOVERY instead !!"
  #endif

  #ifdef CSM_C_DOWN_REASON_CDA_BUSOFF_RECOVERY
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CDA_BUSOFF_RECOVERY) )
  {
    BYTE bBus;
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CDA_BUSOFF_RECOVERY);

    for (bBus=0; bBus < CSM_C_MAX_CAN_BUS; bBus++)
    {
      if (csm_bBusOffState[ bBus].fRecoveryIndication == TRUE)
      {
        csm_bBusOffState[ bBus].fRecoveryIndication = FALSE;
        CDA_lBusoffRecovery( bBus);
        #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
        #if (CSM_S_J1939 == CSM_C_F_ON)
          CNP_J1939_lBusoffRecovery( bBus); /* J1939 may have no NM */
        #endif
        #endif
        #if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
          CNM_lBusoffRecovery( bBus);
        #endif

        #if (CSM_S_CSM_VW == CSM_C_F_OFF)
          #if (CSM_S_CDA_END_BUS_OFF_WITH_DATA_IND == CSM_C_F_OFF)
            #if (CSM_S_ENABLE_INDICATE_BUSERROR == CSM_C_F_ON)
              #if (CSM_S_INDICATE_BUSOFF_TO_APPLICATION == CSM_C_F_ON)
               CSM_vIndicateBusError(bBus, CSM_C_BUS_OFF, FALSE);
              #endif
            #endif
          #endif /* CSM_S_CDA_END_BUS_OFF_WITH_DATA_IND */
        #endif /* CSM_S_CSM_VW */
      }
    }
  }
  #endif // CSM_C_DOWN_REASON_CDA_BUSOFF_RECOVERY

  #ifdef CSM_C_DOWN_REASON_CDA_SEND
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CDA_SEND) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CDA_SEND);
    CDA_vProcessSend();
  }
  #endif // CSM_C_DOWN_REASON_CDA_SEND

  #ifdef CSM_C_DOWN_REASON_CDA_IND
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CDA_IND) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CDA_IND);
    CDA_vProcessDataInd();
  }
  #endif // CSM_C_DOWN_REASON_CDA_IND

  #ifdef CSM_C_DOWN_REASON_CDA_CON
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CDA_CON) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CDA_CON);
    CDA_vProcessDataCon();
  }
  #endif // CSM_C_DOWN_REASON_CDA_CON

  //**************************************************************************
  // CDA_LLD_LIN downstream handling
  #ifdef CSM_C_DOWN_REASON_CDA_LLD_LIN_TX_CON
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CDA_LLD_LIN_TX_CON) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CDA_LLD_LIN_TX_CON);
    CDA_LLD_LIN_vTxConfirmationProcess();
  }
  #endif // CSM_C_DOWN_REASON_CDA_LLD_LIN_TX_CON

  //**************************************************************************
  // CBR downstream handling
  //**************************************************************************
  #if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
  #ifdef CSM_C_DOWN_REASON_CBR_SEND
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CBR_SEND) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CBR_SEND);
    CBR_vProcessTransmit();
  }
  #endif // CSM_C_DOWN_REASON_CBR_SEND

  #ifdef CSM_C_DOWN_REASON_CBR_TIMEOUT
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CBR_TIMEOUT) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CBR_TIMEOUT);
    CBR_vProcessTimeout();
  }
  #endif // CSM_C_DOWN_REASON_CBR_TIMEOUT

  #ifdef CSM_C_DOWN_REASON_CBR_COMMUNICATION_REQ
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CBR_COMMUNICATION_REQ) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CBR_COMMUNICATION_REQ);
    CSM_CBR_vProcessCommunicationReq();
  }
  #endif // CSM_C_DOWN_REASON_CBR_COMMUNICATION_REQ
  #endif // CSM_S_CBR_AVAILABLE

  //**************************************************************************
  // CSM downstream handling
  //**************************************************************************
  #ifdef CSM_C_DOWN_REASON_CSM_COMMUNICATION_REQ
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CSM_COMMUNICATION_REQ) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CSM_COMMUNICATION_REQ);
    CSM_LCTR_vProcessCommunicationReq();
  }
  #endif // CSM_C_DOWN_REASON_CSM_COMMUNICATION_REQ */

  #ifdef CSM_C_DOWN_REASON_CSM_BUS_STATE_CHANGED
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CSM_BUS_STATE_CHANGED) )
  {
    BYTE bBus;

    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CSM_BUS_STATE_CHANGED);

    for( bBus = 0; bBus < CSM_C_MAX_CAN_BUS; bBus++)
    {
      CSM_vProcessBusStateChange( bBus);
    }
  }
  #endif // CSM_C_DOWN_REASON_CSM_BUS_STATE_CHANGED

  #ifdef CSM_C_DOWN_REASON_CSM_STACK_ACTIVATED
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CSM_STACK_ACTIVATED) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CSM_STACK_ACTIVATED);
    CSM_vStackActivated();
  }
  #endif // CSM_C_DOWN_REASON_CSM_STACK_ACTIVATED

  #ifdef CSM_C_DOWN_REASON_CSM_IND_RADIOISON
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CSM_IND_RADIOISON) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CSM_IND_RADIOISON);
    #if (CSM_S_FIATSLAVE_NM == CSM_C_F_ON)
      CNM_vFiatSlave_NMRequest( CNM_FIATSLAVE_REQ_NET_ON);
    #endif
  }
  #endif // CSM_C_DOWN_REASON_CSM_IND_RADIOISON

  #ifdef CSM_C_DOWN_REASON_CSM_IND_RADIOISOFF
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CSM_IND_RADIOISOFF) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CSM_IND_RADIOISOFF);
    #if (CSM_S_FIATSLAVE_NM == CSM_C_F_ON)
      CNM_vFiatSlave_NMRequest( CNM_FIATSLAVE_REQ_NET_OFF);
    #endif
  }
  #endif // CSM_C_DOWN_REASON_CSM_IND_RADIOISOFF

  #ifdef CSM_C_DOWN_REASON_CSM_IND_RADIOSTATUSCHANGED
  /* THIS SHOULD REPLACE RADIOISON and RADIOISOFF ! */
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CSM_IND_RADIOSTATUSCHANGED) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CSM_IND_RADIOSTATUSCHANGED);

    #if (CSM_S_REMOTE_STACK == CSM_C_F_ON)
      CSM_PROXY_vProcessPowerState ();
    #endif
  }
  #endif // CSM_C_DOWN_REASON_CSM_IND_RADIOSTATUSCHANGED

  #ifdef CSM_C_DOWN_REASON_CSM_IND_EEMS_CHK_ON
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CSM_IND_EEMS_CHK_ON) )
  {
    LONG lStatus;
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CSM_IND_EEMS_CHK_ON);
    lStatus = CNM_lFiatSlave_GetStatus( CSM_C_CAN_1);
    if ((lStatus == CNM_FIATSLAVE_C_NM_IND_NET_OFF)
     || (lStatus == CNM_FIATSLAVE_C_NM_IND_NET_CHECK))
    {
      CNM_vFiatSlave_NMRequest( CNM_FIATSLAVE_REQ_NET_ON);
    }
    else if (lStatus == CNM_FIATSLAVE_C_NM_IND_NET_ON)
    {
      csm_vTriggerCsmUpstreamTask( CSM_C_IND_REASON_EEMS_IND);
    }
    else
    {
      /* nothing to do here because net is starting at present and EEMS msg */
      /* will be delivered soon to PWR and DIM once the net is fully up */
    }
  }
  #endif // CSM_C_DOWN_REASON_CSM_IND_EEMS_CHK_ON_IND

  #ifdef CSM_C_DOWN_REASON_CSM_EVENT_LISTENER
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CSM_EVENT_LISTENER) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CSM_EVENT_LISTENER);
    CSM_VW_vNMEventListenerPCAN();
  }
  #endif // CSM_C_DOWN_REASON_CSM_IND_EEMS_CHK_ON_IND

  #ifdef CSM_C_DOWN_REASON_CSM_IND_EEMS_CHK_OFF
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CSM_IND_EEMS_CHK_OFF) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CSM_IND_EEMS_CHK_OFF);
    CNM_vFiatSlave_NMRequest( CNM_FIATSLAVE_REQ_NET_OFF);
  }
  #endif // CSM_C_DOWN_REASON_CSM_IND_EEMS_CHK_ON_IND

  //**************************************************************************
  // CNP downstream handling
  //**************************************************************************
  #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)

  // ISO TP ----------------------
  #if (CSM_S_ISO_TP == CSM_C_F_ON)
    #ifdef CSM_C_DOWN_REASON_CNP_ITP_COMMUNICATION_REQ
    if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CNP_ITP_COMMUNICATION_REQ) )
    {
      CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CNP_ITP_COMMUNICATION_REQ);
    #if (CSM_S_ITP_COMMUNICATION_FCT == CSM_C_F_ON)
      CSM_ITP_vProcessCommunicationReq();
    #endif
    }
    #endif // CSM_C_DOWN_REASON_CNP_ITP_COMMUNICATION_REQ

    #ifdef CSM_C_DOWN_REASON_ITP_DATA_REQ
    if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_ITP_DATA_REQ) )
    {
      CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_ITP_DATA_REQ);
      CNP_ITP_vProcessDataReq();
    }
    #endif // CSM_C_DOWN_REASON_ITP_DATA_REQ

    #ifdef CSM_C_DOWN_REASON_ITP_DATA_IND_PROCESSED
    if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_ITP_DATA_IND_PROCESSED) )
    {
      CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_ITP_DATA_IND_PROCESSED);
      CNP_ITP_vProcessDataIndProcessed();
    }
    #endif // CSM_C_DOWN_REASON_ITP_DATA_IND_PROCESSED

    #ifdef CSM_C_DOWN_REASON_ITP_TIMEOUT
    if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_ITP_TIMEOUT) )
    {
      CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_ITP_TIMEOUT);
      CNP_ITP_vProcessTimeout();
    }
    #endif // CSM_C_DOWN_REASON_ITP_TIMEOUT
  #endif // CSM_S_ISO_TP == CSM_C_F_ON

  // UUDT ------------------------------
  #ifdef CSM_C_DOWN_REASON_UUDT_DATA_REQ
  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_UUDT_DATA_REQ) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_UUDT_DATA_REQ);
    CNP_UUDT_vProcessDataReq();
  }
  #endif // CSM_C_DOWN_REASON_UUDT_DATA_REQ

  #ifdef CSM_C_DOWN_REASON_UUDT_DATA_IND_PROCESSED
  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_UUDT_DATA_IND_PROCESSED) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_UUDT_DATA_IND_PROCESSED);
    CNP_UUDT_vProcessDataIndProcessed();
  }
  #endif // CSM_C_DOWN_REASON_UUDT_DATA_IND_PROCESSED

  // MPDT -----------------------
  #if ( CSM_S_MPDT == CSM_C_F_ON )
    #ifdef CSM_C_DOWN_REASON_CSM_MPDT_COMMUNICATION_REQ
    if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CSM_MPDT_COMMUNICATION_REQ) )
    {
      CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CSM_MPDT_COMMUNICATION_REQ);
      CSM_MPDT_vProcessCommunicationReq();
    }
    #endif // CSM_C_DOWN_REASON_CSM_MPDT_COMMUNICATION_REQ

    #ifdef CSM_C_DOWN_REASON_CNP_MPDT_DATA_REQ
    if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CNP_MPDT_DATA_REQ) )
    {
      CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CNP_MPDT_DATA_REQ);
      CNP_MPDT_vProcessDataReq();
    }
    #endif // CSM_C_DOWN_REASON_CNP_MPDT_DATA_REQ

    #ifdef CSM_C_DOWN_REASON_CNP_MPDT_DATA_IND_PROCESSED
    if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CNP_MPDT_DATA_IND_PROCESSED) )
    {
      CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CNP_MPDT_DATA_IND_PROCESSED);
      CNP_MPDT_vProcessDataIndProcessed();
    }
    #endif // CSM_C_DOWN_REASON_CNP_MPDT_DATA_IND_PROCESSED

    #ifdef CSM_C_DOWN_REASON_CNP_MPDT_TIMEOUT
    if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CNP_MPDT_TIMEOUT) )
    {
      CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CNP_MPDT_TIMEOUT);
     CNP_MPDT_vProcessTimeout();
    }
    #endif // CSM_C_DOWN_REASON_CNP_MPDT_TIMEOUT

    #ifdef CSM_C_DOWN_REASON_CNP_MPDT_PACKET_DATA_REQ
    if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CNP_MPDT_PACKET_DATA_REQ) )
    {
      CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CNP_MPDT_PACKET_DATA_REQ);
      CNP_MPDT_vProcessPacketDataReq();
    }
    #endif // CSM_C_DOWN_REASON_CNP_MPDT_PACKET_DATA_REQ

    #ifdef CSM_C_DOWN_REASON_CNP_MPDT_SEND_TELEGRAM
    if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CNP_MPDT_SEND_TELEGRAM) )
    {
      CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CNP_MPDT_SEND_TELEGRAM);
      CNP_MPDT_vProcessSendTelegram();
    }
    #endif // CSM_C_DOWN_REASON_CNP_MPDT_SEND_TELEGRAM
  #endif // CSM_S_MPDT == CSM_C_F_ON

  // LCTRL ----------------------------------
  #ifdef CSM_C_DOWN_REASON_CNP_LCTR_DATA_REQ
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CNP_LCTR_DATA_REQ) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CNP_LCTR_DATA_REQ);
    CNP_LCTR_vProcessDataReq();
  }
  #endif // CSM_C_DOWN_REASON_CNP_LCTR_DATA_REQ

  // J1939 -------------------------------
  #ifdef CSM_C_DOWN_REASON_J1939_DATA_REQ
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_J1939_DATA_REQ ) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_J1939_DATA_REQ );
    CSM_J1939_vProcessDataReq();
  }
  #endif

  #ifdef CSM_C_DOWN_REASON_J1939_COMMUNICATION_REQ
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_J1939_COMMUNICATION_REQ ) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_J1939_COMMUNICATION_REQ );
    CSM_J1939_vProcessCommunicationReq();
  }
  #endif

  #ifdef CSM_C_DOWN_REASON_J1939_DATA_IND_PROCESSED
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_J1939_DATA_IND_PROCESSED ) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_J1939_DATA_IND_PROCESSED );
    CSM_J1939_vProcessDataIndProcessed();
  }
  #endif

  #ifdef CSM_C_DOWN_REASON_J1939_PGN_TIMEOUT
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_J1939_PGN_TIMEOUT ) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_J1939_PGN_TIMEOUT );
    CSM_J1939_vProcessPGNTimeout();
  }
  #endif

  #endif // CSM_S_CNP_AVAILABLE

  /*****************************************************************************
   * MCNet Slave NM: Watchdog monitor indication                              */
  #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
  #ifdef CSM_C_DOWN_REASON_MCNET_WD_MON_IND
  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_MCNET_WD_MON_IND) )
  {
    BYTE bSlaveNmIdx;  /* Loop index */

    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_MCNET_WD_MON_IND);

    for (bSlaveNmIdx = 0;                                /* check all channels */
         bSlaveNmIdx < csm_wMCNetRemoteMasters; /* CSM_C_MCNET_MAX_CONNECTIONS; */
         bSlaveNmIdx++)
    {
      /* Disable interrupts ??? */

      if (CSM_M_IS_MCNET_WD_PRESENT_FLAG_SET(bSlaveNmIdx))  /* "WD present" is signalled */
      {
        CSM_M_CLEAR_MCNET_WD_PRESENT_FLAG(bSlaveNmIdx);

        CSM_MCNET_lConnectSlaveChannels(bSlaveNmIdx); /* Establish connection, if disconnected */

      } /* end if "WD present" for this slave NM instance */

      if (CSM_M_IS_MCNET_WD_PRESENT_FIRST_FLAG_SET(bSlaveNmIdx)) /* "WD present first time" is signalled */
      {
        CSM_M_CLEAR_MCNET_WD_PRESENT_FIRST_FLAG(bSlaveNmIdx);

        CSM_MCNET_lConnectSlaveChannels(bSlaveNmIdx); /* Establish connection, if disconnected */

        /* Trigger Downstream Task because of probable bus state transition */
        csm_vTriggerCsmDownstreamTask( CSM_C_DOWN_REASON_CSM_BUS_STATE_CHANGED);

      } /* end if "WD present for first time" for this slave NM instance */

      if (CSM_M_IS_MCNET_WD_MISSING_FLAG_SET(bSlaveNmIdx))  /* "WD missing" is signalled */
      {
        CSM_M_CLEAR_MCNET_WD_MISSING_FLAG(bSlaveNmIdx);

        CSM_MCNET_lDisconnectSlaveChannels(bSlaveNmIdx); /* Disconnect concerned channels */

        /* Trigger Downstream Task because of probable bus state transition */
        csm_vTriggerCsmDownstreamTask( CSM_C_DOWN_REASON_CSM_BUS_STATE_CHANGED);

      } /* end if "WD missing" for this slave NM instance */

   } /* end for all MCNet slave NM instances */

  } /* end if indication reason MCNet WD monitor indication */
  #endif /* CSM_C_DOWN_REASON_MCNET_WD_MON_IND */

  /*****************************************************************************
   * Connect request for MCNet ASDT TP was called                             */
  #ifdef CSM_C_DOWN_REASON_MCNET_CONNECT_REQ
  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_MCNET_CONNECT_REQ) )
  {
    BYTE bTpChannel;  /* Loop index */

    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_MCNET_CONNECT_REQ);

    for (bTpChannel = 0;                                /* check all channels */
         bTpChannel < CSM_C_MCNET_MAX_CONNECTIONS;
         bTpChannel++)
    {
      /* Disable interrupts ??? */

      if (CSM_M_IS_MCNET_CONNECT_REQUEST_FLAG_SET(bTpChannel))  /* if data request from CSM_lDataReq */
      {
        CSM_M_CLEAR_MCNET_CONNECT_REQUEST_FLAG(bTpChannel);
        #if ( CSM_S_OSEK_NM == CSM_C_F_ON )
        #if ( CNM_OSEK_S_VW_PAYLOAD == CSM_C_F_ON )
        if( csm_rMCNetConnectionAct[ bTpChannel].bReqAction == CSM_C_DISCONNECT)
        {
          CNM_OSEK_lClrPayload( csm_rMCNetConnection[ bTpChannel].bBus, csm_rMCNetConnection[ bTpChannel].dwNmPayload);
        }
        else
        {
          CNM_OSEK_lSetPayload( csm_rMCNetConnection[ bTpChannel].bBus, csm_rMCNetConnection[ bTpChannel].dwNmPayload);
        }
        #endif // CNM_OSEK_S_VW_PAYLOAD == CSM_C_F_ON
        #endif // CSM_S_OSEK_NM == CSM_C_F_ON

        if (CSM_C_NO_ERROR != CNP_MCNET_lConnectReq ( bTpChannel,
                                                      0, /* bBlockSize and */
                                                      0  /* bServiceMode ditto */) )
         {
          /* error occured */ /* U.Z.(6): Fehlerstrategie noch zu berarbeiten! */

          CSM_MCNET_vCNP_ConnectCon( bTpChannel,
                                     0 /*bConStatus*/,
                                     0 /*bBlockSize*/,
                                     0 /*bServiceMode*/ );
        }
      } /* end if Connection request for this channel */
    } /* end for all MCNet connection requests */
  } /* end if indication reason MCNet connection request */
  #endif // CSM_C_DOWN_REASON_MCNET_CONNNECT_REQ

  /*****************************************************************************
   * Data request for MCNet ASDT TP message was called                        */
  #ifdef CSM_C_DOWN_REASON_MCNET_ASDT_DATA_REQ
  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_MCNET_ASDT_DATA_REQ) )
  {
    BYTE bTpChannel;  /* Loop index */

    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_MCNET_ASDT_DATA_REQ);

    for (bTpChannel = 0;                                /* check all channels */
         bTpChannel < CSM_C_MCNET_MAX_CONNECTIONS;
         bTpChannel++)
    {
      /* Disable interrupts ??? */

      /* Expedited data request ?*/
      if (CSM_M_IS_MCNET_ASDT_EDATA_REQUEST_FLAG_SET(bTpChannel))  /* if data request from CSM_lDataReq */
      {
        CSM_M_CLEAR_MCNET_ASDT_EDATA_REQUEST_FLAG(bTpChannel);

        if (CSM_C_NO_ERROR != CNP_MCNET_lASDTDataReq ( CNP_MCNET_C_EDATA_SERV,
                                                       bTpChannel,
                                                       NULL, /* pbData and */
                                                       0     /* wDataLength in Tx struct*/) )
        {
          /* error occured */ /* U.Z.(6): Fehlerstrategie noch zu berarbeiten! */

        /* U.Z.(6): evtl. noch zu tun: ? */  /* csm_rMCNetTpConnectionAct[bIsoTpChannel].fTxChannelFree = TRUE; */

          CSM_MCNET_vCNP_ASDTDataCon ( CNP_MCNET_C_EDATA_SERV, bTpChannel, CSM_C_CONF_FAULT);

        }
      } /* end if Expedited DataReq for this channel */


      /* Long data request ?*/
      if (CSM_M_IS_MCNET_ASDT_LDATA_REQUEST_FLAG_SET(bTpChannel))  /* if data request from CSM_lDataReq */
      {
        CSM_M_CLEAR_MCNET_ASDT_LDATA_REQUEST_FLAG(bTpChannel);

        if (CSM_C_NO_ERROR != CNP_MCNET_lASDTDataReq ( CNP_MCNET_C_LDATA_SERV,
                                                       bTpChannel,
                                                       NULL, /* pbData and */
                                                       0     /* wDataLength in Tx struct*/) )
        {
          /* error occured */ /* U.Z.(6): Fehlerstrategie noch zu berarbeiten! */

        /* U.Z.(6): evtl. noch zu tun: ? */  /* csm_rMCNetTpConnectionAct[bIsoTpChannel].fTxChannelFree = TRUE; */

          CSM_MCNET_vCNP_ASDTDataCon ( CNP_MCNET_C_LDATA_SERV, bTpChannel, CSM_C_CONF_FAULT);

        }
      } /* end if Expedited DataReq for this channel */
    } /* end for all MCNet ASDT TP channels */
  } /* end if indication reason MCNet ASDT DataReq */
  #endif // CSM_C_DOWN_REASON_MCNET_ASDT_DATA_REQ

  /*****************************************************************************
   * Data request for MCNet USDT TP message was called                        */
  #ifdef CSM_C_DOWN_REASON_MCNET_USDT_DATA_REQ
  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_MCNET_USDT_DATA_REQ) )
  {
    BYTE bTpChannel;  /* Loop index */

    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_MCNET_USDT_DATA_REQ);

    for (bTpChannel = 0;                                /* check all channels */
         bTpChannel < CSM_C_MCNET_MAX_USDT_TX_CHANNELS;
         bTpChannel++)
    {
      /* Disable interrupts ??? */

      if (CSM_M_IS_MCNET_USDT_DATA_REQUEST_FLAG_SET(bTpChannel))  /* if data request from CSM_lDataReq */
      {
        CSM_M_CLEAR_MCNET_USDT_DATA_REQUEST_FLAG(bTpChannel);

        if (CSM_C_NO_ERROR != CNP_MCNET_lUSDTDataReq ( bTpChannel,
                                                       NULL, /* pbData and */
                                                       0     /* wDataLength in Tx struct*/) )
        {
          /* error occured */ /* U.Z.(6): Fehlerstrategie noch zu berarbeiten! */

        /* U.Z.(6): evtl. noch zu tun: ? */  /* csm_rMCNetTpConnectionAct[bIsoTpChannel].fTxChannelFree = TRUE; */

          CSM_MCNET_vCNP_USDTDataCon (bTpChannel, CSM_C_CONF_FAULT);
        }
      } /* end if USDT DataReq for this channel */
    } /* end for all MCNet USDT TP channels */

  } /* end if downstream reason MCNet USDT DataReq */
  #endif // CSM_C_DOWN_REASON_MCNET_USDT_DATA_REQ

  #ifdef CSM_C_DOWN_REASON_MCNET_TIMEOUT
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_MCNET_TIMEOUT) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_MCNET_TIMEOUT);
    CNP_MCNET_vProcessTimeout();
  }
  #endif // CSM_C_DOWN_REASON_MCNET_TIMEOUT
  #endif // CSM_S_CNP_AVAILABLE

  //**************************************************************************
  // CNM downstream handling
  //**************************************************************************
  #ifdef CSM_C_DOWN_REASON_CNM_OSEKI_TIMEOUT
  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_CNM_OSEKI_TIMEOUT) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_CNM_OSEKI_TIMEOUT);
    CNM_OSEKI_vProcessTimeout();
  }
  #endif // CSM_C_DOWN_REASON_CNM_OSEKI_TIMEOUT

  #ifdef CSM_C_DOWN_REASON_CNM_OSEKI_COMMUNICATION_REQ
  if ( CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_CNM_OSEKI_COMMUNICATION_REQ) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_CNM_OSEKI_COMMUNICATION_REQ);
    CNM_OSEKI_vProcessCommunicationReq();
  }
  #endif // CSM_C_DOWN_REASON_CNM_OSEKI_COMMUNICATION_REQ

  #ifdef CSM_C_DOWN_REASON_OSEK_TIMEOUT
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_OSEK_TIMEOUT) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_OSEK_TIMEOUT);
    CNM_OSEK_vProcessTimeout();
  }
  #endif // CSM_C_DOWN_REASON_OSEK_TIMEOUT

  #ifdef CSM_C_DOWN_REASON_VWHIGH_TIMEOUT
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_VWHIGH_TIMEOUT) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_VWHIGH_TIMEOUT);
    CNM_VWHIGH_vProcessTimeout();
  }
  #endif // CSM_C_DOWN_REASON_VWHIGH_TIMEOUT

  #ifdef CSM_C_DOWN_REASON_FIAT_SLAVE_TIMEOUT
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_FIAT_SLAVE_TIMEOUT) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_FIAT_SLAVE_TIMEOUT);
    CNM_vFiatSlave_vProcessTimeout();
  }
  #endif // CSM_C_DOWN_REASON_FIAT_SLAVE_TIMEOUT

  #ifdef CSM_C_DOWN_REASON_GMLAN_TIMEOUT
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_GMLAN_TIMEOUT) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_GMLAN_TIMEOUT);
    CNM_GMLAN_vProcessTimeout();
  }
  #endif // CSM_C_DOWN_REASON_GMLAN_TIMEOUT

  #ifdef CSM_C_DOWN_REASON_NM_PROCESSING_TASK
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_NM_PROCESSING_TASK) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_NM_PROCESSING_TASK);
    CSM_Stack_vNM_CyclicTask();
  }
  #endif // CSM_C_DOWN_REASON_VOLCANO_CYCLIC_TASK

  #ifdef CSM_C_DOWN_REASON_MCNET_NM_TIMEOUT
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_MCNET_NM_TIMEOUT) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_MCNET_NM_TIMEOUT);
    CNM_MCNET_vProcessTimeout();
  }
  #endif // CSM_C_DOWN_REASON_MCNET_TIMEOUT

  #ifdef CSM_C_DOWN_REASON_IVLAN_TIMEOUT
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_IVLAN_TIMEOUT) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_IVLAN_TIMEOUT);
    CNM_IVLAN_vProcessTimeout();
  }
  #endif // CSM_C_DOWN_REASON_OSEK_TIMEOUT

  #ifdef CSM_C_DOWN_REASON_J1939_TIMEOUT
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_J1939_TIMEOUT) )
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_J1939_TIMEOUT);
    CNM_J1939_vProcessTimeout();
  }
  #endif // CSM_C_DOWN_REASON_OSEK_TIMEOUT

  //***************************************************************************
  // CSM_BAP downstream handling
  //***************************************************************************
  #if (CSM_S_VW_BAP_TP == CSM_C_F_ON)
  #ifdef CSM_C_DOWN_REASON_CSM_BAP_PROCESS_TASK
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CSM_BAP_PROCESS_TASK) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CSM_BAP_PROCESS_TASK);
    CSM_BAP_vProcessTask();
  }
  #endif // CSM_C_DOWN_REASON_CBR_COMMUNICATION_REQ

  #ifdef CSM_C_DOWN_REASON_CSM_BAP_PROCESS_IPC_TASK
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CSM_BAP_PROCESS_IPC_TASK) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CSM_BAP_PROCESS_IPC_TASK);
    CSM_BAP_vProcessBAPIpcTask();
  }
  #endif // CSM_C_DOWN_REASON_CSM_BAP_PROCESS_IPC_TASK

  #ifdef CSM_C_DOWN_REASON_BAP_OWN_PROCESSING
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_BAP_OWN_PROCESSING) )
  {
    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_BAP_OWN_PROCESSING);
    CSM_BAP_vProcessBAPProcessing();
  }
  #endif // CSM_C_DOWN_REASON_BAP_OWN_PROCESSING
  #endif // CSM_S_VW_BAP_TP == CSM_C_F_ON

  #ifdef CSM_C_DOWN_REASON_CSM_POST_INIT_START
  if ( CSM_M_IS_DOWN_REASON_SET( CSM_C_DOWN_REASON_CSM_POST_INIT_START) )
  {
    BYTE bBusIndex;

    CSM_M_CLEAR_DOWN_REASON( CSM_C_DOWN_REASON_CSM_POST_INIT_START);

    for (bBusIndex = 0; bBusIndex < CSM_C_MAX_CAN_BUS; bBusIndex++)
    {
      CSM_vPostInitStart( bBusIndex);
    } /* end for all CAN */
  }
  #endif // CSM_C_DOWN_REASON_CSM_POST_INIT_START

  //**************************************************************************
  #ifdef CSM_C_DOWN_REASON_TRACE
  if (CSM_M_IS_DOWN_REASON_SET(CSM_C_DOWN_REASON_TRACE))
  {
    CSM_M_CLEAR_DOWN_REASON(CSM_C_DOWN_REASON_TRACE);

    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
          #error "Within this nice constellation of making tracing confusing, please check your feature switches to find out what to trace here"
        #endif
      #else // CSM_S_TRACE_ETG
      if (csm_fDownstreamTraceOutOverrun)
      {
        // checked buffer size against CSM_MAX_TRACE_LENGTH !! BKA2HI: 11/2016
        BYTE abData[3];

        abData[0] = CSM_C_ERR_LOC_CSM_TRACE;                // error location
        abData[1] = CSM_M_GET_HIBYTE(CSM_E_BUFFER_OVERRUN); /*lint !e572 !e778 PQM_authorized_multi_127*/ /* error code */
        abData[2] = CSM_M_GET_LOBYTE(CSM_E_BUFFER_OVERRUN); /*lint !e572 !e778 PQM_authorized_multi_127*/ /* error code */

        CSM_M_TRACEOUT(CSM_C_TRACEOUT_LEVEL_INTERFACE, CSM_C_TRACEOUT_INTERFACE_CSM, CSM_C_TRACE_FKT_DOWNSTREAM_TRACE, abData, sizeof(abData));
        csm_fDownstreamTraceOutOverrun = FALSE;
      }

      // checked buffer size against CSM_MAX_TRACE_LENGTH !! BKA2HI: 11/2016
      // this construct traces 4 bytes, if used via the ExceptionHandler, what seems to be the only use case for now.
      CSM_M_TRACEOUT(csm_wDownstreamTraceOutLevel, csm_wDownstreamTraceOutInterface, csm_wDownstreamTraceOutFunktion, csm_abDownstreamTraceOutData, csm_wDownstreamTraceOutDataLength);
      #endif // CSM_S_TRACE_ETG
    #endif // CSM_S_TRACE
  }
  #endif // CSM_C_DOWN_REASON_TRACE

  // special call of an OS specific function
  // currently empty for AUTOSAR (11/2016)
  csm_vOSspecificDownstream();
}

#endif // CSM_S_DOXYGEN_HIDE_NON_API_FCT

//******************************************************************************
//* function implementation (scope: CAN stack #1 API)
//******************************************************************************
// none

#undef CSM_STACK_SELF
#undef CSM_CAN_STACK

/*******************************************************************************
 * \doxydocu
 * \file          csm_stack.c
 * \brief         CAN stack module. Not project or environment specific routines.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/csm_stack/src/
 *
 * \ingroup       CSM
 * \ingroup       CSM_STACK
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2004 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 27.02.04  Rev. \main\3  CM-DI/ESU3-K"ohler
 * - Up- and downstream reason bus state change added.
 *
 * 25.05.04  Rev. \main\4  CM-DI/ESU3-Prhl
 * - integration from SW_NAVI PVCS
 *
 * 23.06.04  Rev. \main\5  CM-DI/ESU3-Prhl
 * - add csm_vTriggerCsmDownstreamTaskFromIrq() CDA function added in down stream task
 *
 * 28.06.04  Rev. \main\6  CM-DI/ESU3-Prhl
 * - warnings removed
 *
 * 27.07.04  \main\7  CM-DI/ESU3-Battis
 * - several CSM_S_CNP_AVAILABLE inserted
 *
 * 02.09.04  \main\8  CM-DI/ESU3-Battis
 * - changes for Fiat SB05
 *
 * 03.09.04  \main\9  CM-DI/ESA3-Prhl
 * - old CBR code removed
 * - call CBR_vProcessCommunicationInd() and CBR_vProcessCommunicationCon() to upstream task added
 * - call CBR_vProcessCommunicationReg() and CSM_vProcessBusStateChange() to downstream task added
 *
 * 15.09.04  \main\10  CM-DI/ESA3-Battis
 * - interrupt control function calls renamed
 *
 * 29.09.04  \main\11 CM-DI/ESA3-Battis
 * - new down reasons implemented:
 *   CSM_C_DOWN_REASON_CDA_BUSOFF_ENTRY
 *   CSM_C_DOWN_REASON_CDA_BUSOFF_RECOVERY
 *   CSM_C_DOWN_REASON_CSM_POST_INIT_START
 *   CSM_C_DOWN_REASON_CSM_IND_RADIOISON
 *   CSM_C_DOWN_REASON_CSM_IND_RADIOISOFF
 *
 * 19.10.04  \main\12  CM-DI/ESA3-Prhl
 * - call CNM_OSEK_vProcessTimeout() to downstream task added
 *
 * 22.10.04  \main\13  CM-DI/ESA3-Prhl
 * - remove old code
 *
 * 01.11.04  \main\14  CM-DI/ESA3-Battis
 * - down reason switch CSM_C_DOWN_REASON_OSEK_TIMEOUT added
 *
 * 02.12.04  \main\15  CM-DI/ESA3-Battis
 * - "blockable upstream task" feature added
 *
 * 18.01.05  \main\16  CM-DI/ESA3-K"ohler
 * - CDA_lSend() with Tx-struct used instead of CDA_lSendRaw to transmit Opel
 *   broadcast telegrams.
 * - Some doxygen comments added.
 *
 * 25.01.05  \main\17  CM-DI/ESA3-K"ohler
 * - New naming conventions and no bus parameter for ISO-TP functions.
 *
 * 08.02.05  \main\18  CM-DI/ESA3-Battis
 * - comments modified
 *
 * 09.02.05  \main\18  CM-DI/ESA3-Prhl
 * - missing #if ... #endif added
 *
 * 16.02.05  \main\21  CM-DI/ESA3-Prhl
 * - handling for local stack ctrl added
 * - traces added
 *
 * 22.02.05  \main\22  CM-DI/ESA3-Battis
 * - application callback feature inserted for CSM_S_INDICATE_BUSOFF_TO_APPLICATION
 *
 * 23.02.05  \main\22  CM-DI/ESA3-Prhl
 * - ISO TP integration
 *
 * 08.04.05  \main\24  CM-DI/ESA3-K"ohler
 * - Callback function types renamed from vPFNTp to pfv.
 *
 * 19.04.05  \main\25  CM-DI/ESA3-Battis
 * - call of CDA Send Restriction now routed through csm_apl
 *
 * 25.04.05  \main\26  CM-DI/ESA3-K"ohler
 * - C++ comment removed, Iso-TP include order changed.
 *
 * 04.05.05  \main\27  CM-CR/ESD4-Tuschik
 * - Add VW-functionality to upstream task.
 *
 * 08.06.05  \main\29  CM-DI/ESA3-Battis
 * - IND reason CSM_C_IND_REASON_EEMS_IND implemented for Fiat SB05
 * - DOWN reasons CSM_C_DOWN_REASON_CSM_IND_EEMS_CHK_ON
 *   and CSM_C_DOWN_REASON_CSM_IND_EEMS_CHK_OFF implemented for Fiat SB05
 *
 * 09.06.05  \main\30  CM-DI/ESA3-Battis
 * - MISRA happyness
 *
 * 09.08.05  \main\31  CM-DI/ESA3-Zurmuehl
 * - Processing of CSM_C_DOWN_REASON_MCNET_WD_MON_IND in downstream task revised
 * - Structure CNP_MCNET_MSG: lDataLength -> wDataLength
 *
 * 15.08.05  \main\33  CM-DI/ESA3-Zurmuehl
 * - Structure CNP_MCNET_MSG: lDataLength -> wDataLength
 *
 * 19.09.05  \main\34 CM-DI/ESA3-Prhl
 * - CSM_vTraceOut() replaced by CSM_M_TRACEOUT()
 *
 * 19.09.05  \main\35 CM-DI/ESA3-Prhl
 * - change defines for trace
 *
 * 26.09.05  \main\36 CM-DI/ESA3-Battis
 * - csm_dwNmEvent moved to csm_vw.c
 *
 * 28.09.05  \main\38 CM-DI/ESA3-Battis
 * - CSM_C_IND_REASON_CBR_NACHLAUF_CONF renamed to CSM_C_IND_REASON_CBR_NACHLAUF_CON
 * - CBR_vProcessCommunicationReg() renamed to CBR_vProcessCommunicationReq()
 *
 * 21.10.05 \main\39 CM-CR/ESD3 Thomas Mehring
 * - Replaced MCNet connect(IND/CON) with communication(IND/CON).
 *
 * 04.11.05  \main\40 CM-DI/ESA3-Battis
 * - CSM_C_IND_REASON_MCNET_CONNECT_CON renamed to CSM_C_IND_REASON_MCNET_COMM_CON
 * - CSM_C_IND_REASON_MCNET_CONNECT_IND renamed to CSM_C_IND_REASON_MCNET_COMM_IND
 * - some alignments
 *
 * 07.11.05 \main\41 CM-DI/ESA3-Zurmuehl
 * - Feature switch CSM_S_MCNET instead of CSM_C_IND_REASON_MCNET_COMM_CON
 *
 * 15.11.05 \main\42 CM-DI/ESA3-Prhl
 * - function names changed
 *
 * 17.11.05 \main\43 CM-DI/ESA3-Battis
 * - CSM_C_APPL_DEFAULT renamed to CSM_C_APPL_ID_DEFAULT
 * - handling of csm_vPostInitStart() merged with CSM_vStackActivated()
 *
 * 22.11.05 \main\44 CM-DI/ESA3-Battis
 * - multi channel busoff handling integrated.
 *   CSM_C_DOWN_REASON_CDA_BUSOFF_ENTRY_CAN0 renamed to
 *      CSM_C_DOWN_REASON_CDA_BUSOFF_ENTRY
 *   CSM_C_DOWN_REASON_CDA_BUSOFF_RECOVERY_CAN0 renamed to
 *      CSM_C_DOWN_REASON_CDA_BUSOFF_RECOVERY
 *
 * 24.11.05 \main\45 CM-DI/ESA3-Battis
 * - Fiat NM specific function call encapsulated ith CSM_S_FIATSLAVE_NM
 *
 * 03.04.06 \main\46 CM-DI/ESA3-Battis
 * - BAP integrated
 *
 * 04.04.06 \main\47 CM-DI/ESA3-Battis
 * - csm_bap_i.h include removed
 *
 * 21.04.06 \main\48 CM-DI/ESA3-Battis
 * - BAP header includes adjusted.
 *
 * 28.04.06 \main\49 CM-DI/ESA3-Battis
 * - CSM_S_FIATSLAVE_NWM_SB05 removed
 * - feature switch handling corrected.
 *
 * 10.05.06 \main\50 CM-DI/ESA3-Battis
 * - csm_bap_i.h include moved to csm_i.h
 *
 * 11.05.06 \main\51 CM-DI/ESA3-Battis
 * - uwLength member of rBAPInOut changed to ulwLength
 *
 * 12.05.06 \main\52 CM-DI/ESA3-Zurmhl
 * - duplicate statement "#ifndef CSM_S_VWTP20_IND_ON_ML_LEVEL" removed
 *
 * 29.05.06 \main\53 CM-DI/ESA3-Prhl
 * - #include csm_cbr_c.h added to remove warning
 * - add some doxygen
 *
 * 29.05.06 \main\54 CM-DI/ESA3-Prhl
 * - remove warning
 *
 * 07.06.06 \main\55 CM-DI/ESA3-Prhl
 * - CSM_C_DOWN_REASON_CSM_BUS_STATE_CHANGED now work with more than one bus
 *
 * 07.06.06 \main\56 CM-DI/ESA3-Prhl
 * - add CSM_C_DOWN_REASON_GMLAN_TIMEOUT
 *
 * 09.06.06 \main\57 CM-DI/ESA3-Battis
 * - BAP code of Upstream Task moved to ...process functions to csm_bap.c
 *
 * 29.06.06 \main\58 CM-DI/ESA3-Haffner
 * - changes for new proxy
 *
 * 29.06.06 \main\59 CM-DI/ESA3-Battis
 * - CBR_vProcessNachlaufCon() was renamed to CSM_CBR_vProcessNachlaufCon()
 *
 * 14.07.06 \main\60 CM-DI/ESA3-Prhl
 * - add feature CSM_S_USE_CALLBACK_WITH_HANDLE.
 *   Add the pvHandle from CSM_lApplCallbackInit() to callback routines.
 *   This is used to handle the process border jump (e.g. TENGINE subsystem)
 *
 * 19.07.06 \main\61 CM-DI/ESA3-Prhl
 * - modify feature CSM_S_USE_CALLBACK_WITH_HANDLE.
 *   add PVOID pvHandle to tCSM_ISO_TP_USDT_APPL_CALLBACK if feature CSM_S_USE_CALLBACK_WITH_HANDLE is active
 *
 * 20.07.06 \main\62 CM-DI/ESA3-Prhl
 * - add #if CSM_S_CDA_AVAILABLE around the cda_i.h include
 *
 * 25.07.06 \main\63 CM-DI/ESA3-K"ohler
 * - Warning in MCNet trace removed (BYTE cast).
 * - check of feature switch CSM_S_ITP_COMMUNICATION_FCT added.
 *
 * 18.08.06 \main\64 CM-DI/ESA3-K"ohler
 * - CSM_TRACE_C_FKT renamed CSM_C_TRACE_FKT.
 *
 * 22.08.06  \main\65  CM-DI/ESA3-Khler
 * - CSM_S_VWTP20_IND_ON_ML_LEVEL featured with CSM_S_VW_TP_2_0.
 *
 * 27.09.06  \main\66  CM-DI/ESA3-Khler
 * - Include "csm_c.h" featured for MCNet and ISO-TP.
 *
 * 27.09.06  \main\67  CM-DI/ESA3-Khler
 * - Lint warnings removed.
 *
 * 06.10.06  \main\68  CM-DI/ESA3-Khler
 * - csm_vTriggerCsmUpstreamTaskFromIrq() encapulated with feature switch added.
 *
 * 24.10.06  \main\69  CM-DI/ESA3-Haffner
 * - moved feature switch CSM_S_VW_BAP_TP outside of CNP.
 * - added TP reasons for remote stack.
 *
 * 26.10.06  \main\70 CM-DI/ESA3-Prhl
 * - code review
 *
 * 02.11.06  \main\71 CM-DI/ESA3-Prhl
 * - code in CSM_C_IND_REASON_ITP_DATA_CON and CSM_C_IND_REASON_ITP_DATA_IND moved
 *   into functions CNP_ITP_vProcessDataCon() and CNP_ITP_vProcessDataInd()
 *
 * 10.11.06 \main\72 CM-DI/ESA3-Prhl
 * - typing error corrected
 *
 * 08.12.06 \main\73 CM-DI/ESA3-Battis
 * - call of OsSpecific Upstrea task moveed to the top of upstream task.
 *
 * 23.01.07 \main\74 CM-DI/ESA3-Prhl
 * - add call in up- and downstream task for UUDT. CNP_UUDT_vProcessDataReq(),CSM_UUDT_vProcessDataCon() and CSM_UUDT_vProcessDataInd()
 *
 * 14.02.07 \main\75 VTeam-Prhl
 * - add call downstream task for UUDT. CNP_UUDT_vProcessDataIndProcessed()
 *
 * 23.02.07 \main\76 VTeam-Prhl
 * - add call upstream task for GMLAN. CSM_GMLAN_vProcessCommunicationInd()
 *
 * 16.03.07 \main\77 VTeam-Prhl
 * - missing include "cnp_uudt_i.h" added
 *
 * 22.03.07 \main\78 VTeam-Prhl
 * - old OPEL feature switch removed
 *
 * 28.03.07 \main\79 VTeam-Prhl
 * - add call downstream task for BAB. CSM_BAP_vProcessTask()
 *
 * 15.05.07 \main\80 VTeam-Prhl
 * - MCNet trace output chnged and "RAM callbacks" added
 *
 * 15.05.07 \main\81 VTeam-Prhl
 * - spaces after # deleted
 *
 * 25.06.07 \main\82 VTeam-Prhl
 * - now we have 32-bit up/down-resons
 *
 * 26.06.07 \main\83 VTeam-Prhl
 * - CSM_vEnableSendRestriction() commented out
 * - error indication handling added.
 *
 * 28.06.07 \main\84 VTeam-Prhl
 * - CSM_vIndicateBusError() call added for CSM_C_BUS_OFF. The error state is active
 *   from CDA_BUSOFF_ENTRY to CDA_BUSOFF_RECOVERY.
 * - CSM_vEnableSendRestriction() replaced by CSM_vEnableBusoffSendRestriction()
 *
 * 05.07.07 \main\85 VTeam-Battis
 * - call of CSM_vIndicateBusError removed from BUSOFF_RECOVERY for VW
 *
 * 06.07.07 \main\86 VTeam-Battis
 * - CSM_S_BUSOFF_SENDRESTRICTION renamed to CSM_S_CDA_BUSOFF_SENDRESTRICTION
 *
 * 11.07.07 \main\87 VTeam-Battis
 * - compiler switch used for IND reason CSM_C_IND_REASON_BUS_ERROR
 *
 * 13.07.07 \main\88 VTeam-Prhl
 * - feature CSM_S_CDA_END_BUS_OFF_WITH_DATA_IND added in CSM_C_DOWN_REASON_CDA_BUSOFF_RECOVERY
 *
 * 24.07.07 \main\89 VTeam-Prhl
 * - OSEK payload for MCNet added.
 *
 * 31.07.07 \main\90 VTeam-Prhl
 * - lint warnings removed or commented out.
 *
 * 25.09.07 \main\91 VTeam-Prhl
 * - merge from \dev_phm2hi_di_can_pag_icm_low_working\3.
 *
 * 05.10.07 \main\92 VTeam-Prhl
 * - ISO-TP timeout processing moved to downstream level.
 * - unused ISO-TP code removed
 * - ISO-TP code for data request moved to cnp_itp.c
 *
 * 05.10.07 \main\93 VTeam-Prhl
 * - MCNET timeout processing moved to downstream level.
 *
 * 05.10.07 \main\94 VTeam-Prhl
 * - make ready to compile with CSM_S_USE_CALLBACK_WITH_HANDLE = CSM_C_F_OFF.
 *
 * 15.11.07 \main\95 VTeam-Khler
 * - Doxygen ingroup CSM_IF replaced by CSM_STACK.
 *
 * 17.12.07 \main\96 VTeam-Funke
 * - Removed volcano specific parts.
 *
 * 17.12.07 \main\97 VTeam-Funke
 * - added description
 *
 * 14.02.08 \main\98 VTeam-Prhl
 * - lint authorisation added.
 *
 * 20.02.08 \main\99 VTeam-Prhl
 * - lint authorisation added.
 *
 * 22.02.08 \main\100 VTeam-Prhl
 * - make doxygen happy.
 *
 * 27.02.08 \main\101 VTeam-Lansley / Funke
 * - added CSM_C_UP_REASON_CSM_OSEK_NM_STATE_CHANGED
 *
 * 18.03.08 \main\102 VTeam-Prhl
 * - MMS 184052: Die Pausenzeiten zwischen den Bus-Offs werden nicht eingehalten.
 *     CDA_vProcessSend() and CDA_vProcessDataInd() moved behind Bus-off handling to prevent sending after Bus-off.
 *
 * 18.04.08 \main\103 VTeam-Prhl
 * - merge from \main\bugfix_bai2hi_csm_proxy_v01.17\1
 *   down reason CSM_C_DOWN_REASON_BAP_OWN_PROCESSING added.
 *
 * 10.05.08 \main\104 VTeam-Prhl
 * - CSM_C_DOWN_REASON_CNP_MPDT_... and CSM_C_IND_REASON_CNP_MPDT_... added.
 *
 * 02.07.08 \main\105  VTeam-Zurmhl
 * - function reviewed (no changes in code, just comments and formatting changed)
 *
 * 22.09.08 \main\106 Prhl
 * - some MPDT code changed.
 *
 * 24.09.08 \main\107 Prhl
 * - CSM_C_DOWN_REASON_CNP_MPDT_PACKET_DATA_REQ added to call CNP_MPDT_vProcessPacketDataReq().
 *
 * 29.09.08 \main\108 Prhl
 * - Function CNP_MPDT_lBusoffEntry() added down reason CSM_C_DOWN_REASON_CDA_BUSOFF_ENTRY. Nissan has now network management to handle bus off.
 *
 * 17.11.08 \main\109 Prhl
 * - Function CDA_vProcessDataCon() added to CSM_vDownstreamTask() at down reason CSM_C_DOWN_REASON_CDA_CON.
 *
 * 18.11.08 \main\110 Prhl
 * - Function CNP_MPDT_vProcessSendTelegram() added to CSM_vDownstreamTask() at down reason CSM_C_DOWN_REASON_CNP_MPDT_SEND_TELEGRAM.
 *
 * 21.11.08 \main\111 CM-DI/PJ-FO45-Pistoor
 * - Added CSM_C_IND_REASON_ITP_DATA_IND_FF and CSM_C_IND_REASON_ITP_ERROR_IND to CSM_vUpstreamTask()
 *
 * 21.11.08 \main\112  VTeam-Zurmhl
 * - functions reviewed (no changes in code, just comments and formatting changed)
 *
 * 29.06.09 \main\113  Prhl
 * - Function CNM_MCNET_vProcessTimeout() added to CSM_vDownstreamTask() at down reason CSM_C_DOWN_REASON_MCNET_NM_TIMEOUT.
 *
 * 17.07.09 \main\114  Prhl
 * - local control functions are moved to modul csm_lctr.c
 *   You have to use some more updated files!
 *     csm.c        \main\248 or newer
 *     csm_m.h      \main\41 or newer
 *     csm_stack.c  \main\114  or newer
 *   You have to update the content of your project file csm_stack_mp.h
 *     CSM_MAX_LOCAL_CTRL_USER renamed to CSM_LCTR_C_MAX_USER
 *     csm_arCsmCfg[] is now part of "#ifdef CSM_LCTR_SELF" and not part of "#ifdef CSM_SELF"
 *
 * 07.09.09 \main\115  VTeam-Franke
 * - CSM_vUpstreamTask: added CSM_C_IND_REASON_LIN_DIAG_DATA_IND
 *
 * 29.09.09 \main\116  VTeam-Jablonski
 * - CSM_vDownstreamTask: added CSM_C_DOWN_REASON_CNP_LCTR_DATA_REQ
 *
 * 20.10.09 \main\117  VTeam-Franke
 * - added include for LIN diag DataInd prototype
 *
 * 20.10.09 \main\118  Prhl
 * - missing include added.
 *
 * 11.11.2009 \main\119 Riecker
 * Add timeout function call for Fiat to downstream task
 *
 * 16.11.09  \main\120  VTeam-Khler
 * - CSM_vMemCopyDWordInMotorolaOrder() added.
 *
 * 09.12.09  \main\121  VTeam-Franke
 * - new: CSM_vDownstreamTraceOut
 *   (downstream reason CSM_C_DOWN_REASON_TRACE)
 *
 * 11.12.09  \main\122  Prhl
 * - CSM_C_DOWN_REASON_CNM_TIMEOUT renamed to CSM_C_DOWN_REASON_FIAT_SLAVE_TIMEOUT
 *
 * 15.12.09  \main\123  Prhl
 * - review done
 *
 * 20.01.10  \main\124  VTeam-Franke
 * - lint warnings removed
 *
 * 22.01.10  \main\125  Prhl
 * - old IVLAN stuff removed
 *
 * 25.01.10  \main\126  Prhl
 * - CSM_vDownstreamTask: added CSM_C_DOWN_REASON_IVLAN_TIMEOUT (CNM_IVLAN_vProcessTimeout())
 *
 * 26.01.10  \main\127  VTeam-Franke
 * - new: CSM_C_IND_REASON_UUDT_ERROR_IND
 *
 * 28.04.10  \main\128  Borck
 * CNM_OSEKI_vProcessTimeout() callback introduced.
 *  This is needed for Nissan LCN2, where an indirect NM has to be introduced.
 *
 * 17.05.10  \main\129  Borck
 * - OSEKI header file included, if feature is ON -> solves warning output
 *
 * 08.09.10  \main\130  VTeam-Pistoor
 * - Added CSM_C_DOWN_REASON_CDA_LLD_LIN_TX_CON to Downstream task
 *
 * 17.09.10  \main\131  VTeam-Pistoor
 * - Added CSM_C_IND_REASON_LIN_USDT_DATA_IND
 *
 * 22.10.10  \main\132  VTeam-Pistoor
 * - Added CSM_C_DOWN_REASON_CSM_POST_INIT_START
 *
 * 26.10.10  \main\133  Borck
 * - added CSM_C_IND_REASON_CSM_OSEKI_NM_STATE_CHANGED for downstream task
 *
 * 28.10.10  \main\134  Pistoor
 * - Made changes because of compiler warnings
 *
 * 08.11.10  \main\135  Borck
 * - Function renamed for OSEKI NM (ProcessCommunicationIndication)
 *
 * 23.02.11  \main\136  Borck
 * - File csm_cbr_c.h now included unconditionally to suppress missing prototype warnings
 *
 * 16.03.11  \main\137  Pistoor
 * - Added CSM_C_IND_REASON_DTC_ERROR_IND
 *
 * 17.03.11  \main\138  Pistoor
 * - Added include of csm_apl.h for CSM_C_IND_REASON_DTC_ERROR_IND ( CSM_vDTCEventCallback() )
 *
 * 28.03.11  \main\139  Pistoor
 * - Modified CSM_lExceptionHandler(), error only in case of != CSM_E_INIT_WARNING
 *
 * 31.03.11  \main\140  Pistoor
 * - Added ETG handling in CSM_lExceptionHandler()
 *
 * 20.04.11  \main\141  Pistoor
 * - Values for ETG handling in CSM_lExceptionHandler() are now defined as enums
 *   in csm_etg_trace_p.h
 *
 * 12.05.11  \main\143  Prhl
 * - some missing #ifdef added
 *
 * 19.05.11  \main\144  Prhl
 * - missing #ifdef CSM_S_TRACE_ETG added
 *
 * 31.05.11  \main\145  Feldhaus
 * - missing includes of J1939 headers added
 *
 * 06.06.11  \main\146  Borck
 * - Added another reason for downstream task, dedicated for OSEKI (CommunicationReq)
 *   This has been introduced as a simple, straightforward command-interface to
 *   OSEKI NM for applications
 *
 * 09.06.11  \main\147  Borck
 * - default ETG trace class set to TR_CLASS_FD_CSM (standard CSM class) on recommendation
 *   by M.Hessling. A dedicated ETG trace class is not needed and only covers the risk
 *   of accidently enabling the wrong trace class in case of field testing by an unadvised person.
 * - probably an update of your csm_etg_trace_p.h file is required for proper ETG tracing.
 *
 * 29.09.11 \main\148 CM/PJ-H- Basavaraj patil
 * - Used compiler switch CSM_S_ITP_FF_INDICATION_AVAILABLE before calling CNP_ITP_vProcessDataIndFF()
 * - Compiler switch CSM_S_CNP_LOCAL_CTRL used instead of CSM_S_CSM_LOCAL_CTRL at relevant places
 *
 * 06.12.12 \main\149 CM-AI/PJ-CD43-Pistoor
 * - Removed LINT warnings
 *
 * 06.02.13 \main\150 CM-AI/PJ-CD43-Pistoor
 * - Made changes in CSM_lExceptionHandler() to fit also to RTA OSEK environment
 *
 * 10.05.13 \main\154 Prhl
 * - include for VW NM HIGH added
 *
 * 20.07.13 \main\155 Prhl
 * - code for proccessing CSM_C_DOWN_REASON_CSM_BAP_PROCESS_IPC_TASK added.
 *
 * 12.09.13 \main\156 Feldhaus
 * - added CSM_PROXY_vProcessRemoteNetTxManager in downstream
 *
 * 21.02.14 \main\157 Prhl
 * - added CNM_VWHIGH_vProcessTimeout to downstream task.
 *
 * 23.06.14 \main\158 Feldhaus
 * - added missing include for header cnm_J1939_i.h
 *
 * 26.02.15 \main\159 Borck
 * - no functional changes !!
 *  -- feature switch indention changed for better readability while CSM G3G adaptation for AIVI
 *  -- some warnings removed if using feature switches, which are not defined in a certain configuration
 *
 * 06.03.15  \main\160 Prhl
 * - trace without ETG for Autosar environment.
 *
 * 18.06.16  \main\161 Borck
 * - Proxy TP Data handling (RX from INC) moved from Upstream to downstream task to have a common handling for all INC channels
 * - reasons have been renamed and NET, BR and TP indications are now handled in downstream task
 * - IPC timeout (TX to v850): reason and callback function renamed
 *
 * 06.07.16  \main\162 Borck
 * - due to confusing and ambiguous names for functions and down-reasons, another renaming has been applied in the Proxy context.
 * - Proxy: BR, NET and TP downstream handler functions (TX to INC) renamed !!! (adaptions in proxy variants required)
 * - downstream reasons renamed for TX requests as well (adaptions in proxy and project specific csm_stack_xxx_p.c required)
 * - naming rule: process data from IPC -> IPC_REMOTE / process data to IPC -> IPC_LOCAL
 * - Proxy Example taking usage of this renamings: RN_AIVI
 *
 * 09.11.16  \main\163 Borck
 * - trace buffer sizes have been checked against CSM_MAX_TRACE_LENGTH due to reduction of the same in csm_stack_m.h
 *
 * 14.11.16  \main\164 Borck
 * - riddle ourselfs with cleaned up trace code ;-)
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
