/************************************************************************
 *FILE:           CSM_PROXY_MP.H
 *SW-COMPONENT:   CAN Proxy Server module header
 *DESCRIPTION:    CAN header file for module
 *                external/internal used data/definitions
 *AUTHOR:         CM-DI/ESA3-Haffner
 *COPYRIGHT:      (c) 2015 Bosch Car Muiltmedia
 *
 ************************************************************************/

#ifndef CSM_PROXY_MP_HEADER
#define CSM_PROXY_MP_HEADER

/*****************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------*/
// none

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/
#define CSM_C_BUFFER_SIZE_REMOTE_RX                 (12+3)  // max. 3 bytes data payload
#define CSM_C_BUFFER_SIZE_REMOTE_TX                 (12+3)  // max. 3 bytes data payload
#define CSM_C_BUFFER_SIZE_BR_RX                     (9+(3*17)+1)
#define CSM_C_BUFFER_SIZE_BR_TX                     (13+8+1)

#define CSM_C_BUFFER_SIZE_TP_RX                     (4106)
#define CSM_C_BUFFER_SIZE_TP_TX_C                   (4106)
#define CSM_C_BUFFER_SIZE_TP_TX_D                   (4106)

#define CSM_C_REMOTE_NET_CTRL_IPCA_HEADER_LENGTH    1 //2 // 4
#define CSM_C_BR_SIGNAL_CTRL_IPCA_HEADER_LENGTH     1 //3 // 5
#define CSM_C_TP_CTRL_IPCA_HEADER_LENGTH            1

#define CSM_C_REMOTE_NET_CTRL_COMP_STATUS_ACTIVE    0x01
#define CSM_C_REMOTE_NET_CTRL_COMP_STATUS_INACTIVE  0x02

#define CSM_C_POWER_STATUS_INACTIVE                 0x00
#define CSM_C_POWER_STATUS_ACTIVE                   0x01

// NET
#define CSM_NET_PROTOCOL_CLIENT_NONE                0x00   // the management struct is currently free for usage
#define CSM_NET_PROTOCOL_CLIENT_LCTRL               0x01   // the management struct is used by LCTRL
#define CSM_NET_PROTOCOL_CLIENT_OSEKI               0x02   // the management struct is used by OSEKI

// Timeouts
#define CSM_C_TIMEOUT_NET_LCTRL                    2000U   // timeout IPC response for NET LCTRL
#define CSM_C_TIMEOUT_NET_OSEKI                    2000U   // timeout IPC response for NET OSEKI
#define CSM_C_TIMEOUT_BRSIGNAL                     2000U   // timeout IPC response for BR
#define CSM_C_TIMEOUT_TP                           2000U   // timeout IPC response for TP

/*****************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------*/
// for all channels (REMOTE, BR, TP)
typedef struct
{
  BYTE  u8Bus;                               // Bus Nr.
  BYTE  u8Context;                           // IPCA Context
  BYTE  u8Subcontext;                        // IPCA Subcontext
  BYTE  au8NetCompAddr[2];                   // IPCA Adressfeld
  DWORD dwProtocolType;                      // CSM Protokoll Type
  BYTE  au8AddressField[2];                  // CSM Adressfeld
} tCSM_IPC_CFG;

// NET channel
typedef struct
{
  tIpcHdl tyIpcHandle;
  BOOL    fRxBufferUsed;
  BYTE    au8BufferRx[CSM_C_BUFFER_SIZE_REMOTE_RX];
  BYTE    au8BufferTx[CSM_C_BUFFER_SIZE_REMOTE_TX];
  WORD    wDataLength;
  BYTE    u8CompStatusReq;
  BYTE    u8CompStatusAct;
  WORD    au16BusError[CSM_C_MAX_CAN_BUS];
  BOOLEAN afCommTxReq[CSM_LCTR_C_MAX_USER];         // Triggerflag for CommunicationReq
  BOOLEAN afDataTxReq[CSM_LCTR_C_MAX_USER];         // Triggerflag for DataReq
  BOOLEAN afWaitForCommConf[CSM_LCTR_C_MAX_USER];   // Marker: waiting for remote ComReq confirmation
  BOOLEAN afWaitForDataConf[CSM_LCTR_C_MAX_USER];   // Marker: waiting for remote DataReq confirmation
  BYTE    au8CommStatusReq[CSM_LCTR_C_MAX_USER];    // Action: Connect, Disconnect [or OSEKI cmd]
  WORD    awAddressField[CSM_LCTR_C_MAX_USER];      // CSM Adressfeld
  WORD    awApplId[CSM_LCTR_C_MAX_USER];            // ?? das knnte auch aus der CSM konfiguration kommen
  BYTE    bBus[CSM_LCTR_C_MAX_USER];                // bus number [for OSEKI]
  BYTE    bCurrentProtocolClient;                   // NONE, LCTRL or OSEKI: default is CSM_NET_PROTOCOL_CLIENT_NONE
} tCSM_IPC_DATA_REMOTE_COMMON;

// for ???
typedef struct
{
  WORD    xu16LastCommApplId;
} tCSM_IPC_DATA_REMOTE_BUS;                         //#ToDo: MP remove

// BR channel
typedef struct
{
  // CommReq:
  BOOLEAN fCommTxReq;
  BOOLEAN fWaitForCommConf;
  WORD    u16LastCommApplId;
  BYTE    au8CommStatusReq[ 1 /*CSM_C_MAX_APPL_ID*/];
  BYTE    au8CommStatusAct[ 1 /*CSM_C_MAX_APPL_ID*/];
  // SignalWrite:
  BOOLEAN afTelTxReq[CBR_TX_ABSOLUT_MAX_NUMBER];   // we always need the max. amount of buffers here
  BYTE    au8TelTxType[CBR_TX_ABSOLUT_MAX_NUMBER]; // we always need the max. amount of buffers here
} tCSM_IPC_DATA_BR_BUS; //#ToDo: MP remove

// BR channel
typedef struct
{
  tIpcHdl tyIpcHandle;
  BOOL    fRxBufferUsed;
  BYTE    au8BufferRx[ CSM_C_BUFFER_SIZE_BR_RX];
  BYTE    au8BufferTx[ CSM_C_BUFFER_SIZE_BR_TX];
  WORD    wDataLength;
  BOOLEAN afCommTxReq[ CSM_CBR_MAX_USER];          //?? Trigger CommunicationReq
  BOOLEAN afWaitForCommConf[ CSM_CBR_MAX_USER];
  BYTE    au8CommStatusReq[ CSM_CBR_MAX_USER];
  BYTE    au8CommStatusAct[ CSM_CBR_MAX_USER];
  WORD    awApplId[ CSM_CBR_MAX_USER];             //?? das knnte auch aus der CSM konfiguration kommen

  BOOLEAN afTelTxReq[CBR_TX_ABSOLUT_MAX_NUMBER];   // we always need the max. amount of buffers here
  BYTE    au8TelTxType[CBR_TX_ABSOLUT_MAX_NUMBER]; // we always need the max. amount of buffers here
} tCSM_IPC_DATA_BR_COMMON;

// TP channels
typedef struct
{
  tIpcHdl tyIpcHandle;
  BOOL    fRxBufferUsed;
  BYTE    au8BufferRx[CSM_C_BUFFER_SIZE_TP_RX];
  BYTE    au8BufferTx_C[CSM_C_BUFFER_SIZE_TP_TX_C];// only used for DataReq, not CommReq
  BYTE    au8BufferTx_D[CSM_C_BUFFER_SIZE_TP_TX_D];// only used for DataReq, not CommReq

  DWORD   u32TxLength_C;                           // special for MPDT
  DWORD   u32TxLength_D;                           // special for MPDT

  WORD    wDataLength;
  BOOLEAN fWaitForIncConf;                         // this actually indicates, that an INC request has been sent to remote CSM
                                                   // the channel related timer has also been started right before !!!
  // CommReq:
  BOOLEAN fCommTxReq;
  BOOLEAN fWaitForCommConf;
  BYTE    u8CommStatusReq;
  BYTE    u8CommStatusAct;
  // DataReq:
  BOOLEAN fWaitForDataConf_C;                      // special for MPDT
  BOOLEAN fWaitForDataConf_D;                      // special for MPDT
  BOOLEAN fDataTxReq_C;                            // special for MPDT
  BOOLEAN fDataTxReq_D;                            // special for MPDT
  // DataInd:
  BOOLEAN fDataAvailable;
} tCSM_IPC_DATA_TP;

//**************************************************************************************************
// variable declaration (scope: global)
//**************************************************************************************************
//#ToDo: Better include header file instead of defining IPN and IPC constants
#define IPC_SRVC_CODE_COMP_STATUS_REQ          0x08  // Component activation request (CCC application -> CCS)
#define IPC_SRVC_CODE_COMP_STATUS_CON          0x09  // Component activation confirmation (CCS -> CCC application)
#define IPC_SRVC_CODE_COMP_STATUS_IND          0x0B  // Component activation indication (CCC application -> CCS)
#define IPC_SRVC_CODE_BUS_STATE_IND            0x15  // Bus state change indication
#define IPC_SRVC_CODE_BUS_ERROR_IND            0x17  // Bus error state change indication
#define IPC_SRVC_CODE_SERVICE_REJECT           0x1B  // Reject of previous (request) service
#define IPC_SRVC_CODE_COMMUNICATION_REQ        0x24  // Communication request (all kinds of connections)
#define IPC_SRVC_CODE_COMMUNICATION_CON        0x25  // Communication confirmation (all kinds of conn.)
#define IPC_SRVC_CODE_COMMUNICATION_IND        0x27  // Communication indication (all kinds of conn.)
#define IPC_SRVC_CODE_DATA_REQ                 0x40  // Data send request
#define IPC_SRVC_CODE_DATA_CON                 0x41  // Data send confirmation
#define IPC_SRVC_CODE_DATA_IND                 0x45  // Data send indication
#define IPC_SRVC_CODE_SIGNAL_WRITE_REQ         0x50  // Signal write request
#define IPC_SRVC_CODE_SIGNAL_IND               0x55  // Signal reception indication
#define IPC_SRVC_CODE_MULTI_SIGNAL_IND         0x57  // Signal reception indication

// Service data codes
#define CCS_REJ_NO_REASON                      0x00
#define CCS_REJ_UNKNOWN_SRVC                   0x01
#define CCS_REJ_COMP_INACTIVE                  0x02
#define CCS_REJ_INVALID_PARA                   0x03
#define CCS_REJ_SRVC_UNAVAILABLE               0x0b
#define CCS_REJ_STACK_INACTIVE                 0x80
#define CCS_REJ_STACK_BUSY                     0x81
#define CCS_REJ_NO_CONNECTION                  0x82

// CCS states
#define CCS_ACTIVE                             0x01
#define CCS_INACTIVE                           0x02
#define CCS_DISCONNECT                         0x00
#define CCS_CONNECT                            0x01

//*********************************************************************************************************************************************
// check iMX global feature switches to find out which project variant we are building now
#if (defined VARIANT_S_FTR_ENABLE_INF4CV) || (defined VARIANT_S_FTR_ENABLE_EVOBUS) || (defined VARIANT_S_FTR_ENABLE_SMART_HU) || (defined VARIANT_S_FTR_ENABLE_EVOBUSB2E)
  // fine: at least we are building one of these 2 projects
#else
  #error "No valid project variant detectable: INF4CV required here"
#endif

#if (defined VARIANT_S_FTR_ENABLE_INF4CV) || (defined VARIANT_S_FTR_ENABLE_EVOBUS) || (defined VARIANT_S_FTR_ENABLE_SMART_HU) || (defined VARIANT_S_FTR_ENABLE_EVOBUSB2E)
  #include "csm_proxy_mp_inf4cv.h"
#endif


//*********************************************************************************************************************************************
// map the following variables intp csm_proxy.c
#ifdef CSM_PROXY_SELF
const tCSM_IPC_CFG corIpcCfgRemoteNet =
{
  CSM_C_CAN_BUS_VCAN,                          // bus not used
  IPC_CONTEXT_TYPE_NET_DC_CAN,                 // u8Context
  IPC_CONTEXT_SUBTYPE_LOCAL_NET_CTRL,          // u8Subcontext
  {0, 0},                                      // au8NetCompAddr[2]
  CSM_C_PTYPE_PSGEN_CAN_LOCAL_CTRL,               // dwProtocolType
  {0, 0}                                       // au8AddressField[2]
};

const tCSM_IPC_CFG corIpcCfgBrSignal =
{
  CSM_C_CAN_BUS_VCAN,                          // bus
  IPC_CONTEXT_TYPE_NET_DC_CAN,                 // u8Context
  IPC_CONTEXT_SUBTYPE_DC_BR_SIGNAL,            // u8Subcontext
  {CSM_C_ADDRESS_FIELD_INF4CV_BR_VCAN, CSM_C_ADDRESS_FIELD_INF4CV_BR_VCAN },   // au8NetCompAddr[2]
  CSM_C_PTYPE_DC_BR_SIGNAL,                    // dwProtocolType
  {CSM_C_ADDRESS_FIELD_INF4CV_BR_VCAN, CSM_C_ADDRESS_FIELD_INF4CV_BR_UNDEF }  // au8AddressField[2]
};

// IPC/INC Buffers instances
tCSM_IPC_DATA_REMOTE_COMMON rIpcDataRemoteNet;
tCSM_IPC_DATA_BR_COMMON     rIpcDataBrSignalCom;
tCSM_IPC_DATA_TP            arIpcDataTp[CSM_C_PROXY_TP_CHANNELS];
//tCSM_IPC_DATA_REMOTE_BUS    rIpcDataRemoteNetBus[CSM_C_MAX_CAN_BUS];
//tCSM_IPC_DATA_BR_BUS        rIpcDataBrSignal[CSM_C_MAX_CAN_BUS];

#else // CSM_PROXY_SELF
  // IPC/INC Buffers declarations
  extern const tCSM_IPC_CFG corIpcCfgRemoteNet;
  extern const tCSM_IPC_CFG corIpcCfgBrSignal;
  extern const tCSM_IPC_CFG coarIpcCfgTp[];

  extern const tIpcHdl coarIpcCfgTpIncHandle[];
  extern sk_dgram * arIpcCfgTpSocketHandles[];
  extern const tyIpcCfgTpComCallback arpIpcCfgTpComCallbacks[];

  extern tCSM_IPC_DATA_REMOTE_COMMON rIpcDataRemoteNet;
  extern tCSM_IPC_DATA_BR_COMMON     rIpcDataBrSignalCom;
  extern tCSM_IPC_DATA_TP            arIpcDataTp[];
  //extern tCSM_IPC_DATA_REMOTE_BUS    rIpcDataRemoteNetBus[];
  //extern tCSM_IPC_DATA_BR_BUS        rIpcDataBrSignal[];
#endif // CSM_PROXY_SELF

/*****************************************************************
| function prototypes (scope: global)
|----------------------------------------------------------------*/
// none

#else
  #error CSM_PROXY_MP.H included several times
#endif

/*******************************************************************************
 * \doxydocu
 * \file          csm_proxy_mp.h
 * \brief         Header file for Proxy external used function and defines.
 *
 *                Header file for CBR external used function and defines.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/csm/src/
 *
 * \ingroup       CSM
 *
 * \authors       V-Team
 *
 * COPYRIGHT:      (c) 2015 Bosch Car Multimedia GmbH
 *
 * \history_begin
 * 23.10.13  \main\vw_mib2_mqb_proxy\13 Prhl
 * - CSM_C_BUFFER_SIZE_BR_RX and CSM_C_BUFFER_SIZE_BR_TX for new message catalog
 *
 * 02.04.15  \main\rn_aivi_proxy\1  Prhl
 * - merge from \main\vw_mib2_mqb_proxy\13
 *
 * 07.04.15  \main\rn_aivi_proxy\2  Prhl
 * - ISO-TP and CBR configuration chaged.
 *
 * 13.04.15  \main\rn_aivi_proxy\3  Prhl
 * - LOCAL_CTRL configuration chaged.
 *
 * 21.04.15  \main\rn_aivi_proxy\4  Borck
 * - ISO-TP stuff disabled
 * - CSM_C_MAX_APPL_ID replaced by magic number 1 -> to be checked
 * - external declaration added for csm_arCbrTxTelegram[] sinced needed in csm_proxy.c (maybe to be fixed later on)
 *
 * 30.04.15  \main\rn_aivi_proxy\5  Prhl
 * - TP configuration chaged.
 * - CBR configuration chaged.
 *
 * 30.04.15  \main\rn_aivi_proxy\6  Prhl
 * - TP configuration chaged to get TCU and RSE running.
 *
 * 19.05.15  \main\rn_aivi_proxy\7  Prhl
 * - IPC Buffer length modified.
 *
 * 03.06.15  \main\rn_aivi_proxy\8  Borck
 * - BAP defines removed
 * - number of Proxy TP channels increased from 2 to 3
 * - BAP typedefs removed
 * - configuration for proxy TP channels extended by 3. entry for MPDT BOSE
 *
 * 04.06.15  \main\rn_aivi_proxy\9  Borck
 * - config struct type for IPC extended by bus nr.
 *
 * 09.07.15  \main\rn_aivi_proxy\10  Borck
 * - new timeouts for NET CTRL, OSEKI
 * - NET channel is now splitted into 2 subchannels
 * - IPC NET struct extended
 * - IPC TP struct extended
 *
 * 21.07.15  \main\rn_aivi_proxy\11  Borck
 * - incorrect external declaration removed
 *
 * 23.07.15  \main\rn_aivi_proxy\12  Borck
 * - some LINT issues fixed
 *
 * 21.09.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\1  Borck
 * - 2 #defines replaced for SLOT based config concept
 *
 * 04.11.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\2  Borck
 * - amount of NP channels (TP) increased from 3 to 8
 * - new channels introduced
 *
 * 28.01.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\3  M.Prhl
 * - CSM_C_BUFFER_SIZE_BR_RX set to 61
 * - define IPC_SRVC_CODE_MULTI_SIGNAL_IND for new message code added.
 *
 * 16.02.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\4  A.Borck
 * - obsolete (duplicated) #defines removed
 *
 * 02.03.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\5  M.Prhl
 * - proposal to solve the inc_port.h issue
 *
 * 03.03.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\6  M.Prhl
 * - use BAP_00_PORT as long it is existing.
 *
 * 16.09.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\7  A.Borck
 * - TX buffer sizes defined for CType and DType MPDT data/definitions
 * - struct tCSM_IPC_DATA_TP extended
 *
 * 07.11.16  \main\rn_aivi_proxy\rn_aivi_proxy_generated\8  A.Borck
 * - some extensions regarding LCTRL DataReq and DataCon via INC
 *
 * 02.02.17  \main\rn_aivi_proxy\rn_aivi_proxy_generated\9  A.Borck
 * - some variant specific code removed here -> to variant specific sub-header
 * - variant specific sub-header is included in dependency of the feature switches
 * - INC port mapping comments adapted, since they are not generically valid anymore
 *
 * 05.05.17  \main\rn_aivi_proxy\rn_aivi_proxy_generated\10  A.Borck
 * - struct coarIpcCfgTpIncHandle[] moved to project specific file
 * - 2 new data structs declarations added.
 *
 * 24.11.17  main\g3inf4cv_csm_proxy_in\1  Jayashree
 * - Modified protocoltypes as per INF4CV
 *
 * \history_end
 * *** END OF FILE ******************************************************* */
