/************************************************************************
 *FILE:           CSM_PROXY_IP.H
 *SW-COMPONENT:   CAN Proxy Server module header
 *DESCRIPTION:    CAN header file for module
 *                external/internal used data/definitions
 *AUTHOR:         CM-DI/ESA3-Haffner
 *COPYRIGHT:      (c) 2006 Blaupunkt Werke GmbH
 *
 ************************************************************************/

#ifndef CSM_PROXY_IP_HEADER
#define CSM_PROXY_IP_HEADER

/*****************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------*/
/* --none-- */

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/
/* --none-- */

/*****************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------*/

typedef DWORD tIpcHdl;                            // Socket handle for INC/IPC channel
typedef void(* tyIpcCfgTpComCallback)(INT);       // ComCallback Function Pointer

/*****************************************************************
| variable declaration (scope: global)
|----------------------------------------------------------------*/
/* --none-- */

/*****************************************************************
| function prototypes (scope: global)
|----------------------------------------------------------------*/
/* --none-- */


#else
#error CSM_PROXY_IP.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          csm_proxy_ip.h
 * \brief         Header file for Proxy external used function and defines.
 *
 *                Header file for CBR external used function and defines.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/csm/src/
 *
 * \ingroup       CSM
 *
 * \authors       V-Team
 *
 * COPYRIGHT:      (c) 2006 Blaupunkt GmbH
 *
 * \history_begin
 * 06.04.06   CM-DI/ESA3-Haffner
 * - Initial version.
 *
 * 18.03.13  \main\3\gm_gen3_proxy\1  Pistoor
 * - Made csm proxy working with GM MY16
 *
 * 05.05.17  \main\3\gm_gen3_proxy\2  Borck
 * - new typedef for ComCallback added
 *
 * \history_end
 * *** END OF FILE ******************************************************* */
