/* Description and history of csm_j1939_m.h at the end of the file.             */
#ifndef CSM_J1939_M_HEADER
/** File name for preprozessor commands */
#define CSM_J1939_M_HEADER

/* No further includes allowed */

/*******************************************************************************
 * defines and macros (scope: can stack manager module local)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * typedefs (scope: can stack manager module local)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition (scope: can stack manager module local)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: file local = static)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: can stack manager module local)
 ******************************************************************************/
LONG CSM_J1939_lExit( BYTE bExitMode);
LONG CSM_J1939_lInit( BYTE bInitMode);

void CSM_J1939_vCNPDataInd(WORD wPGN);
void CSM_J1939_vCNPDataIndFF(WORD wPGN);
void CSM_J1939_vCNPDataCon(WORD wPGN, BYTE bTransferResult);
void CSM_J1939_vCNPDataErrorInd(WORD wPGN);
void CSM_J1939_vPROXYTriggerCommunicationCon(BYTE bUser, BYTE bAction);
void CSM_J1939_vPROXYTriggerCommunicationInd(BYTE bUser, BYTE bAction);
LONG CSM_J1939_lDataReq( DWORD dwProtocolType,
                         const void* pvAddressField,
                         const BYTE* pbData,
                         WORD  wDataLength);
BYTE CSM_J1939_bGetNodeAddress(BYTE bBus, BYTE bID);
BYTE CSM_J1939_bGetNodeID(BYTE bBus, BYTE bAddr);
LONG CSM_J1939_lCommunicationReq( BYTE  bBus,
                                  DWORD dwProtocolType,
                                  const void* pvAddressField,
                                  BYTE  bAction,
                                  WORD wApplID);
BOOL CSM_J1939_fCheckCommunicationReq( BYTE bBus );
LONG CSM_J1939_lDataIndProcessed(DWORD dwProtocolType, const void* pvAddressField);
void CSM_J1939_vPGNTxTimeout(DWORD dwParam);
void CSM_J1939_vPGNRxTimeout(DWORD dwParam);
#if (CSM_S_J1939_STARTSTOP_BROADCAST == CSM_C_F_ON)
void CSM_J1939_vStopBroadcastTimeout(DWORD dwParam);
#endif
void CSM_J1939_vNMDelayTimeout(DWORD dwparam);
void CSM_J1939_vBusoffReinitTimeout(DWORD dwParam);

void CSM_J1939_vProcessCommunicationCon( void );
void CSM_J1939_vProcessCommunicationInd( void );
void CSM_J1939_vProcessCommunicationReq( void );
void CSM_J1939_vProcessDataInd(void);
void CSM_J1939_vProcessDataCon(void);
void CSM_J1939_vProcessErrorInd(void);
void CSM_J1939_vProcessDataReq(void);
void CSM_J1939_vProcessDataIndFF(void);
void CSM_J1939_vProcessDataIndProcessed(void);
void CSM_J1939_vProcessPGNTimeout(void);
void CSM_J1939_vProcessNMDelayTimeout(void);
void CSM_J1939_vProcessBusoffReinit(void);
void CSM_J1939_vProcessRxTimeout(void);
void CSM_J1939_vProcessTxTimeout(void);

void CSM_J1939_vCSMBusStateInd( BYTE bBus, BYTE bCsmActState);

#if (CSM_S_CALLBACK_INIT_BY_APPLICATION == CSM_C_F_ON)
LONG CSM_J1939_lApplCallbackInit(void* pvHandle, BYTE bBus, DWORD dwProtocolType, const void* pvAddressField, tCSM_J1939_APPL_CALLBACK* prCallBackFkt);
#endif

#else
#error CSM_J1939_M.H included several times
#endif
