/* Description and history of csm_i.h at the end of the file.                 */
#ifndef CSM_I_HEADER
/** File name for preprozessor commands */
#define CSM_I_HEADER

#include "csm_ip.h"   /* include project specific part */

/*******************************************************************************
 * defines and macros (scope: CAN stack and external)
 ******************************************************************************/
/*** The dwProtocolTypes (according to CAN-SWA specification, table 20):
     The supported types are listed here, copy the defines you need in your project
     to csm_stack_ip.h (caution: They are used like feature switches!).

#define CSM_C_PTYPE_MCNET_LOCAL_CTRL       0x8001UL   MCNet Stack Control
#define CSM_C_PTYPE_MCNET_ASDT_STD         0x8010UL   MCNet p-p services
#define CSM_C_PTYPE_MCNET_ASDT_EXP         0x8012UL   MCNet p-p services (expedited data transfer)
#define CSM_C_PTYPE_MCNET_USDT             0x8042UL   MCNet broadcast

#define CSM_C_PTYPE_VW_CAN_LOCAL_CTRL      0x8401UL   General (local) control of VW CAN stack
#define CSM_C_PTYPE_VW_OSEK_NWM            0x8403UL   OSEK network management
#define CSM_C_PTYPE_VW_ASDT_TP_16          0x8422UL   VW TP1.6
#define CSM_C_PTYPE_VW_ASDT_TP_20          0x8424UL   VW TP2.0
#define CSM_C_PTYPE_VW_BR_SIGNAL           0x8440UL   VW Broadcast (signals)
#define CSM_C_PTYPE_VW_UUDT_TP20_BR        0x8444UL   VW TP2.0 UUDT
#define CSM_C_PTYPE_VW_BAP_RAW             0x8460UL   BAP raw data (CAN telegrams
#define CSM_C_PTYPE_VW_BAP                 0x8461UL   BAP (full protocol access)

#define CSM_C_PTYPE_DC_OSEK_NWM            0x8803UL   OSEK network management
#define CSM_C_PTYPE_DC_BR_SIGNAL           0x8842UL   DC Broadcast (signals)
#define CSM_C_PTYPE_DC_USDT_ISO            0x8850UL   DC ISO TP

#define CSM_C_PTYPE_FIAT_NWM               0x8C03UL   FIAT network management
#define CSM_C_PTYPE_FIAT_BR_SIGNAL         0x8C40UL   FIAT Broadcast (signals)
#define CSM_C_PTYPE_FIAT_USDT_ISO_EXT      0x8C51UL   ISO TP, extended addr.

#define CSM_C_PTYPE_OPEL_NWM               0x9003UL   OPEL network management
#define CSM_C_PTYPE_OPEL_BR_SIGNAL         0x9040UL   broadcasts used as signals
#define CSM_C_PTYPE_OPEL_BR_TEL            0x9041UL   broadcasts used as messages/telegrams
#define CSM_C_PTYPE_OPEL_USDT_ISO          0x9050UL   ISO-TP, normal addressing
#define CSM_C_PTYPE_OPEL_USDT_ISO_EXT      0x9051UL   ISO-TP, extended addr.
#define CSM_C_PTYPE_OPEL_USDT_ISO_EXT_MUX  0x9052UL   ISO-TP, ext. addr., multiplexed

#define CSM_C_PTYPE_FORD_CAN_LOCAL_CTRL    0x9401UL   General (local) control of FORD CAN stack
#define CSM_C_PTYPE_FORD_NWM               0x9403UL   FORD network management
#define CSM_C_PTYPE_FORD_BR_SIGNAL         0x9440UL   FORD Broadcast (signals)
#define CSM_C_PTYPE_FORD_UUDT_TX           0x9441UL   FORD Broadcast (tx telegrams)
#define CSM_C_PTYPE_FORD_UUDT_RX           0x9442UL   FORD Broadcast (rx telegrams)
#define CSM_C_PTYPE_FORD_USDT_ISO          0x9450UL   FORD ISO TP, normal addressing

#define CSM_C_PTYPE_GM_CAN_LOCAL_CTRL      0x9801UL   General (local) control of GM CAN stack
#define CSM_C_PTYPE_GM_NWM                 0x9803UL   GM network management (GMLAN)
#define CSM_C_PTYPE_GM_BR_SIGNAL           0x9840UL   GM Broadcast (signals)
#define CSM_C_PTYPE_GM_UUDT_TX             0x9841UL   GM Broadcast (tx telegrams)
#define CSM_C_PTYPE_GM_UUDT_RX             0x9842UL   GM Broadcast (rx telegrams)
#define CSM_C_PTYPE_GM_USDT_ISO            0x9850UL   GM ISO TP, normal addressing
#define CSM_C_PTYPE_GM_USDT_ISO_EXT        0x9851UL   GM ISO TP, extended addr.

#define CSM_C_PTYPE_RN_LOCAL_NET_CTRL      0x9C01UL   Renault-Nissan CAN local stack control
#define CSM_C_PTYPE_RN_OSEK_NWM            0x9C03UL   Renault        (direct)   OSEK NWM
#define CSM_C_PTYPE_RN_OSEKI_NWM           0x9C04UL   Renault-Nissan (indirect) OSEK NWM
#define CSM_C_PTYPE_RN_BR_SIGNAL           0x9C40UL   Renault-Nissan Broadcast (signals)
#define CSM_C_PTYPE_RN_USDT_ISO            0x9C50UL   Renault ISO TP variant
#define CSM_C_PTYPE_RN_ASDT                0x9C56UL   Renault specific ASDT protocol
#define CSM_C_PTYPE_RN_MPDT_C              0x9C57UL   Renault-Nissan MPDT IL=Control (25915NDS01)
#define CSM_C_PTYPE_RN_MPDT_D              0x9C58UL   Renault-Nissan MPDT IL=Data (25915NDS01)

#define CSM_C_PTYPE_PSA_CAN_LOCAL_CTRL     0xA001UL   General (local) control of PSA CAN stack
#define CSM_C_PTYPE_PSA_OSEKI_NWM          0xA004UL   PSA (indirect) OSEK NWM
#define CSM_C_PTYPE_PSA_BR_SIGNAL          0xA040UL   PSA Broadcast (signals)
#define CSM_C_PTYPE_PSA_USDT_ISO           0xA050UL   PSA ISO TP variant

#define CSM_C_PTYPE_BRP_CAN_LOCAL_CTRL     0xA401UL   General (local) control of BRP CAN stack
#define CSM_C_PTYPE_BRP_BR_SIGNAL          0xA440UL   BRP Broadcast (signals)
#define CSM_C_PTYPE_BRP_USDT_ISO           0xA450UL   BRP ISO TP variant

#define CSM_C_PTYPE_PAG_CAN_LOCAL_CTRL     0xB001UL   General (local) control of PAG CAN stack
#define CSM_C_PTYPE_PAG_OSEK_NWM           0xB003UL   PAG OSEK network management
#define CSM_C_PTYPE_PAG_BR_SIGNAL          0xB040UL   PAG Broadcast (signals)

#define CSM_C_PTYPE_PSGEN_CAN_LOCAL_CTRL   0xC001UL   J1939 protocol
#define CSM_C_PTYPE_PSGEN_BR_SIGNAL        0xC040UL   PS Gen Broadcast (signals)
#define CSM_C_PTYPE_PSGEN_USDT_ISO         0xC050UL   PS Gen ISO TP variant

**********/

/** CSM_C_PTYPE_USED_STD_USDT_ISO is a placeholder for a USDT ISO-TP protocol
 *  type if the standard routines (CSM_ITP_lDataReq() ..) for normal addressing
 *  shall be used. */
#ifdef CSM_C_PTYPE_OPEL_USDT_ISO
  #define CSM_C_PTYPE_USED_STD_USDT_ISO  CSM_C_PTYPE_OPEL_USDT_ISO
#elif (defined CSM_C_PTYPE_FORD_USDT_ISO)
  #define CSM_C_PTYPE_USED_STD_USDT_ISO  CSM_C_PTYPE_FORD_USDT_ISO
#elif (defined CSM_C_PTYPE_GM_USDT_ISO)
  #define CSM_C_PTYPE_USED_STD_USDT_ISO  CSM_C_PTYPE_GM_USDT_ISO
#elif (defined CSM_C_PTYPE_RN_USDT_ISO)
  #define CSM_C_PTYPE_USED_STD_USDT_ISO  CSM_C_PTYPE_RN_USDT_ISO
#elif (defined CSM_C_PTYPE_VW_USDT_ISO)
  #define CSM_C_PTYPE_USED_STD_USDT_ISO  CSM_C_PTYPE_VW_USDT_ISO
#elif (defined CSM_C_PTYPE_PAG_USDT_ISO)
  #define CSM_C_PTYPE_USED_STD_USDT_ISO  CSM_C_PTYPE_PAG_USDT_ISO
#elif (defined CSM_C_PTYPE_PSA_USDT_ISO)
  #define CSM_C_PTYPE_USED_STD_USDT_ISO  CSM_C_PTYPE_PSA_USDT_ISO
#elif (defined CSM_C_PTYPE_DC_USDT_ISO)
  #define CSM_C_PTYPE_USED_STD_USDT_ISO  CSM_C_PTYPE_DC_USDT_ISO
#elif (defined CSM_C_PTYPE_BRP_USDT_ISO)
  #define CSM_C_PTYPE_USED_STD_USDT_ISO  CSM_C_PTYPE_BRP_USDT_ISO
#else
  #ifdef CSM_C_PTYPE_USED_STD_USDT_ISO
    #error "CSM_C_STANDARD_USDT_ISO_PTYPE must not be defined."
  #endif
#endif

/** CSM_C_PTYPE_USED_STD_BR_SIGNAL is a placeholder for a BR_SIGNAL protocol
 *  type if the standard routines (CSM_lCommunicationReq() ..) shall be used. */
#ifdef CSM_C_PTYPE_GM_BR_SIGNAL
  #define CSM_C_PTYPE_USED_STD_BR_SIGNAL    CSM_C_PTYPE_GM_BR_SIGNAL
#elif (defined CSM_C_PTYPE_VW_BR_SIGNAL)
  #define CSM_C_PTYPE_USED_STD_BR_SIGNAL    CSM_C_PTYPE_VW_BR_SIGNAL
#elif (defined CSM_C_PTYPE_PAG_BR_SIGNAL)
  #define CSM_C_PTYPE_USED_STD_BR_SIGNAL    CSM_C_PTYPE_PAG_BR_SIGNAL
#elif (defined CSM_C_PTYPE_FORD_BR_SIGNAL)
  #define CSM_C_PTYPE_USED_STD_BR_SIGNAL    CSM_C_PTYPE_FORD_BR_SIGNAL
#elif (defined CSM_C_PTYPE_FIAT_BR_SIGNAL)
  #define CSM_C_PTYPE_USED_STD_BR_SIGNAL    CSM_C_PTYPE_FIAT_BR_SIGNAL
#elif (defined CSM_C_PTYPE_MC_BR_SIGNAL)
  #define CSM_C_PTYPE_USED_STD_BR_SIGNAL    CSM_C_PTYPE_MC_BR_SIGNAL
#elif (defined CSM_C_PTYPE_RN_BR_SIGNAL)
  #define CSM_C_PTYPE_USED_STD_BR_SIGNAL    CSM_C_PTYPE_RN_BR_SIGNAL
#elif (defined CSM_C_PTYPE_PSA_BR_SIGNAL)
  #define CSM_C_PTYPE_USED_STD_BR_SIGNAL    CSM_C_PTYPE_PSA_BR_SIGNAL
#elif (defined CSM_C_PTYPE_DC_BR_SIGNAL)
  #define CSM_C_PTYPE_USED_STD_BR_SIGNAL    CSM_C_PTYPE_DC_BR_SIGNAL
#elif (defined CSM_C_PTYPE_BRP_BR_SIGNAL)
  #define CSM_C_PTYPE_USED_STD_BR_SIGNAL    CSM_C_PTYPE_BRP_BR_SIGNAL
  #else
  #ifdef CSM_C_PTYPE_USED_STD_BR_SIGNAL
    #error "CSM_C_PTYPE_USED_STD_BR_SIGNAL must not be defined."
  #endif
#endif

/** CSM_C_PTYPE_USED_STD_BR_SIGNAL is a placeholder for a BR_SIGNAL protocol
 *  type if the standard routines (CSM_lCommunicationReq() ..) shall be used. */
#ifdef CSM_C_PTYPE_GM_CAN_LOCAL_CTRL
  #define CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL  CSM_C_PTYPE_GM_CAN_LOCAL_CTRL
#elif (defined CSM_C_PTYPE_VW_CAN_LOCAL_CTRL)
  #define CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL  CSM_C_PTYPE_VW_CAN_LOCAL_CTRL
#elif (defined CSM_C_PTYPE_PAG_CAN_LOCAL_CTRL)
  #define CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL  CSM_C_PTYPE_PAG_CAN_LOCAL_CTRL
#elif (defined CSM_C_PTYPE_FORD_CAN_LOCAL_CTRL)
  #define CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL  CSM_C_PTYPE_FORD_CAN_LOCAL_CTRL
#elif (defined CSM_C_PTYPE_FIAT_CAN_LOCAL_CTRL)
  #define CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL  CSM_C_PTYPE_FIAT_CAN_LOCAL_CTRL
#elif (defined CSM_C_PTYPE_RN_CAN_LOCAL_CTRL)
  #define CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL  CSM_C_PTYPE_RN_CAN_LOCAL_CTRL
#elif (defined CSM_C_PTYPE_MC_CAN_LOCAL_CTRL)
  #define CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL  CSM_C_PTYPE_MC_CAN_LOCAL_CTRL
#elif (defined CSM_C_PTYPE_PSA_CAN_LOCAL_CTRL)
  #define CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL  CSM_C_PTYPE_PSA_CAN_LOCAL_CTRL
#elif (defined CSM_C_PTYPE_PSGEN_CAN_LOCAL_CTRL)
  #define CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL  CSM_C_PTYPE_PSGEN_CAN_LOCAL_CTRL
#elif (defined CSM_C_PTYPE_BRP_CAN_LOCAL_CTRL)
  #define CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL  CSM_C_PTYPE_BRP_CAN_LOCAL_CTRL
#else
  #ifdef CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL
    #error "CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL must not be defined."
  #endif
#endif



/** CSM_C_PTYPE_USED_STD_UUDT_TX is a placeholder for a UUDT protocol
 *  type if the standard routines (CNP_UUDT_lDataReq() ..)
 *  shall be used. */
#ifdef CSM_C_PTYPE_GM_UUDT_TX
  #define CSM_C_PTYPE_USED_STD_UUDT_TX  CSM_C_PTYPE_GM_UUDT_TX
#elif (defined CSM_C_PTYPE_FORD_UUDT_TX)
  #define CSM_C_PTYPE_USED_STD_UUDT_TX  CSM_C_PTYPE_FORD_UUDT_TX
#else
  #ifdef CSM_C_PTYPE_USED_STD_UUDT_TX
    #error "CSM_C_PTYPE_USED_STD_UUDT_TX must not be defined."
  #endif
#endif


/** CSM_C_PTYPE_USED_STD_UUDT_RX is a placeholder for a UUDT protocol
 *  type if the standard routines (CNP_UUDT_lDataReq() ..)
 *  shall be used. */
#ifdef CSM_C_PTYPE_GM_UUDT_RX
  #define CSM_C_PTYPE_USED_STD_UUDT_RX  CSM_C_PTYPE_GM_UUDT_RX
#elif (defined CSM_C_PTYPE_FORD_UUDT_TX)
  #define CSM_C_PTYPE_USED_STD_UUDT_RX  CSM_C_PTYPE_FORD_UUDT_RX
#else
  #ifdef CSM_C_PTYPE_USED_STD_UUDT_RX
    #error "CSM_C_PTYPE_USED_STD_UUDT_RX must not be defined."
  #endif
#endif


/** CSM_C_PTYPE_USED_STD_LIN_DIAG is a placeholder for a USDT protocol
 *  type if the standard routines (CSM_lDataReq() ..)
 *  shall be used. */
#ifdef CSM_C_PTYPE_FORD_USDT_LIN
  #define CSM_C_PTYPE_USED_STD_LIN_DIAG  CSM_C_PTYPE_FORD_USDT_LIN
#else
  #ifdef CSM_C_PTYPE_USED_STD_LIN_DIAG
    #error "CSM_C_PTYPE_USED_STD_LIN_DIAG must not be defined."
  #endif
#endif

/** CSM_C_PTYPE_USED_STD_LIN_USDT is a placeholder for a USDT protocol
 *  type if the standard routines (CSM_lDataReq() ..)
 *  shall be used. */
#ifdef CSM_C_PTYPE_GM_USDT_LIN
  #define CSM_C_PTYPE_USED_STD_LIN_USDT  CSM_C_PTYPE_GM_USDT_LIN
#else
  #ifdef CSM_C_PTYPE_USED_STD_LIN_USDT
    #error "CSM_C_PTYPE_USED_STD_LIN_USDT must not be defined."
  #endif
#endif


/*******************************************************************************
 * typedefs (scope: CAN stack and external)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition (scope: CAN stack and external)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: CAN stack and external)
 ******************************************************************************/
/* --none-- but in csm_ip.h with project specific datatypes */

#else
  #error CSM_I.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          csm_i.h
 * \brief         Interface header(s) of CSM
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       main latest
 * \path          /di_can/modules_swa/csm/src/
 *
 * \ingroup       CSM
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2001 Blaupunkt GmbH
 *
 * \history_begin
 *
 ******* PVCS
 *01.12.03  Rev. 2.0 CM-DI/ESU3-K"ohler
 *          - New include and feature switch structure.
 *          - Include csm_stack_ip.h removed.
 *          - csm_vIndicateCSMState() csm_vIndicateBusState(), csm_bGetBusState()
 *            and csm_vSetBusState() moved to csm_m.h.
 *
 *29.10.03  Rev. 1.11 CM-DI/ESU3-Franke
 *          - csm_vIndicateState renamed to csm_vIndicateCSMState
 *          - new functions csm_vIndicateBusState, csm_bGetBusState
 *
 *16.10.03  Rev. 1.10 CM-DI/ESU3-Franke
 *          - new function csm_vIndicateState
 *
 *29.07.03  Rev. 1.9 CM-DI/ESU3-K"ohler
 *          - CAN bus state define CSM_C_STATE_BUS_UNDEFINED added.
 *
 *27.03.03  Rev. 1.8 CM-DI/ESU3-Pistoor
 *          - Changed value of CSM_C_PTYPE_FIAT_USDT_ISO_EXT from
 *            0x8C50 to 0x8C51
 *
 *18.02.03  Rev. 1.7 CM-DI/ESU3-Pistoor
 *          - Renamed CSM_C_PTYPE_FIAT_USDT_ISO to CSM_C_PTYPE_FIAT_USDT_ISO_EXT
 *
 *05.12.02  Rev. 1.6 CM-DI/EHS3-FEM5HI
 *          - Added protocol types CSM_C_PTYPE_FORD_BR_SIGNAL and
 *            CSM_C_PTYPE_FORD_USDT_ISO
 *
 *25.09.02  Rev. 1.4 CM-DI/EHS3-Pistoor
 *          - Deleted compiler error after multiple inclusion of this file
 *
 *13.09.02  Rev. 1.3 CM-DI/EHS3-Zurm"uhl, -K"ohler
 *          - Defines CSM_C_PTYPE_OPEL_USDT_ISO_EXT and
 *            CSM_C_PTYPE_OPEL_USDT_ISO_EXT added in comment.
 *
 *20.06.02  Rev. 1.2 CM-DI/EHS3-K"ohler
 *          - Define CSM_C_PTYPE_OPEL_BR_TEL added in comment.
 *
 *31.05.02  Rev. 1.1 CM-DI/EHS3-K"ohler
 *          - Defines CSM_C_CONNECTED/DISCONNECT moved to csm_stack_i.h.
 *
 *25.04.02  Rev. 1.0 CM-DI/EHS3-K"ohler
 *          - CSM_C_PTYPE_ defines moved from csm_stack_i.h
 *
 *18.03.02        Rev. 0.3 CM-DI/ECC13-Pistoor
 *                - Changed STATE definitions from WORD to BYTE length
 *                - Activated #error CSM_I.H included several times again
 *
 *28.02.02        Rev. 0.2 CM-DI/ECC13-Pistoor
 *                Added state definitions and connect/disconnect
 *
 *29.11.01        Rev. 0.1 CM-DI/ECC13-Pistoor
 *                Initial Version.
 ******* ClearCase
 * 30.09.04  \main\3  CM-DI/ESA3-K"ohler
 * - Bus state defines moved from csm_i.h to csm_stack_i.h because they are used
 *   in CNM too.
 *
 * 09.05.05  \main\4  CM-CR/ESD4-Tuschik
 * - Changes for VW-protocol type identifier.
 *
 * 03.04.06  \main\5  CM-DI/ESA3-Battis
 * - protocol types for BAP added in comment
 *
 * 10.05.06  \main\6  CM-DI/ESA3-Battis
 * - BAP include inserted because defines must be visible for applications,too.
 *
 * 21.07.06  \main\7  CM-DI/ESA3-K"ohler
 * - #error for multiple include added again.
 * - Comments with Renault protocol types added.
 * - Doxygen comments added.
 * - Include csm_bap_i.h now in csm_ip.h.
 *
 * 28.07.06  \main\8  CM-DI/ESA3-Zurmhl
 * - protocol types for GM added in comment (all PTYPEs now "UL")
 *
 * 02.08.06  \main\9  CM-DI/ESA3-Zurmhl
 * - comment changed (-> at possible protocol types)
 *
 * 03.08.06  \main\10  CM-DI/ESA3-Zurmhl
 * - comment changed (-> at possible protocol types)
 *
 * 22.08.06  \main\11  CM-DI/ESA3-K"ohler
 * - Define CSM_C_PTYPE_OPEL_USDT_ISO moved from csm_stack_i.h to csm_i.h
 *   because protocol types should be used only in the CAN stack manager and
 *   application and in no other CAN stack module.
 *
 * 12.01.07  \main\12  CM-DI/ESA3-Prhl
 * - Define CSM_C_PTYPE_USED_STD_UUDT_TX and CSM_C_PTYPE_USED_STD_UUDT_RX added
 *
 * 21.03.07  \main\13  VTeam-Prhl
 * - CSM_C_PTYPE_VW_USDT_ISO added.
 *
 * 14.03.08  \main\14  VTeam-Khler
 * - CSM_C_PTYPE_USED_STD_BR_SIGNAL added
 *
 * 20.06.08  \main\15  VTeam-Zurmhl
 * - Template list of CSM_C_PTYPE's updated
 *
 * 24.06.08  \main\16  VTeam-Funke
 * - CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL added
 *
 * 22.09.08  \main\17  Prhl
 * - CSM_C_PTYPE_RN_MPDT_C and CSM_C_PTYPE_RN_MPDT_D added
 *
 * 27.04.09  \main\18  Vteam-Franke
 * - CSM_C_PTYPE_USED_STD_LIN_DIAG added
 *
 * 17.07.09  \main\19  Prhl
 * - CSM_C_PTYPE_FIAT_CAN_LOCAL_CTRL added
 *
 * 21.01.10  \main\20  Prhl
 * - CSM_C_PTYPE_RN_CAN_LOCAL_CTRL added
 *
 * 12.03.10  \main\21  Prhl
 * - CSM_C_PTYPE_PAG_USDT_ISO added
 *
 * 17.03.10 \main\22 Riecker
 * - add CSM_C_PTYPE_MC_CAN_LOCAL_CTRL to CSM_C_PTYPE_USED_STD_BR_SIGNAL definition
 * - add #define CSM_C_PTYPE_USED_STD_BR_SIGNAL CSM_C_PTYPE_MC_BR_SIGNAL
 *
 * 07.09.10 \main\23 Feldhaus
 * - J1939 support
 *
 * 17.09.10 \main\24 Pistoor
 * - add CSM_C_PTYPE_GM_USDT_LIN definition
 *
 * 27.10.10 \main\25 Borck
 * - added CSM_C_PTYPE_RN_OSEKI_NWM definition
 *
 * 13.10.11 \main\26 Borck
 * - added #define CSM_C_PTYPE_USED_STD_BR_SIGNAL    CSM_C_PTYPE_RN_BR_SIGNAL
 * - history fixed
 *
 * 28.05.13 \main\27 Prhl
 * - added #define CSM_C_PTYPE_USED_STD_BR_SIGNAL    CSM_C_PTYPE_PSA_BR_SIGNAL
 * - added #define CSM_C_PTYPE_USED_STD_USDT_ISO    CSM_C_PTYPE_PSA_USDT_ISO
 * - added CSM_C_PTYPE_PSA_CAN_LOCAL_CTRL definition
 * - added CSM_C_PTYPE_PSA_OSEKI_NWM definition
 * - added CSM_C_PTYPE_PSA_BR_SIGNAL definition
 * - added CSM_C_PTYPE_PSA_USDT_ISO definition
 *
 * 13.08.13 \main\28 Basavaraj
 * - added #define CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL    CSM_C_PTYPE_PSA_CAN_LOCAL_CTRL
 *
 * 19.02.16 \main\29 M. Prhl
 * - added #define CSM_C_PTYPE_USED_STD_CAN_LOCAL_CTRL    CSM_C_PTYPE_BRP_CAN_LOCAL_CTRL
 *
 * 23.02.16 \main\30 M. Prhl
 * - merge from \main\ps_generic_base\2
 *
 * 23.02.16 \main\31 M. Prhl
 * - added #define CSM_C_PTYPE_USED_STD_BR_SIGNAL    CSM_C_PTYPE_BRP_BR_SIGNAL
 * - added #define CSM_C_PTYPE_USED_STD_USDT_ISO    CSM_C_PTYPE_BRP_USDT_ISO
 *
 * 23.02.16 \main\32 M. Prhl
 * - typo fixed
 *
 * 24.11.17  main\g3inf4cv_csm_proxy_in\1  Jayashree
 * - Modified protocoltypes as per INF4CV
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
