// Description and history of csm_lctr_mp.h at the end of the file.
#ifndef CSM_CBR_MP_HEADER
// File name for preprozessor commands
#define CSM_CBR_MP_HEADER

// includes only in exceptional cases allowed
// --none--

//******************************************************************************
//* defines and macros
//******************************************************************************
// --none--

//******************************************************************************
//* typedefs
//******************************************************************************
// --none--

//******************************************************************************
//* variable definitions
//******************************************************************************
#if (CSM_S_CBR_AVAILABLE == CSM_C_F_ON)
#ifdef CSM_CBR_SELF
// map the following definitions into csm_cbr.c to create instance variables
CSM_STATIC tCSM_CBR_CFG csm_arCbrCfg[CSM_CBR_MAX_USER] =
{
  {
    CSM_C_CAN_BUS_VCAN,                     // BYTE bBus
    CSM_C_PTYPE_DC_BR_SIGNAL,               // DWORD dwProtocolType
    {
      CSM_C_ADDRESS_FIELD_INF4CV_BR_VCAN,        // BYTE au8AddressField[2]
      CSM_C_ADDRESS_FIELD_INF4CV_BR_UNDEF
    },
    CSM_C_APPL_ID_RN_BR_VCAN,                // WORD wApplId
  },
    {
    CSM_C_CAN_BUS_MCAN,                     // BYTE bBus
    CSM_C_PTYPE_DC_BR_SIGNAL,               // DWORD dwProtocolType
    {
      CSM_C_ADDRESS_FIELD_INF4CV_BR_MCAN,        // BYTE au8AddressField[2]
      CSM_C_ADDRESS_FIELD_INF4CV_BR_UNDEF
    },
    CSM_C_APPL_ID_RN_BR_MCAN,                // WORD wApplId
  },
};
#endif // CSM_CBR_SELF
#endif // CSM_S_CBR_AVAILABLE == CSM_C_F_ON

//******************************************************************************
//* function prototypes (scope: cnp_itp module local)
//******************************************************************************
// --none--

#else
  #error CSM_CBR_MP.H included several times
#endif

/*******************************************************************************
 * \doxydocu
 * \file          csm_cbr_mp.h
 * \brief         Project specific part of the module internal header(s) of
 *                CSM_CBR
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       main latest
 * \path          /di_can/modules_swa/csm/src/
 *
 * \ingroup       CSM
 * \ingroup       CSM_CBR
 *
 * \authors       Borck
 *
 * COPYRIGHT      (c) 2015 CM-AI
 *
 * \history_begin
 * 06.03.15  \main\1  Borck
 * - Initial revision.
 *
 * 10.03.15  \main\rn_aivi\1  Borck
 * - csm_arCbrCfg[] moved here from csm_stack_mp.h
 *
 * 21.04.15  \main\rn_aivi\2  Borck
 * - made tCSM_CBR_CFG csm_arCbrCfg ==> CSM_STATIC
 *
 * 24.11.17  main\g3inf4cv_csm_proxy_in\1  Jayashree
 * - Modified protocoltypes as per INF4CV
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
