/* Description and history of csm_cbr_m.h at the end of the file.             */
#ifndef CSM_CBR_M_HEADER
/** File name for preprozessor commands */
#define CSM_CBR_M_HEADER

#include "csm_cbr_mp.h"                      // include project specific part
/* No further includes allowed */

/*******************************************************************************
 * defines and macros (scope: csm module local)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * typedefs (scope: csm module local)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition (scope: csm module local)
 ******************************************************************************/
extern BOOL CSM_CBR_afFnlWake[ CSM_C_MAX_CAN_BUS];

/*******************************************************************************
 * function prototypes (scope: csm module local)
 ******************************************************************************/
LONG CSM_CBR_lExit( const BYTE bExitMode );
LONG CSM_CBR_lInit( BYTE bInitMode);
LONG CSM_CBR_lCommunicationReq( BYTE  bBus,
                                DWORD dwProtocolType,
                                const void* pvAddressField,
                                BYTE  bAction,
                                WORD wApplID);
BOOL CSM_CBR_fCheckCommunicationReq( BYTE bBus);

VOID CSM_CBR_vCSMBusStateInd( BYTE bBus,
                              BYTE bCsmActState
                              #if (CSM_S_VIRTUAL_NETWORK == CSM_C_F_ON)
                                ,BYTE bVN
                              #endif /* CSM_S_VIRTUAL_NETWORK */
                              );

LONG CSM_CBR_lGetCommunicationState( BYTE  bBus,
                                     DWORD dwProtocolType,
                                     const void* pvAddressField,
                                     BYTE* pbConnectState,
                                     WORD  wApplId);

#if (CSM_S_VIRTUAL_NETWORK == CSM_C_F_ON)
  BYTE CSM_CBR_bQueryRequestedVNs(BYTE bBus);
#endif /* CSM_S_VIRTUAL_NETWORK */

void CSM_CBR_vSendAllIndicationsAgain( void);

#else /* CSM_CBR_M_HEADER already defined */
 #error CSM_CBR_M.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          csm_cbr_m.h
 * \brief         Module internal header of CAN stack manager broadcast server
 *                module.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       ???
 * \path          /di_can/modules_swa/cda/src/
 *
 * \ingroup       CSM
 * \ingroup       CSM_CBR
 *
 * \authors       CM-DI/ESA3-Name
 *
 * COPYRIGHT      (c) 2004 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 01.01.04  main\1 CM-DI/ESA3-Name
 * - Initial revision.
 *
 * 09.03.05  \main\2 CM-DI/ESA3-Prhl
 * - move broadcast communication request to csm_cbr.c
 *
 * 19.09.05  \main\3 CM-DI/ESA3-Prhl
 * - add CSM_CBR_lCommunicationReq() and CSM_CBR_fCheckCommunicationReq()
 *
 * 14.06.06  \main\4 CM-DI/ESA3-Prhl
 * - add CSM_CBR_vCSMBusStateInd()
 *
 * 22.08.06  \main\5 CM-DI/ESA3-Prhl
 * - add CSM_CBR_lGetCommunicationState()
 *
 * 10.10.06  \main\6 CM-DI/ESA3-Zurmhl
 * - PVOID replaced by void* (because of const PVOID confusion!)
 * - const modifier removed in CSM_CBR_vCSMBusStateInd() declaration
 *
 * 15.03.07  \main\7  VTeam-Prhl
 * - FNL code added
 * 19.07.07  \main\8  VTeam-Brunotte
 * - CSM_CBR_lExit declaration added
 * 26.08.08  \main\9  VTeam-Brunotte
 * - "extern" removed in function declarations
 *
 * 17.08.09  \main\10 CM-DI/VTeam Franke
 * - new: CSM_CBR_vEndCommunicationRequests
 *
 * 23.09.09  \main\11 CM-DI/VTeam Franke
 * - CSM_CBR_vEndCommunicationRequests removed
 *
 * 28.10.09  \main\11  CM-DI/VTeam Khler
 * - Prototype CSM_CBR_bQueryRequestedVNs() added.
 * - Indentation changed.
 *
 * 22.10.13  \main\12  Prhl
 * - Prototype CSM_CBR_vSendAllIncicationsAgain() added.
 *
 * 24.10.13  \main\13  Pistoor
 * - Renamed CSM_CBR_vSendAllIncicationsAgain() to CSM_CBR_vSendAllIndicationsAgain().
 *
 * 10.03.15  \main\14  Borck
 * - enabled project specific module include file (csm_cbr_mp.h)
 *   -> to reduce size and complexity of csm_stack_mp.h
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
