/* Description and history of csm_cbr_c.h at the end of the file.             */
#ifndef CSM_CBR_C_HEADER
/** File name for preprozessor commands */
#define CSM_CBR_C_HEADER

/*******************************************************************************
 * includes:  no includes allowed
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * defines and macros (scope: local)
 ******************************************************************************/
#ifdef CSM_C_IND_REASON_CBR_COMMUNICATION_CON
#define CSM_M_SET_COMM_CONF_STAT_1(ApplID)        csm_dwCommConf_Stat1 |= (1 << ApplID);
#define CSM_M_CLR_COMM_CONF_STAT_1(ApplID)        csm_dwCommConf_Stat1 &= ~(1 << ApplID);
#define CSM_M_SET_COMM_CONF_REQ_1(ApplID)         csm_dwCommConf_Req1 |= (1 << ApplID);
#define CSM_M_CLR_COMM_CONF_REQ_1(ApplID)         {INT iIsrStat = CSM_iInterruptsDisable();           /* disable interrupts      */\
                                                   csm_dwCommConf_Req1 &= ~(1 << ApplID);\
                                                   CSM_vInterruptsRestore(iIsrStat);}                  /* enable interrupts again */
#define CSM_M_IS_COMM_CONF_REQ_1_SET(ApplID)      (csm_dwCommConf_Req1 & (0x01U << ApplID))
#else
#define CSM_M_SET_COMM_CONF_STAT_1(ApplID)
#define CSM_M_CLR_COMM_CONF_STAT_1(ApplID)
#define CSM_M_SET_COMM_CONF_REQ_1(ApplID)
#define CSM_M_CLR_COMM_CONF_REQ_1(ApplID)
#endif

#ifdef CSM_C_IND_REASON_CBR_NACHLAUF_CON
#define CSM_M_SET_NACHLAUF_CONF_REQ_1(ApplID)     csm_dwNachlauf_Req1 |= (1 << ApplID);
#define CSM_M_CLR_NACHLAUF_CONF_REQ_1(ApplID)     {INT iIsrStat = CSM_iInterruptsDisable();           /* disable interrupts      */\
                                                   csm_dwNachlauf_Req1 &= ~(1 << ApplID);\
                                                   CSM_vInterruptsRestore(iIsrStat);}                  /* enable interrupts again */
#define CSM_M_IS_NACHLAUF_CONF_REQ_1_SET(ApplID)  (csm_dwNachlauf_Req1 & (0x01U << ApplID))
#else
#define CSM_M_SET_NACHLAUF_CONF_REQ_1(ApplID)
#define CSM_M_CLR_NACHLAUF_CONF_REQ_1(ApplID)
#endif


/*******************************************************************************
 * typedefs (scope: )
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition (scope: )
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: Broadcast server callback functions of the
 *                             can stack manager)
 ******************************************************************************/
VOID CSM_CBR_vProcessCommunicationCon( VOID);
VOID CSM_CBR_vProcessCommunicationInd( VOID);
VOID CSM_CBR_vProcessCommunicationReq( VOID);
VOID CSM_CBR_vProcessNachlaufCon(VOID);

void CSM_CBR_vPROXYCommunicationInd(BYTE bUserNumber, BYTE bAction);
void CSM_CBR_vPROXYCommunicationCon(BYTE bUserNumber, BYTE bAction);

BYTE CSM_CBR_bGetUserAssignedBus(BYTE bUserNumber);
BYTE CSM_CBR_bGetUserNumber(BYTE bBus, DWORD dwProtocolType, const void * pvAddressField, WORD wApplId);

void CSM_CBR_vFnlWaitTimeout( DWORD);
void CSM_CBR_vFnlAliveTimeout( DWORD);

#else // CSM_CBR_C_HEADER
  #error CSM_CBR_C.H included several times
#endif

/*******************************************************************************
 * \doxydocu
 * \file          csm_cbr_c.h
 * \brief         Broadcast server callback functions of the can stack manager.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool Code
 * \path          /di_can/modules_swa/cda/src/
 *
 * \ingroup       CSM
 * \ingroup       CSM_CBR
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2004 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 28.09.05  \main\2 CM-DI/ESA3-Battis
 * - First version after VW merge
 *   USE WITH CAUTION !
 *
 * 29.05.06  \main\3 CM-DI/ESA3-Prhl
 * - add missing functions to remove warnings
 *
 * 28.06.06  \main\4 CM-CR/ESD4-Tuschik
 * - IND_REASON names corrected
 * - prototype of CBR_vProcessNachlaufCon() added
 *
 * 29.06.06  \main\5 CM-DI/ESA3-Battis
 * - CBR_vProcessNachlaufCon() renamed to CSM_CBR_vProcessNachlaufCon()
 *
 * 15.03.07  \main\6  VTeam-Prhl
 * - FNL code added
 *
 * 22.03.07  \main\7  VTeam-Prhl
 * - compiler warning removed (type changed)
 *
 * 15.05.07  \main\8  CM-DI/VTeam-Prhl
 * - spaces after # deleted
 *
 * 19.12.13  \main\9  CM-DI/VTeam-Pistoor
 * - added function declarations CSM_CBR_vPROXYCommunicationInd()
 *   and CSM_CBR_vPROXYCommunicationCon()
 *
 * 21.04.15  \main\10 Borck
 * - prototype for CSM_CBR_bGetUserAssignedBus() added to fix an access issue in csm_proxy.c
 *
 * 23.07.15  \main\11 Borck
 * - 1 more prototype added for export
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
