/* Description and history of csm_c.h at the end of the file.                 */
#ifndef CSM_C_HEADER
/** File name for preprozessor commands */
#define CSM_C_HEADER

/*******************************************************************************
 * includes:  no includes allowed
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * defines and macros (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * typedefs (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition/declaration (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: CAN stack and operating system)
 ******************************************************************************/

#if (CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
  #if (CSM_S_CNM_STATE_CHANGE_IND == CSM_C_F_ON)
    VOID CSM_vCNM_StateChangeInd(BYTE bBus, BYTE bNMState);
  #endif /* CSM_S_CNM_STATE_CHANGE_IND */

  #if (CSM_S_LAST_NM_MSG == CSM_C_F_ON)
    VOID CSM_vCNMLastNmMsg(BYTE bBus);
  #endif /* CSM_S_LAST_NM_MSG */
#endif /* CSM_S_CNM_AVAILABLE */

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
  #if ( CSM_S_VW_TP_2_0 == CSM_C_F_ON )
    void CSM_VW_vCNP_VW20_ConnectInd(BYTE bConNr, BYTE bConState);
    void CSM_VW_vCNP_VW20_ConnectConf(BYTE bConNr, BYTE bConState);
    void CSM_VW_vCNP_VW20_DataInd(BYTE bConNr);
    void CSM_VW_vCNP_VW20_DataConf(BYTE bConNr, BYTE bTransferResult);
  #endif /* if ( CSM_S_VW_TP_2_0 == CSM_C_F_ON ) */

  #if ( CSM_S_VW_TP_1_6 == CSM_C_F_ON )
    void CSM_VW_vCNP_VW16_ConnectInd(BYTE bConNr, BYTE bConState);
    void CSM_VW_vCNP_VW16_ConnectConf(BYTE bConNr, BYTE bConState);
    void CSM_VW_vCNP_VW16_DataInd(BYTE bConNr);
    void CSM_VW_vCNP_VW16_DataConf(BYTE bConNr, BYTE bTransferResult);
  #endif /* if ( CSM_S_VW_TP_1_6 == CSM_C_F_ON ) */

  #if (CSM_S_MCNET == CSM_C_F_ON)
    VOID  CSM_MCNET_vCNP_ConnectCon (BYTE bConNumber,
                                     BYTE bConStatus,
                                     BYTE bBlockSize,
                                     BYTE bServiceMode);

    VOID  CSM_MCNET_vCNP_ConnectInd ( BYTE bConNumber,
                                      BYTE bConStatus,
                                      BYTE bBlockSize,
                                      BYTE bServiceMode,
                                      BYTE bReason);

    #if (CSM_S_MCNET_ASDT == CSM_C_F_ON)
      VOID  CSM_MCNET_vCNP_ASDTDataCon (BYTE bServiceType,
                                        BYTE bConNumber,
                                        BYTE bTransferResult);

      VOID  CSM_MCNET_vCNP_ASDTDataInd (BYTE bServiceType,
                                        BYTE bConNumber,
                                        PBYTE pbData,
                                        WORD wDataLength);
    #endif /* CSM_S_MCNET_ASDT */



    #if (CSM_S_MCNET_USDT_TX == CSM_C_F_ON)
      VOID  CSM_MCNET_vCNP_USDTDataCon (BYTE bUsdtTxChannel, BYTE bTransferResult);
    #endif /* CSM_S_MCNET_USDT_TX */

    #if (CSM_S_MCNET_USDT_RX == CSM_C_F_ON)
      VOID  CSM_MCNET_vCNP_USDTDataInd (BYTE bUsdtRxChannel, PBYTE pbData, WORD wDataLength);
    #endif /* CSM_S_MCNET_USDT_RX */

    VOID  CSM_MCNET_vCNP_USDTErrorInd (BYTE bUsdtRxChannel, BYTE bErrorType);

    VOID  CSM_MCNET_vCNM_WDMonitorInd (BYTE bSlaveNmIdx, BYTE bWdMonState);

    VOID  CSM_MCNET_vCNP_ConTestCon (BYTE bConNumber, BYTE bConStatus,
                                     BYTE bBlockSize, BYTE bServiceMode);
#endif /* CSM_S_MCNET active */


#if (CSM_S_ISO_TP == CSM_C_F_ON)
  #if (CSM_S_REMOTE_STACK == CSM_C_F_OFF)
    // we are building a CSM system with CNP_ITP present
    VOID CSM_ITP_vCNPDataInd (BYTE bIsoTpChannel, PBYTE pbData, WORD wDataLength);
    VOID CSM_ITP_vCNPDataCon (BYTE bIsoTpChannel, BYTE bTransferResult);
    #if (CSM_S_ITP_FF_INDICATION_AVAILABLE == CSM_C_F_ON)
    VOID CSM_ITP_vCNPDataIndFF( BYTE bIsoTpChannel );
    #endif
    #if (CSM_S_ITP_ERROR_INDICATION_AVAILABLE == CSM_C_F_ON)
    VOID CSM_ITP_vCNPDataErrorInd( BYTE bIsoTpChannel );
    #endif

    #if (CSM_S_ITP_ASDT_EXTENSIONS == CSM_C_F_ON)
    #if (CSM_S_ITP_ASDT_EXTENSION_RENAULT == CSM_C_F_ON)
    VOID CSM_ITP_vCNPRnASDTConnectCon(BYTE bConNumber, BYTE bConStatus);
    VOID CSM_ITP_vCNPRnASDTConnectInd(BYTE bConNumber, BYTE bConStatus);
    VOID CSM_ITP_vRnASDTForceDisconnect(VOID);
    VOID csm_itp_vRN_ASDT_HighLevelRetry(BYTE bIsoTpChannel, BYTE bTransferResult);
    VOID csm_itp_vHLRetryTLBTimer(VOID);
    VOID CSM_ITP_vCNPNMLimpHome(VOID);

    /* (Project specific?) timer functions for Renault. Should be placed in another file, e.g. csm_stack_mp.h
    VOID CSM_itp_vLowLevelTimerNasDiag(VOID);
    VOID CSM_itp_vLowLevelTimerNarDiag(VOID);
    VOID CSM_itp_vLowLevelTimerNasScreen(VOID);
    VOID CSM_itp_vLowLevelTimerNarScreen(VOID);
    VOID CSM_itp_vLowLevelTimerNasAmp(VOID);
    VOID CSM_itp_vLowLevelTimerNarAmp(VOID);
    VOID CSM_itp_vLowLevelTimerNasCbox(VOID);
    VOID CSM_itp_vLowLevelTimerNarCbox(VOID);
    */
    #endif // CSM_S_ITP_ASDT_EXTENSION_RENAULT == CSM_C_F_ON
    #endif // CSM_S_ITP_ASDT_EXTENSIONS enabled

    #if (CSM_S_DEBUG == CSM_C_F_ON)
    VOID  CSM_ITP_vCNPErrorInd (BYTE bIsoTpChannel, BYTE bError);
    #else
    #define CSM_ITP_vCNPErrorInd(a,b)   // function not available
    #endif
  #endif // local stack with CNP_ITP

  #if (CSM_S_REMOTE_STACK == CSM_C_F_ON)
  // we are building a proxy CSM system, so no CNP_ITP module will be present
  void CSM_ITP_vPROXYDataInd(BYTE bIsoTpChannel, const VOID * const pbBuffer, WORD wDataLength);
  void CSM_ITP_vPROXYDataCon(BYTE bIsoTpChannel, BYTE bTransferResult);
  #endif // remote stack (proxy system without cnp_itp)
#endif // CSM_S_ISO_TP

#if ( CSM_S_CSM_VW == CSM_C_F_ON )
  void CSM_VW_vCDABusOff(void);
  void CSM_VW_vCDAResetBusOff(void);
#endif

#endif /* CSM_S_CNP_AVAILABLE */

VOID CSM_vCDAErrorInd(BYTE bBus, BYTE bErrorType, DWORD dwNumberOfRepeatedBusoff);

VOID CSM_vCDAWakeupInd(BYTE bBus);

/* VK 27.09.2010: functions correct in this file? Callback from where to CAN stack manager? */
VOID CSM_vTransmitConfirmation(BYTE bHandle);
VOID CSM_vActivateCANReceiveTask(VOID);

#if (CSM_S_RX_OVERRUN_INDICATION == CSM_C_F_ON)
  VOID CSM_vRxOverrunOccured(BYTE bBus);
#endif /* CSM_S_ENABLE_RX_OVERRUN_INDICATION */

void CSM_vCNMBusoffReinitTimerExpired( DWORD dwTimerValue);

void CSM_vCNMBusoffReinit(BYTE bBus);

#if (CSM_S_BUS_WAKE_TEMP == CSM_C_F_ON)
  extern void csm_vWakeTempTimeout( DWORD dwDummy);
#endif

#if (CSM_S_BUS_WAKE_MIN == CSM_C_F_ON)
  extern void csm_vWakeMinTimeout( DWORD dwDummy);
#endif

#if (CSM_S_VIRTUAL_NETWORK == CSM_C_F_ON)
  extern VOID CSM_CBR_vCSMBusStateReInitInd(BYTE bBus, BYTE bVN );
#endif /* CSM_S_VIRTUAL_NETWORK */


#else
  #error CSM_C.H included several times
#endif

/*******************************************************************************
 * \doxydocu
 * \file          csm_c.h
 * \brief         CAN stack manager header file for callback function
 *                declarations.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/csm/src/
 *
 * \ingroup       CSM
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2004 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 10.03.04  Rev. main\3  CM-DI/ESU3-K"ohler
 * - CSM_vCDAWakeup() renamed CSM_vCDAWakeupInd().
 *
 * 27.07.04 \main\4 CM-DI/ESU3-Battis
 * - bugfix for version \main\3
 *
 * 30.09.04 \main\5 CM-DI/ESA3-Battis
 * - CSM_vCNMBusoffReinit() added
 *
 * 18.10.04  Rev. main\6  CM-DI/ESA3-K"ohler
 * - Pointer to struct CSM_CAN_RX_DATA as parameter instead of four pointer/
 *   values for function CSM_vCNPApplTel_DataInd().
 * - Doxygen comments added.
 *
 * 18.10.04  Rev. main\7  CM-DI/ESA3-K"ohler
 * - Some coments corrected.
 *
 * 22.11.04  Rev. main\8  CM-DI/ESA3-Battis
 * - old CBR callback functions removed
 *
 * 25.01.05  Rev. main\9  CM-DI/ESA3-K"ohler
 * - New naming convention for ISO-TP functions.
 * - Parameter bBus for CSM_ITP_vCNPDataInd(), CSM_ITP_vCNPDataCon() and
 *   CSM_ITP_vCNPErrorInd() removed.
 *
 * 03.02.05  Rev. main\10  CM-DI/ESA3-Battis
 * - timer function renamed
 *
 * 17.02.05  main\11  CM-DI/ESA3-Prhl
 * - type for CSM_vCNMBusoffReinitTimerExpired() changed
 *
 * 09.03.05  main\12  CM-DI/ESA3-Prhl
 * - csm_vWakeTempTimeout() added
 *
 * 04.04.05  main\13  CM-CR/ESD4-Tuschik
 * - Add VW-features.
 *
 * 09.05.05  main\14  CM-DI/ESA3-Battis
 * - changes to make MISRA happy
 *
 * 14.06.05  main\15  CM-DI/ESA3-K"ohler
 * - Parameter of CSM_vCNPApplTel_DataInd() changed to const.
 *
 * 30.06.06  main\16  CM-DI/ESA3-Looby
 * - Added function Prototypes.
 *
 * 16.01.07  main\17  CM-DI/ESA3-Looby
 * - Added function Prototypes for Renault R2 08.
 *
 * 17.01.07  main\18  CM-DI/ESA3-Looby
 * - Removed unneeded function Prototypes for Renault R2 08.
 *
 * 02.03.07  main\19  CM-DI/ESA3-Looby
 * - Added function Prototypes for Renault R2 08.
 *
 * 15.03.07  main\20  VTeam-Prhl
 * - BUS_WAKE_MIN feature added
 *
 * 21.03.07  main\21  VTeam-Battis
 * - feature usage switch corrected.
 *
 * 22.03.07  main\22  VTeam-Prhl
 * - old OPEL feature switch removed
 *
 * 10.07.07 main\23 VTeam Brunotte
 * - CSM_CBR_vCSMBusStateReInitInd declaration added
 *
 * 11.07.07  main\24  CM-DI/ESA3-Looby
 * - Added function Prototypes for Renault R2 08.
 *
 * 31.07.07  main\25  VTeam-Prhl
 * - lint warnings removed or commented out.
 *
 * 26.11.07  main\26  VTeam-Khler
 * - CSM_S_ENABLE_RX_OVERRUN_INDICATION replaced by
 *   CSM_S_ENABLE_RX_OVERRUN_INDICATION.
 *
 * 24.01.08  main\27  VTeam-Zurmhl
 * - module history comment block revised (doxygen tag \ingroup)
 *
 * 16.07.08  main\28  VTeam-Zurmhl
 * - Obsolete parameter bBus deleted in CSM_MCNET_vCNP_ASDTDataInd
 *
 * 21.11.08  main\29  VTeam-Pistoor
 * - Added CSM_ITP_vCNPDataIndFF()
 * - Added CSM_ITP_vCNPDataErrorInd()
 *
 * 27.09.10  main\30  VTeam-Khler
 * - Project specific functions commented out, indentation changed.
 *
 * 31.05.17  main\31  A.Borck
 * - ISO-TP section adapted, so that CSM proxy systems do not need the CNP_ITP module
 * - if using this updated file version in a proxy system with ISO TP enabled, check RENAULT/NISSAN implementation of CSM_ITP to get rid of the CNP_ITP module, which is not needed
 * - another solution could be to branch this file and add the required CNP prototype declarations in ISO-TP section under the feature REMOTE_STACK == ON
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
