// Description and history of csm_apl.c at the end of the file.
// File name for preprozessor commands
#define CSM_APL_SELF

// csm_apl.c is a file according V-team CAN-SW architecture implementation rules.
// Often no "CSM_CAN_STACK file IF" system includes are necessary.
#define CSM_CAN_STACK

//*******************************************************************************
//* includes:
//*******************************************************************************
// put required defines for include files here

//*************** Environment includes if necessary ***************
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

//*************** CSM and stack includes **************************
#include "csm_stack_i.h"
#include "csm_i.h"
#include "cnm_oseki_m.h"     // Typedefs used in next header
#include "csm_stack_m.h"
#include "csm_m.h"           // Prototype of CSM_lInitApl()
#include "csm_apl.h"



//************** further includes *********************************
//************** ETG Tracing **********************
#if (CSM_S_TRACE == CSM_C_F_ON)
  #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
  #define ETRACE_S_IMPORT_INTERFACE_GENERIC
  #include "etrace_if.h"

  #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
    #include "csm_etg_trace.h"
    #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FD_CSM
    // #define ETG_INLINE
    #include "trcGenProj/Header/csm_apl.c.trc.h"
  #endif
  #endif
#endif // CSM_S_TRACE

#ifndef CSM_S_SLOT_BASED_CONFIG
  #error "CSM_S_SLOT_BASED_CONFIG must be set to CSM_C_F_ON or -OFF !"
#endif

#ifndef CSM_S_iMX_SIGNAL_ABSTRACTION
  #error "CSM_S_iMX_SIGNAL_ABSTRACTION must be set to CSM_C_F_ON or -OFF !"
#endif

/* currently not needed
#ifndef CSM_S_RUNTIME_FEATURE_BASED_CONFIG
  #error "CSM_S_RUNTIME_FEATURE_BASED_CONFIG must be set to CSM_C_F_ON or -OFF !"
#endif
*/

//******************************************************************************
//* defines and macros (scope: file local)
//******************************************************************************
// -- none --

//******************************************************************************
//* typedefs (scope: file local)
//******************************************************************************
//-- none --

//******************************************************************************
//* variable definition (scope: file local)
//******************************************************************************
// configuration slots
#if (CSM_S_VARIANTS_MANAGEMENT == CSM_C_F_ON)
#if (CSM_S_SLOT_BASED_CONFIG == CSM_C_F_ON)
// The SLOT 0 declarations are already required here, if a SLOT based configuration is used.
extern const CSM_CBR_RX             csm_arCbrRxTelegram_Slot0[];
extern const CSM_CBR_TX             csm_arCbrTxTelegram_Slot0[];
extern const CSM_CBR_RX             csm_arCbrRxTelegram_Slot1[];
extern const CSM_CBR_TX             csm_arCbrTxTelegram_Slot1[];
extern const CSM_CBR_RX             csm_arCbrRxTelegram_Slot2[];
extern const CSM_CBR_TX             csm_arCbrTxTelegram_Slot2[];
extern const CSM_CBR_RX             csm_arCbrRxTelegram_Slot3[];
extern const CSM_CBR_TX             csm_arCbrTxTelegram_Slot3[];
extern const CSM_CBR_RX             csm_arCbrRxTelegram_Slot4[];
extern const CSM_CBR_TX             csm_arCbrTxTelegram_Slot4[];
extern const CSM_CBR_RX             csm_arCbrRxTelegram_Slot5[];
extern const CSM_CBR_TX             csm_arCbrTxTelegram_Slot5[];
extern const CSM_CBR_RX             csm_arCbrRxTelegram_Slot6[];
extern const CSM_CBR_TX             csm_arCbrTxTelegram_Slot6[];
extern const CSM_CBR_RX             csm_arCbrRxTelegram_Slot7[];
extern const CSM_CBR_TX             csm_arCbrTxTelegram_Slot7[];
extern const CSM_CBR_RX             csm_arCbrRxTelegram_Slot8[];
extern const CSM_CBR_TX             csm_arCbrTxTelegram_Slot8[];
extern const CSM_CBR_RX             csm_arCbrRxTelegram_Slot9[];
extern const CSM_CBR_TX             csm_arCbrTxTelegram_Slot9[];

extern const CSM_TELEGRAM *   const cbr_arRxTelegramIndex_Slot0[];
extern const CSM_TELEGRAM *   const cbr_arTxTelegramIndex_Slot0[];
extern const CSM_TELEGRAM *   const cbr_arRxTelegramIndex_Slot1[];
extern const CSM_TELEGRAM *   const cbr_arTxTelegramIndex_Slot1[];
extern const CSM_TELEGRAM *   const cbr_arRxTelegramIndex_Slot2[];
extern const CSM_TELEGRAM *   const cbr_arTxTelegramIndex_Slot2[];
extern const CSM_TELEGRAM *   const cbr_arRxTelegramIndex_Slot3[];
extern const CSM_TELEGRAM *   const cbr_arTxTelegramIndex_Slot3[];
extern const CSM_TELEGRAM *   const cbr_arRxTelegramIndex_Slot4[];
extern const CSM_TELEGRAM *   const cbr_arTxTelegramIndex_Slot4[];
extern const CSM_TELEGRAM *   const cbr_arRxTelegramIndex_Slot5[];
extern const CSM_TELEGRAM *   const cbr_arTxTelegramIndex_Slot5[];
extern const CSM_TELEGRAM *   const cbr_arRxTelegramIndex_Slot6[];
extern const CSM_TELEGRAM *   const cbr_arTxTelegramIndex_Slot6[];
extern const CSM_TELEGRAM *   const cbr_arRxTelegramIndex_Slot7[];
extern const CSM_TELEGRAM *   const cbr_arTxTelegramIndex_Slot7[];
extern const CSM_TELEGRAM *   const cbr_arRxTelegramIndex_Slot8[];
extern const CSM_TELEGRAM *   const cbr_arTxTelegramIndex_Slot8[];
extern const CSM_TELEGRAM *   const cbr_arRxTelegramIndex_Slot9[];
extern const CSM_TELEGRAM *   const cbr_arTxTelegramIndex_Slot9[];

extern const CNM_OSEKI_tBusConfig   CNM_OSEKI_arBusConfig_Slot0[];
extern const CNM_OSEKI_tBusConfig   CNM_OSEKI_arBusConfig_Slot1[];
extern const CNM_OSEKI_tBusConfig   CNM_OSEKI_arBusConfig_Slot2[];
extern const CNM_OSEKI_tBusConfig   CNM_OSEKI_arBusConfig_Slot3[];
extern const CNM_OSEKI_tBusConfig   CNM_OSEKI_arBusConfig_Slot4[];
extern const CNM_OSEKI_tBusConfig   CNM_OSEKI_arBusConfig_Slot5[];
extern const CNM_OSEKI_tBusConfig   CNM_OSEKI_arBusConfig_Slot6[];
extern const CNM_OSEKI_tBusConfig   CNM_OSEKI_arBusConfig_Slot7[];
extern const CNM_OSEKI_tBusConfig   CNM_OSEKI_arBusConfig_Slot8[];
extern const CNM_OSEKI_tBusConfig   CNM_OSEKI_arBusConfig_Slot9[];

// definition of a SLOT configuration
tCSM_SLOT_CONFIG CSM_APL_SLOT_CONFIG[CSM_APL_MAX_CONFIG_SLOTS][CSM_C_MAX_CAN_BUS] =
{
  {
    // SLOT 0 Bus 0 (VCAN)
    {
      NULL,                                                                      // no HW objects (message box) required
      NULL,                                                                      // CDA related, not required
      & csm_arCbrRxTelegram_Slot0[0],                                            // RX telegram descriptor table
      & cbr_arRxTelegramIndex_Slot0[0],                                          // pointer table to RX descriptors
      & csm_arCbrTxTelegram_Slot0[0],                                            // TX telegram descriptor table
      & cbr_arTxTelegramIndex_Slot0[0],                                          // pointer table to TX descriptors

      CBR_RX_MAX_NUMBER_SLOT0,                                                   // generated define
      CBR_TX_MAX_NUMBER_SLOT0,                                                   // generated define

      #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
      CNM_OSEKI_arBusConfig_Slot0,                                               // this referenced struct contains both busses
      #endif

      #if (CSM_S_CBR_MSG_ROLL_COUNTER == CSM_C_F_ON)
      NULL,                                                                      // CBR TX related on v850 site
      #endif

      #if (CSM_S_CDA_GATEWAY == CSM_C_F_ON)
      NULL,
      #endif
    },
    // SLOT 0 Bus 1 (MCAN)
    {
      NULL,                                                                      // no HW objects (message box) required
      NULL,                                                                      // CDA related, not required
      NULL,                                                                      // MCAN has no RX Telegramm Descriptor Table
      NULL,                                                                      // MCAN has no RX Signal Descriptor Table
      NULL,                                                                      // MCAN has no TX Telegramm Descriptor Table
      NULL,                                                                      // MCAN has no TX Signal Descriptor Table

      CBR_RX_MAX_NUMBER_SLOT0,                                                   // dummy, not used
      CBR_TX_MAX_NUMBER_SLOT0,                                                   // dummy, not used

      #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
      CNM_OSEKI_arBusConfig_Slot0,                                               // this referenced struct contains both busses
      #endif

      #if (CSM_S_CBR_MSG_ROLL_COUNTER == CSM_C_F_ON)
      NULL,                                                                      // MCAN has no TX Rolling counter
      #endif

      #if (CSM_S_CDA_GATEWAY == CSM_C_F_ON)
      NULL,
      #endif
    }
}

};
#endif // CSM_S_SLOT_BASED_CONFIG
#endif // CSM_S_VARIANTS_MANAGEMENT

//******************************************************************************
//* variable definition (scope: CAN stack)
//******************************************************************************
// declarations for Variant management
extern const CSM_CBR_RX   * csm_arCbrRxTelegram;
extern const CSM_CBR_TX   * csm_arCbrTxTelegram;
extern const CSM_TELEGRAM * const * cbr_arRxTelegramIndex;
extern const CSM_TELEGRAM * const * cbr_arTxTelegramIndex;

// these variables are mapped by the used #defines CBR_RX_MAX_NUMBER, CBR_TX_MAX_NUMBER
extern BYTE  bCbrRxMaxNumber;
extern BYTE  bCbrTxMaxNumber;

//******************************************************************************
//* function prototypes (scope: global)
//******************************************************************************
// required prototype, if slot value is to be read from KDS (late CSM variant)
DWORD CSM_APL_dwGetKDSValue(BYTE* pTarget, BYTE bItem, DWORD* dwError);
// new prototype, if slot value is to be read from NOR flash (early CSM variant)
BYTE CSM_Proc_vGetDatapoolEarlyNorItem(BYTE* pTarget, BYTE bItem);

//******************************************************************************
//* constants (scope: file local)
//******************************************************************************
//-- none --


// Feature switch is used only to control doxygen documentation
#if (CSM_S_DOXYGEN_HIDE_NON_API_FCT == CSM_C_F_OFF)
//******************************************************************************
//* function implementation (scope: file local = static)
//******************************************************************************
//-- none --

//******************************************************************************
//* function implementation (scope: CAN stack and operating system)
//******************************************************************************

/*******************************************************************************
 * function    CSM_lInitApl
 * \doxydocu
 * \brief      Initialize the CAN stack application module.
 *
 * \see        CAN-SW Architecture, written by CM-DI/ESA3
 *
 * \param[in]  bInitMode
 *               CSM_C_INIT_COLD, CSM_C_INIT_WARM, CSM_C_INIT_START
 *
 * \return     Error value.
 *
 * \access     init
 * \reentrant  no
 *
 * \lastreview 01.07.08 VTeam-Zurmhl
 *
 * \history_begin
 * 14.01.04 CM-DI/ESU3-Prhl
 * Initial Revision.
 * \history_end
 ******************************************************************************/
LONG CSM_lInitApl(BYTE bInitMode)
{
  LONG lReturnValue = CSM_C_NO_ERROR;

  switch ( bInitMode )
  {
    case CSM_C_INIT_COLD:
    {
    }
    break;

    case CSM_C_INIT_WARM:
    {
    }
    break;

    case CSM_C_INIT_START:
    {
    }
    break;

    default:
    {
      /* illegal init mode */
      lReturnValue = CSM_M_MAKE_CSM_ERROR(CSM_C_ERR_ERROR, CSM_E_INVALID_PARA);
      CSM_vAssert(FALSE);
      break;
    }
  } /* end switch (bInitMode)*/

  return( lReturnValue);
} /* end CSM_lInitApl() */


/*******************************************************************************
 * function    CSM_lExitApl
 * \doxydocu
 * \brief      Exit (switch to inactive)  CAN stack application module.
 *
 * \see        CAN-SW Architecture, written by CM-DI/ESA3
 *
 * \param[in]  bExitMode
  *               CSM_C_EXIT_STOP, CSM_C_EXIT_OFF
 *
 * \return     Error value.
 *
 * \access     init
 * \reentrant  no
 *
 * \lastreview 01.07.08 VTeam-Zurmhl
 *
 * \history_begin
 * 14.01.04 CM-DI/ESU3-Prhl
 * Initial Revision.
 * \history_end
 ******************************************************************************/
LONG CSM_lExitApl(BYTE bExitMode)
{
  LONG lReturnValue = CSM_C_NO_ERROR;

  switch (bExitMode)
  {
    case CSM_C_EXIT_STOP:
    {
      break;
    }

    case CSM_C_EXIT_OFF:
    {
      break;
    }

    default:
    {
      /* illegal exit mode */
      lReturnValue = CSM_M_MAKE_CSM_ERROR(CSM_C_ERR_ERROR, CSM_E_INVALID_PARA);
      CSM_vAssert(FALSE);
      break;
    }
  } /* end switch (bExitMode)*/

  return lReturnValue;
} /* end CSM_lExitApl() */

/*******************************************************************************
 * function    CSM_APL_lKernelTester
 * \doxydocu
 * \brief      Initialize the CAN stack upper tester module. To be able to receive
 *             commands from host a trace channel callback function is registered.
 *
 * \see        CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \param[in]  ac
 *               ???
 *
 * \param[in]  av
 *               ???
 *
 * \return     Error value.
 *
 * \access     init
 * \reentrant  no
 *
 * \history_begin
 * 19.05.11 Prhl
 * Initial Revision.
 * \history_end
 ******************************************************************************/
LONG CSM_APL_lKernelTester( INT ac, BYTE *av[])
{
  LONG lRet = CSM_C_NO_ERROR;

/* only dummy function */

  return( lRet);
} /* end CSM_APL_lKernelTester() *//*lint !e715 PQM_authorized_multi_122. Reason: Variable is a preset by interface, but not used intentionally*/

/*******************************************************************************
 * function    CSM_lInitVariants
 * \doxydocu
 * \brief      Initialize the CAN stack application module.
 *
 * \see        CAN-SW Architecture, written by CM-DI/ESA3
 *
 * \param[in]  bInitMode
 *               CSM_C_INIT_COLD, CSM_C_INIT_WARM, CSM_C_INIT_START
 *
 * \return     Error value.
 *
 * \access     init
 * \reentrant  no
 *
 * \lastreview
 *
 * \history_begin
 * 19.05.15 M. Prhl
 * Initial Revision.
 * \history_end
 ******************************************************************************/
#if (CSM_S_VARIANTS_MANAGEMENT == CSM_C_F_ON)
LONG CSM_lInitVariants(BYTE bInitMode)
{
  BYTE bSlot;
  BYTE bBus;

  switch (bInitMode)
  {
    case CSM_C_INIT_COLD:
    {
      bSlot = CSM_APL_bGetConfigurationSlotNr();   // source of Slot value retrieval is encapsulated in this function
      bBus  = CSM_C_CAN_BUS_VCAN;                  // currently the standard value for all handled configuration issues HERE

      #if (CSM_S_iMX_SIGNAL_ABSTRACTION == CSM_C_F_ON)
      CBR_AL_bInit((WORD) bSlot);
      #endif

      #if (CSM_S_SLOT_BASED_CONFIG == CSM_C_F_ON)
      bCbrRxMaxNumber = CSM_APL_SLOT_CONFIG[bSlot][CSM_C_CAN_BUS_VCAN].bCbrRxMax;
      bCbrTxMaxNumber = CSM_APL_SLOT_CONFIG[bSlot][CSM_C_CAN_BUS_VCAN].bCbrTxMax;
      #else
        #error "Without a SLOT based configuration the #defines CBR_RX_MAX_NUMBER and CBR_TX_MAX_NUMBER have to be used differently - please review and rework !!!"
      #endif

      // determine and set the RX configuration, dependent on the configured SLOT
      // attention: HW message boxes cfg is a different thing !!! (handled for example in cda_afcan.c, cda_fcn.c)
      #if (CSM_S_SLOT_BASED_CONFIG == CSM_C_F_ON)
        // since the RX is for CBR on VCAN that bus is set here directly (the SLOT is to be retrieved from NVM)
        csm_arCbrRxTelegram = CSM_APL_SLOT_CONFIG[bSlot][CSM_C_CAN_BUS_VCAN].pRxTelegramDescriptorTable;
        cbr_arRxTelegramIndex = CSM_APL_SLOT_CONFIG[bSlot][CSM_C_CAN_BUS_VCAN].pRxSignalDescriptorTable;
      #else
        // if NO SLOTS, then choose a default value
        csm_arCbrRxTelegram = csm_arCbrRxTelegram_Slot0;
        cbr_arRxTelegramIndex = cbr_arRxTelegramIndex_Slot0;
      #endif

      // determine and set the TX configuration, dependent on the configured SLOT
      #if (CSM_S_SLOT_BASED_CONFIG == CSM_C_F_ON)
        // since the TX is for CBR on VCAN that bus is set here directly (the SLOT is to be retrieved from NVM)
        csm_arCbrTxTelegram   = CSM_APL_SLOT_CONFIG[bSlot][CSM_C_CAN_BUS_VCAN].pTxTelegramDescriptorTable;
        cbr_arTxTelegramIndex = CSM_APL_SLOT_CONFIG[bSlot][CSM_C_CAN_BUS_VCAN].pTxSignalDescriptorTable;
      #else
        // if NO SLOTS, then choose a default value
        csm_arCbrTxTelegram   = csm_arCbrTxTelegram_Slot0;
        cbr_arTxTelegramIndex = cbr_arTxTelegramIndex_Slot0;
      #endif
    }
    break;

    case CSM_C_INIT_WARM:
    break;

    case CSM_C_INIT_START:
    break;

    default:
    // illegal init mode
    CSM_vAssert(0);
    break;
  }

  return (LONG) CSM_C_NO_ERROR;
}
#endif

#if (CSM_S_VARIANTS_MANAGEMENT == CSM_C_F_ON)
#if (CSM_S_SLOT_BASED_CONFIG == CSM_C_F_ON)
BYTE CSM_APL_bGetConfigurationSlotNr(void)
{
  BYTE bReturn;
  BYTE bEarlyNorSlot;

  // preset a default value
  BYTE bSlot = CSM_C_CAN_CONFIG_SLOT_0;

  // read EarlyNOR to get SLOT value (formerly read from KDS, now use NOR flash )
  bReturn = CSM_Proc_vGetDatapoolEarlyNorItem(&bEarlyNorSlot, CSM_APL_C_READ_EARLYNOR_SLOT);
  if (1 != bReturn)
  {
    #if (CSM_S_TRACE == CSM_C_F_ON)
      #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
        #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
        ETG_TRACE_FATAL(("CSM_APL_bGetConfigurationSlotNr: ERROR - Retrieval failed"));
        #endif
      #endif
    #endif
  }
  else
  {
    // 1 means succefully read from EarlyNor
    if (bEarlyNorSlot < CSM_APL_MAX_CONFIG_SLOTS)
    {
      // assign value
      bSlot = bEarlyNorSlot;
    }
  }

  #if (CSM_S_TRACE == CSM_C_F_ON)
    #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_FATAL(("CSM_APL_bGetConfigurationSlotNr: SLOT Nr:%x", bSlot));
      #endif
    #endif
  #endif
  return bSlot;
}

// required function, if slot value is to be read from KDS (late CSM variant)
// a very similar function is provided in ProcCsm.cpp, so this seems to be obsolete !!
DWORD CSM_APL_dwGetKDSValue(BYTE* pTarget, BYTE bItem, DWORD* dwError)
{
  DWORD dwReturn    = 0; // presume an error
  DWORD dwOSALError = 0; // empty

  OSAL_tIODescriptor  hKDS;
  tsKDSEntry          sKDSEntry;

  hKDS = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS, OSAL_EN_READONLY);
  if(OSAL_ERROR == hKDS)
  {
    dwOSALError = OSAL_u32ErrorCode();
    *dwError = dwOSALError;
  }
  else
  {
    switch(bItem)
    {
      // read SLOT
      case CSM_APL_C_READ_SLOT:
        sKDSEntry.u16Entry        = 0xA112;                  // vehicle information (64 bytes max)
        sKDSEntry.u16EntryLength  = 16;                      //  byte 15 is the SLOT
        sKDSEntry.u16EntryFlags   = M_KDS_ENTRY_FLAG_NONE;
        sKDSEntry.au8EntryData[15] = 0xFF;
        if(OSAL_ERROR == OSAL_s32IORead(hKDS, (tPS8)&sKDSEntry, sizeof(sKDSEntry) ) )
        {
          dwOSALError = OSAL_u32ErrorCode();
          *dwError = dwOSALError;
        }
        else
        {
          *pTarget = sKDSEntry.au8EntryData[15];
          dwReturn = 1;
          #if (CSM_S_TRACE == CSM_C_F_ON)
            #if (CSM_S_TRACE_ETG == CSM_C_F_ON)
              #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
              ETG_TRACE_FATAL(("CSM_APL_dwGetKDSValue: SLOT Nr:%x", sKDSEntry.au8EntryData[15]));
              #endif
            #endif
          #endif
        }
        break;

      default:
        *dwError = 0x270565;
        break;
    }
    (tVoid) OSAL_s32IOClose(hKDS);
  }
  return dwReturn;
}

#endif
#endif

#endif // CSM_S_DOXYGEN_HIDE_NON_API_FCT

/*******************************************************************************
 * function implementation (scope: CAN stack #1 API)
 ******************************************************************************/
/*-- none --*/

#undef CSM_APL_SELF
/*******************************************************************************
 * \doxydocu
 * \file          csm_apl.c
 * \brief         CAN stack manager and application adaptation module
 *                Functions which can neither be assigned clearly to the
 *                CAN stack manager nor to an application.
 *
 * \see           CAN-SW Architecture, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       MAIN
 * \path          \di_can\modules_swa\csm\src\
 *
 * \ingroup       CSM
 * \ingroup       CSM_APPL
 * \ingroup       CSM_IF
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2004 Blaupunkt GmbH
 * COPYRIGHT      (c) 2015 Bosch Car Multimedia GmbH
 *
 * \history_begin
 *
 * 05.12.13  \main\10  Prhl
 * - lint warning removed.
 *
 * 19.05.15  \rn_aivi_proxy\1   M. Prhl
 * - merge from \main\10
 *
 * 19.05.15  \rn_aivi_proxy\2   M. Prhl
 * - CSM_lInitVariants() added.
 *
 * 09.07.15  \rn_aivi_proxy\3   Borck
 * - function to get Slot Nr. moved here
 *
 * 16.07.15  \rn_aivi_proxy\4   Borck
 * - ETG tracing added
 * - SLOT configuration introduced
 * - Fkt InitVariant extended by SLOT based configuration
 * - SLOT Getter extended by KDS access, anyway SLOT 1 remains default and is FIXED until
 *   line 471 is activated to take over the SLOT nr.
 *
 * 22.09.15  \rn_aivi_proxy\rn_aivi_proxy_generated\1  A.Borck
 * - SLOT configuration extended for 10 slots (0...9)
 * - default slot is currently fixed and set to 5
 *
 * 24.09.15  \rn_aivi_proxy\rn_aivi_proxy_generated\2  A.Borck
 * - SLOT based CBR Signal abstraction integrated:
 *   -- initialisation of the module from within InitVariants()
 *
 * 08.10.15  \rn_aivi_proxy\rn_aivi_proxy_generated\3  A.Borck
 * - Mini Abstraction (CSM_S_CBR_ABSTRACT_SIGNALS) removed completely
 *
 * 27.10.15  \rn_aivi_proxy\rn_aivi_proxy_generated\4  A.Borck
 * - GetConfigSlot only called once where needed !!!
 *
 * 11.11.15  \rn_aivi_proxy\rn_aivi_proxy_generated\5  A.Borck
 * - default slot is now 0
 * - real KDS slot is taken to configure the CSM
 *
 * 08.06.17  \rn_aivi_proxy\rn_aivi_proxy_generated\6  A.Borck
 * - some ETG trace outputs put under FATAL to see configuration related traces without enabling a trace class
 *
 * 09.06.17  \rn_aivi_proxy\rn_aivi_proxy_generated\rn_aivi_early_csm\1  A.Borck
 * - read Slot Nr. from NOR flash instead from KDS (allows a more early startup)
 *
 * 24.11.17  main\g3inf4cv_csm_proxy_in\1  Jayashree
 * - removed Variant management switch
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
