/* Description and history of cnp_lctr_i.h at the end of the file             */
#if !defined(CNP_LCTR_I_HEADER)
/** File name for preprozessor commands */
#define CNP_LCTR_I_HEADER
/** Doxygen instruction:
 * \defgroup      CNP_LCTR   Local control transport protocol
 *                This group contains all files belonging to the Local control
 *                transport protocol.
 * \ingroup       CNP
*/

//#include "cnp_lctr_ip.h"   /* include project specific part */
/* no further includes allowed */

/*******************************************************************************
 * defines and macros (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * typedefs (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition (scope: CAN stack)
 ******************************************************************************/
/* --none-- */


/*******************************************************************************
 * function prototypes (scope: CAN stack and operating system)
 ******************************************************************************/
extern LONG CNP_LCTR_lInit( BYTE bInitMode);
extern LONG CNP_LCTR_lExit( BYTE bExitMode);
extern void CNP_LCTR_vProcessDataReq(void);
extern LONG CNP_LCTR_lDataReq(DWORD dwProtocolType,
                              const void* pvAddressField,
                              const BYTE* pbData,
                              WORD wDataLength);

#else /* CNP_LCTR_I_HEADER already defined */
 #error CNP_LCTR_I.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          cnp_lctr_i.h
 * \brief         External interface header of LCTR module.
 *
 * \see           CAN-SW Architektur, written by CM-AI/VTeam
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/cnp/src/
 *
 * \ingroup       CNP
 * \ingroup       CNP_LCTR
 *
 * \authors       VTeam-Jablonski
 *
 * COPYRIGHT      (c) 2009 Robert Bosch CM GmbH
 *
 *                  - All rights reserved -                             *
 *                                                                      *
 * This code is provided "as is" without warranty of any kind, either   *
 * expressed or implied, including but not limited to the liability     *
 * concerning the freedom from material defects, the fitness for parti- *
 * cular purposes or the freedom of proprietary rights of third parties.*
 *
 * \history_begin
 * 30.09.09  \main\1  VTeam-Jablonski
 * - Initial revision.
 *
 * 20.10.09  \main\2  Prhl
 * - prototypes for CNP_LCTR_lInit() and CNP_LCTR_lExit() added.
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
