/* Description and history of cnp_itp_ip.h at the end of the file.               */

#ifndef CNP_ITP_IP_HEADER
#define CNP_ITP_IP_HEADER

/*******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/

#ifdef TSI  /* TSI version -> */
 #define CNP_ITP_C_MAX_COMPONENTS 20   /* Max. number of local TP comp. */

 /* Buffer sizes for send and receive (application!) buffers,            */
 /* values have only been used in TSI so far, for non-TSI and assembly   */
 /* buffers csm_rIsoTpConnection[].wMaxRxLen and [].wMaxTxLen is used.   */

 #define CNP_ITP_C_MSG_MAXLEN  4095   /* Max. length of application message (<=4095 Byte)*/
                                    /* -> 585 DT-TPDU's */
 #define CNP_ITP_C_MSG_MAXRXBUF (CNP_ITP_C_MSG_MAXLEN + 6)     /* Length + Reserve */
 #define CNP_ITP_C_MAXMSG     5   /* Max. number of application messages for all channels (fifo ring buffer) */
#endif


/*******************************************************************************
| typedefs (scope: global)
|-----------------------------------------------------------------------------*/
/* --none-- */

/*******************************************************************************
| variable declaration (scope: local)
|-----------------------------------------------------------------------------*/
/*--- Timer arrays ----------------------------------------------*/

#if defined CNP_ITP_SELF
 #if (CSM_S_REQUESTABLE_TIMER == CSM_C_F_ON) /* Only for dynamic timers (e.g.TSI) */
    WORD CNP_wItpConnectionTimer[CSM_C_ISO_TP_MAX_CONNECTIONS][2];
 #else  /* Static timers -> */
    const WORD CNP_wItpConnectionTimer[CSM_C_ISO_TP_MAX_CONNECTIONS][2]
       = {{CSM_TIMER_ITP_TX_CH00, CSM_TIMER_ITP_RX_CH00}
  #if (1 < CSM_C_ISO_TP_MAX_CONNECTIONS)
         ,{CSM_TIMER_ITP_TX_CH01, CSM_TIMER_ITP_RX_CH01}
  #endif
  #if (2 < CSM_C_ISO_TP_MAX_CONNECTIONS)
         ,{CSM_TIMER_ITP_TX_CH02, CSM_TIMER_ITP_RX_CH02}
  #endif
  #if (3 < CSM_C_ISO_TP_MAX_CONNECTIONS)
         ,{CSM_TIMER_ITP_TX_CH03, CSM_TIMER_ITP_RX_CH03}
  #endif
  #if (4 < CSM_C_ISO_TP_MAX_CONNECTIONS)
         ,{CSM_TIMER_ITP_TX_CH04, CSM_TIMER_ITP_RX_CH04}
  #endif
  #if (5 < CSM_C_ISO_TP_MAX_CONNECTIONS)
   #error "Add additional timer IDs"
  #endif
         };
 #endif /* CSM_S_REQUESTABLE_TIMER == CSM_C_F_ON */
#endif /* CNP_ITP_SELF */


/*******************************************************************************
| function prototypes (scope: global)
|-----------------------------------------------------------------------------*/
/* --none-- */

#else
 #error CNP_ITP_IP.H included several times
#endif

/*******************************************************************************
 * \doxydocu
 * \file          cnp_itp_ip.h
 * \brief         Generic implementation of ISO/OSEK TP for CAN-SWA platform
 *                (adaptions for PC version (TSI) included)
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/cnp/src/
 *
 * \ingroup       CNP
 * \ingroup       CNP_ITP
 *
 * \authors       CM-DI/ESU3-K"ohler, -Zurm"uhl
 *
 * COPYRIGHT      (c) 2005 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 17.02.05  \main\2  CM-DI/ESA3-Prhl
 * - Initial revision.
 *
 * 10.03.05  \main\3  CM-DI/ESA3-Zurmhl
 * - Doxygen comments added
 * - Adaptations for TSI test environment
 *
 * 06.04.05  \main\4  CM-DI/ESA3-Prhl
 * - compiler warning removed
 *
 * 19.07.06  \main\5  CM-DI/ESA3-Khler
 * - Doxygen ingroup tags changed from CSM to CNP.
 *
 * 31.07.06  \main\6  CM-DI/ESA3-Zurmhl
 * - Unused code deleted, formatting and comments revised
 * - One "TSI" switch replaced by CSM_S_REQUESTABLE_TIMER
 *
 * 01.08.06  \main\7  CM-DI/ESA3-Zurmhl
 * - Some constant names changed: CNP_ITP_XYZ -> CNP_IPT_C_XYZ
 *
 * 15.06.07  \main\8  VTeam-Prhl
 * - compiler warning removed
 *
 * 09.12.11  \main\9  VTeam-Khler
 * - Three static timer added.
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
