/* Description and history of cnp_i.h at the end of the file                  */
#ifndef CNP_I_HEADER
/** File name for preprozessor commands */
#define CNP_I_HEADER

/*#include "cnp_ip.h" include project specific part (up to now not necessary) */
/* no further includes allowed */

/*******************************************************************************
 * defines and macros (scope: CAN stack)
 ******************************************************************************/
/* Error codes */   /* U.Z.(2): Wohl besser in cnp_m.h aufgehoben?! -> */
                    /* U.Z.(2): Weiterhin teilweise nach cnp_itp.h etc. zu verschieben? */
#define CNP_M_MAKE_ERROR(SecurityLevel, ErrorCode) \
           CSM_M_MAKE_ERROR(SecurityLevel, CSM_C_ERR_LOC_CNP, ErrorCode)

#define CNP_M_MCNET_TP_MAKE_ERROR(SecurityLevel, ErrorCode) \
            CSM_M_MAKE_ERROR(SecurityLevel, CSM_C_ERR_LOC_CNP_MCNET, ErrorCode)

#define CNP_M_ITP_MAKE_ERROR(SecurityLevel, ErrorCode) \
            CSM_M_MAKE_ERROR(SecurityLevel, CSM_C_ERR_LOC_CNP_ISO_TP, ErrorCode)

#define CNP_M_VAG_MAKE_ERROR(SecurityLevel, ErrorCode) \
            CSM_M_MAKE_ERROR(SecurityLevel, CSM_C_ERR_LOC_CNP_VAG_TP, ErrorCode)

#define CNP_M_J1939_MAKE_ERROR(SecurityLevel, ErrorCode) \
            CSM_M_MAKE_ERROR(SecurityLevel, CSM_C_ERR_LOC_CNP_J1939_TP, ErrorCode)


/* Note: All error codes are moved to csm_stack_i.h -> only global error codes to be used!*/
/*  (to be removed in future versions)                                                    */

/* General CNP error codes: */
/* use CSM_C_GENERAL_ERROR   #define CNP_E_GENERAL_ERROR     0x0001   General (unspecified) error    */
/* not used #define CNP_E_WRONG_BUS_NUMBER  0x0002   Wrong bus number               */
/* use CSM_C_INVALID_PARA    #define CNP_E_PARAM_ERROR       0x0003   General function param. error  */
/* #define CNP_E_RESOURCE          0x0004  */  /* General resource error (e.g. memory) */
/* #define CNP_E_BUFFER_ERROR      0x0005  */  /* General buffer error    */
/* #define CNP_E_BUFFER_FULL       0x0006  */  /* Buffer full             */
/* #define CNP_E_CONFIGURATION     0x0007  */  /* Error in configuration  */
/* use CSM_C_NULL_POINTER    #define CNP_E_UNEXP_NULLPTR     0x0008  */  /* Unexpected null pointer */
/* #define CNP_E_UNKNOWN_EVENT     0x0009  */ /* Unknown event           */
/* #define CNP_E_UNKNOWN_STATE     0x000A  */ /* Unknown state           */
/* #define CNP_E_INVALID_CON_IDX   0x000B  */ /* Invalid connection number (index)  */
/* #define CNP_E_ITEM_NOT_FOUND    0x000C  */ /* A search returns no item */
/* #define CNP_E_WRONG_BUS_STATE   0x000D  */ /* bus state not normal */
/* #define CNP_E_INIT_ERROR        0x000E  */ /* Error during initialization */

/* ISO TP specific error codes */
/* #define CNP_E_IPT_INVALID_TA    0x0201  */  /* Invalid TA (target address)       */
/* #define CNP_E_IPT_INVALID_DLC   0x0202  */  /* Invalid CAN DLC                   */
/* #define CNP_E_IPT_INVALID_PCI   0x0203  */  /* Invalid Protocol Control Inform.  */


/*******************************************************************************
 * typedefs (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: CAN stack and operating system)
 ******************************************************************************/
LONG CNP_lInit(BYTE bInitMode);
LONG CNP_lExit(BYTE bExitMode);

#else
#error CNP_I.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          cnp_i.h
 * \brief         Interface header of higher CAN Network Protocols.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/cda/src/
 *
 * \ingroup       CNP
 * \ingroup       CNP_IF
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2002 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 06.03.02  Rev. 1.0  CM-DI/EHS3-Pistoor
 * Initial revision.
 *
 * 13.09.02  Rev. 1.1 CM-DI/EHS3-Zurm"uhl, -K"ohler
 * - CNP error defines and macros added.
 *
 * 28.01.03  Rev. 1.2 CM-DI/EHS3-Pistoor
 * - Changed comment of CNP_lInit() and CNP_lExit()
 * - Added parameter to CNP_lExit()
 *
 * 12.02.03  Rev. 1.3 CM-DI/ESU3-K"ohler
 * - Komments corrected.
 *
 * 31.07.03  Rev. 1.4 CM-DI/ESU3-Franke
 * - new CNP_E_WRONG_BUS_STATE
 *
 * 10.10.03  Rev. 1.5 CM-DI/ESU3-Zurm"uhl, -K"ohler
 * - MCNET error macro name changed.
 *
 * 28.04.05  main\3 CM-DI/ESA3-K"ohler
 * - Some error defines commented out (used now from csm_stack_i.h).
 * - Doxygen comments added.
 *
 * 06.07.05  main\4 CM-DI/ESA3-Zurm"uhl
 * - All error code defines commented out (error codes from csm_stack_i.h used instead!)
 *
 * 18.01.08  main\5 Vteam-Zurmhl
 * - Doxygen tags (ingroup) corrected
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
