/* Description and history of cnm_mp.h at the end of the file.            */
#ifndef CNM_MP_HEADER
/** File name for preprozessor commands */
#define CNM_MP_HEADER

/* includes only in exceptional cases allowed, usually they must
 * be in the .c files. */

/*******************************************************************************
 * defines and macros (scope: module internal)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * typedefs (scope: module internal)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable declaration  (scope: module internal)
 ******************************************************************************/
#ifdef CNM_SELF
tCNM_CALC_BUS_STATE CNM_arCalculateBusState[CSM_C_MAX_CAN_BUS] =
{
  // theoretical path, will practically not occur
  { NULL }, // Null pointer check is implemented, so no risk
  { NULL }, // Null pointer check is implemented, so no risk
};
#endif

/*******************************************************************************
 * function prototypes (scope: module internal (cnm, cnm_osek, cda_...))
 ******************************************************************************/
/* --none-- */

#else
#error CNM_MP.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          cnm_mp.h
 * \brief         Project specific part of the module internal header of CNM
 *
 * \see           CAN-SW Architecture, written by CM-DI/ESA3
 *
 * \sw_component  CNM
 * \project       main
 * \path          /di_can/modules_swa/cnm/src/
 *
 * \ingroup       CNM
 *
 * \authors       CM/VTeam
 *
 * COPYRIGHT:      (c) 2011 Robert Bosch Car Multimedia GmbH
 *                 (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * \history_begin
 *
 * 11.03.15  main/rn_aivi/2  Borck
 * - comment changed, VCAN = Bus 0, MCAN is Bus 1 -> no functional change here !!!
 *
 * 29.05.15  main/rn_aivi_proxy/1  M. Prhl
 * - merge from main/rn_aivi/2
 *
 * 01.06.15  main/rn_aivi_proxy/2  M. Prhl
 * - call of CNM_OSEKI_bCalculateBusState() removed.
 *
 * \history_end
 *//**** END OF FILE *************************************************************/
