/* Description and history of cnm_m.h at the end of the file.                 */
#ifndef CNM_M_HEADER
#define CNM_M_HEADER

/* Include project specific part if necessary. */
/* #include "cnm_mp.h" after struct tCNM_CALC_BUS_STATE */

/*******************************************************************************
 * defines and macros (scope: module internal)
 ******************************************************************************/
/* error codes */
#define CNM_M_MAKE_ERROR(SecurityLevel,ErrorCode) \
            CSM_M_MAKE_ERROR(SecurityLevel,CSM_C_ERR_LOC_CNM,ErrorCode)

/* U.Z.(5): evtl. besser nach cnm_i.h? */
#define CNM_M_MCNET_MAKE_ERROR(SecurityLevel, ErrorCode) \
              CSM_M_MAKE_ERROR(SecurityLevel, CSM_C_ERR_LOC_CNM_MCNET, ErrorCode)

/* General CNM error codes: (VK: removed because general CSM errors shall be used*/

/*******************************************************************************
 * typedefs (scope: module internal)
 ******************************************************************************/
/* data structure for calculation of bus state */
typedef BYTE (*tCNM_PFN_CALC_BUS_STATE) ( BYTE);

/******************************************************************************/
/* Struct to configuration for CAN controler */
typedef struct
{
  tCNM_PFN_CALC_BUS_STATE   bPFNCalcBusState;
}tCNM_CALC_BUS_STATE;

#include "cnm_mp.h"

/*******************************************************************************
 * variable declaration  (scope: module internal)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: module internal (cda, cda_CCC, cda_TTT))
 ******************************************************************************/
/* --none-- */

#else
#error CNM_M.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          cnm_m.h
 * \brief         Header file for CAN Network Management module internal used
 *                data/definitions.
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/cnm/src/
 *
 * \ingroup       CNM
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2001 Blaupunkt Werke GmbH
 *
 * \history_begin
 *
 * 11.02.02  PVCS Rev. 0.1  CM-DI/EHS3-Pistoor
 * - Initial Version.
 * 02.12.02  PVCS Rev. 1.1  CM-DI/EHS3-FEM5HI
 * - included project specific header file for FNOS OSEK NM
 * 22.09.03  PVCS Rev. 1.2  CM-DI/ESU3-Zurm"uhl/K"ohler
 * - CNM MCNet error macro added.
 *
 * 09.06.05  \main\6  CM-DI/ESA3-K"ohler
 * - Doxygen comments added.
 * - Error code defines removed.
 *
 * 14.07.06  \main\4  CM-DI/VTeam-Battis
 * - feature switch usage corrected.
 *
 * 07.12.06  \main\5  CM-DI/VTeam-Khler
 * - CSM_S_FORD_NM_OSEK code removed.
 *
 * 10.02.11  \main\6  CM-AI/PJ-GM58-Pistoor
 * - Added structure definition tCNM_CALC_BUS_STATE
 * - added include of csm_p.h
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
