/* Description and history of cnm.c at the end of the file.                   */
/** File name for preprozessor commands */
#define CNM_SELF
/** cnm.c is a file according V-team CAN-SW architecture implementation rules */
#define CSM_CAN_STACK

/*******************************************************************************
 * includes:
 ******************************************************************************/

/*************** CSM and stack **************/
#include "csm_stack_i.h"
#include "csm_stack_m.h"
/* Include not necessary up to now. Add again if necessarry, possibly
   encapsulated with feature switch.
#include "csm_c.h"
*/

/*************** CNM **************/
#include "cnm_i.h"
//#include "cnm_m.h" is included later
#if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)
  #include "cnm_c.h"
#endif

#if (CSM_S_FIATSLAVE_NM == CSM_C_F_ON)
  #include "cnm_FiatSlave_i.h"
#endif

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
#if (CSM_S_MCNET == CSM_C_F_ON)
  #if ((CSM_S_MCNET_MASTER_NWM == CSM_C_F_ON) || (CSM_S_MCNET_SLAVE_NWM == CSM_C_F_ON))
    #include "cnm_mcnet_i.h"
  #endif
#endif
#endif /*CSM_S_CNP_AVAILABLE    */

#if (CSM_S_OSEK_NM == CSM_C_F_ON)
  #include "cnm_osek_i.h"
#endif

#if (CSM_S_OSEKI_NM == CSM_C_F_ON)
  #include "cnm_oseki_i.h"
#endif

#if (CSM_S_RENAULT_NM == CSM_C_F_ON)
  #include "cnm_renault_i.h"
#endif /* CSM_S_RENAULT_NM */

#if (CSM_S_GMLAN_NM == CSM_C_F_ON)
  #include "cnm_gmlan_i.h"
#endif /* CSM_S_GMLAN_NM */

#if (CSM_S_VW_NM == CSM_C_F_ON)
  #include "cnm_vw_i.h"
#endif

#if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
  #include "cnm_vwhigh_i.h"
#endif

#if (CSM_S_J1939_NM == CSM_C_F_ON)
  #include "cnm_J1939_i.h"
#endif

#include "cnm_m.h"

/*****************************************************************
| check of all feature switches which affects this file :
| The following #defines should be declared in csm_stack_p.h:
|----------------------------------------------------------------*/
#ifndef CSM_S_CDA_AVAILABLE
  #error "CSM_S_CDA_AVAILABLE must be set to CSM_C_F_ON or -OFF !"
#endif

/*******************************************************************************
 * defines and macros (scope: file local)
 ******************************************************************************/
/* -- none --*/

/*******************************************************************************
 * typedefs (scope: file local)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition (scope: file local)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition (scope: CAN stack)
 ******************************************************************************/
/*-- none --*/

/*******************************************************************************
 * function prototypes (scope: file local)
 ******************************************************************************/
/*-- none --*/

/*******************************************************************************
 * constants (scope: file local)
 ******************************************************************************/
/*-- none --*/

/* Feature switch is used only to control doxygen documentation */
#if (CSM_S_DOXYGEN_HIDE_NON_API_FCT == CSM_C_F_OFF)
/*******************************************************************************
 * function implementation (scope: file local = static)
 ******************************************************************************/
/*-- none --*/


/*******************************************************************************
 * function implementation (scope: module local)
 ******************************************************************************/
/*-- none --*/

/*******************************************************************************
 * function implementation (scope: CAN stack and operating system)
 *******************************************************************************/

/*******************************************************************************
 * function    CNM_lInit
 * \doxydocu
 * \brief      Three-stage initialisation of the network management module.
 *
 *
 * \param[in]  bInitMode
 *             Allowed values (see csm_stack_i.h):\n
 *             - CSM_C_INIT_COLD: Called after a reset. If necessary, set a flag,
 *                 in case special reset routines have to be run in the further
 *                 course of initialisation.\n
 *             - CSM_C_INIT_WARM: Variable initialisation: Only the functions of
 *                 some basic (project-specific) modules can be called.\n
 *             - CSM_C_INIT_START: Initialisation of the register/ports, timer
 *                 start. Functions of all the other modules can be called.
 *
 * \return     Error value
 *
 * \access     CAN Task
 * \reentrant  no
 *
 * \lastreview 29.05.06 CM-DI/ESA3-Prhl
 *
 * \history_begin
 * 28.01.03 CM-DI/EHS3-Pistoor
 * - Initial Revision.
 * \history_end
 ******************************************************************************/
LONG CNM_lInit(BYTE bInitMode)
{
LONG lReturnValue = CSM_C_NO_ERROR;
  #if (CSM_S_FIAT_NM_SLAVE_1 == CSM_C_F_ON) || (CSM_S_FIAT_NM_SLAVE_2 == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_lFiatSlave_Init(bInitMode)); //lint !e774 PQM_authorized_127
  #endif
  #if (CSM_S_FIAT_NM_MASTER_1 == CSM_C_F_ON) || (CSM_S_FIAT_NM_MASTER_2 == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_lFiatMaster_Init(bInitMode)); //lint !e774 PQM_authorized_127
  #endif

  #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
  #if (CSM_S_MCNET == CSM_C_F_ON)
    #if ((CSM_S_MCNET_MASTER_NWM == CSM_C_F_ON) || (CSM_S_MCNET_SLAVE_NWM == CSM_C_F_ON))
      CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_MCNET_lInit(bInitMode)); //lint !e774 PQM_authorized_127
    #endif
  #endif
  #endif /* CSM_S_CNP_AVAILABLE*/

  #if (CSM_S_VW_NM == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_VW_lInit(bInitMode)); //lint !e774 PQM_authorized_127
  #endif
  #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_VWHIGH_lInit(bInitMode)); //lint !e774 PQM_authorized_127
  #endif
  #if (CSM_S_RENAULT_NM == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_RENAULT_lInit(bInitMode)); //lint !e774 PQM_authorized_127
  #endif
  #if (CSM_S_GMLAN_NM == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_GMLAN_lInit(bInitMode)); //lint !e774 PQM_authorized_127
  #endif

  #if (CSM_S_OSEK_NM == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_OSEK_lPreInit(bInitMode)); //lint !e774 PQM_authorized_127
  #endif

  #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_OSEKI_lInit(bInitMode)); //lint !e774 PQM_authorized_127
  #endif

  #if (CSM_S_J1939_NM == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_J1939_lInit(bInitMode)); //lint !e774 PQM_authorized_127
  #endif

  return lReturnValue;
} /* CNM_lInit() */


/*******************************************************************************
 * function    CNM_lExit
 * \doxydocu
 * \brief      Deactivation of the network management modules.
 *             Switch network management to inactive.
 *             Design like written in CAN SW architecture
 *             document from group CM-DI/EHS3
 *
 * \param[in]  bExitMode
 *             Allowed values (see csm_stack_i.h):
 *             - CSM_C_EXIT_STOP: Opposite of CSM_C_INIT_START. E.g. stop timers.
 *             - CSM_C_EXIT_OFF: Opposite of CSM_C_INIT_WARM. Set ports for
 *               minimal power consumption.
 *
 * \return     Error value
 *
 * \access     CAN-task
 * \reentrant  no
 *
 * \lastreview 29.05.06 CM-DI/ESA3-Prhl
 *
 * \history_begin
 * 12.01.04 CM-DI/ESU3-Zurmhl
 * CNM_MCNET_lExit() call added
 *
 * 28.01.03 CM-DI/EHS3-Pistoor
 * - Initial Revision.
 * \history_end
 ******************************************************************************/
LONG CNM_lExit(BYTE bExitMode)
{
  LONG lReturnValue = CSM_C_NO_ERROR;
  #if (CSM_S_FIAT_NM_SLAVE_1 == CSM_C_F_ON) || (CSM_S_FIAT_NM_SLAVE_2 == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_lFiatSlave_Exit(bExitMode)); //lint !e774 PQM_authorized_127
  #endif
  #if (CSM_S_FIAT_NM_MASTER_1 == CSM_C_F_ON) || (CSM_S_FIAT_NM_MASTER_2 == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_lFiatMaster_Exit(bExitMode)); //lint !e774 PQM_authorized_127
  #endif

  #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
  #if (CSM_S_MCNET == CSM_C_F_ON)
    #if ((CSM_S_MCNET_MASTER_NWM == CSM_C_F_ON) || (CSM_S_MCNET_SLAVE_NWM == CSM_C_F_ON))
      CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_MCNET_lExit(bExitMode)); //lint !e774 PQM_authorized_127
    #endif
  #endif
  #endif /*CSM_S_CNP_AVAILABLE*/

  #if (CSM_S_VW_NM == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_VW_lExit(bExitMode)); //lint !e774 PQM_authorized_127
  #endif
  #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_VWHIGH_lExit(bExitMode)); //lint !e774 PQM_authorized_127
  #endif
  #if (CSM_S_RENAULT_NM == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_RENAULT_lExit(bExitMode)); //lint !e774 PQM_authorized_127
  #endif
  #if (CSM_S_GMLAN_NM == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_GMLAN_lExit(bExitMode)); //lint !e774 PQM_authorized_127
  #endif

  #if (CSM_S_OSEK_NM == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_OSEK_lExit(bExitMode)); //lint !e774 PQM_authorized_127
  #endif

  #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_OSEKI_lExit(bExitMode)); //lint !e774 PQM_authorized_127
  #endif

  #if (CSM_S_J1939_NM == CSM_C_F_ON)
    CSM_M_SET_HIGHEST_ERROR_GRADE(lReturnValue, CNM_J1939_lExit(bExitMode)); //lint !e774 PQM_authorized_127
  #endif

  return lReturnValue;
}

/*******************************************************************************
 * function    CNM_lGetStatus
 * \doxydocu
 * \brief      Get Status of network component.
 *             VK: request for next bus state?
 *
 * \param[in]  bBus
 *             bus index
 *
 * \return     status value (should be byte)
 *
 * \access     CAN-task
 * \reentrant  no
 *
 * \lastreview 16.04.08 VTeam-Prhl
 *
 * \history_begin
 * 18.09.07 RBIN/EDI2-Basavaraj, V-Team-Khler
 *  - Status processing for the Volcano (OSEK VolvoNM) driver.
 *
 * 16.03.04 CM-DI/ESU3-K"ohler
 *  - lReturnValue initialized with 0x00.
 *
 * 06.08.03 CM-DI/ESU3-Pistoor
 * -Deleted default value for lReturnValue
 *
 * 24.04.03 CM-DI/ESU3-Pistoor
 * - changed states for FORD TP_EX
 *
 * 24.04.03 CM-DI/ESU3-Pistoor
 * - Added functionality for Fiat
 *
 * 19.03.03 CM-DI/ESU3 Franke
 * - Initial Revision.
 * \history_end
 ******************************************************************************/
LONG CNM_lGetStatus(BYTE bBus)
{
  LONG lReturnValue = CSM_C_NO_ERROR;

  #if (CSM_S_FIAT_NM_SLAVE_1 == CSM_C_F_ON) || (CSM_S_FIAT_NM_SLAVE_2 == CSM_C_F_ON)
    lReturnValue = CNM_lFiatSlave_GetStatus(bBus);
  #endif

  #if (CSM_S_FIAT_NM_MASTER_1 == CSM_C_F_ON) || (CSM_S_FIAT_NM_MASTER_2 == CSM_C_F_ON)
    lReturnValue = CNM_lFiatMaster_GetStatus(bBus);
  #endif

  #if (CSM_S_OSEK_NM == CSM_C_F_ON)
    lReturnValue = CNM_OSEK_bGetStatus(bBus);
  #endif

  #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
    lReturnValue = CNM_OSEKI_bGetStatus(bBus);
  #endif

  #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
    lReturnValue = CNM_VWHIGH_bGetStatus(bBus);
  #endif

  return lReturnValue;
}/*lint !e715 PQM_authorized_multi_122. Reason: Variable is a preset by interface, but not used intentionally*/


/*******************************************************************************
 * function    CNM_lGotoMode
 * \doxydocu
 * \brief      Goto NW mode.
 *
 * \param[in]  bBus
 *             bus index
 *
 * \param[in]  bNM_Mode
 *             requested mode
 *
 * \return     status value
 *
 * \access     CAN-task
 * \reentrant  no
 *
 * \lastreview 18.03.11 Borck
 *
 * \history_begin
 * 09.03.11  VTeam-Khler
 * - Macro CSM_M_SET_HIGHEST_ERROR_GRADE usage replaced by 'lReturnValue ='.
 *
 * 17.08.07 RBIN/EDI2-Basavaraj
 *  - Encapsulation of the OSEK-NM Api's
 *
 * 24.04.03 CM-DI/ESU3-Pistoor
 *          Added functionality for Fiat
 *
 * 20.03.03 CM-DI/ESU3 Franke
 *          Initial Revision.
 * \history_end
 ******************************************************************************/
LONG CNM_lGotoMode(BYTE bBus, BYTE bNM_Mode)
{
  LONG lReturnValue = CSM_C_NO_ERROR;

  switch (bNM_Mode)
  {
    #if (CSM_S_FIAT_NM_SLAVE_1 == CSM_C_F_ON) || (CSM_S_FIAT_NM_SLAVE_2 == CSM_C_F_ON)
      case CNM_FIATSLAVE_REQ_NET_OFF:
         /* SB05: das hier wird nicht mehr verwendet ! */
         CSM_vAssert(0);
         CNM_vFiatSlave_NMRequest(CNM_FIATSLAVE_REQ_NET_OFF);
      break;
      case CNM_FIATSLAVE_REQ_NET_ON:
         /* SB05: das hier wird nicht mehr verwendet ! */
         CSM_vAssert(0);
         CNM_vFiatSlave_NMRequest(CNM_FIATSLAVE_REQ_NET_ON);
      break;
      case CNM_FIATSLAVE_REQ_NET_CHECK:
         /* SB05: das hier wird nicht mehr verwendet ! */
         CSM_vAssert(0);
         CNM_vFiatSlave_NMRequest(CNM_FIATSLAVE_REQ_NET_CHECK);
      break;
    #endif

    #if (CSM_S_FIAT_NM_MASTER_1 == CSM_C_F_ON) || (CSM_S_FIAT_NM_MASTER_2 == CSM_C_F_ON)
      case CNM_FIATMASTER_REQ_NET_OFF:
         CNM_vFiatSlave_NMRequest(CNM_FIATMASTER_REQ_NET_OFF);
      break;
      case CNM_FIATMASTER_REQ_NET_ON:
         CNM_vFiatSlave_NMRequest(CNM_FIATMASTER_REQ_NET_ON);
      break;
    #endif

    #if (CSM_S_OSEK_NM == CSM_C_F_ON)
      case CNM_C_CAN_NORMAL:
        lReturnValue = CNM_OSEK_lGotoMode(bBus, CNM_OSEK_C_AWAKE);
        break; /* CNM_C_CAN_NORMAL */
      case CNM_C_CAN_SLEEP:
        /* indicate readiness for sleep mode: */
        lReturnValue = CNM_OSEK_lGotoMode(bBus, CNM_OSEK_C_BUS_SLEEP);
        break; /* CNM_C_CAN_SLEEP */
    #endif /* CSM_S_OSEK_NM */

    #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
      case CNM_C_CAN_NORMAL:
        lReturnValue = CNM_OSEKI_lGotoMode(bBus, CNM_OSEKI_C_NMNormal);
        break;
      case CNM_C_CAN_SLEEP:
        lReturnValue = CNM_OSEKI_lGotoMode(bBus, CNM_OSEKI_C_NMBusSleep);
        break;
    #endif /* CSM_S_OSEK_NM */

    default:
      break;
  } /* switch (bNM_Mode) */ /*lint !e764 */

  return lReturnValue;
}/*lint !e715 PQM_authorized_multi_122. Reason: Variable is a preset by interface, but not used intentionally*/

/*******************************************************************************
 * function    CNM_vCDAReceiveInd
 * \doxydocu
 * \brief      Callback function for CDA if a CNM message was received.
 *             Design like written in CAN SW architecture
 *             document from group CM-DI/EHS3
 *
 * \param[in]  *prData
 *              Pointer to CAN message, only valid while function call!!!
 *
 * \return     void
 *
 * \access     CAN-task
 * \reentrant  no
 *
 * \lastreview 29.05.06 CM-DI/ESA3-Prhl
 *
 * \history_begin
 * 24.06.05 CM-DI/ESA3-K"ohler
 * IVLAN part for OSEK_NM added.
 * 11.12.03 CM-DI/ESU3-Prhl
 * new CDA interface added
 * 12.12.01 CM-DI/ECC13-Pistoor
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
#if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)
void CNM_vCDAReceiveInd(const CSM_CAN_RX_DATA * const prData)
{
  switch( prData->bTelegramType)
  {
    #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
    #if (CSM_S_MCNET == CSM_C_F_ON)
    #if ((CSM_S_MCNET_SLAVE_NWM == CSM_C_F_ON))
      case CSM_C_TEL_TYPE_MCNET_WD_RX:
      {
        CNM_MCNET_lWDMonitor( prData->bTelegramIndex, CNM_MCNET_C_WD_RECEIVED, prData);
      }
      break;
    #endif /* CSM_S_MCNET_SLAVE_NWM */
    #endif /* CSM_S_MCNET */
    #endif

    #if (CSM_S_FIAT_NM_SLAVE_1 == CSM_C_F_ON)
      case CSM_C_TEL_TYPE_FIAT_NM_SLAVE_RX:
      {
        CNM_vFiatSlave_Ind(prData);
      }
      break;
    #endif /* CSM_S_FIAT_NM_SLAVE_1 */

    #if (CSM_S_OSEK_NM == CSM_C_F_ON)
      case CSM_C_TEL_TYPE_OSEK_NM:
      {
        CNM_OSEK_vReceiveInd(prData);
      }
      break;
    #endif /* CSM_S_OSEK_NM */

    #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
    #if (CSM_S_MPDT == CSM_C_F_ON)
      case CSM_C_TEL_TYPE_MPDT_TP:
      {
        /* since the NWM in Nassan LCN2 also handles bus off monitoring       */
        /* it is here required to report MPDT RX messages to NWM              */
        #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
        CNM_OSEKI_vReceiveInd(prData);
        #endif
      }
      break;
    #endif
    #endif

    #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
      case CSM_C_TEL_TYPE_OSEKI_NM:
      {
        CNM_OSEKI_vReceiveInd(prData);
      }
      break;
    #endif /* CSM_S_OSEKI_NM */

    #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
      case CSM_C_TEL_TYPE_VWHIGH_NM:
      {
        CNM_VWHIGH_vReceiveInd(prData);
      }
      break;
    #endif /* CSM_S_OSEKI_NM */

    #if (CSM_S_GMLAN_NM == CSM_C_F_ON)
      case CSM_C_TEL_TYPE_GMLAN_NM:
      {
        CNM_GMLAN_vReceiveInd(prData);
      }
      break;
    #endif /* CSM_S_GMLAN_NM */

    #if (CSM_S_J1939_NM == CSM_C_F_ON)
      case CSM_C_TEL_TYPE_J1939_NM:
      {
        CNM_J1939_vReceiveInd(prData);
      }
      break;
    #endif /* CSM_S_J1939_NM */

      default:
      {
        /*ASSERT!!*/
      }
      break;
   }
} /* end CNM_vCDAReceiveInd() */


/*******************************************************************************
 * function    CNM_vCDADataCon
 * \doxydocu
 * \brief      Callback function for CDA to confirm a data request from NM.
 *
 * \see        Design like written in CAN SW architecture
 *             document from VTeam
 *
 * \param[in]  prData
 *              Pointer to confirmation data
 *
 * \return     void
 *
 * \access     ?
 * \reentrant  ?
 *
 * \lastreview 18.03.11 Borck
 *
 * \history_begin
 * 06.05.2010  Borck
 * - Initial Revision.
 * \history_end
 ******************************************************************************/
void CNM_vCDADataCon(const CSM_CAN_CON_DATA * const prData)
{
  switch(prData->bTelegramType)
  {
    #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
    /* indirect OSEK NM requires to monitor TX messages, for instance send by */
    /* the CBR - this linkage is configured in cda_mp.h                       */
    /* so even if this looks a little bit strange here: it is the property    */
    /* of indirect NM to hook on standard non-dedicated messages, here CBR    */
    /* BKA2HI: Nissan as the first user of OSEKI also wants to have the MCAN  */
    /* to be monitored (at least regarding BusOff) so MPDT is also relevant.  */

    /* for the future, a more generic mechanism with configuration from       */
    /* external header file would be better (currently we needed this quickly)*/
    case CSM_C_TEL_TYPE_MPDT_TP:
    case CSM_C_TEL_TYPE_CBR_TX:
    {
      CNM_OSEKI_vDataCon(prData);
    }
    break;
    #endif

    case CSM_C_TEL_TYPE_NO_TYPE:
    /* Fall through here; this telegram type here is used intentionally       */
    /* to supress the LINT warning for missing "case"                         */
    default:
    {
      /* do nothing                                                           */
    }
    break;
  }
}
#endif /* CSM_S_CDA_AVAILABLE */


/*******************************************************************************
 * function    CNM_lBusoffRecovery
 * \doxydocu
 * \brief      Busoff reinitialization function.
 *
 * \param[in]  bBus
 *              bus number
 *
 * \return     Error value
 *
 * \access     CAN-task
 * \reentrant  no
 *
 * \lastreview 29.05.06 CM-DI/ESA3-Prhl
 *
 * \history_begin
 * 24.09.04 CM-DI/ESA3-Battis
 * New version.
 *
 * 03.04.03 CM-DI/ESU3-Pistoor
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
#if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)
LONG CNM_lBusoffRecovery(BYTE bBus)
{
  LONG lReturnValue = CSM_C_NO_ERROR;

  CSM_M_PARAMETER_INTENTIONALLY_UNUSED( bBus);

  /* do something here if there is any NM work left to be done. */
  #if (CSM_S_OSEK_NM == CSM_C_F_ON)
    lReturnValue = CNM_OSEK_lBusoffRecovery( bBus);
  #endif /* CSM_S_OSEK_NM */

  #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
    lReturnValue = CNM_OSEKI_lBusoffRecovery(bBus);
  #endif

  #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
    lReturnValue = CNM_VWHIGH_lBusoffRecovery(bBus);
  #endif

  #if (CSM_S_GMLAN_NM == CSM_C_F_ON)
    lReturnValue = CNM_GMLAN_lBusoffRecovery( bBus);
  #endif /* CSM_S_GMLAN_NM */

  #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
  #if (CSM_S_MCNET == CSM_C_F_ON)
  #if (CSM_S_MCNET_MASTER_NWM == CSM_C_F_ON) || (CSM_S_MCNET_SLAVE_NWM == CSM_C_F_ON)
    lReturnValue = CNM_MCNET_lBusoffRecovery( bBus);
  #endif
  #endif /* CSM_S_MCNET */
  #endif

  return lReturnValue;
}
#endif /*CSM_S_CDA_AVAILABLE == CSM_C_F_ON*/


/*******************************************************************************
 * function    CNM_lBusOffEntry
 * \doxydocu
 * \brief      Busoff entry function.
 *
 * \param[in]  bBus
 *              bus number
 *
 * \return     Error value
 *
 * \access     main loop
 * \reentrant  no
 *
 * \lastreview 09.03.2011 VTeam-Khler
 * Finding: Only one NM BusOffEntry function per bus useful. Solution project
 * specific function pointer table (one pointer per bus)?
 * 29.05.06 CM-DI/ESA3-Prhl
 * Befund: kein echter Rckgabewert!
 *
 * \history_begin
 * 09.03.11  VTeam-Khler
 * - Return value used.
 * 03.04.03 CM-DI/ESU3-Pistoor
 * Initial Revision.
 *
 * \history_end
 ******************************************************************************/
#if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)
LONG CNM_lBusoffEntry(BYTE bBus)
{
  LONG lReturnValue = CSM_C_NO_ERROR;

  #if (CSM_S_OSEK_NM == CSM_C_F_ON)
    lReturnValue = CNM_OSEK_lBusoffEntry( bBus);
  #endif /* CSM_S_OSEK_NM */

  #if (CSM_S_OSEKI_NM == CSM_C_F_ON)
    lReturnValue = CNM_OSEKI_lBusoffEntry(bBus);
  #endif

  #if (CSM_S_VWHIGH_NM == CSM_C_F_ON)
    lReturnValue = CNM_VWHIGH_lBusoffEntry(bBus);
  #endif

  #if (CSM_S_GMLAN_NM == CSM_C_F_ON)
    lReturnValue = CNM_GMLAN_lBusoffEntry( bBus);
  #endif /* CSM_S_GMLAN_NM */

  #if (CSM_S_FIATSLAVE_NM == CSM_C_F_ON)
    if(bBus == CSM_C_CAN_1)
    {
      CNM_vFiatSlave_BusoffEntry();
    }
  #endif

  #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
  #if (CSM_S_MCNET == CSM_C_F_ON)
  #if (CSM_S_MCNET_SLAVE_NWM == CSM_C_F_ON) || (CSM_S_MCNET_MASTER_NWM == CSM_C_F_ON)
    lReturnValue = CNM_MCNET_lBusoffEntry( bBus);
  #endif
  #endif
  #endif

  #if (CSM_S_RENAULT_NM == CSM_C_F_ON)
    if(bBus == CSM_C_CAN_1)
    {
      CNM_RENAULT_vBusOffEntry();
    }
  #endif /* CSM_S_RENAULT_NM */

   return lReturnValue;
}
#endif /*CSM_S_CDA_AVAILABLE == CSM_C_F_ON*/


/*******************************************************************************
 * function    CNM_bCalculateBusState
 * \doxydocu
 * \brief      Calculate bus state
 *
 *             This function is call from CSM_bCalcBusState() to calculate the bus state from CNM view.
 *
 * \param[in]  bBus
 *              Bus number
 *
 * \return     void
 *
 * \access     CAN-task
 * \reentrant  no
 *
 * \lastreview 18.03.11 Borck
 *
 * \history_begin
 *
 * 10.02.11  CM-AI/PJ-GM58-Pistoor
 * - Added bus specific NM configuration table CNM_arCalculateBusState[]
 *
 * 01.10.04  CM-DI/ESA3-Prhl
 * - Initial version
 * \history_end
 ******************************************************************************/
BYTE CNM_bCalculateBusState(BYTE bBus)
{
  BYTE bNewBusState = CSM_C_STATE_BUS_DOWN; /* per default, a bus can go down */

  /* calculate a bus state only, if a function has been configured for this   */
  if (CNM_arCalculateBusState[bBus].bPFNCalcBusState != NULL)
  {
    bNewBusState = CNM_arCalculateBusState[bBus].bPFNCalcBusState(bBus);
  }

  return bNewBusState;
}

#endif /* CSM_S_DOXYGEN_HIDE_NON_API_FCT */
/*******************************************************************************
 * function implementation (scope: CAN stack #1 API)
 ******************************************************************************/
/* --none-- */

#undef CNM_SELF /*lint !e750 */
#undef CSM_CAN_STACK
/*******************************************************************************
 * \doxydocu
 * \file          cnm.c
 * \brief         CAN Network management adaptation module.
 *
 *                Adaptations between CSM or CDA and the different network
 *                managements.
 *
 * \see           CAN-SW Architecture, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/cnm/src/
 *
 * \ingroup       CNM
 * \ingroup       CNM_IF
 *
 * \authors       V-Team
 *
 * COPYRIGHT      (c) 2004 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 16.03.04  \main\3  CM-DI/ESU3-K"ohler
 * lReturnValue in CNM_lGetStatus() initialized with 0x00.

 * 18.06.04  \main\4  CM-DI/ESU3-Prhl
 * - CNM_vCDAReceiveInd() modified
 *
 * 16.07.04  \main\7  CM-DI/ESU3-Prhl
 * - old typedef CSM_CAN_RX_DATA removed
 *
 * 02.09.04  \main\8  CM-DI/ESA3-Battis
 * - changes for Fiat SB05
 *
 * 03.09.04  \main\9  CM-DI/ESA3-Prhl
 * - CNM_bCalculateBusState() added
 *
 * 13.09.04  \main\10  CM-DI/ESA3-Battis
 * - CNM_bCalculateBusState() filled for Fiat SB05
 *
 * 29.09.04  \main\11 M-DI/ESA3-Battis
 * - new implementation of CNM_lBusOffReinit() and CNM_lBusoffRecovery()
 *
 * 30.09.04  \main\12  CM-DI/ESA3-Battis
 * - includes now csm_c.h
 *
 * 30.09.04  \main\13  CM-DI/ESA3-K"ohler
 * - Include csm_i.h removed.
 *
 * * 15.10.04  \main\14  CM-DI/ESA3-Prhl
 * - feature CSM_S_OSEK_NM added
 *
 * 19.10.04  \main\15  CM-DI/ESA3-Prhl
 * - CNM_bCalculateBusState() modified
 *
 * 02.11.04  \main\16  CM-DI/ESA3-Prhl
 * - CNM_lBusoffRecovery() and CNM_lBusoffEntry() modified for OSEK NM
 *
 * 03.02.05  \main\17  CM-DI/ESA3-Prhl
 * - CNM_lBusoffReinit() inserted
 *
 * 28.04.05  \main\18  CM-DI/ESA3-Battis
 * - const declaration added
 *
 * 09.05.05  \main\20  CM-DI/ESA3-Battis
 * - changes to make MISRA happy
 *
 * 09.06.05  main\21  CM-DI/ESA3-K"ohler
 * - Doxygen comments and prototypes for IVLAN added.
 *
 * 29.06.05  main\22  CM-DI/ESA3-K"ohler
 * - IVLAN part for OSEK_NM in CNM_vCDAReceiveInd added.
 *
 * 30.08.05  main\23  CM-DI/ESA3-Franke
 * - CNM_vFordOsekStateInd bug fix
 *
 * 20.10.05  main\24  CM-DI/ESA3-Franke
 * - Changed MCNet feature switches
 *
 * 17.11.05  main\25  CM-DI/ESA3-Battis
 * - Feature switch corrected.
 *
 * 21.11.05  main\26  CM-DI/ESA3-Battis
 * - feature switches aligned to CSM architecture
 * - MCNet NM included in busoff handling
 *
 * 29.05.06  \main\27  CM-DI/ESA3-Prhl
 * - add a const to CNM_vCDAReceiveInd()
 * - add some doxygen
 *
 * 14.06.06  \main\28  CM-DI/ESA3-Prhl
 * - add GMLAN NM
 *
 * 25.08.06  \main\29  CM-DI/ESA3-Khler
 * - Renault NM added
 *
 * 31.08.06  \main\30  CM-DI/ESA3-Prhl
 * - add CNM_GMLAN_lExit() and CNM_GMLAN_lPreInit()
 *
 * 07.10.06  \main\31  CM-DI/ESA3-Prhl
 * - add some "#if (CSM_S_CDA_AVAILABLE == CSM_C_F_ON)"
 *
 * 24.01.07  \main\32  CM-DI/ESA3-Looby
 * - Renault NM Bus-off added to CNM_lBusoffEntry.
 *
 * 15.05.07  \main\33  CM-DI/VTeam-Prhl
 * - spaces after # deleted
 *
 * 14.06.07  \main\34  CM-DI/VTeam-Battis
 * - feature switch usage corrected.
 *
 * 05.07.07  \main\35  VTeam-Prhl
 * - lint warnings removed or commented out.
 *
 * 19.09.07  \main\36  RBIN/EDI2-Basavaraj, VTeam-Khler
 * - OSEK NM added in CNM_lGetStatus() and CNM_lGotoMode().
 *
 * 16.11.07  \main\37  VTeam-Prhl
 * - Old CSM_S_FORD_NM_OSEK code reemoved.
 *
 * 07.12.07  \main\38  VTeam-Khler
 * - Feature switches CSM_S_MCNET_MASTER_NWM and CSM_S_MCNET_SLAVE_NWM encapsulated
 *   with CSM_S_MCNET.
 * - Doxygen comments added.
 *
 * 05.02.08  \main\39  VTeam-Khler
 * - Lint warning removed by lint comment.
 *
 * 11.02.08  \main\40  VTeam-Prhl
 * - lint authorisation added.
 *
 * 21.02.08  \main\41  VTeam-Prhl
 * - lint authorisation added.
 *
 * 22.02.08  \main\42  VTeam-Prhl
 * - make doxygen happy.
 *
 * 16.04.08  \main\43 VTeam-Prhl
 * - some reviews done.
 *
 * 02.07.08  \main\44  VTeam-Zurmhl
 * - further functions reviewed (no changes in code, just formatting)
 *
 * 02.07.08  \main\45  VTeam-Zurmhl
 * - typo corrected
 *
 * 11.09.08  \main\46  VTeam-Funke/Basavaraj
 * - covered CSM_S_MCNET feature switch by CSM_S_CNP_AVAILABLE feature switch
 *
 * 13.10.09  \main\47  Prhl
 * - missing feature switch added.
 *
 * 22.01.10  \main\48  Prhl
 * - old IVLAN code disabled
 *
 * 22.01.10  \main\49  Prhl
 * - old IVLAN code disabled
 *
 * 25.01.10  \main\51  Prhl
 * - IVLAN interface added.
 *
 * 06.05.10  \main\52  Borck
 * - CNM_vCDADataCon() added, so that (indirekt) OSEKI NM can be hooked
 *
 * 22.09.10  \main\39\gm_next_gen\1  VTeam-Pistoor
 * - CNM_bCalculateBusState() is not able to handle more than one NM in parallel.
 *   Added if cases for GMLAN and OSEKNM.
 *
 * 23.12.10  \main\39\gm_next_gen\2  VTeam-Pistoor
 * - Removed LINT warnings
 *
 * 13.01.11  \main\39\gm_next_gen\3  VTeam-Pistoor
 * - Removed authorized LINT warnings
 *
 * 10.02.11  \main\55
 * - merged main\39\gm_next_gen\3 to trunc
 * - Added bus specific NM configuration table CNM_arCalculateBusState[] in CNM_bCalculateBusState()
 *
 * 09.03.11  \main\56  Feldhaus
 * - added include for J1939 header, if protocol is configured
 * - removed BusoffRecovery and BusoffEntry indications to CNM_J1939; this is completely
 *   handled in CNP now
 *
 * 11.03.11  \main\57  Khler
 * - Not used include csm_c.h commented out.
 * - Returnvalue handling in CNM_lBusoffEntry() and CNM_lGotoMode() changed.
 *
 * 15.03.11  \main\58  Borck
 * - CNM_vCDADataCon extended by the protocol type MPDT to be able to inform OSEKI NWM as well for bus off monitoring on MCAN
 *
 * 18.03.11  \main\59  Borck
 * - CNM_vCDADataCon extended to fix LINT warning if no CASE in switch.
 * - reviewed some stuff
 *
 * 19.04.11  \main\60  Borck
 * - CNM_bCalculateBusState reworked based on review findings from V.Koehler
 *
 * 03.05.11  \main\61  Borck
 * - another review finding (indention abnormality, V.Koehler) fixed
 * - OSEKI NM defines renamed and extended according to naming in Nissan docs
 *
 * 10.05.13  \main\62  Prhl
 * - VW NM HIGH integrated.
 *
 * 01.08.13  \main\63  Feldhaus
 * - moved VW NM HIGH state indications to csm_p.c
 *
 * 04.12.13  \main\64  Prhl
 * - only small lint fixes.
 *
 * 25.02.14  \main\65  Borck
 * - MPDT features are only available if CNP features are also -> fixed a compiler warning
 *
 * 04.03.15  \main\66  Pistoor
 * - removed IVLAN
 *
 * 29.09.15  \main\67  Borck
 * - small LINT fix
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
