/* Description and history of cda_i.h at the end of the file.                 */
#ifndef CDA_I_HEADER
/** File name for preprozessor commands */
#define CDA_I_HEADER

#include "cda_ip.h"        /* include project specific part */
/* no further includes allowed */


/*******************************************************************************
 * defines and macros (scope: CAN stack)
 ******************************************************************************/
/* defines for CDA_lActivate() */
#define CDA_C_LISTEN_ONLY        0
#define CDA_C_LISTEN_AND_SEND    1

/* defines for CDA_lDeActivate() */
#define CDA_C_SLEEP              0
#define CDA_C_STANDBY            1

/* errors for ubTransmitMessage */
#define CDA_ERR_TX_HANDLE 0x01
#define CDA_ERR_TX_BUSY   0x02

#if (CSM_S_CDA_SENDRESTRICTION == CSM_C_F_ON)
  #define CDA_C_SEND_RESTRICTION_MASK_NO      (0x00000000UL)    /**< used in CDA_vSetSendRestriction() to disable send restriction */
  #define CDA_C_SEND_RESTRICTION_MASK_ALL     (0xffffffffUL)    /**< used in CDA_vSetSendRestriction() to enable send restriction */
  /* #define CDA_C_SEND_RESTRICTION_MASK_... is defined in cda_ip.h */
#endif /* CSM_S_CDA_SENDRESTRICTION */

#if (CSM_S_CDA_FLAG_FOR_RX_FRAMES == CSM_C_F_ON)
  #ifdef CDA_SELF  /* extern declaration in the consuming module */
    BYTE CDA_bFrameReceivedFlags;  /* e.g. IVLAN Node Management has to know
                                    * in state ENTER_SLEEPMODE if message was
                                    * received. (bitfield, bit 0 = bus 0) */
  #else
    extern BYTE CDA_bFrameReceivedFlags;
  #endif
  /* CDA_bMessageReceivedFlags access makros */
  #define CDA_M_SET_FRAME_RECEIVED_FLAG(bBus)    CDA_bFrameReceivedFlags |= (BYTE)(0x01U << (bBus));   /**< set received bit for this bus */
  #define CDA_M_CLEAR_FRAME_RECEIVED_FLAG(bBus)  CDA_bFrameReceivedFlags &= ~(0x01U << (bBus));  /**< clear */
  #define CDA_M_IS_FRAME_RECEIVED_FLAG_SET(bBus) (CDA_bFrameReceivedFlags & (0x01U << (bBus)))    /**< check if flag is set */
#else /* feature switch CSM_S_CDA_FLAG_FOR_RX_FRAMES not set */
  /* do nothing */
  #define CDA_M_SET_FRAME_RECEIVED_FLAG(bBus)
  #define CDA_M_CLEAR_FRAME_RECEIVED_FLAG(bBus)
  /* CDA_M_IS_FRAME_RECEIVED_FLAG_SET(bBus) not defined to cause error if it shall be used but feature switch is not defined. */
#endif

/*******************************************************************************
 * typedefs (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition (scope: CAN stack)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: CAN stack and operating system)
 ******************************************************************************/

LONG CDA_lInit(BYTE bInitMode);
LONG CDA_lExit(BYTE bExitMode);
LONG CDA_lActivate(BYTE bBus, BYTE bTxRxMode);
LONG CDA_lDeActivate(BYTE bBus, BYTE bTranscMode, BYTE bContrMode);
INT  CDA_iCanInterruptsDisable(BYTE bBus);
VOID CDA_vCanInterruptsRestore(BYTE bBus, INT iInterruptStatus);
VOID CDA_vWakeupIrqEnable(BYTE bBus);
VOID CDA_vWakeupIrqDisable(BYTE bBus);
LONG CDA_lGetErrorState(BYTE bBus);
LONG CDA_lBusoffEntry(BYTE bBus);
LONG CDA_lBusoffRecovery(BYTE bBus);
LONG CDA_lSend(const CSM_CAN_TX_DATA* const prData);
VOID CDA_vProcessSend(VOID);
VOID CDA_vProcessDataInd(VOID);
VOID CDA_vProcessDataCon(VOID);
VOID CDA_vSetSendRestriction(BYTE bBus, DWORD dwMask);

VOID CDA_vEnableSendRestriction(BYTE bBus);
VOID CDA_vDisableSendRestriction(BYTE bBus);

#if (CSM_S_CDA_GLOBAL_MINDELAY == CSM_C_F_ON)
  VOID CDA_vGlobalTXMinDelayExpired(VOID);
#endif

#if(CSM_S_CNM_AVAILABLE == CSM_C_F_ON)
#if(CSM_S_RENAULT_NM == CSM_C_F_ON)
  extern VOID CNM_vCDADataConNoBusOff(VOID);
#endif
#endif

#else
  #error CDA_I.H included several times
#endif
/*******************************************************************************
 *                MODULE GROUPING INFORMATION FOR DOXYGEN
 * \doxydocu
 *
 * \defgroup      CDA   CDA (CAN Driver Access, Interface #5 and #6)
 *                This group contains all files which upper interface
 *                belongs to CSM interface #5 and #6.
 */
/**
 * \defgroup     CDA_CCD CDA_CCD (CAN Controller Driver, Interface #8)
 *                This group contains all files which upper interface
 *                belongs to CSM interface #8.
 * \ingroup      CDA
 *
 */
/**
 * \defgroup     CDA_TRX CDA_TRX (TRansceiver driver, Interface #9)
 *                This group contains all files which upper interface
 *                belongs to CSM interface #9.
 * \ingroup      CDA
 *
 */
/*******************************************************************************
 * \doxydocu
 * \file          cda_i.h
 * \brief         Interface #5 header definition.
 *
 *                Header of CAN driver access manager module.
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/modules_swa/cda/src/
 *
 * \ingroup       CDA
 *
 * \authors       CM-DI/ESA3-Name
 *
 * COPYRIGHT      (c) 2004 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 04.12.01  Rev. 0.1 CM-DI/ECC13-Pistoor
 *                Initial Version.
 * ...
 * 18.06.04  Rev. \main\4  CM-DI/ESU3-Prhl
 * - CDA_lSend() modified
 *
 * 09.07.04  Rev. \main\5  CM-DI/ESU3-K"ohler
 * - CDA Module status (OK/ERROR) defines removed.
 *   CSM_C_CAN_CONTROLLER_STATE_.. defines now in csm_stack_m.h.
 *
 * 27.07.04  \main\6  CM-DI/ESU3-Battis
 * - CDA_vProcessSend() and CDA_vProcessDataInd() added
 *
 * 29.09.04  \main\7  CM-DI/ESA3-Battis
 * - CDA_vEnableSendRestriction() and CDA_lDisableSendRestriction() added
 *
 * 17.01.05  \main\8  CM-DI/ESA3-K"ohler
 * - CDA_lCanRxTxErrInterruptDisableAndSave/Restore replaced by
 *   CDA_iCanInterruptsDisable/Restore.
 * - Doxygen comments added.
 *
 * 17.02.05  \main\9  CM-DI/ESA3-Battis
 * - min delay feature implemented
 *
 * 09.05.05  \main\10  CM-DI/ESA3-Battis
 * - changes to make MISRA happy
 *
 * 30.06.05  \main\11  CM-DI/ESA3-K"ohler
 * - Variable and macros for feature CSM_S_CDA_FLAG_FOR_RX_FRAMES added.
 *
 * 21.09.05  \main\12  CM-DI/ESA3-Battis
 * - code cleaned
 * - doxydoku reworked
 *
 * 18.08.06  \main\13  CM-DI/ESA3-K"ohler
 * - Defines LISTEN_ONLY, LISTEN_AND_SEND, SLEEP and STANDBY renamed CDA_C_...
 *
 * 29.03.07  \main\14  CM-DI/ESA3-Looby
 * - Added Prototype for Data Con form CDA, needed for Renault Bus-off, Bus mute.
 *
 * 15.05.07  \main\15  CM-DI/VTeam-Prhl
 * - spaces after # deleted
 *
 * 25.06.07  \main\16  CM-DI/VTeam-Prhl
 * - CDA_vSetSendRestriction() and corresponding defines added.
 *
 * 05.07.07  \main\17  VTeam-Prhl
 * - lint warnings removed or commented out.
 *
 * 21.01.08  \main\18  VTeam-Khler
 * - Doxygen defgroups moved from cda.c.
 * - Indentation changed.
 *
 * 29.09.08  \main\19  Prhl
 * - lint warning removed.
 *
 * 17.11.08  \main\20  Prhl
 * - function prototype CDA_vProcessDataCon() added.
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
