// Description and history of cbr_mp.h at the end of the file.
#ifndef CBR_MP_HEADER
// File name for preprozessor commands/
#define CBR_MP_HEADER

//*****************************************************************************
//* defines and macros (scope: CBR)
//*****************************************************************************
#define CBR_M_INIT_VARS()             // empty macro

#define CBR_LOCK_TX_DATA(OldFlag)     OldFlag=CSM_iInterruptsDisable();
#define CBR_UNLOCK_TX_DATA(OldFlag)   CSM_vInterruptsRestore( OldFlag);

#define CBR_LOCK_RX_DATA(OldFlag)     OldFlag=CSM_iInterruptsDisable();
#define CBR_UNLOCK_RX_DATA(OldFlag)   CSM_vInterruptsRestore( OldFlag);

#define CSM_M_GET_SIGNAL_ID_FROM_VIRTUAL_SIGNAL_ID(a) a   // in case no virtual signals are used
#define CSM_M_CHECK_FOR_VALID_SIGNAL_ID(a)            1   // in case no virtual signals are used

// Nissan probably does not require a timeout delay for the first RX
// Practically we assume that CSM is working after 200 ms, so this can be the
// delay for this project.
#define CBR_RXTIMEOUT_DELAY           200    // derived from ITG5, LCN2kai, etc.

#define CBR_TX_TIMEOUT                 50    // timeout to kick frame out of controller in lower CDA layer

//*****************************************************************************
//* variable definitions
//*****************************************************************************
#ifdef CBR_SELF    // map the following definitions into cbr.c to create instance variables

// --- definitions for Variant management ---
// the old RX/TX arrays have been replaced by a pointer with the same name !!
// this is possible since in C an array name IS the pointer to a storage location

// the pointers will be initialized with real values in csm_apl.c at runtime, here they are
// hold in the DATA segment and initialized with NULL
const CSM_CBR_RX   *         csm_arCbrRxTelegram   = NULL;   // Descriptions of all RX telegrams
const CSM_CBR_TX   *         csm_arCbrTxTelegram   = NULL;   // Descriptions of all TX telegrams

const CSM_TELEGRAM * const * cbr_arRxTelegramIndex = NULL;   // Pointer table with pointers to Telegram Signals
const CSM_TELEGRAM * const * cbr_arTxTelegramIndex = NULL;   // Pointer table with pointers to Telegram Signals

// new variables to be able to handle a variable amount of RX/TX message within the configuration
// they will be initialized with real values in csm_apl.c at runtime
BYTE  bCbrRxMaxNumber = 0;
BYTE  bCbrTxMaxNumber = 0;

#endif // CBR_SELF

#else // CBR_MP_HEADER
  #error CBR_MP.H included several times
#endif

/*******************************************************************************
 * \doxydocu
 * \file          cbr_mp.h
 * \brief         Project specific part of the module internal header of CBR
 *
 * \see           CAN-SW Architecture, written by CM-DI/ESA3
 *
 * \sw_component  CBR
 * \project       main
 * \path          /di_can/modules_swa/cbr/src/
 *
 * \ingroup       CBR
 *
 * \authors       CM-DI/VTeam
 *
 * COPYRIGHT:      (c) 2003 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 24.01.08  \main\7  VTeam-Zurmhl
 * - module history comment block added
 *
 * 24.01.08  \main\8  VTeam-Zurmhl
 * - #endif added
 *
 * 22.02.08  \main\9  VTeam-Prhl
 * - make doxygen happy.
 *
 * 18.03.08  \main\10 VTeam-Prhl
 * - MMS 184057 a)TDiagStart. berwachungsbeginn nach Wecken ber CAN whrend TWaitBusSleep-Zeit (700ms und 900ms nach Sleep_ACK) zu frh
 *     CBR_RXTIMEOUT_DELAY set to 3000
 *
 * 25.01.11  \main\11 Borck
 * - CBR_TX_TIMEOUT introduced and set to 50 ms (used to be passed to lowest CDA layer)
 *
 * 12.07.11  \main\12 Borck
 * - CBR_RXTIMEOUT_DELAY set to 200 ms since there is no requiremnet from Nissan for 3000 ms
 *
 * 21.04.15  \main\rn_aivi_proxy\1 Borck
 * - moved some stuff here from csm_stack_mp.h to allow a better sync between v850 and proxy version of that one
 *
 * 16.07.15  \main\rn_aivi_proxy\2 Borck
 * - SLOT based config introduced
 *
 * 22.09.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\1  A.Borck
 * - 2 new variables to handle different numbers of RX/TX messages
 * - Signal Abstraction Lite: support of 10 different configurations added (SLOT based)
 *
 * 08.10.15  \main\rn_aivi_proxy\rn_aivi_proxy_generated\2  A.Borck
 * - Mini Abstraction (CSM_S_CBR_ABSTRACT_SIGNALS) removed completely
 *
 * \history_end
 *//**** END OF FILE *************************************************************/
