/*****************************************************************************
| FILE:         ProcCsm.cpp
| PROJECT:      NISSAN LCN2kai
| SW-COMPONENT: Process
|-----------------------------------------------------------------------------
| DESCRIPTION:  Process Base Entry
|
|-----------------------------------------------------------------------------
| COPYRIGHT:    (c) 2016 Bosch Car Multimegia GmbH
| HISTORY:
| Date      | Modification                                    | Author
| 10.02.16  |                                                 | Kollai
|
| --.--.--  | ----------------           | -------, -----
|
|*****************************************************************************/
#include <algorithm>
#include <vector>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#include "csm_if.h"
#include "csm_stack_m.h"
#include "csm_access_krnl.h"

#include "ProcCsmMain.h"


#include<stdio.h>
#include<string.h>    //strlen
#include<stdlib.h>    //strlen
#include<sys/socket.h>
#include<arpa/inet.h> //inet_addr
#include<unistd.h>    //write
#include<pthread.h> //for threading , link with lpthread


// Trace class definition for ETG (extented trace generator).

#define TR_CLASS_CSMPROC (TR_COMP_CSM + 0x10)

#if (CSM_S_TRACE == CSM_C_F_ON)
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CSMPROC
#include "trcGenProj/Header/ProcCsmSocket.cpp.trc.h"
#endif
#endif


//the thread function
void *connection_handler(void *);

std::vector < int > _listOfClients;
static int _iMySocketId = -1;

//**************************************************************************************************
// function implementation
//**************************************************************************************************
//extern void vSignalDataChanged(DWORD dwSignalId, void * pvActSignalData, BYTE bDataBufferLength, DWORD dwSignalStatus);

void vCreateSocket() {

    int iPort = 2356;
    struct sockaddr_in server , client;

    _iMySocketId = socket(AF_INET , SOCK_STREAM , 0);
    if (_iMySocketId == -1) {
        ETG_TRACE_FATAL(("Could not create socket"));
    }
    ETG_TRACE_FATAL(("Socket created"));

    //Prepare the sockaddr_in structure
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;
    server.sin_port = htons( iPort );

    //Bind
    if( bind(_iMySocketId,(struct sockaddr *)&server , sizeof(server)) < 0)
    {
        //print the error message
        ETG_TRACE_FATAL(("bind failed. Error"));
        return;
    }
    ETG_TRACE_FATAL(("bind done"));
}

void vHandleSocketConnections() {
    int iClientSock , c , *piNewSocket;
    struct sockaddr_in server , client;

    //Listen
    listen(_iMySocketId , 3);

    //Accept and incoming connection
    ETG_TRACE_FATAL(("Waiting for incoming connections..."));
    c = sizeof(struct sockaddr_in);

    while( (iClientSock = accept(_iMySocketId, (struct sockaddr *)&client, (socklen_t*)&c)) ) {
        ETG_TRACE_FATAL(("Connection accepted"));

        pthread_t sniffer_thread;
        piNewSocket = (int*)malloc(1);
        *piNewSocket = iClientSock;

        if( pthread_create( &sniffer_thread , NULL ,  connection_handler , (void*) piNewSocket) < 0)
        {
            ETG_TRACE_FATAL(("could not create thread"));
            return;
        }

        //Now join the thread , so that we dont terminate before the thread
        //pthread_join( sniffer_thread , NULL);
        ETG_TRACE_FATAL(("Handler assigned"));
    }

}

static tU8 _u8Buf[400];
static tU32 _u32TsSendDataReq = 0xffffffff;

void vDataReqReSend2Host();
/*
* This will handle connection for each client
* */
void *connection_handler(void *piClientSock)
{
    //Get the socket descriptor
    int iClientSock = *(int*)piClientSock;
    int read_size;
    char *message , client_message[2000];

    _listOfClients.push_back(iClientSock);

    //Receive a message from client
    while( (read_size = recv(iClientSock , client_message , 2000 , 0)) > 0 ) {

        ETG_TRACE_USR4(("ClientMessageReceived: data: '%s' ", client_message));

        char* pCurPos = client_message;
        while (pCurPos < (client_message + read_size)) {

            ETG_TRACE_USR4(("ClientMessageReceived: message: '%s' ", pCurPos));

            //get pointer to message
            char* pStartOfFrame = pCurPos;
            char* pStartOfMessage = strchr(pStartOfFrame, ':');

            //replace ":" with "0", increment pointer to point to start of message and finally extract length of message
            pStartOfMessage[0] = 0;
            pStartOfMessage += 1;
            tU8 u8SingleMsgDataLen =  atoi(pStartOfFrame);

            ETG_TRACE_USR4(("ClientMessageReceived: message w/o length: '%s' ", pStartOfMessage));

            // first byte is len of message
            char* pStartOfData = strchr(pStartOfMessage, ':');

            ETG_TRACE_USR4(("ClientMessageReceived: start of data: '%s' ", pStartOfData));
            int iCmd = 255;
            if (pStartOfData != NULL) {
                //replace ":" with "0", increment pointer to point to start of data and finally extract command ID
                pStartOfData[0] = 0;
                pStartOfData += 1;
                pCurPos = pStartOfData + (2*u8SingleMsgDataLen);

                iCmd = atoi(pStartOfMessage);

                ETG_TRACE_USR4(("ClientMessageReceived: Command: %d (sock: %d), data: '%s' ", iCmd, iClientSock, pStartOfData));
                switch (iCmd) {
                case CSM_SOCKET_MSG_TYPE_RX_WDT:
                    {
                        //send wathdog message back
                        tU8 u8Buf[2] = {2, CSM_SOCKET_MSG_TYPE_TX_WDT};
                        std::vector < int >::iterator pos;
                        for (pos = _listOfClients.begin(); pos != _listOfClients.end(); ++pos){
                            write(*pos , u8Buf , u8Buf[0]);
                        }

                    }
                    break;
                case CSM_SOCKET_MSG_TYPE_RX_SIG_BROADCAST:
                    {
                        tU8 au8Data[400] = {0};
                        tU8 u8Count = 0;
                        for (tU16 i=0; i<u8SingleMsgDataLen;i++) {
                            char cData[3]={pStartOfData[2*i], pStartOfData[(2*i)+1], 0};
                            au8Data[i] = strtol(cData, NULL, 16);
                            u8Count++;
                        }
                        //and now extract values
                        tU32 u32SignalId = (au8Data[0] << 24) | (au8Data[1] << 16) | (au8Data[2] << 8) | au8Data[3];
                        tU32 u32SignalStatus = (au8Data[4] << 24) | (au8Data[5] << 16) | (au8Data[6] << 8) | au8Data[7];
                        vSignalDataChanged(u32SignalId, &au8Data[8], u8Count-8, u32SignalStatus);

                        //and now loopback this message to all connected hosts
                        tU8 au8LoopbackData[400] = {0};

                        au8LoopbackData[0] = u8Count + 2;
                        au8LoopbackData[1] = CSM_SOCKET_MSG_TYPE_TX_LOOPBACK_RX_SIG;
                        memcpy(&au8LoopbackData[2], &au8Data[0], u8Count);

                        std::vector < int >::iterator pos;
                        for (pos = _listOfClients.begin(); pos != _listOfClients.end(); ++pos){
                            write(*pos , au8LoopbackData , au8LoopbackData[0]);
                        }

                    }
                    break;
                case CSM_SOCKET_MSG_TYPE_RX_COMMUNICATION_CONF:
                    {
                        tU8 au8Data[400] = {0};
                        tU8 u8Count = 0;
                        for (tU16 i=0; i<u8SingleMsgDataLen;i++) {
                            char cData[3]={pStartOfData[2*i], pStartOfData[(2*i)+1], 0};
                            au8Data[i] = strtol(cData, NULL, 16);
                            u8Count++;
                        }
                        //and now extract values

                        tU8 u8Bus = au8Data[0];
                        tU32 u32ProtocolType = (au8Data[1] << 24) | (au8Data[2] << 16) | (au8Data[3] << 8) | au8Data[4];

                        tU8 u8LocalId = au8Data[5];
                        tU8 u8RemoteId = au8Data[6];

                        tU8 u8ConnectState = au8Data[7];
                        tU16 u16ApplId = (au8Data[8] << 8) | au8Data[9];

                        vCommunicationConfirmation(u8Bus, u32ProtocolType, u8LocalId, u8RemoteId, u8ConnectState, u16ApplId);

                    }
                    break;
                case CSM_SOCKET_MSG_TYPE_RX_DATA_CONF:
                    {
            _u32TsSendDataReq = 0xffffffff;
                        tU8 au8Data[400] = {0};
                        tU8 u8Count = 0;
                        for (tU16 i=0; i<u8SingleMsgDataLen;i++) {
                            char cData[3]={pStartOfData[2*i], pStartOfData[(2*i)+1], 0};
                            au8Data[i] = strtol(cData, NULL, 16);
                            u8Count++;
                        }
                        //and now extract values

                        tU32 u32ProtocolType = (au8Data[0] << 24) | (au8Data[1] << 16) | (au8Data[2] << 8) | au8Data[3];

                        tU8 u8LocalId = au8Data[4];
                        tU8 u8RemoteId = au8Data[5];

                        vDataConfirmation(u32ProtocolType, u8LocalId, u8RemoteId, 0);

                    }
                    break;
                case CSM_SOCKET_MSG_TYPE_RX_DATA_IND:
                    {
                        tU8 au8Data[400] = {0};
                        tU8 u8Count = 0;
                        for (tU16 i=0; i<u8SingleMsgDataLen;i++) {
                            char cData[3]={pStartOfData[2*i], pStartOfData[(2*i)+1], 0};
                            au8Data[i] = strtol(cData, NULL, 16);
                            u8Count++;
                        }
                        //and now extract values
                        tU32 u32ProtocolType = (au8Data[0] << 24) | (au8Data[1] << 16) | (au8Data[2] << 8) | au8Data[3];

                        tU8 u8LocalId = au8Data[4];
                        tU8 u8RemoteId = au8Data[5];

                        vDataIndication(u32ProtocolType, u8LocalId, u8RemoteId, &au8Data[6], u8Count-6);

                    }
                    break;


                default:
                    write(iClientSock , client_message , strlen(client_message));
                    ETG_TRACE_FATAL(("ClientMessageReceived: Unknown commad: %d", iCmd));
                    break;
                } // switch
            } else {
                //Send the message back to client
                write(iClientSock , client_message , strlen(client_message));
                ETG_TRACE_FATAL(("ClientMessageReceived: Cannot interpret: '%s'", client_message));

                //invalid message --> send back
                pCurPos = (client_message + read_size);
            } // if

          if ( (_u32TsSendDataReq != 0xffffffff)  && ((_u32TsSendDataReq+1000) < OSAL_ClockGetElapsedTime())) {
                ETG_TRACE_FATAL(("Client disconnected"));
                vDataReqReSend2Host();
            }
        } // while message

        memset(client_message, 0, 2000);
    }

    if(read_size == 0) {
        ETG_TRACE_FATAL(("Client disconnected"));
    } else if(read_size == -1) {
        ETG_TRACE_FATAL(("recv failed"));
    }

    //
    std::vector < int >::iterator pos = std::find(_listOfClients.begin(), _listOfClients.end(), iClientSock);
    if (pos  != _listOfClients.end() ) {
        _listOfClients.erase(pos);
    }

    //Free the socket pointer
    free(piClientSock);

    return 0;
}

void vSignalWrite2Host(DWORD dwSignalId, const void * pvNewSignalData, BYTE bDataBufferLength, BYTE bTxType) {

    tU8 u8Buf[40] = {0};

    u8Buf[1] = CSM_SOCKET_MSG_TYPE_TX_SIG_BROADCAST;

    u8Buf[2] = (tU8)((dwSignalId & 0xff000000) >> 24);
    u8Buf[3] = (tU8)((dwSignalId & 0x00ff0000) >> 16);
    u8Buf[4] = (tU8)((dwSignalId & 0x0000ff00) >>  8);
    u8Buf[5] = (tU8)((dwSignalId & 0x000000ff) >>  0);
    u8Buf[6] = (tU8)bTxType;

    memcpy(&u8Buf[7], pvNewSignalData, bDataBufferLength);

    u8Buf[0] = bDataBufferLength + 7;

    std::vector < int >::iterator pos;
    for (pos = _listOfClients.begin(); pos != _listOfClients.end(); ++pos){
        ETG_TRACE_USR1(("vSignalWrite2Host(): %08x", dwSignalId));
        write(*pos , u8Buf , u8Buf[0]);
    }
}

void vCommunicationReq2Host(BYTE bBus, DWORD dwProtocolType, BYTE bLocalId, BYTE bRemoteId, BYTE bAction, WORD wApplID) {

    tU8 u8Buf[50] = {0};

    u8Buf[1] = CSM_SOCKET_MSG_TYPE_TX_COMMUNICATION_RQ;

    u8Buf[2] = bBus;

    u8Buf[3] = (tU8)((dwProtocolType & 0xff000000) >> 24);
    u8Buf[4] = (tU8)((dwProtocolType & 0x00ff0000) >> 16);
    u8Buf[5] = (tU8)((dwProtocolType & 0x0000ff00) >>  8);
    u8Buf[6] = (tU8)((dwProtocolType & 0x000000ff) >>  0);

    u8Buf[7] = bLocalId;
    u8Buf[8] = bRemoteId;
    u8Buf[9] = bAction;

    u8Buf[10] = (tU8)((wApplID & 0xff00) >>  8);
    u8Buf[11] = (tU8)((wApplID & 0x00ff) >>  0);

    u8Buf[0] = 12;
    std::vector < int >::iterator pos;
    for (pos = _listOfClients.begin(); pos != _listOfClients.end(); ++pos){
        ETG_TRACE_USR1(("vCommunicationReq2Host(): LocalId: %d, RemoteId: %d. ",bLocalId , bRemoteId));
        write(*pos , u8Buf , u8Buf[0]);
    }
}

void vDataReq2Host(DWORD dwProtocolType, BYTE bLocalId, BYTE bRemoteId, const void * pvData, WORD wDataBufferLength) {

    memset(_u8Buf, 0, 400);

    _u8Buf[1] = CSM_SOCKET_MSG_TYPE_TX_DATA_RQ;

    _u8Buf[2] = (tU8)((dwProtocolType & 0xff000000) >> 24);
    _u8Buf[3] = (tU8)((dwProtocolType & 0x00ff0000) >> 16);
    _u8Buf[4] = (tU8)((dwProtocolType & 0x0000ff00) >>  8);
    _u8Buf[5] = (tU8)((dwProtocolType & 0x000000ff) >>  0);

    _u8Buf[6] = bLocalId;
    _u8Buf[7] = bRemoteId;

    memcpy(&_u8Buf[8], pvData, wDataBufferLength);

    _u8Buf[0] = wDataBufferLength + 8;

    std::vector < int >::iterator pos;
    for (pos = _listOfClients.begin(); pos != _listOfClients.end(); ++pos){
        ETG_TRACE_USR1(("vDataReq2Host(): LocalId: %d, RemoteId: %d. ",bLocalId , bRemoteId));
        write(*pos , _u8Buf , _u8Buf[0]);
    }

  ETG_TRACE_FATAL(("Client disconnected: %d %d", _u32TsSendDataReq, OSAL_ClockGetElapsedTime()));
  _u32TsSendDataReq = OSAL_ClockGetElapsedTime();
}
void vDataReqReSend2Host() {
    std::vector < int >::iterator pos;
    for (pos = _listOfClients.begin(); pos != _listOfClients.end(); ++pos){
        write(*pos , _u8Buf , _u8Buf[0]);
    }

  ETG_TRACE_FATAL(("Client disconnected: %d %d", _u32TsSendDataReq, OSAL_ClockGetElapsedTime()));
  _u32TsSendDataReq = OSAL_ClockGetElapsedTime();
}

/************************************************************************
|end of file ProcBase.cpp
|-----------------------------------------------------------------------*/

