#include <algorithm>
#include <vector>
#include <map>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#include "csm_if.h"
#include "csm_stack_m.h"
#include "csm_access_krnl.h"
#include "csm_m.h"

#include "ProcCsmMain.h"

#define TR_CLASS_CSMPROC (TR_COMP_CSM + 0x10)

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CSMPROC
#include "trcGenProj/Header/ProcCsmProxy.cpp.trc.h"
#endif

typedef struct
{
    tCSM_PFN_CBR_SIGNAL_IND pfvSignalInd1;
    void * pvHandle;
}_TCsmCallbackInfo;

typedef std::vector < _TCsmCallbackInfo > TVecSignalCallbackList;

typedef struct
{
    tU8     au8Data[8];
    tU8     u8Len;
    tU32    u32Status;
    TVecSignalCallbackList oListOfCallbacks;
}_TCsmSignal;

typedef std::map < DWORD, _TCsmSignal > TMapSignalInfo;

static TMapSignalInfo _oMapBroadcastSignals;

typedef struct
{
    BYTE   bLocalId;
    BYTE   bRemoteId;
    DWORD  dwProtocolType;
    BYTE   bBus;

    tCSM_PFN_TP_COMMUNICATION_CON pfvCommunicationCon;
    tCSM_PFN_TP_COMMUNICATION_IND pfvCommunicationInd;
    tCSM_PFN_TP_DATA_CON pfvCDataCon;
    tCSM_PFN_TP_DATA_IND pfvCDataInd;
    tCSM_PFN_TP_DATA_CON pfvDDataCon;
    tCSM_PFN_TP_DATA_IND pfvDDataInd;



    tCSM_MPDT_APPL_CALLBACK* pvCallBackFkt;

    void * pvHandle;
}_TCsmMpdtCallbackInfo;

typedef std::vector < _TCsmMpdtCallbackInfo > TVecMpdtCallbackList;
static TVecMpdtCallbackList _oMpdtAppInfoList;


void addSignaltoMap(DWORD  dwSignalId) {
    TMapSignalInfo::iterator it = _oMapBroadcastSignals.find(dwSignalId);
    if(it == _oMapBroadcastSignals.end() ){
        ETG_TRACE_USR1(("ProcCsmSimu: CSM_lSignalCallbackInit(): Signal currently unknown --> add to map now!"));

        _TCsmSignal tNewSig;
        memset(tNewSig.au8Data, 0, 8);
        tNewSig.u8Len = 0;
        tNewSig.u32Status = CSM_C_SIGNAL_NOT_RECEIVED;
        tNewSig.oListOfCallbacks.clear();
        _oMapBroadcastSignals[dwSignalId] = tNewSig;
    }
}

void addMpdtApplicationInfo(void * pvHandle, BYTE bBus, DWORD dwProtocolType, const void * pvAddressField, const void * pvCallBackFkt) {

    tCSM_ADDR_MPDT* pMpdtAddressField = (tCSM_ADDR_MPDT *) pvAddressField;

    _TCsmMpdtCallbackInfo oNewMpdtElement;

    oNewMpdtElement.pvHandle              = pvHandle;
    oNewMpdtElement.bLocalId              = pMpdtAddressField->bLocalComp;
    oNewMpdtElement.bRemoteId             = pMpdtAddressField->bRemoteComp;
    oNewMpdtElement.dwProtocolType        = dwProtocolType;
    oNewMpdtElement.bBus                  = bBus;

    oNewMpdtElement.pfvCommunicationCon   = ((tCSM_MPDT_APPL_CALLBACK*)pvCallBackFkt)->pfvCommunicationCon;
    oNewMpdtElement.pfvCommunicationInd   = ((tCSM_MPDT_APPL_CALLBACK*)pvCallBackFkt)->pfvCommunicationInd;
    oNewMpdtElement.pfvCDataCon           = ((tCSM_MPDT_APPL_CALLBACK*)pvCallBackFkt)->pfvCDataCon;
    oNewMpdtElement.pfvCDataInd           = ((tCSM_MPDT_APPL_CALLBACK*)pvCallBackFkt)->pfvCDataInd;
    oNewMpdtElement.pfvDDataCon           = ((tCSM_MPDT_APPL_CALLBACK*)pvCallBackFkt)->pfvDDataCon;
    oNewMpdtElement.pfvDDataInd           = ((tCSM_MPDT_APPL_CALLBACK*)pvCallBackFkt)->pfvDDataInd;

    ETG_TRACE_FATAL(("ProcCsmSimu: addMpdtApplicationInfo(): Bus: %d, Protocol: %d, LocalID: %d, Remote: %d!", bBus, dwProtocolType, oNewMpdtElement.bLocalId, oNewMpdtElement.bRemoteId));
    _oMpdtAppInfoList.push_back(oNewMpdtElement);



}

CSM_API LONG CSM_lGetCommunicationState(BYTE  bBus, DWORD dwProtocolType, const void * pvAddressField, BYTE * pbConnectState, WORD wApplId)
{
    LONG  lRet = CSM_M_MAKE_CSM_ERROR(CSM_C_ERR_WARNING, CSM_E_INIT_WARNING);
    return lRet;
}

CSM_API LONG CSM_lSignalRead(DWORD  dwSignalId, void * pvActSignalData, BYTE bDataBufferLength, DWORD * pdwSignalStatus)
{
    LONG lRet = CSM_M_MAKE_CSM_ERROR(CSM_C_ERR_WARNING, CSM_E_INIT_WARNING);;

    ETG_TRACE_USR4(("ProcCsmSimu: CSM_lSignalRead(): signal %08x!", dwSignalId));

    addSignaltoMap(dwSignalId);

    TMapSignalInfo::iterator it = _oMapBroadcastSignals.find(dwSignalId);
    if(it != _oMapBroadcastSignals.end() ){
        ETG_TRACE_USR4(("ProcCsmSimu: CSM_lSignalRead(): Send signal back with status %08x!", it->second.u32Status));
        if ((it->second.u8Len != 0) && (bDataBufferLength>=it->second.u8Len)){
            memcpy(pvActSignalData, it->second.au8Data, it->second.u8Len);
        }
        *pdwSignalStatus =  it->second.u32Status;
        lRet = CSM_C_NO_ERROR;
    }



    return lRet;
}

CSM_API LONG CSM_lDataRead(DWORD dwProtocolType, const VOID * pvAddressField, BYTE * pbData, WORD wDataLength)
{
    LONG lRet = CSM_C_NO_ERROR;
    if ((dwProtocolType == CSM_C_PTYPE_DC_USDT_ISO))
    {
        tCSM_ADDR_MPDT* pMpdtAddressField = (tCSM_ADDR_MPDT *) pvAddressField;
        ETG_TRACE_FATAL(("ProcCsmSimu: CSM_lDataRead(): MPDT: Protocol: %d, LocalID: %d, Remote: %d, data: %*x", dwProtocolType, pMpdtAddressField->bLocalComp, pMpdtAddressField->bRemoteComp, ETG_LIST_LEN(wDataLength), ETG_LIST_PTR_T8((tU8*)pbData)));
    }
    return lRet;
}


CSM_API LONG CSM_lConTest (DWORD dwProtocolType, void* pvAdressField, BYTE  bAction)
{
    LONG lRet = CSM_M_MAKE_CSM_ERROR(CSM_C_ERR_WARNING, CSM_E_INIT_WARNING);
    return lRet;
}

CSM_API LONG CSM_lCommunicationReq(BYTE bBus, DWORD dwProtocolType, const void * pvAddressField, BYTE bAction, WORD wApplID)
{
    LONG  lRet = CSM_C_NO_ERROR;
    if ((dwProtocolType == CSM_C_PTYPE_DC_USDT_ISO))
    {
        tCSM_ADDR_MPDT* pMpdtAddressField = (tCSM_ADDR_MPDT *) pvAddressField;
        ETG_TRACE_FATAL(("ProcCsmSimu: CSM_lCommunicationReq(): MPDT: Bus: %d, Protocol: %d, LocalID: %d, Remote: %d, Action: %d, ApplId: %d", bBus, dwProtocolType, pMpdtAddressField->bLocalComp, pMpdtAddressField->bRemoteComp, bAction, wApplID));
        vCommunicationReq2Host(bBus, dwProtocolType, pMpdtAddressField->bLocalComp, pMpdtAddressField->bRemoteComp, bAction, wApplID);
    }
    return lRet;
}

CSM_API LONG CSM_lSignalWrite(DWORD dwSignalId, const void * pvNewSignalData, BYTE bDataBufferLength, BYTE bTxType)
{
    LONG lRet = CSM_C_NO_ERROR;
    vSignalWrite2Host(dwSignalId, pvNewSignalData, bDataBufferLength, bTxType);
    return lRet;
}

CSM_API LONG CSM_lDataReq(DWORD dwProtocolType, const void * pvAddressField, const BYTE * pbData, WORD wDataLength)
{
    /* Default return value Error                                               */
    LONG lRet = CSM_C_NO_ERROR;
    if ((dwProtocolType == CSM_C_PTYPE_DC_USDT_ISO))
    {
        tCSM_ADDR_MPDT* pMpdtAddressField = (tCSM_ADDR_MPDT *) pvAddressField;
        ETG_TRACE_FATAL(("ProcCsmSimu: CSM_lDataReq(): MPDT: Protocol: %d, LocalID: %d, Remote: %d,  data: %*x", dwProtocolType, pMpdtAddressField->bLocalComp, pMpdtAddressField->bRemoteComp, ETG_LIST_LEN(wDataLength), ETG_LIST_PTR_T8((tU8*)pbData)));
        vDataReq2Host(dwProtocolType, pMpdtAddressField->bLocalComp, pMpdtAddressField->bRemoteComp, pbData, wDataLength);
    }
    return lRet;
}

CSM_API LONG CSM_lDataIndProcessed(DWORD dwProtocolType, const void * pvAddressField)
{
    LONG lRet = CSM_M_MAKE_CSM_ERROR(CSM_C_ERR_WARNING, CSM_E_INIT_WARNING);
    return lRet;
}


CSM_API LONG CSM_lApplCallbackInit(void * pvHandle, BYTE bBus, DWORD dwProtocolType,
                                   const void * pvAddressField, const void * pvCallBackFkt)
{
    /* default return is "no error"                                             */
    LONG lRet = CSM_C_NO_ERROR;

    if ((dwProtocolType == CSM_C_PTYPE_DC_USDT_ISO))
    {
        addMpdtApplicationInfo(pvHandle, bBus, dwProtocolType, pvAddressField, pvCallBackFkt);
    }

    return lRet;
}

CSM_API LONG CSM_lSignalCallbackInit(void * pvHandle, DWORD dwSignalId, tCSM_PFN_CBR_SIGNAL_IND vPFNCBRSignalInd)
{
    LONG lRet= CSM_M_MAKE_CSM_ERROR(CSM_C_ERR_WARNING, CSM_E_RESOURCE);
    ETG_TRACE_FATAL(("ProcCsmSimu: CSM_lSignalCallbackInit(): signal %08x!", dwSignalId));

    addSignaltoMap(dwSignalId);

    TMapSignalInfo::iterator it = _oMapBroadcastSignals.find(dwSignalId);
    if(it != _oMapBroadcastSignals.end() ){
        ETG_TRACE_USR1(("ProcCsmSimu: CSM_lSignalCallbackInit(): Callback added!"));
        _TCsmCallbackInfo tNewCallback = {vPFNCBRSignalInd, pvHandle};
        it->second.oListOfCallbacks.push_back(tNewCallback);
        lRet = CSM_C_NO_ERROR;
    }
    return lRet;
}

CSM_API LONG CSM_lBusErrorIndCallbackInit(void * pvHandle, tCSM_PFN_BUS_ERROR_IND vPFNBusErrorInd)
{
    LONG lRet = CSM_M_MAKE_CSM_ERROR(CSM_C_ERR_WARNING, CSM_E_RESOURCE);
    return lRet;
}


void vSignalDataChanged(DWORD dwSignalId, void * pvActSignalData, BYTE bDataBufferLength, DWORD dwSignalStatus) {

    ETG_TRACE_FATAL(("ProcCsmSimu: vSignalDataChanged(): signal %08x, data: 0x%02x (len: %d)!", dwSignalId, ((tU8*)pvActSignalData)[0], bDataBufferLength));

    addSignaltoMap(dwSignalId);


    TMapSignalInfo::iterator it = _oMapBroadcastSignals.find(dwSignalId);
    if(it != _oMapBroadcastSignals.end() ){
        ETG_TRACE_FATAL(("ProcCsmSimu: vSignalDataChanged(): Call registered clients!"));
        if (bDataBufferLength <= 8) {
            memcpy(it->second.au8Data, pvActSignalData, bDataBufferLength);
            it->second.u8Len = bDataBufferLength;
        }
        it->second.u32Status = dwSignalStatus;

        TVecSignalCallbackList::iterator itVec;
        for (itVec = it->second.oListOfCallbacks.begin(); itVec != it->second.oListOfCallbacks.end(); itVec++) {
            itVec->pfvSignalInd1( itVec->pvHandle , dwSignalId, dwSignalStatus);
        }
    }
}

void vCommunicationConfirmation(tU8 u8Bus, tU32 u32ProtocolType, tU8 u8LocalId, tU8 u8RemoteId, tU8 u8ConnectState, tU16 u16ApplId) {
    TVecMpdtCallbackList::iterator itVec;
    ETG_TRACE_FATAL(("ProcCsmSimu: vCommunicationConfirmation(): Bus: %d, Protocol: %d, LocalID: %d, Remote: %d!, State: %d, ApplId: %d", u8Bus, u32ProtocolType, u8LocalId, u8RemoteId, u8ConnectState, u16ApplId));

    for (itVec = _oMpdtAppInfoList.begin(); itVec != _oMpdtAppInfoList.end(); itVec++) {
        if ( (itVec->bLocalId == u8LocalId) && (itVec->bRemoteId == u8RemoteId) && (itVec->dwProtocolType == u32ProtocolType)) {
            ETG_TRACE_FATAL(("ProcCsmSimu: vCommunicationConfirmation(): Call registered clients!"));
            if (itVec->pfvCommunicationCon != NULL) {
                tCSM_ADDR_MPDT oMpdtAddressField;
                oMpdtAddressField.bLocalComp = u8LocalId;
                oMpdtAddressField.bRemoteComp = u8RemoteId;

                itVec->pfvCommunicationCon( itVec->pvHandle , u8Bus, u32ProtocolType, (const tVoid* )&oMpdtAddressField, u8ConnectState, u16ApplId);
            }
        }
    }
}

void vDataConfirmation(tU32 u32ProtocolType, tU8 u8LocalId, tU8 u8RemoteId, tU8 u8TransferResult) {
    TVecMpdtCallbackList::iterator itVec;
    ETG_TRACE_FATAL(("ProcCsmSimu: vDataConfirmation(): Bus: %d, Protocol: %d, LocalID: %d, Remote: %d", u32ProtocolType, u8LocalId, u8RemoteId, u8TransferResult));

    for (itVec = _oMpdtAppInfoList.begin(); itVec != _oMpdtAppInfoList.end(); itVec++) {
        if ( (itVec->bLocalId == u8LocalId) && (itVec->bRemoteId == u8RemoteId) && (itVec->dwProtocolType == u32ProtocolType)) {
            ETG_TRACE_FATAL(("ProcCsmSimu: vDataConfirmation(): Call registered clients!"));
            if (itVec->pfvCDataCon != NULL) {
                tCSM_ADDR_MPDT oMpdtAddressField;
                oMpdtAddressField.bLocalComp = u8LocalId;
                oMpdtAddressField.bRemoteComp = u8RemoteId;

                itVec->pfvCDataCon( itVec->pvHandle , u32ProtocolType, (const tVoid* )&oMpdtAddressField, u8TransferResult);
            }
        }
    }
}

void vDataIndication(tU32 u32ProtocolType, tU8 u8LocalId, tU8 u8RemoteId, void * pvActData, WORD wDataBufferLength) {
    TVecMpdtCallbackList::iterator itVec;
    ETG_TRACE_FATAL(("ProcCsmSimu: vDataIndication(): Protocol: %d, LocalID: %d, Remote: %d, data: %*x", u32ProtocolType, u8LocalId, u8RemoteId, ETG_LIST_LEN(wDataBufferLength), ETG_LIST_PTR_T8((tU8*)pvActData)));

    for (itVec = _oMpdtAppInfoList.begin(); itVec != _oMpdtAppInfoList.end(); itVec++) {
        if ( (itVec->bLocalId == u8LocalId) && (itVec->bRemoteId == u8RemoteId) && (itVec->dwProtocolType == u32ProtocolType)) {
            ETG_TRACE_FATAL(("ProcCsmSimu: vDataIndication(): Call registered clients!"));
            if (itVec->pfvCDataInd != NULL) {
                tCSM_ADDR_MPDT oMpdtAddressField;
                oMpdtAddressField.bLocalComp = u8LocalId;
                oMpdtAddressField.bRemoteComp = u8RemoteId;

                itVec->pfvCDataInd( itVec->pvHandle , u32ProtocolType, (const tVoid* )&oMpdtAddressField, (BYTE *)pvActData, wDataBufferLength);
            }
        }
    }
}


void vInitSignalsFromRegistry() {

    { // first load registry
        OSAL_tIODescriptor  regHandle;
        if((regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY,OSAL_EN_READWRITE)) != OSAL_ERROR )
        {
            if((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG,(tS32)"/dev/root/opt/bosch/base/registry/proccsmsiginit.reg")) == OSAL_OK)
            {
                ETG_TRACE_FATAL(("REGISTRY loaded '/opt/bosch/base/registry/proccsmsiginit.reg'!"));

            } else {
                ETG_TRACE_FATAL(("!!!!!!!!!! FAILED to load REGISTRY  '/opt/bosch/base/registry/proccsmsiginit.reg'!"));
            }
        }
        OSAL_s32IOClose(regHandle);
    }

    OSAL_tIODescriptor fdReg;
    OSAL_trIOCtrlDir   rDirProc;

    fdReg = OSAL_IOOpen("/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/PROCESS/PROCCSM/BCAST_INIT", OSAL_EN_READONLY);
    if (fdReg != OSAL_ERROR){

        /* First, recursively show all the subkeys */
        rDirProc.fd        = fdReg;
        rDirProc.s32Cookie = 0;

        while (OSAL_s32IOControl(fdReg, OSAL_C_S32_IOCTRL_REGENUMVALUE, ( tS32 ) & rDirProc) != OSAL_ERROR){
            OSAL_trIOCtrlRegistryValue rReadVal;
            rReadVal.s32Type = OSAL_C_S32_VALUE_STRING;
            OSAL_szStringNCopy(rReadVal.s8Name, rDirProc.dirent.s8Name, sizeof( rReadVal.s8Name ) );

            if (OSAL_s32IOControl(fdReg, OSAL_C_S32_IOCTRL_REGREADVALUE, ( tS32 ) & rReadVal) != OSAL_ERROR){

                if (rReadVal.s32Type == OSAL_C_S32_VALUE_STRING){
                    tU32 u32ProcNb;
                    tChar* pStartData = (tChar*)rReadVal.s8Value;

                    tU8 au8Data[400] = {0};
                    tU8 u8Count = 0;
                    for (tU16 i=0; i<strlen(pStartData)/2;i++) {
                        char cData[3]={pStartData[2*i], pStartData[(2*i)+1], 0};
                        au8Data[i] = strtol(cData, NULL, 16);
                        u8Count++;
                    }
                    //and now extract values
                    tU32 u32SignalId = (au8Data[0] << 24) | (au8Data[1] << 16) | (au8Data[2] << 8) | au8Data[3];
                    tU32 u32SignalStatus = (au8Data[4] << 24) | (au8Data[5] << 16) | (au8Data[6] << 8) | au8Data[7];

                    vSignalDataChanged(u32SignalId, &au8Data[8], u8Count-8, u32SignalStatus);

                } else {
                    ETG_TRACE_FATAL( ( "VAL unkown: '%30s': unknown type %d", (const tChar*)rDirProc.dirent.s8Name, rReadVal.s32Type ) );
                }
            }
        }
    }
}
CSM_API LONG CSM_lMultipleSignalRead(tCSM_MultipleSignalRead * prSignalList, const BYTE  bNumberOfSignals)
{
  LONG lRet = CSM_M_MAKE_CSM_ERROR(CSM_C_ERR_WARNING, CSM_E_INIT_WARNING);

    return lRet;
}

CSM_API LONG CSM_lMultipleSignalWrite(const tCSM_MultipleSignalWrite * prSignalList, const BYTE bNumberOfSignals)
{
  LONG lRet = CSM_M_MAKE_CSM_ERROR(CSM_C_ERR_WARNING, CSM_E_INIT_WARNING);

    return lRet;
}

/*##### HISTORY BEGIN ##########
*
* 24.11.17  main\g3inf4cv_csm_proxy_in\1  Jayashree
* - Initial version for INF4CV
*
 ##### HISTORY END ########## */
