#ifndef CSM_PROC_MAIN_HEADER
#define CSM_PROC_MAIN_HEADER

#define CSM_SOCKET_MSG_TYPE_TX_SIG_BROADCAST       0
#define CSM_SOCKET_MSG_TYPE_TX_COMMUNICATION_RQ    1
#define CSM_SOCKET_MSG_TYPE_TX_DATA_RQ             2
#define CSM_SOCKET_MSG_TYPE_TX_LOOPBACK_RX_SIG     254
#define CSM_SOCKET_MSG_TYPE_TX_WDT                 255

#define CSM_SOCKET_MSG_TYPE_RX_SIG_BROADCAST       5
#define CSM_SOCKET_MSG_TYPE_RX_COMMUNICATION_IND   6
#define CSM_SOCKET_MSG_TYPE_RX_COMMUNICATION_CONF  7
#define CSM_SOCKET_MSG_TYPE_RX_DATA_CONF           8
#define CSM_SOCKET_MSG_TYPE_RX_DATA_IND            9
#define CSM_SOCKET_MSG_TYPE_RX_WDT                 255


extern void vCreateSocket();
extern void vHandleSocketConnections();

extern tVoid vStartWorkerThread( tVoid );
extern tVoid vCloseAllParentMessageQueues( tVoid );

extern void vSignalDataChanged(DWORD dwSignalId, void * pvActSignalData, BYTE bDataBufferLength, DWORD dwSignalStatus);
extern void vCommunicationConfirmation(tU8 u8Bus, tU32 u32ProtocolType, tU8 u8LocalId, tU8 u8RemoteId, tU8 u8ConnectState, tU16 u16ApplId);
extern void vDataConfirmation(tU32 u32ProtocolType, tU8 u8LocalId, tU8 u8RemoteId, tU8 u8TransferResult);
extern void vDataIndication(tU32 u32ProtocolType, tU8 u8LocalId, tU8 u8RemoteId, void * pvActData, WORD wDataBufferLength);

extern void vSignalWrite2Host(DWORD dwSignalId, const void * pvNewSignalData, BYTE bDataBufferLength, BYTE bTxType);
extern void vCommunicationReq2Host(BYTE bBus, DWORD dwProtocolType, BYTE bLocalId, BYTE bRemoteId, BYTE bAction, WORD wApplID);
extern void vDataReq2Host(DWORD dwProtocolType, BYTE bLocalId, BYTE bRemoteId, const void * pvData, WORD wDataBufferLength);

extern void vInitSignalsFromRegistry();
#endif

 //**** END OF FILE **********************************************************/