/*****************************************************************************
| FILE:         ProcCsm.cpp
| PROJECT:      NISSAN LCN2kai
| SW-COMPONENT: Process
|-----------------------------------------------------------------------------
| DESCRIPTION:  Process Base Entry
|
|-----------------------------------------------------------------------------
| COPYRIGHT:    (c) 2016 Bosch Car Multimegia GmbH
| HISTORY:
| Date      | Modification                                    | Author
| 10.02.16  |                                                 | Kollai
|
| --.--.--  | ----------------           | -------, -----
|
|*****************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_EXH
#include "stl_pif.h"

#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#include "csm_if.h"
#include "csm_stack_m.h"
#include "csm_access_krnl.h"

#include "ProcCsmMain.h"

#define TR_CLASS_CSMPROC (TR_COMP_CSM + 0x10)


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CSMPROC
#include "trcGenProj/Header/ProcCsm.cpp.trc.h"
#endif

#define CSM_EV_SHUTDOWN_NAME  "CSM_SDOWN"
#define CSM_EV_SHUTDOWN       0x00000001

//**************************************************************************************************
// function implementation
//**************************************************************************************************
tS32 s32RunEnv( tVoid )
{
   tS32 s32RetVal = OSAL_OK;

   // open Trace ------------------------------
   #if (CSM_S_TRACE == CSM_C_F_ON)
   ET_TRACE_OPEN;
   ETG_TRACE_USR1(("ProcCsm: Started"));
   #endif

   //check initialization of broadcast CAN signals 
   vInitSignalsFromRegistry();

   //Create and bind socket server
   vCreateSocket();

   // initialize exception handling
   if ( TRUE == exh_bInitExceptionHandling() )
   {
      tBool bExcHandling = exh_bCreateExceptionContext( 0, 0 );
      if ( TRUE == bExcHandling )
      {
         OSAL_tEventHandle  hEvShutdown = OSAL_C_INVALID_HANDLE;
         OSAL_tEventMask    hEvMask     = CSM_EV_SHUTDOWN;
         OSAL_tEventMask    hEvRequest  = 0;

         // first create event
         if ( OSAL_s32EventCreate( CSM_EV_SHUTDOWN_NAME, &hEvShutdown ) != OSAL_ERROR )
         {
            // now setup and start the worker thread
            vStartWorkerThread();

            //will never return
            vHandleSocketConnections();

            #if (CSM_S_TRACE == CSM_C_F_ON)
               ETG_TRACE_USR1(("ProcCsm: Wait for Shutdown-event %08x = %s!", hEvShutdown, CSM_EV_SHUTDOWN_NAME));
            #endif
            tS32 sRet = OSAL_s32EventWait( hEvShutdown, hEvMask, OSAL_EN_EVENTMASK_OR, OSAL_C_TIMEOUT_FOREVER, &hEvRequest );
            #if (CSM_S_TRACE == CSM_C_F_ON)
               ETG_TRACE_USR1(("ProcCsm: Shutdown-event received -> stop CSM (%d(%08x)) -> %d!", sRet, sRet, hEvRequest));
            #endif

            vCloseAllParentMessageQueues();

            OSAL_s32EventClose( hEvShutdown );
            OSAL_s32EventDelete( CSM_EV_SHUTDOWN_NAME );
         }
         else
         {
            #if (CSM_S_TRACE == CSM_C_F_ON)
               ETG_TRACE_ERR(("ProcCsm: Failed to create Shutdown event --> Delete proc."));
            #endif
         }

         //-- free Exceptionhandling
         exh_vFreeExceptionContext();
      } // bExcHandling
      exh_vFreeExceptionHandling();
   } // exh_bInitExceptionHandling

   return s32RetVal;
}
//EOF
