// Description and history of ProcCsm.h at the end of the file.
#ifndef CSM_PROC_HEADER
// File name for preprozessor commands
#define CSM_PROC_HEADER

#include "../csm_access_krnl/include/csm_access_m.h"

//******************************************************************************
//* defines and macros (scope: csm_access_usr module local)
//******************************************************************************
// name of the message queue of the CSM process
#define CSM_C_PROC_MESSAGE_QUEUE_NAME         "PROC_CSM_MSG_QUEUE"

//******************************************************************************
//* typedefs (scope: csm_access_usr module local)
//******************************************************************************
// Typ: Init Message
typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
  tU32              u32MsgQueueElementSize;
}trCSMProcMessageQueueItemInit;

// Typ: ApplReg Message
typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
  tPVoid            pvHandle;
  tU8               u8Bus;
  tU32              u32ProtocolType;
  tU8               au8AddressField[CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE];
  tU16              u16ApplId;
  tPCVoid           pcvCallBackCommunicationCon;
  tPCVoid           pcvCallBackCommunicationInd;
  tPCVoid           pcvCallBackDataCon;                 // standard data confirmation
  tPCVoid           pcvCallBackDataInd;                 // standard data indication
  tPCVoid           pcvCallBackDDataCon;                // MPDT D-data confirmation
  tPCVoid           pcvCallBackDDataInd;                // MPDT D-data indication
  tPCVoid           pcvCallBackDataIndFF;
  tPCVoid           pcvCallBackDataErrorInd;
}trCSMProcMessageQueueItemRegisterAppl;

typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
  tPVoid            pvHandle;
}trCSMProcMessageQueueItemUnregisterAppl;

typedef struct
{
  OSAL_tProcessID          hProcessID;
  tU32                     u32MsgQueueCnt;
  tPVoid                   pvHandle;
  tU32                     u32SignalId;
  tCSM_PFN_CBR_SIGNAL_IND  vPFNCBRSignalInd;
}trCSMProcMessageQueueItemRegisterSignal;

typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
  tPVoid            pvHandle;
  tU32              u32SignalId;
}trCSMProcMessageQueueItemUnregisterSignal;

typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
  tPVoid            pvHandle;
}trCSMProcMessageQueueItemUnregisterAllSignals;

typedef struct
{
  OSAL_tProcessID         hProcessID;
  tU32                    u32MsgQueueCnt;
  tPVoid                  pvHandle;
  tCSM_PFN_BUS_ERROR_IND  vPFNBusErrorInd;
}trCSMProcMessageQueueItemRegisterBusErrorInd;

typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
  tU8               u8Bus;
  tU32              u32ProtocolType;
  tU8               au8AddressField[CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE];
  tU8               u8Action;
  tU16              u16ApplID;
}trCSMProcMessageQueueItemCommunicationReq;

typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
  tU8               u8Bus;
  tU32              u32ProtocolType;
  tU8               au8AddressField[CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE];
  tU16              u16ApplID;
}trCSMProcMessageQueueItemGetCommunicationState;

typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
  tU32              u32ProtocolType;
  tU8               au8AddressField[CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE];
  tU16              u16DataLength;
  tU8               au8Data[CSM_C_ACCESS_LAYER_DATA_REQUEST_MAXLENGTH];
}trCSMProcMessageQueueItemDataRequest;

typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
  tU32              u32ProtocolType;
  tU8               au8AddressField[CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE];
}trCSMProcMessageQueueItemDataIndProcessed;

typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
  tU32              u32SignalId;
  tU8               u8Length;
  tU8               u8TxType;
  tU8               au8Data[CSM_C_ACCESS_LAYER_SIGNAL_DATA_MAXLENGTH];
}trCSMProcMessageQueueItemSignalWrite;

typedef struct
{
  tU32              u32SignalId;
  tU8               u8Length;
  tU8               u8TxType;
  tU8               au8Data[CSM_C_ACCESS_LAYER_SIGNAL_DATA_MAXLENGTH];
}trCSMProcMessageQueueItemSingleSignalWriteData;

typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
  tU8               u8NumberOfSignals;
  trCSMProcMessageQueueItemSingleSignalWriteData arSignalData[CSM_C_ACCESS_LAYER_MULTI_SIGNAL_MAXNUMBER];
}trCSMProcMessageQueueItemMultipleSignalWrite;

typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
  tU32              u32SignalId;
  tU8               u8Length;
}trCSMProcMessageQueueItemSignalRead;

typedef struct
{
  tU32              u32SignalId;
  tU8               u8Length;
}trCSMProcMessageQueueItemSingleSignalReadData;

typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
  tU8               u8NumberOfSignals;
  trCSMProcMessageQueueItemSingleSignalReadData arSignalData[CSM_C_ACCESS_LAYER_MULTI_SIGNAL_MAXNUMBER];
}trCSMProcMessageQueueItemMultipleSignalRead;

typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
}trCSMProcMessageQueueItemGetAllStateIndAgain;

typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
  tU32              u32ProtocolType;
  tU8               au8AddressField[CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE];
  tU8               u8Action;
}trCSMProcMessageQueueItemConTest;

typedef struct
{
  OSAL_tProcessID   hProcessID;
  tU32              u32MsgQueueCnt;
  tU32              u32ProtocolType;
  tU8               au8AddressField[CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE];
  tU16              u16DataLength;
}trCSMProcMessageQueueItemDataRead;

//Typ: Union Daten Element (beinhaltet alle Daten eines Message Queue Elementes, abhngig von dessen Typ)
typedef union
{
   trCSMProcMessageQueueItemInit                    rInit;
   trCSMProcMessageQueueItemRegisterAppl            rRegisterAppl;
   trCSMProcMessageQueueItemUnregisterAppl          rUnregisterAppl;
   trCSMProcMessageQueueItemRegisterSignal          rRegisterSignal;
   trCSMProcMessageQueueItemUnregisterSignal        rUnregisterSignal;
   trCSMProcMessageQueueItemUnregisterAllSignals    rUnregisterAllSignals;
   trCSMProcMessageQueueItemRegisterBusErrorInd     rRegisterBusErrorInd;
   trCSMProcMessageQueueItemCommunicationReq        rCommunicationReq;
   trCSMProcMessageQueueItemGetCommunicationState   rGetCommunicationState;
   trCSMProcMessageQueueItemDataRequest             rDataRequest;
   trCSMProcMessageQueueItemDataIndProcessed        rDataIndProcessed;
   trCSMProcMessageQueueItemSignalWrite             rSignalWrite;
   trCSMProcMessageQueueItemMultipleSignalWrite     rMultipleSignalWrite;
   trCSMProcMessageQueueItemSignalRead              rSignalRead;
   trCSMProcMessageQueueItemMultipleSignalRead      rMultipleSignalRead;
   trCSMProcMessageQueueItemGetAllStateIndAgain     rGetAllStateIndAgain;
   trCSMProcMessageQueueItemConTest                 rConTest;
   trCSMProcMessageQueueItemDataRead                rDataRead;
}tuCSMProcMessageQueueItemData;

// Typ: Message Queue Item Id (gibt an von welchem Typ das QueueItem ist)
typedef enum
{
   CSM_PROC_MESSAGE_QUEUE_ID_INIT = 1,
   CSM_PROC_MESSAGE_QUEUE_ID_REGISTER_APPL,
   CSM_PROC_MESSAGE_QUEUE_ID_UNREGISTER_APPL,
   CSM_PROC_MESSAGE_QUEUE_ID_REGISTER_SIGNAL,
   CSM_PROC_MESSAGE_QUEUE_ID_UNREGISTER_SIGNAL,
   CSM_PROC_MESSAGE_QUEUE_ID_UNREGISTER_ALL_SIGNALS,
   CSM_PROC_MESSAGE_QUEUE_ID_REGISTER_BUS_ERROR_IND,
   CSM_PROC_MESSAGE_QUEUE_ID_COMMUNICATION_REQ,
   CSM_PROC_MESSAGE_QUEUE_ID_GET_COMMUNICATION_STATE,
   CSM_PROC_MESSAGE_QUEUE_ID_DATA_REQUEST,
   CSM_PROC_MESSAGE_QUEUE_ID_DATA_IND_PROCESSED,
   CSM_PROC_MESSAGE_QUEUE_ID_SIGNAL_WRITE,
   CSM_PROC_MESSAGE_QUEUE_ID_MULTIPLE_SIGNAL_WRITE,
   CSM_PROC_MESSAGE_QUEUE_ID_SIGNAL_READ,
   CSM_PROC_MESSAGE_QUEUE_ID_MULTIPLE_SIGNAL_READ,
   CSM_PROC_MESSAGE_QUEUE_ID_GET_ALL_STATE_IND_AGAIN,
   CSM_PROC_MESSAGE_QUEUE_ID_CON_TEST,
   CSM_PROC_MESSAGE_QUEUE_ID_DATA_READ,
   CSM_PROC_MESSAGE_QUEUE_ID_MAX
}tenCSMProcMessageQueueItemID;

// Typ: Message Queue Item
typedef struct
{
  tenCSMProcMessageQueueItemID     enID;      // item ID, die Typ des Queue Elementes angibt
  tuCSMProcMessageQueueItemData    uData;     // item data, eine union aus diversen Elementen, abhngig vom Typ des Elementes
}trCSMProcMessageQueueItem;

/*******************************************************************************
 * variable definition (scope: csm_access_usr module local)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: csm_access_usr module local)
 ******************************************************************************/
/* --none-- */

#endif

/*******************************************************************************
 * \doxydocu
 * \file          ProcCsm.h
 * \brief         Module internal header of CSM process implementation.
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/adapt/osal/csm_proc
 *
 * \ingroup       CSM_ACCESS_LAYER
 * \ingroup       CSM_ACCESS_USR
 *
 * \authors       K+K  (Kollai + Kempen)
 *
 * COPYRIGHT      (c) 2012 Bosch CM GmbH
 *
 * \history_begin
 *
 * 09.03.12  main\1  Kempen
 * - Initial revision.
 *
 * 26.08.13  main\2  Prhl
 * - u16ApplId added to trCSMProcMessageQueueItemRegisterAppl
 *
 * 20.10.16  main\3  Borck
 * - Callback pointers for MPDT D-data added to struct type
 * - comments added while reviewed
 *
 * 22.11.16  main\4  Borck
 * - type for MessageQueueItem extended by ElementSize
 *
 * \history_end
 *//**** END OF FILE **********************************************************/

