// Description and history of csmal_krnl_trace.h at the end of the file.
#ifndef  __CSMAL_KRNL_TRACE_H__
// File name for preprozessor commands
#define  __CSMAL_KRNL_TRACE_H__

// in case of compiling C++ code, the interface is to be declared as C external
#ifdef __cplusplus
extern "C" {
#endif

#if (CSM_S_TRACE_ETG == CSM_C_F_ON)
  // ETG tracing active -> we do not need the standard trace stuff
  // none
#else // CSM_S_TRACE_ETG
  #ifdef CSMAL_KRNL_TRACE_SELF
    // trace functions
    VOID CSMAL_vTraceOut(WORD wTraceOutLevel, const char* coszFormat, ...);
  #else // CSMAL_KRNL_TRACE_SELF
    extern VOID CSMAL_vTraceOut(WORD wTraceOutLevel, const char* coszFormat, ...);
  #endif
#endif // CSM_S_TRACE_ETG

#ifdef __cplusplus
}
#endif

#else
  #error csmal__krnl_trace.h included several times
#endif // __CSMAL_KRNL_TRACE__
/*******************************************************************************
 * \doxydocu
 * \file          csmal_krnl_trace.h
 * \brief         Interface header for the trace part of the kernel module of
 *                the CSM Access Layer
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 * \see           GM Global Epsilon - CSM Access Layer - Software Specification
 *                and Design
 *
 * \sw_component  CAN stack
 * \project       JV-Platfom
 * \path          /di_can/adapt/tengine/csm_access_krnl/include/
 *
 * \ingroup       CSM_ACCESS_KRNL
 *
 * \authors       3SOFT GmbH, Schubart; Blaupunkt GmbH, VTeam
 *
 * COPYRIGHT      (c) 2006 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 16.11.06  /main/1  VTeam-Khler
 * - Initial revision
 *
 * 29.01.08  /main/2  VTeam-Khler
 * - Prototype CSMAL_vTraceOut() instead of CSMAL_vTraceInfo() and
 *   CSMAL_vTraceError()
 * - Doxygen comments added.
 *
 * 29.01.08  /main/3  VTeam-Khler
 * - History corrected.
 *
 * 14.11.16  /main/4  A.Borck
 * - Availability of prototypes made dependend on ETG feature
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
