/* Description and history of csmal_krnl_os.h at the end of the file.       */
#ifndef  __CSMAL_KRNL_OS_H__
/** File name for preprozessor commands */
#define  __CSMAL_KRNL_OS_H__

#ifndef E_OK
#define E_OK         0 /* No Error */
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef CSMAL_KRNL_OS_SELF
  /** OS-dependant functions*/
  LONG CSMAL_lCreateLock(const CHAR* pbSemName);
  LONG CSMAL_lLock(LONG lLockID);
  LONG CSMAL_lUnLock(LONG lLockID);
  LONG CSMAL_lDeleteLock(LONG lLockID);
  LONG CSMAL_lDeleteUserResource(LONG lTaskId, LONG lMfbId);


#else
  /** OS-dependant functions*/
  extern LONG CSMAL_lCreateLock(const CHAR* pbSemName);
  extern LONG CSMAL_lLock(LONG lLockID);
  extern LONG CSMAL_lUnLock(LONG lLockID);
  extern LONG CSMAL_lDeleteLock(LONG lLockID);
  extern LONG CSMAL_lDeleteUserResource(LONG lTaskId, LONG lMfbId);
#endif


#ifdef __cplusplus
}
#endif

#else
  #error csmal__krnl_os.h included several times
#endif /* __CSMAL_KRNL_OS_H__ */
/*******************************************************************************
 * \doxydocu
 * \file          csmal_krnl_os.h
 * \brief         Interface header of the os specific kernel module of the CSM
 *                Access Layer
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 * \see
 *
 * \sw_component  CAN stack
 * \project       Nissan LCN2 kai
 * \path          /di_can/adapt/osal/csm_access_krnl/include/
 *
 * \ingroup       CSM_ACCESS_KRNL
 *
 * \authors       3SOFT GmbH, Schubart; Blaupunkt GmbH, VTeam
 *
 * COPYRIGHT      (c) 2011 Bosch GmbH
 *
 * \history_begin
 *
 * 17.11.11  /main/1  Kollai
 * - initial revision
 *
 * 16.05.12  /main/2  Kollai-Kempen
 * - Function prototype CSMAL_vSendMessage removed
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
