/* Description and history of csm_access_mp.h at the end of the file.             */
#ifndef CSM_ACCESS_MP_HEADER
/** File name for preprozessor commands */
#define CSM_ACCESS_MP_HEADER

/* Includes only in exceptional cases allowed */

/*******************************************************************************
 * defines and macros (scope: csm_access module local)
 ******************************************************************************/
/* Feature switch for changing task communication from tkse_snd_mbf to osal message buffer.
   The same feature switch is used and defined in csm_stack_tengine.c
   At the moment this feature is set to off.
*/
#define CSM_AL_S_USE_OSAL_MESSAGEBUFFER CSM_C_F_ON

/** If the feature switch is on, the csm access layer struct for data
 *  indications contains a buffer for the data with CSMAL_MAX_DATA_PAYLOAD
 *  bytes.
 *  Feature switched off: New handling without fix data array (saves 100*4k RAM buffer)*/
#define CSMAL_S_DATA_IND_STRUCT_WITH_DATA_ARRAY CSM_C_F_OFF

/** */
#define CSMAL_MAX_DATA_PAYLOAD      4096  // default value if Appl does not specify a value
#define CSMAL_MIN_DATA_PAYLOAD        20  // for test purposes

/** Number of bytes for the buffers where access layer stores the address field
 *  information for communication and data confirmation/indication. User mode
 *  applications have read/write access only to these buffers and not to the
 *  memory area where the kernel pvAddressField points to.
 *  Up to now no address field with more than two bytes is used.             */
#ifdef CSM_C_PTYPE_J1939
  #define CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE 4
#else
#define CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE 2
#endif

#ifdef CSM_ACCESS_KRNL_SELF
  /** maximum number of signal indications that can be registered */
  #define CSMAL_MAX_SIGNALIND_NOTIFICATIONS        1000

  /** maximum number of application callbacks that can be registered for each type */
  #define CSMAL_MAX_APPL_NOTIFICATIONS             100

  /** maximum number of communication confirmations that can be registered */
  #define CSMAL_MAX_COMMUNICATIONCON_NOTIFICATIONS CSMAL_MAX_APPL_NOTIFICATIONS

  /** maximum number of communication indications that can be registered */
  #define CSMAL_MAX_COMMUNICATIONIND_NOTIFICATIONS CSMAL_MAX_APPL_NOTIFICATIONS

  /** maximum number of data confirmations that can be registered */
  #define CSMAL_MAX_DATACON_NOTIFICATIONS          CSMAL_MAX_APPL_NOTIFICATIONS

  /** maximum number of data indications that can be registered */
  #define CSMAL_MAX_DATAIND_NOTIFICATIONS          CSMAL_MAX_APPL_NOTIFICATIONS

  #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
    #if (CSM_S_ISO_TP == CSM_C_F_ON)
      #if (CSM_S_ITP_FF_INDICATION_AVAILABLE == CSM_C_F_ON)
        /** maximum number of first frame data indications that can be registered */
        #define CSMAL_MAX_DATAINDFF_NOTIFICATIONS      CSMAL_MAX_APPL_NOTIFICATIONS
      #endif /* CSM_S_ITP_FF_INDICATION_AVAILABLE */
    #endif /* CSM_S_ISO_TP */

    #if (CSM_S_DATA_ERROR_IND_AVAILABLE == CSM_C_F_ON)
      /** maximum number of data error indications that can be registered */
      #define CSMAL_MAX_DATAERRORIND_NOTIFICATIONS     CSMAL_MAX_APPL_NOTIFICATIONS
    #endif /* CSM_S_DATA_ERROR_IND_AVAILABLE */
  #endif /* CSM_S_CNP_AVAILABLE */

  #if (CSM_S_ENABLE_INDICATE_BUSERROR == CSM_C_F_ON)
    /** maximum number of bus error indications that can be registered */
    #define CSMAL_MAX_BUSERRORIND_NOTIFICATIONS        CSMAL_MAX_APPL_NOTIFICATIONS
  #endif /* CSM_S_ENABLE_INDICATE_BUSERROR */

  /** number of handles (= number of user mode apps that can use the CSM by
   * CSM_lApplCallbackPreInit()) */
  #define CSMAL_NUM_HANDLES                        40
#endif  /* CSM_ACCESS_KRNL_SELF */

/*******************************************************************************
 * typedefs (scope: csm_access module local)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * variable definition (scope: csm_access module local)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: csm_access module local)
 ******************************************************************************/

#else /* CSM_ACCESS_MP_HEADER already defined */
# error CSM_ACCESS_MP.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          csm_access_mp.h
 * \brief         Project specific part of the module internal header of the
 *                CSM access layer (kernel and user).
 *
 * \see           CAN-SW Architecture, written by VTeam
 * \see           GM Global Epsilon - CSM Access Layer - Softwar Specification
 *                and Design, Elektrobit-Schubart
 *
 * \sw_component  CAN stack
 * \project       Pool module
 * \path          /di_can/adapt/tengine/csm_access_krnl/include
 *
 * \ingroup       CSM_ACCESS_LAYER
 * \ingroup       CSM_ACCESS_KRNL
 * \ingroup       CSM_ACCESS_USR
 *
 * \authors       VTeam
 *
 * COPYRIGHT      (c) 2008 Blaupunkt GmbH
 *
 * \history_begin
 *
 * 09.04.08  main\1  ???
 * - ???
 *
 * 20.08.13  main\2  Prhl
 * - CSMAL_NUM_HANDLES set to 40
 *
 * 01.10.13  main\3  Pistoor
 * - Increased CSMAL_MAX_SIGNALIND_NOTIFICATIONS to 1000 because of ProcOedt module test
 *
 * 21.11.16  main\4  A.Borck
 * - added additional payload define for test purpose (message queue element size too small)
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
