/* Description and history of csm_access_m.h at the end of the file.             */
#ifndef CSM_ACCESS_M_HEADER
/** File name for preprozessor commands */
#define CSM_ACCESS_M_HEADER

#include "csm_access_mp.h" /*   include project specific part */
/* No further includes allowed */

/*******************************************************************************
 * defines and macros (scope: csm_access module local)
 ******************************************************************************/

#ifndef CSM_AL_S_USE_OSAL_MESSAGEBUFFER
  #error CSM_AL_S_USE_OSAL_MESSAGEBUFFER to be defined in csm_access_mp.h!
#endif

#if (CSM_AL_S_USE_OSAL_MESSAGEBUFFER == CSM_C_F_ON)
  /* Osal message buffer are created with an unique name */
  #define  CSM_C_ACCESS_LAYER_MBF_NAMELENGTH  OSAL_C_U32_MAX_NAMELENGTH
#endif  /* (CSM_AL_S_USE_OSAL_MESSAGEBUFFER == CSM_C_F_ON) */


#define CSM_C_ACCESS_LAYER_SIGNAL_DATA_MAXLENGTH    32
#define CSM_C_ACCESS_LAYER_MULTI_SIGNAL_MAXNUMBER   20
#define CSM_C_ACCESS_LAYER_DATA_REQUEST_MAXLENGTH   CSMAL_MAX_DATA_PAYLOAD
#define CSM_C_ACCESS_LAYER_DATA_READ_MAXLENGTH      CSMAL_MAX_DATA_PAYLOAD


/* prefix of the names for the OSAL message queues */
#define CSMAL_C_PARENT_MESSAGE_QUEUE_NAME_PREFIX  "CSMALU_MQP_"
#define CSMAL_C_SERVICE_MESSAGE_QUEUE_NAME_PREFIX "CSMALU_MQS_"


/*******************************************************************************
 * typedefs (scope: csm_access module local)
 ******************************************************************************/

/** the message types from Access layer kernel to user module that can be handled */
typedef enum
{
  CSM_ACCESS_NoEvent           = 0,  /**< */
  CSM_ACCESS_CommunicationCon  = 1,  /**< */
  CSM_ACCESS_CommunicationInd  = 2,  /**< */
  CSM_ACCESS_DataCon           = 3,  /**< */
  CSM_ACCESS_DataInd           = 4,  /**< */
  CSM_ACCESS_SignalInd         = 5,  /**< */
  CSM_ACCESS_TerminateTask     = 6,  /**< This message type is send to the User Mode Service Task so it terminates itself. */
  #if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
    #if (CSM_S_ISO_TP == CSM_C_F_ON)
      #if (CSM_S_ITP_FF_INDICATION_AVAILABLE == CSM_C_F_ON)
        CSM_ACCESS_DataIndFF   = 7,  /**< YYY_vDataIndFF() callback function has to be called in the User Mode Service Task. */
      #endif
    #endif
    #if (CSM_S_DATA_ERROR_IND_AVAILABLE == CSM_C_F_ON)
      CSM_ACCESS_DataErrorInd  = 8,  /**< YYY_vDataErrorInd() callback function has to be called in the User Mode Service Task. */
    #endif /* CSM_S_DATA_ERROR_IND_AVAILABLE */
  #endif /* CSM_S_CNP_AVAILABLE */
  #if (CSM_S_ENABLE_INDICATE_BUSERROR == CSM_C_F_ON)
    CSM_ACCESS_BusErrorInd     = 9   /**< YYY_vBusErrorInd() callback function has to be called in the User Mode Service Task. */
  #endif
} CSMAL_tenNotifyEvent;

/** type for the csm access handles */
typedef struct
{
  LONG  lMQueueID;           /**< Id of the queue which is related to the access layer user task. */
  LONG  lMQueueElemSize;     /**< Size of the queue element which is related to the access layer user task. */
  LONG  lTaskID;             /**< Id of the access layer user task.*/
} trCSMHandle, *pCSMHandle;

/** message header for all messages */
typedef struct
{
  CSMAL_tenNotifyEvent enMsgType;   /**< */
  void *pvAccessUsrHandle;          /**< Access Layer Handle of the user part (used in vApplCallbackPreInit()) */
} trMsgHeader, *pMsgHeader;

/** Signal indication */
typedef struct
{
  trMsgHeader rMsgHeader;                    /**< */
  tCSM_PFN_CBR_SIGNAL_IND vPFNCBRSignalInd;  /**< */
  DWORD dwSignalId;                          /**< */
  DWORD dwState;                             /**< */
} trSignalIndMsg, *pSignalIndMsg;

/** Communication confirmation */
typedef struct
{
  trMsgHeader rMsgHeader;                                     /**< */
  tCSM_PFN_TP_COMMUNICATION_CON vPFNTPCommunicationCon;       /**< */
  BYTE bBus;                                                  /**< */
  DWORD dwProtocolType;                                       /**< */
  BYTE abAddressField[CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE]; /**< */
  BYTE bConnectState;                                         /**< */
  WORD wAppId;                                                /**< */
} trCommunicationConMsg, *pCommunicationConMsg;

/** Communication indication */
typedef struct
{
  trMsgHeader rMsgHeader;                                     /**< */
  tCSM_PFN_TP_COMMUNICATION_IND vPFNTPCommunicationInd;       /**< */
  BYTE bBus;                                                  /**< */
  DWORD dwProtocolType;                                       /**< */
  BYTE abAddressField[CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE]; /**< */
  BYTE bConnectState;                                         /**< */
  WORD wAppId;                                                /**< */
} trCommunicationIndMsg, *pCommunicationIndMsg;

#if (CSM_S_CNP_AVAILABLE == CSM_C_F_ON)
  /** data confirmation */
  typedef struct
  {
    trMsgHeader rMsgHeader;                                     /**< */
    tCSM_PFN_TP_DATA_CON vPFNTPDataCon;                         /**< */
    BYTE bBus;                                                  /**< */
    DWORD dwProtocolType;                                       /**< */
    BYTE abAddressField[CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE]; /**< */
    BYTE bTransferResult;                                       /**< */
  } trDataConMsg, *pDataConMsg;                                 /**< */

  /** data indication */
  typedef struct
  {
    trMsgHeader rMsgHeader;                                     /**< */
    tCSM_PFN_TP_DATA_IND vPFNTPDataInd;                         /**< */
    BYTE bBus;                                                  /**< */
    DWORD dwProtocolType;                                       /**< */
    BYTE abAddressField[CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE]; /**< */
    WORD wDataLength;                                           /**< */
    #if (CSMAL_S_DATA_IND_STRUCT_WITH_DATA_ARRAY == CSM_C_F_ON)
    BYTE abData[CSMAL_MAX_DATA_PAYLOAD];                        /**< */
    #endif
  } trDataIndMsg, *pDataIndMsg;

  #if (CSM_S_ISO_TP == CSM_C_F_ON)
    #if (CSM_S_ITP_FF_INDICATION_AVAILABLE == CSM_C_F_ON)
      /** data indication first frame */
      typedef struct
      {
        trMsgHeader rMsgHeader;                                     /**< */
        tCSM_PFN_TP_DATA_IND_FF vPFNTPDataIndFF;                    /**< Pointer to YYY_vCSMDataIndFF() callback function */
        BYTE bBus;                                                  /**< Bus Id */
        DWORD dwProtocolType;                                       /**< Protocol Type */
        BYTE abAddressField[CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE]; /**< Address field */
        WORD wDataLength;                                           /**< Message length in byte */
      } trDataIndFFMsg, *pDataIndFFMsg;
    #endif /* CSM_S_ITP_FF_INDICATION_AVAILABLE */
  #endif /* CSM_S_ISO_TP */

  #if (CSM_S_DATA_ERROR_IND_AVAILABLE == CSM_C_F_ON)
    /** data error indication */
    typedef struct
    {
      trMsgHeader rMsgHeader;                                     /**< */
      tCSM_PFN_TP_DATA_ERROR_IND vPFNTPDataErrorInd;              /**< Pointer to YYY_vCSMDataErrorInd() callback function */
      BYTE bBus;                                                  /**< Bus Id */
      DWORD dwProtocolType;                                       /**< Protocol Type */
      BYTE abAddressField[CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE]; /**< Address field */
      DWORD dwDataErrorCode;                                      /**< Error Code */
    } trDataErrorIndMsg, *pDataErrorIndMsg;
  #endif /* (CSM_S_DATA_ERROR_IND_AVAILABLE == CSM_C_F_ON) */
#else
/** data indication, used as sizeof-parameter in csmalu_vCsmUserModeServiceTask() in csm_access_usr.c */
  typedef struct
  {
    trMsgHeader rMsgHeader;                                     /**< */
    tCSM_PFN_TP_DATA_IND vPFNTPDataInd;                         /**< */
    BYTE bBus;                                                  /**< */
    DWORD dwProtocolType;                                       /**< */
    BYTE abAddressField[CSM_C_ACCESS_LAYER_ADDRESS_FIELD_SIZE]; /**< */
    WORD wDataLength;                                           /**< */
    #if (CSMAL_S_DATA_IND_STRUCT_WITH_DATA_ARRAY == CSM_C_F_ON)
      BYTE abData[ CSMAL_MAX_DATA_PAYLOAD];                     /**< */
    #endif
  } trDataIndMsg, *pDataIndMsg;
#endif /* CSM_S_CNP_AVAILABLE */

  #if (CSM_S_ENABLE_INDICATE_BUSERROR == CSM_C_F_ON)
    /** bus error indication */
    typedef struct
    {
      trMsgHeader rMsgHeader;                                    /**< */
      tCSM_PFN_BUS_ERROR_IND vPFNBusErrorInd;                  /**< Pointer to YYY_vCSMDataErrorInd() callback function */
      BYTE bBus;                                                 /**< Bus Id */
      WORD wDataErrorCode;                                       /**< Error Code */
    } trBusErrorIndMsg, *pBusErrorIndMsg;
  #endif

/*******************************************************************************
 * variable definition (scope: csm_access module local)
 ******************************************************************************/
/* --none-- */

/*******************************************************************************
 * function prototypes (scope: csm_access module local)
 ******************************************************************************/
/* --none-- */

#else /* CSM_ACCESS_M_HEADER already defined */
# error CSM_ACCESS_M.H included several times
#endif
/*******************************************************************************
 * \doxydocu
 * \file          csm_access_m.h
 * \brief         Module internal header of CSM access layer (kernel and user).
 *
 * \see           CAN-SW Architecture, written by VTeam
 * \see
 *
 * \sw_component  CAN stack
 * \project       Nissan LCN2 kai
 * \path          /di_can/adapt/osal/csm_access_krnl/include
 *
 * \ingroup       CSM_ACCESS_LAYER
 * \ingroup       CSM_ACCESS_KRNL
 * \ingroup       CSM_ACCESS_USR
 *
 * \authors       VTeam
 *
 * COPYRIGHT      (c) 201 Bosch GmbH
 *
 * \history_begin
 *
 * 17.11.12  main\1  Kollai
 * - Initial revision.
 *
 * 16.05.12  main\2  Kollai-Kempen
 * - CSMAL_C_APPL_CALLBACK_PRE_INIT_SEM_NAME removed
 * - 4 new #defines for MAXLENGTH and MAXNUMBER introduced
 * - 2 Message-Queue Prefix-Defines added
 *
 * 21.11.16  main\3  A.Borck
 * - access handle struct extended by "Queue Element Size"
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
