/* Description and history of csm_access_krnl.h at the end of the file.       */
#ifndef  __SYS_KRNLMODE_CSM_H__
/** File name for preprozessor commands */
#define  __SYS_KRNLMODE_CSM_H__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef CSM_ACCESS_KRNL_SELF

  LONG CSMAL_lInit(VOID);
  LONG CSMAL_lExit(VOID);

  LONG CSMAL_lRegisterAppl(void *pvHandle, BYTE  bBus, DWORD dwProtocolType, const void * pvAddressField, const void * pvCallBackFkt);
  LONG CSMAL_lUnregisterAppl(void *pvHandle);

  LONG CSMAL_lRegisterSignal(void *pvHandle, DWORD dwSignalId, tCSM_PFN_CBR_SIGNAL_IND vPFNCBRSignalInd);
  LONG CSMAL_lUnregisterSignal(void *pvHandle, DWORD dwSignalId);
  LONG CSMAL_lUnregisterAllSignals(void *pvHandle);

  #if (CSM_S_ENABLE_INDICATE_BUSERROR == CSM_C_F_ON)
  LONG CSMAL_lRegisterBusErrorInd(void *pvHandle, tCSM_PFN_BUS_ERROR_IND vPFNBusErrorInd);
  #endif

#else

  /* initializer function for kernel mode part */
  extern LONG CSMAL_lInit(VOID);
  extern LONG CSMAL_lExit(VOID);

  /* Functions for adding/removing callbacks data to corresponding notification tables */
  extern LONG CSMAL_lRegisterAppl(void *pvHandle, BYTE  bBus, DWORD dwProtocolType, const void * pvAddressField, const void * pvCallBackFkt);
  extern LONG CSMAL_lUnregisterAppl(void *pvHandle);

  extern LONG CSMAL_lRegisterSignal(void *pvHandle, DWORD dwSignalId, tCSM_PFN_CBR_SIGNAL_IND vPFNCBRSignalInd);
  extern LONG CSMAL_lUnregisterSignal(void *pvHandle, DWORD dwSignalId);
  extern LONG CSMAL_lUnregisterAllSignals(void *pvHandle);

  #if (CSM_S_ENABLE_INDICATE_BUSERROR == CSM_C_F_ON)
  extern LONG CSMAL_lRegisterBusErrorInd(void *pvHandle, tCSM_PFN_BUS_ERROR_IND vPFNBusErrorInd);
  #endif

  extern LONG CSMAL_lGetAccessHandle(void *pvHandle);
  extern LONG CSMAL_lStoreHandleData(void *pvHandle, LONG lMessageBufferID, LONG lTaskID, LONG lMessageBufferSize);

#endif // CSM_ACCESS_KRNL_SELF

#ifdef __cplusplus
}
#endif

#else
  #error csm_access_krnl.h included several times
#endif // __SYS_KRNLMODE_CSM_H__

/*******************************************************************************
 * \doxydocu
 * \file          csm_access_krnl.h
 * \brief         Interface header of the kernel module of the CSM Access Layer
 *
 * \see           CAN-SW Architektur, written by CM-DI/ESA3
 * \see
 *
 * \sw_component  CAN stack
 * \project       Nissan LCN2 kai
 * \path          /di_can/adapt/tengine/csm_access_krnl/include/
 *
 * \ingroup       CSM_ACCESS_KRNL
 *
 * \authors
 *
 * COPYRIGHT      (c) 2011 Bosch GmbH
 *
 * \history_begin
 *
 * 17.11.11 /main/1 Kollai
 * - initial version Nissan LCN2 kai
 *
 * 16.05.12 /main/2 Kollai-Kempen
 * - function prototypes added/adaptated
 *
 * 21.11.16 /main/3 A.Borck
 * - signature of  CSMAL_lStoreHandleData extended by 1 parameter (to pass the msg queue element size)
 *
 * \history_end
 *//**** END OF FILE **********************************************************/

