
/************************************************************************
*FILE					: swuhmi_statusupdatewnd_inf4cv.h
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: inf4cv Status Update Window.
*DESCRIPTION			: On Startup & On End, This window is used by the App.
*AUTHOR					: RRD7KOR (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2018	| 0.1		| RRD7KOR			| Initial
----------------------------------------------------------------------------

************************************************************************/

#ifndef SWUHMI_STATUSUPDATEWND_INF4CV_H_
#define SWUHMI_STATUSUPDATEWND_INF4CV_H_



#define INFOLABEL_YPOS_FROM_BOTTOM			 75
#define DEVICEIDLABEL_YPOS_FROM_BOTTOM		 15
#define INFOLABEL_XPOS						123
#define INFOLABEL_YPOS                      382


#define HEADERLABEL_XPOS		  		 	300
#define HEADERLABEL_YPOS					 50

//Outline
#define  OUTLINE_XPOS						  5
#define	 OUTLINE_YPOS						  5
#define  OUTLINE_WIDTH						  3

#define WHITE_COLOR					0xFFFFFF

#include "windows/swuhmi_window.h"
#include "widgets/swuhmi_label.h"
#include "widgets/swuhmi_image.h"
#include "widgets/swuhmi_line.h"
#include "main/swuhmi_systemsettings_inf4cv.h"

namespace swuhmi {


class statusupdatewnd : public window
{
public:
	statusupdatewnd();
	virtual ~statusupdatewnd();

	virtual tVoid vInit();
	virtual tVoid vDeInit();
	virtual void traceState() { }
	virtual tVoid InitalizeWnd();
	virtual tVoid DeInitalizeWnd();
	virtual tVoid OnRemainingTimeExpiry() { }



private:
	label								m_HeaderLabel;
	label								m_StatusLabel;
	label								m_DeviceId;
	line								m_OutLine;

	string 								m_strStatusText;
	string								m_strDeviceId;

private:
	tBool SetLabelText();

};

}

#endif /* UPDATESUCCESS_H_ */
