
/************************************************************************
*FILE					: swuhmi_recoveryupdatewnd_inf4cv.h
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: inf4cv Update Window.
*DESCRIPTION			: On Update of Software, This window is used by the App
*AUTHOR					: VRI7COB (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| VRI7COB			| Initial
************************************************************************/

#ifndef SWUHMI_RECOVERYUPDATEWND_INF4CV_H_
#define SWUHMI_RECOVERYUPDATEWND_INF4CV_H_


#include "windows/swuhmi_window.h"
#include "widgets/swuhmi_label.h"
#include "widgets/swuhmi_line.h"
#include "widgets/swuhmi_image.h"
#include "widgets/swuhmi_progressbar_inf4cv.h"
#include "main/swuhmi_systemsettings_inf4cv.h"

namespace swuhmi {

#define inf4cv_PROGRESSBAR_XPOS_FROM_LEFT			123

#define PROGRESSBAR_XPOS_FROM_LEFT				123
#define PROGRESSBAR_YPOS_FROM_TOP			    330
#define PROGRESSBAR_HEIGHT						 14
#define PROGRESSBAR_WIDTH						 553
#define PROGRESSBAR_BORDER_WIDTH				  4

//Remaining Time
#define REMAINING_TIME_TEXT_FROM_LEFT			220
#define REMAINING_TIME_TEXT_FROM_TOP			294
#define REMAINING_TIME_FROM_LEFT				480
#define REMAINING_TIME_FROM_TOP				    294

//Info Text
#define INFO_TEXT_XPOS_FROM_LEFT				123
#define INFO_TEXT_YPOS_FROM_TOP				    382

//Header
#define HEADERLABEL_XPOS		  		 		300
#define HEADERLABEL_YPOS					 	 50

//color
#define WHITE_COLOR								0xFFFFFF
#define SWUPDATE_LABEL_COLOR					0x0000CC
#define STATICTEXT_LABEL_COLOR					0x994C00
#define OUTLINE_BORDER_COLOR					0xFFFFFF

//Outline
#define  OUTLINE_XPOS							 5
#define	 OUTLINE_YPOS							 5
#define  OUTLINE_WIDTH							 3



class recoveryupdatewnd : public window
{
public:
	recoveryupdatewnd();
	virtual ~recoveryupdatewnd();

	virtual tVoid vInit();
	virtual tVoid vDeInit();
	virtual void traceState() { }
	virtual tVoid InitalizeWnd();
	virtual tVoid DeInitalizeWnd();
	virtual tVoid OnRemainingTimeExpiry();


	tVoid vProcess(Msg_UpdateProgressUpdate *pMsg);

private:
	label				m_HeaderLabel;
	label				m_RemainingTimeTextLabel;
	label				m_RemainingTimeLabel;
	label				m_InfoLabel;

	line				m_OutLine;
	inf4cv_progressbar	m_inf4cvProgressBar;

private:
	string		m_strRemainingTime;

	tU16 		m_u16ProgressValue;
	float		m_fProgressValue;
};

}


#endif /* RECOVERYUPDATEWND_H_ */
