
/************************************************************************
*FILE					: swuhmi_recoveryupdatewnd_inf4cv.cpp
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: inf4cv Update Window.
*DESCRIPTION			: On Update of Software, This window is used by the App
*AUTHOR					: RRD7KOR (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2018	| 0.1		| RRD7KOR			| Initial
************************************************************************/

#include "fcswupdatesrv/FcSwUpdateSrvJson.h"
#include "main/swuhmi_component.h"
#include "swuhmi_recoveryupdatewnd_inf4cv.h"
#include "main/swuhmi_configurator_inf4cv.h"
#include "../config/swuhmi_includes_inf4cv.h"
#include "../widgets/swuhmi_graphicsinterface_inf4cv.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL 			TR_TTFIS_SWUPDATE
#define ETG_I_TTFIS_CMD_PREFIX 			"DNL_"
#define ETG_I_FILE_PREFIX 				SWUHMI::LABEL::
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_HMI
#include "trcGenProj/Header/swuhmi_recoveryupdatewnd_inf4cv.cpp.trc.h"
#endif


namespace swuhmi {

/************************************************************************
*FUNCTION			: recoveryupdatewnd
*DESCRIPTION		: constructor of recoveryupdatewnd.
*PARAMETER			: None.
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/

recoveryupdatewnd::recoveryupdatewnd()
{
	m_u16ProgressValue = 0;
	m_fProgressValue = -1;
}

/************************************************************************
*FUNCTION			: recoveryupdatewnd
*DESCRIPTION		: destructor of recoveryupdatewnd.
*PARAMETER			: None.
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/

recoveryupdatewnd::~recoveryupdatewnd(){
}

/************************************************************************
*FUNCTION			: InitalizeWnd
*DESCRIPTION		: Initalize the RecoveryUpdateWnd
*PARAMETER			: None.
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid recoveryupdatewnd::InitalizeWnd()
{
	ETG_TRACE_USR2(("recoveryupdatewnd::InitalizeWnd"));

	GetScreenResolution();
	swuhmi_configurator_inf4cv::instance()->SetUpdateState(E_HMI_SW_UPDATE_STATE);
    

    if(swu::exists(swuhmi_systemsettings_inf4cv::instance()->_inf4cvBackGroundImageLoc))
		SetBackGroundImage(swuhmi_systemsettings_inf4cv::instance()->_inf4cvBackGroundImageLoc);
    
	if(swu::exists(swuhmi_systemsettings_inf4cv::instance()->_backgndImageLoc))
		SetBackGroundImage(swuhmi_systemsettings_inf4cv::instance()->_backgndImageLoc,BOSCH_LOGO_X_POS,BOSCH_LOGO_Y_POS);
    
	m_HeaderLabel.SetXPos(HEADERLABEL_XPOS);
	m_HeaderLabel.SetYPos(HEADERLABEL_YPOS);
	m_HeaderLabel.SetLabelAlignment(E_LABEL_HORIZONTAL_CENTER_ALIGNMENT);
	m_HeaderLabel.SetFGColor(WHITE_COLOR);
	m_HeaderLabel.SetFontHeight(LARGE_FONT_HEIGHT);
	string TranslatedText("");
	string strHeaderText("");
	if( isKDSOnlystick )
	{
		strHeaderText.assign("System configuration data update");
		TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_sysconfigstatuswnd_headerId);
	}
	else
	{
		strHeaderText.assign("Software Update");
		TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_recoverywnd_headerId);
	}

	if(!TranslatedText.empty())
	{
		strHeaderText.clear();
		strHeaderText = TranslatedText;
		m_HeaderLabel.SetTranslationStatus(true);
	}
	m_HeaderLabel.DrawText(strHeaderText);

	m_RemainingTimeTextLabel.SetXPos(REMAINING_TIME_TEXT_FROM_LEFT);
	m_RemainingTimeTextLabel.SetYPos(REMAINING_TIME_TEXT_FROM_TOP);
	m_RemainingTimeTextLabel.SetFontHeight(MEDIUM_FONT_HEIGHT);
	m_RemainingTimeTextLabel.SetFGColor(WHITE_COLOR);
	string strRemainTimeText("Remaining time:");
	TranslatedText.clear();
	TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_recoverywnd_timeId);
	if(!TranslatedText.empty())
	{
		strRemainTimeText.clear();
		strRemainTimeText = TranslatedText;
		m_RemainingTimeTextLabel.SetTranslationStatus(true);
	}
	m_RemainingTimeTextLabel.DrawText(strRemainTimeText);

        tS32 remainingTime=swuhmi_configurator_inf4cv::instance()->m_s32RemainingTime;
        char str[15];
	if( remainingTime>=0){
           // remaining time has already been set ...
           sprintf(str, "%d", remainingTime ? remainingTime : 1);
           m_strRemainingTime.clear();
           m_strRemainingTime.assign(remainingTime ? "~ " : "< ");
           m_strRemainingTime.append(str);
           m_strRemainingTime.append(" min");
	}
	ETG_TRACE_USR2(("recoveryupdatewnd::InitalizeWnd(): Remaining time:%s", m_strRemainingTime.c_str()));

	m_RemainingTimeLabel.SetXPos(REMAINING_TIME_FROM_LEFT);
	m_RemainingTimeLabel.SetYPos(REMAINING_TIME_FROM_TOP);
	m_RemainingTimeLabel.SetFontHeight(MEDIUM_FONT_HEIGHT);
	m_RemainingTimeLabel.SetFGColor(WHITE_COLOR);
	m_RemainingTimeLabel.DrawText(m_strRemainingTime);

	m_InfoLabel.SetXPos(INFO_TEXT_XPOS_FROM_LEFT);
	m_InfoLabel.SetYPos(INFO_TEXT_YPOS_FROM_TOP);
	m_InfoLabel.SetLabelAlignment(E_LABEL_HORIZONTAL_CENTER_ALIGNMENT);
	m_InfoLabel.SetFontHeight(MEDIUM_FONT_HEIGHT);
	m_InfoLabel.SetFGColor(WHITE_COLOR);
	TranslatedText.clear();
	string strInfoText("");
	if( isKDSOnlystick )
	{
		strInfoText.assign("AVM and RVC functions will not be available during the system configuration data file transfer.");
		TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_sysconfigstatuswnd_messageId);
	}
	else
	{
		strInfoText.assign("AVM and RVC functions will not be available during the software update.");
		TranslatedText = swuhmi_systemsettings_inf4cv::instance()->GetTranslationText(_recoverywnd_messageId);
	}

	if(!TranslatedText.empty())
	{
		strInfoText.clear();
		strInfoText = TranslatedText;
		m_InfoLabel.SetTranslationStatus(true);
	}
	m_InfoLabel.DrawText(strInfoText);

	m_inf4cvProgressBar.SetXPos(inf4cv_PROGRESSBAR_XPOS_FROM_LEFT);
	m_inf4cvProgressBar.SetYPos(PROGRESSBAR_YPOS_FROM_TOP);
	m_inf4cvProgressBar.SetWidth(PROGRESSBAR_WIDTH);
	m_inf4cvProgressBar.SetHeight(PROGRESSBAR_HEIGHT);
	m_inf4cvProgressBar.SetBackGndImage(swuhmi_systemsettings_inf4cv::instance()->_inf4cv_pbar_backgnd);
	m_inf4cvProgressBar.SetForeGndImage(swuhmi_systemsettings_inf4cv::instance()->_inf4cv_pbar_foregnd);
	//m_inf4cvProgressBar.SetMeasurementImage(swuhmi_systemsettings_inf4cv::instance()->_inf4cv_pbar_measuring);
	//m_inf4cvProgressBar.SetProgressPointerImage(swuhmi_systemsettings_inf4cv::instance()->_inf4cv_pbar_pointer);
	m_inf4cvProgressBar.SetProgressValue(m_fProgressValue);
	m_inf4cvProgressBar.Showinf4cvProgressBar();

	m_OutLine.SetXPos(OUTLINE_XPOS);
	m_OutLine.SetYPos(OUTLINE_YPOS);
	m_OutLine.SetFGColor(OUTLINE_BORDER_COLOR);
	m_OutLine.SetLineWidth(OUTLINE_WIDTH);
	//m_OutLine.ShowOutLine();

	ShowWindow();

}

/************************************************************************
*FUNCTION			: vInit
*DESCRIPTION		: For Subscribing the ASF Message Call
*PARAMETER			: None.
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/

tVoid recoveryupdatewnd::vInit()
{
	ETG_TRACE_USR2(("vInit"));
	Msg_UpdateProgressUpdate::vSubscribe(this);
}

/************************************************************************
*FUNCTION			: vDeInit
*DESCRIPTION		: For UnSubscribing the ASF Message Call
*PARAMETER			: None.
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid recoveryupdatewnd::vDeInit()
{
	ETG_TRACE_USR2(("vDeInit"));
	Msg_UpdateProgressUpdate::vUnSubscribe(this);
}

/************************************************************************
*FUNCTION			: DeInitalizeWnd
*DESCRIPTION		: For Closing the Window and Clear all Heap Variables.
*PARAMETER			: None.
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid recoveryupdatewnd::DeInitalizeWnd()
{
	vDeInit();
	CloseWindow();
}

/************************************************************************
*FUNCTION			: vProcess
*DESCRIPTION		: To Process the Msg_UpdateProgressUpdate ASF Message.
*PARAMETER			: Msg_UpdateProgressUpdate (I)
*PARAMETER				ASF Message Process.
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid recoveryupdatewnd::vProcess(Msg_UpdateProgressUpdate *pMsg)
{
	tBool bRedrawIsRequired = false;

	FCSWUPD_NS_FCSWUPD::trUpdProgress const &UpdateProgress = SWU_ASF_GET_DATA(pMsg->payload, UpdateProgress);

	ETG_TRACE_USR4(("Media Train:%s", UpdateProgress.getTrain().c_str()));
	ETG_TRACE_USR4(("Device Name:%s", UpdateProgress.getDeviceName().c_str()));
	ETG_TRACE_USR4(("Module Name:%s", UpdateProgress.getModuleName().c_str()));
	ETG_TRACE_USR4(("SubModule Name:%s", UpdateProgress.getSubModuleName().c_str()));
	ETG_TRACE_USR4(("Ref Key:%s", UpdateProgress.getRefKey().c_str()));
	ETG_TRACE_USR4(("Source:%s", UpdateProgress.getSource().c_str()));
	ETG_TRACE_USR4(("Line 1:%s", UpdateProgress.getLine1().c_str()));
	ETG_TRACE_USR4(("Line 2:%s", UpdateProgress.getLine2().c_str()));
	ETG_TRACE_USR4(("LUA command:%s", UpdateProgress.getLuaCmd().c_str()));
	ETG_TRACE_USR4(("Retries:%d", UpdateProgress.getU32Retries()));
	ETG_TRACE_USR4(("Completed:%d", UpdateProgress.getU32NumComplete()));
	ETG_TRACE_USR4(("Not Completed:%d", UpdateProgress.getU32NumNotApplicable()));
	ETG_TRACE_USR4(("Failed:%d", UpdateProgress.getU32NumFailed()));
	ETG_TRACE_USR4(("Remaining:%d", UpdateProgress.getU32NumRemaining()));
	ETG_TRACE_USR4(("Sub Module completed Percent:%d", UpdateProgress.getU8SubModulePercentComplete()));
	ETG_TRACE_USR4(("completed Percent:%d", UpdateProgress.getU8ReleasePercentComplete()));
	ETG_TRACE_USR4(("Estimated Update Time:%u", UpdateProgress.getU32EstimatedUpdateTimeSec()));

    tS32 s32RemainingMinOld=swuhmi_configurator_inf4cv::instance()->m_s32RemainingTime;
        
    float fRemainingMin=static_cast<float>((UpdateProgress.getU32EstimatedUpdateTimeSec() / 60.0) * (100.0 -UpdateProgress.getU8ReleasePercentComplete()) / 100.0); //coverity fix
    tS32 s32RemainingMin = static_cast<tS32>(round(fRemainingMin));
	ETG_TRACE_USR4(("s32RemainingMinOld:%u", s32RemainingMinOld));
	ETG_TRACE_USR4(("s32RemainingMin:%u", s32RemainingMin));
    if (s32RemainingMinOld != s32RemainingMin)  {
           m_strRemainingTime.clear();
           m_strRemainingTime.assign(s32RemainingMin ? "~ " : "< ");

           char str[15];

           swuhmi_configurator_inf4cv::instance()->m_s32RemainingTime = s32RemainingMin;
           sprintf(str, "%d", s32RemainingMin ? s32RemainingMin : 1);

           m_strRemainingTime.append(str);
           m_strRemainingTime.append(" min");
           bRedrawIsRequired = true;
           ETG_TRACE_USR2(("recoveryupdatewnd::Msg_UpdateProgressUpdate(): Remaining time:%s", m_strRemainingTime.c_str()));

        }

	float fProgressBarFillup = 0;
	tU8 u8PercentageComplete = UpdateProgress.getU8ReleasePercentComplete();
	fProgressBarFillup = static_cast<float>(u8PercentageComplete / 100.0);
	ETG_TRACE_USR4(("s32PerModuleProgressVal:%f", fProgressBarFillup));

	if(m_fProgressValue != fProgressBarFillup)
	{
		ETG_TRACE_USR4(("Progress Fill up:%f", fProgressBarFillup));
		m_fProgressValue = fProgressBarFillup;
		m_inf4cvProgressBar.SetProgressValue(m_fProgressValue);
		bRedrawIsRequired = true;
	}


	if(bRedrawIsRequired) {
		inf4cv_graphicsinterface::SwitchSurface();
		InitalizeWnd();
	}
}
/************************************************************************
*FUNCTION			: OnRemainingTimeExpiry
*DESCRIPTION		: Remaining Time Expiration.
*PARAMETER			: None
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid recoveryupdatewnd::OnRemainingTimeExpiry()
{
	ETG_TRACE_USR2(("OnRemainingTimeExpiry"));

        //	swuhmi_configurator_inf4cv::instance()->m_s32RemainingTime = swuhmi_configurator_inf4cv::instance()->m_s32RemainingTime - 1;

        StopRemainingTimeTimer();
}


}




