
/************************************************************************
*FILE					: swuhmi_translation_inf4cv.cpp
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Project Specific Translation Handling.
*DESCRIPTION			: Translation is handled via XML.
*AUTHOR					: RRD7KOR (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2018	| 0.1		| RRD7KOR			| Initial
************************************************************************/

#include "swuhmi_translation_inf4cv.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL 			TR_TTFIS_SWUPDATE
#define ETG_I_TTFIS_CMD_PREFIX 			"SWUHMI_TRANSLATION_"
#define ETG_I_FILE_PREFIX 				SWUHMI::translation::
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_HMI
#include "trcGenProj/Header/swuhmi_translation_inf4cv.cpp.trc.h"
#endif

/************************************************************************
*FUNCTION			: translation
*DESCRIPTION		: Constructor of Translation.
*PARAMETER			: None
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
translation::translation()
{
	m_TranslationXMLFile.clear();
	m_pDocument = NULL;

}

/************************************************************************
*FUNCTION			: translation
*DESCRIPTION		: Destructor of Translation.
*PARAMETER			: None
*RETURNVALUE		: Void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
translation::~translation()
{
	// TODO Auto-generated destructor stub
	if(m_pDocument != NULL){
		m_pDocument = NULL;
	}
}

/************************************************************************
*FUNCTION			: OpenTranslationXMLFile
*DESCRIPTION		: Opening the XML File for Translation.
*PARAMETER			: string (I)
*PARAMETER				FilePathName
*RETURNVALUE		: tBool - Success / Failure
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tBool translation::OpenTranslationXMLFile(string _PathWithName)
{
	ETG_TRACE_USR4(("OpenTranslationXMLFile"));
	tBool bReturn = false;

	m_TranslationXMLFile = _PathWithName;
	ETG_TRACE_USR4(("translation XML File Path:%s", m_TranslationXMLFile.c_str()));

	if (!swu::exists(m_TranslationXMLFile.c_str()))
	{
		ETG_TRACE_USR1(("No translation XML File in Above Path"));
		return bReturn;
	}

	m_pDocument = new TiXmlDocument(m_TranslationXMLFile.c_str());
	if(m_pDocument != NULL)
	{
		if (!m_pDocument->LoadFile())
		{
			ETG_TRACE_USR1(("Not able to Load translation XML file"));
			return bReturn;
		}
		ETG_TRACE_USR4(("translation XML File is Opened Successfully"));
		bReturn = true;
	}
	return bReturn;
}

/************************************************************************
*FUNCTION			: GetTranslationText
*DESCRIPTION		: Getting the Translation Text From XML.
*PARAMETER			: E_TRANSLATION_XML_ID (I)
*PARAMETER				ID Of Text
*PARAMETER			  E_inf4cv_TRANSLATION_LANG (I)
*PARAMETER			    Translation Language.
*RETURNVALUE		: string - Translated Text.
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
string translation::GetTranslationText(string strTextId)
{
	ETG_TRACE_USR4(("GetTranslationText"));
	ETG_TRACE_COMP(( "Text Id: %s", strTextId.c_str()));

	string strTranslatedText("");

	TiXmlElement *root = m_pDocument->FirstChildElement();
	TiXmlElement *LangId = root->FirstChildElement("LangID");
	for(LangId; LangId ; LangId=LangId->NextSiblingElement()) {
		const char* buffer = LangId->Attribute("ID");
		// To fix CID 98628 
		if(buffer != nullptr) {
		   if(strcmp(buffer, strTextId.c_str()) == 0) {
		      strTranslatedText = LangId->Attribute("Text");
		      break;
		   }
		}
	}

	return strTranslatedText;
}

