
/************************************************************************
*FILE					: swuhmi_progressbar_inf4cv.cpp
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Project Specific Progress Bar Widget.
*DESCRIPTION			: Normal Mode inf4cv Progress Bar is Implemented.
*AUTHOR					: RRD7KOR (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2018	| 0.1		| RRD7KOR			| Initial
************************************************************************/

#include "swuhmi_progressbar_inf4cv.h"
#include "swuhmi_graphicsinterface_inf4cv.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL 			TR_TTFIS_SWUPDATE
#define ETG_I_TTFIS_CMD_PREFIX 			"SWUHMI_LABEL_"
#define ETG_I_FILE_PREFIX 				SWUHMI::LABEL::
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_HMI
#include "trcGenProj/Header/swuhmi_progressbar_inf4cv.cpp.trc.h"
#endif

/************************************************************************
*FUNCTION			: inf4cv_progressbar
*DESCRIPTION		: Constructor of ProgressBar
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
inf4cv_progressbar::inf4cv_progressbar()
{
	// TODO Auto-generated constructor stub
	m_strBackGndImagePath.empty();
	m_strForeGndImagePath.empty();
	m_strMeasurementImagePath.empty();
	m_strProgressPtrImagePath.empty();
	m_fProgressValue = 0;

}

/************************************************************************
*FUNCTION			: inf4cv_progressbar
*DESCRIPTION		: Destructor of ProgressBar
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
inf4cv_progressbar::~inf4cv_progressbar() {
	// TODO Auto-generated destructor stub14
}

/************************************************************************
*FUNCTION			: SetBackGndImage
*DESCRIPTION		: To Set the BackGround Image Path
*PARAMETER			: string (I)
*PARAMETER				Image Path With Name
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid inf4cv_progressbar::SetBackGndImage(string strImagePath)
{
	m_strBackGndImagePath = strImagePath;
}

/************************************************************************
*FUNCTION			: SetForeGndImage
*DESCRIPTION		: To Set the BackGround Image Path
*PARAMETER			: string (I)
*PARAMETER				Image Path With Name
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid inf4cv_progressbar::SetForeGndImage(string strImagePath)
{
	m_strForeGndImagePath = strImagePath;
}

/************************************************************************
*FUNCTION			: SetMeasurementImage
*DESCRIPTION		: To Set the Measurement Image Path
*PARAMETER			: string (I)
*PARAMETER				Image Path With Name
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid inf4cv_progressbar::SetMeasurementImage(string strImagePath)
{
	m_strMeasurementImagePath = strImagePath;
}

/************************************************************************
*FUNCTION			: SetProgressPointerImage
*DESCRIPTION		: To Set the Pointer Image Path
*PARAMETER			: string (I)
*PARAMETER				Image Path With Name
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid inf4cv_progressbar::SetProgressPointerImage(string strImagePath)
{
	m_strProgressPtrImagePath = strImagePath;
}

/************************************************************************
*FUNCTION			: SetProgressValue
*DESCRIPTION		: To Set the Progress Bar Value.
*PARAMETER			: float (I)
*PARAMETER				Progress Bar Value.
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid inf4cv_progressbar::SetProgressValue(float fProgressValue)
{
	m_fProgressValue = fProgressValue;
}

/************************************************************************
*FUNCTION			: Showinf4cvProgressBar
*DESCRIPTION		: Show the inf4cv Progress Bar
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid inf4cv_progressbar::Showinf4cvProgressBar()
{
	ETG_TRACE_USR4(("Showinf4cvProgressBar"));
	INF4CV_ProgressBarInfo stProgressBarInfo;
	stProgressBarInfo.u16XPos 							= m_u16Xpos;
	stProgressBarInfo.u16YPos 							= m_u16Ypos;
	stProgressBarInfo.fProgressVal						= m_fProgressValue;
	stProgressBarInfo.strBackGndImagePath				= m_strBackGndImagePath;
	stProgressBarInfo.strForeGndImagePath				= m_strForeGndImagePath;
	stProgressBarInfo.strMeasuringImagePath				= m_strMeasurementImagePath;
	stProgressBarInfo.strPointerImagePath				= m_strProgressPtrImagePath;

	inf4cv_graphicsinterface::Showinf4cvProgressBar(stProgressBarInfo);
}

