
/************************************************************************
*FILE					: swuhmi_graphicsinterface_inf4cv.cpp
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Project Specific Graphics Interface.
*AUTHOR					: RRD7KOR (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2018	| 0.1		| RRD7KOR			| Initial
************************************************************************/

#include "swuhmi_graphicsinterface_inf4cv.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL 			TR_TTFIS_SWUPDATE
#define ETG_I_TTFIS_CMD_PREFIX 			"SWUHMI_LABEL_"
#define ETG_I_FILE_PREFIX 				SWUHMI::LABEL::
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_HMI
#include "trcGenProj/Header/swuhmi_graphicsinterface_inf4cv.cpp.trc.h"
#endif

inf4cv_carioadapter* inf4cv_graphicsinterface::m_pinf4cv_CairoAdapterInst = NULL;

/************************************************************************
*FUNCTION			: inf4cv_graphicsinterface
*DESCRIPTION		: Constructor of inf4cv_graphicsinterface
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
inf4cv_graphicsinterface::inf4cv_graphicsinterface() {
	// TODO Auto-generated constructor stub

}

/************************************************************************
*FUNCTION			: inf4cv_graphicsinterface
*DESCRIPTION		: Destructor of inf4cv_graphicsinterface
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
inf4cv_graphicsinterface::~inf4cv_graphicsinterface() {
	// TODO Auto-generated destructor stub
}

/************************************************************************
*FUNCTION			: InitializeGraphics
*DESCRIPTION		: Initailize the Cairo Graphics
*PARAMETER			: None
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid inf4cv_graphicsinterface::InitializeGraphics()
{
	ETG_TRACE_USR4(("InitializeGraphics"));

	m_pinf4cv_CairoAdapterInst = new inf4cv_carioadapter();
	m_pCairoAdapterInst		 = m_pinf4cv_CairoAdapterInst;

	if(m_pCairoAdapterInst != NULL)
		m_pCairoAdapterInst->InitializeCairoAdapter();
}

/************************************************************************
*FUNCTION			: Showinf4cvProgressBar
*DESCRIPTION		: Interface to Graphics.
*PARAMETER			: struct (I)
*PARAMETER				Contains all info for progress bar drawing.
*RETURNVALUE		: void
*HISTORY:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2016	| 0.1		| RRD7KOR			| Initial
************************************************************************/
tVoid inf4cv_graphicsinterface::Showinf4cvProgressBar(INF4CV_ProgressBarInfo stProgressBarInfo)
{
	ETG_TRACE_USR4(("Showinf4cvProgressBar"));

	if(m_pinf4cv_CairoAdapterInst != NULL)
	{
		m_pinf4cv_CairoAdapterInst->Drawinf4cvProgressBar(stProgressBarInfo);
	}
}

