/*
 * swuhmi_systemsettings_inf4cv.h
 *
 *  Created on: Mar 20, 2018
 *      Author: rrd7kor
 */

#ifndef SWUHMI_SYSTEMSETTINGS_INF4CV_H_
#define SWUHMI_SYSTEMSETTINGS_INF4CV_H_

#include "config/swuhmi_includes_inf4cv.h"
#include "main/swuhmi_systemsettings.h"
#include "widgets/swuhmi_translation_inf4cv.h"
#include "swuhmi_configurator_inf4cv.h"

namespace swuhmi {

static const string _inf4cvfontfile = "BoschJevaSans.ttf";
static const string _inf4cvdefaultLang = "English_UK";
static const string _inf4cvLogo = "inf4cv_Logo.png";
static const string _inf4cvBackGroundImage = "inf4cv_Background.png";
extern bool isKDSOnlystick;

#define BOSCH_LOGO_X_POS                         201
#define BOSCH_LOGO_Y_POS                         151

class swuhmi_systemsettings_inf4cv : public swuhmi_systemsettings ,
										public swu::Singleton<swuhmi_systemsettings_inf4cv>
{
public:
	swuhmi_systemsettings_inf4cv();
	virtual ~swuhmi_systemsettings_inf4cv();

	virtual tVoid DoSystemSettings();
	string GetTranslationText(string strTexId);
        std::string _inf4cvBackGroundImageLoc;

private:
	tBool bopenSystemSettingsFile();
	tVoid vgetLanguageSettings();
	tVoid vgetTargetSettings();
	tVoid vApplyDefaltSettings();
	tVoid vdoTranslationSettings();
	tVoid vLoadDefaultLanguageSettings();
	tVoid vLoadDefaultTargetSettings();


private:
	translation				m_TranslationInst;
	tBool					m_bTranslationStatus;

public:
	string _inf4cv_pbar_backgnd;
	string _inf4cv_pbar_foregnd;
	string _inf4cv_pbar_measuring;
	string _inf4cv_pbar_pointer;
};

} /* namespace swuhmi */
#endif /* SWUHMI_SYSTEMSETTINGS_INF4CV_H_ */
