/*
 * swuhmi_systemsettings_inf4cv.cpp
 *
 *  Created on: Jul 15, 2016
 *      Author: vri7cob
 */

#include "swuhmi_systemsettings_inf4cv.h"
#include "util/swu_robustFile.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS 		TR_CLASS_SWUPDATE_HMI
#include "trcGenProj/Header/swuhmi_systemsettings_inf4cv.cpp.trc.h"
#endif

namespace swuhmi {

swuhmi_systemsettings_inf4cv::swuhmi_systemsettings_inf4cv() :
		_inf4cv_pbar_backgnd(""),
		_inf4cv_pbar_foregnd(""),
		_inf4cv_pbar_measuring(""),
		_inf4cv_pbar_pointer(""),
        _inf4cvBackGroundImageLoc(""),
		m_bTranslationStatus(false)
{

}

swuhmi_systemsettings_inf4cv::~swuhmi_systemsettings_inf4cv() {
	// TODO Auto-generated destructor stub
}

tVoid swuhmi_systemsettings_inf4cv::DoSystemSettings() {

	ETG_TRACE_USR1(("DoSystemSettings"));
	if(bopenSystemSettingsFile())
	{
		vgetLanguageSettings();
		vgetTargetSettings();
	}
	else {
		vApplyDefaltSettings();
	}

	//Target Settings
	ETG_TRACE_USR4(("_oemtype:%s", _oemtype.c_str()));
	ETG_TRACE_USR4(("_displayType:%s", _displayType.c_str()));
	ETG_TRACE_USR4(("_backgndImageLoc:%s", _backgndImageLoc.c_str()));
	ETG_TRACE_USR4(("_pbarImageLoc:%s", _pbarImageLoc.c_str()));

	//Language Settings
	ETG_TRACE_USR4(("_fontfilepath:%s", _fontfilepath.c_str()));
	ETG_TRACE_USR4(("_transLanName:%s", _transLanName.c_str()));
	ETG_TRACE_USR4(("_translationLanPath:%s", _translationLanPath.c_str()));
}


tBool swuhmi_systemsettings_inf4cv::bopenSystemSettingsFile()
{
	tBool bReturn = false;
	ETG_TRACE_USR1(("OpenSystemSettingsFile"));

	bool existing = false;
	swu::exists(_settingFileLoc, existing);
	ETG_TRACE_USR4(("Existing File:%d", existing));

	if(existing) {
		swu::RobustFile rf(_settingFileLoc);
		rf.init();
		if (rf.restore()) {
			m_hmiXmlDoc.LoadFile(_settingFileLoc.c_str());
			m_phmiSettingsroot = m_hmiXmlDoc.FirstChildElement();
			ETG_TRACE_USR4(("hmisettings file is found "));
			bReturn = true;
		}
	}
	else
		ETG_TRACE_USR4(("hmisettings file is not found:%s", _settingFileLoc.c_str()));
	return bReturn;
}

tVoid swuhmi_systemsettings_inf4cv::vgetLanguageSettings() {

	ETG_TRACE_USR1(("vgetLanguageSettings"));

	TiXmlElement *pLangSettings = m_phmiSettingsroot->FirstChildElement("LANGUAGESETTINGS");
	if(pLangSettings) {

		TiXmlElement *pFontFilePath = pLangSettings->FirstChildElement("FONTFILEPATH");
		if(pFontFilePath){
			_fontfilepath = string(pFontFilePath->GetText());
			if(!swu::exists(_fontfilepath)) {
				vLoadDefaultLanguageSettings();
				return;
			}
		}
		else
			_fontfilepath = _DefaultBase + _inf4cvfontfile;

		TiXmlElement *pLangName = pLangSettings->FirstChildElement("LANGUAGENAME");
		if(pLangName) {
			_transLanName = string(pLangName->GetText());
		}
		else
			_transLanName = _inf4cvdefaultLang;

		TiXmlElement *pTransLangPath = pLangSettings->FirstChildElement("TRANSFILEPATH");
		if(pTransLangPath) {
			_translationLanPath = string(pTransLangPath->GetText());
			if(!swu::exists(_translationLanPath))
				vLoadDefaultLanguageSettings();
			else
				vdoTranslationSettings();
		}
		else
			vLoadDefaultLanguageSettings();
	}
	else
		vLoadDefaultLanguageSettings();
}


tVoid swuhmi_systemsettings_inf4cv::vgetTargetSettings() {

	ETG_TRACE_USR1(("vgetTargetSettings"));

	TiXmlElement *pTargetSettings = m_phmiSettingsroot->FirstChildElement("TARGETSETTINGS");
	if(pTargetSettings) {

		TiXmlElement *poemType = pTargetSettings->FirstChildElement("VARIANTTYPE");
		if(poemType)
			_oemtype = string(poemType->GetText());

		TiXmlElement *pDisplayOrientation = pTargetSettings->FirstChildElement("DISPLAYORIENTATION");
		if(pDisplayOrientation)
			_displayType = string(pDisplayOrientation->GetText());

		TiXmlElement *pBackGndImageLoc = pTargetSettings->FirstChildElement("BACKGNDIMAGELOC");
		if(pBackGndImageLoc) {
			_backgndImageLoc = string(pBackGndImageLoc->GetText());
			if(!swu::exists(_backgndImageLoc))
				_backgndImageLoc = _DefaultBase + _inf4cvLogo;
		}
		else
			_backgndImageLoc = _DefaultBase + _inf4cvLogo;

         TiXmlElement *pBackGndLogoImageLoc = pTargetSettings->FirstChildElement("BACKGNDIMAGELOGOLOC");
		if(pBackGndLogoImageLoc) {
			_inf4cvBackGroundImageLoc = string(pBackGndLogoImageLoc->GetText());
			if(!swu::exists(_inf4cvBackGroundImageLoc))
				_inf4cvBackGroundImageLoc = _DefaultBase + _inf4cvBackGroundImage;
		}
		else
			_inf4cvBackGroundImageLoc = _DefaultBase + _inf4cvBackGroundImage;
        
		TiXmlElement *pProgressBarImageLoc = pTargetSettings->FirstChildElement("PBARIMAGELOC");
		if(pProgressBarImageLoc) {
			_pbarImageLoc = string(pProgressBarImageLoc->GetText());
			if(!swu::exists(_pbarImageLoc))
				_pbarImageLoc = _DefaultBase;
		}
		else
			_pbarImageLoc = _DefaultBase;
	}
	else {
		_backgndImageLoc = _DefaultBase + _inf4cvLogo;
		_pbarImageLoc = _DefaultBase;
        _inf4cvBackGroundImageLoc = _DefaultBase + _inf4cvBackGroundImage;
	}

	_inf4cv_pbar_backgnd = _pbarImageLoc + INF4CV_PROGRESSBAR_BACKGND_IMAGE;  
	_inf4cv_pbar_foregnd = _pbarImageLoc + INF4CV_PROGRESSBAR_FILLER_IMAGE;
	

}

tVoid swuhmi_systemsettings_inf4cv::vApplyDefaltSettings() {

	ETG_TRACE_USR1(("vApplyDefaltSettings"));

	vLoadDefaultLanguageSettings();
	vLoadDefaultTargetSettings();
}

tVoid swuhmi_systemsettings_inf4cv::vLoadDefaultLanguageSettings() {

	ETG_TRACE_USR1(("vLoadDefaultLanguageSettings"));

	_fontfilepath = _DefaultBase + _inf4cvfontfile;
	_transLanName = _inf4cvdefaultLang;
	_translationLanPath = "";
}

tVoid swuhmi_systemsettings_inf4cv::vLoadDefaultTargetSettings() {

	ETG_TRACE_USR1(("vLoadDefaultTargetSettings"));

	_backgndImageLoc = _DefaultBase + _inf4cvLogo;
	_pbarImageLoc = _DefaultBase;
    _inf4cvBackGroundImageLoc = _DefaultBase + _inf4cvBackGroundImage;

	_inf4cv_pbar_backgnd = _pbarImageLoc + INF4CV_PROGRESSBAR_BACKGND_IMAGE;  
	_inf4cv_pbar_foregnd = _pbarImageLoc + INF4CV_PROGRESSBAR_FILLER_IMAGE;
	
}

tVoid swuhmi_systemsettings_inf4cv::vdoTranslationSettings() {

	ETG_TRACE_USR1(("vdoTranslationSettings"));
	if(!_translationLanPath.empty()) {
		if(m_TranslationInst.OpenTranslationXMLFile(_translationLanPath)) {
			m_bTranslationStatus = true;
			ETG_TRACE_USR4(("Translation XML is opened Successfully"));
		}
		else
			vLoadDefaultLanguageSettings();
	}

}

string swuhmi_systemsettings_inf4cv::GetTranslationText(string strTexId) {

	ETG_TRACE_USR1(("GetTranslationText"));
	string strtranslatedText("");
	if(m_bTranslationStatus)
	{
		strtranslatedText = m_TranslationInst.GetTranslationText(strTexId);
		ETG_TRACE_USR4(("Translated Text:%s", strtranslatedText.c_str()));
	}
	return strtranslatedText;
}



} /* namespace swuhmi */
