
/************************************************************************
*FILE					: swuhmi_configurator_inf4cv.h
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Project HMI Configurator.
*DESCRIPTION			: This is master of swuhmi, it controls all the functionality.
*AUTHOR					: RRD7KOR (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2018	| 0.1		| RRD7KOR			| Initial
----------------------------------------------------------------------------

************************************************************************/

#ifndef SWUHMI_CONFIGURATOR_INF4CV_H_
#define SWUHMI_CONFIGURATOR_INF4CV_H_

#include "config/swuhmi_includes_inf4cv.h"
#include "main/swuhmi_configurator.h"
#include "main/swuhmi_component_inc.h"
#include "windows/swuhmi_window.h"


#define IDLE_TIMER		30000 //30s

namespace swuhmi {

struct Msg_UpdateStateUpdate;
struct Msg_UpdateProgressUpdate;
struct Msg_UpdateErrorsUpdate;


/*struct Msg_IdleTimer: public swu::Msg< Msg_IdleTimer, FcSwUHMIRoot > {
	virtual tVoid vTrace() {};
};*/

class swuhmi_configurator_inf4cv : public swuhmi_configurator,
									public Singleton<swuhmi_configurator_inf4cv>
{
	friend class Singleton<swuhmi_configurator_inf4cv>;
public:
	swuhmi_configurator_inf4cv();
	virtual ~swuhmi_configurator_inf4cv();

	virtual tVoid vInit();
	virtual tVoid vDeInit();

	virtual tVoid Initializeconfigurator();
	virtual void traceState() { }
	virtual tVoid SetDelimiter(string strDelimiter);

	tVoid vProcess(Msg_UpdateStateUpdate *pMsg);
	tVoid vProcess(Msg_UpdateProgressUpdate *pMsg);
	tVoid vProcess(Msg_UpdateErrorsUpdate *pMsg);
	//tVoid vProcess(Msg_IdleTimer *pMsg);


	void simChangeNextWindow();
	FCSWUPD_NS_FCSWUPD::tenUpdState GetHMIState() { return m_eHMIState; }

	string GetDeviceId() { return m_strDeviceId; }

private:
	tVoid CreateUpdateWnd(E_HMIUPDATE_WND ehmiWnd);
	//swu::SwUpdTimer< swuhmi_configurator_inf4cv, Msg_IdleTimer> m_IdleTimer;

private:
	window*											m_pUpdateWindow;
	E_HMIUPDATE_WND									m_eCurrentHmiUpdateWnd;

	FCSWUPD_NS_FCSWUPD::tenUpdState 				m_eHMIState;

	string											m_strTargetVersion;
	string											m_strMediaSWVersion;
	string 											m_strSourceType;
	string											m_strDeviceId;
	tU16											m_u16FailedCount;
	//tBool											m_onetimeTimer;

public:
	tS32											m_s32RemainingTime;

};

}

#endif
