
/************************************************************************
*FILE					: swuhmi_includes_inf4cv.h
*SW-COMPONENT			: SW-Update
*DESCRIPTION			: Project HMI Includes.
*DESCRIPTION			: In Addition to Common Includes, added one's can be Included.
*AUTHOR					: RRD7KOR (RBEI/ECA)
*COPYRIGHT				: (c) 1996 – 2000 Blaupunkt Werke GmbH
*HISTORY				:
*Date 		| Rev. 		| Author 			| Modification
----------------------------------------------------------------------------
20-02-2018	| 0.1		| RRD7KOR			| Initial
************************************************************************/

#ifndef SWUHMI_HMIINCLUDES_INF4CV_H_
#define SWUHMI_HMIINCLUDES_INF4CV_H_

#include "config/swuhmi_includes.h"
#include <vector>
#include <map>

#define INF4CV_RESOURCES_PATH					"resources/"
#define FCSWUPD_SWUPDCORE_PERSISTENT_ROOT 	"/var/opt/bosch/persistent/swupdate/"
#define INF4CV_FONTFILE_NAME					"BoschJevaSans.ttf"
#define INF4CV_DEFAULT_LANGUAGE				"English_UK"
#define INF4CV_LOGO_NAME						"INF4CV_Logo.png"
#define INF4CV_ENGLISH_FONT_PATH				INF4CV_RESOURCES_PATH "BoschJevaSans.ttf"
#define INF4CV_LOGO_PATH						INF4CV_RESOURCES_PATH "INF4CV_Logo.png"

#define INF4CV_BACKGROUND_IMAGE_NAME						"BackGround_Inf4cv.png"
#define INF4CV_BACKGROUND_IMAGE_PATH						INF4CV_RESOURCES_PATH "BackGround_Inf4cv.png"

#define INF4CV_PROGRESSBAR_BACKGND_IMAGE        "ProgressbarBackground.png"
#define INF4CV_PROGRESSBAR_FILLER_IMAGE         "ProgressbarFiller.png"


 /*lint -e528 */ 
static string swucoreBase 					= FCSWUPD_SWUPDCORE_PERSISTENT_ROOT;
static string ResourcePath 					= INF4CV_RESOURCES_PATH;
static string DefaultFontFile 				= "BoschJevaSans.ttf";				
static string PersistentFontFilePath		= swucoreBase + "hmi/";
 /*lint +e528 */ 

#define LARGE_FONT_HEIGHT				24
#define MEDIUM_FONT_HEIGHT				20
#define SMALL_FONT_HEIGHT				20

typedef enum
{
	E_INVLAID_TRANSLATION_XML_ID = 0,
	E_UPDATE_SUCCESS_ID_1,						//Update Success ! Please Remove the USB Stick From the Target
	E_SWUPDATE_HEADER_ID_2,						//Software Update
	E_CURRENT_VERSION_ID_3,						//Current Version
	E_WAITING_FOR_MEDIA_ID_4,					//Waiting for Update Media
	E_UPDATE_FAILURE_ID_5,						//Software Update Failed
	E_MEDIA_STATUS_ID_6,						//Insert-Update media
	E_FROM_VERSION_ID_7,						//From Version
	E_TO_VERSION_ID_8,							//To Version
	E_REMAINING_TIME_ID_9,						//Remaining Time
	E_INFO_TEXT_ID_10,							//AVM, RVC and eCall are not available
	E_INFO_INF4CV_WAITING_FOR_MEDIUM_TEXT_ID_11,	//Please enter a valid USB stick to proceed with the Update. AVM, RVC and ecall are not available
	E_INFO_MEDIUM_REMOVED_ID_12,				//The USB stick was removed. Please re-enter the stick to proceed with the Update
	E_INFO_DEVICE_ID_13							//Your device ID

}E_TRANSLATION_XML_ID;

static const string _statuswnd_headerId = "SWUpdate_Initializing.Textbox_SWUpdate";
static const string _statuswnd_messageId = "SWUpdate_InvalidUSB.Textbox_Line";
static const string _statuswnd_messageId_NoUsb = "SWUpdate_NoUSB.Textbox_Line";
static const string _recoverywnd_headerId = "SWUpdate_Initializing.Textbox_SWUpdate";
static const string _recoverywnd_messageId = "SWUpdate_Inprogress.Textbox_Line";
static const string _recoverywnd_timeId = "SWUpdate_Inprogress.Textbox_RemainingTime";
static const string _statuswnd_successId = "SWUpdate_Successful.Textbox_Line";
static const string _statuswnd_failureId = "SWUpdate_Failed.Textbox_Line";
static const string _statuswnd_usbremovedId = "SWUpdate_USB_Removed.Textbox_Popup_Text_Line";
static const string _statuswnd_usbinsertionId= "SWUpdate_USB_Insert.Textbox_Popup_Text_Line";
static const string _statuswnd_init= "SWUpdate_Initializing.Textbox_Initializing";
static const string _sysconfigstatuswnd_headerId = "SysConfigData_FileTransfer_Initializing.Textbox_ConfigDataUpdate";
static const string _sysconfigstatuswnd_messageId = "SysConfigData_FileTransfer_Initializing.Textbox_Line";
static const string _sysconfigstatuswnd_successId = "SysConfigData_FileTransfer_Successful.Textbox_Popup_Text_Line";
static const string _sysconfigstatuswnd_failureId = "SysConfigData_FileTransfer_Failed.Textbox_Popup_Text_Line";
static const string kdsDisplayTextMarker = "/opt/bosch/base/bin/resources/KDSDisplayTextEnabled";
static const string kdsSubModuleName = "PDCONFIG";
static const string partNumConfiguredMarker ="/tmp/nopartnumconfigured";

struct INF4CV_ProgressBarInfo
{
	tU16 		u16XPos;
	tU16		u16YPos;
	float		fProgressVal;
	string 		strBackGndImagePath;
	string 		strForeGndImagePath;
	string 		strMeasuringImagePath;
	string 		strPointerImagePath;

};

typedef enum
{
	INVALID_WND = 0,
    RECOVERY_UPDATE_WND,
    STATUS_UPDATE_WND

}E_HMIUPDATE_WND;


#endif /* INF4CV_HMIINCLUDES_H_ */
