
#include <iostream>
#include <fstream>
#include "fcswupdatesrv/FcSwUpdateSrvJson.h"
#include "fcswupdatesrv/FcSwUpdateSrvProxy.h"
#include "main/fcswupd_component.h"
#include "util/swu_constants.hpp"
#include "util/swu_filesystem.h"
#include "util/swu_preInit.h"
#include "util/swu_globallog.h"
#include "main/fcswupd_dataStore.h"
#include "main/fcswupd_srv.h"
#include "main/fcswupd_main.h"
#include "main/fcswupd_mainMessages.hpp"
#include "main/fcswupd_systemData.h"
#include "main/fcswupd_releaseFilterIf.h"
#include "parser_bosch/fcswupd_parserBosch.h"
#include "parser_cms/fcswupd_parserCMS.h"
#include "configurator/fcswupd_configuratorRecoveryGeneric.h"
#include "configurator/fcswupd_configuratorHmiGeneric.h"
#include "ctrl/fcswupd_ctrlHmiGeneric.hpp"
#include "ctrl/fcswupd_ctrlRecoveryGeneric.hpp"
#include "ctrl/fcswupd_ctrlProgress.h"
#include "main/fcswupd_propDevMgr.h"
#include "main/fcswupd_prmIf.h"
#include "main/fcswupd_autoMount.h"
#include "main/fcswupd_srvGeneric.h"
#include "main/fcswupd_hmisettings.h"
#include "main/fcswupd_prj.h"



#define ETG_I_FILE_PREFIX fcswupdate::FcSwUpdProject::instance()->

#include "util/fcswupd_trace.hpp"
#define ETG_I_TTFIS_CMD_PREFIX "FCSWUPD_PRJ_"
#define ETG_I_TRACE_CHANNEL    TR_TTFIS_FCSWUPDATE
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FCSWUPDATE_MAIN
#define ETG_I_FILE_PREFIX fcswupdate::FcSwUpdProject::instance()->
#include "trcGenProj/Header/fcswupd_prj.cpp.trc.h"
#endif

namespace fcswupdate {


static class PreInitPrj: public swu::PreInit<FcSwUpdRoot> {
public:
   // method will be called at start of initialization of fcswupd
   virtual void execute() {
      Config::setUsePersistentPart(true);
   }
} _preInitPrj;


FcSwUpdProjectSpecific *poGetProjectSpecific() {
   return FcSwUpdProject::instance();
}

FcSwUpdProject::FcSwUpdProject(){
   /*
      config has to be created in constructor, since it may overwrite
      global configurations that will be used during construction/initialization
      of other members of fcSwUpdate
   */

}

tVoid FcSwUpdProject::vOnSystemDataChanged() {
   ETG_TRACE_USR1(("FcSwUpdProject::vOnSystemDataChanged() START"));
   FCSWUPD_NS_FCSWUPD_T::trUpdState rState = FcSwUpdSrv::instance()->getUpdateState();
   std::string relName=Config::instance()->cfg_RunningSwVersionDisplay.get();

   ETG_TRACE_USR1(("FcSwUpdProject::vOnSystemDataChanged() relName=%s", relName.c_str()));
   
   std::string overallCISSWVer=Config::instance()->cfg_RunningOverallCISSWVer.get();
   ETG_TRACE_USR1(("FcSwUpdProject::vOnSystemDataChanged() overallCISSWVer=%s", overallCISSWVer.c_str()));

   rState.setTrain( relName);
   rState.setMuVersion( relName);
   rState.setOverallCISSWVer( overallCISSWVer);
   // todo: ask diagIf
   // todo: check if HMI needs this or if it is already known in context
   rState.setBHasEngineeringOptions(true);
   // todo: check if BCustomSupported is needed
   rState.setBCustomSupported(false);
   rState.setBCustomAvail(false);

   // setBInterruptible has to be handle by CTRL
   // todo: setBDevicesReady should depend on availabilty of SwUpdCoreSrv
   rState.setBDevicesReady(true);

   FCSWUPD_SET_ASF_PROPERTY(FcSwUpdSrv, rState, UpdateState);
   ETG_TRACE_USR1(("FcSwUpdProject::vOnSystemDataChanged() END"));

};




tVoid FcSwUpdProject::vInitPrj() {
   ETG_TRACE_USR1(("FcSwUpdProject::vInitPrj() START"));
   ETG_I_REGISTER_FILE();
   Msg_NotifyDevManagerChanged::vSubscribe(this);
   //Msg_CopyProgressBarElements::vSubscribe(this);


   if (Config::instance()->cfg_EnterRecovery.readAsBool()) {
      if (Config::instance()->cfg_UseOwnAutomountInRecovery.readAsBool()) {
         _memberList.addMember(AutoMount::instance());
      } else {
         _memberList.addMember(PrmIf::instance());
      }
   }
   else if (Config::instance()->cfg_EnterFullOperation.readAsBool()) {
      _memberList.addMember(PrmIf::instance());
   }
//   _memberList.addMember(CSMMgrIf::instance());
   ETG_TRACE_USR1(("FcSwUpdProject::adding member() SrvGeneric"));
   _memberList.addMember(SrvGeneric::instance());

   ETG_TRACE_USR1(("FcSwUpdProject::initialize member list"));

   ETG_TRACE_USR1(("FcSwUpdProject::initialize member list"));
   _memberList.vInit();



   //   FcSwUpdCore::instance()->addBxmlFilter(new ReleaseFilterMatch("bla", "1815"));



   SrvGeneric::instance()->setFeature(SrvGeneric::tenFeatures_GetUpdateHistoryRequest);
   SrvGeneric::instance()->setFeature(SrvGeneric::tenFeatures_GetUpdateHistoryScopedRequest);
   SrvGeneric::instance()->setFeature(SrvGeneric::tenFeatures_GetTargetStateRequest);
   SrvGeneric::instance()->setFeature(SrvGeneric::tenFeatures_NotifyCtrlError);
   SrvGeneric::instance()->setFeature(SrvGeneric::tenFeatures_NotifyProgress);
   SrvGeneric::instance()->setFeature(SrvGeneric::tenFeatures_SetAllowRecoveryMode);
   SrvGeneric::instance()->setFeature(SrvGeneric::tenFeatures_NotifyCtrlResult);
   SrvGeneric::instance()->setFeature(SrvGeneric::tenFeatures_AutoHandlePostImageRelease);
   Config::instance()->cfg_EnterRecovery.readAsBool();
   Config::instance()->cfg_EnterEngineering.readAsBool();
   if (Config::instance()->cfg_EnterRecovery.readAsBool() ||
       Config::instance()->cfg_EnterEngineering.readAsBool()) {

   }
   else {

      Config::instance()->cfg_HmiCfgDefaultReleaseFilter.set((ConfiguratorUtil::enConfigOption_NewOnly));


   }

   vSetPrjState(tenPrjState_NotReady);
   vOnSystemDataChanged();
   ETG_TRACE_USR1(("FcSwUpdProject::vInitPrj() END"));
}

tVoid FcSwUpdProject::vDeInitPrj() {
   _memberList.vDeInit();
   ETG_I_UNREGISTER_FILE();
}

void FcSwUpdProject::traceState() {
   ETG_TRACE_COMP(("  ApplyDocRspPending=%u", IS_ASF_RESPONSE_PENDING(FCSWUPD_NS_FCSWUPD, ApplyDoc)));
   ETG_TRACE_COMP(("  cfg_EnterRecovery=%u", Config::instance()->cfg_EnterRecovery.readAsBool()));

   _memberList.traceState(getName());

}

// this class has to be implemented project-specific
tVoid FcSwUpdProject::vOnFcSwUpdState(tenSwUpdateState enState) {
   ETG_TRACE_COMP(("FcSwUpdProject::vOnFcSwUpdState(%u)", ETG_CENUM(tenSwUpdateState, enState)));

   FcSwUpdCore *core = FcSwUpdCore::instance();
   FCSWUPD_NS_FCSWUPD_T::trUpdState rAsfState = FcSwUpdSrv::instance()->getUpdateState();

   // update state
   switch (enState) {
   case tenSwUpdateState_Idle: {

      ETG_TRACE_COMP_CLS((TR_CLASS_FCSWUPDATE_CUST, "setState of FcSwUpdate to %u", ETG_CENUM(tenPrjState, enState)));
      
      rAsfState.setEnState(FCSWUPD_NS_FCSWUPD_T::tenUpdState__Idle);
      if (Config::instance()->cfg_EnterFullOperation.get()) {
         Configurator *configurator = OSAL_NEW(ConfiguratorHmiGeneric);
         if (configurator) {
            core->vEnterUpdate(tenSwUpdateMode_Hmi, configurator);
         }
         configurator = 0;
         // all other states are maintained by CTRL and CONFIGURATOR
      }
      break;
   }
   case tenSwUpdateState_PreResult: {
      rAsfState.setEnState(FCSWUPD_NS_FCSWUPD_T::tenUpdState__PreResult);
   }
   default: {
      break;
   }

   }

   // update user
   FCSWUPD_NS_FCSWUPD_T::tenUser enUser = FCSWUPD_NS_FCSWUPD_T::tenUser__None;
   switch (core->enGetUpdateMode()) {
      case tenSwUpdateMode_Hmi:
         enUser = FCSWUPD_NS_FCSWUPD_T::tenUser__Service;
         break;
   }
   rAsfState.setEnUser(enUser);

   // send new state
   FCSWUPD_SET_ASF_PROPERTY(FcSwUpdSrv, rAsfState, UpdateState);
}

ParserIf* FcSwUpdProject::createPrjParser(trSourceInfo sourceInfo) {

   ETG_TRACE_USR1(("FcSwUpdProject::createPrjParser"));

   tenSwUpdateMode enUpdateMode = CampaignManager::instance()->enGetUpdateMode();
   swu::tenParserType parserType = static_cast<swu::tenParserType>(Config::instance()->cfg_ParserType.get());

   #if 0
   /*
     below conditions are usecases. 
     please think for a while before removing anythings.
    */
   if(enUpdateMode == tenSwUpdateMode_Engineering 
      || parserType == swu::ParserTypeBosch 
      || sourceInfo.enSourceType == tenSourceType_SCOMO_INDEX
      || Config::instance()->cfg_PostImageInstallationRunning.get()) {

      ETG_TRACE_USR4(("createPrjParser:return NULL for project parser"));
      return NULL;
   }
   
   if(!Config::instance()->cfg_VerifyAllianceXML.get()){
      ETG_TRACE_USR4(("createPrjParser:return NULL for project parser"));
      return NULL;
   }
   #endif
    return NULL;

}


tVoid FcSwUpdProject::vProcess(Msg_NotifyDevManagerChanged *pMsg) {
   (void)pMsg;
   vOnSystemDataChanged();
}

CtrlAdapter *FcSwUpdProject::pCreateCtrlAdapter(Ctrl *pCtrl, tenSwUpdateMode enMode) {
   ETG_TRACE_COMP(("FcSwUpdProject::pCreateCtrlAdapter(%u)", ETG_CENUM(tenSwUpdateMode, enMode)));
   switch (enMode) {
      case tenSwUpdateMode_Hmi:
      case tenSwUpdateMode_Scomo:
         return new CtrlHmiGeneric(pCtrl);
      case tenSwUpdateMode_Emergency:
         return new CtrlRecoveryGeneric(pCtrl);
      default:
         break;
   }
   ETG_TRACE_COMP(("FcSwUpdProject does not support enMode %u", enMode));
   return NULL;
}

ETG_I_CMD_DEFINE((vEnterRecoveryDownload, "vEnterRecoveryDownload"))
tVoid FcSwUpdProject::vEnterRecoveryDownload() {
   FcSwUpdCore *core = FcSwUpdCore::instance();
   ETG_TRACE_COMP(("FcSwUpdProject::vEnterRecoveryDownload, "
               "coreIdle= %d core=%p", core->bIsIdle(), core));
   SWU_ASSERT_RETURN(core->bIsIdle());
   Configurator *configurator = OSAL_NEW(ConfiguratorRecoveryGeneric);
   if (configurator) {
      Config::instance()->cfg_EnterRecovery.set(1, true);
      core->vEnterUpdate(tenSwUpdateMode_Emergency, configurator);
   }
   configurator = 0;
}



tVoid FcSwUpdProject::vSetPrjState(tenPrjState enPrjState) {
   swu::LOG_INTERFACE("UpdateState(hmistate:%u)",enPrjState);
   ETG_TRACE_COMP(
         ("FcSwUpdProject::vSetPrjState: ApplyDocRspPending=%u tenPrjState:%u",
          IS_ASF_RESPONSE_PENDING(FCSWUPD_NS_FCSWUPD, ApplyDoc),
          ETG_CENUM(FcSwUpdProject::tenPrjState,
                    enPrjState)));

   // send our new state to HMI

   FCSWUPD_NS_FCSWUPD_T::trUpdState rAsfState = FcSwUpdSrv::instance()->getUpdateState();
   if ((tU32)rAsfState.getEnState() != (tU32)enPrjState) {
      ETG_TRACE_COMP_CLS((TR_CLASS_FCSWUPDATE_CUST, "setState of FcSwUpdate to %u", ETG_CENUM(tenPrjState, enPrjState)));
   }

   rAsfState.setEnState((FCSWUPD_NS_FCSWUPD_T::tenUpdState)enPrjState);
   if (enPrjState == tenPrjState_Result) {
      rAsfState.setTrain( Config::instance()->cfg_RunningSwVersionDisplay.get());
      rAsfState.setHasValidTrain(true);
   } else if (enPrjState == tenPrjState_Running) {
      rAsfState.setTrain( Config::instance()->cfg_RunningSwVersionDisplay.get());
      rAsfState.setHasValidTrain(false);
   } else if (enPrjState == tenPrjState_WaitAllowRecoveryMode) {
     CtrlProgressSection *progSection=CampaignManager::instance()->getProgressSectionInst();
     SWU_ASSERT_RETURN(progSection);
     CtrlProgressSection::Statistics::Counters const &counters= progSection->getStatistics();
     rAsfState.setTrain( Config::instance()->cfg_RunningSwVersionDisplay.get());
     rAsfState.setSourceSwTrain(progSection->getFinalNameCustomer());
     rAsfState.setU32EstimatedUpdateTimeSec(counters.getTimes(CtrlProgressSection::Statistics::enAll).tAll);
   }
   
   tenSourceType sourceType=(tenSourceType)Config::instance()->cfg_CurrentMediaType.get();
   if ((tU32)rAsfState.getEnSourceType() != (tU32)sourceType) {
      ETG_TRACE_COMP_CLS((TR_CLASS_FCSWUPDATE_CUST, "Set source type to %u", ETG_CENUM(tenSourceType, enPrjState)));
   }
   rAsfState.setEnSourceType((FCSWUPD_NS_FCSWUPD_T::tenSourceType)sourceType);
   FCSWUPD_SET_ASF_PROPERTY(FcSwUpdSrv, rAsfState, UpdateState);
   // send applyDocResponse in case
   if (IS_ASF_RESPONSE_PENDING(FCSWUPD_NS_FCSWUPD, ApplyDoc)&& tenPrjState_Running==enPrjState) {
      FcSwUpdSrv::instance()->sendApplyDocResponse(true);
   }
}

tVoid FcSwUpdProject::vProcess(Msg_CopyProgressBarElements *pMsg) {

	tBool bPersistPathLoc = true;
	ETG_TRACE_USR1(("FcSwUpdProject::Msg_CopyProgressBarElements() START"));

	std::string strImagesrcPath = pMsg->_path;
	ETG_TRACE_USR4(("Source ProgressBar Image path:%s", strImagesrcPath.c_str()));
	std::string strImageDestPath = Config::getHMISettingsPath();

	if(!strImagesrcPath.empty()) {
		strImageDestPath = strImageDestPath + "progressbar";
		swu::makeDirectoryRecursive(strImageDestPath, 0700);
		strImageDestPath = strImageDestPath + "/";

		ETG_TRACE_USR4(("Destination ProgressBar Image path:%s", strImageDestPath.c_str()));

		std::string strSliderHeadersrc = strImagesrcPath + PROGRESSBAR_SRC_SLIDERHEADER;
		if(swu::exists(strSliderHeadersrc)) {
			std::string strSliderHeaderdest = strImageDestPath + PROGRESSBAR_DEST_SLIDERHEADER;
			if(swu::copyFile(strSliderHeadersrc, strSliderHeaderdest)){
				ETG_TRACE_USR4(("Slider Header Copy Success"));
			}
			else
				bPersistPathLoc = false;
		}
		else
			bPersistPathLoc = false;

		std::string strAlphaHeadersrc = strImagesrcPath + PROGRESSBAR_SRC_ALPHASLIDER;
		if(swu::exists(strAlphaHeadersrc)) {
			std::string strAlphaHeaderdest = strImageDestPath + PROGRESSBAR_DEST_ALPHASLIDER;
			if(swu::copyFile(strAlphaHeadersrc, strAlphaHeaderdest)){
				ETG_TRACE_USR4(("Alpha Header Copy Success"));
			}
			else
				bPersistPathLoc = false;
		}
		else
			bPersistPathLoc = false;

		std::string strTicksrsrc = strImagesrcPath + PROGRESSBAR_SRC_TICKS;
		if(swu::exists(strTicksrsrc)) {
			std::string strTicksdest = strImageDestPath + PROGRESSBAR_DEST_TICKS;
			if(swu::copyFile(strTicksrsrc, strTicksdest)){
				ETG_TRACE_USR4(("Ticks Copy Success"));
			}
			else
				bPersistPathLoc = false;
		}
		else
			bPersistPathLoc = false;

		std::string strPointersrc = strImagesrcPath + PROGRESSBAR_SRC_POINTER;
		if(swu::exists(strPointersrc)) {
			std::string strPointerdest = strImageDestPath + PROGRESSBAR_DEST_POINTER;
			if(swu::copyFile(strPointersrc, strPointerdest)){
				ETG_TRACE_USR4(("Pointer Copy Success"));
			}
			else
				bPersistPathLoc = false;
		}
		else
			bPersistPathLoc = false;
	}
	else
		bPersistPathLoc = false;

	if(bPersistPathLoc){
		ETG_TRACE_USR4(("Save PBAR Location:%s", strImageDestPath.c_str()));
		hmisettings::instance()->vSetProgressBarPath(strImageDestPath);
	}

	ETG_TRACE_USR1(("FcSwUpdProject::Msg_CopyProgressBarElements() END"));
}




}

