///////////////////////////////////////////////////////////
//  ep_mainloop.h
//  Implementation of the Class ep_mainloop based on epoll
//  Created on:      15-Mar-2013 14:03:00
//  Original author: rjk2hi
///////////////////////////////////////////////////////////

#if !defined(EP_MAINLOOP_H__INCLUDED_)
#define EP_MAINLOOP_H__INCLUDED_

#include <stdint.h>
#include <inttypes.h>
#include <map>

/**
 * Maximum possible events that could fire in a single iteration of main loop
 */
#define MAX_EVENTS 64
#define EP_HANDLE_INVALID			((int)-1)

typedef void (*ep_fptrPollBreak)(int evFd, unsigned int events);
/**
 * Implements epoll based main loop
 */
class ep_mainloop
{
private:
	ep_mainloop(const ep_mainloop&);
	ep_mainloop& operator = (const ep_mainloop &);   //Coverity fix for 47873
public:
	//Default constructor
	ep_mainloop();

	virtual ~ep_mainloop();

private:
	/**********************************************************************
	 *  FILE DESCRIPTORS USED FOR MAINLOOP
	 **********************************************************************/
	/**
	 * File descriptor for epoll
	 */
	int m_FdePoll;
	/**
	 * File descriptor for terminate mainloop
	 */
	int m_evFdTerminator;
	/**
	 * flag to check if main loop has to be run
	 */
	bool m_bRunMainLoop;

	/**
	 * trigger table
	 */
	std::map<int,ep_fptrPollBreak> m_trigtable;


	/**********************************************************************
	 *  Internal helpers
	 **********************************************************************/
	/**
	 * Helper to add fds to epoll
	 */
	bool bAddePollFd(int fd, uint32_t events);
	/**
	 * Helper to remove epollfd
	 */
	bool bDelePollFd(int fd);

public:
	/**********************************************************************
	 *  MAIN LOOP RELATED FUNCTIONS
	 **********************************************************************/
	/**
	 * Function to Add a file descriptor for polling in main loop
	 */
	bool bAddfdtoPoll(int& fd, uint32_t flags, ep_fptrPollBreak cbOnPollbreak);
	/**
	 * Function to remove file descriptor from main loop
	 */
	bool bRemovefdfromPoll(int &fd);
	/**
	 * Run the main loop continuosly
	 */
	void vRunMainLoop();
	/**
	 * Run a single iteration of main loop
	 */
	void vIterateMainLoop();
	/**
	 * Function to stop the main loop when in Continuos mode
	 */
	void vStopMainLoop();
	/**
	 * Helper function to check the validity of a file descriptor
	 */
	bool bIsFdValid(int &fd) const;
};
#endif // !defined(EP_MAINLOOP_H__INCLUDED_)
