/*******************************************************************************************
* FILE:			dl_V850UpdateCtrlManager.h
*
* SW-COMPONENT:Software Download
*
* DESCRIPTION:  This file is a main thread for V850DLCtrl component. Which is invoked from 
*					 V850 Client handler. This class implements the download sequence for V850.  
*				    This will wait for event posted be Client handler and Inc Receiver and 
*               processed events.
*				
* AUTHOR:		Aditya Kumar Jha
*
* COPYRIGHT:	(c) 2013  2014 Robert Bosch Engineering and Business Solutions Ltd, Bangalore.
*
*********************************************************************************************
* HISTORY:
* ------------------------------------------------------------------------------------------------
* Date 				| Rev. 				| Author 		   	| Modification
* ------------------------------------------------------------------------------------------------
*					29.08.2013	Aditya Kumar Jha
*					Initial Version.
*					18.02.2014	Aditya Kumar Jha : 
*					Added functionality for CRC and Version read.
*					03.04.2014	Aditya Kumar Jha : 
*					Added u8GetUpdateState().
*              14.03.2014	Aditya Kumar Jha : Change for ERROR CODE.
*              28.03.2014	Aditya Kumar Jha : added reading SW Version info from registry.
*              28.03.2014	Aditya Kumar Jha : remove mutex and introduce semaphore.
*              12.06.2014  Aditya Kumar Jha , Neera.K.Ponnappa : Implemented No CRC and No Reset
*              30.06.2014  Neera.K.Ponnappa : Implemented Security Bytes and Jtag ID
*              25.07.2014  Neera.K.Ponnappa : Implemented ClearCase label entry to registry
*              31.07.2014  Neera.K.Ponnappa
*                          Fixed Prio2 Lint warning
*              01.08.2014	Aditya Kumar Jha : IS1515_CRQ 4166-2: Prevention of: Linux root user can bypass 
*															 signature check of V850 code during software update.
*              06.08.2014  Neera.K.Ponnappa : Bug Fix CMG3GB-reset issue when Security Bytes/Jtag Bytes executed.
*              2014-08-27 Neera.K.Ponnappa,Apoorva K R  Implemented:CMG3G-5311  IS1604_Optimize Logging (update.log)@V850 Update Ctrl
*              16.09.2014	Aditya Kumar Jha : Fixes for Jira ticket CMG3GB-1128.
*              18.09.2014  Aditya Kumar Jha : added bIsSignByteSend().
*--------------------------------------------------------------------------------------------------------------------
* 17-03-2015		| 2.1	| VRI7COB (RBEI)	| Implementation of Change Request From Lothar.
* 					|		|					| After BL Update & Reset is send, Poll V850 to Get the Response For Active Session
* 					|		|					| Polling has to be done with time period of 2 sec for 8 cycles.
*--------------------------------------------------------------------------------------------------------------------
* 21-05-2015		| 2.2	| VRI7COB (RBEI)	| Changes are Made to Adapt For Adding the New Command line
* 					|		|					| Parameter "screenreinit"
*--------------------------------------------------------------------------------------------------------------------
* 14-07-2015        | 2.3   | VRI7COB (RBEI)    | Fixing the Reset Issues CMG3GB-2166
* 				    |       |  				    | After 10-60 ACK From V850 Retry For BL Mode (Lothar Changes)
*--------------------------------------------------------------------------------------------------------------------
*31-08-2015			| 2.4	| VRI7COB (RBEI)	| Fixing the Reset Issue on Normal Startup CMG3GB-2291
*					|		|					| pthread_cancel() and pthread_join() API is used to handle it.
*--------------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------------
*19-02-2016			| 2.8	| VRI7COB (RBEI)	| Implementing CRQ CMG3G-9596
*--------------------------------------------------------------------------------------------------------------------
*25-04-2016			| 2.9	| VRI7COB (RBEI)	| Fixing the Issue GMMY17-13603
*--------------------------------------------------------------------------------------------------------------------
********************************************************************************************/

#ifndef _DL_V850UPDATECTRLMANAGER_H_
#define _DL_V850UPDATECTRLMANAGER_H_

#include "dl_V850MessageFactory.h"
#include "dl_IncSender.h"
#include "dl_IncReceiver.h"
#include <sys/poll.h>
#include <sys/eventfd.h>
#include <time.h>
#include <string>
#include <semaphore.h>
#include <sstream>
#include "UpdateLog.h"
#include <list>

#define VERSION_MSGSZ_SIZE									240
#define V850_MODE_ERROR                                      21
#define TIMEOUT_ERROR                                         4


enum EN_EXTRA_OPERATIONS
{
	EN_INVALID_OPERATION = 0,
	EN_SCREENREINIT_OPERATION
};

enum EN_RETRY_AFTER
{
	EN_RETRY_AFTER_INVALID = 0,
	EN_RETRY_AFTER_RESET,
	EN_RETRY_AFTER_SWITCHBL
};

typedef uint32_t (*T_fCallback)(uint8_t u8DownloadProgress);
//T_fCallback g_fCallback = NULL;
using namespace ::ai_sw_update::common;
class dl_tclV850UpdateCtrlManager
{

public:
	tChar m_chSWVersion[VERSION_MSGSZ_SIZE+1];
	tChar m_chCheckSumVal[VERSION_MSGSZ_SIZE+1];
	tChar m_chCmdBuff[DEFAULT_MSGSZ+1];
	tChar m_chSWLabel[VERSION_MSGSZ_SIZE+1];

	dl_tclV850UpdateCtrlManager();
	virtual ~dl_tclV850UpdateCtrlManager();

	T_fCallback g_fCallback;

	sem_t m_updateCtrlSem;

	tBool bInitV850Message(  T_fCallback fCallback, tBool bIsAppStartOnly = false );		
	tU8 u8GetDownloadState() const;		

	static void* v850DlCtrlMgrThreadCallBack(void* arg)
	{
		reinterpret_cast<dl_tclV850UpdateCtrlManager *>(arg)->vDlCtrlMgrWorkedThread();
		return NULL;
	}

    static tVoid vHandleClientEvent( tInt evFd, tUInt eEventType );
	static tVoid vHandleDownloadCtrlEvent( tInt evFd, tUInt eEventType );
	static tVoid vHandleTimeoutEvent( tInt evFd, tUInt eEventType ); 

	tVoid vDlCtrlMgrWorkedThread();
	tS32 s32GetClientReqEventFD() const;
	static tS32 s32GetIncResEventFD();
	static MessageQueue *pGetMessageQueuePtr();
	static pthread_mutex_t *pGetdlfinishedmutexPtr();

	tVoid vSetFilePath( tCString CStrFilePath );
	tVoid vSetFileName( tCString CStrFileName );
	tVoid vSetMemeoryAddress( tU32 u32MemoryAddress );	
	tU8 u8GetUpdateState();
	tS8 s8GetCheckSumResult();
	tS8 s8GetSwVersionResult();
	tS8 s8GetSwLabelResult(); 
	tVoid vSetCrcEnable(tBool);  
	tVoid vSetResetEnable(tBool); 
	tVoid vSetListOfOpera(std::list<EN_EXTRA_OPERATIONS> listOfOpera);
	tVoid vSetSecurityByte( tCString CStrSecByteVal );
	tVoid vSetJtagByte( tCString CStrJtagByteVal );
	tVoid vSetSecFlag (); 
    tVoid vSetJtagFlag (); 
	tVoid vSetResetFlag();
	tVoid vSetCrcFlag();
	tVoid vSetVerFlag();
	tVoid vSetUpdateReqFlag();
	tChar s8GetErrorCode();
	tVoid vSetErrorCode(tChar chErrorCode );
	tVoid vWaitForSemRelease();
	static tBool bIsSignByteSend();

	tVoid KillManagerThread();
	//Start of CRQ CMG3G-9596
	tU8 u8getSecurityBitVal() { return m_u8SecurityBitVal; }
	tVoid vsetJTAG_CRC_Byte(tCString szJtagCRCByte);
	E_JTAG_VALIDATION_RESULT getJTAGValidationStatus() { return m_eJTAGValidationResult; }
	//End of CRQ CMG3G-9596

	tChar m_chErrorCode;
	tBool m_bIsBLProgMode;


	tBool m_bSecFlag;
	tBool m_bJtagFlag;
	tBool m_bCrcFlag;
	tBool m_bVerFlag;
	tBool m_bResetFlag;
	tBool m_bUpdateReqFlag;	
protected:
	/** Main loop **/
	ep_mainloop m_mainloop;

private:
	static tBool bIsV850DownloadSuccess;
	tU32 m_u32BlockSize;
	tU32 m_u32RBlockSize;
	tU32 m_u32LastChuckData;
	FILE * m_pFile;
	tU32 m_u32MemoryAddress;
	tCString m_szFilePath;
	tCString m_szFileName;
	tU8 m_u8DlState;
	tS32 m_evfdClientReq;
	tS32 m_evfdIncRx;
	tS32 m_evFdTimer;
	tBool m_bIsReadAllSWVersion;
	time_t m_sectimeout;
	tBool m_bIsBLUpdate;
	tBool m_bIsDnlFile;
	tBool m_bIsBLMode;
	tBool m_bIsBLSuccess;
	tBool m_bIsBLCmdSend;
	tU16 m_u16BlockID;
	Flash_strTYInfo m_DFInfo;
	tS8 m_s8CheckSumResult;
	tS8 m_s8SwVersionResult;
	tS8 m_s8SwLabelResult;
	tBool m_bResetEnabled; 
	tBool m_bCrcEnabled;
	std::list<EN_EXTRA_OPERATIONS> m_listOfOpera;
	
	tChar* m_szSecValToWrite;
	tChar* m_szJtagValToWrite;
	static tBool m_bIsSignByteSend;
	tBool m_bIsAppMode;

	tU32 m_u32RetryCount;
	EN_RETRY_AFTER m_eRetryAfter;

	pthread_t  m_v850DlCtrlMgrThread;


	dl_tclV850MessageFactory *m_pclV850MessageFactory;
	MessageQueue *m_pMessageQueue;
	dl_tclIncSender *m_pclIncSender;
	dl_tclIncReceiver *m_pclIncReceiver;	
	
	dl_tclV850UpdateCtrlManager ( const dl_tclV850UpdateCtrlManager & ); //Coverity fix for 48154
	dl_tclV850UpdateCtrlManager & operator = ( const dl_tclV850UpdateCtrlManager & );  //Coverity fix for 47859
	tBool bInitComponents( );
	tVoid vReadActiveSession( void );
	tVoid vStartInitOperation(  void );
	tVoid vCreateAndAddEventFD();
	tVoid vHandleClientReqMsg( tU8 u8Message );
	tVoid vHandleClientReqMsgExtended( tU8 u8Message );
	tBool bStartV850Download( );
	tVoid vAssignBlockID( );
	tBool bInitDnlFile( );
	tBool bStartDnlSequence( );
	tBool bStartDnlSequenceForSec();
	tVoid vWaitForBootloaderMode();
	tBool bStopV850Download( );
	tBool bStopV850Download1( );
    tBool bStopV850DownloadForSec( );
	tVoid vTerminateProgram( );
	tVoid vCloseBinaryFile( );
	tVoid vProcessClientEvent( tInt evFd );
	tBool bReadVersionInfo( tBool bReadAll, tU8 u8SwVer = 0 );
	tVoid vProcessDownloadCtrlEvent( tInt evFd );
	tVoid vProcessTimoutEvent( tInt evFd );
	tVoid vDisplayNegativeResponse( tU8 *pcMessage, tU32 u32MsgSize );
	tBool bV850DownloadProcess( tU8 *pcMessage, tU32 u32MsgSize );
	tS32 s32SocketCreation ( tU32 u32LocalPort ) const;	
	tBool bWriteToInc( tCString sCmdString );
	tBool bWriteDownloadReqToInc( tCString sCmdString, tU16 Typ );
	tVoid vWriteBinaryDataToInc( tU32 u32BytesToRead );
	tVoid error( tCString msg ) const;
	tVoid vMessageTermination() const;
	tVoid vBindToLocalHost( tU32 u32LocalPort ) const;
	tVoid vConnectToRemoteHost( tU32 u32LocalPort ) const;
	tBool bHandleNegativeResponse( tString pacRecvMsgBuffer );
	tVoid vDiagControlProcess( tString pacRecvMsgBuffer );
	tVoid vReadDataByIdentifierProcess( tString pacRecvMsgBuffer, tU32 u32MsgSize );
	tVoid vReadDataByIdentifierProcessExtended(tString pacRecvMsgBuffer, tU32 u32MsgSize);

	tVoid vHandleActiveSessionResponse(tString pacRecvMsgBuffer);
	tVoid vHandleActiveSessionResponseExtended(tString pacRecvMsgBuffer);


	/* Function to read SW Version Response */
	tVoid vHandleVersionResponse(tString pacRecvMsgBuffer, tU32 u32MsgSize);
	tVoid vHandleBMVersionResponse(tString pacRecvMsgBuffer, tU32 u32MsgSize);
	tVoid vHandleBLVersionResponse(tString pacRecvMsgBuffer, tU32 u32MsgSize);
	tVoid vHandleAppVersionResponse(tString pacRecvMsgBuffer, tU32 u32MsgSize);

	/* Function to read CRC Response */
	tVoid vHandleCrcResponse(tString pacRecvMsgBuffer);
	tVoid vHandleBMCrcResponse(tString pacRecvMsgBuffer);
	tVoid vHandleBLCrcResponse(tString pacRecvMsgBuffer);
	tVoid vHandleAppCrcResponse(tString pacRecvMsgBuffer);

	/* Function to read Security Response */
	tVoid vHandleSecurityResponse(tString pacRecvMsgBuffer);
	/* Function to handle JTAG response */
	tVoid vHandleJtagResponse();

	tVoid vWriteDataByIdentifierProcess( tString pacRecvMsgBuffer );
	tVoid vSecurityAccessProcess( tString pacRecvMsgBuffer );
	tVoid	vRoutineAndRequestProcess( tString pacRecvMsgBuffer );
	tVoid vBinaryDataTransfer( );
	tVoid vDelaySimulation() const;
	tVoid vConvertIntArrayToString(tString pcHexString, tString pacRecvMsgBuffer, tU32 u32SizeOfArray) const;
	tVoid vConvertIntArrayToHexString( tString pcHexString, tString pacRecvMsgBuffer, tU32 u32SizeOfArray) const;
	tVoid vSetTimeout( time_t sectimeout );
	tVoid vStartTimer( void );
	tVoid vStopTimer( void );
	tBool bCheckBinaryFile(std::string& CStrFolderPath, tCString CStrPattern) const;
	tBool bReadCrcValue(tString pacRecvMsgBuffer);
	tBool bIsFileDnlFormat( tCString sFilePath ) const;
	tVoid writeToRegistry( tCString cKeyName, tString cKeyValue );
	tVoid vGetMountPoint(tCString sDevice, std::string& sMountPoint);
    tVoid readFromRegistry( tCString cKeyName );
	tVoid vReadLabelFromRegistry( tCString cKeyName ); 
	tVoid vAppUpdate();
	tVoid vTransitReponse();
	tVoid vSendSecurityBytes();
	tVoid vSendJtagBytes();
	tBool bWriteSecuritySignToInc( tCString sCmdString, tU32 u32MemBlock);
	tBool bHandleSignRes( );
	tVoid vSendPacketError();

	//Start of CRQ CMG3G-9596
	tU8	  						m_u8SecurityBitVal;
	tChar* 						m_szJtagCRCValToCheck;
	E_JTAG_VALIDATION_RESULT	m_eJTAGValidationResult;
	tU8							m_u8ProcessingClientMsg;
	//End of CRQ CMG3G-9596
		
	tVoid vDoDesiredOperations(EN_EXTRA_OPERATIONS eDesOpera);
	tBool bDoScreenReInitOpera();

};
#endif // _DL_V850UPDATECTRLMANAGER_H_
